/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.render.svg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.values.Font;
import org.jetbrains.letsPlot.core.plot.base.render.svg.RichText;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTSpanElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTextElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u0013\u0014\u0015\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00042\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0004J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u0005H\u0002J$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\n2\u0006\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\nH\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0005\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/svg/RichText;", "", "()V", "enrichWidthCalculator", "Lkotlin/Function2;", "", "Lorg/jetbrains/letsPlot/commons/values/Font;", "", "widthCalculator", "extractTerms", "", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/RichText$Term;", "text", "subtractRange", "Lkotlin/ranges/IntRange;", "range", "toSubtract", "toSvg", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTextElement;", "PositionedTerm", "Power", "Term", "Text", "plot-base"})
@SourceDebugExtension(value={"SMAP\nRichText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RichText.kt\norg/jetbrains/letsPlot/core/plot/base/render/svg/RichText\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1360#2:129\n1446#2,5:130\n1855#2,2:135\n1549#2:137\n1620#2,3:138\n1549#2:141\n1620#2,3:142\n1045#2:145\n1549#2:146\n1620#2,3:147\n1045#2:150\n1549#2:151\n1620#2,3:152\n819#2:155\n847#2,2:156\n*S KotlinDebug\n*F\n+ 1 RichText.kt\norg/jetbrains/letsPlot/core/plot/base/render/svg/RichText\n*L\n17#1:129\n17#1:130,5\n18#1:135,2\n39#1:137\n39#1:138,3\n40#1:141\n40#1:142,3\n41#1:145\n41#1:146\n41#1:147,3\n46#1:150\n48#1:151\n48#1:152,3\n53#1:155\n53#1:156,2\n*E\n"})
public final class RichText {
    @NotNull
    public static final RichText INSTANCE = new RichText();

    private RichText() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SvgTextElement toSvg(@NotNull String text2) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        SvgTextElement richTextElement = new SvgTextElement();
        Iterable $this$flatMap$iv = this.extractTerms(text2);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Term p0 = (Term)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = p0.toTSpanElements();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SvgTSpanElement p0 = (SvgTSpanElement)element$iv;
            boolean bl = false;
            richTextElement.addTSpan(p0);
        }
        return richTextElement;
    }

    @NotNull
    public final Function2<String, Font, Double> enrichWidthCalculator(@NotNull Function2<? super String, ? super Font, Double> widthCalculator) {
        Intrinsics.checkNotNullParameter(widthCalculator, (String)"widthCalculator");
        return (Function2)new Function2<String, Font, Double>(widthCalculator){
            final /* synthetic */ Function2<String, Font, Double> $widthCalculator;
            {
                this.$widthCalculator = $widthCalculator;
                super(2, Intrinsics.Kotlin.class, "enrichedWidthCalculator", "enrichWidthCalculator$enrichedWidthCalculator(Lkotlin/jvm/functions/Function2;Ljava/lang/String;Lorg/jetbrains/letsPlot/commons/values/Font;)D", 0);
            }

            @NotNull
            public final Double invoke(@NotNull String p0, @NotNull Font p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return RichText.access$enrichWidthCalculator$enrichedWidthCalculator(this.$widthCalculator, p0, p1);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final List<Term> extractTerms(String text2) {
        List list2;
        List<PositionedTerm> powerTerms = Power.Companion.toPowerTerms(text2);
        if (powerTerms.isEmpty()) {
            list2 = CollectionsKt.listOf((Object)new Text(text2));
        } else {
            PositionedTerm position;
            IntRange it;
            Collection<IntRange> collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable iterable = powerTerms;
            IntRange intRange = new IntRange(0, text2.length() - 1);
            Object object = this;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                PositionedTerm positionedTerm = (PositionedTerm)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getRange());
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = ((RichText)object).subtractRange(intRange, (List<IntRange>)collection);
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (IntRange)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(new PositionedTerm(new Text(StringsKt.substring((String)text2, (IntRange)position)), (IntRange)position));
            }
            List textTerms = (List)destination$iv$iv;
            Iterable $this$sortedBy$iv = CollectionsKt.plus((Collection)powerTerms, (Iterable)textTerms);
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a2, T b2) {
                    PositionedTerm it = (PositionedTerm)a2;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getRange().getFirst());
                    it = (PositionedTerm)b2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getRange().getFirst()));
                }
            });
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                position = (PositionedTerm)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(p0.getTerm());
            }
            list2 = (List)destination$iv$iv;
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<IntRange> subtractRange(IntRange range, List<IntRange> toSubtract) {
        void $this$filterNotTo$iv$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$sortedBy$iv = toSubtract;
        boolean $i$f$sortedBy = false;
        List sortedToSubtract = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a2, T b2) {
                IntRange p0 = (IntRange)a2;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(p0.getFirst());
                p0 = (IntRange)b2;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(p0.getFirst()));
            }
        });
        IntRange firstRange = new IntRange(0, ((IntRange)CollectionsKt.first((List)sortedToSubtract)).getFirst() - 1);
        Iterable $this$map$iv = CollectionsKt.windowed$default((Iterable)sortedToSubtract, (int)2, (int)0, (boolean)false, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            List list2 = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IntRange prevRange = (IntRange)list2.get(0);
            IntRange nextRange = (IntRange)list2.get(1);
            collection.add(new IntRange(prevRange.getLast() + 1, nextRange.getFirst() - 1));
        }
        List intermediateRanges = (List)destination$iv$iv;
        IntRange lastRange = new IntRange(((IntRange)CollectionsKt.last((List)sortedToSubtract)).getLast() + 1, range.getLast());
        Iterable $this$filterNot$iv = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)firstRange), (Iterable)intermediateRanges), (Iterable)CollectionsKt.listOf((Object)lastRange));
        boolean $i$f$filterNot = false;
        destination$iv$iv = $this$filterNot$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            IntRange p0 = (IntRange)element$iv$iv;
            boolean bl = false;
            if (p0.isEmpty()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private static final double enrichWidthCalculator$enrichedWidthCalculator(Function2<? super String, ? super Font, Double> $widthCalculator, String text2, Font font) {
        Iterable iterable = INSTANCE.extractTerms(text2);
        double d = 0.0;
        for (Object t : iterable) {
            void term;
            Term term2 = (Term)t;
            double d2 = d;
            boolean bl = false;
            double d3 = term.calculateWidth($widthCalculator, font);
            d = d2 + d3;
        }
        return d;
    }

    public static final /* synthetic */ double access$enrichWidthCalculator$enrichedWidthCalculator(Function2 $widthCalculator, String text2, Font font) {
        return RichText.enrichWidthCalculator$enrichedWidthCalculator((Function2<? super String, ? super Font, Double>)$widthCalculator, text2, font);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/svg/RichText$PositionedTerm;", "", "term", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/RichText$Term;", "range", "Lkotlin/ranges/IntRange;", "(Lorg/jetbrains/letsPlot/core/plot/base/render/svg/RichText$Term;Lkotlin/ranges/IntRange;)V", "getRange", "()Lkotlin/ranges/IntRange;", "getTerm", "()Lorg/jetbrains/letsPlot/core/plot/base/render/svg/RichText$Term;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "plot-base"})
    private static final class PositionedTerm {
        @NotNull
        private final Term term;
        @NotNull
        private final IntRange range;

        public PositionedTerm(@NotNull Term term, @NotNull IntRange range) {
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            this.term = term;
            this.range = range;
        }

        @NotNull
        public final Term getTerm() {
            return this.term;
        }

        @NotNull
        public final IntRange getRange() {
            return this.range;
        }

        @NotNull
        public final Term component1() {
            return this.term;
        }

        @NotNull
        public final IntRange component2() {
            return this.range;
        }

        @NotNull
        public final PositionedTerm copy(@NotNull Term term, @NotNull IntRange range) {
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            return new PositionedTerm(term, range);
        }

        public static /* synthetic */ PositionedTerm copy$default(PositionedTerm positionedTerm, Term term, IntRange intRange, int n, Object object) {
            if ((n & 1) != 0) {
                term = positionedTerm.term;
            }
            if ((n & 2) != 0) {
                intRange = positionedTerm.range;
            }
            return positionedTerm.copy(term, intRange);
        }

        @NotNull
        public String toString() {
            return "PositionedTerm(term=" + this.term + ", range=" + this.range + ')';
        }

        public int hashCode() {
            int result2 = this.term.hashCode();
            result2 = result2 * 31 + this.range.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PositionedTerm)) {
                return false;
            }
            PositionedTerm positionedTerm = (PositionedTerm)other;
            if (!Intrinsics.areEqual((Object)this.term, (Object)positionedTerm.term)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.range, (Object)positionedTerm.range);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J*\u0010\u0006\u001a\u00020\u00072\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/svg/RichText$Power;", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/RichText$Term;", "base", "", "degree", "(Ljava/lang/String;Ljava/lang/String;)V", "calculateWidth", "", "widthCalculator", "Lkotlin/Function2;", "Lorg/jetbrains/letsPlot/commons/values/Font;", "font", "toTSpanElements", "", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTSpanElement;", "Companion", "plot-base"})
    private static final class Power
    implements Term {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String base;
        @NotNull
        private final String degree;
        @NotNull
        private static final String ZERO_WIDTH_SPACE_SYMBOL = "\u200b";
        @NotNull
        private static final String INDENT_SYMBOL = " ";
        private static final double INDENT_SIZE_FACTOR = 0.1;
        private static final double SUPERSCRIPT_SIZE_FACTOR = 0.7;
        private static final double SUPERSCRIPT_RELATIVE_SHIFT = 0.4;
        @NotNull
        private static final Regex REGEX = new Regex("\\\\\\(\\s*(?<base>\\d+)\\^(\\{\\s*)?(?<degree>-?\\d+)(\\s*\\})?\\s*\\\\\\)");

        public Power(@NotNull String base, @NotNull String degree) {
            Intrinsics.checkNotNullParameter((Object)base, (String)"base");
            Intrinsics.checkNotNullParameter((Object)degree, (String)"degree");
            this.base = base;
            this.degree = degree;
        }

        @Override
        @NotNull
        public List<SvgTSpanElement> toTSpanElements() {
            Object[] objectArray;
            SvgTSpanElement svgTSpanElement;
            SvgTSpanElement baseTSpan = new SvgTSpanElement(this.base);
            SvgTSpanElement $this$toTSpanElements_u24lambda_u240 = svgTSpanElement = new SvgTSpanElement(INDENT_SYMBOL);
            boolean bl = false;
            $this$toTSpanElements_u24lambda_u240.setAttribute(SvgTSpanElement.Companion.getFONT_SIZE(), "0.1em");
            SvgTSpanElement indentTSpan = svgTSpanElement;
            SvgTSpanElement $this$toTSpanElements_u24lambda_u241 = $this$toTSpanElements_u24lambda_u240 = new SvgTSpanElement(this.degree);
            boolean bl2 = false;
            $this$toTSpanElements_u24lambda_u241.setAttribute(SvgTSpanElement.Companion.getFONT_SIZE(), "0.7em");
            $this$toTSpanElements_u24lambda_u241.setAttribute(SvgTSpanElement.Companion.getDY(), "-0.4em");
            SvgTSpanElement degreeTSpan = $this$toTSpanElements_u24lambda_u240;
            Object[] $this$toTSpanElements_u24lambda_u242 = objectArray = new SvgTSpanElement(ZERO_WIDTH_SPACE_SYMBOL);
            boolean bl3 = false;
            $this$toTSpanElements_u24lambda_u242.setAttribute(SvgTSpanElement.Companion.getFONT_SIZE(), "0.7em");
            $this$toTSpanElements_u24lambda_u242.setAttribute(SvgTSpanElement.Companion.getDY(), "0.4em");
            Object[] restoreBaselineTSpan = objectArray;
            objectArray = new SvgTSpanElement[]{baseTSpan, indentTSpan, degreeTSpan, restoreBaselineTSpan};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @Override
        public double calculateWidth(@NotNull Function2<? super String, ? super Font, Double> widthCalculator, @NotNull Font font) {
            Intrinsics.checkNotNullParameter(widthCalculator, (String)"widthCalculator");
            Intrinsics.checkNotNullParameter((Object)font, (String)"font");
            double baseWidth = ((Number)widthCalculator.invoke((Object)this.base, (Object)font)).doubleValue();
            int degreeFontSize = MathKt.roundToInt((double)((double)font.getSize() * 0.7));
            Font superscriptFont = new Font(font.getFamily(), degreeFontSize, font.isBold(), font.isItalic());
            double degreeWidth = ((Number)widthCalculator.invoke((Object)this.degree, (Object)superscriptFont)).doubleValue();
            return baseWidth + degreeWidth;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/svg/RichText$Power$Companion;", "", "()V", "INDENT_SIZE_FACTOR", "", "INDENT_SYMBOL", "", "REGEX", "Lkotlin/text/Regex;", "getREGEX", "()Lkotlin/text/Regex;", "SUPERSCRIPT_RELATIVE_SHIFT", "SUPERSCRIPT_SIZE_FACTOR", "ZERO_WIDTH_SPACE_SYMBOL", "toPowerTerms", "", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/RichText$PositionedTerm;", "text", "plot-base"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Regex getREGEX() {
                return REGEX;
            }

            @NotNull
            public final List<PositionedTerm> toPowerTerms(@NotNull String text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)this.getREGEX(), (CharSequence)text2, (int)0, (int)2, null), (Function1)toPowerTerms.1.INSTANCE));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J*\u0010\u0002\u001a\u00020\u00032\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u00052\u0006\u0010\b\u001a\u00020\u0007H&J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH&\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/svg/RichText$Term;", "", "calculateWidth", "", "widthCalculator", "Lkotlin/Function2;", "", "Lorg/jetbrains/letsPlot/commons/values/Font;", "font", "toTSpanElements", "", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTSpanElement;", "plot-base"})
    private static interface Term {
        @NotNull
        public List<SvgTSpanElement> toTSpanElements();

        public double calculateWidth(@NotNull Function2<? super String, ? super Font, Double> var1, @NotNull Font var2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\n\u001a\u00020\tH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/svg/RichText$Text;", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/RichText$Term;", "text", "", "(Ljava/lang/String;)V", "calculateWidth", "", "widthCalculator", "Lkotlin/Function2;", "Lorg/jetbrains/letsPlot/commons/values/Font;", "font", "toTSpanElements", "", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTSpanElement;", "plot-base"})
    private static final class Text
    implements Term {
        @NotNull
        private final String text;

        public Text(@NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            this.text = text2;
        }

        @Override
        @NotNull
        public List<SvgTSpanElement> toTSpanElements() {
            return CollectionsKt.listOf((Object)new SvgTSpanElement(this.text));
        }

        @Override
        public double calculateWidth(@NotNull Function2<? super String, ? super Font, Double> widthCalculator, @NotNull Font font) {
            Intrinsics.checkNotNullParameter(widthCalculator, (String)"widthCalculator");
            Intrinsics.checkNotNullParameter((Object)font, (String)"font");
            return ((Number)widthCalculator.invoke((Object)this.text, (Object)font)).doubleValue();
        }
    }
}

