/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.ui.diagrams.model;

import com.google.common.graph.MutableNetwork;
import com.intellij.CommonBundle;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramDataView;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.extras.custom.CommonDiagramExtras;
import com.intellij.diagram.util.DiagramAlgorithmsService;
import com.intellij.diagram.util.DiagramSelectionService;
import com.intellij.ide.actions.SendFeedbackAction;
import com.intellij.microservices.mq.MQType;
import com.intellij.microservices.mq.NamedMQType;
import com.intellij.microservices.ui.MicroservicesUiBundle;
import com.intellij.microservices.ui.diagrams.MsDiagramCategoryManager;
import com.intellij.microservices.ui.diagrams.MsDiagramNotificationsKt;
import com.intellij.microservices.ui.diagrams.MsDiagramProvider;
import com.intellij.microservices.ui.diagrams.MsDiagramRelationship;
import com.intellij.microservices.ui.diagrams.model.MQVendor;
import com.intellij.microservices.ui.diagrams.model.MsDiagramElement;
import com.intellij.microservices.ui.diagrams.model.MsDiagramEndpoint;
import com.intellij.microservices.ui.diagrams.model.MsDiagramExternalEndpoint;
import com.intellij.microservices.ui.diagrams.model.MsDiagramMQDestination;
import com.intellij.microservices.ui.diagrams.model.MsDiagramMQDestinationsGroup;
import com.intellij.microservices.ui.diagrams.model.MsDiagramMQSeedElement;
import com.intellij.microservices.ui.diagrams.model.MsDiagramRequest;
import com.intellij.microservices.ui.diagrams.model.MsDiagramSeed;
import com.intellij.microservices.ui.diagrams.model.MsDiagramWebservice;
import com.intellij.microservices.ui.diagrams.model.MsDiagramWholeProjectSeed;
import com.intellij.microservices.ui.diagrams.model.RequestToWebservice;
import com.intellij.microservices.ui.diagrams.model.RequestsSearcher;
import com.intellij.microservices.ui.diagrams.model.searchers.RequestsToExternalEndpointsSearcher;
import com.intellij.microservices.ui.diagrams.model.searchers.RequestsToInternalEndpointsSearcher;
import com.intellij.microservices.ui.diagrams.model.searchers.RequestsToMQSearcher;
import com.intellij.microservices.ui.diagrams.presentation.MsDiagramEdge;
import com.intellij.microservices.ui.diagrams.presentation.MsDiagramNode;
import com.intellij.microservices.ui.diagrams.utils.GraphUtilsKt;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.graph.builder.NodeGroupDescriptor;
import com.intellij.openapi.graph.util.Futures;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00e0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\u0007\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002bcB!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001b\u001a\u00020\u0006H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0016\u0010 \u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00020\"0!H\u0016J\u0018\u0010#\u001a\u00020$2\u000e\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\"H\u0016J\u0016\u0010&\u001a\u00020\u001f2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00020\"H\u0016J\u0016\u0010'\u001a\u00020\u001f2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00020)H\u0016J\u0016\u0010*\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00020)0!H\u0016J \u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\u00132\u0006\u0010-\u001a\u00020\u00132\u0006\u0010.\u001a\u00020/H\u0002J\b\u00100\u001a\u00020\u001fH\u0002J\b\u00101\u001a\u00020\u001fH\u0002J\u0010\u00102\u001a\u00020\u001f2\u0006\u00103\u001a\u00020\u0010H\u0002J\u0010\u00104\u001a\u00020\u001f2\u0006\u00103\u001a\u00020\u0010H\u0002J\b\u00105\u001a\u00020\u001fH\u0002J\u001a\u00106\u001a\u00020\u001f2\u0010\u00107\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\"08H\u0002J\u0018\u00109\u001a\u0004\u0018\u00010:2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00020\"H\u0016J\b\u0010<\u001a\u00020\u001fH\u0016J\u001a\u0010=\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\"2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010>\u001a\u00020?2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010@\u001a\u00020\u001fH\u0016J\u0016\u0010A\u001a\b\u0012\u0004\u0012\u00020C0B2\u0006\u0010D\u001a\u00020\fH\u0016J\u0012\u0010E\u001a\u00020\u001f2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010J\u001a\u00020\u001fH\u0002J(\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00100L2\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020G2\b\u0010D\u001a\u0004\u0018\u00010\fH\u0002J2\u0010P\u001a\b\u0012\u0004\u0012\u0002HQ0L\"\u0004\b\u0000\u0010Q2\b\b\u0001\u0010R\u001a\u00020$2\u0012\u0010S\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u0002HQ0TH\u0002J\"\u0010U\u001a\u00020\u00102\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020G2\b\u0010D\u001a\u0004\u0018\u00010\fH\u0002J:\u0010V\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020X0W0L2$\u0010Y\u001a \u0012\u0004\u0012\u00020[\u0012\u0004\u0012\u00020\\\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020X0]0ZH\u0002J!\u0010^\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020X0W0L2\u0006\u0010(\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b_J!\u0010`\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020X0W0L2\u0006\u0010%\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\baR\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010F\u001a\u00020G8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010I\u00a8\u0006d"}, d2={"Lcom/intellij/microservices/ui/diagrams/model/MsDiagramDataModel;", "Lcom/intellij/diagram/DiagramDataModel;", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramElement;", "myProject", "Lcom/intellij/openapi/project/Project;", "provider", "Lcom/intellij/microservices/ui/diagrams/MsDiagramProvider;", "element", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/microservices/ui/diagrams/MsDiagramProvider;Lcom/intellij/microservices/ui/diagrams/model/MsDiagramElement;)V", "myLastStartedProgress", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/openapi/progress/ProgressIndicator;", "myDelayedRefreshScheduled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "myModelData", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramDataModel$MyModelData;", "myMQDestinationsNodes", "", "Lcom/intellij/microservices/ui/diagrams/presentation/MsDiagramNode;", "myMQDestinationsGroups", "", "Lcom/intellij/microservices/ui/diagrams/model/MQVendor;", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramMQDestinationsGroup;", "myWebservicesNodes", "myEdges", "Lcom/intellij/microservices/ui/diagrams/presentation/MsDiagramEdge;", "getProvider", "getModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "updatePresentation", "", "getNodes", "", "Lcom/intellij/diagram/DiagramNode;", "getNodeName", "", "node", "removeNode", "removeEdge", "edge", "Lcom/intellij/diagram/DiagramEdge;", "getEdges", "createDiagramEdge", "source", "target", "relationship", "Lcom/intellij/microservices/ui/diagrams/MsDiagramRelationship;", "clearAllNodesAndEdges", "updateNodesAndEdges", "setNodesAndEdgesFrom", "modelData", "showNotificationIfNoDataFound", "adjustNodesAndEdgesAccordingToCommonCategories", "removeAllExceptPathsFromRootToNodes", "targets", "", "getGroup", "Lcom/intellij/openapi/graph/builder/NodeGroupDescriptor;", "n", "dispose", "addElement", "hasElement", "", "refreshDataModel", "refreshDataModelAsync", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "indicator", "rebuild", "currentViewSettings", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramDataModel$MyModelSettings;", "getCurrentViewSettings", "()Lcom/intellij/microservices/ui/diagrams/model/MsDiagramDataModel$MyModelSettings;", "scheduleModelComputation", "buildModelAsync", "Lorg/jetbrains/concurrency/Promise;", "seed", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramSeed;", "viewSettings", "scheduleMutexTask", "R", "title", "callable", "Lkotlin/Function1;", "doBuildModel", "scheduleRequestsSearch", "", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramRequest;", "finder", "Lkotlin/Function3;", "Lcom/intellij/microservices/ui/diagrams/model/RequestsSearcher;", "Lcom/intellij/microservices/ui/diagrams/model/RequestsSearcher$SearchParams;", "", "scheduleEdgeRequestsSearch", "scheduleEdgeRequestsSearch$intellij_microservices_ui", "scheduleNodeRequestsSearch", "scheduleNodeRequestsSearch$intellij_microservices_ui", "MyModelSettings", "MyModelData", "intellij.microservices.ui"})
@SourceDebugExtension(value={"SMAP\nMsDiagramDataModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MsDiagramDataModel.kt\ncom/intellij/microservices/ui/diagrams/model/MsDiagramDataModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Grouping.kt\nkotlin/collections/GroupingKt__GroupingKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 7 Futures.kt\ncom/intellij/openapi/graph/util/Futures\n*L\n1#1,382:1\n1216#2,2:383\n1246#2,4:385\n1544#2:389\n1454#2,5:398\n1755#2,3:414\n1755#2,3:417\n1454#2,5:427\n774#2:432\n865#2,2:433\n1368#2:435\n1454#2,5:436\n1368#2:441\n1454#2,5:442\n112#3:390\n53#3:391\n80#3,4:392\n85#3:397\n1#4:396\n37#5,2:403\n37#5,2:405\n381#6,7:407\n100#7,7:420\n*S KotlinDebug\n*F\n+ 1 MsDiagramDataModel.kt\ncom/intellij/microservices/ui/diagrams/model/MsDiagramDataModel\n*L\n140#1:383,2\n140#1:385,4\n155#1:389\n198#1:398,5\n240#1:414,3\n241#1:417,3\n338#1:427,5\n371#1:432\n371#1:433,2\n360#1:435\n360#1:436,5\n373#1:441\n373#1:442,5\n156#1:390\n156#1:391\n156#1:392,4\n156#1:397\n202#1:403,2\n205#1:405,2\n218#1:407,7\n285#1:420,7\n*E\n"})
public final class MsDiagramDataModel
extends DiagramDataModel<MsDiagramElement> {
    @NotNull
    private final AtomicReference<ProgressIndicator> myLastStartedProgress;
    @NotNull
    private final AtomicBoolean myDelayedRefreshScheduled;
    @NotNull
    private final AtomicReference<MyModelData> myModelData;
    @NotNull
    private final Set<MsDiagramNode> myMQDestinationsNodes;
    @NotNull
    private final Map<MQVendor, MsDiagramMQDestinationsGroup> myMQDestinationsGroups;
    @NotNull
    private final Set<MsDiagramNode> myWebservicesNodes;
    @NotNull
    private final Set<MsDiagramEdge> myEdges;

    public MsDiagramDataModel(@NotNull Project myProject, @NotNull MsDiagramProvider provider, @Nullable MsDiagramElement element) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)((Object)provider), (String)"provider");
        super(myProject, (DiagramProvider)provider);
        this.myLastStartedProgress = new AtomicReference();
        this.myDelayedRefreshScheduled = new AtomicBoolean();
        this.myModelData = new AtomicReference();
        this.myMQDestinationsNodes = new LinkedHashSet();
        this.myMQDestinationsGroups = new LinkedHashMap();
        this.myWebservicesNodes = new LinkedHashSet();
        this.myEdges = new LinkedHashSet();
        this.setOriginalElement(element);
    }

    @NotNull
    public MsDiagramProvider getProvider() {
        DiagramProvider diagramProvider = super.getProvider();
        Intrinsics.checkNotNull((Object)diagramProvider, (String)"null cannot be cast to non-null type com.intellij.microservices.ui.diagrams.MsDiagramProvider");
        return (MsDiagramProvider)diagramProvider;
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myModificationTracker;
        Intrinsics.checkNotNullExpressionValue((Object)simpleModificationTracker, (String)"myModificationTracker");
        return (ModificationTracker)simpleModificationTracker;
    }

    private final void updatePresentation() {
        if (!this.getProject().isDisposed()) {
            this.getBuilder().queryUpdate().withDataReload().withPresentationUpdate().withRelayout().run();
        }
    }

    @NotNull
    public Collection<? extends DiagramNode<MsDiagramElement>> getNodes() {
        Set set;
        Set $this$getNodes_u24lambda_u240 = set = (Set)new LinkedHashSet();
        boolean bl = false;
        $this$getNodes_u24lambda_u240.addAll((Collection)this.myMQDestinationsNodes);
        $this$getNodes_u24lambda_u240.addAll((Collection)this.myWebservicesNodes);
        return set;
    }

    @NotNull
    public String getNodeName(@NotNull DiagramNode<MsDiagramElement> node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        String string = node.getTooltip();
        if (string == null) {
            String string2 = CommonBundle.getErrorTitle();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getErrorTitle(...)");
        }
        return string;
    }

    public void removeNode(@NotNull DiagramNode<MsDiagramElement> node) {
        block1: {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            TypeIntrinsics.asMutableCollection((Object)this.myMQDestinationsNodes).remove(node);
            TypeIntrinsics.asMutableCollection((Object)this.myWebservicesNodes).remove(node);
            MutableNetwork<MsDiagramEndpoint, MsDiagramRequest> mutableNetwork = this.myModelData.get();
            if (mutableNetwork == null || (mutableNetwork = mutableNetwork.getRequestsGraph()) == null) break block1;
            Object object = node.getIdentifyingElement();
            MsDiagramEndpoint msDiagramEndpoint = object instanceof MsDiagramEndpoint ? (MsDiagramEndpoint)object : null;
            if (msDiagramEndpoint == null) {
                return;
            }
            mutableNetwork.removeNode((Object)msDiagramEndpoint);
        }
    }

    public void removeEdge(@NotNull DiagramEdge<MsDiagramElement> edge) {
        block1: {
            Intrinsics.checkNotNullParameter(edge, (String)"edge");
            MyModelData myModelData = this.myModelData.get();
            if (myModelData == null) break block1;
            MyModelData data = myModelData;
            boolean bl = false;
            for (MsDiagramRequest it : ((MsDiagramEdge)edge).getRequests()) {
                data.getRequestsGraph().removeEdge((Object)it);
            }
        }
    }

    @NotNull
    public Collection<? extends DiagramEdge<MsDiagramElement>> getEdges() {
        return this.myEdges;
    }

    private final MsDiagramEdge createDiagramEdge(MsDiagramNode source, MsDiagramNode target, MsDiagramRelationship relationship) {
        DiagramBuilder diagramBuilder = this.getBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)diagramBuilder, (String)"getBuilder(...)");
        return new MsDiagramEdge(source, target, relationship, diagramBuilder);
    }

    private final void clearAllNodesAndEdges() {
        this.myMQDestinationsNodes.clear();
        this.myMQDestinationsGroups.clear();
        this.myWebservicesNodes.clear();
        this.myEdges.clear();
    }

    private final void updateNodesAndEdges() {
        this.clearAllNodesAndEdges();
        MyModelData myModelData = this.myModelData.get();
        Intrinsics.checkNotNull((Object)myModelData);
        this.setNodesAndEdgesFrom(myModelData);
        this.adjustNodesAndEdgesAccordingToCommonCategories();
    }

    /*
     * WARNING - void declaration
     */
    private final void setNodesAndEdgesFrom(MyModelData modelData) {
        Map map;
        void $this$associateByTo$iv$iv;
        MutableNetwork<MsDiagramEndpoint, MsDiagramRequest> requestsGraph = modelData.getRequestsGraph();
        Set set = requestsGraph.nodes();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"nodes(...)");
        Iterable $this$associateBy$iv = set;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterator iterator = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            MsDiagramEndpoint msDiagramEndpoint = (MsDiagramEndpoint)element$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            MsDiagramEndpoint it = (MsDiagramEndpoint)element$iv$iv;
            void var37_14 = it;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            MsDiagramNode msDiagramNode = new MsDiagramNode(it, this.getProvider());
            map.put(var37_14, msDiagramNode);
        }
        Map elementToNode = destination$iv$iv;
        for (MsDiagramEndpoint source : requestsGraph.nodes()) {
            Object v = elementToNode.get(source);
            Intrinsics.checkNotNull(v);
            MsDiagramNode sourceNode = (MsDiagramNode)((Object)v);
            iterator = source;
            if (iterator instanceof MsDiagramWebservice || iterator instanceof MsDiagramExternalEndpoint) {
                v2 = this.myWebservicesNodes.add(sourceNode);
            } else if (iterator instanceof MsDiagramMQDestination) {
                v2 = this.myMQDestinationsNodes.add(sourceNode);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            for (MsDiagramEndpoint target : requestsGraph.successors((Object)source)) {
                void destination$iv$iv$iv;
                void $this$aggregateTo$iv$iv$iv;
                void $this$fold$iv;
                Grouping $this$groupingBy$iv;
                Object v2 = elementToNode.get(target);
                Intrinsics.checkNotNull(v2);
                MsDiagramNode targetNode = (MsDiagramNode)((Object)v2);
                Set set2 = requestsGraph.edgesConnecting((Object)source, (Object)target);
                Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"edgesConnecting(...)");
                Iterable iterable = set2;
                boolean $i$f$groupingBy = false;
                $this$groupingBy$iv = (Grouping)new Grouping<MsDiagramRequest, MsDiagramRelationship>((Iterable)$this$groupingBy$iv){
                    final /* synthetic */ Iterable $this_groupingBy;
                    {
                        this.$this_groupingBy = $receiver;
                    }

                    public Iterator<MsDiagramRequest> sourceIterator() {
                        return this.$this_groupingBy.iterator();
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public Object keyOf(Object element) {
                        MsDiagramRequest it = (MsDiagramRequest)element;
                        boolean bl = false;
                        return it.toRelationship();
                    }
                };
                boolean $i$f$fold = false;
                void $this$aggregate$iv$iv = $this$fold$iv;
                boolean $i$f$aggregate = false;
                void var14_24 = $this$aggregate$iv$iv;
                Map map2 = new LinkedHashMap();
                boolean $i$f$aggregateTo = false;
                Iterator iterator2 = $this$aggregateTo$iv$iv$iv.sourceIterator();
                while (iterator2.hasNext()) {
                    void request2;
                    void edge;
                    void var32_43;
                    MsDiagramEdge msDiagramEdge;
                    void e$iv;
                    void first$iv;
                    void key$iv;
                    Object e$iv$iv$iv = iterator2.next();
                    Object key$iv$iv$iv = $this$aggregateTo$iv$iv$iv.keyOf(e$iv$iv$iv);
                    Object accumulator$iv$iv$iv = destination$iv$iv$iv.get(key$iv$iv$iv);
                    boolean bl = accumulator$iv$iv$iv == null && !destination$iv$iv$iv.containsKey(key$iv$iv$iv);
                    Object e = e$iv$iv$iv;
                    Object v3 = accumulator$iv$iv$iv;
                    Object object = key$iv$iv$iv;
                    Object object2 = key$iv$iv$iv;
                    void var26_36 = destination$iv$iv$iv;
                    boolean bl3 = false;
                    Map map3 = key$iv;
                    if (first$iv != false) {
                        void relationship;
                        MsDiagramRequest cfr_ignored_0 = (MsDiagramRequest)e$iv;
                        MsDiagramRelationship msDiagramRelationship = (MsDiagramRelationship)key$iv;
                        map = map3;
                        boolean bl4 = false;
                        msDiagramEdge = this.createDiagramEdge(sourceNode, targetNode, (MsDiagramRelationship)relationship);
                        map3 = map;
                    } else {
                        void acc$iv;
                        msDiagramEdge = acc$iv;
                    }
                    MsDiagramRequest bl4 = (MsDiagramRequest)e$iv;
                    MsDiagramEdge msDiagramEdge2 = msDiagramEdge;
                    MsDiagramRelationship cfr_ignored_1 = (MsDiagramRelationship)((Object)map3);
                    boolean bl5 = false;
                    void it = var32_43 = edge;
                    boolean bl6 = false;
                    List<MsDiagramRequest> list = it.getRequests();
                    Intrinsics.checkNotNull((Object)request2);
                    list.add((MsDiagramRequest)request2);
                    void var35_46 = var32_43;
                    var26_36.put(object2, var35_46);
                }
                void it = destination$iv$iv$iv;
                boolean bl = false;
                this.myEdges.addAll(it.values());
            }
        }
    }

    private final void showNotificationIfNoDataFound(MyModelData modelData) {
        if (modelData.getRequestsGraph().nodes().isEmpty()) {
            Notification noDataFoundNotification = MsDiagramNotificationsKt.getGeneralGroup().createNotification(MicroservicesUiBundle.message("microservices.diagrams.webservices.presentable.name.sentence", new Object[0]), MicroservicesUiBundle.message("microservices.diagrams.webservices.no.data.found.notification", new Object[0]), NotificationType.WARNING);
            String string = MicroservicesUiBundle.message("microservices.diagrams.webservices.no.data.found.notification.submit.feedback.action", new Object[0]);
            noDataFoundNotification.addAction((AnAction)new NotificationAction(this, string){
                final /* synthetic */ MsDiagramDataModel this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                public void actionPerformed(AnActionEvent e, Notification notification) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                    SendFeedbackAction.Companion.submit(this.this$0.getProject());
                    notification.expire();
                }
            });
            Notifications.Bus.notify((Notification)noDataFoundNotification, (Project)this.getProject());
        }
    }

    private final void adjustNodesAndEdgesAccordingToCommonCategories() {
        if (this.getNodeContentManager().isCategoryEnabled(CommonDiagramExtras.PATH_TO_ROOT)) {
            DiagramSelectionService diagramSelectionService = DiagramSelectionService.getInstance();
            DiagramBuilder diagramBuilder = this.getBuilder();
            Intrinsics.checkNotNull((Object)diagramBuilder);
            List list = diagramSelectionService.getSelectedNodes(diagramBuilder);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSelectedNodes(...)");
            List nodes = list;
            if (nodes.size() > 0) {
                this.removeAllExceptPathsFromRootToNodes(nodes);
            }
        }
        if (CommonDiagramExtras.isSelectionMode((DiagramBuilder)this.getBuilder())) {
            DiagramAlgorithmsService.getInstance().removeNonSelectedDependencies((DiagramDataModel)this);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void removeAllExceptPathsFromRootToNodes(Collection<? extends DiagramNode<?>> targets) {
        void $this$flatMapTo$iv;
        Iterable iterable = this.myMQDestinationsNodes;
        Collection objectArray = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object t : $this$flatMapTo$iv) {
            MsDiagramNode it = (MsDiagramNode)((Object)t);
            boolean bl = false;
            Set set = DiagramAlgorithmsService.getInstance().getPathsFromRoot((DiagramNode)it, targets, (DiagramDataView)this, DiagramAlgorithmsService.PathDirection.DIRECTED_BOTH);
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getPathsFromRoot(...)");
            Iterable list$iv = set;
            CollectionsKt.addAll((Collection)objectArray, (Iterable)list$iv);
        }
        Set pathEdges = (Set)objectArray;
        Set set = DiagramAlgorithmsService.getInstance().collectNodes((Collection)pathEdges);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"collectNodes(...)");
        Set pathNodes = set;
        Collection $this$toTypedArray$iv = this.myWebservicesNodes;
        int $i$f$toTypedArray = 0;
        Collection collection = $this$toTypedArray$iv;
        for (MsDiagramNode msDiagramNode : collection.toArray(new MsDiagramNode[0])) {
            if (pathNodes.contains((Object)msDiagramNode)) continue;
            this.myWebservicesNodes.remove((Object)msDiagramNode);
        }
        $this$toTypedArray$iv = this.myEdges;
        $i$f$toTypedArray = 0;
        Collection collection2 = $this$toTypedArray$iv;
        for (MsDiagramEdge msDiagramEdge : collection2.toArray(new MsDiagramEdge[0])) {
            if (pathEdges.contains((Object)msDiagramEdge)) continue;
            this.myEdges.remove((Object)msDiagramEdge);
        }
    }

    @Nullable
    public NodeGroupDescriptor getGroup(@NotNull DiagramNode<MsDiagramElement> n) {
        NodeGroupDescriptor nodeGroupDescriptor;
        Intrinsics.checkNotNullParameter(n, (String)"n");
        Object object = n.getIdentifyingElement();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getIdentifyingElement(...)");
        MsDiagramElement element = (MsDiagramElement)object;
        if (element instanceof MsDiagramMQDestination) {
            MsDiagramMQDestinationsGroup msDiagramMQDestinationsGroup;
            MQType mqType = ((MsDiagramMQDestination)element).getDestination().getType();
            Object object2 = mqType instanceof NamedMQType ? (NamedMQType)mqType : null;
            if (object2 == null || (object2 = object2.getName()) == null) {
                object2 = MicroservicesUiBundle.message("microservices.diagrams.mq.unknown.message.queue", new Object[0]);
            }
            MQVendor vendor = new MQVendor((String)object2, mqType.getIcon());
            Map<MQVendor, MsDiagramMQDestinationsGroup> $this$getOrPut$iv = this.myMQDestinationsGroups;
            boolean $i$f$getOrPut = false;
            MsDiagramMQDestinationsGroup value$iv = $this$getOrPut$iv.get(vendor);
            if (value$iv == null) {
                boolean bl = false;
                DiagramBuilder diagramBuilder = this.getBuilder();
                Intrinsics.checkNotNullExpressionValue((Object)diagramBuilder, (String)"getBuilder(...)");
                MsDiagramMQDestinationsGroup answer$iv = new MsDiagramMQDestinationsGroup(vendor, diagramBuilder);
                $this$getOrPut$iv.put(vendor, answer$iv);
                msDiagramMQDestinationsGroup = answer$iv;
            } else {
                msDiagramMQDestinationsGroup = value$iv;
            }
            nodeGroupDescriptor = (NodeGroupDescriptor)msDiagramMQDestinationsGroup;
        } else if (element instanceof MsDiagramWebservice || element instanceof MsDiagramExternalEndpoint || element instanceof MsDiagramWholeProjectSeed || element instanceof MsDiagramMQSeedElement) {
            nodeGroupDescriptor = super.getGroup(n);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return nodeGroupDescriptor;
    }

    public void dispose() {
    }

    @Nullable
    public DiagramNode<MsDiagramElement> addElement(@Nullable MsDiagramElement element) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasElement(@Nullable MsDiagramElement element) {
        MsDiagramNode it;
        boolean bl;
        Iterable $this$any$iv = this.myWebservicesNodes;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                it = (MsDiagramNode)((Object)element$iv);
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getIdentifyingElement(), (Object)element)) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        $this$any$iv = this.myMQDestinationsNodes;
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator.hasNext()) return false;
            element$iv = iterator.next();
            it = (MsDiagramNode)((Object)element$iv);
            boolean bl3 = false;
        } while (!Intrinsics.areEqual((Object)it.getIdentifyingElement(), (Object)element));
        return true;
    }

    public void refreshDataModel() {
        this.rebuild((MsDiagramElement)this.getOriginalElement());
    }

    @NotNull
    public CompletableFuture<Void> refreshDataModelAsync(@NotNull ProgressIndicator indicator) {
        CompletionStage<Object> completionStage;
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        MsDiagramElement element = (MsDiagramElement)this.getOriginalElement();
        if (element instanceof MsDiagramWholeProjectSeed || element instanceof MsDiagramMQSeedElement) {
            Promise promise = this.buildModelAsync((MsDiagramSeed)((Object)element), this.getCurrentViewSettings(), indicator).onSuccess(arg_0 -> MsDiagramDataModel.refreshDataModelAsync$lambda$15(arg_0 -> MsDiagramDataModel.refreshDataModelAsync$lambda$14(this, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"onSuccess(...)");
            CompletionStage completionStage2 = Promises.asCompletableFuture((Promise)promise).thenRun(MsDiagramDataModel::refreshDataModelAsync$lambda$16);
            Intrinsics.checkNotNullExpressionValue((Object)completionStage2, (String)"thenRun(...)");
            completionStage = completionStage2;
        } else {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            completionStage = completableFuture;
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        }
        return completionStage;
    }

    public void rebuild(@Nullable MsDiagramElement element) {
        if (element == null) {
            return;
        }
        MyModelData myModelData = this.myModelData.get();
        if (!Intrinsics.areEqual((Object)(myModelData != null ? myModelData.getViewSettings() : null), (Object)this.getCurrentViewSettings())) {
            this.scheduleModelComputation();
        } else {
            this.updateNodesAndEdges();
        }
    }

    private final MyModelSettings getCurrentViewSettings() {
        return new MyModelSettings(this.getNodeContentManager().isCategoryEnabled(MsDiagramCategoryManager.Companion.getFROM_TESTS()), this.getNodeContentManager().isCategoryEnabled(MsDiagramCategoryManager.Companion.getFROM_LIBRARIES()));
    }

    private final void scheduleModelComputation() {
        if (this.myDelayedRefreshScheduled.compareAndSet(false, true)) {
            Class<MsDiagramDataModel> loggingClass$iv = MsDiagramDataModel.class;
            boolean $i$f$logIfFailed = false;
            ((CompletableFuture)((CompletableFuture)this.refreshDataModelAsync((ProgressIndicator)new EmptyProgressIndicator()).thenRunAsync(() -> MsDiagramDataModel.scheduleModelComputation$lambda$18(this))).whenComplete((arg_0, arg_1) -> MsDiagramDataModel.scheduleModelComputation$lambda$20((arg_0, arg_1) -> MsDiagramDataModel.scheduleModelComputation$lambda$19(this, arg_0, arg_1), arg_0, arg_1))).whenComplete(new BiConsumer(loggingClass$iv){
                final /* synthetic */ Class $loggingClass;
                {
                    this.$loggingClass = $loggingClass;
                }

                public final void accept(Object object, Throwable cause) {
                    if (cause != null && !Futures.isCancellation((Throwable)cause)) {
                        Throwable throwable = cause;
                        Logger logger = Logger.getInstance((Class)this.$loggingClass);
                        boolean bl = false;
                        logger.error(throwable);
                    }
                }
            });
        }
    }

    private final Promise<MyModelData> buildModelAsync(MsDiagramSeed seed, MyModelSettings viewSettings, ProgressIndicator indicator) {
        return this.scheduleMutexTask(MicroservicesUiBundle.message("microservices.diagrams.webservices.async.building.background.task.name", new Object[0]), arg_0 -> MsDiagramDataModel.buildModelAsync$lambda$21(this, seed, viewSettings, arg_0));
    }

    private final <R> Promise<R> scheduleMutexTask(@Nls String title, Function1<? super ProgressIndicator, ? extends R> callable) {
        AsyncPromise result = new AsyncPromise();
        Project project = this.getProject();
        PerformInBackgroundOption performInBackgroundOption = Task.Backgroundable.ALWAYS_BACKGROUND;
        Task.Backgroundable task2 = new Task.Backgroundable(title, this, result, callable, project, performInBackgroundOption){
            final /* synthetic */ MsDiagramDataModel this$0;
            final /* synthetic */ AsyncPromise<R> $result;
            final /* synthetic */ Function1<ProgressIndicator, R> $callable;
            {
                this.this$0 = $receiver;
                this.$result = $result;
                this.$callable = $callable;
                super($super_call_param$1, $title, true, $super_call_param$2);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                if (!MsDiagramDataModel.access$getMyLastStartedProgress$p(this.this$0).compareAndSet(null, indicator)) {
                    return;
                }
                try {
                    this.$result.setResult(this.$callable.invoke((Object)indicator));
                }
                catch (ProcessCanceledException ce) {
                    this.$result.setError((Throwable)ce);
                }
                catch (Exception e) {
                    this.$result.setError((Throwable)e);
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(MsDiagramDataModel.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error((Throwable)e);
                }
                finally {
                    MsDiagramDataModel.access$getMyLastStartedProgress$p(this.this$0).compareAndSet(indicator, null);
                }
            }
        };
        task2.queue();
        return (Promise)result;
    }

    /*
     * WARNING - void declaration
     */
    private final MyModelData doBuildModel(MsDiagramSeed seed, MyModelSettings viewSettings, ProgressIndicator indicator) {
        void destination$iv;
        void $this$flatMapTo$iv;
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.setIndeterminate(true);
        }
        RequestsSearcher.SearchParams searchParams = new RequestsSearcher.SearchParams(viewSettings.getDoSearchFromTests(), viewSettings.getDoSearchFromLibraries());
        MutableNetwork requestsGraph = GraphUtilsKt.mutableNetworkOf();
        GraphUtilsKt.plusAssign(requestsGraph, new RequestsToMQSearcher().search(seed, searchParams, indicator));
        GraphUtilsKt.plusAssign(requestsGraph, new RequestsToInternalEndpointsSearcher().search(seed, searchParams, indicator));
        Set set = requestsGraph.edges();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"edges(...)");
        Iterable iterable = set;
        Collection collection = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            MsDiagramRequest it = (MsDiagramRequest)element$iv;
            boolean bl = false;
            Object object = it instanceof RequestToWebservice ? (RequestToWebservice)it : null;
            if (object == null || (object = ((RequestToWebservice)object).getPathReference()) == null || (object = object.getContext()) == null || (object = object.getAuthorities()) == null) {
                object = CollectionsKt.emptyList();
            }
            Iterable list$iv = (Iterable)object;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        Set internalAuthorities = (Set)destination$iv;
        GraphUtilsKt.plusAssign(requestsGraph, new RequestsToExternalEndpointsSearcher(internalAuthorities).search(seed, searchParams, indicator));
        return new MyModelData(viewSettings, requestsGraph);
    }

    private final Promise<List<MsDiagramRequest>> scheduleRequestsSearch(Function3<? super RequestsSearcher, ? super RequestsSearcher.SearchParams, ? super ProgressIndicator, ? extends Iterable<? extends MsDiagramRequest>> finder) {
        return this.scheduleMutexTask(MicroservicesUiBundle.message("microservices.diagrams.webservices.async.building.background.task.name", new Object[0]), arg_0 -> MsDiagramDataModel.scheduleRequestsSearch$lambda$24(this, finder, arg_0));
    }

    @NotNull
    public final Promise<List<MsDiagramRequest>> scheduleEdgeRequestsSearch$intellij_microservices_ui(@NotNull MsDiagramEdge edge) {
        Intrinsics.checkNotNullParameter((Object)((Object)edge), (String)"edge");
        return this.scheduleRequestsSearch((Function3<? super RequestsSearcher, ? super RequestsSearcher.SearchParams, ? super ProgressIndicator, ? extends Iterable<? extends MsDiagramRequest>>)((Function3)(arg_0, arg_1, arg_2) -> MsDiagramDataModel.scheduleEdgeRequestsSearch$lambda$25(edge, arg_0, arg_1, arg_2)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Promise<List<MsDiagramRequest>> scheduleNodeRequestsSearch$intellij_microservices_ui(@NotNull MsDiagramNode node) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)node), (String)"node");
        Iterable $this$filter$iv = this.myEdges;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MsDiagramEdge it = (MsDiagramEdge)((Object)element$iv$iv);
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)((Object)it.getSource()), (Object)((Object)node)) || Intrinsics.areEqual((Object)((Object)it.getTarget()), (Object)((Object)node)))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List edges = (List)destination$iv$iv;
        return this.scheduleRequestsSearch((Function3<? super RequestsSearcher, ? super RequestsSearcher.SearchParams, ? super ProgressIndicator, ? extends Iterable<? extends MsDiagramRequest>>)((Function3)(arg_0, arg_1, arg_2) -> MsDiagramDataModel.scheduleNodeRequestsSearch$lambda$28(edges, arg_0, arg_1, arg_2)));
    }

    private static final void refreshDataModelAsync$lambda$14$lambda$13(MsDiagramDataModel this$0) {
        this$0.updateNodesAndEdges();
    }

    private static final Unit refreshDataModelAsync$lambda$14(MsDiagramDataModel this$0, MyModelData it) {
        this$0.myModelData.set(it);
        Intrinsics.checkNotNull((Object)it);
        this$0.showNotificationIfNoDataFound(it);
        ApplicationManager.getApplication().invokeLater(() -> MsDiagramDataModel.refreshDataModelAsync$lambda$14$lambda$13(this$0));
        return Unit.INSTANCE;
    }

    private static final void refreshDataModelAsync$lambda$15(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void refreshDataModelAsync$lambda$16() {
    }

    private static final void scheduleModelComputation$lambda$18$lambda$17(MsDiagramDataModel this$0) {
        this$0.updatePresentation();
    }

    private static final void scheduleModelComputation$lambda$18(MsDiagramDataModel this$0) {
        Project project = this$0.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        DumbService.Companion.getInstance(project).smartInvokeLater(() -> MsDiagramDataModel.scheduleModelComputation$lambda$18$lambda$17(this$0));
    }

    private static final Unit scheduleModelComputation$lambda$19(MsDiagramDataModel this$0, Void void_, Throwable throwable) {
        this$0.myDelayedRefreshScheduled.set(false);
        return Unit.INSTANCE;
    }

    private static final void scheduleModelComputation$lambda$20(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final MyModelData buildModelAsync$lambda$21(MsDiagramDataModel this$0, MsDiagramSeed $seed, MyModelSettings $viewSettings, ProgressIndicator taskIndicator) {
        Intrinsics.checkNotNullParameter((Object)taskIndicator, (String)"taskIndicator");
        return this$0.doBuildModel($seed, $viewSettings, taskIndicator);
    }

    /*
     * WARNING - void declaration
     */
    private static final List scheduleRequestsSearch$lambda$24(MsDiagramDataModel this$0, Function3 $finder, ProgressIndicator indicator) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        MyModelSettings viewSettings = this$0.getCurrentViewSettings();
        RequestsSearcher.SearchParams searchParams = new RequestsSearcher.SearchParams(viewSettings.getDoSearchFromTests(), viewSettings.getDoSearchFromLibraries());
        Object object = new RequestsSearcher[]{new RequestsToMQSearcher(), new RequestsToInternalEndpointsSearcher(), new RequestsToExternalEndpointsSearcher(SetsKt.emptySet())};
        object = CollectionsKt.listOf((Object[])object);
        boolean $i$f$flatMap = false;
        void var7_7 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            RequestsSearcher it = (RequestsSearcher)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = (Iterable)$finder.invoke((Object)it, (Object)searchParams, (Object)indicator);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Iterable scheduleEdgeRequestsSearch$lambda$25(MsDiagramEdge $edge, RequestsSearcher searcher, RequestsSearcher.SearchParams searchParams, ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
        Intrinsics.checkNotNullParameter((Object)searchParams, (String)"searchParams");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        return searcher.searchForRequestsFormingAnEdge($edge, searchParams, indicator);
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable scheduleNodeRequestsSearch$lambda$28(List $edges, RequestsSearcher searcher, RequestsSearcher.SearchParams searchParams, ProgressIndicator indicator) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
        Intrinsics.checkNotNullParameter((Object)searchParams, (String)"searchParams");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Iterable $this$flatMap$iv = $edges;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            MsDiagramEdge edge = (MsDiagramEdge)((Object)element$iv$iv);
            boolean bl = false;
            Iterable<MsDiagramRequest> list$iv$iv = searcher.searchForRequestsFormingAnEdge(edge, searchParams, indicator);
            CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ AtomicReference access$getMyLastStartedProgress$p(MsDiagramDataModel $this) {
        return $this.myLastStartedProgress;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003J)\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/intellij/microservices/ui/diagrams/model/MsDiagramDataModel$MyModelData;", "", "viewSettings", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramDataModel$MyModelSettings;", "requestsGraph", "Lcom/google/common/graph/MutableNetwork;", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramEndpoint;", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramRequest;", "<init>", "(Lcom/intellij/microservices/ui/diagrams/model/MsDiagramDataModel$MyModelSettings;Lcom/google/common/graph/MutableNetwork;)V", "getViewSettings", "()Lcom/intellij/microservices/ui/diagrams/model/MsDiagramDataModel$MyModelSettings;", "getRequestsGraph", "()Lcom/google/common/graph/MutableNetwork;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.microservices.ui"})
    private static final class MyModelData {
        @NotNull
        private final MyModelSettings viewSettings;
        @NotNull
        private final MutableNetwork<MsDiagramEndpoint, MsDiagramRequest> requestsGraph;

        public MyModelData(@NotNull MyModelSettings viewSettings, @NotNull MutableNetwork<MsDiagramEndpoint, MsDiagramRequest> requestsGraph) {
            Intrinsics.checkNotNullParameter((Object)viewSettings, (String)"viewSettings");
            Intrinsics.checkNotNullParameter(requestsGraph, (String)"requestsGraph");
            this.viewSettings = viewSettings;
            this.requestsGraph = requestsGraph;
        }

        @NotNull
        public final MyModelSettings getViewSettings() {
            return this.viewSettings;
        }

        @NotNull
        public final MutableNetwork<MsDiagramEndpoint, MsDiagramRequest> getRequestsGraph() {
            return this.requestsGraph;
        }

        @NotNull
        public final MyModelSettings component1() {
            return this.viewSettings;
        }

        @NotNull
        public final MutableNetwork<MsDiagramEndpoint, MsDiagramRequest> component2() {
            return this.requestsGraph;
        }

        @NotNull
        public final MyModelData copy(@NotNull MyModelSettings viewSettings, @NotNull MutableNetwork<MsDiagramEndpoint, MsDiagramRequest> requestsGraph) {
            Intrinsics.checkNotNullParameter((Object)viewSettings, (String)"viewSettings");
            Intrinsics.checkNotNullParameter(requestsGraph, (String)"requestsGraph");
            return new MyModelData(viewSettings, requestsGraph);
        }

        public static /* synthetic */ MyModelData copy$default(MyModelData myModelData, MyModelSettings myModelSettings, MutableNetwork mutableNetwork, int n, Object object) {
            if ((n & 1) != 0) {
                myModelSettings = myModelData.viewSettings;
            }
            if ((n & 2) != 0) {
                mutableNetwork = myModelData.requestsGraph;
            }
            return myModelData.copy(myModelSettings, mutableNetwork);
        }

        @NotNull
        public String toString() {
            return "MyModelData(viewSettings=" + this.viewSettings + ", requestsGraph=" + this.requestsGraph + ")";
        }

        public int hashCode() {
            int result = this.viewSettings.hashCode();
            result = result * 31 + this.requestsGraph.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MyModelData)) {
                return false;
            }
            MyModelData myModelData = (MyModelData)other;
            if (!Intrinsics.areEqual((Object)this.viewSettings, (Object)myModelData.viewSettings)) {
                return false;
            }
            return Intrinsics.areEqual(this.requestsGraph, myModelData.requestsGraph);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/microservices/ui/diagrams/model/MsDiagramDataModel$MyModelSettings;", "", "doSearchFromTests", "", "doSearchFromLibraries", "<init>", "(ZZ)V", "getDoSearchFromTests", "()Z", "getDoSearchFromLibraries", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.microservices.ui"})
    private static final class MyModelSettings {
        private final boolean doSearchFromTests;
        private final boolean doSearchFromLibraries;

        public MyModelSettings(boolean doSearchFromTests, boolean doSearchFromLibraries) {
            this.doSearchFromTests = doSearchFromTests;
            this.doSearchFromLibraries = doSearchFromLibraries;
        }

        public final boolean getDoSearchFromTests() {
            return this.doSearchFromTests;
        }

        public final boolean getDoSearchFromLibraries() {
            return this.doSearchFromLibraries;
        }

        public final boolean component1() {
            return this.doSearchFromTests;
        }

        public final boolean component2() {
            return this.doSearchFromLibraries;
        }

        @NotNull
        public final MyModelSettings copy(boolean doSearchFromTests, boolean doSearchFromLibraries) {
            return new MyModelSettings(doSearchFromTests, doSearchFromLibraries);
        }

        public static /* synthetic */ MyModelSettings copy$default(MyModelSettings myModelSettings, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = myModelSettings.doSearchFromTests;
            }
            if ((n & 2) != 0) {
                bl2 = myModelSettings.doSearchFromLibraries;
            }
            return myModelSettings.copy(bl, bl2);
        }

        @NotNull
        public String toString() {
            return "MyModelSettings(doSearchFromTests=" + this.doSearchFromTests + ", doSearchFromLibraries=" + this.doSearchFromLibraries + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.doSearchFromTests);
            result = result * 31 + Boolean.hashCode(this.doSearchFromLibraries);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MyModelSettings)) {
                return false;
            }
            MyModelSettings myModelSettings = (MyModelSettings)other;
            if (this.doSearchFromTests != myModelSettings.doSearchFromTests) {
                return false;
            }
            return this.doSearchFromLibraries == myModelSettings.doSearchFromLibraries;
        }
    }
}

