/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.ui.remote.providers;

import com.intellij.core.CoreBundle;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.CachingFileContentsApi;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.ContentsApiModel;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.DirectoryModel;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.FileModel;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.NotebookModel;
import com.intellij.jupyter.core.jupyter.connections.http.JupyterRestClientErrorResponseException;
import com.intellij.jupyter.core.jupyter.connections.http.JupyterRestClientException;
import com.intellij.jupyter.py.JupyterRemoteBundle;
import com.intellij.jupyter.py.remote.JupyterRemoteUtilKt;
import com.intellij.jupyter.py.remote.SuggestedKind;
import com.intellij.jupyter.py.remote.vfs.JupyterRemoteVfsUtilKt;
import com.intellij.jupyter.py.ui.remote.JupyterRemoteLoadingNode;
import com.intellij.jupyter.py.ui.remote.JupyterRemoteNode;
import com.intellij.notebooks.core.jupyter.JupyterRemotePath;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.pom.Navigatable;
import com.intellij.util.IncorrectOperationException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0000\u001a\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u000e\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u0006H\u0000\u00a8\u0006\t"}, d2={"getRemoteTargetNode", "Lcom/intellij/jupyter/py/ui/remote/JupyterRemoteNode;", "Lcom/intellij/openapi/actionSystem/DataContext;", "createRemoteDirectory", "Lcom/intellij/jupyter/core/jupyter/connections/filecontentsapi/DirectoryModel;", "remoteDirPath", "Lcom/intellij/notebooks/core/jupyter/JupyterRemotePath;", "getFileNodeLookingOnExtension", "Lcom/intellij/jupyter/core/jupyter/connections/filecontentsapi/ContentsApiModel;", "intellij.jupyter.py"})
public final class UtilKt {
    @Nullable
    public static final JupyterRemoteNode getRemoteTargetNode(@NotNull DataContext $this$getRemoteTargetNode) {
        Intrinsics.checkNotNullParameter((Object)$this$getRemoteTargetNode, (String)"<this>");
        Navigatable target = (Navigatable)$this$getRemoteTargetNode.getData(CommonDataKeys.NAVIGATABLE);
        if (target instanceof JupyterRemoteLoadingNode) {
            return null;
        }
        return target instanceof JupyterRemoteNode ? (JupyterRemoteNode)target : null;
    }

    @Nullable
    public static final DirectoryModel createRemoteDirectory(@NotNull JupyterRemotePath remoteDirPath) {
        DirectoryModel directoryModel;
        Intrinsics.checkNotNullParameter((Object)remoteDirPath, (String)"remoteDirPath");
        try {
            CachingFileContentsApi cachingFileContentsApi = JupyterRemoteVfsUtilKt.getFileContentsApi(remoteDirPath);
            directoryModel = cachingFileContentsApi != null ? cachingFileContentsApi.createDirectory(remoteDirPath.getJupyterPath()) : null;
        }
        catch (JupyterRestClientErrorResponseException e) {
            String string;
            String string2 = e.getMessage();
            boolean bl = string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)"Not a directory:", (boolean)false, (int)2, null) : false;
            if (bl) {
                var5_3 = new Object[]{remoteDirPath.getFullPath()};
                string = CoreBundle.message((String)"file.already.exists.error", (Object[])var5_3);
            } else {
                var5_3 = new Object[]{remoteDirPath.getFullPath()};
                string = JupyterRemoteBundle.message("Jupyter.remote.unable.to.create.target.dir", var5_3);
            }
            String string3 = string;
            Intrinsics.checkNotNull((Object)string3);
            String errMsg = string3;
            throw new IncorrectOperationException(errMsg);
        }
        return directoryModel;
    }

    @Nullable
    public static final ContentsApiModel getFileNodeLookingOnExtension(@NotNull JupyterRemotePath $this$getFileNodeLookingOnExtension) {
        ContentsApiModel contentsApiModel;
        Intrinsics.checkNotNullParameter((Object)$this$getFileNodeLookingOnExtension, (String)"<this>");
        CachingFileContentsApi cachingFileContentsApi = JupyterRemoteVfsUtilKt.getFileContentsApi($this$getFileNodeLookingOnExtension);
        if (cachingFileContentsApi == null) {
            return null;
        }
        CachingFileContentsApi fileContentsApi = cachingFileContentsApi;
        SuggestedKind suggestedKind = JupyterRemoteUtilKt.suggestedKind($this$getFileNodeLookingOnExtension);
        Class<NotebookModel> type = switch (suggestedKind == null ? -1 : WhenMappings.$EnumSwitchMapping$0[suggestedKind.ordinal()]) {
            case 1 -> NotebookModel.class;
            case 2 -> FileModel.class;
            case -1 -> ContentsApiModel.class;
            default -> throw new NoWhenBranchMatchedException();
        };
        try {
            contentsApiModel = fileContentsApi.getFileNode($this$getFileNodeLookingOnExtension.getJupyterPath(), true, type);
        }
        catch (JupyterRestClientException err) {
            if (err.getCode() != 400 || Intrinsics.areEqual(type, ContentsApiModel.class)) {
                throw err;
            }
            contentsApiModel = fileContentsApi.getFileNode($this$getFileNodeLookingOnExtension.getJupyterPath(), true, ContentsApiModel.class);
        }
        return contentsApiModel;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SuggestedKind.values().length];
            try {
                nArray[SuggestedKind.NOTEBOOK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SuggestedKind.FILE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

