/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.ui.remote.providers;

import com.intellij.jupyter.core.jupyter.JupyterErrorHandlingUtilKt;
import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParameterSettingsUtilsKt;
import com.intellij.jupyter.core.jupyter.connections.settings.ConfiguredServerJupyterModuleConnectionSettings;
import com.intellij.jupyter.py.JupyterRemoteBundle;
import com.intellij.jupyter.py.ui.remote.JupyterRemoteCompositeNode;
import com.intellij.jupyter.py.ui.remote.JupyterRemoteFileNode;
import com.intellij.jupyter.py.ui.remote.JupyterRemoteLoadingNode;
import com.intellij.jupyter.py.ui.remote.JupyterRemoteNode;
import com.intellij.jupyter.py.ui.remote.providers.JupyterRemoteCopyPasteLog;
import com.intellij.jupyter.py.ui.remote.providers.PasteCommand;
import com.intellij.jupyter.py.ui.remote.providers.RemoteToLocalCopyStrategy;
import com.intellij.notebooks.core.jupyter.JupyterRemotePath;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0011\u001a\u00020\u0012H\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/jupyter/py/ui/remote/providers/MultipleRemoteItemsToLocalDirCommand;", "Lcom/intellij/jupyter/py/ui/remote/providers/PasteCommand;", "project", "Lcom/intellij/openapi/project/Project;", "itemsToCopy", "", "Lcom/intellij/jupyter/py/ui/remote/JupyterRemoteNode;", "localPasteDirectory", "Lcom/intellij/psi/PsiDirectory;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;Lcom/intellij/psi/PsiDirectory;)V", "taskTitle", "", "getTaskTitle", "()Ljava/lang/String;", "strategy", "Lcom/intellij/jupyter/py/ui/remote/providers/RemoteToLocalCopyStrategy;", "doExecute", "", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\npasteCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 pasteCommands.kt\ncom/intellij/jupyter/py/ui/remote/providers/MultipleRemoteItemsToLocalDirCommand\n+ 2 JupyterErrorHandlingUtil.kt\ncom/intellij/jupyter/core/jupyter/JupyterErrorHandlingUtilKt\n*L\n1#1,394:1\n41#2:395\n73#2,6:396\n43#2:402\n79#2:403\n77#2,7:404\n47#2:411\n*S KotlinDebug\n*F\n+ 1 pasteCommands.kt\ncom/intellij/jupyter/py/ui/remote/providers/MultipleRemoteItemsToLocalDirCommand\n*L\n294#1:395\n294#1:396,6\n294#1:402\n294#1:403\n294#1:404,7\n294#1:411\n*E\n"})
final class MultipleRemoteItemsToLocalDirCommand
extends PasteCommand {
    @NotNull
    private final Collection<JupyterRemoteNode> itemsToCopy;
    @NotNull
    private final PsiDirectory localPasteDirectory;
    @NotNull
    private final String taskTitle;
    @NotNull
    private final RemoteToLocalCopyStrategy strategy;

    public MultipleRemoteItemsToLocalDirCommand(@NotNull Project project, @NotNull Collection<? extends JupyterRemoteNode> itemsToCopy, @NotNull PsiDirectory localPasteDirectory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(itemsToCopy, (String)"itemsToCopy");
        Intrinsics.checkNotNullParameter((Object)localPasteDirectory, (String)"localPasteDirectory");
        super(project, null);
        this.itemsToCopy = itemsToCopy;
        this.localPasteDirectory = localPasteDirectory;
        Object[] objectArray = new Object[]{this.localPasteDirectory.getVirtualFile().getPath()};
        this.taskTitle = JupyterRemoteBundle.message("Jupyter.remote.copying.multiple", objectArray);
        this.strategy = new RemoteToLocalCopyStrategy(this);
    }

    @Override
    @NotNull
    protected String getTaskTitle() {
        return this.taskTitle;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doExecute() {
        File localPasteDirectoryFile = this.localPasteDirectory.getVirtualFile().toNioPath().toFile();
        for (JupyterRemoteNode remoteNode : this.itemsToCopy) {
            Unit unit;
            void $this$runHandlingConnectionErrors$iv;
            Logger logger = JupyterRemoteCopyPasteLog.INSTANCE.getLOG();
            JupyterRemotePath jupyterRemotePath = remoteNode.getRemotePath();
            boolean suggestRemovingConnection$iv = false;
            boolean $i$f$runHandlingConnectionErrors = false;
            void $this$runHandlingConnectionErrors$iv$iv = $this$runHandlingConnectionErrors$iv;
            boolean $i$f$runHandlingConnectionErrors2 = false;
            try {
                boolean bl = false;
                JupyterRemoteNode jupyterRemoteNode = remoteNode;
                if (jupyterRemoteNode instanceof JupyterRemoteFileNode) {
                    JupyterRemotePath jupyterRemotePath2 = remoteNode.getRemotePath();
                    String string = remoteNode.getRemotePath().getName();
                    Intrinsics.checkNotNull((Object)string);
                    Intrinsics.checkNotNull((Object)localPasteDirectoryFile);
                    this.strategy.copyFile(jupyterRemotePath2, string, localPasteDirectoryFile);
                } else if (jupyterRemoteNode instanceof JupyterRemoteCompositeNode) {
                    JupyterRemotePath jupyterRemotePath3 = remoteNode.getRemotePath();
                    String string = remoteNode.getRemotePath().getNameOrAuthority();
                    Intrinsics.checkNotNull((Object)localPasteDirectoryFile);
                    this.strategy.copyDirectory(jupyterRemotePath3, string, localPasteDirectoryFile);
                } else {
                    if (jupyterRemoteNode instanceof JupyterRemoteLoadingNode) {
                        return;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                unit = Unit.INSTANCE;
            }
            catch (IOException e$iv$iv) {
                void remotePath$iv;
                boolean bl = false;
                ConfiguredServerJupyterModuleConnectionSettings configuredServerJupyterModuleConnectionSettings = JupyterConnectionParameterSettingsUtilsKt.getAnyConnectionSettingsForAuthority((String)remotePath$iv.getAuthority());
                if (configuredServerJupyterModuleConnectionSettings == null) {
                    throw e$iv$iv;
                }
                JupyterErrorHandlingUtilKt.suggestRemovingConnection((ConfiguredServerJupyterModuleConnectionSettings)configuredServerJupyterModuleConnectionSettings, (boolean)suggestRemovingConnection$iv);
                void var15_15 = $this$runHandlingConnectionErrors$iv$iv;
                bl = false;
                var15_15.warn("Unexpected exception for " + JupyterConnectionParameterSettingsUtilsKt.getAnyConnectionSettingsForAuthority((String)remotePath$iv.getAuthority()), (Throwable)e$iv$iv);
                unit = null;
            }
        }
        VirtualFile[] virtualFileArray = new VirtualFile[]{this.localPasteDirectory.getVirtualFile()};
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])virtualFileArray);
    }
}

