/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.actions.convert;

import com.intellij.jupyter.core.core.api.actions.NotebookCellLinesEditHelper;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellsContents;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.actions.convert.ConvertAction;
import com.intellij.jupyter.py.psi.JupyterPyDialect;
import com.intellij.lang.Language;
import com.intellij.notebooks.jupyter.core.jupyter.JupyterFileType;
import com.intellij.notebooks.jupyter.core.jupyter.JupyterLanguage;
import com.intellij.notebooks.visualization.IntervalsGenerator;
import com.intellij.notebooks.visualization.NotebookCellLinesProvider;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.jetbrains.python.PythonLanguage;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lcom/intellij/jupyter/py/actions/convert/ConvertJupyterToPythonAction;", "Lcom/intellij/jupyter/core/jupyter/actions/convert/ConvertAction;", "<init>", "()V", "sourceLanguage", "Lcom/intellij/lang/Language;", "getSourceLanguage", "()Lcom/intellij/lang/Language;", "targetLanguage", "getTargetLanguage", "isSupported", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "loadContents", "Lcom/intellij/jupyter/core/core/impl/actions/NotebookCellsContents;", "virtualFile", "writeContents", "", "content", "project", "Lcom/intellij/openapi/project/Project;", "intellij.jupyter.py"})
public final class ConvertJupyterToPythonAction
extends ConvertAction {
    @NotNull
    private final Language sourceLanguage = (Language)JupyterLanguage.INSTANCE;
    @NotNull
    private final Language targetLanguage;

    public ConvertJupyterToPythonAction() {
        PythonLanguage pythonLanguage = PythonLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)pythonLanguage, (String)"INSTANCE");
        this.targetLanguage = (Language)pythonLanguage;
    }

    @NotNull
    public Language getSourceLanguage() {
        return this.sourceLanguage;
    }

    @NotNull
    public Language getTargetLanguage() {
        return this.targetLanguage;
    }

    protected boolean isSupported(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        String extension = virtualFile != null ? virtualFile.getExtension() : null;
        return Intrinsics.areEqual((Object)extension, (Object)JupyterFileType.INSTANCE.getDefaultExtension());
    }

    @Nullable
    protected VirtualFile getFile(@NotNull AnActionEvent e) {
        BackedNotebookVirtualFile notebookVirtualFile;
        BackedNotebookVirtualFile backedNotebookVirtualFile;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        BackedNotebookVirtualFile backedNotebookVirtualFile2 = BackedNotebookVirtualFile.Companion.takeFront(virtualFile2);
        if (backedNotebookVirtualFile2 == null) {
            backedNotebookVirtualFile2 = BackedNotebookVirtualFile.Companion.find(virtualFile2);
        }
        if ((backedNotebookVirtualFile = (notebookVirtualFile = backedNotebookVirtualFile2)) == null || (backedNotebookVirtualFile = backedNotebookVirtualFile.getNotebook()) == null) {
            return null;
        }
        BackedNotebookVirtualFile notebook = backedNotebookVirtualFile;
        if (!(notebook.getLanguage() instanceof JupyterPyDialect)) {
            return null;
        }
        return notebookVirtualFile.getFile();
    }

    @Nullable
    public NotebookCellsContents loadContents(@NotNull VirtualFile virtualFile) {
        Object object;
        Document document;
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        BackedNotebookVirtualFile backedNotebookVirtualFile = BackedNotebookVirtualFile.Companion.takeIfBacked(virtualFile);
        if (backedNotebookVirtualFile == null) {
            return null;
        }
        BackedNotebookVirtualFile notebookVirtualFile = backedNotebookVirtualFile;
        Document document2 = VirtualFileUtil.findDocument((VirtualFile)notebookVirtualFile.getFile());
        if (document2 == null) {
            document2 = document = (Document)new DocumentImpl(VirtualFileUtil.readText((VirtualFile)notebookVirtualFile.getFile()));
        }
        if ((object = (NotebookCellLinesProvider)NotebookCellLinesProvider.Companion.forLanguage(this.getSourceLanguage())) == null || (object = IntervalsGenerator.DefaultImpls.makeIntervals$default((IntervalsGenerator)((IntervalsGenerator)object), (Document)document, null, (int)2, null)) == null) {
            return null;
        }
        Object intervals = object;
        String string = document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return new NotebookCellsContents(string, (List)intervals, null, this.getSourceLanguage(), 4, null);
    }

    public void writeContents(@NotNull VirtualFile virtualFile, @NotNull NotebookCellsContents content, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        NotebookCellLinesEditHelper notebookCellLinesEditHelper = (NotebookCellLinesEditHelper)NotebookCellLinesEditHelper.Companion.forLanguage(this.getTargetLanguage());
        if (notebookCellLinesEditHelper == null) {
            return;
        }
        NotebookCellLinesEditHelper helper = notebookCellLinesEditHelper;
        String text = helper.makeInsertedCells(content, 0);
        VirtualFileUtil.writeText((VirtualFile)virtualFile, (String)text);
    }
}

