/*                                                     -*- linux-c -*-
    Copyright (C) 2004 Tom Szilagyi

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: gui_ext.c,v 1.4 2004/06/12 13:56:46 tszilagyi Exp $
*/


#include <string.h>
#include <gtk/gtk.h>

#include "common.h"
#include "gui_ext.h"



/* display modal message box with Dismiss button */
int message_box(char * title, char * label_text, GtkWidget * parent, GtkMessageType type) {

	GdkColor color;
	GtkWidget * dialog;
	GtkWidget * button;
	int ret;
	
	dialog = gtk_message_dialog_new(GTK_WINDOW(parent),
					GTK_DIALOG_DESTROY_WITH_PARENT,
					type,
					GTK_BUTTONS_NONE,
					label_text);
	gtk_window_set_title(GTK_WINDOW(dialog), title);
	gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);
	gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
	
	button = gtk_dialog_add_button(GTK_DIALOG(dialog), "Dismiss", 0);
	gtk_dialog_set_default_response(GTK_DIALOG(dialog), 0);
	
        color.red = WINDOW_R;
        color.green = WINDOW_G;
        color.blue = WINDOW_B;
        gtk_widget_modify_bg(GTK_WIDGET(dialog), GTK_STATE_NORMAL, &color);

        color.red = NORMAL_R;
        color.green = NORMAL_G;
        color.blue = NORMAL_B;
        gtk_widget_modify_bg(GTK_WIDGET(button), GTK_STATE_NORMAL, &color);

        color.red = ACTIVE_R;
        color.green = ACTIVE_G;
        color.blue = ACTIVE_B;
        gtk_widget_modify_bg(GTK_WIDGET(button), GTK_STATE_ACTIVE, &color);

        color.red = PRELIGHT_R;
        color.green = PRELIGHT_G;
        color.blue = PRELIGHT_B;
        gtk_widget_modify_bg(GTK_WIDGET(button), GTK_STATE_PRELIGHT, &color);

	ret = gtk_dialog_run(GTK_DIALOG(dialog));
	gtk_widget_destroy(dialog);

	return ret;
}


/* display modal confirm box with OK/Cancel buttons */
int confirm_box(char * title, char * label_text, GtkWidget * parent, GtkMessageType type) {
	
	GdkColor color;
	GtkWidget * dialog;
	GtkWidget * button_ok;
	GtkWidget * button_cancel;
	int ret;
	
	dialog = gtk_message_dialog_new(GTK_WINDOW(parent),
					GTK_DIALOG_DESTROY_WITH_PARENT,
					type,
					GTK_BUTTONS_NONE,
					label_text);
	gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
	gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);
	gtk_window_set_title(GTK_WINDOW(dialog), title);
	gtk_window_set_destroy_with_parent(GTK_WINDOW(dialog), TRUE);
	
	button_ok = gtk_dialog_add_button(GTK_DIALOG(dialog), "OK", 0);
	button_cancel = gtk_dialog_add_button(GTK_DIALOG(dialog), "Cancel", 1);
	gtk_dialog_set_default_response(GTK_DIALOG(dialog), 1);
	
        color.red = WINDOW_R;
        color.green = WINDOW_G;
        color.blue = WINDOW_B;
        gtk_widget_modify_bg(GTK_WIDGET(dialog), GTK_STATE_NORMAL, &color);

        color.red = NORMAL_R;
        color.green = NORMAL_G;
        color.blue = NORMAL_B;
        gtk_widget_modify_bg(GTK_WIDGET(button_ok), GTK_STATE_NORMAL, &color);
        gtk_widget_modify_bg(GTK_WIDGET(button_cancel), GTK_STATE_NORMAL, &color);

        color.red = ACTIVE_R;
        color.green = ACTIVE_G;
        color.blue = ACTIVE_B;
        gtk_widget_modify_bg(GTK_WIDGET(button_ok), GTK_STATE_ACTIVE, &color);
        gtk_widget_modify_bg(GTK_WIDGET(button_cancel), GTK_STATE_ACTIVE, &color);

        color.red = PRELIGHT_R;
        color.green = PRELIGHT_G;
        color.blue = PRELIGHT_B;
        gtk_widget_modify_bg(GTK_WIDGET(button_ok), GTK_STATE_PRELIGHT, &color);
        gtk_widget_modify_bg(GTK_WIDGET(button_cancel), GTK_STATE_PRELIGHT, &color);
	
	ret = gtk_dialog_run(GTK_DIALOG(dialog));
	gtk_widget_destroy(dialog);

	return ret;
}


/* display modal exit_confirm box with Quit/Don't quit buttons */
int confirm_exit_box(char * title, char * label_text, GtkWidget * parent, GtkMessageType type) {
	
	GdkColor color;
	GtkWidget * dialog;
	GtkWidget * button_quit;
	GtkWidget * button_noquit;
	int ret;
	
	dialog = gtk_message_dialog_new(GTK_WINDOW(parent),
					GTK_DIALOG_DESTROY_WITH_PARENT,
					type,
					GTK_BUTTONS_NONE,
					label_text);
	gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
	gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);
	gtk_window_set_title(GTK_WINDOW(dialog), title);
	
	button_quit = gtk_dialog_add_button(GTK_DIALOG(dialog), "Quit", 0);
	button_noquit = gtk_dialog_add_button(GTK_DIALOG(dialog), "Don't quit", 1);
	gtk_dialog_set_default_response(GTK_DIALOG(dialog), 0);
	
        color.red = WINDOW_R;
        color.green = WINDOW_G;
        color.blue = WINDOW_B;
        gtk_widget_modify_bg(GTK_WIDGET(dialog), GTK_STATE_NORMAL, &color);

        color.red = NORMAL_R;
        color.green = NORMAL_G;
        color.blue = NORMAL_B;
        gtk_widget_modify_bg(GTK_WIDGET(button_quit), GTK_STATE_NORMAL, &color);
        gtk_widget_modify_bg(GTK_WIDGET(button_noquit), GTK_STATE_NORMAL, &color);

        color.red = ACTIVE_R;
        color.green = ACTIVE_G;
        color.blue = ACTIVE_B;
        gtk_widget_modify_bg(GTK_WIDGET(button_quit), GTK_STATE_ACTIVE, &color);
        gtk_widget_modify_bg(GTK_WIDGET(button_noquit), GTK_STATE_ACTIVE, &color);

        color.red = PRELIGHT_R;
        color.green = PRELIGHT_G;
        color.blue = PRELIGHT_B;
        gtk_widget_modify_bg(GTK_WIDGET(button_quit), GTK_STATE_PRELIGHT, &color);
        gtk_widget_modify_bg(GTK_WIDGET(button_noquit), GTK_STATE_PRELIGHT, &color);

	ret = gtk_dialog_run(GTK_DIALOG(dialog));
	gtk_widget_destroy(dialog);

	return ret;
}


/* display modal input box with OK/Cancel buttons */
int input_box(char * title, char * label_text, char * default_text, char * user_entry,
	      GtkWidget * parent, GtkMessageType type) {
	
	GdkColor color;
	GtkWidget * dialog;
	GtkWidget * entry;
	GtkWidget * button_ok;
	GtkWidget * button_cancel;
	int ret;
	
	entry = gtk_entry_new();
	dialog = gtk_message_dialog_new(GTK_WINDOW(parent),
					GTK_DIALOG_DESTROY_WITH_PARENT,
					type,
					GTK_BUTTONS_NONE,
					label_text);
	gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
	gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);
	gtk_window_set_title(GTK_WINDOW(dialog), title);
	gtk_window_set_destroy_with_parent(GTK_WINDOW(dialog), TRUE);
	
	button_ok = gtk_dialog_add_button(GTK_DIALOG(dialog), "OK", 0);
	button_cancel = gtk_dialog_add_button(GTK_DIALOG(dialog), "Cancel", 1);
	gtk_dialog_set_default_response(GTK_DIALOG(dialog), 0);
	
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), entry, TRUE, TRUE, 10);
	gtk_entry_set_text(GTK_ENTRY(entry), default_text);
	gtk_widget_show(entry);
	
        color.red = WINDOW_R;
        color.green = WINDOW_G;
        color.blue = WINDOW_B;
        gtk_widget_modify_bg(GTK_WIDGET(dialog), GTK_STATE_NORMAL, &color);

        color.red = NORMAL_R;
        color.green = NORMAL_G;
        color.blue = NORMAL_B;
        gtk_widget_modify_bg(GTK_WIDGET(button_ok), GTK_STATE_NORMAL, &color);
        gtk_widget_modify_bg(GTK_WIDGET(button_cancel), GTK_STATE_NORMAL, &color);
        gtk_widget_modify_bg(GTK_WIDGET(entry), GTK_STATE_NORMAL, &color);

        color.red = ACTIVE_R;
        color.green = ACTIVE_G;
        color.blue = ACTIVE_B;
        gtk_widget_modify_bg(GTK_WIDGET(button_ok), GTK_STATE_ACTIVE, &color);
        gtk_widget_modify_bg(GTK_WIDGET(button_cancel), GTK_STATE_ACTIVE, &color);
        gtk_widget_modify_bg(GTK_WIDGET(entry), GTK_STATE_ACTIVE, &color);

        color.red = PRELIGHT_R;
        color.green = PRELIGHT_G;
        color.blue = PRELIGHT_B;
        gtk_widget_modify_bg(GTK_WIDGET(button_ok), GTK_STATE_PRELIGHT, &color);
        gtk_widget_modify_bg(GTK_WIDGET(button_cancel), GTK_STATE_PRELIGHT, &color);
        gtk_widget_modify_bg(GTK_WIDGET(entry), GTK_STATE_PRELIGHT, &color);

	if (!gtk_dialog_run(GTK_DIALOG(dialog))) {
		strcpy(user_entry, gtk_entry_get_text(GTK_ENTRY(entry)));
		ret = 1;
	} else {
		user_entry[0] = '\0';
		ret = 0;
	}
	
	gtk_widget_destroy(entry);
	gtk_widget_destroy(dialog);

	return ret;
}
