// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/logging/v2/logging.proto

package logging

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "github.com/golang/protobuf/ptypes/duration"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	monitoredres "google.golang.org/genproto/googleapis/api/monitoredres"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The parameters to DeleteLog.
type DeleteLogRequest struct {
	// Required. The resource name of the log to delete:
	//
	//     "projects/[PROJECT_ID]/logs/[LOG_ID]"
	//     "organizations/[ORGANIZATION_ID]/logs/[LOG_ID]"
	//     "billingAccounts/[BILLING_ACCOUNT_ID]/logs/[LOG_ID]"
	//     "folders/[FOLDER_ID]/logs/[LOG_ID]"
	//
	// `[LOG_ID]` must be URL-encoded. For example,
	// `"projects/my-project-id/logs/syslog"`,
	// `"organizations/1234567890/logs/cloudresourcemanager.googleapis.com%2Factivity"`.
	// For more information about log names, see
	// [LogEntry][google.logging.v2.LogEntry].
	LogName              string   `protobuf:"bytes,1,opt,name=log_name,json=logName,proto3" json:"log_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteLogRequest) Reset()         { *m = DeleteLogRequest{} }
func (m *DeleteLogRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteLogRequest) ProtoMessage()    {}
func (*DeleteLogRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6a8ba408154557e4, []int{0}
}

func (m *DeleteLogRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteLogRequest.Unmarshal(m, b)
}
func (m *DeleteLogRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteLogRequest.Marshal(b, m, deterministic)
}
func (m *DeleteLogRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteLogRequest.Merge(m, src)
}
func (m *DeleteLogRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteLogRequest.Size(m)
}
func (m *DeleteLogRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteLogRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteLogRequest proto.InternalMessageInfo

func (m *DeleteLogRequest) GetLogName() string {
	if m != nil {
		return m.LogName
	}
	return ""
}

// The parameters to WriteLogEntries.
type WriteLogEntriesRequest struct {
	// Optional. A default log resource name that is assigned to all log entries
	// in `entries` that do not specify a value for `log_name`:
	//
	//     "projects/[PROJECT_ID]/logs/[LOG_ID]"
	//     "organizations/[ORGANIZATION_ID]/logs/[LOG_ID]"
	//     "billingAccounts/[BILLING_ACCOUNT_ID]/logs/[LOG_ID]"
	//     "folders/[FOLDER_ID]/logs/[LOG_ID]"
	//
	// `[LOG_ID]` must be URL-encoded. For example:
	//
	//     "projects/my-project-id/logs/syslog"
	//     "organizations/1234567890/logs/cloudresourcemanager.googleapis.com%2Factivity"
	//
	// The permission <code>logging.logEntries.create</code> is needed on each
	// project, organization, billing account, or folder that is receiving
	// new log entries, whether the resource is specified in
	// <code>logName</code> or in an individual log entry.
	LogName string `protobuf:"bytes,1,opt,name=log_name,json=logName,proto3" json:"log_name,omitempty"`
	// Optional. A default monitored resource object that is assigned to all log
	// entries in `entries` that do not specify a value for `resource`. Example:
	//
	//     { "type": "gce_instance",
	//       "labels": {
	//         "zone": "us-central1-a", "instance_id": "00000000000000000000" }}
	//
	// See [LogEntry][google.logging.v2.LogEntry].
	Resource *monitoredres.MonitoredResource `protobuf:"bytes,2,opt,name=resource,proto3" json:"resource,omitempty"`
	// Optional. Default labels that are added to the `labels` field of all log
	// entries in `entries`. If a log entry already has a label with the same key
	// as a label in this parameter, then the log entry's label is not changed.
	// See [LogEntry][google.logging.v2.LogEntry].
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. The log entries to send to Logging. The order of log
	// entries in this list does not matter. Values supplied in this method's
	// `log_name`, `resource`, and `labels` fields are copied into those log
	// entries in this list that do not include values for their corresponding
	// fields. For more information, see the
	// [LogEntry][google.logging.v2.LogEntry] type.
	//
	// If the `timestamp` or `insert_id` fields are missing in log entries, then
	// this method supplies the current time or a unique identifier, respectively.
	// The supplied values are chosen so that, among the log entries that did not
	// supply their own values, the entries earlier in the list will sort before
	// the entries later in the list. See the `entries.list` method.
	//
	// Log entries with timestamps that are more than the
	// [logs retention period](/logging/quota-policy) in the past or more than
	// 24 hours in the future will not be available when calling `entries.list`.
	// However, those log entries can still be
	// [exported with LogSinks](/logging/docs/api/tasks/exporting-logs).
	//
	// To improve throughput and to avoid exceeding the
	// [quota limit](/logging/quota-policy) for calls to `entries.write`,
	// you should try to include several log entries in this list,
	// rather than calling this method for each individual log entry.
	Entries []*LogEntry `protobuf:"bytes,4,rep,name=entries,proto3" json:"entries,omitempty"`
	// Optional. Whether valid entries should be written even if some other
	// entries fail due to INVALID_ARGUMENT or PERMISSION_DENIED errors. If any
	// entry is not written, then the response status is the error associated
	// with one of the failed entries and the response includes error details
	// keyed by the entries' zero-based index in the `entries.write` method.
	PartialSuccess bool `protobuf:"varint,5,opt,name=partial_success,json=partialSuccess,proto3" json:"partial_success,omitempty"`
	// Optional. If true, the request should expect normal response, but the
	// entries won't be persisted nor exported. Useful for checking whether the
	// logging API endpoints are working properly before sending valuable data.
	DryRun               bool     `protobuf:"varint,6,opt,name=dry_run,json=dryRun,proto3" json:"dry_run,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WriteLogEntriesRequest) Reset()         { *m = WriteLogEntriesRequest{} }
func (m *WriteLogEntriesRequest) String() string { return proto.CompactTextString(m) }
func (*WriteLogEntriesRequest) ProtoMessage()    {}
func (*WriteLogEntriesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6a8ba408154557e4, []int{1}
}

func (m *WriteLogEntriesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WriteLogEntriesRequest.Unmarshal(m, b)
}
func (m *WriteLogEntriesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WriteLogEntriesRequest.Marshal(b, m, deterministic)
}
func (m *WriteLogEntriesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WriteLogEntriesRequest.Merge(m, src)
}
func (m *WriteLogEntriesRequest) XXX_Size() int {
	return xxx_messageInfo_WriteLogEntriesRequest.Size(m)
}
func (m *WriteLogEntriesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_WriteLogEntriesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_WriteLogEntriesRequest proto.InternalMessageInfo

func (m *WriteLogEntriesRequest) GetLogName() string {
	if m != nil {
		return m.LogName
	}
	return ""
}

func (m *WriteLogEntriesRequest) GetResource() *monitoredres.MonitoredResource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *WriteLogEntriesRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *WriteLogEntriesRequest) GetEntries() []*LogEntry {
	if m != nil {
		return m.Entries
	}
	return nil
}

func (m *WriteLogEntriesRequest) GetPartialSuccess() bool {
	if m != nil {
		return m.PartialSuccess
	}
	return false
}

func (m *WriteLogEntriesRequest) GetDryRun() bool {
	if m != nil {
		return m.DryRun
	}
	return false
}

// Result returned from WriteLogEntries.
// empty
type WriteLogEntriesResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WriteLogEntriesResponse) Reset()         { *m = WriteLogEntriesResponse{} }
func (m *WriteLogEntriesResponse) String() string { return proto.CompactTextString(m) }
func (*WriteLogEntriesResponse) ProtoMessage()    {}
func (*WriteLogEntriesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6a8ba408154557e4, []int{2}
}

func (m *WriteLogEntriesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WriteLogEntriesResponse.Unmarshal(m, b)
}
func (m *WriteLogEntriesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WriteLogEntriesResponse.Marshal(b, m, deterministic)
}
func (m *WriteLogEntriesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WriteLogEntriesResponse.Merge(m, src)
}
func (m *WriteLogEntriesResponse) XXX_Size() int {
	return xxx_messageInfo_WriteLogEntriesResponse.Size(m)
}
func (m *WriteLogEntriesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_WriteLogEntriesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_WriteLogEntriesResponse proto.InternalMessageInfo

// Error details for WriteLogEntries with partial success.
type WriteLogEntriesPartialErrors struct {
	// When `WriteLogEntriesRequest.partial_success` is true, records the error
	// status for entries that were not written due to a permanent error, keyed
	// by the entry's zero-based index in `WriteLogEntriesRequest.entries`.
	//
	// Failed requests for which no entries are written will not include
	// per-entry errors.
	LogEntryErrors       map[int32]*status.Status `protobuf:"bytes,1,rep,name=log_entry_errors,json=logEntryErrors,proto3" json:"log_entry_errors,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *WriteLogEntriesPartialErrors) Reset()         { *m = WriteLogEntriesPartialErrors{} }
func (m *WriteLogEntriesPartialErrors) String() string { return proto.CompactTextString(m) }
func (*WriteLogEntriesPartialErrors) ProtoMessage()    {}
func (*WriteLogEntriesPartialErrors) Descriptor() ([]byte, []int) {
	return fileDescriptor_6a8ba408154557e4, []int{3}
}

func (m *WriteLogEntriesPartialErrors) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WriteLogEntriesPartialErrors.Unmarshal(m, b)
}
func (m *WriteLogEntriesPartialErrors) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WriteLogEntriesPartialErrors.Marshal(b, m, deterministic)
}
func (m *WriteLogEntriesPartialErrors) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WriteLogEntriesPartialErrors.Merge(m, src)
}
func (m *WriteLogEntriesPartialErrors) XXX_Size() int {
	return xxx_messageInfo_WriteLogEntriesPartialErrors.Size(m)
}
func (m *WriteLogEntriesPartialErrors) XXX_DiscardUnknown() {
	xxx_messageInfo_WriteLogEntriesPartialErrors.DiscardUnknown(m)
}

var xxx_messageInfo_WriteLogEntriesPartialErrors proto.InternalMessageInfo

func (m *WriteLogEntriesPartialErrors) GetLogEntryErrors() map[int32]*status.Status {
	if m != nil {
		return m.LogEntryErrors
	}
	return nil
}

// The parameters to `ListLogEntries`.
type ListLogEntriesRequest struct {
	// Deprecated. Use `resource_names` instead.  One or more project identifiers
	// or project numbers from which to retrieve log entries.  Example:
	// `"my-project-1A"`.
	ProjectIds []string `protobuf:"bytes,1,rep,name=project_ids,json=projectIds,proto3" json:"project_ids,omitempty"` // Deprecated: Do not use.
	// Required. Names of one or more parent resources from which to
	// retrieve log entries:
	//
	//     "projects/[PROJECT_ID]"
	//     "organizations/[ORGANIZATION_ID]"
	//     "billingAccounts/[BILLING_ACCOUNT_ID]"
	//     "folders/[FOLDER_ID]"
	//
	//
	// Projects listed in the `project_ids` field are added to this list.
	ResourceNames []string `protobuf:"bytes,8,rep,name=resource_names,json=resourceNames,proto3" json:"resource_names,omitempty"`
	// Optional. A filter that chooses which log entries to return.  See [Advanced
	// Logs Filters](/logging/docs/view/advanced_filters).  Only log entries that
	// match the filter are returned.  An empty filter matches all log entries in
	// the resources listed in `resource_names`. Referencing a parent resource
	// that is not listed in `resource_names` will cause the filter to return no
	// results.
	// The maximum length of the filter is 20000 characters.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. How the results should be sorted.  Presently, the only permitted
	// values are `"timestamp asc"` (default) and `"timestamp desc"`. The first
	// option returns entries in order of increasing values of
	// `LogEntry.timestamp` (oldest first), and the second option returns entries
	// in order of decreasing timestamps (newest first).  Entries with equal
	// timestamps are returned in order of their `insert_id` values.
	OrderBy string `protobuf:"bytes,3,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Optional. The maximum number of results to return from this request.
	// Non-positive values are ignored.  The presence of `next_page_token` in the
	// response indicates that more results might be available.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. If present, then retrieve the next batch of results from the
	// preceding call to this method.  `page_token` must be the value of
	// `next_page_token` from the previous response.  The values of other method
	// parameters should be identical to those in the previous call.
	PageToken            string   `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListLogEntriesRequest) Reset()         { *m = ListLogEntriesRequest{} }
func (m *ListLogEntriesRequest) String() string { return proto.CompactTextString(m) }
func (*ListLogEntriesRequest) ProtoMessage()    {}
func (*ListLogEntriesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6a8ba408154557e4, []int{4}
}

func (m *ListLogEntriesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListLogEntriesRequest.Unmarshal(m, b)
}
func (m *ListLogEntriesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListLogEntriesRequest.Marshal(b, m, deterministic)
}
func (m *ListLogEntriesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListLogEntriesRequest.Merge(m, src)
}
func (m *ListLogEntriesRequest) XXX_Size() int {
	return xxx_messageInfo_ListLogEntriesRequest.Size(m)
}
func (m *ListLogEntriesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListLogEntriesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListLogEntriesRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *ListLogEntriesRequest) GetProjectIds() []string {
	if m != nil {
		return m.ProjectIds
	}
	return nil
}

func (m *ListLogEntriesRequest) GetResourceNames() []string {
	if m != nil {
		return m.ResourceNames
	}
	return nil
}

func (m *ListLogEntriesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListLogEntriesRequest) GetOrderBy() string {
	if m != nil {
		return m.OrderBy
	}
	return ""
}

func (m *ListLogEntriesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListLogEntriesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Result returned from `ListLogEntries`.
type ListLogEntriesResponse struct {
	// A list of log entries.  If `entries` is empty, `nextPageToken` may still be
	// returned, indicating that more entries may exist.  See `nextPageToken` for
	// more information.
	Entries []*LogEntry `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
	// If there might be more results than those appearing in this response, then
	// `nextPageToken` is included.  To get the next set of results, call this
	// method again using the value of `nextPageToken` as `pageToken`.
	//
	// If a value for `next_page_token` appears and the `entries` field is empty,
	// it means that the search found no log entries so far but it did not have
	// time to search all the possible log entries.  Retry the method with this
	// value for `page_token` to continue the search.  Alternatively, consider
	// speeding up the search by changing your filter to specify a single log name
	// or resource type, or to narrow the time range of the search.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListLogEntriesResponse) Reset()         { *m = ListLogEntriesResponse{} }
func (m *ListLogEntriesResponse) String() string { return proto.CompactTextString(m) }
func (*ListLogEntriesResponse) ProtoMessage()    {}
func (*ListLogEntriesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6a8ba408154557e4, []int{5}
}

func (m *ListLogEntriesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListLogEntriesResponse.Unmarshal(m, b)
}
func (m *ListLogEntriesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListLogEntriesResponse.Marshal(b, m, deterministic)
}
func (m *ListLogEntriesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListLogEntriesResponse.Merge(m, src)
}
func (m *ListLogEntriesResponse) XXX_Size() int {
	return xxx_messageInfo_ListLogEntriesResponse.Size(m)
}
func (m *ListLogEntriesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListLogEntriesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListLogEntriesResponse proto.InternalMessageInfo

func (m *ListLogEntriesResponse) GetEntries() []*LogEntry {
	if m != nil {
		return m.Entries
	}
	return nil
}

func (m *ListLogEntriesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The parameters to ListMonitoredResourceDescriptors
type ListMonitoredResourceDescriptorsRequest struct {
	// Optional. The maximum number of results to return from this request.
	// Non-positive values are ignored.  The presence of `nextPageToken` in the
	// response indicates that more results might be available.
	PageSize int32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. If present, then retrieve the next batch of results from the
	// preceding call to this method.  `pageToken` must be the value of
	// `nextPageToken` from the previous response.  The values of other method
	// parameters should be identical to those in the previous call.
	PageToken            string   `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListMonitoredResourceDescriptorsRequest) Reset() {
	*m = ListMonitoredResourceDescriptorsRequest{}
}
func (m *ListMonitoredResourceDescriptorsRequest) String() string { return proto.CompactTextString(m) }
func (*ListMonitoredResourceDescriptorsRequest) ProtoMessage()    {}
func (*ListMonitoredResourceDescriptorsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6a8ba408154557e4, []int{6}
}

func (m *ListMonitoredResourceDescriptorsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListMonitoredResourceDescriptorsRequest.Unmarshal(m, b)
}
func (m *ListMonitoredResourceDescriptorsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListMonitoredResourceDescriptorsRequest.Marshal(b, m, deterministic)
}
func (m *ListMonitoredResourceDescriptorsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListMonitoredResourceDescriptorsRequest.Merge(m, src)
}
func (m *ListMonitoredResourceDescriptorsRequest) XXX_Size() int {
	return xxx_messageInfo_ListMonitoredResourceDescriptorsRequest.Size(m)
}
func (m *ListMonitoredResourceDescriptorsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListMonitoredResourceDescriptorsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListMonitoredResourceDescriptorsRequest proto.InternalMessageInfo

func (m *ListMonitoredResourceDescriptorsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListMonitoredResourceDescriptorsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Result returned from ListMonitoredResourceDescriptors.
type ListMonitoredResourceDescriptorsResponse struct {
	// A list of resource descriptors.
	ResourceDescriptors []*monitoredres.MonitoredResourceDescriptor `protobuf:"bytes,1,rep,name=resource_descriptors,json=resourceDescriptors,proto3" json:"resource_descriptors,omitempty"`
	// If there might be more results than those appearing in this response, then
	// `nextPageToken` is included.  To get the next set of results, call this
	// method again using the value of `nextPageToken` as `pageToken`.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListMonitoredResourceDescriptorsResponse) Reset() {
	*m = ListMonitoredResourceDescriptorsResponse{}
}
func (m *ListMonitoredResourceDescriptorsResponse) String() string { return proto.CompactTextString(m) }
func (*ListMonitoredResourceDescriptorsResponse) ProtoMessage()    {}
func (*ListMonitoredResourceDescriptorsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6a8ba408154557e4, []int{7}
}

func (m *ListMonitoredResourceDescriptorsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListMonitoredResourceDescriptorsResponse.Unmarshal(m, b)
}
func (m *ListMonitoredResourceDescriptorsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListMonitoredResourceDescriptorsResponse.Marshal(b, m, deterministic)
}
func (m *ListMonitoredResourceDescriptorsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListMonitoredResourceDescriptorsResponse.Merge(m, src)
}
func (m *ListMonitoredResourceDescriptorsResponse) XXX_Size() int {
	return xxx_messageInfo_ListMonitoredResourceDescriptorsResponse.Size(m)
}
func (m *ListMonitoredResourceDescriptorsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListMonitoredResourceDescriptorsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListMonitoredResourceDescriptorsResponse proto.InternalMessageInfo

func (m *ListMonitoredResourceDescriptorsResponse) GetResourceDescriptors() []*monitoredres.MonitoredResourceDescriptor {
	if m != nil {
		return m.ResourceDescriptors
	}
	return nil
}

func (m *ListMonitoredResourceDescriptorsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The parameters to ListLogs.
type ListLogsRequest struct {
	// Required. The resource name that owns the logs:
	//
	//     "projects/[PROJECT_ID]"
	//     "organizations/[ORGANIZATION_ID]"
	//     "billingAccounts/[BILLING_ACCOUNT_ID]"
	//     "folders/[FOLDER_ID]"
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of results to return from this request.
	// Non-positive values are ignored.  The presence of `nextPageToken` in the
	// response indicates that more results might be available.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. If present, then retrieve the next batch of results from the
	// preceding call to this method.  `pageToken` must be the value of
	// `nextPageToken` from the previous response.  The values of other method
	// parameters should be identical to those in the previous call.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListLogsRequest) Reset()         { *m = ListLogsRequest{} }
func (m *ListLogsRequest) String() string { return proto.CompactTextString(m) }
func (*ListLogsRequest) ProtoMessage()    {}
func (*ListLogsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6a8ba408154557e4, []int{8}
}

func (m *ListLogsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListLogsRequest.Unmarshal(m, b)
}
func (m *ListLogsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListLogsRequest.Marshal(b, m, deterministic)
}
func (m *ListLogsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListLogsRequest.Merge(m, src)
}
func (m *ListLogsRequest) XXX_Size() int {
	return xxx_messageInfo_ListLogsRequest.Size(m)
}
func (m *ListLogsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListLogsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListLogsRequest proto.InternalMessageInfo

func (m *ListLogsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListLogsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListLogsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Result returned from ListLogs.
type ListLogsResponse struct {
	// A list of log names. For example,
	// `"projects/my-project/logs/syslog"` or
	// `"organizations/123/logs/cloudresourcemanager.googleapis.com%2Factivity"`.
	LogNames []string `protobuf:"bytes,3,rep,name=log_names,json=logNames,proto3" json:"log_names,omitempty"`
	// If there might be more results than those appearing in this response, then
	// `nextPageToken` is included.  To get the next set of results, call this
	// method again using the value of `nextPageToken` as `pageToken`.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListLogsResponse) Reset()         { *m = ListLogsResponse{} }
func (m *ListLogsResponse) String() string { return proto.CompactTextString(m) }
func (*ListLogsResponse) ProtoMessage()    {}
func (*ListLogsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6a8ba408154557e4, []int{9}
}

func (m *ListLogsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListLogsResponse.Unmarshal(m, b)
}
func (m *ListLogsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListLogsResponse.Marshal(b, m, deterministic)
}
func (m *ListLogsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListLogsResponse.Merge(m, src)
}
func (m *ListLogsResponse) XXX_Size() int {
	return xxx_messageInfo_ListLogsResponse.Size(m)
}
func (m *ListLogsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListLogsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListLogsResponse proto.InternalMessageInfo

func (m *ListLogsResponse) GetLogNames() []string {
	if m != nil {
		return m.LogNames
	}
	return nil
}

func (m *ListLogsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*DeleteLogRequest)(nil), "google.logging.v2.DeleteLogRequest")
	proto.RegisterType((*WriteLogEntriesRequest)(nil), "google.logging.v2.WriteLogEntriesRequest")
	proto.RegisterMapType((map[string]string)(nil), "google.logging.v2.WriteLogEntriesRequest.LabelsEntry")
	proto.RegisterType((*WriteLogEntriesResponse)(nil), "google.logging.v2.WriteLogEntriesResponse")
	proto.RegisterType((*WriteLogEntriesPartialErrors)(nil), "google.logging.v2.WriteLogEntriesPartialErrors")
	proto.RegisterMapType((map[int32]*status.Status)(nil), "google.logging.v2.WriteLogEntriesPartialErrors.LogEntryErrorsEntry")
	proto.RegisterType((*ListLogEntriesRequest)(nil), "google.logging.v2.ListLogEntriesRequest")
	proto.RegisterType((*ListLogEntriesResponse)(nil), "google.logging.v2.ListLogEntriesResponse")
	proto.RegisterType((*ListMonitoredResourceDescriptorsRequest)(nil), "google.logging.v2.ListMonitoredResourceDescriptorsRequest")
	proto.RegisterType((*ListMonitoredResourceDescriptorsResponse)(nil), "google.logging.v2.ListMonitoredResourceDescriptorsResponse")
	proto.RegisterType((*ListLogsRequest)(nil), "google.logging.v2.ListLogsRequest")
	proto.RegisterType((*ListLogsResponse)(nil), "google.logging.v2.ListLogsResponse")
}

func init() { proto.RegisterFile("google/logging/v2/logging.proto", fileDescriptor_6a8ba408154557e4) }

var fileDescriptor_6a8ba408154557e4 = []byte{
	// 1193 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x56, 0xcf, 0x4f, 0x1b, 0xc7,
	0x17, 0xd7, 0x98, 0xc4, 0xb1, 0x87, 0x6f, 0xc0, 0x99, 0x04, 0xe3, 0xd8, 0x24, 0x18, 0x5b, 0x04,
	0x63, 0x7d, 0xd9, 0x95, 0x5c, 0x45, 0x4a, 0x88, 0x7a, 0x80, 0x04, 0x55, 0x95, 0x48, 0x85, 0x96,
	0x96, 0x48, 0x08, 0xc9, 0x5a, 0x76, 0x87, 0xcd, 0x34, 0xbb, 0x3b, 0xdb, 0x99, 0x59, 0xa8, 0xa9,
	0x72, 0x89, 0xd4, 0xaa, 0x97, 0x9e, 0x7a, 0xe9, 0xb9, 0xb7, 0xf6, 0xd0, 0x63, 0x6f, 0x3d, 0xf6,
	0x92, 0x63, 0xfa, 0x2f, 0xe4, 0x0f, 0x68, 0x6f, 0xbd, 0xb5, 0xda, 0x99, 0x59, 0xb3, 0xfe, 0x01,
	0x98, 0xde, 0xbc, 0xef, 0x7d, 0xe6, 0xbd, 0xf7, 0x79, 0xf3, 0x79, 0x6f, 0x0c, 0x17, 0x3d, 0x4a,
	0x3d, 0x1f, 0x9b, 0x3e, 0xf5, 0x3c, 0x12, 0x7a, 0xe6, 0x71, 0x27, 0xfd, 0x69, 0x44, 0x8c, 0x0a,
	0x8a, 0x6e, 0x29, 0x80, 0x91, 0x5a, 0x8f, 0x3b, 0xd5, 0xa6, 0x3e, 0x63, 0x47, 0xc4, 0x0c, 0x68,
	0x48, 0x04, 0x65, 0xd8, 0xed, 0x32, 0xcc, 0x69, 0xcc, 0x1c, 0xac, 0xce, 0x55, 0x97, 0xc6, 0x06,
	0xee, 0xe2, 0x50, 0xb0, 0x9e, 0x86, 0x3c, 0x38, 0x37, 0x77, 0xd7, 0xa1, 0xe1, 0x11, 0xd1, 0x25,
	0x54, 0xef, 0x6b, 0x9c, 0xfc, 0x3a, 0x8c, 0x8f, 0x4c, 0x37, 0x66, 0xb6, 0x20, 0x34, 0xd4, 0xfe,
	0xda, 0xb0, 0x1f, 0x07, 0x91, 0x48, 0x93, 0x2c, 0x0e, 0x3b, 0x05, 0x09, 0x30, 0x17, 0x76, 0x10,
	0x69, 0xc0, 0xbc, 0x06, 0xb0, 0xc8, 0x31, 0xb9, 0xb0, 0x45, 0xcc, 0xb5, 0x63, 0x21, 0x43, 0xd3,
	0x0e, 0x43, 0x2a, 0x64, 0x4e, 0x3e, 0x74, 0x2c, 0xf1, 0x3a, 0x3e, 0xc1, 0xa1, 0x50, 0x8e, 0xc6,
	0x1a, 0x2c, 0x3d, 0xc3, 0x3e, 0x16, 0x78, 0x9b, 0x7a, 0x16, 0xfe, 0x22, 0xc6, 0x5c, 0xa0, 0xbb,
	0xb0, 0x90, 0x90, 0x0f, 0xed, 0x00, 0x57, 0x40, 0x1d, 0xb4, 0x8a, 0xd6, 0x0d, 0x9f, 0x7a, 0x9f,
	0xd8, 0x01, 0x6e, 0xfc, 0x95, 0x83, 0xe5, 0x17, 0x8c, 0x48, 0xf8, 0x56, 0x28, 0x18, 0xc1, 0xfc,
	0xf2, 0x53, 0xe8, 0x31, 0x2c, 0xa4, 0xfd, 0xae, 0xe4, 0xea, 0xa0, 0x35, 0xdd, 0xb9, 0x67, 0xe8,
	0x8b, 0xb2, 0x23, 0x62, 0x3c, 0x4f, 0x6f, 0xc5, 0xd2, 0x20, 0xab, 0x0f, 0x47, 0xcf, 0x61, 0xde,
	0xb7, 0x0f, 0xb1, 0xcf, 0x2b, 0x53, 0xf5, 0xa9, 0xd6, 0x74, 0xe7, 0xa1, 0x31, 0x72, 0xc3, 0xc6,
	0xf8, 0x82, 0x8c, 0x6d, 0x79, 0x2e, 0x31, 0xf6, 0x2c, 0x1d, 0x04, 0x3d, 0x84, 0x37, 0xb0, 0x42,
	0x55, 0xae, 0xc9, 0x78, 0xb5, 0x31, 0xf1, 0x74, 0xa8, 0x9e, 0x95, 0x62, 0xd1, 0x0a, 0x9c, 0x8d,
	0x6c, 0x26, 0x88, 0xed, 0x77, 0x79, 0xec, 0x38, 0x98, 0xf3, 0xca, 0xf5, 0x3a, 0x68, 0x15, 0xac,
	0x19, 0x6d, 0xde, 0x55, 0x56, 0x34, 0x0f, 0x6f, 0xb8, 0xac, 0xd7, 0x65, 0x71, 0x58, 0xc9, 0x4b,
	0x40, 0xde, 0x65, 0x3d, 0x2b, 0x0e, 0xab, 0x8f, 0xe1, 0x74, 0xa6, 0x1e, 0x54, 0x82, 0x53, 0xaf,
	0x70, 0x4f, 0xf7, 0x29, 0xf9, 0x89, 0xee, 0xc0, 0xeb, 0xc7, 0xb6, 0x1f, 0xab, 0x06, 0x15, 0x2d,
	0xf5, 0xb1, 0x9e, 0x7b, 0x04, 0x1a, 0x77, 0xe1, 0xfc, 0x08, 0x43, 0x1e, 0xd1, 0x90, 0xe3, 0xc6,
	0x7b, 0x00, 0x17, 0x86, 0x7c, 0x3b, 0xaa, 0xa0, 0x2d, 0xc6, 0x28, 0xe3, 0x28, 0x80, 0xa5, 0xbe,
	0x8e, 0xbb, 0x58, 0xda, 0x2a, 0x40, 0x12, 0x7f, 0x7a, 0x79, 0x23, 0x07, 0x42, 0xf5, 0xbb, 0xa2,
	0x3e, 0x55, 0x83, 0x66, 0xfc, 0x01, 0x63, 0xf5, 0x33, 0x78, 0x7b, 0x0c, 0x2c, 0xcb, 0xf6, 0xba,
	0x62, 0xdb, 0xca, 0xb2, 0x9d, 0xee, 0xa0, 0xb4, 0x18, 0x16, 0x39, 0xc6, 0xae, 0x94, 0x75, 0xb6,
	0x03, 0xef, 0x00, 0x9c, 0xdb, 0x26, 0x5c, 0x8c, 0x8a, 0xae, 0x09, 0xa7, 0x23, 0x46, 0x3f, 0xc7,
	0x8e, 0xe8, 0x12, 0x57, 0x51, 0x2b, 0x6e, 0xe6, 0x2a, 0xc0, 0x82, 0xda, 0xfc, 0xb1, 0xcb, 0xd1,
	0x32, 0x9c, 0x49, 0xf5, 0x24, 0xe5, 0xc9, 0x2b, 0x85, 0x04, 0x67, 0xdd, 0x4c, 0xad, 0x89, 0x48,
	0x39, 0x2a, 0xc3, 0xfc, 0x11, 0xf1, 0x05, 0x66, 0xfa, 0x0a, 0xf4, 0x57, 0x22, 0x6c, 0xca, 0x5c,
	0xcc, 0xba, 0x87, 0xbd, 0xca, 0x94, 0x12, 0xb6, 0xfc, 0xde, 0xec, 0xa1, 0x1a, 0x2c, 0x46, 0xb6,
	0x87, 0xbb, 0x9c, 0x9c, 0xe2, 0xca, 0x35, 0x49, 0xaf, 0x90, 0x18, 0x76, 0xc9, 0x29, 0x46, 0xf7,
	0x20, 0x94, 0x4e, 0x41, 0x5f, 0xe1, 0x50, 0xea, 0xa5, 0x68, 0x49, 0xf8, 0xa7, 0x89, 0xa1, 0x71,
	0x02, 0xcb, 0xc3, 0x9c, 0xd4, 0xad, 0x66, 0x45, 0x0a, 0xae, 0x20, 0xd2, 0x07, 0x70, 0x36, 0xc4,
	0x5f, 0x8a, 0x6e, 0x26, 0xa9, 0x22, 0x72, 0x33, 0x31, 0xef, 0xf4, 0x13, 0x63, 0xb8, 0x92, 0x24,
	0x1e, 0x99, 0xba, 0x67, 0x98, 0x3b, 0x8c, 0x44, 0x82, 0xb2, 0x7e, 0x7b, 0x07, 0xf8, 0x81, 0x0b,
	0xf9, 0xe5, 0x86, 0xf9, 0xfd, 0x02, 0x60, 0xeb, 0xf2, 0x3c, 0x9a, 0xf2, 0x3e, 0xbc, 0xd3, 0xbf,
	0x22, 0xf7, 0xcc, 0xaf, 0xf9, 0xaf, 0x5c, 0xb8, 0x2d, 0xce, 0xe2, 0x59, 0xb7, 0xd9, 0x68, 0x8e,
	0x2b, 0xf4, 0x65, 0x56, 0x5f, 0x48, 0x9f, 0x7f, 0x19, 0xe6, 0x23, 0x9b, 0xe1, 0x50, 0xe8, 0x49,
	0xd5, 0x5f, 0x83, 0x7d, 0xc9, 0x5d, 0xd8, 0x97, 0xa9, 0xe1, 0xbe, 0xbc, 0x80, 0xa5, 0xb3, 0x34,
	0x9a, 0x7e, 0x0d, 0x16, 0xd3, 0xdd, 0xa9, 0x16, 0x5d, 0xd1, 0x2a, 0xe8, 0xe5, 0x39, 0x71, 0xfd,
	0x9d, 0xaf, 0x21, 0x2c, 0x6d, 0x2b, 0x81, 0xec, 0x62, 0x76, 0x4c, 0x1c, 0xbc, 0xd7, 0x41, 0xdf,
	0xe6, 0x60, 0xb1, 0xbf, 0xe0, 0x51, 0x73, 0x8c, 0x90, 0x86, 0xd7, 0x7f, 0xb5, 0x9c, 0x82, 0xd2,
	0x47, 0xc8, 0xd8, 0x4a, 0x5e, 0xa8, 0xc6, 0x6f, 0xe0, 0xcd, 0x1f, 0xef, 0xbf, 0xcf, 0xfd, 0x0a,
	0xda, 0xf5, 0xe4, 0xf1, 0xfb, 0x2a, 0xad, 0xf8, 0x43, 0x3d, 0x6a, 0xdc, 0x6c, 0x27, 0x2f, 0x22,
	0x37, 0xdb, 0xaf, 0xf7, 0x6b, 0xed, 0xbb, 0x83, 0x98, 0x76, 0xc6, 0xb9, 0xd2, 0x5e, 0x1e, 0x74,
	0x52, 0xe6, 0xd9, 0x21, 0x39, 0x55, 0x2f, 0x56, 0x06, 0xb8, 0xd4, 0x5e, 0x1c, 0x04, 0x1e, 0x51,
	0xdf, 0xc5, 0x2c, 0x0b, 0x59, 0x6d, 0xaf, 0x0c, 0x42, 0x0e, 0x89, 0xef, 0x93, 0xd0, 0xdb, 0x70,
	0x1c, 0x1a, 0x87, 0xd9, 0x9a, 0xd0, 0x37, 0x00, 0xce, 0x0e, 0x6d, 0x38, 0xb4, 0x3a, 0xf1, 0x73,
	0x52, 0x6d, 0x4f, 0x02, 0xd5, 0x7b, 0x79, 0x41, 0x76, 0xaa, 0xdc, 0xb8, 0x95, 0xd4, 0xa6, 0xe7,
	0x73, 0xfd, 0x24, 0x01, 0xaf, 0x83, 0x36, 0x7a, 0x03, 0xe0, 0xcc, 0xe0, 0xe8, 0xa3, 0xd6, 0xb8,
	0x09, 0x1f, 0xb7, 0xf1, 0xaa, 0xab, 0x13, 0x20, 0x75, 0x15, 0x35, 0x59, 0xc5, 0x5c, 0xa3, 0x94,
	0xad, 0xc2, 0x27, 0x5c, 0x24, 0x45, 0xfc, 0x0e, 0x60, 0xfd, 0xb2, 0xf1, 0x44, 0xeb, 0xe7, 0x24,
	0x9b, 0x60, 0x77, 0x54, 0x9f, 0xfc, 0xa7, 0xb3, 0xba, 0xf4, 0x96, 0x2c, 0xbd, 0x81, 0xa4, 0xd2,
	0x82, 0x8b, 0x4a, 0xfc, 0x07, 0xc0, 0x42, 0x3a, 0x4f, 0xa8, 0x71, 0x7e, 0x73, 0xfa, 0x75, 0x35,
	0x2f, 0xc4, 0xe8, 0xfc, 0x3f, 0x29, 0xad, 0xff, 0x08, 0xd0, 0x9c, 0x94, 0x97, 0x9a, 0xfb, 0x44,
	0xc5, 0xaf, 0xa5, 0x9e, 0xf6, 0xef, 0xa3, 0x85, 0xac, 0xe3, 0x6c, 0x04, 0xb4, 0xbf, 0x89, 0x96,
	0xb2, 0xfe, 0x21, 0x85, 0x6b, 0xd0, 0x3d, 0x54, 0xcb, 0x82, 0xfa, 0xea, 0xd6, 0xee, 0x65, 0xd4,
	0xcc, 0xba, 0x47, 0x94, 0xad, 0x60, 0xd5, 0xef, 0x72, 0x6f, 0x37, 0xca, 0x29, 0x19, 0xc5, 0xcd,
	0x8e, 0x08, 0x37, 0x1c, 0x1a, 0xbc, 0xdb, 0xf8, 0x13, 0xbc, 0x14, 0x22, 0xe2, 0xeb, 0xa6, 0x79,
	0x72, 0x72, 0x32, 0xe4, 0x35, 0xed, 0x58, 0xbc, 0x34, 0x1d, 0x9f, 0xc6, 0xee, 0x5a, 0xe4, 0xdb,
	0xe2, 0x88, 0xb2, 0xe0, 0xff, 0x57, 0x83, 0x1b, 0x0c, 0xdb, 0xee, 0x1a, 0x0d, 0xfd, 0xde, 0xa5,
	0x07, 0xd3, 0x0a, 0x6d, 0x37, 0x20, 0xe1, 0xc4, 0xe8, 0x24, 0xfe, 0xc4, 0x60, 0x39, 0x61, 0x9b,
	0x3f, 0x00, 0x38, 0xe7, 0xd0, 0x60, 0xf4, 0x9a, 0x37, 0xff, 0xa7, 0xd7, 0xe3, 0x4e, 0xb2, 0xd8,
	0x76, 0xc0, 0xfe, 0x23, 0x0d, 0xf1, 0xa8, 0x6f, 0x87, 0x9e, 0x41, 0x99, 0x67, 0x7a, 0x38, 0x94,
	0x6b, 0xcf, 0x3c, 0xcb, 0x93, 0xf9, 0xc7, 0xff, 0x44, 0xff, 0xfc, 0x1b, 0x80, 0x9f, 0x73, 0xf3,
	0x1f, 0xa9, 0xd3, 0x4f, 0x93, 0x8e, 0x18, 0x3a, 0xb4, 0xb1, 0xd7, 0x79, 0x9b, 0x7a, 0x0e, 0xa4,
	0xe7, 0x40, 0x7b, 0x0e, 0xf6, 0x3a, 0x87, 0x79, 0x19, 0xfb, 0x83, 0x7f, 0x03, 0x00, 0x00, 0xff,
	0xff, 0xec, 0xaf, 0x27, 0x27, 0xc8, 0x0c, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// LoggingServiceV2Client is the client API for LoggingServiceV2 service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type LoggingServiceV2Client interface {
	// Deletes all the log entries in a log.
	// The log reappears if it receives new entries.
	// Log entries written shortly before the delete operation might not be
	// deleted.
	DeleteLog(ctx context.Context, in *DeleteLogRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Writes log entries to Logging. This API method is the
	// only way to send log entries to Logging. This method
	// is used, directly or indirectly, by the Logging agent
	// (fluentd) and all logging libraries configured to use Logging.
	// A single request may contain log entries for a maximum of 1000
	// different resources (projects, organizations, billing accounts or
	// folders)
	WriteLogEntries(ctx context.Context, in *WriteLogEntriesRequest, opts ...grpc.CallOption) (*WriteLogEntriesResponse, error)
	// Lists log entries.  Use this method to retrieve log entries that originated
	// from a project/folder/organization/billing account.  For ways to export log
	// entries, see [Exporting Logs](/logging/docs/export).
	ListLogEntries(ctx context.Context, in *ListLogEntriesRequest, opts ...grpc.CallOption) (*ListLogEntriesResponse, error)
	// Lists the descriptors for monitored resource types used by Logging.
	ListMonitoredResourceDescriptors(ctx context.Context, in *ListMonitoredResourceDescriptorsRequest, opts ...grpc.CallOption) (*ListMonitoredResourceDescriptorsResponse, error)
	// Lists the logs in projects, organizations, folders, or billing accounts.
	// Only logs that have entries are listed.
	ListLogs(ctx context.Context, in *ListLogsRequest, opts ...grpc.CallOption) (*ListLogsResponse, error)
}

type loggingServiceV2Client struct {
	cc *grpc.ClientConn
}

func NewLoggingServiceV2Client(cc *grpc.ClientConn) LoggingServiceV2Client {
	return &loggingServiceV2Client{cc}
}

func (c *loggingServiceV2Client) DeleteLog(ctx context.Context, in *DeleteLogRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.logging.v2.LoggingServiceV2/DeleteLog", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *loggingServiceV2Client) WriteLogEntries(ctx context.Context, in *WriteLogEntriesRequest, opts ...grpc.CallOption) (*WriteLogEntriesResponse, error) {
	out := new(WriteLogEntriesResponse)
	err := c.cc.Invoke(ctx, "/google.logging.v2.LoggingServiceV2/WriteLogEntries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *loggingServiceV2Client) ListLogEntries(ctx context.Context, in *ListLogEntriesRequest, opts ...grpc.CallOption) (*ListLogEntriesResponse, error) {
	out := new(ListLogEntriesResponse)
	err := c.cc.Invoke(ctx, "/google.logging.v2.LoggingServiceV2/ListLogEntries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *loggingServiceV2Client) ListMonitoredResourceDescriptors(ctx context.Context, in *ListMonitoredResourceDescriptorsRequest, opts ...grpc.CallOption) (*ListMonitoredResourceDescriptorsResponse, error) {
	out := new(ListMonitoredResourceDescriptorsResponse)
	err := c.cc.Invoke(ctx, "/google.logging.v2.LoggingServiceV2/ListMonitoredResourceDescriptors", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *loggingServiceV2Client) ListLogs(ctx context.Context, in *ListLogsRequest, opts ...grpc.CallOption) (*ListLogsResponse, error) {
	out := new(ListLogsResponse)
	err := c.cc.Invoke(ctx, "/google.logging.v2.LoggingServiceV2/ListLogs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// LoggingServiceV2Server is the server API for LoggingServiceV2 service.
type LoggingServiceV2Server interface {
	// Deletes all the log entries in a log.
	// The log reappears if it receives new entries.
	// Log entries written shortly before the delete operation might not be
	// deleted.
	DeleteLog(context.Context, *DeleteLogRequest) (*empty.Empty, error)
	// Writes log entries to Logging. This API method is the
	// only way to send log entries to Logging. This method
	// is used, directly or indirectly, by the Logging agent
	// (fluentd) and all logging libraries configured to use Logging.
	// A single request may contain log entries for a maximum of 1000
	// different resources (projects, organizations, billing accounts or
	// folders)
	WriteLogEntries(context.Context, *WriteLogEntriesRequest) (*WriteLogEntriesResponse, error)
	// Lists log entries.  Use this method to retrieve log entries that originated
	// from a project/folder/organization/billing account.  For ways to export log
	// entries, see [Exporting Logs](/logging/docs/export).
	ListLogEntries(context.Context, *ListLogEntriesRequest) (*ListLogEntriesResponse, error)
	// Lists the descriptors for monitored resource types used by Logging.
	ListMonitoredResourceDescriptors(context.Context, *ListMonitoredResourceDescriptorsRequest) (*ListMonitoredResourceDescriptorsResponse, error)
	// Lists the logs in projects, organizations, folders, or billing accounts.
	// Only logs that have entries are listed.
	ListLogs(context.Context, *ListLogsRequest) (*ListLogsResponse, error)
}

func RegisterLoggingServiceV2Server(s *grpc.Server, srv LoggingServiceV2Server) {
	s.RegisterService(&_LoggingServiceV2_serviceDesc, srv)
}

func _LoggingServiceV2_DeleteLog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteLogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LoggingServiceV2Server).DeleteLog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.LoggingServiceV2/DeleteLog",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LoggingServiceV2Server).DeleteLog(ctx, req.(*DeleteLogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LoggingServiceV2_WriteLogEntries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WriteLogEntriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LoggingServiceV2Server).WriteLogEntries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.LoggingServiceV2/WriteLogEntries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LoggingServiceV2Server).WriteLogEntries(ctx, req.(*WriteLogEntriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LoggingServiceV2_ListLogEntries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListLogEntriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LoggingServiceV2Server).ListLogEntries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.LoggingServiceV2/ListLogEntries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LoggingServiceV2Server).ListLogEntries(ctx, req.(*ListLogEntriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LoggingServiceV2_ListMonitoredResourceDescriptors_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMonitoredResourceDescriptorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LoggingServiceV2Server).ListMonitoredResourceDescriptors(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.LoggingServiceV2/ListMonitoredResourceDescriptors",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LoggingServiceV2Server).ListMonitoredResourceDescriptors(ctx, req.(*ListMonitoredResourceDescriptorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LoggingServiceV2_ListLogs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListLogsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LoggingServiceV2Server).ListLogs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.LoggingServiceV2/ListLogs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LoggingServiceV2Server).ListLogs(ctx, req.(*ListLogsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _LoggingServiceV2_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.logging.v2.LoggingServiceV2",
	HandlerType: (*LoggingServiceV2Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "DeleteLog",
			Handler:    _LoggingServiceV2_DeleteLog_Handler,
		},
		{
			MethodName: "WriteLogEntries",
			Handler:    _LoggingServiceV2_WriteLogEntries_Handler,
		},
		{
			MethodName: "ListLogEntries",
			Handler:    _LoggingServiceV2_ListLogEntries_Handler,
		},
		{
			MethodName: "ListMonitoredResourceDescriptors",
			Handler:    _LoggingServiceV2_ListMonitoredResourceDescriptors_Handler,
		},
		{
			MethodName: "ListLogs",
			Handler:    _LoggingServiceV2_ListLogs_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/logging/v2/logging.proto",
}
