.TH w0vncserver 1 "" "TigerVNC" "TigerVNC Manual"
.SH NAME
w0vncserver \- TigerVNC server for Wayland compositors
.SH SYNOPSIS
.B w0vncserver
.RI [ options ]
.br
.B w0vncserver -version
.SH DESCRIPTION
.B w0vncserver
is a TigerVNC server which makes a Wayland compositor that is based on
wlroots, or has the RemoteDesktop portal implemented, remotely
accessible via VNC, TigerVNC or compatible viewers. It does not create
a virtual display, instead, it shares an existing display (typically,
hat one connected to the physical screen).

.SH OPTIONS
.B w0vncserver
interprets the command line as a list of parameters with optional values.
Running \fBw0vncserver \-h\fP will show a list of all valid parameters with
short descriptions.  All parameters are optional, but normally you would have
to use the \fBPasswordFile\fP parameter (see its description below).
.PP
There are several forms of specifying parameters in the command line (here we
use `\fISomeParameter\fP' as an example parameter name):

.TP
.B -\fISomeParameter\fP
Enable the parameter, turn the feature on.  This form can be used with
parameters that simply enable or disable some feature.
.
.TP
.B -\fISomeParameter\fP=0
Disable the parameter, turn the feature off.
.
.TP
.B -\fISomeParameter\fP=\fIvalue\fP
Assign the specified \fIvalue\fP to the parameter.  The leading dash can be
omitted, or it can be doubled if desired (like in GNU-style long options).
.PP
Parameter names are case-insensitive, their order in the command line can be
arbitrary.

.SH PARAMETERS

.TP
.B \-AcceptKeyEvents
Accept key press and release events from clients. Default is on.
.
.TP
.B \-AcceptPointerEvents
Accept pointer movement and button events from clients. Default is on.
.
.TP
.B \-AlwaysShared
Always treat incoming connections as shared, regardless of the client-specified
setting. Default is off.
.
.TP
.B \-AskDisplayChoice \fImode\fP
Ask which displays to share when a user connects. Can be either
\fBAlways\fP, \fBOnce\fP, or \fBNever\fP. Choosing \fBAlways\fP means a
prompt dialog will be be shown every time a user connects to the server.
\fBOnce\fP means a prompt will be shown only once during the program's
lifetime. When choosing \fBNever\fP, the choice you make will be
remembered and persist. To reset your choice, see
\fBw0vncserver-forget\fP(1). Default is \fBOnce\fP.
.
.TP
.B \-BlacklistThreshold \fIcount\fP
The number of unauthenticated connection attempts allowed from any individual
host before that host is black-listed.  Default is 5.
.
.TP
.B \-BlacklistTimeout \fIseconds\fP
The initial timeout applied when a host is first black-listed.  The host
cannot re-attempt a connection until the timeout expires.  Default is 10.
.
.TP
.B \-CompareFB \fImode\fP
Perform pixel comparison on framebuffer to reduce unnecessary updates. Can
be either \fB0\fP (off), \fB1\fP (always) or \fB2\fP (auto). Default is
\fB2\fP.
.
.TP
.B \-desktop \fIdesktop-name\fP
Each desktop has a name which may be displayed by the viewer. It defaults to
"<user>@<hostname>".
.
.TP
.B \-DisconnectClients
Disconnect existing clients if an incoming connection is non-shared. Default is
on. If \fBDisconnectClients\fP is false, then a new non-shared connection will
be refused while there is a client active.  When combined with
\fBNeverShared\fP this means only one client is allowed at a time.
.
.TP
.B \-FrameRate \fIfps\fP
The maximum number of updates per second sent to each client. If the screen
updates any faster then those changes will be aggregated and sent in a single
update to the client. Note that this only controls the maximum rate and a
client may get a lower rate when resources are limited. Default is \fB60\fP.
.
.TP
.B \-Geometry \fIgeometry\fP
This option specifies the screen area that will be shown to VNC clients.  The
format is
.B \fIwidth\fPx\fIheight\fP+\fIxoffset\fP+\fIyoffset\fP
, where `+' signs can be replaced with `\-' signs to specify offsets from the
right and/or from the bottom of the screen.  Offsets are optional, +0+0 is
assumed by default (top left corner).  If the argument is empty, full screen
is shown to VNC clients (this is the default).
.
.TP
.B \-GnuTLSPriority \fIpriority\fP
GnuTLS priority string that controls the TLS session’s handshake algorithms.
See the GnuTLS manual for possible values. Default is \fBNORMAL\fP.
.
.TP
.B \-IdleTimeout \fIseconds\fP
The number of seconds after which an idle VNC connection will be dropped.
Default is 0, which means that idle connections will never be dropped.
.
.TP
.B \-ImprovedHextile
Use improved compression algorithm for Hextile encoding which achieves better
compression ratios by the cost of using slightly more CPU time.  Default is
on.
.
.TP
.B \-interface \fIIP address\fP
Listen on interface. By default w0vncserver listens on all available interfaces.
.
.TP
.B \-localhost
Only allow connections from the same machine. Useful if you use SSH and want to
stop non-SSH connections from any other hosts.
.
.TP
.B \-Log \fIlogname\fP:\fIdest\fP:\fIlevel\fP[, ...]
Configures the debug log settings.  \fIdest\fP can currently be \fBstderr\fP,
\fBstdout\fP or \fBsyslog\fP, and \fIlevel\fP is between 0 and 100, 100 meaning
most verbose output.  \fIlogname\fP is usually \fB*\fP meaning all, but you can
target a specific source file if you know the name of its "LogWriter".  Default
is \fB*:stderr:30\fP.
.
.TP
.B \-MaxConnectionTime \fIseconds\fP
Terminate when a client has been connected for \fIN\fP seconds.  Default is
0.
.
.TP
.B \-MaxDisconnectionTime \fIseconds\fP
Terminate when no client has been connected for \fIN\fP seconds.  Default is
0.
.
.TP
.B \-MaxIdleTime \fIseconds\fP
Terminate after \fIN\fP seconds of user inactivity.  Default is 0.
.
.TP
.B \-NeverShared
Never treat incoming connections as shared, regardless of the client-specified
setting. Default is off.
.
.TP
.B \-pam_service \fIname\fP, \-PAMService \fIname\fP
PAM service name to use when authentication users using any of the "Plain"
security types. Default is \fBvnc\fP.
.
.TP
.B \-Password \fIpassword\fP
Obfuscated binary encoding of the password which clients must supply to
access the server.  Using this parameter is insecure, use \fBPasswordFile\fP
parameter instead.
.
.TP
.B \-PasswordFile \fIpasswd-file\fP, \-rfbauth \fIpasswd-file\fP
Password file for VNC authentication.  There is no default, you should
specify the password file explicitly.  Password file should be created with
the \fBvncpasswd\fP(1) utility.  The file is accessed each time a connection
comes in, so it can be changed on the fly.
.
.TP
.B \-PlainUsers \fIuser-list\fP
A comma separated list of user names that are allowed to authenticate via
any of the "Plain" security types (Plain, TLSPlain, etc.). Specify \fB*\fP
to allow any user to authenticate using this security type. Specify \fB%u\fP
to allow the user of the server process. Default is to deny all users.
.
.TP
.B \-Protocol3.3
Always use protocol version 3.3 for backwards compatibility with badly-behaved
clients. Default is off.
.
.TP
.B \-QueryConnect
Prompts the user of the desktop to explicitly accept or reject incoming
connections. Default is off.
.
.TP
.B \-RawKeyboard
Send keyboard events straight through and avoid mapping them to the current
keyboard layout. This effectively makes the keyboard behave according to the
layout configured on the server instead of the layout configured on the
client. Default is off.
.
.TP
.B \-RemapKeys \fImapping
Sets up a keyboard mapping.
.I mapping
is a comma-separated string of character mappings, each of the form
.IR char -> char ,
or
.IR char <> char ,
where
.I char
is a hexadecimal keysym. For example, to exchange the " and @ symbols you would specify the following:

.RS 10
RemapKeys=0x22<>0x40
.RE
.
.TP
.B \-RequireUsername
Require username for the RSA-AES security types. Default is off.
.
.TP
.B \-rfbport \fIport\fP
Specifies the TCP port on which w0vncserver listens for connections from
viewers (the protocol used in VNC is called RFB - "remote framebuffer").
Specify \fB-1\fP to disable listening on a TCP port. The default port is
5900 when started directly, and -1 when activated by a systemd socket.
.
.TP
.B \-rfbunixmode \fImode\fP
Specifies the mode of the Unix domain socket.  The default is 0600.
.
.TP
.B \-rfbunixpath \fIpath\fP
Specifies the path of a Unix domain socket on which w0vncserver listens for
connections from viewers. Default is to not listen to any Unix domain
socket.
.
.TP
.B \-RSAKey \fIpath\fP
Path to the RSA key for the RSA-AES security types (\fBRA2\fP, \fBRA2ne\fP,
\fBRA2_256\fP and \fBRA2ne_256\fP) in PEM format.
.
.TP
.B \-SecurityTypes \fIsec-types\fP
Specify which security scheme to use for incoming connections.  Valid values
are a comma separated list of \fBNone\fP, \fBVncAuth\fP, \fBPlain\fP,
\fBTLSNone\fP, \fBTLSVnc\fP, \fBTLSPlain\fP, \fBX509None\fP, \fBX509Vnc\fP,
\fBX509Plain\fP, \fBRA2\fP, \fBRA2ne\fP, \fBRA2_256\fP and \fBRA2ne_256\fP.
Default is \fBTLSVnc,VncAuth\fP.
.
.TP
.B \-UseBlacklist
Temporarily reject connections from a host if it repeatedly fails to
authenticate. Default is on.
.
.TP
.B \-UseIPv4
Use IPv4 for incoming and outgoing connections. Default is on.
.
.TP
.B \-UseIPv6
Use IPv6 for incoming and outgoing connections. Default is on.
.
.TP
.B \-X509Cert \fIpath\fP
Path to a X509 certificate in PEM format to be used for all X509 based
security types (X509None, X509Vnc, etc.).
.
.TP
.B \-X509Key \fIpath\fP
Private key counter part to the certificate given in \fBX509Cert\fP. Must
also be in PEM format.

.SH SEE ALSO
.BR w0vncserver-forget (1),
.BR x0vncserver (1),
.BR Xvnc (1),
.BR vncpasswd (1),
.br
https://www.tigervnc.org/

.SH AUTHOR
TigerVNC Team

VNC was originally developed by the RealVNC team while at Olivetti
Research Ltd / AT&T Laboratories Cambridge.  TightVNC additions were
implemented by Constantin Kaplinsky. Many other people have since
participated in development, testing and support. This manual is part
of the TigerVNC software suite.
