/*
 * Decompiled with CFR 0.152.
 */
package coursier.cache;

import coursier.cache.AuthenticatedURLConnection;
import coursier.cache.CacheUrl;
import coursier.cache.CacheUrl$BasicRealm$;
import coursier.cache.ConnectionBuilder$;
import coursier.core.Authentication;
import coursier.credentials.DirectCredentials;
import java.io.InputStream;
import java.io.Serializable;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import scala.$less$colon$less$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class CacheUrl$ {
    public static final CacheUrl$ MODULE$ = new CacheUrl$();
    private static final ConcurrentHashMap<String, Option<URLStreamHandler>> handlerClsCache = new ConcurrentHashMap();

    private ConcurrentHashMap<String, Option<URLStreamHandler>> handlerClsCache() {
        return handlerClsCache;
    }

    private Option<URLStreamHandler> handlerFor(String url, Seq<ClassLoader> classLoaders) {
        String protocol = StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(url), (Function1<Object, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(CacheUrl$.$anonfun$handlerFor$1(BoxesRunTime.unboxToChar(x$1))));
        Option<Option<URLStreamHandler>> option = Option$.MODULE$.apply(this.handlerClsCache().get(protocol));
        if (None$.MODULE$.equals(option)) {
            String clsName = new $colon$colon<Nothing$>((Nothing$)((Object)"coursier"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"cache"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"protocol"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new StringBuilder(7).append(StringOps$.MODULE$.capitalize$extension(Predef$.MODULE$.augmentString(protocol))).append("Handler").toString()), Nil$.MODULE$)))).mkString(".");
            Iterator allLoaders = classLoaders.iterator().$plus$plus((Function0<Iterator> & Serializable)() -> package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClassLoader[]{Thread.currentThread().getContextClassLoader(), MODULE$.getClass().getClassLoader()})));
            Option clsOpt0 = allLoaders.flatMap((Function1<ClassLoader, Iterator> & Serializable)x$2 -> CacheUrl$.clsOpt$1(x$2, clsName).iterator()).find((Function1<Class, Object> & Serializable)x$3 -> BoxesRunTime.boxToBoolean(CacheUrl$.$anonfun$handlerFor$4(x$3)));
            Option handlerFactoryOpt = clsOpt0.flatMap((Function1<Class, Option> & Serializable)cls -> {
                Option option;
                try {
                    option = new Some<URLStreamHandlerFactory>((URLStreamHandlerFactory)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (InstantiationException e) {
                    CacheUrl$.printError$1(e, clsName);
                    option = None$.MODULE$;
                }
                catch (IllegalAccessException e) {
                    CacheUrl$.printError$1(e, clsName);
                    option = None$.MODULE$;
                }
                catch (ClassCastException e) {
                    CacheUrl$.printError$1(e, clsName);
                    option = None$.MODULE$;
                }
                return option;
            });
            Option handlerOpt = handlerFactoryOpt.flatMap((Function1<URLStreamHandlerFactory, Option> & Serializable)factory -> {
                Option option;
                try {
                    option = new Some<URLStreamHandler>(factory.createURLStreamHandler(protocol));
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable throwable3 = throwable;
                    if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                        Console$.MODULE$.err().println(new StringBuilder(31).append("Cannot get handler for ").append(protocol).append(" from ").append(clsName).append(": ").append(throwable2.toString()).append(Option$.MODULE$.apply(throwable2.getMessage()).fold((Function0<String> & Serializable)() -> "", (Function1<String, String> & Serializable)x$5 -> new StringBuilder(3).append(" (").append((String)x$5).append(")").toString())).toString());
                        option = None$.MODULE$;
                    }
                    throw throwable;
                }
                return option;
            });
            Option prevOpt = Option$.MODULE$.apply(this.handlerClsCache().putIfAbsent(protocol, handlerOpt));
            return (Option)prevOpt.getOrElse((Function0<Option> & Serializable)() -> handlerOpt);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Option handlerOpt = (Option)some.value();
            return handlerOpt;
        }
        throw new MatchError(option);
    }

    public URL url(String s, Seq<ClassLoader> classLoaders) {
        return new URL(null, s, (URLStreamHandler)this.handlerFor(s, classLoaders).orNull($less$colon$less$.MODULE$.refl()));
    }

    public URL url(String s) {
        return new URL(null, s, (URLStreamHandler)this.handlerFor(s, Nil$.MODULE$).orNull($less$colon$less$.MODULE$.refl()));
    }

    public String basicAuthenticationEncode(String user, String password) {
        return Base64.getEncoder().encodeToString(new StringBuilder(1).append(user).append(":").append(password).toString().getBytes(StandardCharsets.UTF_8));
    }

    private int partialContentResponseCode() {
        return 206;
    }

    private int invalidPartialContentResponseCode() {
        return 416;
    }

    private void initialize(URLConnection conn, Option<Authentication> authentication, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, String method) {
        URLConnection uRLConnection = conn;
        if (uRLConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            String string = method;
            String string2 = "GET";
            if (string == null ? string2 != null : !string.equals(string2)) {
                httpURLConnection.setRequestMethod(method);
            }
            httpURLConnection.setInstanceFollowRedirects(false);
            httpURLConnection.setRequestProperty("User-Agent", "Coursier/2.0");
            httpURLConnection.setRequestProperty("Accept", "*/*");
            HttpURLConnection httpURLConnection2 = httpURLConnection;
            if (httpURLConnection2 instanceof HttpsURLConnection) {
                HttpsURLConnection httpsURLConnection = (HttpsURLConnection)httpURLConnection2;
                sslSocketFactoryOpt.foreach((Function1<SSLSocketFactory, Object> & Serializable)f -> {
                    httpsURLConnection.setSSLSocketFactory(f);
                    return BoxedUnit.UNIT;
                });
                hostnameVerifierOpt.foreach((Function1<HostnameVerifier, Object> & Serializable)v -> {
                    httpsURLConnection.setHostnameVerifier(v);
                    return BoxedUnit.UNIT;
                });
            }
        }
        authentication.foreach((Function1<Authentication, Object> & Serializable)auth -> {
            CacheUrl$.$anonfun$initialize$3(conn, auth);
            return BoxedUnit.UNIT;
        });
    }

    private Option<String> redirectTo(URLConnection conn) {
        URLConnection uRLConnection = conn;
        if (uRLConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            int c = httpURLConnection.getResponseCode();
            if (c == 301 || c == 302 || c == 303 || c == 304 || c == 307 || c == 308) {
                return Option$.MODULE$.apply(httpURLConnection.getHeaderField("Location"));
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    private Option<String> redirect(String url, URLConnection conn, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections) {
        return this.redirectTo(conn).map((Function1<String, String> & Serializable)loc -> new URI(url).resolve((String)loc).toASCIIString()).filter((Function1<String, Object> & Serializable)target -> BoxesRunTime.boxToBoolean(CacheUrl$.$anonfun$redirect$2(url, followHttpToHttpsRedirections, followHttpsToHttpRedirections, target)));
    }

    private Option<Object> rangeResOpt(URLConnection conn, long alreadyDownloaded) {
        if (alreadyDownloaded > 0L) {
            URLConnection uRLConnection = conn;
            if (uRLConnection instanceof HttpURLConnection) {
                boolean hasMatchingHeader;
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                httpURLConnection.setRequestProperty("Range", new StringBuilder(7).append("bytes=").append(alreadyDownloaded).append("-").toString());
                boolean isPartial = httpURLConnection.getResponseCode() == this.partialContentResponseCode() || httpURLConnection.getResponseCode() == this.invalidPartialContentResponseCode();
                boolean startOver = isPartial && !(hasMatchingHeader = Option$.MODULE$.apply(httpURLConnection.getHeaderField("Content-Range")).exists((Function1<String, Object> & Serializable)x$7 -> BoxesRunTime.boxToBoolean(x$7.startsWith(new StringBuilder(7).append("bytes ").append(alreadyDownloaded).append("-").toString()))));
                return new Some<Object>(BoxesRunTime.boxToBoolean(startOver));
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    private boolean is4xx(URLConnection conn) {
        URLConnection uRLConnection = conn;
        if (uRLConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            int c = httpURLConnection.getResponseCode();
            return c / 100 == 4;
        }
        return false;
    }

    public URLConnection urlConnection(String url0, Option<Authentication> authentication, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Seq<DirectCredentials> credentials, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, String method, Option<Object> maxRedirectionsOpt) {
        return ConnectionBuilder$.MODULE$.apply(url0, authentication, 0L, followHttpToHttpsRedirections, followHttpsToHttpRedirections, credentials, sslSocketFactoryOpt, hostnameVerifierOpt, method, maxRedirectionsOpt, None$.MODULE$, Nil$.MODULE$).connection();
    }

    public boolean urlConnection$default$3() {
        return false;
    }

    public boolean urlConnection$default$4() {
        return false;
    }

    public Seq<DirectCredentials> urlConnection$default$5() {
        return Nil$.MODULE$;
    }

    public Option<SSLSocketFactory> urlConnection$default$6() {
        return None$.MODULE$;
    }

    public Option<HostnameVerifier> urlConnection$default$7() {
        return None$.MODULE$;
    }

    public String urlConnection$default$8() {
        return "GET";
    }

    public Option<Object> urlConnection$default$9() {
        return new Some<Object>(BoxesRunTime.boxToInteger(20));
    }

    public Tuple2<URLConnection, Object> urlConnectionMaybePartial(String url0, Option<Authentication> authentication, long alreadyDownloaded, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Seq<DirectCredentials> autoCredentials, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, String method, Option<Object> maxRedirectionsOpt) {
        return ConnectionBuilder$.MODULE$.apply(url0, authentication, alreadyDownloaded, followHttpToHttpsRedirections, followHttpsToHttpRedirections, autoCredentials, sslSocketFactoryOpt, hostnameVerifierOpt, method, maxRedirectionsOpt, None$.MODULE$, Nil$.MODULE$).connectionMaybePartial();
    }

    public Tuple2<URLConnection, Object> urlConnectionMaybePartial(CacheUrl.Args args) {
        Either either;
        while (true) {
            CacheUrl.Args newArgs;
            Either res;
            Either either2;
            block19: {
                URLConnection conn = null;
                try {
                    Some some;
                    boolean bl;
                    Option<Object> rangeResOpt0;
                    URLConnection uRLConnection;
                    URL jnUrl = this.url(args.url0(), args.classLoaders());
                    Option<Proxy> option = args.proxyOpt();
                    if (None$.MODULE$.equals(option)) {
                        uRLConnection = jnUrl.openConnection();
                    } else if (option instanceof Some) {
                        Some some2 = (Some)option;
                        Proxy proxy = (Proxy)some2.value();
                        uRLConnection = jnUrl.openConnection(proxy);
                    } else {
                        throw new MatchError(option);
                    }
                    conn = uRLConnection;
                    Option<Authentication> authOpt = args.authentication().filter((Function1<Authentication, Object> & Serializable)a -> BoxesRunTime.boxToBoolean(CacheUrl$.$anonfun$urlConnectionMaybePartial$1(args, a)));
                    this.initialize(conn, authOpt, args.sslSocketFactoryOpt(), args.hostnameVerifierOpt(), args.method());
                    Option<Object> option2 = rangeResOpt0 = this.rangeResOpt(conn, args.alreadyDownloaded());
                    if (option2 instanceof Some && (bl = BoxesRunTime.unboxToBoolean((some = (Some)option2).value()))) {
                        this.closeConn(conn);
                        long x$1 = 0L;
                        String x$2 = args.copy$default$1();
                        String x$3 = args.copy$default$2();
                        Option<Authentication> x$4 = args.copy$default$3();
                        boolean x$5 = args.copy$default$5();
                        boolean x$6 = args.copy$default$6();
                        Seq<DirectCredentials> x$7 = args.copy$default$7();
                        Option<SSLSocketFactory> x$82 = args.copy$default$8();
                        Option<HostnameVerifier> x$9 = args.copy$default$9();
                        Option<Proxy> x$10 = args.copy$default$10();
                        String x$112 = args.copy$default$11();
                        Option<String> x$12 = args.copy$default$12();
                        int x$13 = args.copy$default$13();
                        Option<Object> x$142 = args.copy$default$14();
                        Seq<ClassLoader> x$15 = args.copy$default$15();
                        either2 = new Left(args.copy(x$2, x$3, x$4, 0L, x$5, x$6, x$7, x$82, x$9, x$10, x$112, x$12, x$13, x$142, x$15));
                        break block19;
                    }
                    boolean partialDownload = rangeResOpt0.nonEmpty();
                    Option<String> redirectOpt = this.redirect(args.url0(), conn, args.followHttpToHttpsRedirections(), args.followHttpsToHttpRedirections());
                    Option<String> option3 = redirectOpt;
                    if (option3 instanceof Some) {
                        Some some3 = (Some)option3;
                        String loc = (String)some3.value();
                        this.closeConn(conn);
                        if (args.maxRedirectionsOpt().exists(x$8 -> x$8 <= args.redirectionCount())) {
                            throw new Exception(new StringBuilder(52).append("Too many redirections for ").append(args.initialUrl()).append(" (more than ").append(args.redirectionCount()).append(" redirections)").toString());
                        }
                        Option<Authentication> newAuthOpt = args.authentication().filter((Function1<Authentication, Object> & Serializable)auth -> BoxesRunTime.boxToBoolean(CacheUrl$.$anonfun$urlConnectionMaybePartial$4(loc, auth))).orElse((Function0<Option> & Serializable)() -> args.autoCredentials().find((Function1<DirectCredentials, Object> & Serializable)x$9 -> BoxesRunTime.boxToBoolean(x$9.autoMatches(loc, None$.MODULE$))).map((Function1<DirectCredentials, Authentication> & Serializable)x$10 -> x$10.authentication()));
                        String x$16 = loc;
                        Option<Authentication> x$17 = newAuthOpt;
                        None$ x$18 = None$.MODULE$;
                        int x$19 = args.redirectionCount() + 1;
                        String x$20 = args.copy$default$1();
                        long x$21 = args.copy$default$4();
                        boolean x$22 = args.copy$default$5();
                        boolean x$23 = args.copy$default$6();
                        Seq<DirectCredentials> x$24 = args.copy$default$7();
                        Option<SSLSocketFactory> x$25 = args.copy$default$8();
                        Option<HostnameVerifier> x$26 = args.copy$default$9();
                        Option<Proxy> x$27 = args.copy$default$10();
                        String x$28 = args.copy$default$11();
                        Option<Object> x$29 = args.copy$default$14();
                        Seq<ClassLoader> x$30 = args.copy$default$15();
                        either2 = new Left(args.copy(x$20, x$16, x$17, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$18, x$19, x$29, x$30));
                        break block19;
                    }
                    if (None$.MODULE$.equals(option3)) {
                        if (this.is4xx(conn)) {
                            Option<Authentication> authentication0;
                            Option<String> realmOpt = this.realm(conn);
                            Option<Authentication> option4 = authentication0 = args.authentication().map((Function1<Authentication, Authentication> & Serializable)x$11 -> x$11.withOptional(false)).orElse((Function0<Option> & Serializable)() -> args.autoCredentials().find((Function1<DirectCredentials, Object> & Serializable)x$12 -> BoxesRunTime.boxToBoolean(x$12.autoMatches(args.url0(), realmOpt))).map((Function1<DirectCredentials, Authentication> & Serializable)x$13 -> x$13.authentication()));
                            Option<Authentication> option5 = args.authentication();
                            if (!(option4 != null ? !option4.equals(option5) : option5 != null) && realmOpt.forall((Function1<String, Object>)(Function1<Object, Object> & Serializable)elem -> BoxesRunTime.boxToBoolean(CacheUrl$.$anonfun$urlConnectionMaybePartial$12(args, elem)))) {
                                either2 = new Right(new Tuple2<URLConnection, Boolean>(conn, BoxesRunTime.boxToBoolean(partialDownload)));
                            } else {
                                this.closeConn(conn);
                                if (args.maxRedirectionsOpt().exists(x$14 -> x$14 <= args.redirectionCount())) {
                                    throw new Exception(new StringBuilder(52).append("Too many redirections for ").append(args.initialUrl()).append(" (more than ").append(args.redirectionCount()).append(" redirections)").toString());
                                }
                                Option<Authentication> x$31 = authentication0;
                                Option<String> x$32 = realmOpt;
                                int x$33 = args.redirectionCount() + 1;
                                String x$34 = args.copy$default$1();
                                String x$35 = args.copy$default$2();
                                long x$36 = args.copy$default$4();
                                boolean x$37 = args.copy$default$5();
                                boolean x$38 = args.copy$default$6();
                                Seq<DirectCredentials> x$39 = args.copy$default$7();
                                Option<SSLSocketFactory> x$40 = args.copy$default$8();
                                Option<HostnameVerifier> x$41 = args.copy$default$9();
                                Option<Proxy> x$42 = args.copy$default$10();
                                String x$43 = args.copy$default$11();
                                Option<Object> x$44 = args.copy$default$14();
                                Seq<ClassLoader> x$45 = args.copy$default$15();
                                either2 = new Left(args.copy(x$34, x$35, x$31, x$36, x$37, x$38, x$39, x$40, x$41, x$42, x$43, x$32, x$33, x$44, x$45));
                            }
                        } else {
                            either2 = new Right(new Tuple2<URLConnection, Boolean>(conn, BoxesRunTime.boxToBoolean(partialDownload)));
                        }
                        break block19;
                    }
                    throw new MatchError(option3);
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable throwable3 = throwable;
                    if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                        if (conn != null) {
                            this.closeConn(conn);
                        }
                        throw throwable2;
                    }
                    throw throwable;
                }
            }
            either = res = either2;
            if (!(either instanceof Left)) break;
            Either either3 = either;
            args = newArgs = (CacheUrl.Args)((Left)either3).value();
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Tuple2 ret = (Tuple2)right.value();
            return ret;
        }
        throw new MatchError(either);
    }

    public Option<Object> responseCode(URLConnection conn) {
        URLConnection uRLConnection = conn;
        if (uRLConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            return new Some<Object>(BoxesRunTime.boxToInteger(httpURLConnection.getResponseCode()));
        }
        return None$.MODULE$;
    }

    public Option<String> realm(URLConnection conn) {
        URLConnection uRLConnection = conn;
        if (uRLConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            return Option$.MODULE$.apply(httpURLConnection.getHeaderField("WWW-Authenticate")).collect(new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Option<String> option;
                    A1 A1 = x1;
                    if (A1 != null && !(option = CacheUrl$BasicRealm$.MODULE$.unapply(A1)).isEmpty()) {
                        String realm2 = option.get();
                        return (B1)realm2;
                    }
                    return function1.apply(x1);
                }

                public final boolean isDefinedAt(String x1) {
                    Option<String> option;
                    String string = x1;
                    return string != null && !(option = CacheUrl$BasicRealm$.MODULE$.unapply(string)).isEmpty();
                }
            });
        }
        return None$.MODULE$;
    }

    public void closeConn(URLConnection conn) {
        Try$.MODULE$.apply((Function0<InputStream> & Serializable)() -> conn.getInputStream()).toOption().filter((Function1<InputStream, Object> & Serializable)x$15 -> BoxesRunTime.boxToBoolean(CacheUrl$.$anonfun$closeConn$2(x$15))).foreach((Function1<InputStream, Object> & Serializable)x$16 -> {
            x$16.close();
            return BoxedUnit.UNIT;
        });
        URLConnection uRLConnection = conn;
        if (uRLConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            Try$.MODULE$.apply((Function0<InputStream> & Serializable)() -> httpURLConnection.getErrorStream()).toOption().filter((Function1<InputStream, Object> & Serializable)x$17 -> BoxesRunTime.boxToBoolean(CacheUrl$.$anonfun$closeConn$5(x$17))).foreach((Function1<InputStream, Object> & Serializable)x$18 -> {
                x$18.close();
                return BoxedUnit.UNIT;
            });
            httpURLConnection.disconnect();
            return;
        }
    }

    public void setupProxyAuth(Map<Tuple3<String, String, String>, Tuple2<String, String>> credentials) {
        Authenticator.setDefault(new Authenticator(credentials){
            private final Map credentials$1;

            public PasswordAuthentication getPasswordAuthentication() {
                Some some;
                Tuple2 tuple2;
                Tuple3<String, String, String> key2 = new Tuple3<String, String, String>(this.getRequestingProtocol(), this.getRequestingHost(), Integer.toString(this.getRequestingPort()));
                Option<V> option = this.credentials$1.get(key2);
                if (None$.MODULE$.equals(option)) {
                    return super.getPasswordAuthentication();
                }
                if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                    String user = (String)tuple2._1();
                    String password = (String)tuple2._2();
                    return new PasswordAuthentication(user, password.toCharArray());
                }
                throw new MatchError(option);
            }
            {
                this.credentials$1 = credentials$1;
            }
        });
        if (System.getProperty("jdk.http.auth.tunneling.disabledSchemes") == null) {
            System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
            return;
        }
    }

    public void setupProxyAuth() {
        Option httpAuthOpt = CacheUrl$.authOpt$1("http");
        Option httpsAuthOpt = CacheUrl$.authOpt$1("https");
        Map<Tuple3<String, String, String>, Tuple2<String, String>> map = httpAuthOpt.iterator().$plus$plus((Function0<Iterator> & Serializable)() -> httpsAuthOpt.iterator()).toMap($less$colon$less$.MODULE$.refl());
        if (map.nonEmpty()) {
            this.setupProxyAuth(map);
            return;
        }
    }

    public void disableProxyAuth() {
        Authenticator.setDefault(null);
    }

    public static final /* synthetic */ boolean $anonfun$handlerFor$1(char x$1) {
        return x$1 != ':';
    }

    private static final Option clsOpt$1(ClassLoader loader, String clsName$1) {
        Option option;
        try {
            option = new Some(Class.forName(clsName$1, false, loader));
        }
        catch (ClassNotFoundException classNotFoundException) {
            option = None$.MODULE$;
        }
        return option;
    }

    public static final /* synthetic */ boolean $anonfun$handlerFor$4(Class x$3) {
        return true;
    }

    private static final void printError$1(Exception e, String clsName$1) {
        Console$.MODULE$.err().println(new StringBuilder(21).append("Cannot instantiate ").append(clsName$1).append(": ").append(e).append(Option$.MODULE$.apply(e.getMessage()).fold((Function0<String> & Serializable)() -> "", (Function1<String, String> & Serializable)x$4 -> new StringBuilder(3).append(" (").append((String)x$4).append(")").toString())).toString());
    }

    public static final /* synthetic */ boolean $anonfun$initialize$4(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$initialize$5(HttpURLConnection x3$1, Tuple2 x$6) {
        Tuple2 tuple2 = x$6;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            x3$1.setRequestProperty(k, v);
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$initialize$3(URLConnection conn$1, Authentication auth) {
        URLConnection uRLConnection = conn$1;
        if (uRLConnection instanceof AuthenticatedURLConnection) {
            AuthenticatedURLConnection authenticatedURLConnection = (AuthenticatedURLConnection)((Object)uRLConnection);
            authenticatedURLConnection.authenticate(auth);
            return;
        }
        if (uRLConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            auth.allHttpHeaders().withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(CacheUrl$.$anonfun$initialize$4(check$ifrefutable$1))).foreach((Function1<Tuple2, Object> & Serializable)x$6 -> {
                CacheUrl$.$anonfun$initialize$5(httpURLConnection, x$6);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$redirect$2(String url$1, boolean followHttpToHttpsRedirections$1, boolean followHttpsToHttpRedirections$1, String target) {
        boolean isHttp = url$1.startsWith("http://");
        boolean isHttps = url$1.startsWith("https://");
        boolean redirToHttp = target.startsWith("http://");
        boolean redirToHttps = target.startsWith("https://");
        return isHttp && redirToHttp || isHttps && redirToHttps || followHttpToHttpsRedirections$1 && isHttp && redirToHttps || followHttpsToHttpRedirections$1 && isHttps && redirToHttp;
    }

    public static final /* synthetic */ boolean $anonfun$urlConnectionMaybePartial$2(CacheUrl.Args args$1, Object elem) {
        return args$1.authRealm().contains(elem);
    }

    public static final /* synthetic */ boolean $anonfun$urlConnectionMaybePartial$1(CacheUrl.Args args$1, Authentication a) {
        return a.realmOpt().forall((Function1<String, Object>)(Function1<Object, Object> & Serializable)elem -> BoxesRunTime.boxToBoolean(CacheUrl$.$anonfun$urlConnectionMaybePartial$2(args$1, elem))) && !a.optional();
    }

    public static final /* synthetic */ boolean $anonfun$urlConnectionMaybePartial$4(String loc$1, Authentication auth) {
        return auth.passOnRedirect() && (loc$1.startsWith("https://") || loc$1.startsWith("http://") && !auth.httpsOnly());
    }

    public static final /* synthetic */ boolean $anonfun$urlConnectionMaybePartial$12(CacheUrl.Args args$1, Object elem) {
        return args$1.authRealm().contains(elem);
    }

    public static final /* synthetic */ boolean $anonfun$closeConn$2(InputStream x$15) {
        return x$15 != null;
    }

    public static final /* synthetic */ boolean $anonfun$closeConn$5(InputStream x$17) {
        return x$17 != null;
    }

    private static final Option authOpt$1(String scheme) {
        return scala.sys.package$.MODULE$.props().get(new StringBuilder(10).append(scheme).append(".proxyHost").toString()).flatMap((Function1<String, Option> & Serializable)host -> scala.sys.package$.MODULE$.props().get(new StringBuilder(10).append(scheme).append(".proxyPort").toString()).flatMap((Function1<String, Option> & Serializable)port -> scala.sys.package$.MODULE$.props().get(new StringBuilder(10).append(scheme).append(".proxyUser").toString()).flatMap((Function1<String, Option> & Serializable)user -> scala.sys.package$.MODULE$.props().get(new StringBuilder(14).append(scheme).append(".proxyPassword").toString()).map((Function1<String, Tuple2> & Serializable)password -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new Tuple3<String, String, String>(scheme, (String)host, (String)port)), new Tuple2<String, String>((String)user, (String)password))))));
    }

    private CacheUrl$() {
    }
}

