/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis;

import java.util.Map;
import java.util.TreeMap;

public class Metrics {
    public static final Map<MetricType, Integer> counts = new TreeMap<MetricType, Integer>();

    public static void increaseCount(MetricType type) {
        counts.merge(type, 1, Integer::sum);
    }

    public static String flush() {
        StringBuilder result = new StringBuilder("Metrics:\n");
        counts.forEach((type, count) -> result.append(type.name()).append(": ").append(count).append("\n"));
        counts.clear();
        return result.toString();
    }

    public static enum MetricType {
        MISSING_CLASS,
        MISSING_METHODS,
        UNSUPPORTED_OPCODE,
        PARTIAL_EVALUATOR_EXCEPTION,
        PARTIAL_EVALUATOR_EXCESSIVE_COMPLEXITY,
        PARTIAL_EVALUATOR_VALUE_IMPRECISE,
        SYMBOLIC_CALL,
        CONCRETE_CALL,
        INVALID_TYPE_STRING,
        CALL_TO_ABSTRACT_METHOD;

    }
}

