// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chimesdkvoice

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAssociatePhoneNumbersWithVoiceConnector = "AssociatePhoneNumbersWithVoiceConnector"

// AssociatePhoneNumbersWithVoiceConnectorRequest generates a "aws/request.Request" representing the
// client's request for the AssociatePhoneNumbersWithVoiceConnector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociatePhoneNumbersWithVoiceConnector for more information on using the AssociatePhoneNumbersWithVoiceConnector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociatePhoneNumbersWithVoiceConnectorRequest method.
//	req, resp := client.AssociatePhoneNumbersWithVoiceConnectorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/AssociatePhoneNumbersWithVoiceConnector
func (c *ChimeSDKVoice) AssociatePhoneNumbersWithVoiceConnectorRequest(input *AssociatePhoneNumbersWithVoiceConnectorInput) (req *request.Request, output *AssociatePhoneNumbersWithVoiceConnectorOutput) {
	op := &request.Operation{
		Name:       opAssociatePhoneNumbersWithVoiceConnector,
		HTTPMethod: "POST",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}?operation=associate-phone-numbers",
	}

	if input == nil {
		input = &AssociatePhoneNumbersWithVoiceConnectorInput{}
	}

	output = &AssociatePhoneNumbersWithVoiceConnectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociatePhoneNumbersWithVoiceConnector API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation AssociatePhoneNumbersWithVoiceConnector for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - AccessDeniedException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/AssociatePhoneNumbersWithVoiceConnector
func (c *ChimeSDKVoice) AssociatePhoneNumbersWithVoiceConnector(input *AssociatePhoneNumbersWithVoiceConnectorInput) (*AssociatePhoneNumbersWithVoiceConnectorOutput, error) {
	req, out := c.AssociatePhoneNumbersWithVoiceConnectorRequest(input)
	return out, req.Send()
}

// AssociatePhoneNumbersWithVoiceConnectorWithContext is the same as AssociatePhoneNumbersWithVoiceConnector with the addition of
// the ability to pass a context and additional request options.
//
// See AssociatePhoneNumbersWithVoiceConnector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) AssociatePhoneNumbersWithVoiceConnectorWithContext(ctx aws.Context, input *AssociatePhoneNumbersWithVoiceConnectorInput, opts ...request.Option) (*AssociatePhoneNumbersWithVoiceConnectorOutput, error) {
	req, out := c.AssociatePhoneNumbersWithVoiceConnectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociatePhoneNumbersWithVoiceConnectorGroup = "AssociatePhoneNumbersWithVoiceConnectorGroup"

// AssociatePhoneNumbersWithVoiceConnectorGroupRequest generates a "aws/request.Request" representing the
// client's request for the AssociatePhoneNumbersWithVoiceConnectorGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociatePhoneNumbersWithVoiceConnectorGroup for more information on using the AssociatePhoneNumbersWithVoiceConnectorGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociatePhoneNumbersWithVoiceConnectorGroupRequest method.
//	req, resp := client.AssociatePhoneNumbersWithVoiceConnectorGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/AssociatePhoneNumbersWithVoiceConnectorGroup
func (c *ChimeSDKVoice) AssociatePhoneNumbersWithVoiceConnectorGroupRequest(input *AssociatePhoneNumbersWithVoiceConnectorGroupInput) (req *request.Request, output *AssociatePhoneNumbersWithVoiceConnectorGroupOutput) {
	op := &request.Operation{
		Name:       opAssociatePhoneNumbersWithVoiceConnectorGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/voice-connector-groups/{voiceConnectorGroupId}?operation=associate-phone-numbers",
	}

	if input == nil {
		input = &AssociatePhoneNumbersWithVoiceConnectorGroupInput{}
	}

	output = &AssociatePhoneNumbersWithVoiceConnectorGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociatePhoneNumbersWithVoiceConnectorGroup API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation AssociatePhoneNumbersWithVoiceConnectorGroup for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - AccessDeniedException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/AssociatePhoneNumbersWithVoiceConnectorGroup
func (c *ChimeSDKVoice) AssociatePhoneNumbersWithVoiceConnectorGroup(input *AssociatePhoneNumbersWithVoiceConnectorGroupInput) (*AssociatePhoneNumbersWithVoiceConnectorGroupOutput, error) {
	req, out := c.AssociatePhoneNumbersWithVoiceConnectorGroupRequest(input)
	return out, req.Send()
}

// AssociatePhoneNumbersWithVoiceConnectorGroupWithContext is the same as AssociatePhoneNumbersWithVoiceConnectorGroup with the addition of
// the ability to pass a context and additional request options.
//
// See AssociatePhoneNumbersWithVoiceConnectorGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) AssociatePhoneNumbersWithVoiceConnectorGroupWithContext(ctx aws.Context, input *AssociatePhoneNumbersWithVoiceConnectorGroupInput, opts ...request.Option) (*AssociatePhoneNumbersWithVoiceConnectorGroupOutput, error) {
	req, out := c.AssociatePhoneNumbersWithVoiceConnectorGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDeletePhoneNumber = "BatchDeletePhoneNumber"

// BatchDeletePhoneNumberRequest generates a "aws/request.Request" representing the
// client's request for the BatchDeletePhoneNumber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDeletePhoneNumber for more information on using the BatchDeletePhoneNumber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchDeletePhoneNumberRequest method.
//	req, resp := client.BatchDeletePhoneNumberRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/BatchDeletePhoneNumber
func (c *ChimeSDKVoice) BatchDeletePhoneNumberRequest(input *BatchDeletePhoneNumberInput) (req *request.Request, output *BatchDeletePhoneNumberOutput) {
	op := &request.Operation{
		Name:       opBatchDeletePhoneNumber,
		HTTPMethod: "POST",
		HTTPPath:   "/phone-numbers?operation=batch-delete",
	}

	if input == nil {
		input = &BatchDeletePhoneNumberInput{}
	}

	output = &BatchDeletePhoneNumberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDeletePhoneNumber API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation BatchDeletePhoneNumber for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/BatchDeletePhoneNumber
func (c *ChimeSDKVoice) BatchDeletePhoneNumber(input *BatchDeletePhoneNumberInput) (*BatchDeletePhoneNumberOutput, error) {
	req, out := c.BatchDeletePhoneNumberRequest(input)
	return out, req.Send()
}

// BatchDeletePhoneNumberWithContext is the same as BatchDeletePhoneNumber with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDeletePhoneNumber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) BatchDeletePhoneNumberWithContext(ctx aws.Context, input *BatchDeletePhoneNumberInput, opts ...request.Option) (*BatchDeletePhoneNumberOutput, error) {
	req, out := c.BatchDeletePhoneNumberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchUpdatePhoneNumber = "BatchUpdatePhoneNumber"

// BatchUpdatePhoneNumberRequest generates a "aws/request.Request" representing the
// client's request for the BatchUpdatePhoneNumber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchUpdatePhoneNumber for more information on using the BatchUpdatePhoneNumber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchUpdatePhoneNumberRequest method.
//	req, resp := client.BatchUpdatePhoneNumberRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/BatchUpdatePhoneNumber
func (c *ChimeSDKVoice) BatchUpdatePhoneNumberRequest(input *BatchUpdatePhoneNumberInput) (req *request.Request, output *BatchUpdatePhoneNumberOutput) {
	op := &request.Operation{
		Name:       opBatchUpdatePhoneNumber,
		HTTPMethod: "POST",
		HTTPPath:   "/phone-numbers?operation=batch-update",
	}

	if input == nil {
		input = &BatchUpdatePhoneNumberInput{}
	}

	output = &BatchUpdatePhoneNumberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchUpdatePhoneNumber API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation BatchUpdatePhoneNumber for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/BatchUpdatePhoneNumber
func (c *ChimeSDKVoice) BatchUpdatePhoneNumber(input *BatchUpdatePhoneNumberInput) (*BatchUpdatePhoneNumberOutput, error) {
	req, out := c.BatchUpdatePhoneNumberRequest(input)
	return out, req.Send()
}

// BatchUpdatePhoneNumberWithContext is the same as BatchUpdatePhoneNumber with the addition of
// the ability to pass a context and additional request options.
//
// See BatchUpdatePhoneNumber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) BatchUpdatePhoneNumberWithContext(ctx aws.Context, input *BatchUpdatePhoneNumberInput, opts ...request.Option) (*BatchUpdatePhoneNumberOutput, error) {
	req, out := c.BatchUpdatePhoneNumberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePhoneNumberOrder = "CreatePhoneNumberOrder"

// CreatePhoneNumberOrderRequest generates a "aws/request.Request" representing the
// client's request for the CreatePhoneNumberOrder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePhoneNumberOrder for more information on using the CreatePhoneNumberOrder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreatePhoneNumberOrderRequest method.
//	req, resp := client.CreatePhoneNumberOrderRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreatePhoneNumberOrder
func (c *ChimeSDKVoice) CreatePhoneNumberOrderRequest(input *CreatePhoneNumberOrderInput) (req *request.Request, output *CreatePhoneNumberOrderOutput) {
	op := &request.Operation{
		Name:       opCreatePhoneNumberOrder,
		HTTPMethod: "POST",
		HTTPPath:   "/phone-number-orders",
	}

	if input == nil {
		input = &CreatePhoneNumberOrderInput{}
	}

	output = &CreatePhoneNumberOrderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePhoneNumberOrder API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation CreatePhoneNumberOrder for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - ForbiddenException
//
//   - AccessDeniedException
//
//   - UnauthorizedClientException
//
//   - ThrottledClientException
//
//   - ResourceLimitExceededException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreatePhoneNumberOrder
func (c *ChimeSDKVoice) CreatePhoneNumberOrder(input *CreatePhoneNumberOrderInput) (*CreatePhoneNumberOrderOutput, error) {
	req, out := c.CreatePhoneNumberOrderRequest(input)
	return out, req.Send()
}

// CreatePhoneNumberOrderWithContext is the same as CreatePhoneNumberOrder with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePhoneNumberOrder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) CreatePhoneNumberOrderWithContext(ctx aws.Context, input *CreatePhoneNumberOrderInput, opts ...request.Option) (*CreatePhoneNumberOrderOutput, error) {
	req, out := c.CreatePhoneNumberOrderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProxySession = "CreateProxySession"

// CreateProxySessionRequest generates a "aws/request.Request" representing the
// client's request for the CreateProxySession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProxySession for more information on using the CreateProxySession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateProxySessionRequest method.
//	req, resp := client.CreateProxySessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateProxySession
func (c *ChimeSDKVoice) CreateProxySessionRequest(input *CreateProxySessionInput) (req *request.Request, output *CreateProxySessionOutput) {
	op := &request.Operation{
		Name:       opCreateProxySession,
		HTTPMethod: "POST",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/proxy-sessions",
	}

	if input == nil {
		input = &CreateProxySessionInput{}
	}

	output = &CreateProxySessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProxySession API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation CreateProxySession for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateProxySession
func (c *ChimeSDKVoice) CreateProxySession(input *CreateProxySessionInput) (*CreateProxySessionOutput, error) {
	req, out := c.CreateProxySessionRequest(input)
	return out, req.Send()
}

// CreateProxySessionWithContext is the same as CreateProxySession with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProxySession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) CreateProxySessionWithContext(ctx aws.Context, input *CreateProxySessionInput, opts ...request.Option) (*CreateProxySessionOutput, error) {
	req, out := c.CreateProxySessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSipMediaApplication = "CreateSipMediaApplication"

// CreateSipMediaApplicationRequest generates a "aws/request.Request" representing the
// client's request for the CreateSipMediaApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSipMediaApplication for more information on using the CreateSipMediaApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSipMediaApplicationRequest method.
//	req, resp := client.CreateSipMediaApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateSipMediaApplication
func (c *ChimeSDKVoice) CreateSipMediaApplicationRequest(input *CreateSipMediaApplicationInput) (req *request.Request, output *CreateSipMediaApplicationOutput) {
	op := &request.Operation{
		Name:       opCreateSipMediaApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/sip-media-applications",
	}

	if input == nil {
		input = &CreateSipMediaApplicationInput{}
	}

	output = &CreateSipMediaApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSipMediaApplication API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation CreateSipMediaApplication for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - ForbiddenException
//
//   - AccessDeniedException
//
//   - UnauthorizedClientException
//
//   - ThrottledClientException
//
//   - ResourceLimitExceededException
//
//   - ConflictException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateSipMediaApplication
func (c *ChimeSDKVoice) CreateSipMediaApplication(input *CreateSipMediaApplicationInput) (*CreateSipMediaApplicationOutput, error) {
	req, out := c.CreateSipMediaApplicationRequest(input)
	return out, req.Send()
}

// CreateSipMediaApplicationWithContext is the same as CreateSipMediaApplication with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSipMediaApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) CreateSipMediaApplicationWithContext(ctx aws.Context, input *CreateSipMediaApplicationInput, opts ...request.Option) (*CreateSipMediaApplicationOutput, error) {
	req, out := c.CreateSipMediaApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSipMediaApplicationCall = "CreateSipMediaApplicationCall"

// CreateSipMediaApplicationCallRequest generates a "aws/request.Request" representing the
// client's request for the CreateSipMediaApplicationCall operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSipMediaApplicationCall for more information on using the CreateSipMediaApplicationCall
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSipMediaApplicationCallRequest method.
//	req, resp := client.CreateSipMediaApplicationCallRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateSipMediaApplicationCall
func (c *ChimeSDKVoice) CreateSipMediaApplicationCallRequest(input *CreateSipMediaApplicationCallInput) (req *request.Request, output *CreateSipMediaApplicationCallOutput) {
	op := &request.Operation{
		Name:       opCreateSipMediaApplicationCall,
		HTTPMethod: "POST",
		HTTPPath:   "/sip-media-applications/{sipMediaApplicationId}/calls",
	}

	if input == nil {
		input = &CreateSipMediaApplicationCallInput{}
	}

	output = &CreateSipMediaApplicationCallOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSipMediaApplicationCall API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation CreateSipMediaApplicationCall for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - ForbiddenException
//
//   - ResourceLimitExceededException
//
//   - ThrottledClientException
//
//   - UnauthorizedClientException
//
//   - AccessDeniedException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateSipMediaApplicationCall
func (c *ChimeSDKVoice) CreateSipMediaApplicationCall(input *CreateSipMediaApplicationCallInput) (*CreateSipMediaApplicationCallOutput, error) {
	req, out := c.CreateSipMediaApplicationCallRequest(input)
	return out, req.Send()
}

// CreateSipMediaApplicationCallWithContext is the same as CreateSipMediaApplicationCall with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSipMediaApplicationCall for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) CreateSipMediaApplicationCallWithContext(ctx aws.Context, input *CreateSipMediaApplicationCallInput, opts ...request.Option) (*CreateSipMediaApplicationCallOutput, error) {
	req, out := c.CreateSipMediaApplicationCallRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSipRule = "CreateSipRule"

// CreateSipRuleRequest generates a "aws/request.Request" representing the
// client's request for the CreateSipRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSipRule for more information on using the CreateSipRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSipRuleRequest method.
//	req, resp := client.CreateSipRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateSipRule
func (c *ChimeSDKVoice) CreateSipRuleRequest(input *CreateSipRuleInput) (req *request.Request, output *CreateSipRuleOutput) {
	op := &request.Operation{
		Name:       opCreateSipRule,
		HTTPMethod: "POST",
		HTTPPath:   "/sip-rules",
	}

	if input == nil {
		input = &CreateSipRuleInput{}
	}

	output = &CreateSipRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSipRule API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation CreateSipRule for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - ForbiddenException
//
//   - AccessDeniedException
//
//   - UnauthorizedClientException
//
//   - ThrottledClientException
//
//   - ResourceLimitExceededException
//
//   - ConflictException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateSipRule
func (c *ChimeSDKVoice) CreateSipRule(input *CreateSipRuleInput) (*CreateSipRuleOutput, error) {
	req, out := c.CreateSipRuleRequest(input)
	return out, req.Send()
}

// CreateSipRuleWithContext is the same as CreateSipRule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSipRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) CreateSipRuleWithContext(ctx aws.Context, input *CreateSipRuleInput, opts ...request.Option) (*CreateSipRuleOutput, error) {
	req, out := c.CreateSipRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVoiceConnector = "CreateVoiceConnector"

// CreateVoiceConnectorRequest generates a "aws/request.Request" representing the
// client's request for the CreateVoiceConnector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVoiceConnector for more information on using the CreateVoiceConnector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateVoiceConnectorRequest method.
//	req, resp := client.CreateVoiceConnectorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateVoiceConnector
func (c *ChimeSDKVoice) CreateVoiceConnectorRequest(input *CreateVoiceConnectorInput) (req *request.Request, output *CreateVoiceConnectorOutput) {
	op := &request.Operation{
		Name:       opCreateVoiceConnector,
		HTTPMethod: "POST",
		HTTPPath:   "/voice-connectors",
	}

	if input == nil {
		input = &CreateVoiceConnectorInput{}
	}

	output = &CreateVoiceConnectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVoiceConnector API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation CreateVoiceConnector for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - ForbiddenException
//
//   - AccessDeniedException
//
//   - UnauthorizedClientException
//
//   - ThrottledClientException
//
//   - ResourceLimitExceededException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateVoiceConnector
func (c *ChimeSDKVoice) CreateVoiceConnector(input *CreateVoiceConnectorInput) (*CreateVoiceConnectorOutput, error) {
	req, out := c.CreateVoiceConnectorRequest(input)
	return out, req.Send()
}

// CreateVoiceConnectorWithContext is the same as CreateVoiceConnector with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVoiceConnector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) CreateVoiceConnectorWithContext(ctx aws.Context, input *CreateVoiceConnectorInput, opts ...request.Option) (*CreateVoiceConnectorOutput, error) {
	req, out := c.CreateVoiceConnectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVoiceConnectorGroup = "CreateVoiceConnectorGroup"

// CreateVoiceConnectorGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateVoiceConnectorGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVoiceConnectorGroup for more information on using the CreateVoiceConnectorGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateVoiceConnectorGroupRequest method.
//	req, resp := client.CreateVoiceConnectorGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateVoiceConnectorGroup
func (c *ChimeSDKVoice) CreateVoiceConnectorGroupRequest(input *CreateVoiceConnectorGroupInput) (req *request.Request, output *CreateVoiceConnectorGroupOutput) {
	op := &request.Operation{
		Name:       opCreateVoiceConnectorGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/voice-connector-groups",
	}

	if input == nil {
		input = &CreateVoiceConnectorGroupInput{}
	}

	output = &CreateVoiceConnectorGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVoiceConnectorGroup API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation CreateVoiceConnectorGroup for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - ForbiddenException
//
//   - AccessDeniedException
//
//   - UnauthorizedClientException
//
//   - ThrottledClientException
//
//   - ResourceLimitExceededException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateVoiceConnectorGroup
func (c *ChimeSDKVoice) CreateVoiceConnectorGroup(input *CreateVoiceConnectorGroupInput) (*CreateVoiceConnectorGroupOutput, error) {
	req, out := c.CreateVoiceConnectorGroupRequest(input)
	return out, req.Send()
}

// CreateVoiceConnectorGroupWithContext is the same as CreateVoiceConnectorGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVoiceConnectorGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) CreateVoiceConnectorGroupWithContext(ctx aws.Context, input *CreateVoiceConnectorGroupInput, opts ...request.Option) (*CreateVoiceConnectorGroupOutput, error) {
	req, out := c.CreateVoiceConnectorGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePhoneNumber = "DeletePhoneNumber"

// DeletePhoneNumberRequest generates a "aws/request.Request" representing the
// client's request for the DeletePhoneNumber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePhoneNumber for more information on using the DeletePhoneNumber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePhoneNumberRequest method.
//	req, resp := client.DeletePhoneNumberRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeletePhoneNumber
func (c *ChimeSDKVoice) DeletePhoneNumberRequest(input *DeletePhoneNumberInput) (req *request.Request, output *DeletePhoneNumberOutput) {
	op := &request.Operation{
		Name:       opDeletePhoneNumber,
		HTTPMethod: "DELETE",
		HTTPPath:   "/phone-numbers/{phoneNumberId}",
	}

	if input == nil {
		input = &DeletePhoneNumberInput{}
	}

	output = &DeletePhoneNumberOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePhoneNumber API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation DeletePhoneNumber for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeletePhoneNumber
func (c *ChimeSDKVoice) DeletePhoneNumber(input *DeletePhoneNumberInput) (*DeletePhoneNumberOutput, error) {
	req, out := c.DeletePhoneNumberRequest(input)
	return out, req.Send()
}

// DeletePhoneNumberWithContext is the same as DeletePhoneNumber with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePhoneNumber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) DeletePhoneNumberWithContext(ctx aws.Context, input *DeletePhoneNumberInput, opts ...request.Option) (*DeletePhoneNumberOutput, error) {
	req, out := c.DeletePhoneNumberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProxySession = "DeleteProxySession"

// DeleteProxySessionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProxySession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProxySession for more information on using the DeleteProxySession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteProxySessionRequest method.
//	req, resp := client.DeleteProxySessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteProxySession
func (c *ChimeSDKVoice) DeleteProxySessionRequest(input *DeleteProxySessionInput) (req *request.Request, output *DeleteProxySessionOutput) {
	op := &request.Operation{
		Name:       opDeleteProxySession,
		HTTPMethod: "DELETE",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/proxy-sessions/{proxySessionId}",
	}

	if input == nil {
		input = &DeleteProxySessionInput{}
	}

	output = &DeleteProxySessionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteProxySession API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation DeleteProxySession for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteProxySession
func (c *ChimeSDKVoice) DeleteProxySession(input *DeleteProxySessionInput) (*DeleteProxySessionOutput, error) {
	req, out := c.DeleteProxySessionRequest(input)
	return out, req.Send()
}

// DeleteProxySessionWithContext is the same as DeleteProxySession with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProxySession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) DeleteProxySessionWithContext(ctx aws.Context, input *DeleteProxySessionInput, opts ...request.Option) (*DeleteProxySessionOutput, error) {
	req, out := c.DeleteProxySessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSipMediaApplication = "DeleteSipMediaApplication"

// DeleteSipMediaApplicationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSipMediaApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSipMediaApplication for more information on using the DeleteSipMediaApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSipMediaApplicationRequest method.
//	req, resp := client.DeleteSipMediaApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteSipMediaApplication
func (c *ChimeSDKVoice) DeleteSipMediaApplicationRequest(input *DeleteSipMediaApplicationInput) (req *request.Request, output *DeleteSipMediaApplicationOutput) {
	op := &request.Operation{
		Name:       opDeleteSipMediaApplication,
		HTTPMethod: "DELETE",
		HTTPPath:   "/sip-media-applications/{sipMediaApplicationId}",
	}

	if input == nil {
		input = &DeleteSipMediaApplicationInput{}
	}

	output = &DeleteSipMediaApplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSipMediaApplication API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation DeleteSipMediaApplication for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ConflictException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteSipMediaApplication
func (c *ChimeSDKVoice) DeleteSipMediaApplication(input *DeleteSipMediaApplicationInput) (*DeleteSipMediaApplicationOutput, error) {
	req, out := c.DeleteSipMediaApplicationRequest(input)
	return out, req.Send()
}

// DeleteSipMediaApplicationWithContext is the same as DeleteSipMediaApplication with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSipMediaApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) DeleteSipMediaApplicationWithContext(ctx aws.Context, input *DeleteSipMediaApplicationInput, opts ...request.Option) (*DeleteSipMediaApplicationOutput, error) {
	req, out := c.DeleteSipMediaApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSipRule = "DeleteSipRule"

// DeleteSipRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSipRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSipRule for more information on using the DeleteSipRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSipRuleRequest method.
//	req, resp := client.DeleteSipRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteSipRule
func (c *ChimeSDKVoice) DeleteSipRuleRequest(input *DeleteSipRuleInput) (req *request.Request, output *DeleteSipRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteSipRule,
		HTTPMethod: "DELETE",
		HTTPPath:   "/sip-rules/{sipRuleId}",
	}

	if input == nil {
		input = &DeleteSipRuleInput{}
	}

	output = &DeleteSipRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSipRule API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation DeleteSipRule for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ConflictException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteSipRule
func (c *ChimeSDKVoice) DeleteSipRule(input *DeleteSipRuleInput) (*DeleteSipRuleOutput, error) {
	req, out := c.DeleteSipRuleRequest(input)
	return out, req.Send()
}

// DeleteSipRuleWithContext is the same as DeleteSipRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSipRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) DeleteSipRuleWithContext(ctx aws.Context, input *DeleteSipRuleInput, opts ...request.Option) (*DeleteSipRuleOutput, error) {
	req, out := c.DeleteSipRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVoiceConnector = "DeleteVoiceConnector"

// DeleteVoiceConnectorRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVoiceConnector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVoiceConnector for more information on using the DeleteVoiceConnector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVoiceConnectorRequest method.
//	req, resp := client.DeleteVoiceConnectorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnector
func (c *ChimeSDKVoice) DeleteVoiceConnectorRequest(input *DeleteVoiceConnectorInput) (req *request.Request, output *DeleteVoiceConnectorOutput) {
	op := &request.Operation{
		Name:       opDeleteVoiceConnector,
		HTTPMethod: "DELETE",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}",
	}

	if input == nil {
		input = &DeleteVoiceConnectorInput{}
	}

	output = &DeleteVoiceConnectorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVoiceConnector API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation DeleteVoiceConnector for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ConflictException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnector
func (c *ChimeSDKVoice) DeleteVoiceConnector(input *DeleteVoiceConnectorInput) (*DeleteVoiceConnectorOutput, error) {
	req, out := c.DeleteVoiceConnectorRequest(input)
	return out, req.Send()
}

// DeleteVoiceConnectorWithContext is the same as DeleteVoiceConnector with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVoiceConnector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) DeleteVoiceConnectorWithContext(ctx aws.Context, input *DeleteVoiceConnectorInput, opts ...request.Option) (*DeleteVoiceConnectorOutput, error) {
	req, out := c.DeleteVoiceConnectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVoiceConnectorEmergencyCallingConfiguration = "DeleteVoiceConnectorEmergencyCallingConfiguration"

// DeleteVoiceConnectorEmergencyCallingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVoiceConnectorEmergencyCallingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVoiceConnectorEmergencyCallingConfiguration for more information on using the DeleteVoiceConnectorEmergencyCallingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVoiceConnectorEmergencyCallingConfigurationRequest method.
//	req, resp := client.DeleteVoiceConnectorEmergencyCallingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnectorEmergencyCallingConfiguration
func (c *ChimeSDKVoice) DeleteVoiceConnectorEmergencyCallingConfigurationRequest(input *DeleteVoiceConnectorEmergencyCallingConfigurationInput) (req *request.Request, output *DeleteVoiceConnectorEmergencyCallingConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteVoiceConnectorEmergencyCallingConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/emergency-calling-configuration",
	}

	if input == nil {
		input = &DeleteVoiceConnectorEmergencyCallingConfigurationInput{}
	}

	output = &DeleteVoiceConnectorEmergencyCallingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVoiceConnectorEmergencyCallingConfiguration API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation DeleteVoiceConnectorEmergencyCallingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnectorEmergencyCallingConfiguration
func (c *ChimeSDKVoice) DeleteVoiceConnectorEmergencyCallingConfiguration(input *DeleteVoiceConnectorEmergencyCallingConfigurationInput) (*DeleteVoiceConnectorEmergencyCallingConfigurationOutput, error) {
	req, out := c.DeleteVoiceConnectorEmergencyCallingConfigurationRequest(input)
	return out, req.Send()
}

// DeleteVoiceConnectorEmergencyCallingConfigurationWithContext is the same as DeleteVoiceConnectorEmergencyCallingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVoiceConnectorEmergencyCallingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) DeleteVoiceConnectorEmergencyCallingConfigurationWithContext(ctx aws.Context, input *DeleteVoiceConnectorEmergencyCallingConfigurationInput, opts ...request.Option) (*DeleteVoiceConnectorEmergencyCallingConfigurationOutput, error) {
	req, out := c.DeleteVoiceConnectorEmergencyCallingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVoiceConnectorGroup = "DeleteVoiceConnectorGroup"

// DeleteVoiceConnectorGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVoiceConnectorGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVoiceConnectorGroup for more information on using the DeleteVoiceConnectorGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVoiceConnectorGroupRequest method.
//	req, resp := client.DeleteVoiceConnectorGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnectorGroup
func (c *ChimeSDKVoice) DeleteVoiceConnectorGroupRequest(input *DeleteVoiceConnectorGroupInput) (req *request.Request, output *DeleteVoiceConnectorGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteVoiceConnectorGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/voice-connector-groups/{voiceConnectorGroupId}",
	}

	if input == nil {
		input = &DeleteVoiceConnectorGroupInput{}
	}

	output = &DeleteVoiceConnectorGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVoiceConnectorGroup API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation DeleteVoiceConnectorGroup for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ConflictException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnectorGroup
func (c *ChimeSDKVoice) DeleteVoiceConnectorGroup(input *DeleteVoiceConnectorGroupInput) (*DeleteVoiceConnectorGroupOutput, error) {
	req, out := c.DeleteVoiceConnectorGroupRequest(input)
	return out, req.Send()
}

// DeleteVoiceConnectorGroupWithContext is the same as DeleteVoiceConnectorGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVoiceConnectorGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) DeleteVoiceConnectorGroupWithContext(ctx aws.Context, input *DeleteVoiceConnectorGroupInput, opts ...request.Option) (*DeleteVoiceConnectorGroupOutput, error) {
	req, out := c.DeleteVoiceConnectorGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVoiceConnectorOrigination = "DeleteVoiceConnectorOrigination"

// DeleteVoiceConnectorOriginationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVoiceConnectorOrigination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVoiceConnectorOrigination for more information on using the DeleteVoiceConnectorOrigination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVoiceConnectorOriginationRequest method.
//	req, resp := client.DeleteVoiceConnectorOriginationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnectorOrigination
func (c *ChimeSDKVoice) DeleteVoiceConnectorOriginationRequest(input *DeleteVoiceConnectorOriginationInput) (req *request.Request, output *DeleteVoiceConnectorOriginationOutput) {
	op := &request.Operation{
		Name:       opDeleteVoiceConnectorOrigination,
		HTTPMethod: "DELETE",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/origination",
	}

	if input == nil {
		input = &DeleteVoiceConnectorOriginationInput{}
	}

	output = &DeleteVoiceConnectorOriginationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVoiceConnectorOrigination API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation DeleteVoiceConnectorOrigination for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnectorOrigination
func (c *ChimeSDKVoice) DeleteVoiceConnectorOrigination(input *DeleteVoiceConnectorOriginationInput) (*DeleteVoiceConnectorOriginationOutput, error) {
	req, out := c.DeleteVoiceConnectorOriginationRequest(input)
	return out, req.Send()
}

// DeleteVoiceConnectorOriginationWithContext is the same as DeleteVoiceConnectorOrigination with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVoiceConnectorOrigination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) DeleteVoiceConnectorOriginationWithContext(ctx aws.Context, input *DeleteVoiceConnectorOriginationInput, opts ...request.Option) (*DeleteVoiceConnectorOriginationOutput, error) {
	req, out := c.DeleteVoiceConnectorOriginationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVoiceConnectorProxy = "DeleteVoiceConnectorProxy"

// DeleteVoiceConnectorProxyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVoiceConnectorProxy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVoiceConnectorProxy for more information on using the DeleteVoiceConnectorProxy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVoiceConnectorProxyRequest method.
//	req, resp := client.DeleteVoiceConnectorProxyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnectorProxy
func (c *ChimeSDKVoice) DeleteVoiceConnectorProxyRequest(input *DeleteVoiceConnectorProxyInput) (req *request.Request, output *DeleteVoiceConnectorProxyOutput) {
	op := &request.Operation{
		Name:       opDeleteVoiceConnectorProxy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/programmable-numbers/proxy",
	}

	if input == nil {
		input = &DeleteVoiceConnectorProxyInput{}
	}

	output = &DeleteVoiceConnectorProxyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVoiceConnectorProxy API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation DeleteVoiceConnectorProxy for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnectorProxy
func (c *ChimeSDKVoice) DeleteVoiceConnectorProxy(input *DeleteVoiceConnectorProxyInput) (*DeleteVoiceConnectorProxyOutput, error) {
	req, out := c.DeleteVoiceConnectorProxyRequest(input)
	return out, req.Send()
}

// DeleteVoiceConnectorProxyWithContext is the same as DeleteVoiceConnectorProxy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVoiceConnectorProxy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) DeleteVoiceConnectorProxyWithContext(ctx aws.Context, input *DeleteVoiceConnectorProxyInput, opts ...request.Option) (*DeleteVoiceConnectorProxyOutput, error) {
	req, out := c.DeleteVoiceConnectorProxyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVoiceConnectorStreamingConfiguration = "DeleteVoiceConnectorStreamingConfiguration"

// DeleteVoiceConnectorStreamingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVoiceConnectorStreamingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVoiceConnectorStreamingConfiguration for more information on using the DeleteVoiceConnectorStreamingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVoiceConnectorStreamingConfigurationRequest method.
//	req, resp := client.DeleteVoiceConnectorStreamingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnectorStreamingConfiguration
func (c *ChimeSDKVoice) DeleteVoiceConnectorStreamingConfigurationRequest(input *DeleteVoiceConnectorStreamingConfigurationInput) (req *request.Request, output *DeleteVoiceConnectorStreamingConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteVoiceConnectorStreamingConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/streaming-configuration",
	}

	if input == nil {
		input = &DeleteVoiceConnectorStreamingConfigurationInput{}
	}

	output = &DeleteVoiceConnectorStreamingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVoiceConnectorStreamingConfiguration API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation DeleteVoiceConnectorStreamingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnectorStreamingConfiguration
func (c *ChimeSDKVoice) DeleteVoiceConnectorStreamingConfiguration(input *DeleteVoiceConnectorStreamingConfigurationInput) (*DeleteVoiceConnectorStreamingConfigurationOutput, error) {
	req, out := c.DeleteVoiceConnectorStreamingConfigurationRequest(input)
	return out, req.Send()
}

// DeleteVoiceConnectorStreamingConfigurationWithContext is the same as DeleteVoiceConnectorStreamingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVoiceConnectorStreamingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) DeleteVoiceConnectorStreamingConfigurationWithContext(ctx aws.Context, input *DeleteVoiceConnectorStreamingConfigurationInput, opts ...request.Option) (*DeleteVoiceConnectorStreamingConfigurationOutput, error) {
	req, out := c.DeleteVoiceConnectorStreamingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVoiceConnectorTermination = "DeleteVoiceConnectorTermination"

// DeleteVoiceConnectorTerminationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVoiceConnectorTermination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVoiceConnectorTermination for more information on using the DeleteVoiceConnectorTermination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVoiceConnectorTerminationRequest method.
//	req, resp := client.DeleteVoiceConnectorTerminationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnectorTermination
func (c *ChimeSDKVoice) DeleteVoiceConnectorTerminationRequest(input *DeleteVoiceConnectorTerminationInput) (req *request.Request, output *DeleteVoiceConnectorTerminationOutput) {
	op := &request.Operation{
		Name:       opDeleteVoiceConnectorTermination,
		HTTPMethod: "DELETE",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/termination",
	}

	if input == nil {
		input = &DeleteVoiceConnectorTerminationInput{}
	}

	output = &DeleteVoiceConnectorTerminationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVoiceConnectorTermination API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation DeleteVoiceConnectorTermination for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnectorTermination
func (c *ChimeSDKVoice) DeleteVoiceConnectorTermination(input *DeleteVoiceConnectorTerminationInput) (*DeleteVoiceConnectorTerminationOutput, error) {
	req, out := c.DeleteVoiceConnectorTerminationRequest(input)
	return out, req.Send()
}

// DeleteVoiceConnectorTerminationWithContext is the same as DeleteVoiceConnectorTermination with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVoiceConnectorTermination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) DeleteVoiceConnectorTerminationWithContext(ctx aws.Context, input *DeleteVoiceConnectorTerminationInput, opts ...request.Option) (*DeleteVoiceConnectorTerminationOutput, error) {
	req, out := c.DeleteVoiceConnectorTerminationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVoiceConnectorTerminationCredentials = "DeleteVoiceConnectorTerminationCredentials"

// DeleteVoiceConnectorTerminationCredentialsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVoiceConnectorTerminationCredentials operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVoiceConnectorTerminationCredentials for more information on using the DeleteVoiceConnectorTerminationCredentials
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVoiceConnectorTerminationCredentialsRequest method.
//	req, resp := client.DeleteVoiceConnectorTerminationCredentialsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnectorTerminationCredentials
func (c *ChimeSDKVoice) DeleteVoiceConnectorTerminationCredentialsRequest(input *DeleteVoiceConnectorTerminationCredentialsInput) (req *request.Request, output *DeleteVoiceConnectorTerminationCredentialsOutput) {
	op := &request.Operation{
		Name:       opDeleteVoiceConnectorTerminationCredentials,
		HTTPMethod: "POST",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/termination/credentials?operation=delete",
	}

	if input == nil {
		input = &DeleteVoiceConnectorTerminationCredentialsInput{}
	}

	output = &DeleteVoiceConnectorTerminationCredentialsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVoiceConnectorTerminationCredentials API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation DeleteVoiceConnectorTerminationCredentials for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnectorTerminationCredentials
func (c *ChimeSDKVoice) DeleteVoiceConnectorTerminationCredentials(input *DeleteVoiceConnectorTerminationCredentialsInput) (*DeleteVoiceConnectorTerminationCredentialsOutput, error) {
	req, out := c.DeleteVoiceConnectorTerminationCredentialsRequest(input)
	return out, req.Send()
}

// DeleteVoiceConnectorTerminationCredentialsWithContext is the same as DeleteVoiceConnectorTerminationCredentials with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVoiceConnectorTerminationCredentials for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) DeleteVoiceConnectorTerminationCredentialsWithContext(ctx aws.Context, input *DeleteVoiceConnectorTerminationCredentialsInput, opts ...request.Option) (*DeleteVoiceConnectorTerminationCredentialsOutput, error) {
	req, out := c.DeleteVoiceConnectorTerminationCredentialsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociatePhoneNumbersFromVoiceConnector = "DisassociatePhoneNumbersFromVoiceConnector"

// DisassociatePhoneNumbersFromVoiceConnectorRequest generates a "aws/request.Request" representing the
// client's request for the DisassociatePhoneNumbersFromVoiceConnector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociatePhoneNumbersFromVoiceConnector for more information on using the DisassociatePhoneNumbersFromVoiceConnector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociatePhoneNumbersFromVoiceConnectorRequest method.
//	req, resp := client.DisassociatePhoneNumbersFromVoiceConnectorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DisassociatePhoneNumbersFromVoiceConnector
func (c *ChimeSDKVoice) DisassociatePhoneNumbersFromVoiceConnectorRequest(input *DisassociatePhoneNumbersFromVoiceConnectorInput) (req *request.Request, output *DisassociatePhoneNumbersFromVoiceConnectorOutput) {
	op := &request.Operation{
		Name:       opDisassociatePhoneNumbersFromVoiceConnector,
		HTTPMethod: "POST",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}?operation=disassociate-phone-numbers",
	}

	if input == nil {
		input = &DisassociatePhoneNumbersFromVoiceConnectorInput{}
	}

	output = &DisassociatePhoneNumbersFromVoiceConnectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociatePhoneNumbersFromVoiceConnector API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation DisassociatePhoneNumbersFromVoiceConnector for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DisassociatePhoneNumbersFromVoiceConnector
func (c *ChimeSDKVoice) DisassociatePhoneNumbersFromVoiceConnector(input *DisassociatePhoneNumbersFromVoiceConnectorInput) (*DisassociatePhoneNumbersFromVoiceConnectorOutput, error) {
	req, out := c.DisassociatePhoneNumbersFromVoiceConnectorRequest(input)
	return out, req.Send()
}

// DisassociatePhoneNumbersFromVoiceConnectorWithContext is the same as DisassociatePhoneNumbersFromVoiceConnector with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociatePhoneNumbersFromVoiceConnector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) DisassociatePhoneNumbersFromVoiceConnectorWithContext(ctx aws.Context, input *DisassociatePhoneNumbersFromVoiceConnectorInput, opts ...request.Option) (*DisassociatePhoneNumbersFromVoiceConnectorOutput, error) {
	req, out := c.DisassociatePhoneNumbersFromVoiceConnectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociatePhoneNumbersFromVoiceConnectorGroup = "DisassociatePhoneNumbersFromVoiceConnectorGroup"

// DisassociatePhoneNumbersFromVoiceConnectorGroupRequest generates a "aws/request.Request" representing the
// client's request for the DisassociatePhoneNumbersFromVoiceConnectorGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociatePhoneNumbersFromVoiceConnectorGroup for more information on using the DisassociatePhoneNumbersFromVoiceConnectorGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociatePhoneNumbersFromVoiceConnectorGroupRequest method.
//	req, resp := client.DisassociatePhoneNumbersFromVoiceConnectorGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DisassociatePhoneNumbersFromVoiceConnectorGroup
func (c *ChimeSDKVoice) DisassociatePhoneNumbersFromVoiceConnectorGroupRequest(input *DisassociatePhoneNumbersFromVoiceConnectorGroupInput) (req *request.Request, output *DisassociatePhoneNumbersFromVoiceConnectorGroupOutput) {
	op := &request.Operation{
		Name:       opDisassociatePhoneNumbersFromVoiceConnectorGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/voice-connector-groups/{voiceConnectorGroupId}?operation=disassociate-phone-numbers",
	}

	if input == nil {
		input = &DisassociatePhoneNumbersFromVoiceConnectorGroupInput{}
	}

	output = &DisassociatePhoneNumbersFromVoiceConnectorGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociatePhoneNumbersFromVoiceConnectorGroup API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation DisassociatePhoneNumbersFromVoiceConnectorGroup for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DisassociatePhoneNumbersFromVoiceConnectorGroup
func (c *ChimeSDKVoice) DisassociatePhoneNumbersFromVoiceConnectorGroup(input *DisassociatePhoneNumbersFromVoiceConnectorGroupInput) (*DisassociatePhoneNumbersFromVoiceConnectorGroupOutput, error) {
	req, out := c.DisassociatePhoneNumbersFromVoiceConnectorGroupRequest(input)
	return out, req.Send()
}

// DisassociatePhoneNumbersFromVoiceConnectorGroupWithContext is the same as DisassociatePhoneNumbersFromVoiceConnectorGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociatePhoneNumbersFromVoiceConnectorGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) DisassociatePhoneNumbersFromVoiceConnectorGroupWithContext(ctx aws.Context, input *DisassociatePhoneNumbersFromVoiceConnectorGroupInput, opts ...request.Option) (*DisassociatePhoneNumbersFromVoiceConnectorGroupOutput, error) {
	req, out := c.DisassociatePhoneNumbersFromVoiceConnectorGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGlobalSettings = "GetGlobalSettings"

// GetGlobalSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetGlobalSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGlobalSettings for more information on using the GetGlobalSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetGlobalSettingsRequest method.
//	req, resp := client.GetGlobalSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetGlobalSettings
func (c *ChimeSDKVoice) GetGlobalSettingsRequest(input *GetGlobalSettingsInput) (req *request.Request, output *GetGlobalSettingsOutput) {
	op := &request.Operation{
		Name:       opGetGlobalSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/settings",
	}

	if input == nil {
		input = &GetGlobalSettingsInput{}
	}

	output = &GetGlobalSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGlobalSettings API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation GetGlobalSettings for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetGlobalSettings
func (c *ChimeSDKVoice) GetGlobalSettings(input *GetGlobalSettingsInput) (*GetGlobalSettingsOutput, error) {
	req, out := c.GetGlobalSettingsRequest(input)
	return out, req.Send()
}

// GetGlobalSettingsWithContext is the same as GetGlobalSettings with the addition of
// the ability to pass a context and additional request options.
//
// See GetGlobalSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) GetGlobalSettingsWithContext(ctx aws.Context, input *GetGlobalSettingsInput, opts ...request.Option) (*GetGlobalSettingsOutput, error) {
	req, out := c.GetGlobalSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPhoneNumber = "GetPhoneNumber"

// GetPhoneNumberRequest generates a "aws/request.Request" representing the
// client's request for the GetPhoneNumber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPhoneNumber for more information on using the GetPhoneNumber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPhoneNumberRequest method.
//	req, resp := client.GetPhoneNumberRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetPhoneNumber
func (c *ChimeSDKVoice) GetPhoneNumberRequest(input *GetPhoneNumberInput) (req *request.Request, output *GetPhoneNumberOutput) {
	op := &request.Operation{
		Name:       opGetPhoneNumber,
		HTTPMethod: "GET",
		HTTPPath:   "/phone-numbers/{phoneNumberId}",
	}

	if input == nil {
		input = &GetPhoneNumberInput{}
	}

	output = &GetPhoneNumberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPhoneNumber API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation GetPhoneNumber for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetPhoneNumber
func (c *ChimeSDKVoice) GetPhoneNumber(input *GetPhoneNumberInput) (*GetPhoneNumberOutput, error) {
	req, out := c.GetPhoneNumberRequest(input)
	return out, req.Send()
}

// GetPhoneNumberWithContext is the same as GetPhoneNumber with the addition of
// the ability to pass a context and additional request options.
//
// See GetPhoneNumber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) GetPhoneNumberWithContext(ctx aws.Context, input *GetPhoneNumberInput, opts ...request.Option) (*GetPhoneNumberOutput, error) {
	req, out := c.GetPhoneNumberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPhoneNumberOrder = "GetPhoneNumberOrder"

// GetPhoneNumberOrderRequest generates a "aws/request.Request" representing the
// client's request for the GetPhoneNumberOrder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPhoneNumberOrder for more information on using the GetPhoneNumberOrder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPhoneNumberOrderRequest method.
//	req, resp := client.GetPhoneNumberOrderRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetPhoneNumberOrder
func (c *ChimeSDKVoice) GetPhoneNumberOrderRequest(input *GetPhoneNumberOrderInput) (req *request.Request, output *GetPhoneNumberOrderOutput) {
	op := &request.Operation{
		Name:       opGetPhoneNumberOrder,
		HTTPMethod: "GET",
		HTTPPath:   "/phone-number-orders/{phoneNumberOrderId}",
	}

	if input == nil {
		input = &GetPhoneNumberOrderInput{}
	}

	output = &GetPhoneNumberOrderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPhoneNumberOrder API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation GetPhoneNumberOrder for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetPhoneNumberOrder
func (c *ChimeSDKVoice) GetPhoneNumberOrder(input *GetPhoneNumberOrderInput) (*GetPhoneNumberOrderOutput, error) {
	req, out := c.GetPhoneNumberOrderRequest(input)
	return out, req.Send()
}

// GetPhoneNumberOrderWithContext is the same as GetPhoneNumberOrder with the addition of
// the ability to pass a context and additional request options.
//
// See GetPhoneNumberOrder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) GetPhoneNumberOrderWithContext(ctx aws.Context, input *GetPhoneNumberOrderInput, opts ...request.Option) (*GetPhoneNumberOrderOutput, error) {
	req, out := c.GetPhoneNumberOrderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPhoneNumberSettings = "GetPhoneNumberSettings"

// GetPhoneNumberSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetPhoneNumberSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPhoneNumberSettings for more information on using the GetPhoneNumberSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPhoneNumberSettingsRequest method.
//	req, resp := client.GetPhoneNumberSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetPhoneNumberSettings
func (c *ChimeSDKVoice) GetPhoneNumberSettingsRequest(input *GetPhoneNumberSettingsInput) (req *request.Request, output *GetPhoneNumberSettingsOutput) {
	op := &request.Operation{
		Name:       opGetPhoneNumberSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/settings/phone-number",
	}

	if input == nil {
		input = &GetPhoneNumberSettingsInput{}
	}

	output = &GetPhoneNumberSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPhoneNumberSettings API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation GetPhoneNumberSettings for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetPhoneNumberSettings
func (c *ChimeSDKVoice) GetPhoneNumberSettings(input *GetPhoneNumberSettingsInput) (*GetPhoneNumberSettingsOutput, error) {
	req, out := c.GetPhoneNumberSettingsRequest(input)
	return out, req.Send()
}

// GetPhoneNumberSettingsWithContext is the same as GetPhoneNumberSettings with the addition of
// the ability to pass a context and additional request options.
//
// See GetPhoneNumberSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) GetPhoneNumberSettingsWithContext(ctx aws.Context, input *GetPhoneNumberSettingsInput, opts ...request.Option) (*GetPhoneNumberSettingsOutput, error) {
	req, out := c.GetPhoneNumberSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetProxySession = "GetProxySession"

// GetProxySessionRequest generates a "aws/request.Request" representing the
// client's request for the GetProxySession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetProxySession for more information on using the GetProxySession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetProxySessionRequest method.
//	req, resp := client.GetProxySessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetProxySession
func (c *ChimeSDKVoice) GetProxySessionRequest(input *GetProxySessionInput) (req *request.Request, output *GetProxySessionOutput) {
	op := &request.Operation{
		Name:       opGetProxySession,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/proxy-sessions/{proxySessionId}",
	}

	if input == nil {
		input = &GetProxySessionInput{}
	}

	output = &GetProxySessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetProxySession API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation GetProxySession for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetProxySession
func (c *ChimeSDKVoice) GetProxySession(input *GetProxySessionInput) (*GetProxySessionOutput, error) {
	req, out := c.GetProxySessionRequest(input)
	return out, req.Send()
}

// GetProxySessionWithContext is the same as GetProxySession with the addition of
// the ability to pass a context and additional request options.
//
// See GetProxySession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) GetProxySessionWithContext(ctx aws.Context, input *GetProxySessionInput, opts ...request.Option) (*GetProxySessionOutput, error) {
	req, out := c.GetProxySessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSipMediaApplication = "GetSipMediaApplication"

// GetSipMediaApplicationRequest generates a "aws/request.Request" representing the
// client's request for the GetSipMediaApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSipMediaApplication for more information on using the GetSipMediaApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSipMediaApplicationRequest method.
//	req, resp := client.GetSipMediaApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetSipMediaApplication
func (c *ChimeSDKVoice) GetSipMediaApplicationRequest(input *GetSipMediaApplicationInput) (req *request.Request, output *GetSipMediaApplicationOutput) {
	op := &request.Operation{
		Name:       opGetSipMediaApplication,
		HTTPMethod: "GET",
		HTTPPath:   "/sip-media-applications/{sipMediaApplicationId}",
	}

	if input == nil {
		input = &GetSipMediaApplicationInput{}
	}

	output = &GetSipMediaApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSipMediaApplication API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation GetSipMediaApplication for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetSipMediaApplication
func (c *ChimeSDKVoice) GetSipMediaApplication(input *GetSipMediaApplicationInput) (*GetSipMediaApplicationOutput, error) {
	req, out := c.GetSipMediaApplicationRequest(input)
	return out, req.Send()
}

// GetSipMediaApplicationWithContext is the same as GetSipMediaApplication with the addition of
// the ability to pass a context and additional request options.
//
// See GetSipMediaApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) GetSipMediaApplicationWithContext(ctx aws.Context, input *GetSipMediaApplicationInput, opts ...request.Option) (*GetSipMediaApplicationOutput, error) {
	req, out := c.GetSipMediaApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSipMediaApplicationAlexaSkillConfiguration = "GetSipMediaApplicationAlexaSkillConfiguration"

// GetSipMediaApplicationAlexaSkillConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetSipMediaApplicationAlexaSkillConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSipMediaApplicationAlexaSkillConfiguration for more information on using the GetSipMediaApplicationAlexaSkillConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSipMediaApplicationAlexaSkillConfigurationRequest method.
//	req, resp := client.GetSipMediaApplicationAlexaSkillConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetSipMediaApplicationAlexaSkillConfiguration
func (c *ChimeSDKVoice) GetSipMediaApplicationAlexaSkillConfigurationRequest(input *GetSipMediaApplicationAlexaSkillConfigurationInput) (req *request.Request, output *GetSipMediaApplicationAlexaSkillConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetSipMediaApplicationAlexaSkillConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/sip-media-applications/{sipMediaApplicationId}/alexa-skill-configuration",
	}

	if input == nil {
		input = &GetSipMediaApplicationAlexaSkillConfigurationInput{}
	}

	output = &GetSipMediaApplicationAlexaSkillConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSipMediaApplicationAlexaSkillConfiguration API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation GetSipMediaApplicationAlexaSkillConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetSipMediaApplicationAlexaSkillConfiguration
func (c *ChimeSDKVoice) GetSipMediaApplicationAlexaSkillConfiguration(input *GetSipMediaApplicationAlexaSkillConfigurationInput) (*GetSipMediaApplicationAlexaSkillConfigurationOutput, error) {
	req, out := c.GetSipMediaApplicationAlexaSkillConfigurationRequest(input)
	return out, req.Send()
}

// GetSipMediaApplicationAlexaSkillConfigurationWithContext is the same as GetSipMediaApplicationAlexaSkillConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetSipMediaApplicationAlexaSkillConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) GetSipMediaApplicationAlexaSkillConfigurationWithContext(ctx aws.Context, input *GetSipMediaApplicationAlexaSkillConfigurationInput, opts ...request.Option) (*GetSipMediaApplicationAlexaSkillConfigurationOutput, error) {
	req, out := c.GetSipMediaApplicationAlexaSkillConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSipMediaApplicationLoggingConfiguration = "GetSipMediaApplicationLoggingConfiguration"

// GetSipMediaApplicationLoggingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetSipMediaApplicationLoggingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSipMediaApplicationLoggingConfiguration for more information on using the GetSipMediaApplicationLoggingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSipMediaApplicationLoggingConfigurationRequest method.
//	req, resp := client.GetSipMediaApplicationLoggingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetSipMediaApplicationLoggingConfiguration
func (c *ChimeSDKVoice) GetSipMediaApplicationLoggingConfigurationRequest(input *GetSipMediaApplicationLoggingConfigurationInput) (req *request.Request, output *GetSipMediaApplicationLoggingConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetSipMediaApplicationLoggingConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/sip-media-applications/{sipMediaApplicationId}/logging-configuration",
	}

	if input == nil {
		input = &GetSipMediaApplicationLoggingConfigurationInput{}
	}

	output = &GetSipMediaApplicationLoggingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSipMediaApplicationLoggingConfiguration API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation GetSipMediaApplicationLoggingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetSipMediaApplicationLoggingConfiguration
func (c *ChimeSDKVoice) GetSipMediaApplicationLoggingConfiguration(input *GetSipMediaApplicationLoggingConfigurationInput) (*GetSipMediaApplicationLoggingConfigurationOutput, error) {
	req, out := c.GetSipMediaApplicationLoggingConfigurationRequest(input)
	return out, req.Send()
}

// GetSipMediaApplicationLoggingConfigurationWithContext is the same as GetSipMediaApplicationLoggingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetSipMediaApplicationLoggingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) GetSipMediaApplicationLoggingConfigurationWithContext(ctx aws.Context, input *GetSipMediaApplicationLoggingConfigurationInput, opts ...request.Option) (*GetSipMediaApplicationLoggingConfigurationOutput, error) {
	req, out := c.GetSipMediaApplicationLoggingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSipRule = "GetSipRule"

// GetSipRuleRequest generates a "aws/request.Request" representing the
// client's request for the GetSipRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSipRule for more information on using the GetSipRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSipRuleRequest method.
//	req, resp := client.GetSipRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetSipRule
func (c *ChimeSDKVoice) GetSipRuleRequest(input *GetSipRuleInput) (req *request.Request, output *GetSipRuleOutput) {
	op := &request.Operation{
		Name:       opGetSipRule,
		HTTPMethod: "GET",
		HTTPPath:   "/sip-rules/{sipRuleId}",
	}

	if input == nil {
		input = &GetSipRuleInput{}
	}

	output = &GetSipRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSipRule API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation GetSipRule for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetSipRule
func (c *ChimeSDKVoice) GetSipRule(input *GetSipRuleInput) (*GetSipRuleOutput, error) {
	req, out := c.GetSipRuleRequest(input)
	return out, req.Send()
}

// GetSipRuleWithContext is the same as GetSipRule with the addition of
// the ability to pass a context and additional request options.
//
// See GetSipRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) GetSipRuleWithContext(ctx aws.Context, input *GetSipRuleInput, opts ...request.Option) (*GetSipRuleOutput, error) {
	req, out := c.GetSipRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVoiceConnector = "GetVoiceConnector"

// GetVoiceConnectorRequest generates a "aws/request.Request" representing the
// client's request for the GetVoiceConnector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVoiceConnector for more information on using the GetVoiceConnector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetVoiceConnectorRequest method.
//	req, resp := client.GetVoiceConnectorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnector
func (c *ChimeSDKVoice) GetVoiceConnectorRequest(input *GetVoiceConnectorInput) (req *request.Request, output *GetVoiceConnectorOutput) {
	op := &request.Operation{
		Name:       opGetVoiceConnector,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}",
	}

	if input == nil {
		input = &GetVoiceConnectorInput{}
	}

	output = &GetVoiceConnectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVoiceConnector API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation GetVoiceConnector for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnector
func (c *ChimeSDKVoice) GetVoiceConnector(input *GetVoiceConnectorInput) (*GetVoiceConnectorOutput, error) {
	req, out := c.GetVoiceConnectorRequest(input)
	return out, req.Send()
}

// GetVoiceConnectorWithContext is the same as GetVoiceConnector with the addition of
// the ability to pass a context and additional request options.
//
// See GetVoiceConnector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) GetVoiceConnectorWithContext(ctx aws.Context, input *GetVoiceConnectorInput, opts ...request.Option) (*GetVoiceConnectorOutput, error) {
	req, out := c.GetVoiceConnectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVoiceConnectorEmergencyCallingConfiguration = "GetVoiceConnectorEmergencyCallingConfiguration"

// GetVoiceConnectorEmergencyCallingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetVoiceConnectorEmergencyCallingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVoiceConnectorEmergencyCallingConfiguration for more information on using the GetVoiceConnectorEmergencyCallingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetVoiceConnectorEmergencyCallingConfigurationRequest method.
//	req, resp := client.GetVoiceConnectorEmergencyCallingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorEmergencyCallingConfiguration
func (c *ChimeSDKVoice) GetVoiceConnectorEmergencyCallingConfigurationRequest(input *GetVoiceConnectorEmergencyCallingConfigurationInput) (req *request.Request, output *GetVoiceConnectorEmergencyCallingConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetVoiceConnectorEmergencyCallingConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/emergency-calling-configuration",
	}

	if input == nil {
		input = &GetVoiceConnectorEmergencyCallingConfigurationInput{}
	}

	output = &GetVoiceConnectorEmergencyCallingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVoiceConnectorEmergencyCallingConfiguration API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation GetVoiceConnectorEmergencyCallingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorEmergencyCallingConfiguration
func (c *ChimeSDKVoice) GetVoiceConnectorEmergencyCallingConfiguration(input *GetVoiceConnectorEmergencyCallingConfigurationInput) (*GetVoiceConnectorEmergencyCallingConfigurationOutput, error) {
	req, out := c.GetVoiceConnectorEmergencyCallingConfigurationRequest(input)
	return out, req.Send()
}

// GetVoiceConnectorEmergencyCallingConfigurationWithContext is the same as GetVoiceConnectorEmergencyCallingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetVoiceConnectorEmergencyCallingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) GetVoiceConnectorEmergencyCallingConfigurationWithContext(ctx aws.Context, input *GetVoiceConnectorEmergencyCallingConfigurationInput, opts ...request.Option) (*GetVoiceConnectorEmergencyCallingConfigurationOutput, error) {
	req, out := c.GetVoiceConnectorEmergencyCallingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVoiceConnectorGroup = "GetVoiceConnectorGroup"

// GetVoiceConnectorGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetVoiceConnectorGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVoiceConnectorGroup for more information on using the GetVoiceConnectorGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetVoiceConnectorGroupRequest method.
//	req, resp := client.GetVoiceConnectorGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorGroup
func (c *ChimeSDKVoice) GetVoiceConnectorGroupRequest(input *GetVoiceConnectorGroupInput) (req *request.Request, output *GetVoiceConnectorGroupOutput) {
	op := &request.Operation{
		Name:       opGetVoiceConnectorGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connector-groups/{voiceConnectorGroupId}",
	}

	if input == nil {
		input = &GetVoiceConnectorGroupInput{}
	}

	output = &GetVoiceConnectorGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVoiceConnectorGroup API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation GetVoiceConnectorGroup for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorGroup
func (c *ChimeSDKVoice) GetVoiceConnectorGroup(input *GetVoiceConnectorGroupInput) (*GetVoiceConnectorGroupOutput, error) {
	req, out := c.GetVoiceConnectorGroupRequest(input)
	return out, req.Send()
}

// GetVoiceConnectorGroupWithContext is the same as GetVoiceConnectorGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetVoiceConnectorGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) GetVoiceConnectorGroupWithContext(ctx aws.Context, input *GetVoiceConnectorGroupInput, opts ...request.Option) (*GetVoiceConnectorGroupOutput, error) {
	req, out := c.GetVoiceConnectorGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVoiceConnectorLoggingConfiguration = "GetVoiceConnectorLoggingConfiguration"

// GetVoiceConnectorLoggingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetVoiceConnectorLoggingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVoiceConnectorLoggingConfiguration for more information on using the GetVoiceConnectorLoggingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetVoiceConnectorLoggingConfigurationRequest method.
//	req, resp := client.GetVoiceConnectorLoggingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorLoggingConfiguration
func (c *ChimeSDKVoice) GetVoiceConnectorLoggingConfigurationRequest(input *GetVoiceConnectorLoggingConfigurationInput) (req *request.Request, output *GetVoiceConnectorLoggingConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetVoiceConnectorLoggingConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/logging-configuration",
	}

	if input == nil {
		input = &GetVoiceConnectorLoggingConfigurationInput{}
	}

	output = &GetVoiceConnectorLoggingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVoiceConnectorLoggingConfiguration API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation GetVoiceConnectorLoggingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorLoggingConfiguration
func (c *ChimeSDKVoice) GetVoiceConnectorLoggingConfiguration(input *GetVoiceConnectorLoggingConfigurationInput) (*GetVoiceConnectorLoggingConfigurationOutput, error) {
	req, out := c.GetVoiceConnectorLoggingConfigurationRequest(input)
	return out, req.Send()
}

// GetVoiceConnectorLoggingConfigurationWithContext is the same as GetVoiceConnectorLoggingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetVoiceConnectorLoggingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) GetVoiceConnectorLoggingConfigurationWithContext(ctx aws.Context, input *GetVoiceConnectorLoggingConfigurationInput, opts ...request.Option) (*GetVoiceConnectorLoggingConfigurationOutput, error) {
	req, out := c.GetVoiceConnectorLoggingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVoiceConnectorOrigination = "GetVoiceConnectorOrigination"

// GetVoiceConnectorOriginationRequest generates a "aws/request.Request" representing the
// client's request for the GetVoiceConnectorOrigination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVoiceConnectorOrigination for more information on using the GetVoiceConnectorOrigination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetVoiceConnectorOriginationRequest method.
//	req, resp := client.GetVoiceConnectorOriginationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorOrigination
func (c *ChimeSDKVoice) GetVoiceConnectorOriginationRequest(input *GetVoiceConnectorOriginationInput) (req *request.Request, output *GetVoiceConnectorOriginationOutput) {
	op := &request.Operation{
		Name:       opGetVoiceConnectorOrigination,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/origination",
	}

	if input == nil {
		input = &GetVoiceConnectorOriginationInput{}
	}

	output = &GetVoiceConnectorOriginationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVoiceConnectorOrigination API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation GetVoiceConnectorOrigination for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorOrigination
func (c *ChimeSDKVoice) GetVoiceConnectorOrigination(input *GetVoiceConnectorOriginationInput) (*GetVoiceConnectorOriginationOutput, error) {
	req, out := c.GetVoiceConnectorOriginationRequest(input)
	return out, req.Send()
}

// GetVoiceConnectorOriginationWithContext is the same as GetVoiceConnectorOrigination with the addition of
// the ability to pass a context and additional request options.
//
// See GetVoiceConnectorOrigination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) GetVoiceConnectorOriginationWithContext(ctx aws.Context, input *GetVoiceConnectorOriginationInput, opts ...request.Option) (*GetVoiceConnectorOriginationOutput, error) {
	req, out := c.GetVoiceConnectorOriginationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVoiceConnectorProxy = "GetVoiceConnectorProxy"

// GetVoiceConnectorProxyRequest generates a "aws/request.Request" representing the
// client's request for the GetVoiceConnectorProxy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVoiceConnectorProxy for more information on using the GetVoiceConnectorProxy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetVoiceConnectorProxyRequest method.
//	req, resp := client.GetVoiceConnectorProxyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorProxy
func (c *ChimeSDKVoice) GetVoiceConnectorProxyRequest(input *GetVoiceConnectorProxyInput) (req *request.Request, output *GetVoiceConnectorProxyOutput) {
	op := &request.Operation{
		Name:       opGetVoiceConnectorProxy,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/programmable-numbers/proxy",
	}

	if input == nil {
		input = &GetVoiceConnectorProxyInput{}
	}

	output = &GetVoiceConnectorProxyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVoiceConnectorProxy API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation GetVoiceConnectorProxy for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorProxy
func (c *ChimeSDKVoice) GetVoiceConnectorProxy(input *GetVoiceConnectorProxyInput) (*GetVoiceConnectorProxyOutput, error) {
	req, out := c.GetVoiceConnectorProxyRequest(input)
	return out, req.Send()
}

// GetVoiceConnectorProxyWithContext is the same as GetVoiceConnectorProxy with the addition of
// the ability to pass a context and additional request options.
//
// See GetVoiceConnectorProxy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) GetVoiceConnectorProxyWithContext(ctx aws.Context, input *GetVoiceConnectorProxyInput, opts ...request.Option) (*GetVoiceConnectorProxyOutput, error) {
	req, out := c.GetVoiceConnectorProxyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVoiceConnectorStreamingConfiguration = "GetVoiceConnectorStreamingConfiguration"

// GetVoiceConnectorStreamingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetVoiceConnectorStreamingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVoiceConnectorStreamingConfiguration for more information on using the GetVoiceConnectorStreamingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetVoiceConnectorStreamingConfigurationRequest method.
//	req, resp := client.GetVoiceConnectorStreamingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorStreamingConfiguration
func (c *ChimeSDKVoice) GetVoiceConnectorStreamingConfigurationRequest(input *GetVoiceConnectorStreamingConfigurationInput) (req *request.Request, output *GetVoiceConnectorStreamingConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetVoiceConnectorStreamingConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/streaming-configuration",
	}

	if input == nil {
		input = &GetVoiceConnectorStreamingConfigurationInput{}
	}

	output = &GetVoiceConnectorStreamingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVoiceConnectorStreamingConfiguration API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation GetVoiceConnectorStreamingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorStreamingConfiguration
func (c *ChimeSDKVoice) GetVoiceConnectorStreamingConfiguration(input *GetVoiceConnectorStreamingConfigurationInput) (*GetVoiceConnectorStreamingConfigurationOutput, error) {
	req, out := c.GetVoiceConnectorStreamingConfigurationRequest(input)
	return out, req.Send()
}

// GetVoiceConnectorStreamingConfigurationWithContext is the same as GetVoiceConnectorStreamingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetVoiceConnectorStreamingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) GetVoiceConnectorStreamingConfigurationWithContext(ctx aws.Context, input *GetVoiceConnectorStreamingConfigurationInput, opts ...request.Option) (*GetVoiceConnectorStreamingConfigurationOutput, error) {
	req, out := c.GetVoiceConnectorStreamingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVoiceConnectorTermination = "GetVoiceConnectorTermination"

// GetVoiceConnectorTerminationRequest generates a "aws/request.Request" representing the
// client's request for the GetVoiceConnectorTermination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVoiceConnectorTermination for more information on using the GetVoiceConnectorTermination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetVoiceConnectorTerminationRequest method.
//	req, resp := client.GetVoiceConnectorTerminationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorTermination
func (c *ChimeSDKVoice) GetVoiceConnectorTerminationRequest(input *GetVoiceConnectorTerminationInput) (req *request.Request, output *GetVoiceConnectorTerminationOutput) {
	op := &request.Operation{
		Name:       opGetVoiceConnectorTermination,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/termination",
	}

	if input == nil {
		input = &GetVoiceConnectorTerminationInput{}
	}

	output = &GetVoiceConnectorTerminationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVoiceConnectorTermination API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation GetVoiceConnectorTermination for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorTermination
func (c *ChimeSDKVoice) GetVoiceConnectorTermination(input *GetVoiceConnectorTerminationInput) (*GetVoiceConnectorTerminationOutput, error) {
	req, out := c.GetVoiceConnectorTerminationRequest(input)
	return out, req.Send()
}

// GetVoiceConnectorTerminationWithContext is the same as GetVoiceConnectorTermination with the addition of
// the ability to pass a context and additional request options.
//
// See GetVoiceConnectorTermination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) GetVoiceConnectorTerminationWithContext(ctx aws.Context, input *GetVoiceConnectorTerminationInput, opts ...request.Option) (*GetVoiceConnectorTerminationOutput, error) {
	req, out := c.GetVoiceConnectorTerminationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVoiceConnectorTerminationHealth = "GetVoiceConnectorTerminationHealth"

// GetVoiceConnectorTerminationHealthRequest generates a "aws/request.Request" representing the
// client's request for the GetVoiceConnectorTerminationHealth operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVoiceConnectorTerminationHealth for more information on using the GetVoiceConnectorTerminationHealth
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetVoiceConnectorTerminationHealthRequest method.
//	req, resp := client.GetVoiceConnectorTerminationHealthRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorTerminationHealth
func (c *ChimeSDKVoice) GetVoiceConnectorTerminationHealthRequest(input *GetVoiceConnectorTerminationHealthInput) (req *request.Request, output *GetVoiceConnectorTerminationHealthOutput) {
	op := &request.Operation{
		Name:       opGetVoiceConnectorTerminationHealth,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/termination/health",
	}

	if input == nil {
		input = &GetVoiceConnectorTerminationHealthInput{}
	}

	output = &GetVoiceConnectorTerminationHealthOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVoiceConnectorTerminationHealth API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation GetVoiceConnectorTerminationHealth for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorTerminationHealth
func (c *ChimeSDKVoice) GetVoiceConnectorTerminationHealth(input *GetVoiceConnectorTerminationHealthInput) (*GetVoiceConnectorTerminationHealthOutput, error) {
	req, out := c.GetVoiceConnectorTerminationHealthRequest(input)
	return out, req.Send()
}

// GetVoiceConnectorTerminationHealthWithContext is the same as GetVoiceConnectorTerminationHealth with the addition of
// the ability to pass a context and additional request options.
//
// See GetVoiceConnectorTerminationHealth for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) GetVoiceConnectorTerminationHealthWithContext(ctx aws.Context, input *GetVoiceConnectorTerminationHealthInput, opts ...request.Option) (*GetVoiceConnectorTerminationHealthOutput, error) {
	req, out := c.GetVoiceConnectorTerminationHealthRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAvailableVoiceConnectorRegions = "ListAvailableVoiceConnectorRegions"

// ListAvailableVoiceConnectorRegionsRequest generates a "aws/request.Request" representing the
// client's request for the ListAvailableVoiceConnectorRegions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAvailableVoiceConnectorRegions for more information on using the ListAvailableVoiceConnectorRegions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAvailableVoiceConnectorRegionsRequest method.
//	req, resp := client.ListAvailableVoiceConnectorRegionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListAvailableVoiceConnectorRegions
func (c *ChimeSDKVoice) ListAvailableVoiceConnectorRegionsRequest(input *ListAvailableVoiceConnectorRegionsInput) (req *request.Request, output *ListAvailableVoiceConnectorRegionsOutput) {
	op := &request.Operation{
		Name:       opListAvailableVoiceConnectorRegions,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connector-regions",
	}

	if input == nil {
		input = &ListAvailableVoiceConnectorRegionsInput{}
	}

	output = &ListAvailableVoiceConnectorRegionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAvailableVoiceConnectorRegions API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation ListAvailableVoiceConnectorRegions for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListAvailableVoiceConnectorRegions
func (c *ChimeSDKVoice) ListAvailableVoiceConnectorRegions(input *ListAvailableVoiceConnectorRegionsInput) (*ListAvailableVoiceConnectorRegionsOutput, error) {
	req, out := c.ListAvailableVoiceConnectorRegionsRequest(input)
	return out, req.Send()
}

// ListAvailableVoiceConnectorRegionsWithContext is the same as ListAvailableVoiceConnectorRegions with the addition of
// the ability to pass a context and additional request options.
//
// See ListAvailableVoiceConnectorRegions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) ListAvailableVoiceConnectorRegionsWithContext(ctx aws.Context, input *ListAvailableVoiceConnectorRegionsInput, opts ...request.Option) (*ListAvailableVoiceConnectorRegionsOutput, error) {
	req, out := c.ListAvailableVoiceConnectorRegionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPhoneNumberOrders = "ListPhoneNumberOrders"

// ListPhoneNumberOrdersRequest generates a "aws/request.Request" representing the
// client's request for the ListPhoneNumberOrders operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPhoneNumberOrders for more information on using the ListPhoneNumberOrders
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPhoneNumberOrdersRequest method.
//	req, resp := client.ListPhoneNumberOrdersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListPhoneNumberOrders
func (c *ChimeSDKVoice) ListPhoneNumberOrdersRequest(input *ListPhoneNumberOrdersInput) (req *request.Request, output *ListPhoneNumberOrdersOutput) {
	op := &request.Operation{
		Name:       opListPhoneNumberOrders,
		HTTPMethod: "GET",
		HTTPPath:   "/phone-number-orders",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPhoneNumberOrdersInput{}
	}

	output = &ListPhoneNumberOrdersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPhoneNumberOrders API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation ListPhoneNumberOrders for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListPhoneNumberOrders
func (c *ChimeSDKVoice) ListPhoneNumberOrders(input *ListPhoneNumberOrdersInput) (*ListPhoneNumberOrdersOutput, error) {
	req, out := c.ListPhoneNumberOrdersRequest(input)
	return out, req.Send()
}

// ListPhoneNumberOrdersWithContext is the same as ListPhoneNumberOrders with the addition of
// the ability to pass a context and additional request options.
//
// See ListPhoneNumberOrders for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) ListPhoneNumberOrdersWithContext(ctx aws.Context, input *ListPhoneNumberOrdersInput, opts ...request.Option) (*ListPhoneNumberOrdersOutput, error) {
	req, out := c.ListPhoneNumberOrdersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPhoneNumberOrdersPages iterates over the pages of a ListPhoneNumberOrders operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPhoneNumberOrders method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPhoneNumberOrders operation.
//	pageNum := 0
//	err := client.ListPhoneNumberOrdersPages(params,
//	    func(page *chimesdkvoice.ListPhoneNumberOrdersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ChimeSDKVoice) ListPhoneNumberOrdersPages(input *ListPhoneNumberOrdersInput, fn func(*ListPhoneNumberOrdersOutput, bool) bool) error {
	return c.ListPhoneNumberOrdersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPhoneNumberOrdersPagesWithContext same as ListPhoneNumberOrdersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) ListPhoneNumberOrdersPagesWithContext(ctx aws.Context, input *ListPhoneNumberOrdersInput, fn func(*ListPhoneNumberOrdersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPhoneNumberOrdersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPhoneNumberOrdersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPhoneNumberOrdersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPhoneNumbers = "ListPhoneNumbers"

// ListPhoneNumbersRequest generates a "aws/request.Request" representing the
// client's request for the ListPhoneNumbers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPhoneNumbers for more information on using the ListPhoneNumbers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPhoneNumbersRequest method.
//	req, resp := client.ListPhoneNumbersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListPhoneNumbers
func (c *ChimeSDKVoice) ListPhoneNumbersRequest(input *ListPhoneNumbersInput) (req *request.Request, output *ListPhoneNumbersOutput) {
	op := &request.Operation{
		Name:       opListPhoneNumbers,
		HTTPMethod: "GET",
		HTTPPath:   "/phone-numbers",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPhoneNumbersInput{}
	}

	output = &ListPhoneNumbersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPhoneNumbers API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation ListPhoneNumbers for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - NotFoundException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListPhoneNumbers
func (c *ChimeSDKVoice) ListPhoneNumbers(input *ListPhoneNumbersInput) (*ListPhoneNumbersOutput, error) {
	req, out := c.ListPhoneNumbersRequest(input)
	return out, req.Send()
}

// ListPhoneNumbersWithContext is the same as ListPhoneNumbers with the addition of
// the ability to pass a context and additional request options.
//
// See ListPhoneNumbers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) ListPhoneNumbersWithContext(ctx aws.Context, input *ListPhoneNumbersInput, opts ...request.Option) (*ListPhoneNumbersOutput, error) {
	req, out := c.ListPhoneNumbersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPhoneNumbersPages iterates over the pages of a ListPhoneNumbers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPhoneNumbers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPhoneNumbers operation.
//	pageNum := 0
//	err := client.ListPhoneNumbersPages(params,
//	    func(page *chimesdkvoice.ListPhoneNumbersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ChimeSDKVoice) ListPhoneNumbersPages(input *ListPhoneNumbersInput, fn func(*ListPhoneNumbersOutput, bool) bool) error {
	return c.ListPhoneNumbersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPhoneNumbersPagesWithContext same as ListPhoneNumbersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) ListPhoneNumbersPagesWithContext(ctx aws.Context, input *ListPhoneNumbersInput, fn func(*ListPhoneNumbersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPhoneNumbersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPhoneNumbersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPhoneNumbersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProxySessions = "ListProxySessions"

// ListProxySessionsRequest generates a "aws/request.Request" representing the
// client's request for the ListProxySessions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProxySessions for more information on using the ListProxySessions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListProxySessionsRequest method.
//	req, resp := client.ListProxySessionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListProxySessions
func (c *ChimeSDKVoice) ListProxySessionsRequest(input *ListProxySessionsInput) (req *request.Request, output *ListProxySessionsOutput) {
	op := &request.Operation{
		Name:       opListProxySessions,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/proxy-sessions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProxySessionsInput{}
	}

	output = &ListProxySessionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProxySessions API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation ListProxySessions for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListProxySessions
func (c *ChimeSDKVoice) ListProxySessions(input *ListProxySessionsInput) (*ListProxySessionsOutput, error) {
	req, out := c.ListProxySessionsRequest(input)
	return out, req.Send()
}

// ListProxySessionsWithContext is the same as ListProxySessions with the addition of
// the ability to pass a context and additional request options.
//
// See ListProxySessions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) ListProxySessionsWithContext(ctx aws.Context, input *ListProxySessionsInput, opts ...request.Option) (*ListProxySessionsOutput, error) {
	req, out := c.ListProxySessionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProxySessionsPages iterates over the pages of a ListProxySessions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProxySessions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListProxySessions operation.
//	pageNum := 0
//	err := client.ListProxySessionsPages(params,
//	    func(page *chimesdkvoice.ListProxySessionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ChimeSDKVoice) ListProxySessionsPages(input *ListProxySessionsInput, fn func(*ListProxySessionsOutput, bool) bool) error {
	return c.ListProxySessionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProxySessionsPagesWithContext same as ListProxySessionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) ListProxySessionsPagesWithContext(ctx aws.Context, input *ListProxySessionsInput, fn func(*ListProxySessionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProxySessionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProxySessionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProxySessionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSipMediaApplications = "ListSipMediaApplications"

// ListSipMediaApplicationsRequest generates a "aws/request.Request" representing the
// client's request for the ListSipMediaApplications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSipMediaApplications for more information on using the ListSipMediaApplications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSipMediaApplicationsRequest method.
//	req, resp := client.ListSipMediaApplicationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListSipMediaApplications
func (c *ChimeSDKVoice) ListSipMediaApplicationsRequest(input *ListSipMediaApplicationsInput) (req *request.Request, output *ListSipMediaApplicationsOutput) {
	op := &request.Operation{
		Name:       opListSipMediaApplications,
		HTTPMethod: "GET",
		HTTPPath:   "/sip-media-applications",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSipMediaApplicationsInput{}
	}

	output = &ListSipMediaApplicationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSipMediaApplications API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation ListSipMediaApplications for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListSipMediaApplications
func (c *ChimeSDKVoice) ListSipMediaApplications(input *ListSipMediaApplicationsInput) (*ListSipMediaApplicationsOutput, error) {
	req, out := c.ListSipMediaApplicationsRequest(input)
	return out, req.Send()
}

// ListSipMediaApplicationsWithContext is the same as ListSipMediaApplications with the addition of
// the ability to pass a context and additional request options.
//
// See ListSipMediaApplications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) ListSipMediaApplicationsWithContext(ctx aws.Context, input *ListSipMediaApplicationsInput, opts ...request.Option) (*ListSipMediaApplicationsOutput, error) {
	req, out := c.ListSipMediaApplicationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSipMediaApplicationsPages iterates over the pages of a ListSipMediaApplications operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSipMediaApplications method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSipMediaApplications operation.
//	pageNum := 0
//	err := client.ListSipMediaApplicationsPages(params,
//	    func(page *chimesdkvoice.ListSipMediaApplicationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ChimeSDKVoice) ListSipMediaApplicationsPages(input *ListSipMediaApplicationsInput, fn func(*ListSipMediaApplicationsOutput, bool) bool) error {
	return c.ListSipMediaApplicationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSipMediaApplicationsPagesWithContext same as ListSipMediaApplicationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) ListSipMediaApplicationsPagesWithContext(ctx aws.Context, input *ListSipMediaApplicationsInput, fn func(*ListSipMediaApplicationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSipMediaApplicationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSipMediaApplicationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSipMediaApplicationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSipRules = "ListSipRules"

// ListSipRulesRequest generates a "aws/request.Request" representing the
// client's request for the ListSipRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSipRules for more information on using the ListSipRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSipRulesRequest method.
//	req, resp := client.ListSipRulesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListSipRules
func (c *ChimeSDKVoice) ListSipRulesRequest(input *ListSipRulesInput) (req *request.Request, output *ListSipRulesOutput) {
	op := &request.Operation{
		Name:       opListSipRules,
		HTTPMethod: "GET",
		HTTPPath:   "/sip-rules",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSipRulesInput{}
	}

	output = &ListSipRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSipRules API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation ListSipRules for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListSipRules
func (c *ChimeSDKVoice) ListSipRules(input *ListSipRulesInput) (*ListSipRulesOutput, error) {
	req, out := c.ListSipRulesRequest(input)
	return out, req.Send()
}

// ListSipRulesWithContext is the same as ListSipRules with the addition of
// the ability to pass a context and additional request options.
//
// See ListSipRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) ListSipRulesWithContext(ctx aws.Context, input *ListSipRulesInput, opts ...request.Option) (*ListSipRulesOutput, error) {
	req, out := c.ListSipRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSipRulesPages iterates over the pages of a ListSipRules operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSipRules method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSipRules operation.
//	pageNum := 0
//	err := client.ListSipRulesPages(params,
//	    func(page *chimesdkvoice.ListSipRulesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ChimeSDKVoice) ListSipRulesPages(input *ListSipRulesInput, fn func(*ListSipRulesOutput, bool) bool) error {
	return c.ListSipRulesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSipRulesPagesWithContext same as ListSipRulesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) ListSipRulesPagesWithContext(ctx aws.Context, input *ListSipRulesInput, fn func(*ListSipRulesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSipRulesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSipRulesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSipRulesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSupportedPhoneNumberCountries = "ListSupportedPhoneNumberCountries"

// ListSupportedPhoneNumberCountriesRequest generates a "aws/request.Request" representing the
// client's request for the ListSupportedPhoneNumberCountries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSupportedPhoneNumberCountries for more information on using the ListSupportedPhoneNumberCountries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSupportedPhoneNumberCountriesRequest method.
//	req, resp := client.ListSupportedPhoneNumberCountriesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListSupportedPhoneNumberCountries
func (c *ChimeSDKVoice) ListSupportedPhoneNumberCountriesRequest(input *ListSupportedPhoneNumberCountriesInput) (req *request.Request, output *ListSupportedPhoneNumberCountriesOutput) {
	op := &request.Operation{
		Name:       opListSupportedPhoneNumberCountries,
		HTTPMethod: "GET",
		HTTPPath:   "/phone-number-countries",
	}

	if input == nil {
		input = &ListSupportedPhoneNumberCountriesInput{}
	}

	output = &ListSupportedPhoneNumberCountriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSupportedPhoneNumberCountries API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation ListSupportedPhoneNumberCountries for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - ForbiddenException
//
//   - AccessDeniedException
//
//   - UnauthorizedClientException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListSupportedPhoneNumberCountries
func (c *ChimeSDKVoice) ListSupportedPhoneNumberCountries(input *ListSupportedPhoneNumberCountriesInput) (*ListSupportedPhoneNumberCountriesOutput, error) {
	req, out := c.ListSupportedPhoneNumberCountriesRequest(input)
	return out, req.Send()
}

// ListSupportedPhoneNumberCountriesWithContext is the same as ListSupportedPhoneNumberCountries with the addition of
// the ability to pass a context and additional request options.
//
// See ListSupportedPhoneNumberCountries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) ListSupportedPhoneNumberCountriesWithContext(ctx aws.Context, input *ListSupportedPhoneNumberCountriesInput, opts ...request.Option) (*ListSupportedPhoneNumberCountriesOutput, error) {
	req, out := c.ListSupportedPhoneNumberCountriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListVoiceConnectorGroups = "ListVoiceConnectorGroups"

// ListVoiceConnectorGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListVoiceConnectorGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVoiceConnectorGroups for more information on using the ListVoiceConnectorGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListVoiceConnectorGroupsRequest method.
//	req, resp := client.ListVoiceConnectorGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListVoiceConnectorGroups
func (c *ChimeSDKVoice) ListVoiceConnectorGroupsRequest(input *ListVoiceConnectorGroupsInput) (req *request.Request, output *ListVoiceConnectorGroupsOutput) {
	op := &request.Operation{
		Name:       opListVoiceConnectorGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connector-groups",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVoiceConnectorGroupsInput{}
	}

	output = &ListVoiceConnectorGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVoiceConnectorGroups API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation ListVoiceConnectorGroups for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListVoiceConnectorGroups
func (c *ChimeSDKVoice) ListVoiceConnectorGroups(input *ListVoiceConnectorGroupsInput) (*ListVoiceConnectorGroupsOutput, error) {
	req, out := c.ListVoiceConnectorGroupsRequest(input)
	return out, req.Send()
}

// ListVoiceConnectorGroupsWithContext is the same as ListVoiceConnectorGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListVoiceConnectorGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) ListVoiceConnectorGroupsWithContext(ctx aws.Context, input *ListVoiceConnectorGroupsInput, opts ...request.Option) (*ListVoiceConnectorGroupsOutput, error) {
	req, out := c.ListVoiceConnectorGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVoiceConnectorGroupsPages iterates over the pages of a ListVoiceConnectorGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVoiceConnectorGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListVoiceConnectorGroups operation.
//	pageNum := 0
//	err := client.ListVoiceConnectorGroupsPages(params,
//	    func(page *chimesdkvoice.ListVoiceConnectorGroupsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ChimeSDKVoice) ListVoiceConnectorGroupsPages(input *ListVoiceConnectorGroupsInput, fn func(*ListVoiceConnectorGroupsOutput, bool) bool) error {
	return c.ListVoiceConnectorGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVoiceConnectorGroupsPagesWithContext same as ListVoiceConnectorGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) ListVoiceConnectorGroupsPagesWithContext(ctx aws.Context, input *ListVoiceConnectorGroupsInput, fn func(*ListVoiceConnectorGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVoiceConnectorGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVoiceConnectorGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListVoiceConnectorGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListVoiceConnectorTerminationCredentials = "ListVoiceConnectorTerminationCredentials"

// ListVoiceConnectorTerminationCredentialsRequest generates a "aws/request.Request" representing the
// client's request for the ListVoiceConnectorTerminationCredentials operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVoiceConnectorTerminationCredentials for more information on using the ListVoiceConnectorTerminationCredentials
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListVoiceConnectorTerminationCredentialsRequest method.
//	req, resp := client.ListVoiceConnectorTerminationCredentialsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListVoiceConnectorTerminationCredentials
func (c *ChimeSDKVoice) ListVoiceConnectorTerminationCredentialsRequest(input *ListVoiceConnectorTerminationCredentialsInput) (req *request.Request, output *ListVoiceConnectorTerminationCredentialsOutput) {
	op := &request.Operation{
		Name:       opListVoiceConnectorTerminationCredentials,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/termination/credentials",
	}

	if input == nil {
		input = &ListVoiceConnectorTerminationCredentialsInput{}
	}

	output = &ListVoiceConnectorTerminationCredentialsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVoiceConnectorTerminationCredentials API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation ListVoiceConnectorTerminationCredentials for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListVoiceConnectorTerminationCredentials
func (c *ChimeSDKVoice) ListVoiceConnectorTerminationCredentials(input *ListVoiceConnectorTerminationCredentialsInput) (*ListVoiceConnectorTerminationCredentialsOutput, error) {
	req, out := c.ListVoiceConnectorTerminationCredentialsRequest(input)
	return out, req.Send()
}

// ListVoiceConnectorTerminationCredentialsWithContext is the same as ListVoiceConnectorTerminationCredentials with the addition of
// the ability to pass a context and additional request options.
//
// See ListVoiceConnectorTerminationCredentials for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) ListVoiceConnectorTerminationCredentialsWithContext(ctx aws.Context, input *ListVoiceConnectorTerminationCredentialsInput, opts ...request.Option) (*ListVoiceConnectorTerminationCredentialsOutput, error) {
	req, out := c.ListVoiceConnectorTerminationCredentialsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListVoiceConnectors = "ListVoiceConnectors"

// ListVoiceConnectorsRequest generates a "aws/request.Request" representing the
// client's request for the ListVoiceConnectors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVoiceConnectors for more information on using the ListVoiceConnectors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListVoiceConnectorsRequest method.
//	req, resp := client.ListVoiceConnectorsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListVoiceConnectors
func (c *ChimeSDKVoice) ListVoiceConnectorsRequest(input *ListVoiceConnectorsInput) (req *request.Request, output *ListVoiceConnectorsOutput) {
	op := &request.Operation{
		Name:       opListVoiceConnectors,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVoiceConnectorsInput{}
	}

	output = &ListVoiceConnectorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVoiceConnectors API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation ListVoiceConnectors for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListVoiceConnectors
func (c *ChimeSDKVoice) ListVoiceConnectors(input *ListVoiceConnectorsInput) (*ListVoiceConnectorsOutput, error) {
	req, out := c.ListVoiceConnectorsRequest(input)
	return out, req.Send()
}

// ListVoiceConnectorsWithContext is the same as ListVoiceConnectors with the addition of
// the ability to pass a context and additional request options.
//
// See ListVoiceConnectors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) ListVoiceConnectorsWithContext(ctx aws.Context, input *ListVoiceConnectorsInput, opts ...request.Option) (*ListVoiceConnectorsOutput, error) {
	req, out := c.ListVoiceConnectorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVoiceConnectorsPages iterates over the pages of a ListVoiceConnectors operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVoiceConnectors method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListVoiceConnectors operation.
//	pageNum := 0
//	err := client.ListVoiceConnectorsPages(params,
//	    func(page *chimesdkvoice.ListVoiceConnectorsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ChimeSDKVoice) ListVoiceConnectorsPages(input *ListVoiceConnectorsInput, fn func(*ListVoiceConnectorsOutput, bool) bool) error {
	return c.ListVoiceConnectorsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVoiceConnectorsPagesWithContext same as ListVoiceConnectorsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) ListVoiceConnectorsPagesWithContext(ctx aws.Context, input *ListVoiceConnectorsInput, fn func(*ListVoiceConnectorsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVoiceConnectorsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVoiceConnectorsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListVoiceConnectorsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutSipMediaApplicationAlexaSkillConfiguration = "PutSipMediaApplicationAlexaSkillConfiguration"

// PutSipMediaApplicationAlexaSkillConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutSipMediaApplicationAlexaSkillConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutSipMediaApplicationAlexaSkillConfiguration for more information on using the PutSipMediaApplicationAlexaSkillConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutSipMediaApplicationAlexaSkillConfigurationRequest method.
//	req, resp := client.PutSipMediaApplicationAlexaSkillConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutSipMediaApplicationAlexaSkillConfiguration
func (c *ChimeSDKVoice) PutSipMediaApplicationAlexaSkillConfigurationRequest(input *PutSipMediaApplicationAlexaSkillConfigurationInput) (req *request.Request, output *PutSipMediaApplicationAlexaSkillConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutSipMediaApplicationAlexaSkillConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/sip-media-applications/{sipMediaApplicationId}/alexa-skill-configuration",
	}

	if input == nil {
		input = &PutSipMediaApplicationAlexaSkillConfigurationInput{}
	}

	output = &PutSipMediaApplicationAlexaSkillConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutSipMediaApplicationAlexaSkillConfiguration API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation PutSipMediaApplicationAlexaSkillConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutSipMediaApplicationAlexaSkillConfiguration
func (c *ChimeSDKVoice) PutSipMediaApplicationAlexaSkillConfiguration(input *PutSipMediaApplicationAlexaSkillConfigurationInput) (*PutSipMediaApplicationAlexaSkillConfigurationOutput, error) {
	req, out := c.PutSipMediaApplicationAlexaSkillConfigurationRequest(input)
	return out, req.Send()
}

// PutSipMediaApplicationAlexaSkillConfigurationWithContext is the same as PutSipMediaApplicationAlexaSkillConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutSipMediaApplicationAlexaSkillConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) PutSipMediaApplicationAlexaSkillConfigurationWithContext(ctx aws.Context, input *PutSipMediaApplicationAlexaSkillConfigurationInput, opts ...request.Option) (*PutSipMediaApplicationAlexaSkillConfigurationOutput, error) {
	req, out := c.PutSipMediaApplicationAlexaSkillConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutSipMediaApplicationLoggingConfiguration = "PutSipMediaApplicationLoggingConfiguration"

// PutSipMediaApplicationLoggingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutSipMediaApplicationLoggingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutSipMediaApplicationLoggingConfiguration for more information on using the PutSipMediaApplicationLoggingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutSipMediaApplicationLoggingConfigurationRequest method.
//	req, resp := client.PutSipMediaApplicationLoggingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutSipMediaApplicationLoggingConfiguration
func (c *ChimeSDKVoice) PutSipMediaApplicationLoggingConfigurationRequest(input *PutSipMediaApplicationLoggingConfigurationInput) (req *request.Request, output *PutSipMediaApplicationLoggingConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutSipMediaApplicationLoggingConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/sip-media-applications/{sipMediaApplicationId}/logging-configuration",
	}

	if input == nil {
		input = &PutSipMediaApplicationLoggingConfigurationInput{}
	}

	output = &PutSipMediaApplicationLoggingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutSipMediaApplicationLoggingConfiguration API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation PutSipMediaApplicationLoggingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutSipMediaApplicationLoggingConfiguration
func (c *ChimeSDKVoice) PutSipMediaApplicationLoggingConfiguration(input *PutSipMediaApplicationLoggingConfigurationInput) (*PutSipMediaApplicationLoggingConfigurationOutput, error) {
	req, out := c.PutSipMediaApplicationLoggingConfigurationRequest(input)
	return out, req.Send()
}

// PutSipMediaApplicationLoggingConfigurationWithContext is the same as PutSipMediaApplicationLoggingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutSipMediaApplicationLoggingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) PutSipMediaApplicationLoggingConfigurationWithContext(ctx aws.Context, input *PutSipMediaApplicationLoggingConfigurationInput, opts ...request.Option) (*PutSipMediaApplicationLoggingConfigurationOutput, error) {
	req, out := c.PutSipMediaApplicationLoggingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutVoiceConnectorEmergencyCallingConfiguration = "PutVoiceConnectorEmergencyCallingConfiguration"

// PutVoiceConnectorEmergencyCallingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutVoiceConnectorEmergencyCallingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutVoiceConnectorEmergencyCallingConfiguration for more information on using the PutVoiceConnectorEmergencyCallingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutVoiceConnectorEmergencyCallingConfigurationRequest method.
//	req, resp := client.PutVoiceConnectorEmergencyCallingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutVoiceConnectorEmergencyCallingConfiguration
func (c *ChimeSDKVoice) PutVoiceConnectorEmergencyCallingConfigurationRequest(input *PutVoiceConnectorEmergencyCallingConfigurationInput) (req *request.Request, output *PutVoiceConnectorEmergencyCallingConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutVoiceConnectorEmergencyCallingConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/emergency-calling-configuration",
	}

	if input == nil {
		input = &PutVoiceConnectorEmergencyCallingConfigurationInput{}
	}

	output = &PutVoiceConnectorEmergencyCallingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutVoiceConnectorEmergencyCallingConfiguration API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation PutVoiceConnectorEmergencyCallingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutVoiceConnectorEmergencyCallingConfiguration
func (c *ChimeSDKVoice) PutVoiceConnectorEmergencyCallingConfiguration(input *PutVoiceConnectorEmergencyCallingConfigurationInput) (*PutVoiceConnectorEmergencyCallingConfigurationOutput, error) {
	req, out := c.PutVoiceConnectorEmergencyCallingConfigurationRequest(input)
	return out, req.Send()
}

// PutVoiceConnectorEmergencyCallingConfigurationWithContext is the same as PutVoiceConnectorEmergencyCallingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutVoiceConnectorEmergencyCallingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) PutVoiceConnectorEmergencyCallingConfigurationWithContext(ctx aws.Context, input *PutVoiceConnectorEmergencyCallingConfigurationInput, opts ...request.Option) (*PutVoiceConnectorEmergencyCallingConfigurationOutput, error) {
	req, out := c.PutVoiceConnectorEmergencyCallingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutVoiceConnectorLoggingConfiguration = "PutVoiceConnectorLoggingConfiguration"

// PutVoiceConnectorLoggingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutVoiceConnectorLoggingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutVoiceConnectorLoggingConfiguration for more information on using the PutVoiceConnectorLoggingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutVoiceConnectorLoggingConfigurationRequest method.
//	req, resp := client.PutVoiceConnectorLoggingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutVoiceConnectorLoggingConfiguration
func (c *ChimeSDKVoice) PutVoiceConnectorLoggingConfigurationRequest(input *PutVoiceConnectorLoggingConfigurationInput) (req *request.Request, output *PutVoiceConnectorLoggingConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutVoiceConnectorLoggingConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/logging-configuration",
	}

	if input == nil {
		input = &PutVoiceConnectorLoggingConfigurationInput{}
	}

	output = &PutVoiceConnectorLoggingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutVoiceConnectorLoggingConfiguration API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation PutVoiceConnectorLoggingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutVoiceConnectorLoggingConfiguration
func (c *ChimeSDKVoice) PutVoiceConnectorLoggingConfiguration(input *PutVoiceConnectorLoggingConfigurationInput) (*PutVoiceConnectorLoggingConfigurationOutput, error) {
	req, out := c.PutVoiceConnectorLoggingConfigurationRequest(input)
	return out, req.Send()
}

// PutVoiceConnectorLoggingConfigurationWithContext is the same as PutVoiceConnectorLoggingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutVoiceConnectorLoggingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) PutVoiceConnectorLoggingConfigurationWithContext(ctx aws.Context, input *PutVoiceConnectorLoggingConfigurationInput, opts ...request.Option) (*PutVoiceConnectorLoggingConfigurationOutput, error) {
	req, out := c.PutVoiceConnectorLoggingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutVoiceConnectorOrigination = "PutVoiceConnectorOrigination"

// PutVoiceConnectorOriginationRequest generates a "aws/request.Request" representing the
// client's request for the PutVoiceConnectorOrigination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutVoiceConnectorOrigination for more information on using the PutVoiceConnectorOrigination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutVoiceConnectorOriginationRequest method.
//	req, resp := client.PutVoiceConnectorOriginationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutVoiceConnectorOrigination
func (c *ChimeSDKVoice) PutVoiceConnectorOriginationRequest(input *PutVoiceConnectorOriginationInput) (req *request.Request, output *PutVoiceConnectorOriginationOutput) {
	op := &request.Operation{
		Name:       opPutVoiceConnectorOrigination,
		HTTPMethod: "PUT",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/origination",
	}

	if input == nil {
		input = &PutVoiceConnectorOriginationInput{}
	}

	output = &PutVoiceConnectorOriginationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutVoiceConnectorOrigination API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation PutVoiceConnectorOrigination for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutVoiceConnectorOrigination
func (c *ChimeSDKVoice) PutVoiceConnectorOrigination(input *PutVoiceConnectorOriginationInput) (*PutVoiceConnectorOriginationOutput, error) {
	req, out := c.PutVoiceConnectorOriginationRequest(input)
	return out, req.Send()
}

// PutVoiceConnectorOriginationWithContext is the same as PutVoiceConnectorOrigination with the addition of
// the ability to pass a context and additional request options.
//
// See PutVoiceConnectorOrigination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) PutVoiceConnectorOriginationWithContext(ctx aws.Context, input *PutVoiceConnectorOriginationInput, opts ...request.Option) (*PutVoiceConnectorOriginationOutput, error) {
	req, out := c.PutVoiceConnectorOriginationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutVoiceConnectorProxy = "PutVoiceConnectorProxy"

// PutVoiceConnectorProxyRequest generates a "aws/request.Request" representing the
// client's request for the PutVoiceConnectorProxy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutVoiceConnectorProxy for more information on using the PutVoiceConnectorProxy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutVoiceConnectorProxyRequest method.
//	req, resp := client.PutVoiceConnectorProxyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutVoiceConnectorProxy
func (c *ChimeSDKVoice) PutVoiceConnectorProxyRequest(input *PutVoiceConnectorProxyInput) (req *request.Request, output *PutVoiceConnectorProxyOutput) {
	op := &request.Operation{
		Name:       opPutVoiceConnectorProxy,
		HTTPMethod: "PUT",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/programmable-numbers/proxy",
	}

	if input == nil {
		input = &PutVoiceConnectorProxyInput{}
	}

	output = &PutVoiceConnectorProxyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutVoiceConnectorProxy API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation PutVoiceConnectorProxy for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - AccessDeniedException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutVoiceConnectorProxy
func (c *ChimeSDKVoice) PutVoiceConnectorProxy(input *PutVoiceConnectorProxyInput) (*PutVoiceConnectorProxyOutput, error) {
	req, out := c.PutVoiceConnectorProxyRequest(input)
	return out, req.Send()
}

// PutVoiceConnectorProxyWithContext is the same as PutVoiceConnectorProxy with the addition of
// the ability to pass a context and additional request options.
//
// See PutVoiceConnectorProxy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) PutVoiceConnectorProxyWithContext(ctx aws.Context, input *PutVoiceConnectorProxyInput, opts ...request.Option) (*PutVoiceConnectorProxyOutput, error) {
	req, out := c.PutVoiceConnectorProxyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutVoiceConnectorStreamingConfiguration = "PutVoiceConnectorStreamingConfiguration"

// PutVoiceConnectorStreamingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutVoiceConnectorStreamingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutVoiceConnectorStreamingConfiguration for more information on using the PutVoiceConnectorStreamingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutVoiceConnectorStreamingConfigurationRequest method.
//	req, resp := client.PutVoiceConnectorStreamingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutVoiceConnectorStreamingConfiguration
func (c *ChimeSDKVoice) PutVoiceConnectorStreamingConfigurationRequest(input *PutVoiceConnectorStreamingConfigurationInput) (req *request.Request, output *PutVoiceConnectorStreamingConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutVoiceConnectorStreamingConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/streaming-configuration",
	}

	if input == nil {
		input = &PutVoiceConnectorStreamingConfigurationInput{}
	}

	output = &PutVoiceConnectorStreamingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutVoiceConnectorStreamingConfiguration API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation PutVoiceConnectorStreamingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutVoiceConnectorStreamingConfiguration
func (c *ChimeSDKVoice) PutVoiceConnectorStreamingConfiguration(input *PutVoiceConnectorStreamingConfigurationInput) (*PutVoiceConnectorStreamingConfigurationOutput, error) {
	req, out := c.PutVoiceConnectorStreamingConfigurationRequest(input)
	return out, req.Send()
}

// PutVoiceConnectorStreamingConfigurationWithContext is the same as PutVoiceConnectorStreamingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutVoiceConnectorStreamingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) PutVoiceConnectorStreamingConfigurationWithContext(ctx aws.Context, input *PutVoiceConnectorStreamingConfigurationInput, opts ...request.Option) (*PutVoiceConnectorStreamingConfigurationOutput, error) {
	req, out := c.PutVoiceConnectorStreamingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutVoiceConnectorTermination = "PutVoiceConnectorTermination"

// PutVoiceConnectorTerminationRequest generates a "aws/request.Request" representing the
// client's request for the PutVoiceConnectorTermination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutVoiceConnectorTermination for more information on using the PutVoiceConnectorTermination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutVoiceConnectorTerminationRequest method.
//	req, resp := client.PutVoiceConnectorTerminationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutVoiceConnectorTermination
func (c *ChimeSDKVoice) PutVoiceConnectorTerminationRequest(input *PutVoiceConnectorTerminationInput) (req *request.Request, output *PutVoiceConnectorTerminationOutput) {
	op := &request.Operation{
		Name:       opPutVoiceConnectorTermination,
		HTTPMethod: "PUT",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/termination",
	}

	if input == nil {
		input = &PutVoiceConnectorTerminationInput{}
	}

	output = &PutVoiceConnectorTerminationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutVoiceConnectorTermination API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation PutVoiceConnectorTermination for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - AccessDeniedException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutVoiceConnectorTermination
func (c *ChimeSDKVoice) PutVoiceConnectorTermination(input *PutVoiceConnectorTerminationInput) (*PutVoiceConnectorTerminationOutput, error) {
	req, out := c.PutVoiceConnectorTerminationRequest(input)
	return out, req.Send()
}

// PutVoiceConnectorTerminationWithContext is the same as PutVoiceConnectorTermination with the addition of
// the ability to pass a context and additional request options.
//
// See PutVoiceConnectorTermination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) PutVoiceConnectorTerminationWithContext(ctx aws.Context, input *PutVoiceConnectorTerminationInput, opts ...request.Option) (*PutVoiceConnectorTerminationOutput, error) {
	req, out := c.PutVoiceConnectorTerminationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutVoiceConnectorTerminationCredentials = "PutVoiceConnectorTerminationCredentials"

// PutVoiceConnectorTerminationCredentialsRequest generates a "aws/request.Request" representing the
// client's request for the PutVoiceConnectorTerminationCredentials operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutVoiceConnectorTerminationCredentials for more information on using the PutVoiceConnectorTerminationCredentials
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutVoiceConnectorTerminationCredentialsRequest method.
//	req, resp := client.PutVoiceConnectorTerminationCredentialsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutVoiceConnectorTerminationCredentials
func (c *ChimeSDKVoice) PutVoiceConnectorTerminationCredentialsRequest(input *PutVoiceConnectorTerminationCredentialsInput) (req *request.Request, output *PutVoiceConnectorTerminationCredentialsOutput) {
	op := &request.Operation{
		Name:       opPutVoiceConnectorTerminationCredentials,
		HTTPMethod: "POST",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/termination/credentials?operation=put",
	}

	if input == nil {
		input = &PutVoiceConnectorTerminationCredentialsInput{}
	}

	output = &PutVoiceConnectorTerminationCredentialsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutVoiceConnectorTerminationCredentials API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation PutVoiceConnectorTerminationCredentials for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutVoiceConnectorTerminationCredentials
func (c *ChimeSDKVoice) PutVoiceConnectorTerminationCredentials(input *PutVoiceConnectorTerminationCredentialsInput) (*PutVoiceConnectorTerminationCredentialsOutput, error) {
	req, out := c.PutVoiceConnectorTerminationCredentialsRequest(input)
	return out, req.Send()
}

// PutVoiceConnectorTerminationCredentialsWithContext is the same as PutVoiceConnectorTerminationCredentials with the addition of
// the ability to pass a context and additional request options.
//
// See PutVoiceConnectorTerminationCredentials for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) PutVoiceConnectorTerminationCredentialsWithContext(ctx aws.Context, input *PutVoiceConnectorTerminationCredentialsInput, opts ...request.Option) (*PutVoiceConnectorTerminationCredentialsOutput, error) {
	req, out := c.PutVoiceConnectorTerminationCredentialsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestorePhoneNumber = "RestorePhoneNumber"

// RestorePhoneNumberRequest generates a "aws/request.Request" representing the
// client's request for the RestorePhoneNumber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestorePhoneNumber for more information on using the RestorePhoneNumber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RestorePhoneNumberRequest method.
//	req, resp := client.RestorePhoneNumberRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/RestorePhoneNumber
func (c *ChimeSDKVoice) RestorePhoneNumberRequest(input *RestorePhoneNumberInput) (req *request.Request, output *RestorePhoneNumberOutput) {
	op := &request.Operation{
		Name:       opRestorePhoneNumber,
		HTTPMethod: "POST",
		HTTPPath:   "/phone-numbers/{phoneNumberId}?operation=restore",
	}

	if input == nil {
		input = &RestorePhoneNumberInput{}
	}

	output = &RestorePhoneNumberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RestorePhoneNumber API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation RestorePhoneNumber for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ResourceLimitExceededException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/RestorePhoneNumber
func (c *ChimeSDKVoice) RestorePhoneNumber(input *RestorePhoneNumberInput) (*RestorePhoneNumberOutput, error) {
	req, out := c.RestorePhoneNumberRequest(input)
	return out, req.Send()
}

// RestorePhoneNumberWithContext is the same as RestorePhoneNumber with the addition of
// the ability to pass a context and additional request options.
//
// See RestorePhoneNumber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) RestorePhoneNumberWithContext(ctx aws.Context, input *RestorePhoneNumberInput, opts ...request.Option) (*RestorePhoneNumberOutput, error) {
	req, out := c.RestorePhoneNumberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchAvailablePhoneNumbers = "SearchAvailablePhoneNumbers"

// SearchAvailablePhoneNumbersRequest generates a "aws/request.Request" representing the
// client's request for the SearchAvailablePhoneNumbers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchAvailablePhoneNumbers for more information on using the SearchAvailablePhoneNumbers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchAvailablePhoneNumbersRequest method.
//	req, resp := client.SearchAvailablePhoneNumbersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/SearchAvailablePhoneNumbers
func (c *ChimeSDKVoice) SearchAvailablePhoneNumbersRequest(input *SearchAvailablePhoneNumbersInput) (req *request.Request, output *SearchAvailablePhoneNumbersOutput) {
	op := &request.Operation{
		Name:       opSearchAvailablePhoneNumbers,
		HTTPMethod: "GET",
		HTTPPath:   "/search?type=phone-numbers",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchAvailablePhoneNumbersInput{}
	}

	output = &SearchAvailablePhoneNumbersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchAvailablePhoneNumbers API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation SearchAvailablePhoneNumbers for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - ForbiddenException
//
//   - AccessDeniedException
//
//   - UnauthorizedClientException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/SearchAvailablePhoneNumbers
func (c *ChimeSDKVoice) SearchAvailablePhoneNumbers(input *SearchAvailablePhoneNumbersInput) (*SearchAvailablePhoneNumbersOutput, error) {
	req, out := c.SearchAvailablePhoneNumbersRequest(input)
	return out, req.Send()
}

// SearchAvailablePhoneNumbersWithContext is the same as SearchAvailablePhoneNumbers with the addition of
// the ability to pass a context and additional request options.
//
// See SearchAvailablePhoneNumbers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) SearchAvailablePhoneNumbersWithContext(ctx aws.Context, input *SearchAvailablePhoneNumbersInput, opts ...request.Option) (*SearchAvailablePhoneNumbersOutput, error) {
	req, out := c.SearchAvailablePhoneNumbersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchAvailablePhoneNumbersPages iterates over the pages of a SearchAvailablePhoneNumbers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchAvailablePhoneNumbers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a SearchAvailablePhoneNumbers operation.
//	pageNum := 0
//	err := client.SearchAvailablePhoneNumbersPages(params,
//	    func(page *chimesdkvoice.SearchAvailablePhoneNumbersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ChimeSDKVoice) SearchAvailablePhoneNumbersPages(input *SearchAvailablePhoneNumbersInput, fn func(*SearchAvailablePhoneNumbersOutput, bool) bool) error {
	return c.SearchAvailablePhoneNumbersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchAvailablePhoneNumbersPagesWithContext same as SearchAvailablePhoneNumbersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) SearchAvailablePhoneNumbersPagesWithContext(ctx aws.Context, input *SearchAvailablePhoneNumbersInput, fn func(*SearchAvailablePhoneNumbersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchAvailablePhoneNumbersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchAvailablePhoneNumbersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchAvailablePhoneNumbersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opUpdateGlobalSettings = "UpdateGlobalSettings"

// UpdateGlobalSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGlobalSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGlobalSettings for more information on using the UpdateGlobalSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateGlobalSettingsRequest method.
//	req, resp := client.UpdateGlobalSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateGlobalSettings
func (c *ChimeSDKVoice) UpdateGlobalSettingsRequest(input *UpdateGlobalSettingsInput) (req *request.Request, output *UpdateGlobalSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdateGlobalSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/settings",
	}

	if input == nil {
		input = &UpdateGlobalSettingsInput{}
	}

	output = &UpdateGlobalSettingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateGlobalSettings API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation UpdateGlobalSettings for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateGlobalSettings
func (c *ChimeSDKVoice) UpdateGlobalSettings(input *UpdateGlobalSettingsInput) (*UpdateGlobalSettingsOutput, error) {
	req, out := c.UpdateGlobalSettingsRequest(input)
	return out, req.Send()
}

// UpdateGlobalSettingsWithContext is the same as UpdateGlobalSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGlobalSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) UpdateGlobalSettingsWithContext(ctx aws.Context, input *UpdateGlobalSettingsInput, opts ...request.Option) (*UpdateGlobalSettingsOutput, error) {
	req, out := c.UpdateGlobalSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePhoneNumber = "UpdatePhoneNumber"

// UpdatePhoneNumberRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePhoneNumber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePhoneNumber for more information on using the UpdatePhoneNumber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdatePhoneNumberRequest method.
//	req, resp := client.UpdatePhoneNumberRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdatePhoneNumber
func (c *ChimeSDKVoice) UpdatePhoneNumberRequest(input *UpdatePhoneNumberInput) (req *request.Request, output *UpdatePhoneNumberOutput) {
	op := &request.Operation{
		Name:       opUpdatePhoneNumber,
		HTTPMethod: "POST",
		HTTPPath:   "/phone-numbers/{phoneNumberId}",
	}

	if input == nil {
		input = &UpdatePhoneNumberInput{}
	}

	output = &UpdatePhoneNumberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePhoneNumber API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation UpdatePhoneNumber for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ConflictException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdatePhoneNumber
func (c *ChimeSDKVoice) UpdatePhoneNumber(input *UpdatePhoneNumberInput) (*UpdatePhoneNumberOutput, error) {
	req, out := c.UpdatePhoneNumberRequest(input)
	return out, req.Send()
}

// UpdatePhoneNumberWithContext is the same as UpdatePhoneNumber with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePhoneNumber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) UpdatePhoneNumberWithContext(ctx aws.Context, input *UpdatePhoneNumberInput, opts ...request.Option) (*UpdatePhoneNumberOutput, error) {
	req, out := c.UpdatePhoneNumberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePhoneNumberSettings = "UpdatePhoneNumberSettings"

// UpdatePhoneNumberSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePhoneNumberSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePhoneNumberSettings for more information on using the UpdatePhoneNumberSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdatePhoneNumberSettingsRequest method.
//	req, resp := client.UpdatePhoneNumberSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdatePhoneNumberSettings
func (c *ChimeSDKVoice) UpdatePhoneNumberSettingsRequest(input *UpdatePhoneNumberSettingsInput) (req *request.Request, output *UpdatePhoneNumberSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdatePhoneNumberSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/settings/phone-number",
	}

	if input == nil {
		input = &UpdatePhoneNumberSettingsInput{}
	}

	output = &UpdatePhoneNumberSettingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdatePhoneNumberSettings API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation UpdatePhoneNumberSettings for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdatePhoneNumberSettings
func (c *ChimeSDKVoice) UpdatePhoneNumberSettings(input *UpdatePhoneNumberSettingsInput) (*UpdatePhoneNumberSettingsOutput, error) {
	req, out := c.UpdatePhoneNumberSettingsRequest(input)
	return out, req.Send()
}

// UpdatePhoneNumberSettingsWithContext is the same as UpdatePhoneNumberSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePhoneNumberSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) UpdatePhoneNumberSettingsWithContext(ctx aws.Context, input *UpdatePhoneNumberSettingsInput, opts ...request.Option) (*UpdatePhoneNumberSettingsOutput, error) {
	req, out := c.UpdatePhoneNumberSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateProxySession = "UpdateProxySession"

// UpdateProxySessionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProxySession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateProxySession for more information on using the UpdateProxySession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateProxySessionRequest method.
//	req, resp := client.UpdateProxySessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateProxySession
func (c *ChimeSDKVoice) UpdateProxySessionRequest(input *UpdateProxySessionInput) (req *request.Request, output *UpdateProxySessionOutput) {
	op := &request.Operation{
		Name:       opUpdateProxySession,
		HTTPMethod: "POST",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/proxy-sessions/{proxySessionId}",
	}

	if input == nil {
		input = &UpdateProxySessionInput{}
	}

	output = &UpdateProxySessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateProxySession API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation UpdateProxySession for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateProxySession
func (c *ChimeSDKVoice) UpdateProxySession(input *UpdateProxySessionInput) (*UpdateProxySessionOutput, error) {
	req, out := c.UpdateProxySessionRequest(input)
	return out, req.Send()
}

// UpdateProxySessionWithContext is the same as UpdateProxySession with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateProxySession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) UpdateProxySessionWithContext(ctx aws.Context, input *UpdateProxySessionInput, opts ...request.Option) (*UpdateProxySessionOutput, error) {
	req, out := c.UpdateProxySessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSipMediaApplication = "UpdateSipMediaApplication"

// UpdateSipMediaApplicationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSipMediaApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSipMediaApplication for more information on using the UpdateSipMediaApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSipMediaApplicationRequest method.
//	req, resp := client.UpdateSipMediaApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateSipMediaApplication
func (c *ChimeSDKVoice) UpdateSipMediaApplicationRequest(input *UpdateSipMediaApplicationInput) (req *request.Request, output *UpdateSipMediaApplicationOutput) {
	op := &request.Operation{
		Name:       opUpdateSipMediaApplication,
		HTTPMethod: "PUT",
		HTTPPath:   "/sip-media-applications/{sipMediaApplicationId}",
	}

	if input == nil {
		input = &UpdateSipMediaApplicationInput{}
	}

	output = &UpdateSipMediaApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSipMediaApplication API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation UpdateSipMediaApplication for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ConflictException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateSipMediaApplication
func (c *ChimeSDKVoice) UpdateSipMediaApplication(input *UpdateSipMediaApplicationInput) (*UpdateSipMediaApplicationOutput, error) {
	req, out := c.UpdateSipMediaApplicationRequest(input)
	return out, req.Send()
}

// UpdateSipMediaApplicationWithContext is the same as UpdateSipMediaApplication with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSipMediaApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) UpdateSipMediaApplicationWithContext(ctx aws.Context, input *UpdateSipMediaApplicationInput, opts ...request.Option) (*UpdateSipMediaApplicationOutput, error) {
	req, out := c.UpdateSipMediaApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSipMediaApplicationCall = "UpdateSipMediaApplicationCall"

// UpdateSipMediaApplicationCallRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSipMediaApplicationCall operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSipMediaApplicationCall for more information on using the UpdateSipMediaApplicationCall
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSipMediaApplicationCallRequest method.
//	req, resp := client.UpdateSipMediaApplicationCallRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateSipMediaApplicationCall
func (c *ChimeSDKVoice) UpdateSipMediaApplicationCallRequest(input *UpdateSipMediaApplicationCallInput) (req *request.Request, output *UpdateSipMediaApplicationCallOutput) {
	op := &request.Operation{
		Name:       opUpdateSipMediaApplicationCall,
		HTTPMethod: "POST",
		HTTPPath:   "/sip-media-applications/{sipMediaApplicationId}/calls/{transactionId}",
	}

	if input == nil {
		input = &UpdateSipMediaApplicationCallInput{}
	}

	output = &UpdateSipMediaApplicationCallOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSipMediaApplicationCall API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation UpdateSipMediaApplicationCall for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - ResourceLimitExceededException
//
//   - ThrottledClientException
//
//   - UnauthorizedClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateSipMediaApplicationCall
func (c *ChimeSDKVoice) UpdateSipMediaApplicationCall(input *UpdateSipMediaApplicationCallInput) (*UpdateSipMediaApplicationCallOutput, error) {
	req, out := c.UpdateSipMediaApplicationCallRequest(input)
	return out, req.Send()
}

// UpdateSipMediaApplicationCallWithContext is the same as UpdateSipMediaApplicationCall with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSipMediaApplicationCall for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) UpdateSipMediaApplicationCallWithContext(ctx aws.Context, input *UpdateSipMediaApplicationCallInput, opts ...request.Option) (*UpdateSipMediaApplicationCallOutput, error) {
	req, out := c.UpdateSipMediaApplicationCallRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSipRule = "UpdateSipRule"

// UpdateSipRuleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSipRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSipRule for more information on using the UpdateSipRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSipRuleRequest method.
//	req, resp := client.UpdateSipRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateSipRule
func (c *ChimeSDKVoice) UpdateSipRuleRequest(input *UpdateSipRuleInput) (req *request.Request, output *UpdateSipRuleOutput) {
	op := &request.Operation{
		Name:       opUpdateSipRule,
		HTTPMethod: "PUT",
		HTTPPath:   "/sip-rules/{sipRuleId}",
	}

	if input == nil {
		input = &UpdateSipRuleInput{}
	}

	output = &UpdateSipRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSipRule API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation UpdateSipRule for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ConflictException
//
//   - ThrottledClientException
//
//   - ResourceLimitExceededException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateSipRule
func (c *ChimeSDKVoice) UpdateSipRule(input *UpdateSipRuleInput) (*UpdateSipRuleOutput, error) {
	req, out := c.UpdateSipRuleRequest(input)
	return out, req.Send()
}

// UpdateSipRuleWithContext is the same as UpdateSipRule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSipRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) UpdateSipRuleWithContext(ctx aws.Context, input *UpdateSipRuleInput, opts ...request.Option) (*UpdateSipRuleOutput, error) {
	req, out := c.UpdateSipRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVoiceConnector = "UpdateVoiceConnector"

// UpdateVoiceConnectorRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVoiceConnector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVoiceConnector for more information on using the UpdateVoiceConnector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateVoiceConnectorRequest method.
//	req, resp := client.UpdateVoiceConnectorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateVoiceConnector
func (c *ChimeSDKVoice) UpdateVoiceConnectorRequest(input *UpdateVoiceConnectorInput) (req *request.Request, output *UpdateVoiceConnectorOutput) {
	op := &request.Operation{
		Name:       opUpdateVoiceConnector,
		HTTPMethod: "PUT",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}",
	}

	if input == nil {
		input = &UpdateVoiceConnectorInput{}
	}

	output = &UpdateVoiceConnectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateVoiceConnector API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation UpdateVoiceConnector for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateVoiceConnector
func (c *ChimeSDKVoice) UpdateVoiceConnector(input *UpdateVoiceConnectorInput) (*UpdateVoiceConnectorOutput, error) {
	req, out := c.UpdateVoiceConnectorRequest(input)
	return out, req.Send()
}

// UpdateVoiceConnectorWithContext is the same as UpdateVoiceConnector with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVoiceConnector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) UpdateVoiceConnectorWithContext(ctx aws.Context, input *UpdateVoiceConnectorInput, opts ...request.Option) (*UpdateVoiceConnectorOutput, error) {
	req, out := c.UpdateVoiceConnectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVoiceConnectorGroup = "UpdateVoiceConnectorGroup"

// UpdateVoiceConnectorGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVoiceConnectorGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVoiceConnectorGroup for more information on using the UpdateVoiceConnectorGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateVoiceConnectorGroupRequest method.
//	req, resp := client.UpdateVoiceConnectorGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateVoiceConnectorGroup
func (c *ChimeSDKVoice) UpdateVoiceConnectorGroupRequest(input *UpdateVoiceConnectorGroupInput) (req *request.Request, output *UpdateVoiceConnectorGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateVoiceConnectorGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/voice-connector-groups/{voiceConnectorGroupId}",
	}

	if input == nil {
		input = &UpdateVoiceConnectorGroupInput{}
	}

	output = &UpdateVoiceConnectorGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateVoiceConnectorGroup API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation UpdateVoiceConnectorGroup for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ConflictException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateVoiceConnectorGroup
func (c *ChimeSDKVoice) UpdateVoiceConnectorGroup(input *UpdateVoiceConnectorGroupInput) (*UpdateVoiceConnectorGroupOutput, error) {
	req, out := c.UpdateVoiceConnectorGroupRequest(input)
	return out, req.Send()
}

// UpdateVoiceConnectorGroupWithContext is the same as UpdateVoiceConnectorGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVoiceConnectorGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) UpdateVoiceConnectorGroupWithContext(ctx aws.Context, input *UpdateVoiceConnectorGroupInput, opts ...request.Option) (*UpdateVoiceConnectorGroupOutput, error) {
	req, out := c.UpdateVoiceConnectorGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opValidateE911Address = "ValidateE911Address"

// ValidateE911AddressRequest generates a "aws/request.Request" representing the
// client's request for the ValidateE911Address operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ValidateE911Address for more information on using the ValidateE911Address
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ValidateE911AddressRequest method.
//	req, resp := client.ValidateE911AddressRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ValidateE911Address
func (c *ChimeSDKVoice) ValidateE911AddressRequest(input *ValidateE911AddressInput) (req *request.Request, output *ValidateE911AddressOutput) {
	op := &request.Operation{
		Name:       opValidateE911Address,
		HTTPMethod: "POST",
		HTTPPath:   "/emergency-calling/address",
	}

	if input == nil {
		input = &ValidateE911AddressInput{}
	}

	output = &ValidateE911AddressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ValidateE911Address API operation for Amazon Chime SDK Voice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Voice's
// API operation ValidateE911Address for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//
//   - NotFoundException
//
//   - ForbiddenException
//
//   - BadRequestException
//
//   - ThrottledClientException
//
//   - ServiceUnavailableException
//
//   - ServiceFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ValidateE911Address
func (c *ChimeSDKVoice) ValidateE911Address(input *ValidateE911AddressInput) (*ValidateE911AddressOutput, error) {
	req, out := c.ValidateE911AddressRequest(input)
	return out, req.Send()
}

// ValidateE911AddressWithContext is the same as ValidateE911Address with the addition of
// the ability to pass a context and additional request options.
//
// See ValidateE911Address for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKVoice) ValidateE911AddressWithContext(ctx aws.Context, input *ValidateE911AddressInput, opts ...request.Option) (*ValidateE911AddressOutput, error) {
	req, out := c.ValidateE911AddressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type Address struct {
	_ struct{} `type:"structure"`

	// City is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	City *string `locationName:"city" type:"string" sensitive:"true"`

	// Country is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	Country *string `locationName:"country" type:"string" sensitive:"true"`

	// PostDirectional is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	PostDirectional *string `locationName:"postDirectional" type:"string" sensitive:"true"`

	// PostalCode is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	PostalCode *string `locationName:"postalCode" type:"string" sensitive:"true"`

	// PostalCodePlus4 is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	PostalCodePlus4 *string `locationName:"postalCodePlus4" type:"string" sensitive:"true"`

	// PreDirectional is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	PreDirectional *string `locationName:"preDirectional" type:"string" sensitive:"true"`

	// State is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	State *string `locationName:"state" type:"string" sensitive:"true"`

	// StreetName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	StreetName *string `locationName:"streetName" type:"string" sensitive:"true"`

	// StreetNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	StreetNumber *string `locationName:"streetNumber" type:"string" sensitive:"true"`

	// StreetSuffix is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	StreetSuffix *string `locationName:"streetSuffix" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Address) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Address) GoString() string {
	return s.String()
}

// SetCity sets the City field's value.
func (s *Address) SetCity(v string) *Address {
	s.City = &v
	return s
}

// SetCountry sets the Country field's value.
func (s *Address) SetCountry(v string) *Address {
	s.Country = &v
	return s
}

// SetPostDirectional sets the PostDirectional field's value.
func (s *Address) SetPostDirectional(v string) *Address {
	s.PostDirectional = &v
	return s
}

// SetPostalCode sets the PostalCode field's value.
func (s *Address) SetPostalCode(v string) *Address {
	s.PostalCode = &v
	return s
}

// SetPostalCodePlus4 sets the PostalCodePlus4 field's value.
func (s *Address) SetPostalCodePlus4(v string) *Address {
	s.PostalCodePlus4 = &v
	return s
}

// SetPreDirectional sets the PreDirectional field's value.
func (s *Address) SetPreDirectional(v string) *Address {
	s.PreDirectional = &v
	return s
}

// SetState sets the State field's value.
func (s *Address) SetState(v string) *Address {
	s.State = &v
	return s
}

// SetStreetName sets the StreetName field's value.
func (s *Address) SetStreetName(v string) *Address {
	s.StreetName = &v
	return s
}

// SetStreetNumber sets the StreetNumber field's value.
func (s *Address) SetStreetNumber(v string) *Address {
	s.StreetNumber = &v
	return s
}

// SetStreetSuffix sets the StreetSuffix field's value.
func (s *Address) SetStreetSuffix(v string) *Address {
	s.StreetSuffix = &v
	return s
}

type AssociatePhoneNumbersWithVoiceConnectorGroupInput struct {
	_ struct{} `type:"structure"`

	// E164PhoneNumbers is a required field
	E164PhoneNumbers []*string `type:"list" required:"true"`

	ForceAssociate *bool `type:"boolean"`

	// VoiceConnectorGroupId is a required field
	VoiceConnectorGroupId *string `location:"uri" locationName:"voiceConnectorGroupId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePhoneNumbersWithVoiceConnectorGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePhoneNumbersWithVoiceConnectorGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociatePhoneNumbersWithVoiceConnectorGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociatePhoneNumbersWithVoiceConnectorGroupInput"}
	if s.E164PhoneNumbers == nil {
		invalidParams.Add(request.NewErrParamRequired("E164PhoneNumbers"))
	}
	if s.VoiceConnectorGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorGroupId"))
	}
	if s.VoiceConnectorGroupId != nil && len(*s.VoiceConnectorGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorGroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetE164PhoneNumbers sets the E164PhoneNumbers field's value.
func (s *AssociatePhoneNumbersWithVoiceConnectorGroupInput) SetE164PhoneNumbers(v []*string) *AssociatePhoneNumbersWithVoiceConnectorGroupInput {
	s.E164PhoneNumbers = v
	return s
}

// SetForceAssociate sets the ForceAssociate field's value.
func (s *AssociatePhoneNumbersWithVoiceConnectorGroupInput) SetForceAssociate(v bool) *AssociatePhoneNumbersWithVoiceConnectorGroupInput {
	s.ForceAssociate = &v
	return s
}

// SetVoiceConnectorGroupId sets the VoiceConnectorGroupId field's value.
func (s *AssociatePhoneNumbersWithVoiceConnectorGroupInput) SetVoiceConnectorGroupId(v string) *AssociatePhoneNumbersWithVoiceConnectorGroupInput {
	s.VoiceConnectorGroupId = &v
	return s
}

type AssociatePhoneNumbersWithVoiceConnectorGroupOutput struct {
	_ struct{} `type:"structure"`

	PhoneNumberErrors []*PhoneNumberError `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePhoneNumbersWithVoiceConnectorGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePhoneNumbersWithVoiceConnectorGroupOutput) GoString() string {
	return s.String()
}

// SetPhoneNumberErrors sets the PhoneNumberErrors field's value.
func (s *AssociatePhoneNumbersWithVoiceConnectorGroupOutput) SetPhoneNumberErrors(v []*PhoneNumberError) *AssociatePhoneNumbersWithVoiceConnectorGroupOutput {
	s.PhoneNumberErrors = v
	return s
}

type AssociatePhoneNumbersWithVoiceConnectorInput struct {
	_ struct{} `type:"structure"`

	// E164PhoneNumbers is a required field
	E164PhoneNumbers []*string `type:"list" required:"true"`

	ForceAssociate *bool `type:"boolean"`

	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePhoneNumbersWithVoiceConnectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePhoneNumbersWithVoiceConnectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociatePhoneNumbersWithVoiceConnectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociatePhoneNumbersWithVoiceConnectorInput"}
	if s.E164PhoneNumbers == nil {
		invalidParams.Add(request.NewErrParamRequired("E164PhoneNumbers"))
	}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetE164PhoneNumbers sets the E164PhoneNumbers field's value.
func (s *AssociatePhoneNumbersWithVoiceConnectorInput) SetE164PhoneNumbers(v []*string) *AssociatePhoneNumbersWithVoiceConnectorInput {
	s.E164PhoneNumbers = v
	return s
}

// SetForceAssociate sets the ForceAssociate field's value.
func (s *AssociatePhoneNumbersWithVoiceConnectorInput) SetForceAssociate(v bool) *AssociatePhoneNumbersWithVoiceConnectorInput {
	s.ForceAssociate = &v
	return s
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *AssociatePhoneNumbersWithVoiceConnectorInput) SetVoiceConnectorId(v string) *AssociatePhoneNumbersWithVoiceConnectorInput {
	s.VoiceConnectorId = &v
	return s
}

type AssociatePhoneNumbersWithVoiceConnectorOutput struct {
	_ struct{} `type:"structure"`

	PhoneNumberErrors []*PhoneNumberError `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePhoneNumbersWithVoiceConnectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePhoneNumbersWithVoiceConnectorOutput) GoString() string {
	return s.String()
}

// SetPhoneNumberErrors sets the PhoneNumberErrors field's value.
func (s *AssociatePhoneNumbersWithVoiceConnectorOutput) SetPhoneNumberErrors(v []*PhoneNumberError) *AssociatePhoneNumbersWithVoiceConnectorOutput {
	s.PhoneNumberErrors = v
	return s
}

type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

type BatchDeletePhoneNumberInput struct {
	_ struct{} `type:"structure"`

	// PhoneNumberIds is a required field
	PhoneNumberIds []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeletePhoneNumberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeletePhoneNumberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeletePhoneNumberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDeletePhoneNumberInput"}
	if s.PhoneNumberIds == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneNumberIds"))
	}
	if s.PhoneNumberIds != nil && len(s.PhoneNumberIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PhoneNumberIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPhoneNumberIds sets the PhoneNumberIds field's value.
func (s *BatchDeletePhoneNumberInput) SetPhoneNumberIds(v []*string) *BatchDeletePhoneNumberInput {
	s.PhoneNumberIds = v
	return s
}

type BatchDeletePhoneNumberOutput struct {
	_ struct{} `type:"structure"`

	PhoneNumberErrors []*PhoneNumberError `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeletePhoneNumberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeletePhoneNumberOutput) GoString() string {
	return s.String()
}

// SetPhoneNumberErrors sets the PhoneNumberErrors field's value.
func (s *BatchDeletePhoneNumberOutput) SetPhoneNumberErrors(v []*PhoneNumberError) *BatchDeletePhoneNumberOutput {
	s.PhoneNumberErrors = v
	return s
}

type BatchUpdatePhoneNumberInput struct {
	_ struct{} `type:"structure"`

	// UpdatePhoneNumberRequestItems is a required field
	UpdatePhoneNumberRequestItems []*UpdatePhoneNumberRequestItem `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdatePhoneNumberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdatePhoneNumberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchUpdatePhoneNumberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchUpdatePhoneNumberInput"}
	if s.UpdatePhoneNumberRequestItems == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdatePhoneNumberRequestItems"))
	}
	if s.UpdatePhoneNumberRequestItems != nil {
		for i, v := range s.UpdatePhoneNumberRequestItems {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "UpdatePhoneNumberRequestItems", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUpdatePhoneNumberRequestItems sets the UpdatePhoneNumberRequestItems field's value.
func (s *BatchUpdatePhoneNumberInput) SetUpdatePhoneNumberRequestItems(v []*UpdatePhoneNumberRequestItem) *BatchUpdatePhoneNumberInput {
	s.UpdatePhoneNumberRequestItems = v
	return s
}

type BatchUpdatePhoneNumberOutput struct {
	_ struct{} `type:"structure"`

	PhoneNumberErrors []*PhoneNumberError `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdatePhoneNumberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdatePhoneNumberOutput) GoString() string {
	return s.String()
}

// SetPhoneNumberErrors sets the PhoneNumberErrors field's value.
func (s *BatchUpdatePhoneNumberOutput) SetPhoneNumberErrors(v []*PhoneNumberError) *BatchUpdatePhoneNumberOutput {
	s.PhoneNumberErrors = v
	return s
}

type CandidateAddress struct {
	_ struct{} `type:"structure"`

	// City is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CandidateAddress's
	// String and GoString methods.
	City *string `locationName:"city" type:"string" sensitive:"true"`

	// Country is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CandidateAddress's
	// String and GoString methods.
	Country *string `locationName:"country" type:"string" sensitive:"true"`

	// PostalCode is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CandidateAddress's
	// String and GoString methods.
	PostalCode *string `locationName:"postalCode" type:"string" sensitive:"true"`

	// PostalCodePlus4 is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CandidateAddress's
	// String and GoString methods.
	PostalCodePlus4 *string `locationName:"postalCodePlus4" type:"string" sensitive:"true"`

	// State is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CandidateAddress's
	// String and GoString methods.
	State *string `locationName:"state" type:"string" sensitive:"true"`

	// StreetInfo is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CandidateAddress's
	// String and GoString methods.
	StreetInfo *string `locationName:"streetInfo" type:"string" sensitive:"true"`

	// StreetNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CandidateAddress's
	// String and GoString methods.
	StreetNumber *string `locationName:"streetNumber" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CandidateAddress) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CandidateAddress) GoString() string {
	return s.String()
}

// SetCity sets the City field's value.
func (s *CandidateAddress) SetCity(v string) *CandidateAddress {
	s.City = &v
	return s
}

// SetCountry sets the Country field's value.
func (s *CandidateAddress) SetCountry(v string) *CandidateAddress {
	s.Country = &v
	return s
}

// SetPostalCode sets the PostalCode field's value.
func (s *CandidateAddress) SetPostalCode(v string) *CandidateAddress {
	s.PostalCode = &v
	return s
}

// SetPostalCodePlus4 sets the PostalCodePlus4 field's value.
func (s *CandidateAddress) SetPostalCodePlus4(v string) *CandidateAddress {
	s.PostalCodePlus4 = &v
	return s
}

// SetState sets the State field's value.
func (s *CandidateAddress) SetState(v string) *CandidateAddress {
	s.State = &v
	return s
}

// SetStreetInfo sets the StreetInfo field's value.
func (s *CandidateAddress) SetStreetInfo(v string) *CandidateAddress {
	s.StreetInfo = &v
	return s
}

// SetStreetNumber sets the StreetNumber field's value.
func (s *CandidateAddress) SetStreetNumber(v string) *CandidateAddress {
	s.StreetNumber = &v
	return s
}

type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreatePhoneNumberOrderInput struct {
	_ struct{} `type:"structure"`

	// E164PhoneNumbers is a required field
	E164PhoneNumbers []*string `type:"list" required:"true"`

	// ProductType is a required field
	ProductType *string `type:"string" required:"true" enum:"PhoneNumberProductType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePhoneNumberOrderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePhoneNumberOrderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePhoneNumberOrderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePhoneNumberOrderInput"}
	if s.E164PhoneNumbers == nil {
		invalidParams.Add(request.NewErrParamRequired("E164PhoneNumbers"))
	}
	if s.ProductType == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetE164PhoneNumbers sets the E164PhoneNumbers field's value.
func (s *CreatePhoneNumberOrderInput) SetE164PhoneNumbers(v []*string) *CreatePhoneNumberOrderInput {
	s.E164PhoneNumbers = v
	return s
}

// SetProductType sets the ProductType field's value.
func (s *CreatePhoneNumberOrderInput) SetProductType(v string) *CreatePhoneNumberOrderInput {
	s.ProductType = &v
	return s
}

type CreatePhoneNumberOrderOutput struct {
	_ struct{} `type:"structure"`

	PhoneNumberOrder *PhoneNumberOrder `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePhoneNumberOrderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePhoneNumberOrderOutput) GoString() string {
	return s.String()
}

// SetPhoneNumberOrder sets the PhoneNumberOrder field's value.
func (s *CreatePhoneNumberOrderOutput) SetPhoneNumberOrder(v *PhoneNumberOrder) *CreatePhoneNumberOrderOutput {
	s.PhoneNumberOrder = v
	return s
}

type CreateProxySessionInput struct {
	_ struct{} `type:"structure"`

	// Capabilities is a required field
	Capabilities []*string `type:"list" required:"true" enum:"Capability"`

	ExpiryMinutes *int64 `min:"1" type:"integer"`

	GeoMatchLevel *string `type:"string" enum:"GeoMatchLevel"`

	GeoMatchParams *GeoMatchParams `type:"structure"`

	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateProxySessionInput's
	// String and GoString methods.
	Name *string `type:"string" sensitive:"true"`

	NumberSelectionBehavior *string `type:"string" enum:"NumberSelectionBehavior"`

	// ParticipantPhoneNumbers is a required field
	ParticipantPhoneNumbers []*string `min:"2" type:"list" required:"true"`

	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProxySessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProxySessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProxySessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProxySessionInput"}
	if s.Capabilities == nil {
		invalidParams.Add(request.NewErrParamRequired("Capabilities"))
	}
	if s.ExpiryMinutes != nil && *s.ExpiryMinutes < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ExpiryMinutes", 1))
	}
	if s.ParticipantPhoneNumbers == nil {
		invalidParams.Add(request.NewErrParamRequired("ParticipantPhoneNumbers"))
	}
	if s.ParticipantPhoneNumbers != nil && len(s.ParticipantPhoneNumbers) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ParticipantPhoneNumbers", 2))
	}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}
	if s.GeoMatchParams != nil {
		if err := s.GeoMatchParams.Validate(); err != nil {
			invalidParams.AddNested("GeoMatchParams", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapabilities sets the Capabilities field's value.
func (s *CreateProxySessionInput) SetCapabilities(v []*string) *CreateProxySessionInput {
	s.Capabilities = v
	return s
}

// SetExpiryMinutes sets the ExpiryMinutes field's value.
func (s *CreateProxySessionInput) SetExpiryMinutes(v int64) *CreateProxySessionInput {
	s.ExpiryMinutes = &v
	return s
}

// SetGeoMatchLevel sets the GeoMatchLevel field's value.
func (s *CreateProxySessionInput) SetGeoMatchLevel(v string) *CreateProxySessionInput {
	s.GeoMatchLevel = &v
	return s
}

// SetGeoMatchParams sets the GeoMatchParams field's value.
func (s *CreateProxySessionInput) SetGeoMatchParams(v *GeoMatchParams) *CreateProxySessionInput {
	s.GeoMatchParams = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateProxySessionInput) SetName(v string) *CreateProxySessionInput {
	s.Name = &v
	return s
}

// SetNumberSelectionBehavior sets the NumberSelectionBehavior field's value.
func (s *CreateProxySessionInput) SetNumberSelectionBehavior(v string) *CreateProxySessionInput {
	s.NumberSelectionBehavior = &v
	return s
}

// SetParticipantPhoneNumbers sets the ParticipantPhoneNumbers field's value.
func (s *CreateProxySessionInput) SetParticipantPhoneNumbers(v []*string) *CreateProxySessionInput {
	s.ParticipantPhoneNumbers = v
	return s
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *CreateProxySessionInput) SetVoiceConnectorId(v string) *CreateProxySessionInput {
	s.VoiceConnectorId = &v
	return s
}

type CreateProxySessionOutput struct {
	_ struct{} `type:"structure"`

	ProxySession *ProxySession `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProxySessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProxySessionOutput) GoString() string {
	return s.String()
}

// SetProxySession sets the ProxySession field's value.
func (s *CreateProxySessionOutput) SetProxySession(v *ProxySession) *CreateProxySessionOutput {
	s.ProxySession = v
	return s
}

type CreateSipMediaApplicationCallInput struct {
	_ struct{} `type:"structure"`

	ArgumentsMap map[string]*string `type:"map"`

	// FromPhoneNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateSipMediaApplicationCallInput's
	// String and GoString methods.
	// FromPhoneNumber is a required field
	FromPhoneNumber *string `type:"string" required:"true" sensitive:"true"`

	SipHeaders map[string]*string `type:"map"`

	// SipMediaApplicationId is a required field
	SipMediaApplicationId *string `location:"uri" locationName:"sipMediaApplicationId" type:"string" required:"true"`

	// ToPhoneNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateSipMediaApplicationCallInput's
	// String and GoString methods.
	// ToPhoneNumber is a required field
	ToPhoneNumber *string `type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSipMediaApplicationCallInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSipMediaApplicationCallInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSipMediaApplicationCallInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSipMediaApplicationCallInput"}
	if s.FromPhoneNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("FromPhoneNumber"))
	}
	if s.SipMediaApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("SipMediaApplicationId"))
	}
	if s.SipMediaApplicationId != nil && len(*s.SipMediaApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SipMediaApplicationId", 1))
	}
	if s.ToPhoneNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("ToPhoneNumber"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArgumentsMap sets the ArgumentsMap field's value.
func (s *CreateSipMediaApplicationCallInput) SetArgumentsMap(v map[string]*string) *CreateSipMediaApplicationCallInput {
	s.ArgumentsMap = v
	return s
}

// SetFromPhoneNumber sets the FromPhoneNumber field's value.
func (s *CreateSipMediaApplicationCallInput) SetFromPhoneNumber(v string) *CreateSipMediaApplicationCallInput {
	s.FromPhoneNumber = &v
	return s
}

// SetSipHeaders sets the SipHeaders field's value.
func (s *CreateSipMediaApplicationCallInput) SetSipHeaders(v map[string]*string) *CreateSipMediaApplicationCallInput {
	s.SipHeaders = v
	return s
}

// SetSipMediaApplicationId sets the SipMediaApplicationId field's value.
func (s *CreateSipMediaApplicationCallInput) SetSipMediaApplicationId(v string) *CreateSipMediaApplicationCallInput {
	s.SipMediaApplicationId = &v
	return s
}

// SetToPhoneNumber sets the ToPhoneNumber field's value.
func (s *CreateSipMediaApplicationCallInput) SetToPhoneNumber(v string) *CreateSipMediaApplicationCallInput {
	s.ToPhoneNumber = &v
	return s
}

type CreateSipMediaApplicationCallOutput struct {
	_ struct{} `type:"structure"`

	SipMediaApplicationCall *SipMediaApplicationCall `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSipMediaApplicationCallOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSipMediaApplicationCallOutput) GoString() string {
	return s.String()
}

// SetSipMediaApplicationCall sets the SipMediaApplicationCall field's value.
func (s *CreateSipMediaApplicationCallOutput) SetSipMediaApplicationCall(v *SipMediaApplicationCall) *CreateSipMediaApplicationCallOutput {
	s.SipMediaApplicationCall = v
	return s
}

type CreateSipMediaApplicationInput struct {
	_ struct{} `type:"structure"`

	// AwsRegion is a required field
	AwsRegion *string `type:"string" required:"true"`

	// Endpoints is a required field
	Endpoints []*SipMediaApplicationEndpoint `min:"1" type:"list" required:"true"`

	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSipMediaApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSipMediaApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSipMediaApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSipMediaApplicationInput"}
	if s.AwsRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsRegion"))
	}
	if s.Endpoints == nil {
		invalidParams.Add(request.NewErrParamRequired("Endpoints"))
	}
	if s.Endpoints != nil && len(s.Endpoints) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Endpoints", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *CreateSipMediaApplicationInput) SetAwsRegion(v string) *CreateSipMediaApplicationInput {
	s.AwsRegion = &v
	return s
}

// SetEndpoints sets the Endpoints field's value.
func (s *CreateSipMediaApplicationInput) SetEndpoints(v []*SipMediaApplicationEndpoint) *CreateSipMediaApplicationInput {
	s.Endpoints = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSipMediaApplicationInput) SetName(v string) *CreateSipMediaApplicationInput {
	s.Name = &v
	return s
}

type CreateSipMediaApplicationOutput struct {
	_ struct{} `type:"structure"`

	SipMediaApplication *SipMediaApplication `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSipMediaApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSipMediaApplicationOutput) GoString() string {
	return s.String()
}

// SetSipMediaApplication sets the SipMediaApplication field's value.
func (s *CreateSipMediaApplicationOutput) SetSipMediaApplication(v *SipMediaApplication) *CreateSipMediaApplicationOutput {
	s.SipMediaApplication = v
	return s
}

type CreateSipRuleInput struct {
	_ struct{} `type:"structure"`

	Disabled *bool `type:"boolean"`

	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	TargetApplications []*SipRuleTargetApplication `min:"1" type:"list"`

	// TriggerType is a required field
	TriggerType *string `type:"string" required:"true" enum:"SipRuleTriggerType"`

	// TriggerValue is a required field
	TriggerValue *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSipRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSipRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSipRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSipRuleInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.TargetApplications != nil && len(s.TargetApplications) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetApplications", 1))
	}
	if s.TriggerType == nil {
		invalidParams.Add(request.NewErrParamRequired("TriggerType"))
	}
	if s.TriggerValue == nil {
		invalidParams.Add(request.NewErrParamRequired("TriggerValue"))
	}
	if s.TargetApplications != nil {
		for i, v := range s.TargetApplications {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TargetApplications", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDisabled sets the Disabled field's value.
func (s *CreateSipRuleInput) SetDisabled(v bool) *CreateSipRuleInput {
	s.Disabled = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSipRuleInput) SetName(v string) *CreateSipRuleInput {
	s.Name = &v
	return s
}

// SetTargetApplications sets the TargetApplications field's value.
func (s *CreateSipRuleInput) SetTargetApplications(v []*SipRuleTargetApplication) *CreateSipRuleInput {
	s.TargetApplications = v
	return s
}

// SetTriggerType sets the TriggerType field's value.
func (s *CreateSipRuleInput) SetTriggerType(v string) *CreateSipRuleInput {
	s.TriggerType = &v
	return s
}

// SetTriggerValue sets the TriggerValue field's value.
func (s *CreateSipRuleInput) SetTriggerValue(v string) *CreateSipRuleInput {
	s.TriggerValue = &v
	return s
}

type CreateSipRuleOutput struct {
	_ struct{} `type:"structure"`

	SipRule *SipRule `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSipRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSipRuleOutput) GoString() string {
	return s.String()
}

// SetSipRule sets the SipRule field's value.
func (s *CreateSipRuleOutput) SetSipRule(v *SipRule) *CreateSipRuleOutput {
	s.SipRule = v
	return s
}

type CreateVoiceConnectorGroupInput struct {
	_ struct{} `type:"structure"`

	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	VoiceConnectorItems []*VoiceConnectorItem `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVoiceConnectorGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVoiceConnectorGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVoiceConnectorGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVoiceConnectorGroupInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.VoiceConnectorItems != nil {
		for i, v := range s.VoiceConnectorItems {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "VoiceConnectorItems", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateVoiceConnectorGroupInput) SetName(v string) *CreateVoiceConnectorGroupInput {
	s.Name = &v
	return s
}

// SetVoiceConnectorItems sets the VoiceConnectorItems field's value.
func (s *CreateVoiceConnectorGroupInput) SetVoiceConnectorItems(v []*VoiceConnectorItem) *CreateVoiceConnectorGroupInput {
	s.VoiceConnectorItems = v
	return s
}

type CreateVoiceConnectorGroupOutput struct {
	_ struct{} `type:"structure"`

	VoiceConnectorGroup *VoiceConnectorGroup `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVoiceConnectorGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVoiceConnectorGroupOutput) GoString() string {
	return s.String()
}

// SetVoiceConnectorGroup sets the VoiceConnectorGroup field's value.
func (s *CreateVoiceConnectorGroupOutput) SetVoiceConnectorGroup(v *VoiceConnectorGroup) *CreateVoiceConnectorGroupOutput {
	s.VoiceConnectorGroup = v
	return s
}

type CreateVoiceConnectorInput struct {
	_ struct{} `type:"structure"`

	AwsRegion *string `type:"string" enum:"VoiceConnectorAwsRegion"`

	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// RequireEncryption is a required field
	RequireEncryption *bool `type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVoiceConnectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVoiceConnectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVoiceConnectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVoiceConnectorInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RequireEncryption == nil {
		invalidParams.Add(request.NewErrParamRequired("RequireEncryption"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *CreateVoiceConnectorInput) SetAwsRegion(v string) *CreateVoiceConnectorInput {
	s.AwsRegion = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateVoiceConnectorInput) SetName(v string) *CreateVoiceConnectorInput {
	s.Name = &v
	return s
}

// SetRequireEncryption sets the RequireEncryption field's value.
func (s *CreateVoiceConnectorInput) SetRequireEncryption(v bool) *CreateVoiceConnectorInput {
	s.RequireEncryption = &v
	return s
}

type CreateVoiceConnectorOutput struct {
	_ struct{} `type:"structure"`

	VoiceConnector *VoiceConnector `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVoiceConnectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVoiceConnectorOutput) GoString() string {
	return s.String()
}

// SetVoiceConnector sets the VoiceConnector field's value.
func (s *CreateVoiceConnectorOutput) SetVoiceConnector(v *VoiceConnector) *CreateVoiceConnectorOutput {
	s.VoiceConnector = v
	return s
}

type Credential struct {
	_ struct{} `type:"structure"`

	// Password is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Credential's
	// String and GoString methods.
	Password *string `type:"string" sensitive:"true"`

	// Username is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Credential's
	// String and GoString methods.
	Username *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Credential) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Credential) GoString() string {
	return s.String()
}

// SetPassword sets the Password field's value.
func (s *Credential) SetPassword(v string) *Credential {
	s.Password = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *Credential) SetUsername(v string) *Credential {
	s.Username = &v
	return s
}

type DNISEmergencyCallingConfiguration struct {
	_ struct{} `type:"structure"`

	// CallingCountry is a required field
	CallingCountry *string `type:"string" required:"true"`

	// EmergencyPhoneNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DNISEmergencyCallingConfiguration's
	// String and GoString methods.
	// EmergencyPhoneNumber is a required field
	EmergencyPhoneNumber *string `type:"string" required:"true" sensitive:"true"`

	// TestPhoneNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DNISEmergencyCallingConfiguration's
	// String and GoString methods.
	TestPhoneNumber *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DNISEmergencyCallingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DNISEmergencyCallingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DNISEmergencyCallingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DNISEmergencyCallingConfiguration"}
	if s.CallingCountry == nil {
		invalidParams.Add(request.NewErrParamRequired("CallingCountry"))
	}
	if s.EmergencyPhoneNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("EmergencyPhoneNumber"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallingCountry sets the CallingCountry field's value.
func (s *DNISEmergencyCallingConfiguration) SetCallingCountry(v string) *DNISEmergencyCallingConfiguration {
	s.CallingCountry = &v
	return s
}

// SetEmergencyPhoneNumber sets the EmergencyPhoneNumber field's value.
func (s *DNISEmergencyCallingConfiguration) SetEmergencyPhoneNumber(v string) *DNISEmergencyCallingConfiguration {
	s.EmergencyPhoneNumber = &v
	return s
}

// SetTestPhoneNumber sets the TestPhoneNumber field's value.
func (s *DNISEmergencyCallingConfiguration) SetTestPhoneNumber(v string) *DNISEmergencyCallingConfiguration {
	s.TestPhoneNumber = &v
	return s
}

type DeletePhoneNumberInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// PhoneNumberId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DeletePhoneNumberInput's
	// String and GoString methods.
	// PhoneNumberId is a required field
	PhoneNumberId *string `location:"uri" locationName:"phoneNumberId" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePhoneNumberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePhoneNumberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePhoneNumberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePhoneNumberInput"}
	if s.PhoneNumberId == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneNumberId"))
	}
	if s.PhoneNumberId != nil && len(*s.PhoneNumberId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PhoneNumberId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPhoneNumberId sets the PhoneNumberId field's value.
func (s *DeletePhoneNumberInput) SetPhoneNumberId(v string) *DeletePhoneNumberInput {
	s.PhoneNumberId = &v
	return s
}

type DeletePhoneNumberOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePhoneNumberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePhoneNumberOutput) GoString() string {
	return s.String()
}

type DeleteProxySessionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ProxySessionId is a required field
	ProxySessionId *string `location:"uri" locationName:"proxySessionId" min:"1" type:"string" required:"true"`

	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProxySessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProxySessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProxySessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProxySessionInput"}
	if s.ProxySessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProxySessionId"))
	}
	if s.ProxySessionId != nil && len(*s.ProxySessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProxySessionId", 1))
	}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProxySessionId sets the ProxySessionId field's value.
func (s *DeleteProxySessionInput) SetProxySessionId(v string) *DeleteProxySessionInput {
	s.ProxySessionId = &v
	return s
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *DeleteProxySessionInput) SetVoiceConnectorId(v string) *DeleteProxySessionInput {
	s.VoiceConnectorId = &v
	return s
}

type DeleteProxySessionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProxySessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProxySessionOutput) GoString() string {
	return s.String()
}

type DeleteSipMediaApplicationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// SipMediaApplicationId is a required field
	SipMediaApplicationId *string `location:"uri" locationName:"sipMediaApplicationId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSipMediaApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSipMediaApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSipMediaApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSipMediaApplicationInput"}
	if s.SipMediaApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("SipMediaApplicationId"))
	}
	if s.SipMediaApplicationId != nil && len(*s.SipMediaApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SipMediaApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSipMediaApplicationId sets the SipMediaApplicationId field's value.
func (s *DeleteSipMediaApplicationInput) SetSipMediaApplicationId(v string) *DeleteSipMediaApplicationInput {
	s.SipMediaApplicationId = &v
	return s
}

type DeleteSipMediaApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSipMediaApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSipMediaApplicationOutput) GoString() string {
	return s.String()
}

type DeleteSipRuleInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// SipRuleId is a required field
	SipRuleId *string `location:"uri" locationName:"sipRuleId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSipRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSipRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSipRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSipRuleInput"}
	if s.SipRuleId == nil {
		invalidParams.Add(request.NewErrParamRequired("SipRuleId"))
	}
	if s.SipRuleId != nil && len(*s.SipRuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SipRuleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSipRuleId sets the SipRuleId field's value.
func (s *DeleteSipRuleInput) SetSipRuleId(v string) *DeleteSipRuleInput {
	s.SipRuleId = &v
	return s
}

type DeleteSipRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSipRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSipRuleOutput) GoString() string {
	return s.String()
}

type DeleteVoiceConnectorEmergencyCallingConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVoiceConnectorEmergencyCallingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVoiceConnectorEmergencyCallingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVoiceConnectorEmergencyCallingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVoiceConnectorEmergencyCallingConfigurationInput"}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *DeleteVoiceConnectorEmergencyCallingConfigurationInput) SetVoiceConnectorId(v string) *DeleteVoiceConnectorEmergencyCallingConfigurationInput {
	s.VoiceConnectorId = &v
	return s
}

type DeleteVoiceConnectorEmergencyCallingConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVoiceConnectorEmergencyCallingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVoiceConnectorEmergencyCallingConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteVoiceConnectorGroupInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// VoiceConnectorGroupId is a required field
	VoiceConnectorGroupId *string `location:"uri" locationName:"voiceConnectorGroupId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVoiceConnectorGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVoiceConnectorGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVoiceConnectorGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVoiceConnectorGroupInput"}
	if s.VoiceConnectorGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorGroupId"))
	}
	if s.VoiceConnectorGroupId != nil && len(*s.VoiceConnectorGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorGroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVoiceConnectorGroupId sets the VoiceConnectorGroupId field's value.
func (s *DeleteVoiceConnectorGroupInput) SetVoiceConnectorGroupId(v string) *DeleteVoiceConnectorGroupInput {
	s.VoiceConnectorGroupId = &v
	return s
}

type DeleteVoiceConnectorGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVoiceConnectorGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVoiceConnectorGroupOutput) GoString() string {
	return s.String()
}

type DeleteVoiceConnectorInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVoiceConnectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVoiceConnectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVoiceConnectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVoiceConnectorInput"}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *DeleteVoiceConnectorInput) SetVoiceConnectorId(v string) *DeleteVoiceConnectorInput {
	s.VoiceConnectorId = &v
	return s
}

type DeleteVoiceConnectorOriginationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVoiceConnectorOriginationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVoiceConnectorOriginationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVoiceConnectorOriginationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVoiceConnectorOriginationInput"}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *DeleteVoiceConnectorOriginationInput) SetVoiceConnectorId(v string) *DeleteVoiceConnectorOriginationInput {
	s.VoiceConnectorId = &v
	return s
}

type DeleteVoiceConnectorOriginationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVoiceConnectorOriginationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVoiceConnectorOriginationOutput) GoString() string {
	return s.String()
}

type DeleteVoiceConnectorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVoiceConnectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVoiceConnectorOutput) GoString() string {
	return s.String()
}

type DeleteVoiceConnectorProxyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVoiceConnectorProxyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVoiceConnectorProxyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVoiceConnectorProxyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVoiceConnectorProxyInput"}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *DeleteVoiceConnectorProxyInput) SetVoiceConnectorId(v string) *DeleteVoiceConnectorProxyInput {
	s.VoiceConnectorId = &v
	return s
}

type DeleteVoiceConnectorProxyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVoiceConnectorProxyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVoiceConnectorProxyOutput) GoString() string {
	return s.String()
}

type DeleteVoiceConnectorStreamingConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVoiceConnectorStreamingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVoiceConnectorStreamingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVoiceConnectorStreamingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVoiceConnectorStreamingConfigurationInput"}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *DeleteVoiceConnectorStreamingConfigurationInput) SetVoiceConnectorId(v string) *DeleteVoiceConnectorStreamingConfigurationInput {
	s.VoiceConnectorId = &v
	return s
}

type DeleteVoiceConnectorStreamingConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVoiceConnectorStreamingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVoiceConnectorStreamingConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteVoiceConnectorTerminationCredentialsInput struct {
	_ struct{} `type:"structure"`

	// Usernames is a required field
	Usernames []*string `type:"list" required:"true"`

	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVoiceConnectorTerminationCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVoiceConnectorTerminationCredentialsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVoiceConnectorTerminationCredentialsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVoiceConnectorTerminationCredentialsInput"}
	if s.Usernames == nil {
		invalidParams.Add(request.NewErrParamRequired("Usernames"))
	}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUsernames sets the Usernames field's value.
func (s *DeleteVoiceConnectorTerminationCredentialsInput) SetUsernames(v []*string) *DeleteVoiceConnectorTerminationCredentialsInput {
	s.Usernames = v
	return s
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *DeleteVoiceConnectorTerminationCredentialsInput) SetVoiceConnectorId(v string) *DeleteVoiceConnectorTerminationCredentialsInput {
	s.VoiceConnectorId = &v
	return s
}

type DeleteVoiceConnectorTerminationCredentialsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVoiceConnectorTerminationCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVoiceConnectorTerminationCredentialsOutput) GoString() string {
	return s.String()
}

type DeleteVoiceConnectorTerminationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVoiceConnectorTerminationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVoiceConnectorTerminationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVoiceConnectorTerminationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVoiceConnectorTerminationInput"}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *DeleteVoiceConnectorTerminationInput) SetVoiceConnectorId(v string) *DeleteVoiceConnectorTerminationInput {
	s.VoiceConnectorId = &v
	return s
}

type DeleteVoiceConnectorTerminationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVoiceConnectorTerminationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVoiceConnectorTerminationOutput) GoString() string {
	return s.String()
}

type DisassociatePhoneNumbersFromVoiceConnectorGroupInput struct {
	_ struct{} `type:"structure"`

	// E164PhoneNumbers is a required field
	E164PhoneNumbers []*string `type:"list" required:"true"`

	// VoiceConnectorGroupId is a required field
	VoiceConnectorGroupId *string `location:"uri" locationName:"voiceConnectorGroupId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociatePhoneNumbersFromVoiceConnectorGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociatePhoneNumbersFromVoiceConnectorGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociatePhoneNumbersFromVoiceConnectorGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociatePhoneNumbersFromVoiceConnectorGroupInput"}
	if s.E164PhoneNumbers == nil {
		invalidParams.Add(request.NewErrParamRequired("E164PhoneNumbers"))
	}
	if s.VoiceConnectorGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorGroupId"))
	}
	if s.VoiceConnectorGroupId != nil && len(*s.VoiceConnectorGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorGroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetE164PhoneNumbers sets the E164PhoneNumbers field's value.
func (s *DisassociatePhoneNumbersFromVoiceConnectorGroupInput) SetE164PhoneNumbers(v []*string) *DisassociatePhoneNumbersFromVoiceConnectorGroupInput {
	s.E164PhoneNumbers = v
	return s
}

// SetVoiceConnectorGroupId sets the VoiceConnectorGroupId field's value.
func (s *DisassociatePhoneNumbersFromVoiceConnectorGroupInput) SetVoiceConnectorGroupId(v string) *DisassociatePhoneNumbersFromVoiceConnectorGroupInput {
	s.VoiceConnectorGroupId = &v
	return s
}

type DisassociatePhoneNumbersFromVoiceConnectorGroupOutput struct {
	_ struct{} `type:"structure"`

	PhoneNumberErrors []*PhoneNumberError `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociatePhoneNumbersFromVoiceConnectorGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociatePhoneNumbersFromVoiceConnectorGroupOutput) GoString() string {
	return s.String()
}

// SetPhoneNumberErrors sets the PhoneNumberErrors field's value.
func (s *DisassociatePhoneNumbersFromVoiceConnectorGroupOutput) SetPhoneNumberErrors(v []*PhoneNumberError) *DisassociatePhoneNumbersFromVoiceConnectorGroupOutput {
	s.PhoneNumberErrors = v
	return s
}

type DisassociatePhoneNumbersFromVoiceConnectorInput struct {
	_ struct{} `type:"structure"`

	// E164PhoneNumbers is a required field
	E164PhoneNumbers []*string `type:"list" required:"true"`

	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociatePhoneNumbersFromVoiceConnectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociatePhoneNumbersFromVoiceConnectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociatePhoneNumbersFromVoiceConnectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociatePhoneNumbersFromVoiceConnectorInput"}
	if s.E164PhoneNumbers == nil {
		invalidParams.Add(request.NewErrParamRequired("E164PhoneNumbers"))
	}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetE164PhoneNumbers sets the E164PhoneNumbers field's value.
func (s *DisassociatePhoneNumbersFromVoiceConnectorInput) SetE164PhoneNumbers(v []*string) *DisassociatePhoneNumbersFromVoiceConnectorInput {
	s.E164PhoneNumbers = v
	return s
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *DisassociatePhoneNumbersFromVoiceConnectorInput) SetVoiceConnectorId(v string) *DisassociatePhoneNumbersFromVoiceConnectorInput {
	s.VoiceConnectorId = &v
	return s
}

type DisassociatePhoneNumbersFromVoiceConnectorOutput struct {
	_ struct{} `type:"structure"`

	PhoneNumberErrors []*PhoneNumberError `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociatePhoneNumbersFromVoiceConnectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociatePhoneNumbersFromVoiceConnectorOutput) GoString() string {
	return s.String()
}

// SetPhoneNumberErrors sets the PhoneNumberErrors field's value.
func (s *DisassociatePhoneNumbersFromVoiceConnectorOutput) SetPhoneNumberErrors(v []*PhoneNumberError) *DisassociatePhoneNumbersFromVoiceConnectorOutput {
	s.PhoneNumberErrors = v
	return s
}

type EmergencyCallingConfiguration struct {
	_ struct{} `type:"structure"`

	DNIS []*DNISEmergencyCallingConfiguration `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EmergencyCallingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EmergencyCallingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EmergencyCallingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EmergencyCallingConfiguration"}
	if s.DNIS != nil {
		for i, v := range s.DNIS {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DNIS", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDNIS sets the DNIS field's value.
func (s *EmergencyCallingConfiguration) SetDNIS(v []*DNISEmergencyCallingConfiguration) *EmergencyCallingConfiguration {
	s.DNIS = v
	return s
}

type ForbiddenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForbiddenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForbiddenException) GoString() string {
	return s.String()
}

func newErrorForbiddenException(v protocol.ResponseMetadata) error {
	return &ForbiddenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ForbiddenException) Code() string {
	return "ForbiddenException"
}

// Message returns the exception's message.
func (s *ForbiddenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ForbiddenException) OrigErr() error {
	return nil
}

func (s *ForbiddenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ForbiddenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ForbiddenException) RequestID() string {
	return s.RespMetadata.RequestID
}

type GeoMatchParams struct {
	_ struct{} `type:"structure"`

	// AreaCode is a required field
	AreaCode *string `type:"string" required:"true"`

	// Country is a required field
	Country *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeoMatchParams) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeoMatchParams) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GeoMatchParams) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GeoMatchParams"}
	if s.AreaCode == nil {
		invalidParams.Add(request.NewErrParamRequired("AreaCode"))
	}
	if s.Country == nil {
		invalidParams.Add(request.NewErrParamRequired("Country"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAreaCode sets the AreaCode field's value.
func (s *GeoMatchParams) SetAreaCode(v string) *GeoMatchParams {
	s.AreaCode = &v
	return s
}

// SetCountry sets the Country field's value.
func (s *GeoMatchParams) SetCountry(v string) *GeoMatchParams {
	s.Country = &v
	return s
}

type GetGlobalSettingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGlobalSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGlobalSettingsInput) GoString() string {
	return s.String()
}

type GetGlobalSettingsOutput struct {
	_ struct{} `type:"structure"`

	VoiceConnector *VoiceConnectorSettings `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGlobalSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGlobalSettingsOutput) GoString() string {
	return s.String()
}

// SetVoiceConnector sets the VoiceConnector field's value.
func (s *GetGlobalSettingsOutput) SetVoiceConnector(v *VoiceConnectorSettings) *GetGlobalSettingsOutput {
	s.VoiceConnector = v
	return s
}

type GetPhoneNumberInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// PhoneNumberId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetPhoneNumberInput's
	// String and GoString methods.
	// PhoneNumberId is a required field
	PhoneNumberId *string `location:"uri" locationName:"phoneNumberId" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPhoneNumberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPhoneNumberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPhoneNumberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPhoneNumberInput"}
	if s.PhoneNumberId == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneNumberId"))
	}
	if s.PhoneNumberId != nil && len(*s.PhoneNumberId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PhoneNumberId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPhoneNumberId sets the PhoneNumberId field's value.
func (s *GetPhoneNumberInput) SetPhoneNumberId(v string) *GetPhoneNumberInput {
	s.PhoneNumberId = &v
	return s
}

type GetPhoneNumberOrderInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// PhoneNumberOrderId is a required field
	PhoneNumberOrderId *string `location:"uri" locationName:"phoneNumberOrderId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPhoneNumberOrderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPhoneNumberOrderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPhoneNumberOrderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPhoneNumberOrderInput"}
	if s.PhoneNumberOrderId == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneNumberOrderId"))
	}
	if s.PhoneNumberOrderId != nil && len(*s.PhoneNumberOrderId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PhoneNumberOrderId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPhoneNumberOrderId sets the PhoneNumberOrderId field's value.
func (s *GetPhoneNumberOrderInput) SetPhoneNumberOrderId(v string) *GetPhoneNumberOrderInput {
	s.PhoneNumberOrderId = &v
	return s
}

type GetPhoneNumberOrderOutput struct {
	_ struct{} `type:"structure"`

	PhoneNumberOrder *PhoneNumberOrder `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPhoneNumberOrderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPhoneNumberOrderOutput) GoString() string {
	return s.String()
}

// SetPhoneNumberOrder sets the PhoneNumberOrder field's value.
func (s *GetPhoneNumberOrderOutput) SetPhoneNumberOrder(v *PhoneNumberOrder) *GetPhoneNumberOrderOutput {
	s.PhoneNumberOrder = v
	return s
}

type GetPhoneNumberOutput struct {
	_ struct{} `type:"structure"`

	PhoneNumber *PhoneNumber `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPhoneNumberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPhoneNumberOutput) GoString() string {
	return s.String()
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *GetPhoneNumberOutput) SetPhoneNumber(v *PhoneNumber) *GetPhoneNumberOutput {
	s.PhoneNumber = v
	return s
}

type GetPhoneNumberSettingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPhoneNumberSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPhoneNumberSettingsInput) GoString() string {
	return s.String()
}

type GetPhoneNumberSettingsOutput struct {
	_ struct{} `type:"structure"`

	// CallingName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetPhoneNumberSettingsOutput's
	// String and GoString methods.
	CallingName *string `type:"string" sensitive:"true"`

	CallingNameUpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPhoneNumberSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPhoneNumberSettingsOutput) GoString() string {
	return s.String()
}

// SetCallingName sets the CallingName field's value.
func (s *GetPhoneNumberSettingsOutput) SetCallingName(v string) *GetPhoneNumberSettingsOutput {
	s.CallingName = &v
	return s
}

// SetCallingNameUpdatedTimestamp sets the CallingNameUpdatedTimestamp field's value.
func (s *GetPhoneNumberSettingsOutput) SetCallingNameUpdatedTimestamp(v time.Time) *GetPhoneNumberSettingsOutput {
	s.CallingNameUpdatedTimestamp = &v
	return s
}

type GetProxySessionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ProxySessionId is a required field
	ProxySessionId *string `location:"uri" locationName:"proxySessionId" min:"1" type:"string" required:"true"`

	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProxySessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProxySessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetProxySessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetProxySessionInput"}
	if s.ProxySessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProxySessionId"))
	}
	if s.ProxySessionId != nil && len(*s.ProxySessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProxySessionId", 1))
	}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProxySessionId sets the ProxySessionId field's value.
func (s *GetProxySessionInput) SetProxySessionId(v string) *GetProxySessionInput {
	s.ProxySessionId = &v
	return s
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *GetProxySessionInput) SetVoiceConnectorId(v string) *GetProxySessionInput {
	s.VoiceConnectorId = &v
	return s
}

type GetProxySessionOutput struct {
	_ struct{} `type:"structure"`

	ProxySession *ProxySession `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProxySessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProxySessionOutput) GoString() string {
	return s.String()
}

// SetProxySession sets the ProxySession field's value.
func (s *GetProxySessionOutput) SetProxySession(v *ProxySession) *GetProxySessionOutput {
	s.ProxySession = v
	return s
}

type GetSipMediaApplicationAlexaSkillConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// SipMediaApplicationId is a required field
	SipMediaApplicationId *string `location:"uri" locationName:"sipMediaApplicationId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSipMediaApplicationAlexaSkillConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSipMediaApplicationAlexaSkillConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSipMediaApplicationAlexaSkillConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSipMediaApplicationAlexaSkillConfigurationInput"}
	if s.SipMediaApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("SipMediaApplicationId"))
	}
	if s.SipMediaApplicationId != nil && len(*s.SipMediaApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SipMediaApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSipMediaApplicationId sets the SipMediaApplicationId field's value.
func (s *GetSipMediaApplicationAlexaSkillConfigurationInput) SetSipMediaApplicationId(v string) *GetSipMediaApplicationAlexaSkillConfigurationInput {
	s.SipMediaApplicationId = &v
	return s
}

type GetSipMediaApplicationAlexaSkillConfigurationOutput struct {
	_ struct{} `type:"structure"`

	SipMediaApplicationAlexaSkillConfiguration *SipMediaApplicationAlexaSkillConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSipMediaApplicationAlexaSkillConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSipMediaApplicationAlexaSkillConfigurationOutput) GoString() string {
	return s.String()
}

// SetSipMediaApplicationAlexaSkillConfiguration sets the SipMediaApplicationAlexaSkillConfiguration field's value.
func (s *GetSipMediaApplicationAlexaSkillConfigurationOutput) SetSipMediaApplicationAlexaSkillConfiguration(v *SipMediaApplicationAlexaSkillConfiguration) *GetSipMediaApplicationAlexaSkillConfigurationOutput {
	s.SipMediaApplicationAlexaSkillConfiguration = v
	return s
}

type GetSipMediaApplicationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// SipMediaApplicationId is a required field
	SipMediaApplicationId *string `location:"uri" locationName:"sipMediaApplicationId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSipMediaApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSipMediaApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSipMediaApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSipMediaApplicationInput"}
	if s.SipMediaApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("SipMediaApplicationId"))
	}
	if s.SipMediaApplicationId != nil && len(*s.SipMediaApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SipMediaApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSipMediaApplicationId sets the SipMediaApplicationId field's value.
func (s *GetSipMediaApplicationInput) SetSipMediaApplicationId(v string) *GetSipMediaApplicationInput {
	s.SipMediaApplicationId = &v
	return s
}

type GetSipMediaApplicationLoggingConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// SipMediaApplicationId is a required field
	SipMediaApplicationId *string `location:"uri" locationName:"sipMediaApplicationId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSipMediaApplicationLoggingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSipMediaApplicationLoggingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSipMediaApplicationLoggingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSipMediaApplicationLoggingConfigurationInput"}
	if s.SipMediaApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("SipMediaApplicationId"))
	}
	if s.SipMediaApplicationId != nil && len(*s.SipMediaApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SipMediaApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSipMediaApplicationId sets the SipMediaApplicationId field's value.
func (s *GetSipMediaApplicationLoggingConfigurationInput) SetSipMediaApplicationId(v string) *GetSipMediaApplicationLoggingConfigurationInput {
	s.SipMediaApplicationId = &v
	return s
}

type GetSipMediaApplicationLoggingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	SipMediaApplicationLoggingConfiguration *SipMediaApplicationLoggingConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSipMediaApplicationLoggingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSipMediaApplicationLoggingConfigurationOutput) GoString() string {
	return s.String()
}

// SetSipMediaApplicationLoggingConfiguration sets the SipMediaApplicationLoggingConfiguration field's value.
func (s *GetSipMediaApplicationLoggingConfigurationOutput) SetSipMediaApplicationLoggingConfiguration(v *SipMediaApplicationLoggingConfiguration) *GetSipMediaApplicationLoggingConfigurationOutput {
	s.SipMediaApplicationLoggingConfiguration = v
	return s
}

type GetSipMediaApplicationOutput struct {
	_ struct{} `type:"structure"`

	SipMediaApplication *SipMediaApplication `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSipMediaApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSipMediaApplicationOutput) GoString() string {
	return s.String()
}

// SetSipMediaApplication sets the SipMediaApplication field's value.
func (s *GetSipMediaApplicationOutput) SetSipMediaApplication(v *SipMediaApplication) *GetSipMediaApplicationOutput {
	s.SipMediaApplication = v
	return s
}

type GetSipRuleInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// SipRuleId is a required field
	SipRuleId *string `location:"uri" locationName:"sipRuleId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSipRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSipRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSipRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSipRuleInput"}
	if s.SipRuleId == nil {
		invalidParams.Add(request.NewErrParamRequired("SipRuleId"))
	}
	if s.SipRuleId != nil && len(*s.SipRuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SipRuleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSipRuleId sets the SipRuleId field's value.
func (s *GetSipRuleInput) SetSipRuleId(v string) *GetSipRuleInput {
	s.SipRuleId = &v
	return s
}

type GetSipRuleOutput struct {
	_ struct{} `type:"structure"`

	SipRule *SipRule `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSipRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSipRuleOutput) GoString() string {
	return s.String()
}

// SetSipRule sets the SipRule field's value.
func (s *GetSipRuleOutput) SetSipRule(v *SipRule) *GetSipRuleOutput {
	s.SipRule = v
	return s
}

type GetVoiceConnectorEmergencyCallingConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVoiceConnectorEmergencyCallingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVoiceConnectorEmergencyCallingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVoiceConnectorEmergencyCallingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVoiceConnectorEmergencyCallingConfigurationInput"}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *GetVoiceConnectorEmergencyCallingConfigurationInput) SetVoiceConnectorId(v string) *GetVoiceConnectorEmergencyCallingConfigurationInput {
	s.VoiceConnectorId = &v
	return s
}

type GetVoiceConnectorEmergencyCallingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	EmergencyCallingConfiguration *EmergencyCallingConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVoiceConnectorEmergencyCallingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVoiceConnectorEmergencyCallingConfigurationOutput) GoString() string {
	return s.String()
}

// SetEmergencyCallingConfiguration sets the EmergencyCallingConfiguration field's value.
func (s *GetVoiceConnectorEmergencyCallingConfigurationOutput) SetEmergencyCallingConfiguration(v *EmergencyCallingConfiguration) *GetVoiceConnectorEmergencyCallingConfigurationOutput {
	s.EmergencyCallingConfiguration = v
	return s
}

type GetVoiceConnectorGroupInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// VoiceConnectorGroupId is a required field
	VoiceConnectorGroupId *string `location:"uri" locationName:"voiceConnectorGroupId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVoiceConnectorGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVoiceConnectorGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVoiceConnectorGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVoiceConnectorGroupInput"}
	if s.VoiceConnectorGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorGroupId"))
	}
	if s.VoiceConnectorGroupId != nil && len(*s.VoiceConnectorGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorGroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVoiceConnectorGroupId sets the VoiceConnectorGroupId field's value.
func (s *GetVoiceConnectorGroupInput) SetVoiceConnectorGroupId(v string) *GetVoiceConnectorGroupInput {
	s.VoiceConnectorGroupId = &v
	return s
}

type GetVoiceConnectorGroupOutput struct {
	_ struct{} `type:"structure"`

	VoiceConnectorGroup *VoiceConnectorGroup `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVoiceConnectorGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVoiceConnectorGroupOutput) GoString() string {
	return s.String()
}

// SetVoiceConnectorGroup sets the VoiceConnectorGroup field's value.
func (s *GetVoiceConnectorGroupOutput) SetVoiceConnectorGroup(v *VoiceConnectorGroup) *GetVoiceConnectorGroupOutput {
	s.VoiceConnectorGroup = v
	return s
}

type GetVoiceConnectorInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVoiceConnectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVoiceConnectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVoiceConnectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVoiceConnectorInput"}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *GetVoiceConnectorInput) SetVoiceConnectorId(v string) *GetVoiceConnectorInput {
	s.VoiceConnectorId = &v
	return s
}

type GetVoiceConnectorLoggingConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVoiceConnectorLoggingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVoiceConnectorLoggingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVoiceConnectorLoggingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVoiceConnectorLoggingConfigurationInput"}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *GetVoiceConnectorLoggingConfigurationInput) SetVoiceConnectorId(v string) *GetVoiceConnectorLoggingConfigurationInput {
	s.VoiceConnectorId = &v
	return s
}

type GetVoiceConnectorLoggingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	LoggingConfiguration *LoggingConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVoiceConnectorLoggingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVoiceConnectorLoggingConfigurationOutput) GoString() string {
	return s.String()
}

// SetLoggingConfiguration sets the LoggingConfiguration field's value.
func (s *GetVoiceConnectorLoggingConfigurationOutput) SetLoggingConfiguration(v *LoggingConfiguration) *GetVoiceConnectorLoggingConfigurationOutput {
	s.LoggingConfiguration = v
	return s
}

type GetVoiceConnectorOriginationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVoiceConnectorOriginationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVoiceConnectorOriginationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVoiceConnectorOriginationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVoiceConnectorOriginationInput"}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *GetVoiceConnectorOriginationInput) SetVoiceConnectorId(v string) *GetVoiceConnectorOriginationInput {
	s.VoiceConnectorId = &v
	return s
}

type GetVoiceConnectorOriginationOutput struct {
	_ struct{} `type:"structure"`

	Origination *Origination `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVoiceConnectorOriginationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVoiceConnectorOriginationOutput) GoString() string {
	return s.String()
}

// SetOrigination sets the Origination field's value.
func (s *GetVoiceConnectorOriginationOutput) SetOrigination(v *Origination) *GetVoiceConnectorOriginationOutput {
	s.Origination = v
	return s
}

type GetVoiceConnectorOutput struct {
	_ struct{} `type:"structure"`

	VoiceConnector *VoiceConnector `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVoiceConnectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVoiceConnectorOutput) GoString() string {
	return s.String()
}

// SetVoiceConnector sets the VoiceConnector field's value.
func (s *GetVoiceConnectorOutput) SetVoiceConnector(v *VoiceConnector) *GetVoiceConnectorOutput {
	s.VoiceConnector = v
	return s
}

type GetVoiceConnectorProxyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVoiceConnectorProxyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVoiceConnectorProxyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVoiceConnectorProxyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVoiceConnectorProxyInput"}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *GetVoiceConnectorProxyInput) SetVoiceConnectorId(v string) *GetVoiceConnectorProxyInput {
	s.VoiceConnectorId = &v
	return s
}

type GetVoiceConnectorProxyOutput struct {
	_ struct{} `type:"structure"`

	Proxy *Proxy `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVoiceConnectorProxyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVoiceConnectorProxyOutput) GoString() string {
	return s.String()
}

// SetProxy sets the Proxy field's value.
func (s *GetVoiceConnectorProxyOutput) SetProxy(v *Proxy) *GetVoiceConnectorProxyOutput {
	s.Proxy = v
	return s
}

type GetVoiceConnectorStreamingConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVoiceConnectorStreamingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVoiceConnectorStreamingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVoiceConnectorStreamingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVoiceConnectorStreamingConfigurationInput"}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *GetVoiceConnectorStreamingConfigurationInput) SetVoiceConnectorId(v string) *GetVoiceConnectorStreamingConfigurationInput {
	s.VoiceConnectorId = &v
	return s
}

type GetVoiceConnectorStreamingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	StreamingConfiguration *StreamingConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVoiceConnectorStreamingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVoiceConnectorStreamingConfigurationOutput) GoString() string {
	return s.String()
}

// SetStreamingConfiguration sets the StreamingConfiguration field's value.
func (s *GetVoiceConnectorStreamingConfigurationOutput) SetStreamingConfiguration(v *StreamingConfiguration) *GetVoiceConnectorStreamingConfigurationOutput {
	s.StreamingConfiguration = v
	return s
}

type GetVoiceConnectorTerminationHealthInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVoiceConnectorTerminationHealthInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVoiceConnectorTerminationHealthInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVoiceConnectorTerminationHealthInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVoiceConnectorTerminationHealthInput"}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *GetVoiceConnectorTerminationHealthInput) SetVoiceConnectorId(v string) *GetVoiceConnectorTerminationHealthInput {
	s.VoiceConnectorId = &v
	return s
}

type GetVoiceConnectorTerminationHealthOutput struct {
	_ struct{} `type:"structure"`

	TerminationHealth *TerminationHealth `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVoiceConnectorTerminationHealthOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVoiceConnectorTerminationHealthOutput) GoString() string {
	return s.String()
}

// SetTerminationHealth sets the TerminationHealth field's value.
func (s *GetVoiceConnectorTerminationHealthOutput) SetTerminationHealth(v *TerminationHealth) *GetVoiceConnectorTerminationHealthOutput {
	s.TerminationHealth = v
	return s
}

type GetVoiceConnectorTerminationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVoiceConnectorTerminationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVoiceConnectorTerminationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVoiceConnectorTerminationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVoiceConnectorTerminationInput"}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *GetVoiceConnectorTerminationInput) SetVoiceConnectorId(v string) *GetVoiceConnectorTerminationInput {
	s.VoiceConnectorId = &v
	return s
}

type GetVoiceConnectorTerminationOutput struct {
	_ struct{} `type:"structure"`

	Termination *Termination `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVoiceConnectorTerminationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVoiceConnectorTerminationOutput) GoString() string {
	return s.String()
}

// SetTermination sets the Termination field's value.
func (s *GetVoiceConnectorTerminationOutput) SetTermination(v *Termination) *GetVoiceConnectorTerminationOutput {
	s.Termination = v
	return s
}

type ListAvailableVoiceConnectorRegionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAvailableVoiceConnectorRegionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAvailableVoiceConnectorRegionsInput) GoString() string {
	return s.String()
}

type ListAvailableVoiceConnectorRegionsOutput struct {
	_ struct{} `type:"structure"`

	VoiceConnectorRegions []*string `type:"list" enum:"VoiceConnectorAwsRegion"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAvailableVoiceConnectorRegionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAvailableVoiceConnectorRegionsOutput) GoString() string {
	return s.String()
}

// SetVoiceConnectorRegions sets the VoiceConnectorRegions field's value.
func (s *ListAvailableVoiceConnectorRegionsOutput) SetVoiceConnectorRegions(v []*string) *ListAvailableVoiceConnectorRegionsOutput {
	s.VoiceConnectorRegions = v
	return s
}

type ListPhoneNumberOrdersInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPhoneNumberOrdersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPhoneNumberOrdersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPhoneNumberOrdersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPhoneNumberOrdersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPhoneNumberOrdersInput) SetMaxResults(v int64) *ListPhoneNumberOrdersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPhoneNumberOrdersInput) SetNextToken(v string) *ListPhoneNumberOrdersInput {
	s.NextToken = &v
	return s
}

type ListPhoneNumberOrdersOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `type:"string"`

	PhoneNumberOrders []*PhoneNumberOrder `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPhoneNumberOrdersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPhoneNumberOrdersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPhoneNumberOrdersOutput) SetNextToken(v string) *ListPhoneNumberOrdersOutput {
	s.NextToken = &v
	return s
}

// SetPhoneNumberOrders sets the PhoneNumberOrders field's value.
func (s *ListPhoneNumberOrdersOutput) SetPhoneNumberOrders(v []*PhoneNumberOrder) *ListPhoneNumberOrdersOutput {
	s.PhoneNumberOrders = v
	return s
}

type ListPhoneNumbersInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	FilterName *string `location:"querystring" locationName:"filter-name" type:"string" enum:"PhoneNumberAssociationName"`

	FilterValue *string `location:"querystring" locationName:"filter-value" type:"string"`

	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	ProductType *string `location:"querystring" locationName:"product-type" type:"string" enum:"PhoneNumberProductType"`

	Status *string `location:"querystring" locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPhoneNumbersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPhoneNumbersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPhoneNumbersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPhoneNumbersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterName sets the FilterName field's value.
func (s *ListPhoneNumbersInput) SetFilterName(v string) *ListPhoneNumbersInput {
	s.FilterName = &v
	return s
}

// SetFilterValue sets the FilterValue field's value.
func (s *ListPhoneNumbersInput) SetFilterValue(v string) *ListPhoneNumbersInput {
	s.FilterValue = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPhoneNumbersInput) SetMaxResults(v int64) *ListPhoneNumbersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPhoneNumbersInput) SetNextToken(v string) *ListPhoneNumbersInput {
	s.NextToken = &v
	return s
}

// SetProductType sets the ProductType field's value.
func (s *ListPhoneNumbersInput) SetProductType(v string) *ListPhoneNumbersInput {
	s.ProductType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListPhoneNumbersInput) SetStatus(v string) *ListPhoneNumbersInput {
	s.Status = &v
	return s
}

type ListPhoneNumbersOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `type:"string"`

	PhoneNumbers []*PhoneNumber `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPhoneNumbersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPhoneNumbersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPhoneNumbersOutput) SetNextToken(v string) *ListPhoneNumbersOutput {
	s.NextToken = &v
	return s
}

// SetPhoneNumbers sets the PhoneNumbers field's value.
func (s *ListPhoneNumbersOutput) SetPhoneNumbers(v []*PhoneNumber) *ListPhoneNumbersOutput {
	s.PhoneNumbers = v
	return s
}

type ListProxySessionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	Status *string `location:"querystring" locationName:"status" type:"string" enum:"ProxySessionStatus"`

	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProxySessionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProxySessionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProxySessionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProxySessionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProxySessionsInput) SetMaxResults(v int64) *ListProxySessionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProxySessionsInput) SetNextToken(v string) *ListProxySessionsInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListProxySessionsInput) SetStatus(v string) *ListProxySessionsInput {
	s.Status = &v
	return s
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *ListProxySessionsInput) SetVoiceConnectorId(v string) *ListProxySessionsInput {
	s.VoiceConnectorId = &v
	return s
}

type ListProxySessionsOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `type:"string"`

	ProxySessions []*ProxySession `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProxySessionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProxySessionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProxySessionsOutput) SetNextToken(v string) *ListProxySessionsOutput {
	s.NextToken = &v
	return s
}

// SetProxySessions sets the ProxySessions field's value.
func (s *ListProxySessionsOutput) SetProxySessions(v []*ProxySession) *ListProxySessionsOutput {
	s.ProxySessions = v
	return s
}

type ListSipMediaApplicationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSipMediaApplicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSipMediaApplicationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSipMediaApplicationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSipMediaApplicationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSipMediaApplicationsInput) SetMaxResults(v int64) *ListSipMediaApplicationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSipMediaApplicationsInput) SetNextToken(v string) *ListSipMediaApplicationsInput {
	s.NextToken = &v
	return s
}

type ListSipMediaApplicationsOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `type:"string"`

	SipMediaApplications []*SipMediaApplication `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSipMediaApplicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSipMediaApplicationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSipMediaApplicationsOutput) SetNextToken(v string) *ListSipMediaApplicationsOutput {
	s.NextToken = &v
	return s
}

// SetSipMediaApplications sets the SipMediaApplications field's value.
func (s *ListSipMediaApplicationsOutput) SetSipMediaApplications(v []*SipMediaApplication) *ListSipMediaApplicationsOutput {
	s.SipMediaApplications = v
	return s
}

type ListSipRulesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	SipMediaApplicationId *string `location:"querystring" locationName:"sip-media-application" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSipRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSipRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSipRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSipRulesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSipRulesInput) SetMaxResults(v int64) *ListSipRulesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSipRulesInput) SetNextToken(v string) *ListSipRulesInput {
	s.NextToken = &v
	return s
}

// SetSipMediaApplicationId sets the SipMediaApplicationId field's value.
func (s *ListSipRulesInput) SetSipMediaApplicationId(v string) *ListSipRulesInput {
	s.SipMediaApplicationId = &v
	return s
}

type ListSipRulesOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `type:"string"`

	SipRules []*SipRule `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSipRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSipRulesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSipRulesOutput) SetNextToken(v string) *ListSipRulesOutput {
	s.NextToken = &v
	return s
}

// SetSipRules sets the SipRules field's value.
func (s *ListSipRulesOutput) SetSipRules(v []*SipRule) *ListSipRulesOutput {
	s.SipRules = v
	return s
}

type ListSupportedPhoneNumberCountriesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ProductType is a required field
	ProductType *string `location:"querystring" locationName:"product-type" type:"string" required:"true" enum:"PhoneNumberProductType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSupportedPhoneNumberCountriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSupportedPhoneNumberCountriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSupportedPhoneNumberCountriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSupportedPhoneNumberCountriesInput"}
	if s.ProductType == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProductType sets the ProductType field's value.
func (s *ListSupportedPhoneNumberCountriesInput) SetProductType(v string) *ListSupportedPhoneNumberCountriesInput {
	s.ProductType = &v
	return s
}

type ListSupportedPhoneNumberCountriesOutput struct {
	_ struct{} `type:"structure"`

	PhoneNumberCountries []*PhoneNumberCountry `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSupportedPhoneNumberCountriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSupportedPhoneNumberCountriesOutput) GoString() string {
	return s.String()
}

// SetPhoneNumberCountries sets the PhoneNumberCountries field's value.
func (s *ListSupportedPhoneNumberCountriesOutput) SetPhoneNumberCountries(v []*PhoneNumberCountry) *ListSupportedPhoneNumberCountriesOutput {
	s.PhoneNumberCountries = v
	return s
}

type ListVoiceConnectorGroupsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVoiceConnectorGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVoiceConnectorGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVoiceConnectorGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVoiceConnectorGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListVoiceConnectorGroupsInput) SetMaxResults(v int64) *ListVoiceConnectorGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVoiceConnectorGroupsInput) SetNextToken(v string) *ListVoiceConnectorGroupsInput {
	s.NextToken = &v
	return s
}

type ListVoiceConnectorGroupsOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `type:"string"`

	VoiceConnectorGroups []*VoiceConnectorGroup `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVoiceConnectorGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVoiceConnectorGroupsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListVoiceConnectorGroupsOutput) SetNextToken(v string) *ListVoiceConnectorGroupsOutput {
	s.NextToken = &v
	return s
}

// SetVoiceConnectorGroups sets the VoiceConnectorGroups field's value.
func (s *ListVoiceConnectorGroupsOutput) SetVoiceConnectorGroups(v []*VoiceConnectorGroup) *ListVoiceConnectorGroupsOutput {
	s.VoiceConnectorGroups = v
	return s
}

type ListVoiceConnectorTerminationCredentialsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVoiceConnectorTerminationCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVoiceConnectorTerminationCredentialsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVoiceConnectorTerminationCredentialsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVoiceConnectorTerminationCredentialsInput"}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *ListVoiceConnectorTerminationCredentialsInput) SetVoiceConnectorId(v string) *ListVoiceConnectorTerminationCredentialsInput {
	s.VoiceConnectorId = &v
	return s
}

type ListVoiceConnectorTerminationCredentialsOutput struct {
	_ struct{} `type:"structure"`

	Usernames []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVoiceConnectorTerminationCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVoiceConnectorTerminationCredentialsOutput) GoString() string {
	return s.String()
}

// SetUsernames sets the Usernames field's value.
func (s *ListVoiceConnectorTerminationCredentialsOutput) SetUsernames(v []*string) *ListVoiceConnectorTerminationCredentialsOutput {
	s.Usernames = v
	return s
}

type ListVoiceConnectorsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVoiceConnectorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVoiceConnectorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVoiceConnectorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVoiceConnectorsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListVoiceConnectorsInput) SetMaxResults(v int64) *ListVoiceConnectorsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVoiceConnectorsInput) SetNextToken(v string) *ListVoiceConnectorsInput {
	s.NextToken = &v
	return s
}

type ListVoiceConnectorsOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `type:"string"`

	VoiceConnectors []*VoiceConnector `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVoiceConnectorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVoiceConnectorsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListVoiceConnectorsOutput) SetNextToken(v string) *ListVoiceConnectorsOutput {
	s.NextToken = &v
	return s
}

// SetVoiceConnectors sets the VoiceConnectors field's value.
func (s *ListVoiceConnectorsOutput) SetVoiceConnectors(v []*VoiceConnector) *ListVoiceConnectorsOutput {
	s.VoiceConnectors = v
	return s
}

type LoggingConfiguration struct {
	_ struct{} `type:"structure"`

	EnableSIPLogs *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoggingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoggingConfiguration) GoString() string {
	return s.String()
}

// SetEnableSIPLogs sets the EnableSIPLogs field's value.
func (s *LoggingConfiguration) SetEnableSIPLogs(v bool) *LoggingConfiguration {
	s.EnableSIPLogs = &v
	return s
}

type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type OrderedPhoneNumber struct {
	_ struct{} `type:"structure"`

	// E164PhoneNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by OrderedPhoneNumber's
	// String and GoString methods.
	E164PhoneNumber *string `type:"string" sensitive:"true"`

	Status *string `type:"string" enum:"OrderedPhoneNumberStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrderedPhoneNumber) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrderedPhoneNumber) GoString() string {
	return s.String()
}

// SetE164PhoneNumber sets the E164PhoneNumber field's value.
func (s *OrderedPhoneNumber) SetE164PhoneNumber(v string) *OrderedPhoneNumber {
	s.E164PhoneNumber = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *OrderedPhoneNumber) SetStatus(v string) *OrderedPhoneNumber {
	s.Status = &v
	return s
}

type Origination struct {
	_ struct{} `type:"structure"`

	Disabled *bool `type:"boolean"`

	Routes []*OriginationRoute `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Origination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Origination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Origination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Origination"}
	if s.Routes != nil {
		for i, v := range s.Routes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Routes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDisabled sets the Disabled field's value.
func (s *Origination) SetDisabled(v bool) *Origination {
	s.Disabled = &v
	return s
}

// SetRoutes sets the Routes field's value.
func (s *Origination) SetRoutes(v []*OriginationRoute) *Origination {
	s.Routes = v
	return s
}

type OriginationRoute struct {
	_ struct{} `type:"structure"`

	Host *string `type:"string"`

	Port *int64 `type:"integer"`

	Priority *int64 `min:"1" type:"integer"`

	Protocol *string `type:"string" enum:"OriginationRouteProtocol"`

	Weight *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OriginationRoute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OriginationRoute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OriginationRoute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OriginationRoute"}
	if s.Priority != nil && *s.Priority < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Priority", 1))
	}
	if s.Weight != nil && *s.Weight < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Weight", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHost sets the Host field's value.
func (s *OriginationRoute) SetHost(v string) *OriginationRoute {
	s.Host = &v
	return s
}

// SetPort sets the Port field's value.
func (s *OriginationRoute) SetPort(v int64) *OriginationRoute {
	s.Port = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *OriginationRoute) SetPriority(v int64) *OriginationRoute {
	s.Priority = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *OriginationRoute) SetProtocol(v string) *OriginationRoute {
	s.Protocol = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *OriginationRoute) SetWeight(v int64) *OriginationRoute {
	s.Weight = &v
	return s
}

type Participant struct {
	_ struct{} `type:"structure"`

	// PhoneNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Participant's
	// String and GoString methods.
	PhoneNumber *string `type:"string" sensitive:"true"`

	// ProxyPhoneNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Participant's
	// String and GoString methods.
	ProxyPhoneNumber *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Participant) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Participant) GoString() string {
	return s.String()
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *Participant) SetPhoneNumber(v string) *Participant {
	s.PhoneNumber = &v
	return s
}

// SetProxyPhoneNumber sets the ProxyPhoneNumber field's value.
func (s *Participant) SetProxyPhoneNumber(v string) *Participant {
	s.ProxyPhoneNumber = &v
	return s
}

type PhoneNumber struct {
	_ struct{} `type:"structure"`

	Associations []*PhoneNumberAssociation `type:"list"`

	// CallingName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PhoneNumber's
	// String and GoString methods.
	CallingName *string `type:"string" sensitive:"true"`

	CallingNameStatus *string `type:"string" enum:"CallingNameStatus"`

	Capabilities *PhoneNumberCapabilities `type:"structure"`

	Country *string `type:"string"`

	CreatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	DeletionTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// E164PhoneNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PhoneNumber's
	// String and GoString methods.
	E164PhoneNumber *string `type:"string" sensitive:"true"`

	OrderId *string `type:"string"`

	// PhoneNumberId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PhoneNumber's
	// String and GoString methods.
	PhoneNumberId *string `type:"string" sensitive:"true"`

	ProductType *string `type:"string" enum:"PhoneNumberProductType"`

	Status *string `type:"string" enum:"PhoneNumberStatus"`

	Type *string `type:"string" enum:"PhoneNumberType"`

	UpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PhoneNumber) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PhoneNumber) GoString() string {
	return s.String()
}

// SetAssociations sets the Associations field's value.
func (s *PhoneNumber) SetAssociations(v []*PhoneNumberAssociation) *PhoneNumber {
	s.Associations = v
	return s
}

// SetCallingName sets the CallingName field's value.
func (s *PhoneNumber) SetCallingName(v string) *PhoneNumber {
	s.CallingName = &v
	return s
}

// SetCallingNameStatus sets the CallingNameStatus field's value.
func (s *PhoneNumber) SetCallingNameStatus(v string) *PhoneNumber {
	s.CallingNameStatus = &v
	return s
}

// SetCapabilities sets the Capabilities field's value.
func (s *PhoneNumber) SetCapabilities(v *PhoneNumberCapabilities) *PhoneNumber {
	s.Capabilities = v
	return s
}

// SetCountry sets the Country field's value.
func (s *PhoneNumber) SetCountry(v string) *PhoneNumber {
	s.Country = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *PhoneNumber) SetCreatedTimestamp(v time.Time) *PhoneNumber {
	s.CreatedTimestamp = &v
	return s
}

// SetDeletionTimestamp sets the DeletionTimestamp field's value.
func (s *PhoneNumber) SetDeletionTimestamp(v time.Time) *PhoneNumber {
	s.DeletionTimestamp = &v
	return s
}

// SetE164PhoneNumber sets the E164PhoneNumber field's value.
func (s *PhoneNumber) SetE164PhoneNumber(v string) *PhoneNumber {
	s.E164PhoneNumber = &v
	return s
}

// SetOrderId sets the OrderId field's value.
func (s *PhoneNumber) SetOrderId(v string) *PhoneNumber {
	s.OrderId = &v
	return s
}

// SetPhoneNumberId sets the PhoneNumberId field's value.
func (s *PhoneNumber) SetPhoneNumberId(v string) *PhoneNumber {
	s.PhoneNumberId = &v
	return s
}

// SetProductType sets the ProductType field's value.
func (s *PhoneNumber) SetProductType(v string) *PhoneNumber {
	s.ProductType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *PhoneNumber) SetStatus(v string) *PhoneNumber {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *PhoneNumber) SetType(v string) *PhoneNumber {
	s.Type = &v
	return s
}

// SetUpdatedTimestamp sets the UpdatedTimestamp field's value.
func (s *PhoneNumber) SetUpdatedTimestamp(v time.Time) *PhoneNumber {
	s.UpdatedTimestamp = &v
	return s
}

type PhoneNumberAssociation struct {
	_ struct{} `type:"structure"`

	AssociatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	Name *string `type:"string" enum:"PhoneNumberAssociationName"`

	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PhoneNumberAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PhoneNumberAssociation) GoString() string {
	return s.String()
}

// SetAssociatedTimestamp sets the AssociatedTimestamp field's value.
func (s *PhoneNumberAssociation) SetAssociatedTimestamp(v time.Time) *PhoneNumberAssociation {
	s.AssociatedTimestamp = &v
	return s
}

// SetName sets the Name field's value.
func (s *PhoneNumberAssociation) SetName(v string) *PhoneNumberAssociation {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *PhoneNumberAssociation) SetValue(v string) *PhoneNumberAssociation {
	s.Value = &v
	return s
}

type PhoneNumberCapabilities struct {
	_ struct{} `type:"structure"`

	InboundCall *bool `type:"boolean"`

	InboundMMS *bool `type:"boolean"`

	InboundSMS *bool `type:"boolean"`

	OutboundCall *bool `type:"boolean"`

	OutboundMMS *bool `type:"boolean"`

	OutboundSMS *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PhoneNumberCapabilities) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PhoneNumberCapabilities) GoString() string {
	return s.String()
}

// SetInboundCall sets the InboundCall field's value.
func (s *PhoneNumberCapabilities) SetInboundCall(v bool) *PhoneNumberCapabilities {
	s.InboundCall = &v
	return s
}

// SetInboundMMS sets the InboundMMS field's value.
func (s *PhoneNumberCapabilities) SetInboundMMS(v bool) *PhoneNumberCapabilities {
	s.InboundMMS = &v
	return s
}

// SetInboundSMS sets the InboundSMS field's value.
func (s *PhoneNumberCapabilities) SetInboundSMS(v bool) *PhoneNumberCapabilities {
	s.InboundSMS = &v
	return s
}

// SetOutboundCall sets the OutboundCall field's value.
func (s *PhoneNumberCapabilities) SetOutboundCall(v bool) *PhoneNumberCapabilities {
	s.OutboundCall = &v
	return s
}

// SetOutboundMMS sets the OutboundMMS field's value.
func (s *PhoneNumberCapabilities) SetOutboundMMS(v bool) *PhoneNumberCapabilities {
	s.OutboundMMS = &v
	return s
}

// SetOutboundSMS sets the OutboundSMS field's value.
func (s *PhoneNumberCapabilities) SetOutboundSMS(v bool) *PhoneNumberCapabilities {
	s.OutboundSMS = &v
	return s
}

type PhoneNumberCountry struct {
	_ struct{} `type:"structure"`

	CountryCode *string `type:"string"`

	SupportedPhoneNumberTypes []*string `type:"list" enum:"PhoneNumberType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PhoneNumberCountry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PhoneNumberCountry) GoString() string {
	return s.String()
}

// SetCountryCode sets the CountryCode field's value.
func (s *PhoneNumberCountry) SetCountryCode(v string) *PhoneNumberCountry {
	s.CountryCode = &v
	return s
}

// SetSupportedPhoneNumberTypes sets the SupportedPhoneNumberTypes field's value.
func (s *PhoneNumberCountry) SetSupportedPhoneNumberTypes(v []*string) *PhoneNumberCountry {
	s.SupportedPhoneNumberTypes = v
	return s
}

type PhoneNumberError struct {
	_ struct{} `type:"structure"`

	ErrorCode *string `type:"string" enum:"ErrorCode"`

	ErrorMessage *string `type:"string"`

	// PhoneNumberId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PhoneNumberError's
	// String and GoString methods.
	PhoneNumberId *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PhoneNumberError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PhoneNumberError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *PhoneNumberError) SetErrorCode(v string) *PhoneNumberError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *PhoneNumberError) SetErrorMessage(v string) *PhoneNumberError {
	s.ErrorMessage = &v
	return s
}

// SetPhoneNumberId sets the PhoneNumberId field's value.
func (s *PhoneNumberError) SetPhoneNumberId(v string) *PhoneNumberError {
	s.PhoneNumberId = &v
	return s
}

type PhoneNumberOrder struct {
	_ struct{} `type:"structure"`

	CreatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	OrderType *string `type:"string" enum:"PhoneNumberOrderType"`

	OrderedPhoneNumbers []*OrderedPhoneNumber `type:"list"`

	PhoneNumberOrderId *string `type:"string"`

	ProductType *string `type:"string" enum:"PhoneNumberProductType"`

	Status *string `type:"string" enum:"PhoneNumberOrderStatus"`

	UpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PhoneNumberOrder) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PhoneNumberOrder) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *PhoneNumberOrder) SetCreatedTimestamp(v time.Time) *PhoneNumberOrder {
	s.CreatedTimestamp = &v
	return s
}

// SetOrderType sets the OrderType field's value.
func (s *PhoneNumberOrder) SetOrderType(v string) *PhoneNumberOrder {
	s.OrderType = &v
	return s
}

// SetOrderedPhoneNumbers sets the OrderedPhoneNumbers field's value.
func (s *PhoneNumberOrder) SetOrderedPhoneNumbers(v []*OrderedPhoneNumber) *PhoneNumberOrder {
	s.OrderedPhoneNumbers = v
	return s
}

// SetPhoneNumberOrderId sets the PhoneNumberOrderId field's value.
func (s *PhoneNumberOrder) SetPhoneNumberOrderId(v string) *PhoneNumberOrder {
	s.PhoneNumberOrderId = &v
	return s
}

// SetProductType sets the ProductType field's value.
func (s *PhoneNumberOrder) SetProductType(v string) *PhoneNumberOrder {
	s.ProductType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *PhoneNumberOrder) SetStatus(v string) *PhoneNumberOrder {
	s.Status = &v
	return s
}

// SetUpdatedTimestamp sets the UpdatedTimestamp field's value.
func (s *PhoneNumberOrder) SetUpdatedTimestamp(v time.Time) *PhoneNumberOrder {
	s.UpdatedTimestamp = &v
	return s
}

type Proxy struct {
	_ struct{} `type:"structure"`

	DefaultSessionExpiryMinutes *int64 `type:"integer"`

	Disabled *bool `type:"boolean"`

	// FallBackPhoneNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Proxy's
	// String and GoString methods.
	FallBackPhoneNumber *string `type:"string" sensitive:"true"`

	PhoneNumberCountries []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Proxy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Proxy) GoString() string {
	return s.String()
}

// SetDefaultSessionExpiryMinutes sets the DefaultSessionExpiryMinutes field's value.
func (s *Proxy) SetDefaultSessionExpiryMinutes(v int64) *Proxy {
	s.DefaultSessionExpiryMinutes = &v
	return s
}

// SetDisabled sets the Disabled field's value.
func (s *Proxy) SetDisabled(v bool) *Proxy {
	s.Disabled = &v
	return s
}

// SetFallBackPhoneNumber sets the FallBackPhoneNumber field's value.
func (s *Proxy) SetFallBackPhoneNumber(v string) *Proxy {
	s.FallBackPhoneNumber = &v
	return s
}

// SetPhoneNumberCountries sets the PhoneNumberCountries field's value.
func (s *Proxy) SetPhoneNumberCountries(v []*string) *Proxy {
	s.PhoneNumberCountries = v
	return s
}

type ProxySession struct {
	_ struct{} `type:"structure"`

	Capabilities []*string `type:"list" enum:"Capability"`

	CreatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	EndedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	ExpiryMinutes *int64 `min:"1" type:"integer"`

	GeoMatchLevel *string `type:"string" enum:"GeoMatchLevel"`

	GeoMatchParams *GeoMatchParams `type:"structure"`

	Name *string `type:"string"`

	NumberSelectionBehavior *string `type:"string" enum:"NumberSelectionBehavior"`

	Participants []*Participant `type:"list"`

	ProxySessionId *string `min:"1" type:"string"`

	Status *string `type:"string" enum:"ProxySessionStatus"`

	UpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	VoiceConnectorId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProxySession) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProxySession) GoString() string {
	return s.String()
}

// SetCapabilities sets the Capabilities field's value.
func (s *ProxySession) SetCapabilities(v []*string) *ProxySession {
	s.Capabilities = v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *ProxySession) SetCreatedTimestamp(v time.Time) *ProxySession {
	s.CreatedTimestamp = &v
	return s
}

// SetEndedTimestamp sets the EndedTimestamp field's value.
func (s *ProxySession) SetEndedTimestamp(v time.Time) *ProxySession {
	s.EndedTimestamp = &v
	return s
}

// SetExpiryMinutes sets the ExpiryMinutes field's value.
func (s *ProxySession) SetExpiryMinutes(v int64) *ProxySession {
	s.ExpiryMinutes = &v
	return s
}

// SetGeoMatchLevel sets the GeoMatchLevel field's value.
func (s *ProxySession) SetGeoMatchLevel(v string) *ProxySession {
	s.GeoMatchLevel = &v
	return s
}

// SetGeoMatchParams sets the GeoMatchParams field's value.
func (s *ProxySession) SetGeoMatchParams(v *GeoMatchParams) *ProxySession {
	s.GeoMatchParams = v
	return s
}

// SetName sets the Name field's value.
func (s *ProxySession) SetName(v string) *ProxySession {
	s.Name = &v
	return s
}

// SetNumberSelectionBehavior sets the NumberSelectionBehavior field's value.
func (s *ProxySession) SetNumberSelectionBehavior(v string) *ProxySession {
	s.NumberSelectionBehavior = &v
	return s
}

// SetParticipants sets the Participants field's value.
func (s *ProxySession) SetParticipants(v []*Participant) *ProxySession {
	s.Participants = v
	return s
}

// SetProxySessionId sets the ProxySessionId field's value.
func (s *ProxySession) SetProxySessionId(v string) *ProxySession {
	s.ProxySessionId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ProxySession) SetStatus(v string) *ProxySession {
	s.Status = &v
	return s
}

// SetUpdatedTimestamp sets the UpdatedTimestamp field's value.
func (s *ProxySession) SetUpdatedTimestamp(v time.Time) *ProxySession {
	s.UpdatedTimestamp = &v
	return s
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *ProxySession) SetVoiceConnectorId(v string) *ProxySession {
	s.VoiceConnectorId = &v
	return s
}

type PutSipMediaApplicationAlexaSkillConfigurationInput struct {
	_ struct{} `type:"structure"`

	SipMediaApplicationAlexaSkillConfiguration *SipMediaApplicationAlexaSkillConfiguration `type:"structure"`

	// SipMediaApplicationId is a required field
	SipMediaApplicationId *string `location:"uri" locationName:"sipMediaApplicationId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSipMediaApplicationAlexaSkillConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSipMediaApplicationAlexaSkillConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutSipMediaApplicationAlexaSkillConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutSipMediaApplicationAlexaSkillConfigurationInput"}
	if s.SipMediaApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("SipMediaApplicationId"))
	}
	if s.SipMediaApplicationId != nil && len(*s.SipMediaApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SipMediaApplicationId", 1))
	}
	if s.SipMediaApplicationAlexaSkillConfiguration != nil {
		if err := s.SipMediaApplicationAlexaSkillConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SipMediaApplicationAlexaSkillConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSipMediaApplicationAlexaSkillConfiguration sets the SipMediaApplicationAlexaSkillConfiguration field's value.
func (s *PutSipMediaApplicationAlexaSkillConfigurationInput) SetSipMediaApplicationAlexaSkillConfiguration(v *SipMediaApplicationAlexaSkillConfiguration) *PutSipMediaApplicationAlexaSkillConfigurationInput {
	s.SipMediaApplicationAlexaSkillConfiguration = v
	return s
}

// SetSipMediaApplicationId sets the SipMediaApplicationId field's value.
func (s *PutSipMediaApplicationAlexaSkillConfigurationInput) SetSipMediaApplicationId(v string) *PutSipMediaApplicationAlexaSkillConfigurationInput {
	s.SipMediaApplicationId = &v
	return s
}

type PutSipMediaApplicationAlexaSkillConfigurationOutput struct {
	_ struct{} `type:"structure"`

	SipMediaApplicationAlexaSkillConfiguration *SipMediaApplicationAlexaSkillConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSipMediaApplicationAlexaSkillConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSipMediaApplicationAlexaSkillConfigurationOutput) GoString() string {
	return s.String()
}

// SetSipMediaApplicationAlexaSkillConfiguration sets the SipMediaApplicationAlexaSkillConfiguration field's value.
func (s *PutSipMediaApplicationAlexaSkillConfigurationOutput) SetSipMediaApplicationAlexaSkillConfiguration(v *SipMediaApplicationAlexaSkillConfiguration) *PutSipMediaApplicationAlexaSkillConfigurationOutput {
	s.SipMediaApplicationAlexaSkillConfiguration = v
	return s
}

type PutSipMediaApplicationLoggingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// SipMediaApplicationId is a required field
	SipMediaApplicationId *string `location:"uri" locationName:"sipMediaApplicationId" type:"string" required:"true"`

	SipMediaApplicationLoggingConfiguration *SipMediaApplicationLoggingConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSipMediaApplicationLoggingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSipMediaApplicationLoggingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutSipMediaApplicationLoggingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutSipMediaApplicationLoggingConfigurationInput"}
	if s.SipMediaApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("SipMediaApplicationId"))
	}
	if s.SipMediaApplicationId != nil && len(*s.SipMediaApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SipMediaApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSipMediaApplicationId sets the SipMediaApplicationId field's value.
func (s *PutSipMediaApplicationLoggingConfigurationInput) SetSipMediaApplicationId(v string) *PutSipMediaApplicationLoggingConfigurationInput {
	s.SipMediaApplicationId = &v
	return s
}

// SetSipMediaApplicationLoggingConfiguration sets the SipMediaApplicationLoggingConfiguration field's value.
func (s *PutSipMediaApplicationLoggingConfigurationInput) SetSipMediaApplicationLoggingConfiguration(v *SipMediaApplicationLoggingConfiguration) *PutSipMediaApplicationLoggingConfigurationInput {
	s.SipMediaApplicationLoggingConfiguration = v
	return s
}

type PutSipMediaApplicationLoggingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	SipMediaApplicationLoggingConfiguration *SipMediaApplicationLoggingConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSipMediaApplicationLoggingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSipMediaApplicationLoggingConfigurationOutput) GoString() string {
	return s.String()
}

// SetSipMediaApplicationLoggingConfiguration sets the SipMediaApplicationLoggingConfiguration field's value.
func (s *PutSipMediaApplicationLoggingConfigurationOutput) SetSipMediaApplicationLoggingConfiguration(v *SipMediaApplicationLoggingConfiguration) *PutSipMediaApplicationLoggingConfigurationOutput {
	s.SipMediaApplicationLoggingConfiguration = v
	return s
}

type PutVoiceConnectorEmergencyCallingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// EmergencyCallingConfiguration is a required field
	EmergencyCallingConfiguration *EmergencyCallingConfiguration `type:"structure" required:"true"`

	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutVoiceConnectorEmergencyCallingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutVoiceConnectorEmergencyCallingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutVoiceConnectorEmergencyCallingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutVoiceConnectorEmergencyCallingConfigurationInput"}
	if s.EmergencyCallingConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("EmergencyCallingConfiguration"))
	}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}
	if s.EmergencyCallingConfiguration != nil {
		if err := s.EmergencyCallingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EmergencyCallingConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmergencyCallingConfiguration sets the EmergencyCallingConfiguration field's value.
func (s *PutVoiceConnectorEmergencyCallingConfigurationInput) SetEmergencyCallingConfiguration(v *EmergencyCallingConfiguration) *PutVoiceConnectorEmergencyCallingConfigurationInput {
	s.EmergencyCallingConfiguration = v
	return s
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *PutVoiceConnectorEmergencyCallingConfigurationInput) SetVoiceConnectorId(v string) *PutVoiceConnectorEmergencyCallingConfigurationInput {
	s.VoiceConnectorId = &v
	return s
}

type PutVoiceConnectorEmergencyCallingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	EmergencyCallingConfiguration *EmergencyCallingConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutVoiceConnectorEmergencyCallingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutVoiceConnectorEmergencyCallingConfigurationOutput) GoString() string {
	return s.String()
}

// SetEmergencyCallingConfiguration sets the EmergencyCallingConfiguration field's value.
func (s *PutVoiceConnectorEmergencyCallingConfigurationOutput) SetEmergencyCallingConfiguration(v *EmergencyCallingConfiguration) *PutVoiceConnectorEmergencyCallingConfigurationOutput {
	s.EmergencyCallingConfiguration = v
	return s
}

type PutVoiceConnectorLoggingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// LoggingConfiguration is a required field
	LoggingConfiguration *LoggingConfiguration `type:"structure" required:"true"`

	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutVoiceConnectorLoggingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutVoiceConnectorLoggingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutVoiceConnectorLoggingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutVoiceConnectorLoggingConfigurationInput"}
	if s.LoggingConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("LoggingConfiguration"))
	}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLoggingConfiguration sets the LoggingConfiguration field's value.
func (s *PutVoiceConnectorLoggingConfigurationInput) SetLoggingConfiguration(v *LoggingConfiguration) *PutVoiceConnectorLoggingConfigurationInput {
	s.LoggingConfiguration = v
	return s
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *PutVoiceConnectorLoggingConfigurationInput) SetVoiceConnectorId(v string) *PutVoiceConnectorLoggingConfigurationInput {
	s.VoiceConnectorId = &v
	return s
}

type PutVoiceConnectorLoggingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	LoggingConfiguration *LoggingConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutVoiceConnectorLoggingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutVoiceConnectorLoggingConfigurationOutput) GoString() string {
	return s.String()
}

// SetLoggingConfiguration sets the LoggingConfiguration field's value.
func (s *PutVoiceConnectorLoggingConfigurationOutput) SetLoggingConfiguration(v *LoggingConfiguration) *PutVoiceConnectorLoggingConfigurationOutput {
	s.LoggingConfiguration = v
	return s
}

type PutVoiceConnectorOriginationInput struct {
	_ struct{} `type:"structure"`

	// Origination is a required field
	Origination *Origination `type:"structure" required:"true"`

	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutVoiceConnectorOriginationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutVoiceConnectorOriginationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutVoiceConnectorOriginationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutVoiceConnectorOriginationInput"}
	if s.Origination == nil {
		invalidParams.Add(request.NewErrParamRequired("Origination"))
	}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}
	if s.Origination != nil {
		if err := s.Origination.Validate(); err != nil {
			invalidParams.AddNested("Origination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrigination sets the Origination field's value.
func (s *PutVoiceConnectorOriginationInput) SetOrigination(v *Origination) *PutVoiceConnectorOriginationInput {
	s.Origination = v
	return s
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *PutVoiceConnectorOriginationInput) SetVoiceConnectorId(v string) *PutVoiceConnectorOriginationInput {
	s.VoiceConnectorId = &v
	return s
}

type PutVoiceConnectorOriginationOutput struct {
	_ struct{} `type:"structure"`

	Origination *Origination `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutVoiceConnectorOriginationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutVoiceConnectorOriginationOutput) GoString() string {
	return s.String()
}

// SetOrigination sets the Origination field's value.
func (s *PutVoiceConnectorOriginationOutput) SetOrigination(v *Origination) *PutVoiceConnectorOriginationOutput {
	s.Origination = v
	return s
}

type PutVoiceConnectorProxyInput struct {
	_ struct{} `type:"structure"`

	// DefaultSessionExpiryMinutes is a required field
	DefaultSessionExpiryMinutes *int64 `type:"integer" required:"true"`

	Disabled *bool `type:"boolean"`

	// FallBackPhoneNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PutVoiceConnectorProxyInput's
	// String and GoString methods.
	FallBackPhoneNumber *string `type:"string" sensitive:"true"`

	// PhoneNumberPoolCountries is a required field
	PhoneNumberPoolCountries []*string `min:"1" type:"list" required:"true"`

	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutVoiceConnectorProxyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutVoiceConnectorProxyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutVoiceConnectorProxyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutVoiceConnectorProxyInput"}
	if s.DefaultSessionExpiryMinutes == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultSessionExpiryMinutes"))
	}
	if s.PhoneNumberPoolCountries == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneNumberPoolCountries"))
	}
	if s.PhoneNumberPoolCountries != nil && len(s.PhoneNumberPoolCountries) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PhoneNumberPoolCountries", 1))
	}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultSessionExpiryMinutes sets the DefaultSessionExpiryMinutes field's value.
func (s *PutVoiceConnectorProxyInput) SetDefaultSessionExpiryMinutes(v int64) *PutVoiceConnectorProxyInput {
	s.DefaultSessionExpiryMinutes = &v
	return s
}

// SetDisabled sets the Disabled field's value.
func (s *PutVoiceConnectorProxyInput) SetDisabled(v bool) *PutVoiceConnectorProxyInput {
	s.Disabled = &v
	return s
}

// SetFallBackPhoneNumber sets the FallBackPhoneNumber field's value.
func (s *PutVoiceConnectorProxyInput) SetFallBackPhoneNumber(v string) *PutVoiceConnectorProxyInput {
	s.FallBackPhoneNumber = &v
	return s
}

// SetPhoneNumberPoolCountries sets the PhoneNumberPoolCountries field's value.
func (s *PutVoiceConnectorProxyInput) SetPhoneNumberPoolCountries(v []*string) *PutVoiceConnectorProxyInput {
	s.PhoneNumberPoolCountries = v
	return s
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *PutVoiceConnectorProxyInput) SetVoiceConnectorId(v string) *PutVoiceConnectorProxyInput {
	s.VoiceConnectorId = &v
	return s
}

type PutVoiceConnectorProxyOutput struct {
	_ struct{} `type:"structure"`

	Proxy *Proxy `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutVoiceConnectorProxyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutVoiceConnectorProxyOutput) GoString() string {
	return s.String()
}

// SetProxy sets the Proxy field's value.
func (s *PutVoiceConnectorProxyOutput) SetProxy(v *Proxy) *PutVoiceConnectorProxyOutput {
	s.Proxy = v
	return s
}

type PutVoiceConnectorStreamingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// StreamingConfiguration is a required field
	StreamingConfiguration *StreamingConfiguration `type:"structure" required:"true"`

	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutVoiceConnectorStreamingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutVoiceConnectorStreamingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutVoiceConnectorStreamingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutVoiceConnectorStreamingConfigurationInput"}
	if s.StreamingConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamingConfiguration"))
	}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}
	if s.StreamingConfiguration != nil {
		if err := s.StreamingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("StreamingConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStreamingConfiguration sets the StreamingConfiguration field's value.
func (s *PutVoiceConnectorStreamingConfigurationInput) SetStreamingConfiguration(v *StreamingConfiguration) *PutVoiceConnectorStreamingConfigurationInput {
	s.StreamingConfiguration = v
	return s
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *PutVoiceConnectorStreamingConfigurationInput) SetVoiceConnectorId(v string) *PutVoiceConnectorStreamingConfigurationInput {
	s.VoiceConnectorId = &v
	return s
}

type PutVoiceConnectorStreamingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	StreamingConfiguration *StreamingConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutVoiceConnectorStreamingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutVoiceConnectorStreamingConfigurationOutput) GoString() string {
	return s.String()
}

// SetStreamingConfiguration sets the StreamingConfiguration field's value.
func (s *PutVoiceConnectorStreamingConfigurationOutput) SetStreamingConfiguration(v *StreamingConfiguration) *PutVoiceConnectorStreamingConfigurationOutput {
	s.StreamingConfiguration = v
	return s
}

type PutVoiceConnectorTerminationCredentialsInput struct {
	_ struct{} `type:"structure"`

	Credentials []*Credential `type:"list"`

	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutVoiceConnectorTerminationCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutVoiceConnectorTerminationCredentialsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutVoiceConnectorTerminationCredentialsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutVoiceConnectorTerminationCredentialsInput"}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCredentials sets the Credentials field's value.
func (s *PutVoiceConnectorTerminationCredentialsInput) SetCredentials(v []*Credential) *PutVoiceConnectorTerminationCredentialsInput {
	s.Credentials = v
	return s
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *PutVoiceConnectorTerminationCredentialsInput) SetVoiceConnectorId(v string) *PutVoiceConnectorTerminationCredentialsInput {
	s.VoiceConnectorId = &v
	return s
}

type PutVoiceConnectorTerminationCredentialsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutVoiceConnectorTerminationCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutVoiceConnectorTerminationCredentialsOutput) GoString() string {
	return s.String()
}

type PutVoiceConnectorTerminationInput struct {
	_ struct{} `type:"structure"`

	// Termination is a required field
	Termination *Termination `type:"structure" required:"true"`

	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutVoiceConnectorTerminationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutVoiceConnectorTerminationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutVoiceConnectorTerminationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutVoiceConnectorTerminationInput"}
	if s.Termination == nil {
		invalidParams.Add(request.NewErrParamRequired("Termination"))
	}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}
	if s.Termination != nil {
		if err := s.Termination.Validate(); err != nil {
			invalidParams.AddNested("Termination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTermination sets the Termination field's value.
func (s *PutVoiceConnectorTerminationInput) SetTermination(v *Termination) *PutVoiceConnectorTerminationInput {
	s.Termination = v
	return s
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *PutVoiceConnectorTerminationInput) SetVoiceConnectorId(v string) *PutVoiceConnectorTerminationInput {
	s.VoiceConnectorId = &v
	return s
}

type PutVoiceConnectorTerminationOutput struct {
	_ struct{} `type:"structure"`

	Termination *Termination `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutVoiceConnectorTerminationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutVoiceConnectorTerminationOutput) GoString() string {
	return s.String()
}

// SetTermination sets the Termination field's value.
func (s *PutVoiceConnectorTerminationOutput) SetTermination(v *Termination) *PutVoiceConnectorTerminationOutput {
	s.Termination = v
	return s
}

type ResourceLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceLimitExceededException) GoString() string {
	return s.String()
}

func newErrorResourceLimitExceededException(v protocol.ResponseMetadata) error {
	return &ResourceLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceLimitExceededException) Code() string {
	return "ResourceLimitExceededException"
}

// Message returns the exception's message.
func (s *ResourceLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceLimitExceededException) OrigErr() error {
	return nil
}

func (s *ResourceLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type RestorePhoneNumberInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// PhoneNumberId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RestorePhoneNumberInput's
	// String and GoString methods.
	// PhoneNumberId is a required field
	PhoneNumberId *string `location:"uri" locationName:"phoneNumberId" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestorePhoneNumberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestorePhoneNumberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestorePhoneNumberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestorePhoneNumberInput"}
	if s.PhoneNumberId == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneNumberId"))
	}
	if s.PhoneNumberId != nil && len(*s.PhoneNumberId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PhoneNumberId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPhoneNumberId sets the PhoneNumberId field's value.
func (s *RestorePhoneNumberInput) SetPhoneNumberId(v string) *RestorePhoneNumberInput {
	s.PhoneNumberId = &v
	return s
}

type RestorePhoneNumberOutput struct {
	_ struct{} `type:"structure"`

	PhoneNumber *PhoneNumber `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestorePhoneNumberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestorePhoneNumberOutput) GoString() string {
	return s.String()
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *RestorePhoneNumberOutput) SetPhoneNumber(v *PhoneNumber) *RestorePhoneNumberOutput {
	s.PhoneNumber = v
	return s
}

type SearchAvailablePhoneNumbersInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	AreaCode *string `location:"querystring" locationName:"area-code" type:"string"`

	City *string `location:"querystring" locationName:"city" type:"string"`

	Country *string `location:"querystring" locationName:"country" type:"string"`

	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	PhoneNumberType *string `location:"querystring" locationName:"phone-number-type" type:"string" enum:"PhoneNumberType"`

	State *string `location:"querystring" locationName:"state" type:"string"`

	TollFreePrefix *string `location:"querystring" locationName:"toll-free-prefix" min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchAvailablePhoneNumbersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchAvailablePhoneNumbersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchAvailablePhoneNumbersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchAvailablePhoneNumbersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.TollFreePrefix != nil && len(*s.TollFreePrefix) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TollFreePrefix", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAreaCode sets the AreaCode field's value.
func (s *SearchAvailablePhoneNumbersInput) SetAreaCode(v string) *SearchAvailablePhoneNumbersInput {
	s.AreaCode = &v
	return s
}

// SetCity sets the City field's value.
func (s *SearchAvailablePhoneNumbersInput) SetCity(v string) *SearchAvailablePhoneNumbersInput {
	s.City = &v
	return s
}

// SetCountry sets the Country field's value.
func (s *SearchAvailablePhoneNumbersInput) SetCountry(v string) *SearchAvailablePhoneNumbersInput {
	s.Country = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchAvailablePhoneNumbersInput) SetMaxResults(v int64) *SearchAvailablePhoneNumbersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchAvailablePhoneNumbersInput) SetNextToken(v string) *SearchAvailablePhoneNumbersInput {
	s.NextToken = &v
	return s
}

// SetPhoneNumberType sets the PhoneNumberType field's value.
func (s *SearchAvailablePhoneNumbersInput) SetPhoneNumberType(v string) *SearchAvailablePhoneNumbersInput {
	s.PhoneNumberType = &v
	return s
}

// SetState sets the State field's value.
func (s *SearchAvailablePhoneNumbersInput) SetState(v string) *SearchAvailablePhoneNumbersInput {
	s.State = &v
	return s
}

// SetTollFreePrefix sets the TollFreePrefix field's value.
func (s *SearchAvailablePhoneNumbersInput) SetTollFreePrefix(v string) *SearchAvailablePhoneNumbersInput {
	s.TollFreePrefix = &v
	return s
}

type SearchAvailablePhoneNumbersOutput struct {
	_ struct{} `type:"structure"`

	E164PhoneNumbers []*string `type:"list"`

	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchAvailablePhoneNumbersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchAvailablePhoneNumbersOutput) GoString() string {
	return s.String()
}

// SetE164PhoneNumbers sets the E164PhoneNumbers field's value.
func (s *SearchAvailablePhoneNumbersOutput) SetE164PhoneNumbers(v []*string) *SearchAvailablePhoneNumbersOutput {
	s.E164PhoneNumbers = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchAvailablePhoneNumbersOutput) SetNextToken(v string) *SearchAvailablePhoneNumbersOutput {
	s.NextToken = &v
	return s
}

type ServiceFailureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceFailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceFailureException) GoString() string {
	return s.String()
}

func newErrorServiceFailureException(v protocol.ResponseMetadata) error {
	return &ServiceFailureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceFailureException) Code() string {
	return "ServiceFailureException"
}

// Message returns the exception's message.
func (s *ServiceFailureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceFailureException) OrigErr() error {
	return nil
}

func (s *ServiceFailureException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceFailureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceFailureException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

type SipMediaApplication struct {
	_ struct{} `type:"structure"`

	AwsRegion *string `type:"string"`

	CreatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	Endpoints []*SipMediaApplicationEndpoint `min:"1" type:"list"`

	Name *string `min:"1" type:"string"`

	SipMediaApplicationId *string `type:"string"`

	UpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SipMediaApplication) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SipMediaApplication) GoString() string {
	return s.String()
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *SipMediaApplication) SetAwsRegion(v string) *SipMediaApplication {
	s.AwsRegion = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *SipMediaApplication) SetCreatedTimestamp(v time.Time) *SipMediaApplication {
	s.CreatedTimestamp = &v
	return s
}

// SetEndpoints sets the Endpoints field's value.
func (s *SipMediaApplication) SetEndpoints(v []*SipMediaApplicationEndpoint) *SipMediaApplication {
	s.Endpoints = v
	return s
}

// SetName sets the Name field's value.
func (s *SipMediaApplication) SetName(v string) *SipMediaApplication {
	s.Name = &v
	return s
}

// SetSipMediaApplicationId sets the SipMediaApplicationId field's value.
func (s *SipMediaApplication) SetSipMediaApplicationId(v string) *SipMediaApplication {
	s.SipMediaApplicationId = &v
	return s
}

// SetUpdatedTimestamp sets the UpdatedTimestamp field's value.
func (s *SipMediaApplication) SetUpdatedTimestamp(v time.Time) *SipMediaApplication {
	s.UpdatedTimestamp = &v
	return s
}

type SipMediaApplicationAlexaSkillConfiguration struct {
	_ struct{} `type:"structure"`

	// AlexaSkillIds is a required field
	AlexaSkillIds []*string `min:"1" type:"list" required:"true"`

	// AlexaSkillStatus is a required field
	AlexaSkillStatus *string `type:"string" required:"true" enum:"AlexaSkillStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SipMediaApplicationAlexaSkillConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SipMediaApplicationAlexaSkillConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SipMediaApplicationAlexaSkillConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SipMediaApplicationAlexaSkillConfiguration"}
	if s.AlexaSkillIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AlexaSkillIds"))
	}
	if s.AlexaSkillIds != nil && len(s.AlexaSkillIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlexaSkillIds", 1))
	}
	if s.AlexaSkillStatus == nil {
		invalidParams.Add(request.NewErrParamRequired("AlexaSkillStatus"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlexaSkillIds sets the AlexaSkillIds field's value.
func (s *SipMediaApplicationAlexaSkillConfiguration) SetAlexaSkillIds(v []*string) *SipMediaApplicationAlexaSkillConfiguration {
	s.AlexaSkillIds = v
	return s
}

// SetAlexaSkillStatus sets the AlexaSkillStatus field's value.
func (s *SipMediaApplicationAlexaSkillConfiguration) SetAlexaSkillStatus(v string) *SipMediaApplicationAlexaSkillConfiguration {
	s.AlexaSkillStatus = &v
	return s
}

type SipMediaApplicationCall struct {
	_ struct{} `type:"structure"`

	TransactionId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SipMediaApplicationCall) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SipMediaApplicationCall) GoString() string {
	return s.String()
}

// SetTransactionId sets the TransactionId field's value.
func (s *SipMediaApplicationCall) SetTransactionId(v string) *SipMediaApplicationCall {
	s.TransactionId = &v
	return s
}

type SipMediaApplicationEndpoint struct {
	_ struct{} `type:"structure"`

	// LambdaArn is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SipMediaApplicationEndpoint's
	// String and GoString methods.
	LambdaArn *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SipMediaApplicationEndpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SipMediaApplicationEndpoint) GoString() string {
	return s.String()
}

// SetLambdaArn sets the LambdaArn field's value.
func (s *SipMediaApplicationEndpoint) SetLambdaArn(v string) *SipMediaApplicationEndpoint {
	s.LambdaArn = &v
	return s
}

type SipMediaApplicationLoggingConfiguration struct {
	_ struct{} `type:"structure"`

	EnableSipMediaApplicationMessageLogs *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SipMediaApplicationLoggingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SipMediaApplicationLoggingConfiguration) GoString() string {
	return s.String()
}

// SetEnableSipMediaApplicationMessageLogs sets the EnableSipMediaApplicationMessageLogs field's value.
func (s *SipMediaApplicationLoggingConfiguration) SetEnableSipMediaApplicationMessageLogs(v bool) *SipMediaApplicationLoggingConfiguration {
	s.EnableSipMediaApplicationMessageLogs = &v
	return s
}

type SipRule struct {
	_ struct{} `type:"structure"`

	CreatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	Disabled *bool `type:"boolean"`

	Name *string `min:"1" type:"string"`

	SipRuleId *string `type:"string"`

	TargetApplications []*SipRuleTargetApplication `min:"1" type:"list"`

	TriggerType *string `type:"string" enum:"SipRuleTriggerType"`

	TriggerValue *string `type:"string"`

	UpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SipRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SipRule) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *SipRule) SetCreatedTimestamp(v time.Time) *SipRule {
	s.CreatedTimestamp = &v
	return s
}

// SetDisabled sets the Disabled field's value.
func (s *SipRule) SetDisabled(v bool) *SipRule {
	s.Disabled = &v
	return s
}

// SetName sets the Name field's value.
func (s *SipRule) SetName(v string) *SipRule {
	s.Name = &v
	return s
}

// SetSipRuleId sets the SipRuleId field's value.
func (s *SipRule) SetSipRuleId(v string) *SipRule {
	s.SipRuleId = &v
	return s
}

// SetTargetApplications sets the TargetApplications field's value.
func (s *SipRule) SetTargetApplications(v []*SipRuleTargetApplication) *SipRule {
	s.TargetApplications = v
	return s
}

// SetTriggerType sets the TriggerType field's value.
func (s *SipRule) SetTriggerType(v string) *SipRule {
	s.TriggerType = &v
	return s
}

// SetTriggerValue sets the TriggerValue field's value.
func (s *SipRule) SetTriggerValue(v string) *SipRule {
	s.TriggerValue = &v
	return s
}

// SetUpdatedTimestamp sets the UpdatedTimestamp field's value.
func (s *SipRule) SetUpdatedTimestamp(v time.Time) *SipRule {
	s.UpdatedTimestamp = &v
	return s
}

type SipRuleTargetApplication struct {
	_ struct{} `type:"structure"`

	AwsRegion *string `type:"string"`

	Priority *int64 `min:"1" type:"integer"`

	SipMediaApplicationId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SipRuleTargetApplication) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SipRuleTargetApplication) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SipRuleTargetApplication) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SipRuleTargetApplication"}
	if s.Priority != nil && *s.Priority < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Priority", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *SipRuleTargetApplication) SetAwsRegion(v string) *SipRuleTargetApplication {
	s.AwsRegion = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *SipRuleTargetApplication) SetPriority(v int64) *SipRuleTargetApplication {
	s.Priority = &v
	return s
}

// SetSipMediaApplicationId sets the SipMediaApplicationId field's value.
func (s *SipRuleTargetApplication) SetSipMediaApplicationId(v string) *SipRuleTargetApplication {
	s.SipMediaApplicationId = &v
	return s
}

type StreamingConfiguration struct {
	_ struct{} `type:"structure"`

	// DataRetentionInHours is a required field
	DataRetentionInHours *int64 `type:"integer" required:"true"`

	// Disabled is a required field
	Disabled *bool `type:"boolean" required:"true"`

	StreamingNotificationTargets []*StreamingNotificationTarget `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StreamingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StreamingConfiguration"}
	if s.DataRetentionInHours == nil {
		invalidParams.Add(request.NewErrParamRequired("DataRetentionInHours"))
	}
	if s.Disabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Disabled"))
	}
	if s.StreamingNotificationTargets != nil && len(s.StreamingNotificationTargets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamingNotificationTargets", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataRetentionInHours sets the DataRetentionInHours field's value.
func (s *StreamingConfiguration) SetDataRetentionInHours(v int64) *StreamingConfiguration {
	s.DataRetentionInHours = &v
	return s
}

// SetDisabled sets the Disabled field's value.
func (s *StreamingConfiguration) SetDisabled(v bool) *StreamingConfiguration {
	s.Disabled = &v
	return s
}

// SetStreamingNotificationTargets sets the StreamingNotificationTargets field's value.
func (s *StreamingConfiguration) SetStreamingNotificationTargets(v []*StreamingNotificationTarget) *StreamingConfiguration {
	s.StreamingNotificationTargets = v
	return s
}

type StreamingNotificationTarget struct {
	_ struct{} `type:"structure"`

	NotificationTarget *string `type:"string" enum:"NotificationTarget"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamingNotificationTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamingNotificationTarget) GoString() string {
	return s.String()
}

// SetNotificationTarget sets the NotificationTarget field's value.
func (s *StreamingNotificationTarget) SetNotificationTarget(v string) *StreamingNotificationTarget {
	s.NotificationTarget = &v
	return s
}

type Termination struct {
	_ struct{} `type:"structure"`

	CallingRegions []*string `type:"list"`

	CidrAllowedList []*string `type:"list"`

	CpsLimit *int64 `min:"1" type:"integer"`

	// DefaultPhoneNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Termination's
	// String and GoString methods.
	DefaultPhoneNumber *string `type:"string" sensitive:"true"`

	Disabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Termination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Termination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Termination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Termination"}
	if s.CpsLimit != nil && *s.CpsLimit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CpsLimit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallingRegions sets the CallingRegions field's value.
func (s *Termination) SetCallingRegions(v []*string) *Termination {
	s.CallingRegions = v
	return s
}

// SetCidrAllowedList sets the CidrAllowedList field's value.
func (s *Termination) SetCidrAllowedList(v []*string) *Termination {
	s.CidrAllowedList = v
	return s
}

// SetCpsLimit sets the CpsLimit field's value.
func (s *Termination) SetCpsLimit(v int64) *Termination {
	s.CpsLimit = &v
	return s
}

// SetDefaultPhoneNumber sets the DefaultPhoneNumber field's value.
func (s *Termination) SetDefaultPhoneNumber(v string) *Termination {
	s.DefaultPhoneNumber = &v
	return s
}

// SetDisabled sets the Disabled field's value.
func (s *Termination) SetDisabled(v bool) *Termination {
	s.Disabled = &v
	return s
}

type TerminationHealth struct {
	_ struct{} `type:"structure"`

	Source *string `type:"string"`

	Timestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminationHealth) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminationHealth) GoString() string {
	return s.String()
}

// SetSource sets the Source field's value.
func (s *TerminationHealth) SetSource(v string) *TerminationHealth {
	s.Source = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *TerminationHealth) SetTimestamp(v time.Time) *TerminationHealth {
	s.Timestamp = &v
	return s
}

type ThrottledClientException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottledClientException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottledClientException) GoString() string {
	return s.String()
}

func newErrorThrottledClientException(v protocol.ResponseMetadata) error {
	return &ThrottledClientException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottledClientException) Code() string {
	return "ThrottledClientException"
}

// Message returns the exception's message.
func (s *ThrottledClientException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottledClientException) OrigErr() error {
	return nil
}

func (s *ThrottledClientException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottledClientException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottledClientException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UnauthorizedClientException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnauthorizedClientException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnauthorizedClientException) GoString() string {
	return s.String()
}

func newErrorUnauthorizedClientException(v protocol.ResponseMetadata) error {
	return &UnauthorizedClientException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnauthorizedClientException) Code() string {
	return "UnauthorizedClientException"
}

// Message returns the exception's message.
func (s *UnauthorizedClientException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnauthorizedClientException) OrigErr() error {
	return nil
}

func (s *UnauthorizedClientException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnauthorizedClientException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnauthorizedClientException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UpdateGlobalSettingsInput struct {
	_ struct{} `type:"structure"`

	VoiceConnector *VoiceConnectorSettings `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGlobalSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGlobalSettingsInput) GoString() string {
	return s.String()
}

// SetVoiceConnector sets the VoiceConnector field's value.
func (s *UpdateGlobalSettingsInput) SetVoiceConnector(v *VoiceConnectorSettings) *UpdateGlobalSettingsInput {
	s.VoiceConnector = v
	return s
}

type UpdateGlobalSettingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGlobalSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGlobalSettingsOutput) GoString() string {
	return s.String()
}

type UpdatePhoneNumberInput struct {
	_ struct{} `type:"structure"`

	// CallingName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdatePhoneNumberInput's
	// String and GoString methods.
	CallingName *string `type:"string" sensitive:"true"`

	// PhoneNumberId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdatePhoneNumberInput's
	// String and GoString methods.
	// PhoneNumberId is a required field
	PhoneNumberId *string `location:"uri" locationName:"phoneNumberId" type:"string" required:"true" sensitive:"true"`

	ProductType *string `type:"string" enum:"PhoneNumberProductType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePhoneNumberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePhoneNumberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePhoneNumberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePhoneNumberInput"}
	if s.PhoneNumberId == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneNumberId"))
	}
	if s.PhoneNumberId != nil && len(*s.PhoneNumberId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PhoneNumberId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallingName sets the CallingName field's value.
func (s *UpdatePhoneNumberInput) SetCallingName(v string) *UpdatePhoneNumberInput {
	s.CallingName = &v
	return s
}

// SetPhoneNumberId sets the PhoneNumberId field's value.
func (s *UpdatePhoneNumberInput) SetPhoneNumberId(v string) *UpdatePhoneNumberInput {
	s.PhoneNumberId = &v
	return s
}

// SetProductType sets the ProductType field's value.
func (s *UpdatePhoneNumberInput) SetProductType(v string) *UpdatePhoneNumberInput {
	s.ProductType = &v
	return s
}

type UpdatePhoneNumberOutput struct {
	_ struct{} `type:"structure"`

	PhoneNumber *PhoneNumber `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePhoneNumberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePhoneNumberOutput) GoString() string {
	return s.String()
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *UpdatePhoneNumberOutput) SetPhoneNumber(v *PhoneNumber) *UpdatePhoneNumberOutput {
	s.PhoneNumber = v
	return s
}

type UpdatePhoneNumberRequestItem struct {
	_ struct{} `type:"structure"`

	// CallingName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdatePhoneNumberRequestItem's
	// String and GoString methods.
	CallingName *string `type:"string" sensitive:"true"`

	// PhoneNumberId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdatePhoneNumberRequestItem's
	// String and GoString methods.
	// PhoneNumberId is a required field
	PhoneNumberId *string `type:"string" required:"true" sensitive:"true"`

	ProductType *string `type:"string" enum:"PhoneNumberProductType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePhoneNumberRequestItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePhoneNumberRequestItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePhoneNumberRequestItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePhoneNumberRequestItem"}
	if s.PhoneNumberId == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneNumberId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallingName sets the CallingName field's value.
func (s *UpdatePhoneNumberRequestItem) SetCallingName(v string) *UpdatePhoneNumberRequestItem {
	s.CallingName = &v
	return s
}

// SetPhoneNumberId sets the PhoneNumberId field's value.
func (s *UpdatePhoneNumberRequestItem) SetPhoneNumberId(v string) *UpdatePhoneNumberRequestItem {
	s.PhoneNumberId = &v
	return s
}

// SetProductType sets the ProductType field's value.
func (s *UpdatePhoneNumberRequestItem) SetProductType(v string) *UpdatePhoneNumberRequestItem {
	s.ProductType = &v
	return s
}

type UpdatePhoneNumberSettingsInput struct {
	_ struct{} `type:"structure"`

	// CallingName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdatePhoneNumberSettingsInput's
	// String and GoString methods.
	// CallingName is a required field
	CallingName *string `type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePhoneNumberSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePhoneNumberSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePhoneNumberSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePhoneNumberSettingsInput"}
	if s.CallingName == nil {
		invalidParams.Add(request.NewErrParamRequired("CallingName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallingName sets the CallingName field's value.
func (s *UpdatePhoneNumberSettingsInput) SetCallingName(v string) *UpdatePhoneNumberSettingsInput {
	s.CallingName = &v
	return s
}

type UpdatePhoneNumberSettingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePhoneNumberSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePhoneNumberSettingsOutput) GoString() string {
	return s.String()
}

type UpdateProxySessionInput struct {
	_ struct{} `type:"structure"`

	// Capabilities is a required field
	Capabilities []*string `type:"list" required:"true" enum:"Capability"`

	ExpiryMinutes *int64 `min:"1" type:"integer"`

	// ProxySessionId is a required field
	ProxySessionId *string `location:"uri" locationName:"proxySessionId" min:"1" type:"string" required:"true"`

	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProxySessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProxySessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProxySessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateProxySessionInput"}
	if s.Capabilities == nil {
		invalidParams.Add(request.NewErrParamRequired("Capabilities"))
	}
	if s.ExpiryMinutes != nil && *s.ExpiryMinutes < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ExpiryMinutes", 1))
	}
	if s.ProxySessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProxySessionId"))
	}
	if s.ProxySessionId != nil && len(*s.ProxySessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProxySessionId", 1))
	}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapabilities sets the Capabilities field's value.
func (s *UpdateProxySessionInput) SetCapabilities(v []*string) *UpdateProxySessionInput {
	s.Capabilities = v
	return s
}

// SetExpiryMinutes sets the ExpiryMinutes field's value.
func (s *UpdateProxySessionInput) SetExpiryMinutes(v int64) *UpdateProxySessionInput {
	s.ExpiryMinutes = &v
	return s
}

// SetProxySessionId sets the ProxySessionId field's value.
func (s *UpdateProxySessionInput) SetProxySessionId(v string) *UpdateProxySessionInput {
	s.ProxySessionId = &v
	return s
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *UpdateProxySessionInput) SetVoiceConnectorId(v string) *UpdateProxySessionInput {
	s.VoiceConnectorId = &v
	return s
}

type UpdateProxySessionOutput struct {
	_ struct{} `type:"structure"`

	ProxySession *ProxySession `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProxySessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProxySessionOutput) GoString() string {
	return s.String()
}

// SetProxySession sets the ProxySession field's value.
func (s *UpdateProxySessionOutput) SetProxySession(v *ProxySession) *UpdateProxySessionOutput {
	s.ProxySession = v
	return s
}

type UpdateSipMediaApplicationCallInput struct {
	_ struct{} `type:"structure"`

	// Arguments is a required field
	Arguments map[string]*string `type:"map" required:"true"`

	// SipMediaApplicationId is a required field
	SipMediaApplicationId *string `location:"uri" locationName:"sipMediaApplicationId" type:"string" required:"true"`

	// TransactionId is a required field
	TransactionId *string `location:"uri" locationName:"transactionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSipMediaApplicationCallInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSipMediaApplicationCallInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSipMediaApplicationCallInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSipMediaApplicationCallInput"}
	if s.Arguments == nil {
		invalidParams.Add(request.NewErrParamRequired("Arguments"))
	}
	if s.SipMediaApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("SipMediaApplicationId"))
	}
	if s.SipMediaApplicationId != nil && len(*s.SipMediaApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SipMediaApplicationId", 1))
	}
	if s.TransactionId == nil {
		invalidParams.Add(request.NewErrParamRequired("TransactionId"))
	}
	if s.TransactionId != nil && len(*s.TransactionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TransactionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArguments sets the Arguments field's value.
func (s *UpdateSipMediaApplicationCallInput) SetArguments(v map[string]*string) *UpdateSipMediaApplicationCallInput {
	s.Arguments = v
	return s
}

// SetSipMediaApplicationId sets the SipMediaApplicationId field's value.
func (s *UpdateSipMediaApplicationCallInput) SetSipMediaApplicationId(v string) *UpdateSipMediaApplicationCallInput {
	s.SipMediaApplicationId = &v
	return s
}

// SetTransactionId sets the TransactionId field's value.
func (s *UpdateSipMediaApplicationCallInput) SetTransactionId(v string) *UpdateSipMediaApplicationCallInput {
	s.TransactionId = &v
	return s
}

type UpdateSipMediaApplicationCallOutput struct {
	_ struct{} `type:"structure"`

	SipMediaApplicationCall *SipMediaApplicationCall `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSipMediaApplicationCallOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSipMediaApplicationCallOutput) GoString() string {
	return s.String()
}

// SetSipMediaApplicationCall sets the SipMediaApplicationCall field's value.
func (s *UpdateSipMediaApplicationCallOutput) SetSipMediaApplicationCall(v *SipMediaApplicationCall) *UpdateSipMediaApplicationCallOutput {
	s.SipMediaApplicationCall = v
	return s
}

type UpdateSipMediaApplicationInput struct {
	_ struct{} `type:"structure"`

	Endpoints []*SipMediaApplicationEndpoint `min:"1" type:"list"`

	Name *string `min:"1" type:"string"`

	// SipMediaApplicationId is a required field
	SipMediaApplicationId *string `location:"uri" locationName:"sipMediaApplicationId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSipMediaApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSipMediaApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSipMediaApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSipMediaApplicationInput"}
	if s.Endpoints != nil && len(s.Endpoints) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Endpoints", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SipMediaApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("SipMediaApplicationId"))
	}
	if s.SipMediaApplicationId != nil && len(*s.SipMediaApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SipMediaApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpoints sets the Endpoints field's value.
func (s *UpdateSipMediaApplicationInput) SetEndpoints(v []*SipMediaApplicationEndpoint) *UpdateSipMediaApplicationInput {
	s.Endpoints = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateSipMediaApplicationInput) SetName(v string) *UpdateSipMediaApplicationInput {
	s.Name = &v
	return s
}

// SetSipMediaApplicationId sets the SipMediaApplicationId field's value.
func (s *UpdateSipMediaApplicationInput) SetSipMediaApplicationId(v string) *UpdateSipMediaApplicationInput {
	s.SipMediaApplicationId = &v
	return s
}

type UpdateSipMediaApplicationOutput struct {
	_ struct{} `type:"structure"`

	SipMediaApplication *SipMediaApplication `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSipMediaApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSipMediaApplicationOutput) GoString() string {
	return s.String()
}

// SetSipMediaApplication sets the SipMediaApplication field's value.
func (s *UpdateSipMediaApplicationOutput) SetSipMediaApplication(v *SipMediaApplication) *UpdateSipMediaApplicationOutput {
	s.SipMediaApplication = v
	return s
}

type UpdateSipRuleInput struct {
	_ struct{} `type:"structure"`

	Disabled *bool `type:"boolean"`

	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// SipRuleId is a required field
	SipRuleId *string `location:"uri" locationName:"sipRuleId" type:"string" required:"true"`

	TargetApplications []*SipRuleTargetApplication `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSipRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSipRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSipRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSipRuleInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SipRuleId == nil {
		invalidParams.Add(request.NewErrParamRequired("SipRuleId"))
	}
	if s.SipRuleId != nil && len(*s.SipRuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SipRuleId", 1))
	}
	if s.TargetApplications != nil && len(s.TargetApplications) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetApplications", 1))
	}
	if s.TargetApplications != nil {
		for i, v := range s.TargetApplications {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TargetApplications", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDisabled sets the Disabled field's value.
func (s *UpdateSipRuleInput) SetDisabled(v bool) *UpdateSipRuleInput {
	s.Disabled = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateSipRuleInput) SetName(v string) *UpdateSipRuleInput {
	s.Name = &v
	return s
}

// SetSipRuleId sets the SipRuleId field's value.
func (s *UpdateSipRuleInput) SetSipRuleId(v string) *UpdateSipRuleInput {
	s.SipRuleId = &v
	return s
}

// SetTargetApplications sets the TargetApplications field's value.
func (s *UpdateSipRuleInput) SetTargetApplications(v []*SipRuleTargetApplication) *UpdateSipRuleInput {
	s.TargetApplications = v
	return s
}

type UpdateSipRuleOutput struct {
	_ struct{} `type:"structure"`

	SipRule *SipRule `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSipRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSipRuleOutput) GoString() string {
	return s.String()
}

// SetSipRule sets the SipRule field's value.
func (s *UpdateSipRuleOutput) SetSipRule(v *SipRule) *UpdateSipRuleOutput {
	s.SipRule = v
	return s
}

type UpdateVoiceConnectorGroupInput struct {
	_ struct{} `type:"structure"`

	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// VoiceConnectorGroupId is a required field
	VoiceConnectorGroupId *string `location:"uri" locationName:"voiceConnectorGroupId" type:"string" required:"true"`

	// VoiceConnectorItems is a required field
	VoiceConnectorItems []*VoiceConnectorItem `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVoiceConnectorGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVoiceConnectorGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVoiceConnectorGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVoiceConnectorGroupInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.VoiceConnectorGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorGroupId"))
	}
	if s.VoiceConnectorGroupId != nil && len(*s.VoiceConnectorGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorGroupId", 1))
	}
	if s.VoiceConnectorItems == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorItems"))
	}
	if s.VoiceConnectorItems != nil {
		for i, v := range s.VoiceConnectorItems {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "VoiceConnectorItems", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *UpdateVoiceConnectorGroupInput) SetName(v string) *UpdateVoiceConnectorGroupInput {
	s.Name = &v
	return s
}

// SetVoiceConnectorGroupId sets the VoiceConnectorGroupId field's value.
func (s *UpdateVoiceConnectorGroupInput) SetVoiceConnectorGroupId(v string) *UpdateVoiceConnectorGroupInput {
	s.VoiceConnectorGroupId = &v
	return s
}

// SetVoiceConnectorItems sets the VoiceConnectorItems field's value.
func (s *UpdateVoiceConnectorGroupInput) SetVoiceConnectorItems(v []*VoiceConnectorItem) *UpdateVoiceConnectorGroupInput {
	s.VoiceConnectorItems = v
	return s
}

type UpdateVoiceConnectorGroupOutput struct {
	_ struct{} `type:"structure"`

	VoiceConnectorGroup *VoiceConnectorGroup `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVoiceConnectorGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVoiceConnectorGroupOutput) GoString() string {
	return s.String()
}

// SetVoiceConnectorGroup sets the VoiceConnectorGroup field's value.
func (s *UpdateVoiceConnectorGroupOutput) SetVoiceConnectorGroup(v *VoiceConnectorGroup) *UpdateVoiceConnectorGroupOutput {
	s.VoiceConnectorGroup = v
	return s
}

type UpdateVoiceConnectorInput struct {
	_ struct{} `type:"structure"`

	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// RequireEncryption is a required field
	RequireEncryption *bool `type:"boolean" required:"true"`

	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVoiceConnectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVoiceConnectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVoiceConnectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVoiceConnectorInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RequireEncryption == nil {
		invalidParams.Add(request.NewErrParamRequired("RequireEncryption"))
	}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *UpdateVoiceConnectorInput) SetName(v string) *UpdateVoiceConnectorInput {
	s.Name = &v
	return s
}

// SetRequireEncryption sets the RequireEncryption field's value.
func (s *UpdateVoiceConnectorInput) SetRequireEncryption(v bool) *UpdateVoiceConnectorInput {
	s.RequireEncryption = &v
	return s
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *UpdateVoiceConnectorInput) SetVoiceConnectorId(v string) *UpdateVoiceConnectorInput {
	s.VoiceConnectorId = &v
	return s
}

type UpdateVoiceConnectorOutput struct {
	_ struct{} `type:"structure"`

	VoiceConnector *VoiceConnector `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVoiceConnectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVoiceConnectorOutput) GoString() string {
	return s.String()
}

// SetVoiceConnector sets the VoiceConnector field's value.
func (s *UpdateVoiceConnectorOutput) SetVoiceConnector(v *VoiceConnector) *UpdateVoiceConnectorOutput {
	s.VoiceConnector = v
	return s
}

type ValidateE911AddressInput struct {
	_ struct{} `type:"structure"`

	// AwsAccountId is a required field
	AwsAccountId *string `type:"string" required:"true"`

	// City is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ValidateE911AddressInput's
	// String and GoString methods.
	// City is a required field
	City *string `type:"string" required:"true" sensitive:"true"`

	// Country is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ValidateE911AddressInput's
	// String and GoString methods.
	// Country is a required field
	Country *string `type:"string" required:"true" sensitive:"true"`

	// PostalCode is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ValidateE911AddressInput's
	// String and GoString methods.
	// PostalCode is a required field
	PostalCode *string `type:"string" required:"true" sensitive:"true"`

	// State is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ValidateE911AddressInput's
	// String and GoString methods.
	// State is a required field
	State *string `type:"string" required:"true" sensitive:"true"`

	// StreetInfo is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ValidateE911AddressInput's
	// String and GoString methods.
	// StreetInfo is a required field
	StreetInfo *string `type:"string" required:"true" sensitive:"true"`

	// StreetNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ValidateE911AddressInput's
	// String and GoString methods.
	// StreetNumber is a required field
	StreetNumber *string `type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidateE911AddressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidateE911AddressInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ValidateE911AddressInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ValidateE911AddressInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.City == nil {
		invalidParams.Add(request.NewErrParamRequired("City"))
	}
	if s.Country == nil {
		invalidParams.Add(request.NewErrParamRequired("Country"))
	}
	if s.PostalCode == nil {
		invalidParams.Add(request.NewErrParamRequired("PostalCode"))
	}
	if s.State == nil {
		invalidParams.Add(request.NewErrParamRequired("State"))
	}
	if s.StreetInfo == nil {
		invalidParams.Add(request.NewErrParamRequired("StreetInfo"))
	}
	if s.StreetNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("StreetNumber"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *ValidateE911AddressInput) SetAwsAccountId(v string) *ValidateE911AddressInput {
	s.AwsAccountId = &v
	return s
}

// SetCity sets the City field's value.
func (s *ValidateE911AddressInput) SetCity(v string) *ValidateE911AddressInput {
	s.City = &v
	return s
}

// SetCountry sets the Country field's value.
func (s *ValidateE911AddressInput) SetCountry(v string) *ValidateE911AddressInput {
	s.Country = &v
	return s
}

// SetPostalCode sets the PostalCode field's value.
func (s *ValidateE911AddressInput) SetPostalCode(v string) *ValidateE911AddressInput {
	s.PostalCode = &v
	return s
}

// SetState sets the State field's value.
func (s *ValidateE911AddressInput) SetState(v string) *ValidateE911AddressInput {
	s.State = &v
	return s
}

// SetStreetInfo sets the StreetInfo field's value.
func (s *ValidateE911AddressInput) SetStreetInfo(v string) *ValidateE911AddressInput {
	s.StreetInfo = &v
	return s
}

// SetStreetNumber sets the StreetNumber field's value.
func (s *ValidateE911AddressInput) SetStreetNumber(v string) *ValidateE911AddressInput {
	s.StreetNumber = &v
	return s
}

type ValidateE911AddressOutput struct {
	_ struct{} `type:"structure"`

	Address *Address `type:"structure"`

	AddressExternalId *string `type:"string"`

	CandidateAddressList []*CandidateAddress `type:"list"`

	ValidationResult *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidateE911AddressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidateE911AddressOutput) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *ValidateE911AddressOutput) SetAddress(v *Address) *ValidateE911AddressOutput {
	s.Address = v
	return s
}

// SetAddressExternalId sets the AddressExternalId field's value.
func (s *ValidateE911AddressOutput) SetAddressExternalId(v string) *ValidateE911AddressOutput {
	s.AddressExternalId = &v
	return s
}

// SetCandidateAddressList sets the CandidateAddressList field's value.
func (s *ValidateE911AddressOutput) SetCandidateAddressList(v []*CandidateAddress) *ValidateE911AddressOutput {
	s.CandidateAddressList = v
	return s
}

// SetValidationResult sets the ValidationResult field's value.
func (s *ValidateE911AddressOutput) SetValidationResult(v int64) *ValidateE911AddressOutput {
	s.ValidationResult = &v
	return s
}

type VoiceConnector struct {
	_ struct{} `type:"structure"`

	AwsRegion *string `type:"string" enum:"VoiceConnectorAwsRegion"`

	CreatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	Name *string `min:"1" type:"string"`

	OutboundHostName *string `type:"string"`

	RequireEncryption *bool `type:"boolean"`

	UpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	VoiceConnectorArn *string `type:"string"`

	VoiceConnectorId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VoiceConnector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VoiceConnector) GoString() string {
	return s.String()
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *VoiceConnector) SetAwsRegion(v string) *VoiceConnector {
	s.AwsRegion = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *VoiceConnector) SetCreatedTimestamp(v time.Time) *VoiceConnector {
	s.CreatedTimestamp = &v
	return s
}

// SetName sets the Name field's value.
func (s *VoiceConnector) SetName(v string) *VoiceConnector {
	s.Name = &v
	return s
}

// SetOutboundHostName sets the OutboundHostName field's value.
func (s *VoiceConnector) SetOutboundHostName(v string) *VoiceConnector {
	s.OutboundHostName = &v
	return s
}

// SetRequireEncryption sets the RequireEncryption field's value.
func (s *VoiceConnector) SetRequireEncryption(v bool) *VoiceConnector {
	s.RequireEncryption = &v
	return s
}

// SetUpdatedTimestamp sets the UpdatedTimestamp field's value.
func (s *VoiceConnector) SetUpdatedTimestamp(v time.Time) *VoiceConnector {
	s.UpdatedTimestamp = &v
	return s
}

// SetVoiceConnectorArn sets the VoiceConnectorArn field's value.
func (s *VoiceConnector) SetVoiceConnectorArn(v string) *VoiceConnector {
	s.VoiceConnectorArn = &v
	return s
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *VoiceConnector) SetVoiceConnectorId(v string) *VoiceConnector {
	s.VoiceConnectorId = &v
	return s
}

type VoiceConnectorGroup struct {
	_ struct{} `type:"structure"`

	CreatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	Name *string `min:"1" type:"string"`

	UpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	VoiceConnectorGroupArn *string `type:"string"`

	VoiceConnectorGroupId *string `type:"string"`

	VoiceConnectorItems []*VoiceConnectorItem `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VoiceConnectorGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VoiceConnectorGroup) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *VoiceConnectorGroup) SetCreatedTimestamp(v time.Time) *VoiceConnectorGroup {
	s.CreatedTimestamp = &v
	return s
}

// SetName sets the Name field's value.
func (s *VoiceConnectorGroup) SetName(v string) *VoiceConnectorGroup {
	s.Name = &v
	return s
}

// SetUpdatedTimestamp sets the UpdatedTimestamp field's value.
func (s *VoiceConnectorGroup) SetUpdatedTimestamp(v time.Time) *VoiceConnectorGroup {
	s.UpdatedTimestamp = &v
	return s
}

// SetVoiceConnectorGroupArn sets the VoiceConnectorGroupArn field's value.
func (s *VoiceConnectorGroup) SetVoiceConnectorGroupArn(v string) *VoiceConnectorGroup {
	s.VoiceConnectorGroupArn = &v
	return s
}

// SetVoiceConnectorGroupId sets the VoiceConnectorGroupId field's value.
func (s *VoiceConnectorGroup) SetVoiceConnectorGroupId(v string) *VoiceConnectorGroup {
	s.VoiceConnectorGroupId = &v
	return s
}

// SetVoiceConnectorItems sets the VoiceConnectorItems field's value.
func (s *VoiceConnectorGroup) SetVoiceConnectorItems(v []*VoiceConnectorItem) *VoiceConnectorGroup {
	s.VoiceConnectorItems = v
	return s
}

type VoiceConnectorItem struct {
	_ struct{} `type:"structure"`

	// Priority is a required field
	Priority *int64 `min:"1" type:"integer" required:"true"`

	// VoiceConnectorId is a required field
	VoiceConnectorId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VoiceConnectorItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VoiceConnectorItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VoiceConnectorItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VoiceConnectorItem"}
	if s.Priority == nil {
		invalidParams.Add(request.NewErrParamRequired("Priority"))
	}
	if s.Priority != nil && *s.Priority < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Priority", 1))
	}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPriority sets the Priority field's value.
func (s *VoiceConnectorItem) SetPriority(v int64) *VoiceConnectorItem {
	s.Priority = &v
	return s
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *VoiceConnectorItem) SetVoiceConnectorId(v string) *VoiceConnectorItem {
	s.VoiceConnectorId = &v
	return s
}

type VoiceConnectorSettings struct {
	_ struct{} `type:"structure"`

	CdrBucket *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VoiceConnectorSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VoiceConnectorSettings) GoString() string {
	return s.String()
}

// SetCdrBucket sets the CdrBucket field's value.
func (s *VoiceConnectorSettings) SetCdrBucket(v string) *VoiceConnectorSettings {
	s.CdrBucket = &v
	return s
}

const (
	// AlexaSkillStatusActive is a AlexaSkillStatus enum value
	AlexaSkillStatusActive = "ACTIVE"

	// AlexaSkillStatusInactive is a AlexaSkillStatus enum value
	AlexaSkillStatusInactive = "INACTIVE"
)

// AlexaSkillStatus_Values returns all elements of the AlexaSkillStatus enum
func AlexaSkillStatus_Values() []string {
	return []string{
		AlexaSkillStatusActive,
		AlexaSkillStatusInactive,
	}
}

const (
	// CallingNameStatusUnassigned is a CallingNameStatus enum value
	CallingNameStatusUnassigned = "Unassigned"

	// CallingNameStatusUpdateInProgress is a CallingNameStatus enum value
	CallingNameStatusUpdateInProgress = "UpdateInProgress"

	// CallingNameStatusUpdateSucceeded is a CallingNameStatus enum value
	CallingNameStatusUpdateSucceeded = "UpdateSucceeded"

	// CallingNameStatusUpdateFailed is a CallingNameStatus enum value
	CallingNameStatusUpdateFailed = "UpdateFailed"
)

// CallingNameStatus_Values returns all elements of the CallingNameStatus enum
func CallingNameStatus_Values() []string {
	return []string{
		CallingNameStatusUnassigned,
		CallingNameStatusUpdateInProgress,
		CallingNameStatusUpdateSucceeded,
		CallingNameStatusUpdateFailed,
	}
}

const (
	// CapabilityVoice is a Capability enum value
	CapabilityVoice = "Voice"

	// CapabilitySms is a Capability enum value
	CapabilitySms = "SMS"
)

// Capability_Values returns all elements of the Capability enum
func Capability_Values() []string {
	return []string{
		CapabilityVoice,
		CapabilitySms,
	}
}

const (
	// ErrorCodeBadRequest is a ErrorCode enum value
	ErrorCodeBadRequest = "BadRequest"

	// ErrorCodeConflict is a ErrorCode enum value
	ErrorCodeConflict = "Conflict"

	// ErrorCodeForbidden is a ErrorCode enum value
	ErrorCodeForbidden = "Forbidden"

	// ErrorCodeNotFound is a ErrorCode enum value
	ErrorCodeNotFound = "NotFound"

	// ErrorCodePreconditionFailed is a ErrorCode enum value
	ErrorCodePreconditionFailed = "PreconditionFailed"

	// ErrorCodeResourceLimitExceeded is a ErrorCode enum value
	ErrorCodeResourceLimitExceeded = "ResourceLimitExceeded"

	// ErrorCodeServiceFailure is a ErrorCode enum value
	ErrorCodeServiceFailure = "ServiceFailure"

	// ErrorCodeAccessDenied is a ErrorCode enum value
	ErrorCodeAccessDenied = "AccessDenied"

	// ErrorCodeServiceUnavailable is a ErrorCode enum value
	ErrorCodeServiceUnavailable = "ServiceUnavailable"

	// ErrorCodeThrottled is a ErrorCode enum value
	ErrorCodeThrottled = "Throttled"

	// ErrorCodeThrottling is a ErrorCode enum value
	ErrorCodeThrottling = "Throttling"

	// ErrorCodeUnauthorized is a ErrorCode enum value
	ErrorCodeUnauthorized = "Unauthorized"

	// ErrorCodeUnprocessable is a ErrorCode enum value
	ErrorCodeUnprocessable = "Unprocessable"

	// ErrorCodeVoiceConnectorGroupAssociationsExist is a ErrorCode enum value
	ErrorCodeVoiceConnectorGroupAssociationsExist = "VoiceConnectorGroupAssociationsExist"

	// ErrorCodePhoneNumberAssociationsExist is a ErrorCode enum value
	ErrorCodePhoneNumberAssociationsExist = "PhoneNumberAssociationsExist"

	// ErrorCodeGone is a ErrorCode enum value
	ErrorCodeGone = "Gone"
)

// ErrorCode_Values returns all elements of the ErrorCode enum
func ErrorCode_Values() []string {
	return []string{
		ErrorCodeBadRequest,
		ErrorCodeConflict,
		ErrorCodeForbidden,
		ErrorCodeNotFound,
		ErrorCodePreconditionFailed,
		ErrorCodeResourceLimitExceeded,
		ErrorCodeServiceFailure,
		ErrorCodeAccessDenied,
		ErrorCodeServiceUnavailable,
		ErrorCodeThrottled,
		ErrorCodeThrottling,
		ErrorCodeUnauthorized,
		ErrorCodeUnprocessable,
		ErrorCodeVoiceConnectorGroupAssociationsExist,
		ErrorCodePhoneNumberAssociationsExist,
		ErrorCodeGone,
	}
}

const (
	// GeoMatchLevelCountry is a GeoMatchLevel enum value
	GeoMatchLevelCountry = "Country"

	// GeoMatchLevelAreaCode is a GeoMatchLevel enum value
	GeoMatchLevelAreaCode = "AreaCode"
)

// GeoMatchLevel_Values returns all elements of the GeoMatchLevel enum
func GeoMatchLevel_Values() []string {
	return []string{
		GeoMatchLevelCountry,
		GeoMatchLevelAreaCode,
	}
}

const (
	// NotificationTargetEventBridge is a NotificationTarget enum value
	NotificationTargetEventBridge = "EventBridge"

	// NotificationTargetSns is a NotificationTarget enum value
	NotificationTargetSns = "SNS"

	// NotificationTargetSqs is a NotificationTarget enum value
	NotificationTargetSqs = "SQS"
)

// NotificationTarget_Values returns all elements of the NotificationTarget enum
func NotificationTarget_Values() []string {
	return []string{
		NotificationTargetEventBridge,
		NotificationTargetSns,
		NotificationTargetSqs,
	}
}

const (
	// NumberSelectionBehaviorPreferSticky is a NumberSelectionBehavior enum value
	NumberSelectionBehaviorPreferSticky = "PreferSticky"

	// NumberSelectionBehaviorAvoidSticky is a NumberSelectionBehavior enum value
	NumberSelectionBehaviorAvoidSticky = "AvoidSticky"
)

// NumberSelectionBehavior_Values returns all elements of the NumberSelectionBehavior enum
func NumberSelectionBehavior_Values() []string {
	return []string{
		NumberSelectionBehaviorPreferSticky,
		NumberSelectionBehaviorAvoidSticky,
	}
}

const (
	// OrderedPhoneNumberStatusProcessing is a OrderedPhoneNumberStatus enum value
	OrderedPhoneNumberStatusProcessing = "Processing"

	// OrderedPhoneNumberStatusAcquired is a OrderedPhoneNumberStatus enum value
	OrderedPhoneNumberStatusAcquired = "Acquired"

	// OrderedPhoneNumberStatusFailed is a OrderedPhoneNumberStatus enum value
	OrderedPhoneNumberStatusFailed = "Failed"
)

// OrderedPhoneNumberStatus_Values returns all elements of the OrderedPhoneNumberStatus enum
func OrderedPhoneNumberStatus_Values() []string {
	return []string{
		OrderedPhoneNumberStatusProcessing,
		OrderedPhoneNumberStatusAcquired,
		OrderedPhoneNumberStatusFailed,
	}
}

const (
	// OriginationRouteProtocolTcp is a OriginationRouteProtocol enum value
	OriginationRouteProtocolTcp = "TCP"

	// OriginationRouteProtocolUdp is a OriginationRouteProtocol enum value
	OriginationRouteProtocolUdp = "UDP"
)

// OriginationRouteProtocol_Values returns all elements of the OriginationRouteProtocol enum
func OriginationRouteProtocol_Values() []string {
	return []string{
		OriginationRouteProtocolTcp,
		OriginationRouteProtocolUdp,
	}
}

const (
	// PhoneNumberAssociationNameVoiceConnectorId is a PhoneNumberAssociationName enum value
	PhoneNumberAssociationNameVoiceConnectorId = "VoiceConnectorId"

	// PhoneNumberAssociationNameVoiceConnectorGroupId is a PhoneNumberAssociationName enum value
	PhoneNumberAssociationNameVoiceConnectorGroupId = "VoiceConnectorGroupId"

	// PhoneNumberAssociationNameSipRuleId is a PhoneNumberAssociationName enum value
	PhoneNumberAssociationNameSipRuleId = "SipRuleId"
)

// PhoneNumberAssociationName_Values returns all elements of the PhoneNumberAssociationName enum
func PhoneNumberAssociationName_Values() []string {
	return []string{
		PhoneNumberAssociationNameVoiceConnectorId,
		PhoneNumberAssociationNameVoiceConnectorGroupId,
		PhoneNumberAssociationNameSipRuleId,
	}
}

const (
	// PhoneNumberOrderStatusProcessing is a PhoneNumberOrderStatus enum value
	PhoneNumberOrderStatusProcessing = "Processing"

	// PhoneNumberOrderStatusSuccessful is a PhoneNumberOrderStatus enum value
	PhoneNumberOrderStatusSuccessful = "Successful"

	// PhoneNumberOrderStatusFailed is a PhoneNumberOrderStatus enum value
	PhoneNumberOrderStatusFailed = "Failed"

	// PhoneNumberOrderStatusPartial is a PhoneNumberOrderStatus enum value
	PhoneNumberOrderStatusPartial = "Partial"

	// PhoneNumberOrderStatusPendingDocuments is a PhoneNumberOrderStatus enum value
	PhoneNumberOrderStatusPendingDocuments = "PendingDocuments"

	// PhoneNumberOrderStatusSubmitted is a PhoneNumberOrderStatus enum value
	PhoneNumberOrderStatusSubmitted = "Submitted"

	// PhoneNumberOrderStatusFoc is a PhoneNumberOrderStatus enum value
	PhoneNumberOrderStatusFoc = "FOC"

	// PhoneNumberOrderStatusChangeRequested is a PhoneNumberOrderStatus enum value
	PhoneNumberOrderStatusChangeRequested = "ChangeRequested"

	// PhoneNumberOrderStatusException is a PhoneNumberOrderStatus enum value
	PhoneNumberOrderStatusException = "Exception"

	// PhoneNumberOrderStatusCancelRequested is a PhoneNumberOrderStatus enum value
	PhoneNumberOrderStatusCancelRequested = "CancelRequested"

	// PhoneNumberOrderStatusCancelled is a PhoneNumberOrderStatus enum value
	PhoneNumberOrderStatusCancelled = "Cancelled"
)

// PhoneNumberOrderStatus_Values returns all elements of the PhoneNumberOrderStatus enum
func PhoneNumberOrderStatus_Values() []string {
	return []string{
		PhoneNumberOrderStatusProcessing,
		PhoneNumberOrderStatusSuccessful,
		PhoneNumberOrderStatusFailed,
		PhoneNumberOrderStatusPartial,
		PhoneNumberOrderStatusPendingDocuments,
		PhoneNumberOrderStatusSubmitted,
		PhoneNumberOrderStatusFoc,
		PhoneNumberOrderStatusChangeRequested,
		PhoneNumberOrderStatusException,
		PhoneNumberOrderStatusCancelRequested,
		PhoneNumberOrderStatusCancelled,
	}
}

const (
	// PhoneNumberOrderTypeNew is a PhoneNumberOrderType enum value
	PhoneNumberOrderTypeNew = "New"

	// PhoneNumberOrderTypePorting is a PhoneNumberOrderType enum value
	PhoneNumberOrderTypePorting = "Porting"
)

// PhoneNumberOrderType_Values returns all elements of the PhoneNumberOrderType enum
func PhoneNumberOrderType_Values() []string {
	return []string{
		PhoneNumberOrderTypeNew,
		PhoneNumberOrderTypePorting,
	}
}

const (
	// PhoneNumberProductTypeVoiceConnector is a PhoneNumberProductType enum value
	PhoneNumberProductTypeVoiceConnector = "VoiceConnector"

	// PhoneNumberProductTypeSipMediaApplicationDialIn is a PhoneNumberProductType enum value
	PhoneNumberProductTypeSipMediaApplicationDialIn = "SipMediaApplicationDialIn"
)

// PhoneNumberProductType_Values returns all elements of the PhoneNumberProductType enum
func PhoneNumberProductType_Values() []string {
	return []string{
		PhoneNumberProductTypeVoiceConnector,
		PhoneNumberProductTypeSipMediaApplicationDialIn,
	}
}

const (
	// PhoneNumberStatusCancelled is a PhoneNumberStatus enum value
	PhoneNumberStatusCancelled = "Cancelled"

	// PhoneNumberStatusPortinCancelRequested is a PhoneNumberStatus enum value
	PhoneNumberStatusPortinCancelRequested = "PortinCancelRequested"

	// PhoneNumberStatusPortinInProgress is a PhoneNumberStatus enum value
	PhoneNumberStatusPortinInProgress = "PortinInProgress"

	// PhoneNumberStatusAcquireInProgress is a PhoneNumberStatus enum value
	PhoneNumberStatusAcquireInProgress = "AcquireInProgress"

	// PhoneNumberStatusAcquireFailed is a PhoneNumberStatus enum value
	PhoneNumberStatusAcquireFailed = "AcquireFailed"

	// PhoneNumberStatusUnassigned is a PhoneNumberStatus enum value
	PhoneNumberStatusUnassigned = "Unassigned"

	// PhoneNumberStatusAssigned is a PhoneNumberStatus enum value
	PhoneNumberStatusAssigned = "Assigned"

	// PhoneNumberStatusReleaseInProgress is a PhoneNumberStatus enum value
	PhoneNumberStatusReleaseInProgress = "ReleaseInProgress"

	// PhoneNumberStatusDeleteInProgress is a PhoneNumberStatus enum value
	PhoneNumberStatusDeleteInProgress = "DeleteInProgress"

	// PhoneNumberStatusReleaseFailed is a PhoneNumberStatus enum value
	PhoneNumberStatusReleaseFailed = "ReleaseFailed"

	// PhoneNumberStatusDeleteFailed is a PhoneNumberStatus enum value
	PhoneNumberStatusDeleteFailed = "DeleteFailed"
)

// PhoneNumberStatus_Values returns all elements of the PhoneNumberStatus enum
func PhoneNumberStatus_Values() []string {
	return []string{
		PhoneNumberStatusCancelled,
		PhoneNumberStatusPortinCancelRequested,
		PhoneNumberStatusPortinInProgress,
		PhoneNumberStatusAcquireInProgress,
		PhoneNumberStatusAcquireFailed,
		PhoneNumberStatusUnassigned,
		PhoneNumberStatusAssigned,
		PhoneNumberStatusReleaseInProgress,
		PhoneNumberStatusDeleteInProgress,
		PhoneNumberStatusReleaseFailed,
		PhoneNumberStatusDeleteFailed,
	}
}

const (
	// PhoneNumberTypeLocal is a PhoneNumberType enum value
	PhoneNumberTypeLocal = "Local"

	// PhoneNumberTypeTollFree is a PhoneNumberType enum value
	PhoneNumberTypeTollFree = "TollFree"
)

// PhoneNumberType_Values returns all elements of the PhoneNumberType enum
func PhoneNumberType_Values() []string {
	return []string{
		PhoneNumberTypeLocal,
		PhoneNumberTypeTollFree,
	}
}

const (
	// ProxySessionStatusOpen is a ProxySessionStatus enum value
	ProxySessionStatusOpen = "Open"

	// ProxySessionStatusInProgress is a ProxySessionStatus enum value
	ProxySessionStatusInProgress = "InProgress"

	// ProxySessionStatusClosed is a ProxySessionStatus enum value
	ProxySessionStatusClosed = "Closed"
)

// ProxySessionStatus_Values returns all elements of the ProxySessionStatus enum
func ProxySessionStatus_Values() []string {
	return []string{
		ProxySessionStatusOpen,
		ProxySessionStatusInProgress,
		ProxySessionStatusClosed,
	}
}

const (
	// SipRuleTriggerTypeToPhoneNumber is a SipRuleTriggerType enum value
	SipRuleTriggerTypeToPhoneNumber = "ToPhoneNumber"

	// SipRuleTriggerTypeRequestUriHostname is a SipRuleTriggerType enum value
	SipRuleTriggerTypeRequestUriHostname = "RequestUriHostname"
)

// SipRuleTriggerType_Values returns all elements of the SipRuleTriggerType enum
func SipRuleTriggerType_Values() []string {
	return []string{
		SipRuleTriggerTypeToPhoneNumber,
		SipRuleTriggerTypeRequestUriHostname,
	}
}

const (
	// VoiceConnectorAwsRegionUsEast1 is a VoiceConnectorAwsRegion enum value
	VoiceConnectorAwsRegionUsEast1 = "us-east-1"

	// VoiceConnectorAwsRegionUsWest2 is a VoiceConnectorAwsRegion enum value
	VoiceConnectorAwsRegionUsWest2 = "us-west-2"

	// VoiceConnectorAwsRegionCaCentral1 is a VoiceConnectorAwsRegion enum value
	VoiceConnectorAwsRegionCaCentral1 = "ca-central-1"

	// VoiceConnectorAwsRegionEuCentral1 is a VoiceConnectorAwsRegion enum value
	VoiceConnectorAwsRegionEuCentral1 = "eu-central-1"

	// VoiceConnectorAwsRegionEuWest1 is a VoiceConnectorAwsRegion enum value
	VoiceConnectorAwsRegionEuWest1 = "eu-west-1"

	// VoiceConnectorAwsRegionEuWest2 is a VoiceConnectorAwsRegion enum value
	VoiceConnectorAwsRegionEuWest2 = "eu-west-2"

	// VoiceConnectorAwsRegionApNortheast2 is a VoiceConnectorAwsRegion enum value
	VoiceConnectorAwsRegionApNortheast2 = "ap-northeast-2"

	// VoiceConnectorAwsRegionApNortheast1 is a VoiceConnectorAwsRegion enum value
	VoiceConnectorAwsRegionApNortheast1 = "ap-northeast-1"

	// VoiceConnectorAwsRegionApSoutheast1 is a VoiceConnectorAwsRegion enum value
	VoiceConnectorAwsRegionApSoutheast1 = "ap-southeast-1"

	// VoiceConnectorAwsRegionApSoutheast2 is a VoiceConnectorAwsRegion enum value
	VoiceConnectorAwsRegionApSoutheast2 = "ap-southeast-2"
)

// VoiceConnectorAwsRegion_Values returns all elements of the VoiceConnectorAwsRegion enum
func VoiceConnectorAwsRegion_Values() []string {
	return []string{
		VoiceConnectorAwsRegionUsEast1,
		VoiceConnectorAwsRegionUsWest2,
		VoiceConnectorAwsRegionCaCentral1,
		VoiceConnectorAwsRegionEuCentral1,
		VoiceConnectorAwsRegionEuWest1,
		VoiceConnectorAwsRegionEuWest2,
		VoiceConnectorAwsRegionApNortheast2,
		VoiceConnectorAwsRegionApNortheast1,
		VoiceConnectorAwsRegionApSoutheast1,
		VoiceConnectorAwsRegionApSoutheast2,
	}
}
