/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiType;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.light.LightCompactConstructorParameter;
import com.intellij.psi.impl.light.LightRecordCanonicalConstructor;
import com.intellij.psi.impl.light.LightRecordField;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaPsiRecordUtil {
    public static final Set<String> ILLEGAL_RECORD_COMPONENT_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"clone", "finalize", "getClass", "hashCode", "notify", "notifyAll", "toString", "wait"});

    @Nullable
    public static PsiRecordComponent getRecordComponentForAccessor(@NotNull PsiMethod accessor) {
        PsiElement parent;
        PsiClass aClass;
        if (accessor == null) {
            JavaPsiRecordUtil.$$$reportNull$$$0(0);
        }
        if ((aClass = accessor.getContainingClass()) == null && (parent = accessor.getParent()) instanceof DummyHolder) {
            aClass = (PsiClass)ObjectUtils.tryCast((Object)parent.getContext(), PsiClass.class);
        }
        if (aClass == null || !aClass.isRecord()) {
            return null;
        }
        if (!accessor.getParameterList().isEmpty()) {
            return null;
        }
        String name = accessor.getName();
        for (PsiRecordComponent c : aClass.getRecordComponents()) {
            if (!name.equals(c.getName())) continue;
            return c;
        }
        return null;
    }

    @Nullable
    public static PsiMethod getAccessorForRecordComponent(@NotNull PsiRecordComponent component) {
        PsiClass aClass;
        if (component == null) {
            JavaPsiRecordUtil.$$$reportNull$$$0(1);
        }
        if ((aClass = component.getContainingClass()) == null || !aClass.isRecord()) {
            return null;
        }
        for (PsiMethod method : aClass.findMethodsByName(component.getName(), false)) {
            if (!method.getParameterList().isEmpty()) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static PsiField getFieldForComponent(@NotNull PsiRecordComponent component) {
        PsiClass aClass;
        if (component == null) {
            JavaPsiRecordUtil.$$$reportNull$$$0(2);
        }
        if ((aClass = component.getContainingClass()) == null) {
            return null;
        }
        String name = component.getName();
        for (PsiField field : aClass.getFields()) {
            if (!field.getName().equals(name) || field.hasModifierProperty("static")) continue;
            return field;
        }
        return null;
    }

    @Nullable
    public static PsiRecordComponent getComponentForCanonicalConstructorParameter(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            JavaPsiRecordUtil.$$$reportNull$$$0(3);
        }
        if (parameter instanceof LightCompactConstructorParameter) {
            return ((LightCompactConstructorParameter)parameter).getRecordComponent();
        }
        PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parameter, PsiClass.class);
        if (aClass == null) {
            return null;
        }
        String parameterName = parameter.getName();
        return Stream.of(aClass.getRecordComponents()).filter(component -> parameterName.equals(component.getName())).findFirst().orElse(null);
    }

    @Nullable
    public static PsiRecordComponent getComponentForField(@NotNull PsiField field) {
        if (field == null) {
            JavaPsiRecordUtil.$$$reportNull$$$0(4);
        }
        return field instanceof LightRecordField ? ((LightRecordField)field).getRecordComponent() : null;
    }

    public static boolean isCompactConstructor(@NotNull PsiMethod method) {
        if (method == null) {
            JavaPsiRecordUtil.$$$reportNull$$$0(5);
        }
        return method.isConstructor() && method.getParameterList().getText() == null;
    }

    public static boolean isExplicitCanonicalConstructor(@NotNull PsiMethod method) {
        if (method == null) {
            JavaPsiRecordUtil.$$$reportNull$$$0(6);
        }
        if (!method.isConstructor() || JavaPsiRecordUtil.isCompactConstructor(method)) {
            return false;
        }
        if (method instanceof SyntheticElement) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null || !aClass.isRecord()) {
            return false;
        }
        return JavaPsiRecordUtil.hasCanonicalSignature(method, aClass.getRecordComponents());
    }

    public static boolean isCanonicalConstructor(@NotNull PsiMethod method) {
        if (method == null) {
            JavaPsiRecordUtil.$$$reportNull$$$0(7);
        }
        if (method instanceof LightRecordCanonicalConstructor) {
            return true;
        }
        if (!method.isConstructor()) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null || !aClass.isRecord()) {
            return false;
        }
        return method.getParameterList().getText() == null || JavaPsiRecordUtil.hasCanonicalSignature(method, aClass.getRecordComponents());
    }

    private static boolean hasCanonicalSignature(@NotNull PsiMethod method, PsiRecordComponent[] components) {
        PsiParameter[] parameters;
        if (method == null) {
            JavaPsiRecordUtil.$$$reportNull$$$0(8);
        }
        if (components.length != (parameters = method.getParameterList().getParameters()).length) {
            return false;
        }
        for (int i = 0; i < parameters.length; ++i) {
            PsiType componentType = components[i].getType();
            PsiType parameterType = parameters[i].getType();
            if (componentType instanceof PsiEllipsisType) {
                componentType = ((PsiEllipsisType)componentType).toArrayType();
            }
            if (parameterType instanceof PsiEllipsisType) {
                parameterType = ((PsiEllipsisType)parameterType).toArrayType();
            }
            if (TypeConversionUtil.erasure(componentType).equals(TypeConversionUtil.erasure(parameterType))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static PsiMethod findCanonicalConstructor(@NotNull PsiClass recordClass) {
        if (recordClass == null) {
            JavaPsiRecordUtil.$$$reportNull$$$0(9);
        }
        if (!recordClass.isRecord()) {
            return null;
        }
        PsiMethod[] constructors = recordClass.getConstructors();
        if (constructors.length == 0) {
            return null;
        }
        PsiRecordComponent[] components = recordClass.getRecordComponents();
        for (PsiMethod constructor : constructors) {
            if (!JavaPsiRecordUtil.isCompactConstructor(constructor) && !JavaPsiRecordUtil.hasCanonicalSignature(constructor, components)) continue;
            return constructor;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/util/JavaPsiRecordUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getRecordComponentForAccessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getAccessorForRecordComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getFieldForComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getComponentForCanonicalConstructorParameter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getComponentForField";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isCompactConstructor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isExplicitCanonicalConstructor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isCanonicalConstructor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "hasCanonicalSignature";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "findCanonicalConstructor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

