/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiFragment;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.impl.source.tree.java.PsiLiteralExpressionImpl;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class StringLiteralEscaper<T extends PsiLanguageInjectionHost>
extends LiteralTextEscaper<T> {
    private int[] outSourceOffsets;

    public StringLiteralEscaper(T host) {
        super(host);
    }

    public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
        if (rangeInsideHost == null) {
            StringLiteralEscaper.$$$reportNull$$$0(0);
        }
        if (outChars == null) {
            StringLiteralEscaper.$$$reportNull$$$0(1);
        }
        String subText = rangeInsideHost.substring(this.myHost.getText());
        this.outSourceOffsets = new int[subText.length() + 1];
        return PsiLiteralExpressionImpl.parseStringCharacters(subText, outChars, this.outSourceOffsets);
    }

    public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
        int result;
        if (rangeInsideHost == null) {
            StringLiteralEscaper.$$$reportNull$$$0(2);
        }
        int n = result = offsetInDecoded < this.outSourceOffsets.length ? this.outSourceOffsets[offsetInDecoded] : -1;
        if (result == -1) {
            return -1;
        }
        return Math.min(result, rangeInsideHost.getLength()) + rangeInsideHost.getStartOffset();
    }

    public boolean isOneLine() {
        boolean textBlock = this.myHost instanceof PsiFragment && ((PsiFragment)this.myHost).isTextBlock() || this.myHost instanceof PsiLiteralExpression && ((PsiLiteralExpression)this.myHost).isTextBlock();
        return !textBlock;
    }

    @NotNull
    public TextRange getRelevantTextRange() {
        if (this.myHost instanceof PsiFragment) {
            PsiFragment fragment = (PsiFragment)this.myHost;
            int length = fragment.getTextLength();
            IElementType tokenType = fragment.getTokenType();
            if (tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_BEGIN) {
                String text = fragment.getText();
                int startOffset = StringLiteralEscaper.findBlockStart(text);
                return startOffset < 0 ? new TextRange(0, length) : new TextRange(startOffset, length - 2);
            }
            if (tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_MID) {
                return new TextRange(1, Math.max(1, length - 2));
            }
            if (tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_END) {
                String text = fragment.getText();
                if (text.endsWith("\"\"\"")) {
                    return new TextRange(1, Math.max(1, length - 3));
                }
                return new TextRange(1, length);
            }
            if (tokenType == JavaTokenType.STRING_TEMPLATE_BEGIN || tokenType == JavaTokenType.STRING_TEMPLATE_MID) {
                return new TextRange(1, Math.max(1, length - 2));
            }
            if (tokenType == JavaTokenType.STRING_TEMPLATE_END) {
                String text = fragment.getText();
                if (text.endsWith("\"")) {
                    return new TextRange(1, Math.max(1, length - 1));
                }
                return new TextRange(1, length);
            }
            throw new IllegalStateException("Unexpected tokenType: " + tokenType);
        }
        if (this.myHost instanceof PsiLiteralExpression) {
            PsiLiteralExpression expression = (PsiLiteralExpression)this.myHost;
            int length = expression.getTextLength();
            if (expression.isTextBlock()) {
                String text = expression.getText();
                int startOffset = StringLiteralEscaper.findBlockStart(text);
                return startOffset < 0 ? new TextRange(0, length) : new TextRange(startOffset, length - (text.endsWith("\"\"\"") ? 3 : 0));
            }
            PsiType type = expression.getType();
            boolean isQuoted = PsiTypes.charType().equals(type) || type != null && type.equalsToText("java.lang.String");
            TextRange textRange = isQuoted ? new TextRange(1, Math.max(1, length - 1)) : TextRange.from((int)0, (int)length);
            if (textRange == null) {
                StringLiteralEscaper.$$$reportNull$$$0(3);
            }
            return textRange;
        }
        int textLength = this.myHost.getTextLength();
        if (textLength >= 2) {
            TextRange textRange = TextRange.from((int)1, (int)(textLength - 2));
            if (textRange == null) {
                StringLiteralEscaper.$$$reportNull$$$0(4);
            }
            return textRange;
        }
        TextRange textRange = super.getRelevantTextRange();
        if (textRange == null) {
            StringLiteralEscaper.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    static int findBlockStart(String text) {
        if (!text.startsWith("\"\"\"")) {
            return -1;
        }
        int length = text.length();
        for (int i = 3; i < length; ++i) {
            char c = text.charAt(i);
            if (c == '\n') {
                return i + 1;
            }
            if (Character.isWhitespace(c)) continue;
            return -1;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInsideHost";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outChars";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/injected/StringLiteralEscaper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/StringLiteralEscaper";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelevantTextRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "decode";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOffsetInHost";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

