/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.core.JavaPsiBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import java.util.List;

public class SubtypingConstraint
implements ConstraintFormula {
    private static final Logger LOG = Logger.getInstance(SubtypingConstraint.class);
    private PsiType myS;
    private PsiType myT;

    public SubtypingConstraint(PsiType t, PsiType s) {
        this.myT = t;
        this.myS = s;
    }

    @Override
    public void apply(PsiSubstitutor substitutor, boolean cache) {
        this.myT = substitutor.substitute(this.myT);
        this.myS = substitutor.substitute(this.myS);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubtypingConstraint that = (SubtypingConstraint)o;
        return ConstraintUtil.typesEqual(this.myS, that.myS) && ConstraintUtil.typesEqual(this.myT, that.myT);
    }

    public int hashCode() {
        int result = ConstraintUtil.typeHashCode(this.myT);
        result = 31 * result + ConstraintUtil.typeHashCode(this.myS);
        return result;
    }

    @Override
    public boolean reduce(InferenceSession session, List<? super ConstraintFormula> constraints) {
        boolean reduceResult = this.doReduce(constraints);
        if (!reduceResult) {
            session.registerIncompatibleErrorMessage(session.getInferenceVariables(), JavaPsiBundle.message("type.can.be.converted", session.getPresentableText(this.myS), session.getPresentableText(this.myT)));
        }
        return reduceResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean doReduce(List<? super ConstraintFormula> constraints) {
        if (this.myT instanceof PsiWildcardType) {
            PsiType tBound = ((PsiWildcardType)this.myT).getBound();
            if (tBound == null) {
                return true;
            }
            if (((PsiWildcardType)this.myT).isExtends()) {
                if (this.myS instanceof PsiWildcardType) {
                    PsiType sBound = ((PsiWildcardType)this.myS).getBound();
                    if (sBound == null) {
                        constraints.add(new StrictSubtypingConstraint(tBound, ((PsiWildcardType)this.myS).getExtendsBound(), false));
                        return true;
                    }
                    if (((PsiWildcardType)this.myS).isExtends()) {
                        constraints.add(new StrictSubtypingConstraint(tBound, sBound, false));
                        return true;
                    }
                    if (((PsiWildcardType)this.myS).isSuper()) {
                        constraints.add(new TypeEqualityConstraint(tBound, PsiType.getJavaLangObject(((PsiWildcardType)this.myT).getManager(), this.myT.getResolveScope())));
                        return true;
                    }
                    assert (false);
                    return false;
                }
                constraints.add(new StrictSubtypingConstraint(tBound, this.myS, false));
                return true;
            }
            LOG.assertTrue(((PsiWildcardType)this.myT).isSuper());
            if (this.myS instanceof PsiWildcardType) {
                PsiType sBound = ((PsiWildcardType)this.myS).getBound();
                if (sBound == null || !((PsiWildcardType)this.myS).isSuper()) return false;
                constraints.add(new StrictSubtypingConstraint(sBound, tBound, false));
                return true;
            }
            constraints.add(new StrictSubtypingConstraint(this.myS, tBound, false));
            return true;
        }
        if (this.myS instanceof PsiWildcardType) {
            return false;
        }
        constraints.add(new TypeEqualityConstraint(this.myT, this.myS));
        return true;
    }

    public String toString() {
        return this.myS.getPresentableText() + " <= " + this.myT.getPresentableText();
    }
}

