/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.formatter.java.JavaFormatterUtil;
import com.intellij.psi.formatter.java.LegacyCallChunkBlockBuilder;
import com.intellij.psi.formatter.java.SyntheticCodeBlock;
import com.intellij.psi.impl.source.tree.JavaElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LegacyChainedMethodCallsBlockBuilder {
    public static final String COMPATIBILITY_KEY = "java.formatter.chained.calls.pre212.compatibility";
    private final CommonCodeStyleSettings mySettings;
    private final CommonCodeStyleSettings.IndentOptions myIndentSettings;
    private final JavaCodeStyleSettings myJavaSettings;
    private final Wrap myBlockWrap;
    private final Alignment myBlockAlignment;
    private final Indent myBlockIndent;
    private final FormattingMode myFormattingMode;

    LegacyChainedMethodCallsBlockBuilder(Alignment alignment, Wrap wrap, Indent indent, CommonCodeStyleSettings settings, JavaCodeStyleSettings javaSettings, @NotNull FormattingMode formattingMode) {
        if (formattingMode == null) {
            LegacyChainedMethodCallsBlockBuilder.$$$reportNull$$$0(0);
        }
        this.myBlockWrap = wrap;
        this.myBlockAlignment = alignment;
        this.myBlockIndent = indent;
        this.mySettings = settings;
        this.myIndentSettings = settings.getIndentOptions();
        this.myJavaSettings = javaSettings;
        this.myFormattingMode = formattingMode;
    }

    public Block build(List<? extends ASTNode> nodes) {
        List<Block> blocks = this.buildBlocksFrom(nodes);
        Indent indent = this.myBlockIndent != null ? this.myBlockIndent : Indent.getContinuationWithoutFirstIndent((boolean)this.myIndentSettings.USE_RELATIVE_INDENTS);
        return new SyntheticCodeBlock(blocks, this.myBlockAlignment, this.mySettings, this.myJavaSettings, indent, this.myBlockWrap);
    }

    private List<Block> buildBlocksFrom(List<? extends ASTNode> nodes) {
        List<ChainedCallChunk> methodCall = LegacyChainedMethodCallsBlockBuilder.splitMethodCallOnChunksByDots(nodes);
        Wrap wrap = null;
        Alignment chainedCallsAlignment = null;
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (int i = 0; i < methodCall.size(); ++i) {
            ChainedCallChunk currentCallChunk = methodCall.get(i);
            if (LegacyChainedMethodCallsBlockBuilder.isMethodCall(currentCallChunk) || LegacyChainedMethodCallsBlockBuilder.isComment(currentCallChunk)) {
                if (wrap == null) {
                    wrap = this.createCallChunkWrap(i, methodCall);
                }
                if (chainedCallsAlignment == null) {
                    chainedCallsAlignment = this.createCallChunkAlignment(i, methodCall);
                }
            } else {
                wrap = null;
                chainedCallsAlignment = null;
            }
            LegacyCallChunkBlockBuilder builder = new LegacyCallChunkBlockBuilder(this.mySettings, this.myJavaSettings, this.myFormattingMode);
            blocks.add(builder.create(currentCallChunk.nodes, wrap, chainedCallsAlignment));
        }
        return blocks;
    }

    private static boolean isComment(ChainedCallChunk chunk) {
        List<ASTNode> nodes = chunk.nodes;
        if (nodes.size() == 1) {
            return nodes.get(0).getPsi() instanceof PsiComment;
        }
        return false;
    }

    private Wrap createCallChunkWrap(int chunkIndex, @NotNull List<? extends ChainedCallChunk> methodCall) {
        if (methodCall == null) {
            LegacyChainedMethodCallsBlockBuilder.$$$reportNull$$$0(1);
        }
        if (this.mySettings.WRAP_FIRST_METHOD_IN_CALL_CHAIN) {
            ChainedCallChunk next;
            ChainedCallChunk chainedCallChunk = next = chunkIndex + 1 < methodCall.size() ? methodCall.get(chunkIndex + 1) : null;
            if (next != null && LegacyChainedMethodCallsBlockBuilder.isMethodCall(next)) {
                return Wrap.createWrap((WrapType)JavaFormatterUtil.getWrapType(this.mySettings.METHOD_CALL_CHAIN_WRAP), (boolean)true);
            }
        }
        return Wrap.createWrap((WrapType)JavaFormatterUtil.getWrapType(this.mySettings.METHOD_CALL_CHAIN_WRAP), (boolean)false);
    }

    private boolean shouldAlignMethod(ChainedCallChunk currentMethodChunk, List<ChainedCallChunk> methodCall) {
        return this.mySettings.ALIGN_MULTILINE_CHAINED_METHODS && !currentMethodChunk.isEmpty() && !LegacyChainedMethodCallsBlockBuilder.chunkIsFirstInChainMethodCall(currentMethodChunk, methodCall);
    }

    private static boolean chunkIsFirstInChainMethodCall(@NotNull ChainedCallChunk callChunk, @NotNull List<ChainedCallChunk> methodCall) {
        if (callChunk == null) {
            LegacyChainedMethodCallsBlockBuilder.$$$reportNull$$$0(2);
        }
        if (methodCall == null) {
            LegacyChainedMethodCallsBlockBuilder.$$$reportNull$$$0(3);
        }
        return !methodCall.isEmpty() && callChunk == methodCall.get(0);
    }

    @NotNull
    private static List<ChainedCallChunk> splitMethodCallOnChunksByDots(@NotNull List<? extends ASTNode> nodes) {
        if (nodes == null) {
            LegacyChainedMethodCallsBlockBuilder.$$$reportNull$$$0(4);
        }
        ArrayList<ChainedCallChunk> result = new ArrayList<ChainedCallChunk>();
        ArrayList<Object> current = new ArrayList<ASTNode>();
        for (ASTNode aSTNode : nodes) {
            if (aSTNode.getElementType() == JavaTokenType.DOT || aSTNode.getPsi() instanceof PsiComment) {
                if (!current.isEmpty()) {
                    result.add(new ChainedCallChunk(current));
                }
                current = new ArrayList();
            }
            current.add(aSTNode);
        }
        if (!current.isEmpty()) {
            result.add(new ChainedCallChunk(current));
        }
        ArrayList<ChainedCallChunk> arrayList = result;
        if (arrayList == null) {
            LegacyChainedMethodCallsBlockBuilder.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private Alignment createCallChunkAlignment(int chunkIndex, @NotNull List<ChainedCallChunk> methodCall) {
        ChainedCallChunk current;
        if (methodCall == null) {
            LegacyChainedMethodCallsBlockBuilder.$$$reportNull$$$0(6);
        }
        return this.shouldAlignMethod(current = methodCall.get(chunkIndex), methodCall) ? AbstractJavaBlock.createAlignment(this.mySettings.ALIGN_MULTILINE_CHAINED_METHODS, null) : null;
    }

    private static boolean isMethodCall(@NotNull ChainedCallChunk callChunk) {
        List<ASTNode> nodes;
        if (callChunk == null) {
            LegacyChainedMethodCallsBlockBuilder.$$$reportNull$$$0(7);
        }
        return (nodes = callChunk.nodes).size() >= 3 && nodes.get(2).getElementType() == JavaElementType.EXPRESSION_LIST;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingMode";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callChunk";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/formatter/java/LegacyChainedMethodCallsBlockBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/formatter/java/LegacyChainedMethodCallsBlockBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "splitMethodCallOnChunksByDots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createCallChunkWrap";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "chunkIsFirstInChainMethodCall";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "splitMethodCallOnChunksByDots";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCallChunkAlignment";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isMethodCall";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    private record ChainedCallChunk(@NotNull List<ASTNode> nodes) {
        @NotNull
        private final List<ASTNode> nodes;

        private ChainedCallChunk(@NotNull List<ASTNode> nodes) {
            if (nodes == null) {
                ChainedCallChunk.$$$reportNull$$$0(0);
            }
        }

        boolean isEmpty() {
            return this.nodes.isEmpty();
        }

        @NotNull
        public List<ASTNode> nodes() {
            List<ASTNode> list = this.nodes;
            if (list == null) {
                ChainedCallChunk.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/formatter/java/LegacyChainedMethodCallsBlockBuilder$ChainedCallChunk";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/formatter/java/LegacyChainedMethodCallsBlockBuilder$ChainedCallChunk";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "nodes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

