/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 2516577176602L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-273674160 - -2668, 273674160 - 18015, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-273674160 - -2669, -273674160 - -28421, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 63379493665680L;
                thread = Thread.currentThread();
                boolean bl2 = SshAgentIpcService.G();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (bl2) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl3 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-1338748980 - -((char)-25240), -1338748980 - -31651, (int)l2) + string + WindowsNamedPipeAgentIpc.b(-1338748980 - -((char)-25239), -1338748980 - -27163, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-1338748980 - -((char)-25242), 1338748980 - (char)-30137, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        block17: {
            boolean bl;
            block19: {
                block18: {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
                    boolean bl2;
                    long l2;
                    block15: {
                        block16: {
                            l2 = 137102856506075L;
                            Object object = this.lock;
                            synchronized (object) {
                                boolean bl3;
                                bl2 = SshAgentIpcService.G();
                                boolean bl4 = false;
                                try {
                                    bl3 = this.connectionThread == null;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                if (!bl3) {
                                    boolean bl5 = false;
                                    String string = WindowsNamedPipeAgentIpc.b(-1089584910 - -((char)-9338), -1089584910 - -((char)-6365), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1089584910 - -((char)-9335), 1089453840 + (char)-2708, (int)l2) + this.state;
                                    throw new IllegalArgumentException(string.toString());
                                }
                                this.connectionThread = Thread.currentThread();
                                Unit unit = Unit.INSTANCE;
                            }
                            try {
                                try {
                                    WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                                    Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1089584910 - -((char)-9336), -1089453840 + -((char)-2275), (int)l2));
                                    this.hPipe = hANDLE;
                                    windowsNamedPipeAgentIpc = this;
                                    if (bl2) break block15;
                                    if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                                    }
                                    break block16;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-1089584910 - -((char)-9341), -1089584910 - -((char)-5389), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1089584910 - -((char)-9342), 1089584910 - (char)-5428, (int)l2) + ErrorToolsKt.kernel32LastError());
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        this.state = NamedPipeState.Open;
                        windowsNamedPipeAgentIpc = this;
                    }
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
                    boolean bl6 = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1089584910 - -((char)-9339), -1089584910 - -((char)-8907), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1089584910 - -((char)-9341), -1089584910 - -((char)-5389), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1089584910 - -((char)-9340), -1089584910 - -((char)-4258), (int)l2));
                            if (!ActionTimestamp.G()) break block17;
                            if (!bl2) break block18;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = false;
                        break block19;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = true;
            }
            SshAgentIpcService.G(bl);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                boolean bl;
                block6: {
                    long l2 = 96807273374021L;
                    bl = SshAgentIpcService.G();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (bl) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (bl) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        block32: {
            boolean bl;
            block34: {
                block33: {
                    Object object;
                    Object object2;
                    boolean bl2;
                    long l2;
                    block28: {
                        block29: {
                            l2 = 113480217137996L;
                            boolean bl3 = SshAgentIpcService.j();
                            this.assertConnectionThread();
                            Object object3 = this.lock;
                            bl2 = bl3;
                            synchronized (object3) {
                                boolean bl4;
                                NamedPipeState namedPipeState;
                                NamedPipeState namedPipeState2;
                                block26: {
                                    block27: {
                                        boolean bl5 = false;
                                        try {
                                            namedPipeState2 = this.state;
                                            namedPipeState = NamedPipeState.Closing;
                                            if (!bl2) break block26;
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block27;
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                        }
                                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                                        boolean bl6 = false;
                                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1408740360 + -3602, -1408740360 + -17992, (int)l2));
                                        logger.info(WindowsNamedPipeAgentIpc.b(-1408740360 + -3606, -1408740360 - -7802, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1408740360 + -3601, 1408740360 + 12886, (int)l2) + this.state);
                                        throw new ClosedChannelException();
                                    }
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Open;
                                }
                                try {
                                    bl4 = namedPipeState2 == namedPipeState;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                if (!bl4) {
                                    boolean bl7 = false;
                                    String string = WindowsNamedPipeAgentIpc.b(-1408740360 + -3606, -1408740360 - -7802, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1408740360 + -3604, 1408740360 + 20609, (int)l2) + this.state;
                                    throw new IllegalArgumentException(string.toString());
                                }
                                this.state = NamedPipeState.Connecting;
                                Unit unit = Unit.INSTANCE;
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl8 = false;
                            try {
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1408740360 + -3602, -1408740360 + -17992, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1408740360 + -3606, -1408740360 - -7802, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1408740360 + -3603, -1408740360 - -5949, (int)l2));
                                object2 = Kernel32.INSTANCE;
                                if (!bl2) break block28;
                                if (object2.ConnectNamedPipe(this.hPipe, null)) break block29;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            int n2 = Kernel32.INSTANCE.GetLastError();
                            if (n2 == 535) {
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                                boolean bl9 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1408740360 + -3602, -1408740360 + -17992, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1408740360 + -3606, -1408740360 - -7802, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1408740360 + -3582, -1408740360 - -9774, (int)l2));
                            } else {
                                throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-1408740360 + -3606, -1408740360 - -7802, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1408740360 + -3581, 1408740360 + 16247, (int)l2) + ErrorToolsKt.prettyHRESULT(n2)).toString());
                            }
                        }
                        object2 = this.lock;
                    }
                    Kernel32 kernel32 = object2;
                    synchronized (kernel32) {
                        boolean bl10;
                        NamedPipeState namedPipeState;
                        NamedPipeState namedPipeState3;
                        block30: {
                            block31: {
                                boolean bl11 = false;
                                namedPipeState3 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (!bl2) break block30;
                                try {
                                    block35: {
                                        if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block31;
                                        break block35;
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                        }
                                    }
                                    throw new ClosedChannelException();
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                            }
                            namedPipeState3 = this.state;
                            namedPipeState = NamedPipeState.Connecting;
                        }
                        try {
                            bl10 = namedPipeState3 == namedPipeState;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        if (!bl10) {
                            boolean bl12 = false;
                            String string = WindowsNamedPipeAgentIpc.b(-1408740360 + -3606, -1408740360 - -7802, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1408740360 + -3604, 1408740360 + 20609, (int)l2) + this.state;
                            throw new IllegalArgumentException(string.toString());
                        }
                        this.state = NamedPipeState.Connected;
                        object = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                    boolean bl13 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1408740360 + -3602, -1408740360 + -17992, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1408740360 + -3606, -1408740360 - -7802, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1408740360 + -3584, -1408740360 - -448, (int)l2));
                    long l3 = this.getRequesterPid();
                    this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
                    object = new PipeReadableByteChannel(this);
                    PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
                    try {
                        try {
                            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                                final /* synthetic */ PipeReadableByteChannel $read;
                                final /* synthetic */ PipeWritableByteChannel $write;
                                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                                private static final String[] a;
                                private static final String[] b;
                                {
                                    this.$read = $read;
                                    this.$write = $write;
                                    this.this$0 = $receiver;
                                }

                                public InputStream getInputStream() {
                                    long l2 = 123917473153938L;
                                    InputStream inputStream = Channels.newInputStream(this.$read);
                                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(923257080 + 6389, 923257080 - 17419, (int)l2));
                                    return inputStream;
                                }

                                public OutputStream getOutputStream() {
                                    long l2 = 112796472488576L;
                                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-2041415250 - -((char)-10416), 2041415250 - (char)-393, (int)l2));
                                    return outputStream;
                                }

                                public void close() {
                                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                static {
                                    block13: {
                                        var5 = new String[2];
                                        var3_1 = 0;
                                        var2_2 = "PF\u00a7\u0085\f}A\u00cf;\u000e\u00e1Q\u00bc\u0098\u0098fi\u00c4\u00e0\u0014\u00e6\u00a2q\u001f\u00cd\u00ec\u0004x\u0011\u00fea\u009bn8\u0003\u00f9\u00f7\u00f14!";
                                        var4_3 = "PF\u00a7\u0085\f}A\u00cf;\u000e\u00e1Q\u00bc\u0098\u0098fi\u00c4\u00e0\u0014\u00e6\u00a2q\u001f\u00cd\u00ec\u0004x\u0011\u00fea\u009bn8\u0003\u00f9\u00f7\u00f14!".length();
                                        var1_4 = 19;
                                        var0_5 = -1;
lbl7:
                                        // 2 sources

                                        while (true) {
                                            continue;
                                            break;
                                        }
lbl9:
                                        // 1 sources

                                        while (true) {
                                            var5[var3_1++] = new String(v0).intern();
                                            if ((var0_5 += var1_4) < var4_3) {
                                                var1_4 = var2_2.charAt(var0_5);
                                                ** continue;
                                            }
                                            break block13;
                                            break;
                                        }
                                        v1 = ++var0_5;
                                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                                        v3 = v2.length;
                                        var6_6 = 0;
                                        v4 = 125;
                                        v5 = v2;
                                        v6 = v3;
                                        if (v3 > 1) ** GOTO lbl67
                                        do {
                                            v7 = v4;
                                            v5 = v5;
                                            v8 = v5;
                                            v9 = v4;
                                            v10 = var6_6;
                                            while (true) {
                                                switch (var6_6 % 7) {
                                                    case 0: {
                                                        v11 = 53;
                                                        break;
                                                    }
                                                    case 1: {
                                                        v11 = 32;
                                                        break;
                                                    }
                                                    case 2: {
                                                        v11 = 13;
                                                        break;
                                                    }
                                                    case 3: {
                                                        v11 = 27;
                                                        break;
                                                    }
                                                    case 4: {
                                                        v11 = 124;
                                                        break;
                                                    }
                                                    case 5: {
                                                        v11 = 108;
                                                        break;
                                                    }
                                                    default: {
                                                        v11 = 75;
                                                    }
                                                }
                                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                                ++var6_6;
                                                v4 = v7;
                                                if (v7 != 0) break;
                                                v7 = v4;
                                                v5 = v5;
                                                v10 = v4;
                                                v8 = v5;
                                                v9 = v4;
                                            }
lbl67:
                                            // 2 sources

                                            v0 = v5;
                                            v6 = v6;
                                        } while (v6 > var6_6);
                                        ** while (true)
                                    }
                                    accept.3.a = var5;
                                    accept.3.b = new String[2];
                                }

                                private static String a(int n2, int n3, int n4) {
                                    int n5 = (n2 ^ n4 ^ 0xFFFFE27F) & 0xFFFF;
                                    if (b[n5] == null) {
                                        int n6;
                                        char[] cArray = a[n5].toCharArray();
                                        int n7 = switch (cArray[0] & 0xFF) {
                                            case 0 -> 207;
                                            case 1 -> 74;
                                            case 2 -> 223;
                                            case 3 -> 62;
                                            case 4 -> 134;
                                            case 5 -> 225;
                                            case 6 -> 87;
                                            case 7 -> 69;
                                            case 8 -> 137;
                                            case 9 -> 152;
                                            case 10 -> 133;
                                            case 11 -> 4;
                                            case 12 -> 143;
                                            case 13 -> 177;
                                            case 14 -> 251;
                                            case 15 -> 104;
                                            case 16 -> 119;
                                            case 17 -> 174;
                                            case 18 -> 57;
                                            case 19 -> 179;
                                            case 20 -> 194;
                                            case 21 -> 46;
                                            case 22 -> 36;
                                            case 23 -> 231;
                                            case 24 -> 9;
                                            case 25 -> 106;
                                            case 26 -> 76;
                                            case 27 -> 95;
                                            case 28 -> 13;
                                            case 29 -> 100;
                                            case 30 -> 205;
                                            case 31 -> 182;
                                            case 32 -> 48;
                                            case 33 -> 173;
                                            case 34 -> 216;
                                            case 35 -> 115;
                                            case 36 -> 146;
                                            case 37 -> 204;
                                            case 38 -> 199;
                                            case 39 -> 228;
                                            case 40 -> 113;
                                            case 41 -> 53;
                                            case 42 -> 40;
                                            case 43 -> 47;
                                            case 44 -> 38;
                                            case 45 -> 255;
                                            case 46 -> 128;
                                            case 47 -> 22;
                                            case 48 -> 142;
                                            case 49 -> 240;
                                            case 50 -> 210;
                                            case 51 -> 144;
                                            case 52 -> 58;
                                            case 53 -> 139;
                                            case 54 -> 132;
                                            case 55 -> 37;
                                            case 56 -> 56;
                                            case 57 -> 11;
                                            case 58 -> 79;
                                            case 59 -> 16;
                                            case 60 -> 145;
                                            case 61 -> 8;
                                            case 62 -> 162;
                                            case 63 -> 68;
                                            case 64 -> 107;
                                            case 65 -> 1;
                                            case 66 -> 21;
                                            case 67 -> 201;
                                            case 68 -> 18;
                                            case 69 -> 252;
                                            case 70 -> 242;
                                            case 71 -> 186;
                                            case 72 -> 136;
                                            case 73 -> 110;
                                            case 74 -> 215;
                                            case 75 -> 168;
                                            case 76 -> 202;
                                            case 77 -> 83;
                                            case 78 -> 93;
                                            case 79 -> 61;
                                            case 80 -> 124;
                                            case 81 -> 197;
                                            case 82 -> 206;
                                            case 83 -> 71;
                                            case 84 -> 77;
                                            case 85 -> 108;
                                            case 86 -> 72;
                                            case 87 -> 237;
                                            case 88 -> 97;
                                            case 89 -> 129;
                                            case 90 -> 181;
                                            case 91 -> 247;
                                            case 92 -> 148;
                                            case 93 -> 126;
                                            case 94 -> 64;
                                            case 95 -> 234;
                                            case 96 -> 24;
                                            case 97 -> 183;
                                            case 98 -> 43;
                                            case 99 -> 208;
                                            case 100 -> 135;
                                            case 101 -> 3;
                                            case 102 -> 153;
                                            case 103 -> 141;
                                            case 104 -> 35;
                                            case 105 -> 96;
                                            case 106 -> 31;
                                            case 107 -> 166;
                                            case 108 -> 19;
                                            case 109 -> 140;
                                            case 110 -> 111;
                                            case 111 -> 63;
                                            case 112 -> 224;
                                            case 113 -> 249;
                                            case 114 -> 17;
                                            case 115 -> 236;
                                            case 116 -> 25;
                                            case 117 -> 89;
                                            case 118 -> 80;
                                            case 119 -> 39;
                                            case 120 -> 29;
                                            case 121 -> 85;
                                            case 122 -> 127;
                                            case 123 -> 28;
                                            case 124 -> 91;
                                            case 125 -> 84;
                                            case 126 -> 151;
                                            case 127 -> 227;
                                            case 128 -> 54;
                                            case 129 -> 156;
                                            case 130 -> 189;
                                            case 131 -> 170;
                                            case 132 -> 130;
                                            case 133 -> 82;
                                            case 134 -> 94;
                                            case 135 -> 178;
                                            case 136 -> 20;
                                            case 137 -> 220;
                                            case 138 -> 32;
                                            case 139 -> 99;
                                            case 140 -> 73;
                                            case 141 -> 248;
                                            case 142 -> 44;
                                            case 143 -> 10;
                                            case 144 -> 120;
                                            case 145 -> 67;
                                            case 146 -> 105;
                                            case 147 -> 246;
                                            case 148 -> 65;
                                            case 149 -> 34;
                                            case 150 -> 171;
                                            case 151 -> 230;
                                            case 152 -> 167;
                                            case 153 -> 0;
                                            case 154 -> 221;
                                            case 155 -> 229;
                                            case 156 -> 138;
                                            case 157 -> 41;
                                            case 158 -> 114;
                                            case 159 -> 147;
                                            case 160 -> 192;
                                            case 161 -> 250;
                                            case 162 -> 2;
                                            case 163 -> 158;
                                            case 164 -> 211;
                                            case 165 -> 51;
                                            case 166 -> 125;
                                            case 167 -> 233;
                                            case 168 -> 195;
                                            case 169 -> 185;
                                            case 170 -> 27;
                                            case 171 -> 45;
                                            case 172 -> 109;
                                            case 173 -> 6;
                                            case 174 -> 155;
                                            case 175 -> 226;
                                            case 176 -> 253;
                                            case 177 -> 219;
                                            case 178 -> 203;
                                            case 179 -> 198;
                                            case 180 -> 243;
                                            case 181 -> 52;
                                            case 182 -> 176;
                                            case 183 -> 245;
                                            case 184 -> 244;
                                            case 185 -> 66;
                                            case 186 -> 241;
                                            case 187 -> 15;
                                            case 188 -> 164;
                                            case 189 -> 81;
                                            case 190 -> 239;
                                            case 191 -> 165;
                                            case 192 -> 149;
                                            case 193 -> 193;
                                            case 194 -> 161;
                                            case 195 -> 117;
                                            case 196 -> 212;
                                            case 197 -> 98;
                                            case 198 -> 92;
                                            case 199 -> 160;
                                            case 200 -> 157;
                                            case 201 -> 180;
                                            case 202 -> 49;
                                            case 203 -> 70;
                                            case 204 -> 116;
                                            case 205 -> 191;
                                            case 206 -> 131;
                                            case 207 -> 122;
                                            case 208 -> 123;
                                            case 209 -> 59;
                                            case 210 -> 90;
                                            case 211 -> 42;
                                            case 212 -> 14;
                                            case 213 -> 55;
                                            case 214 -> 101;
                                            case 215 -> 169;
                                            case 216 -> 12;
                                            case 217 -> 33;
                                            case 218 -> 187;
                                            case 219 -> 60;
                                            case 220 -> 172;
                                            case 221 -> 5;
                                            case 222 -> 209;
                                            case 223 -> 190;
                                            case 224 -> 23;
                                            case 225 -> 163;
                                            case 226 -> 26;
                                            case 227 -> 88;
                                            case 228 -> 150;
                                            case 229 -> 222;
                                            case 230 -> 238;
                                            case 231 -> 121;
                                            case 232 -> 175;
                                            case 233 -> 112;
                                            case 234 -> 50;
                                            case 235 -> 30;
                                            case 236 -> 213;
                                            case 237 -> 232;
                                            case 238 -> 7;
                                            case 239 -> 118;
                                            case 240 -> 103;
                                            case 241 -> 254;
                                            case 242 -> 159;
                                            case 243 -> 86;
                                            case 244 -> 200;
                                            case 245 -> 78;
                                            case 246 -> 214;
                                            case 247 -> 188;
                                            case 248 -> 154;
                                            case 249 -> 235;
                                            case 250 -> 75;
                                            case 251 -> 102;
                                            case 252 -> 184;
                                            case 253 -> 196;
                                            case 254 -> 217;
                                            default -> 218;
                                        };
                                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                                        if (n8 < 0) {
                                            n8 += 256;
                                        }
                                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                                            n6 += 256;
                                        }
                                        int n9 = 0;
                                        while (n9 < cArray.length) {
                                            int n10 = n9 % 2;
                                            int n11 = n9;
                                            char[] cArray2 = cArray;
                                            char c2 = cArray[n11];
                                            if (n10 == 0) {
                                                cArray2[n11] = (char)(c2 ^ n8);
                                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                                            } else {
                                                cArray2[n11] = (char)(c2 ^ n6);
                                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                                            }
                                            ++n9;
                                        }
                                        accept.3.b[n5] = new String(cArray).intern();
                                    }
                                    return b[n5];
                                }
                            };
                            if (bl2) break block32;
                            if (!ActionTimestamp.G()) break block33;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = false;
                        break block34;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = true;
            }
            ActionTimestamp.G(bl);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 85954619600724L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    boolean bl2 = SshAgentIpcService.j();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (!bl2) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-560848530 + -((char)-6288), -560848530 + -((char)-20538), (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-560848530 + -((char)-6284), -560979600 - -((char)-4870), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-560848530 + -((char)-6259), -560848530 + -((char)-7175), (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-560848530 + -((char)-6288), -560848530 + -((char)-20538), (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-560848530 + -((char)-6284), -560979600 - -((char)-4870), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-560848530 + -((char)-6264), -560848530 + -((char)-8151), (int)l3) + ErrorToolsKt.prettyHRESULT(n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    boolean bl2;
                    block13: {
                        long l2 = 71545886026957L;
                        boolean bl3 = SshAgentIpcService.G();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(320859360 - 29282, -320859360 - -28021, (int)l2));
                        bl2 = bl3;
                        try {
                            try {
                                try {
                                    try {
                                        if (bl2 || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (bl2) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(320859360 - 29283, -320859360 - -((char)-25061), (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (bl2) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        boolean bl;
        long l2;
        block25: {
            block26: {
                l2 = 43926923620264L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl2;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    bl = SshAgentIpcService.G();
                                    boolean bl3 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (bl) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (bl) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl4 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2001832110 + -32336, -2001832110 + -((char)-14850), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-2001832110 + -32332, -2001832110 + -((char)-22340), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2001832110 + -32313, 2001832110 + (char)-24776, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl2 = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl2) {
                        boolean bl5 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-2001832110 + -32332, -2001832110 + -((char)-22340), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2001832110 + -32338, 2001832110 + (char)-18497, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl6 = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2001832110 + -32336, -2001832110 + -((char)-14850), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-2001832110 + -32332, -2001832110 + -((char)-22340), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2001832110 + -32316, -2001832110 + -30624, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (bl) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl6 = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2001832110 + -32336, -2001832110 + -((char)-14850), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-2001832110 + -32332, -2001832110 + -((char)-22340), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2001832110 + -32315, -2001832110 + -31353, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl7 = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (bl) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl8 = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2001832110 + -32336, -2001832110 + -((char)-14850), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-2001832110 + -32332, -2001832110 + -((char)-22340), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2001832110 + -32318, 2001832110 + (char)-14420, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                boolean bl2;
                block16: {
                    l2 = 140050700057673L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                bl2 = SshAgentIpcService.j();
                                boolean bl3 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (!bl2) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl4 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(406448070 + (char)-31971, 406448070 + 15087, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(406448070 + (char)-31967, 406448070 + 30129, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(406448070 + (char)-31954, 406448070 + (char)-30113, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(406448070 + (char)-31955, -406448070 + -18237, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(406448070 + (char)-31971, 406448070 + 15087, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(406448070 + (char)-31967, 406448070 + 30129, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(406448070 + (char)-31956, -406448070 + -30337, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (!bl2) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (!bl2) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl5 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(406448070 + (char)-31971, 406448070 + 15087, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(406448070 + (char)-31967, 406448070 + 30129, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(406448070 + (char)-31957, -406448070 + -30880, (int)l2) + ErrorToolsKt.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(406448070 + (char)-31971, 406448070 + 15087, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(406448070 + (char)-31967, 406448070 + 30129, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(406448070 + (char)-31958, -406448070 + -7369, (int)l2));
                    if (!bl2) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(406448070 + (char)-31971, 406448070 + 15087, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(406448070 + (char)-31967, 406448070 + 30129, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(406448070 + (char)-31991, 406448070 + 25717, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(406448070 + (char)-31992, -406448070 + -28600, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u00d5i\u00c5\u0019\u0000\u00c7\u00d0G\u0014V~\u008d\u001c\u00f7\u00ef\u0081XF\u008f\u00d2J\u00dd>\u00bb\u008e\u00f3\u0014\u00d4N\u0006)\u0082Zd\u0099)\u0018O\u0090\u00ce\u00f1\u001d\u0097\u00de\u0097e\u000b\u00b9\u00aa\u00d6\u00dd\u0088p<\u00a2\u0003\u0005#P\b\u008f\t\u001c4:\u00d4\u00e8\u00acx\u00b8\u008d\u0005u\u0003\u00d1T\u00f2\b\u008c|\u00ee\u00ca7\u009b0.\u0014y6\u0010\u008e)\u00b5o\u0084\u00f5\u00c9\u000f6,\u0012>\u00e6Q\u00cay\u00d7\u0005T\u0093\u00f5Fv\u001e\u00fa\u00985C\u00f3\u0005\u00a1\u00bf/\u001a\u00bb\u000f\u00daI\u00ab\u0086\u00b9\u00eda\u0018\u00c3\u00dc\u0018\u00d3Nd\u001a!\u0097i\u0010\u000br\u00ef\u00db\u00ff$\u00d6b\u00bc\u0013D\u00d3#\u0087;\u00c0\th@bK\u00b0xU\u00bd\u00c6\u0010\u000b$\u00ef\u0011\u00ff}\u00d6I\u00bcvD\u007f#\u0012;r?7i\u0084}\u00c8\u00cbC\n\u0002}[\u0018y]\u00e2=U\u00ff\u0081\u009fQ~1\u00e1{\u00ca\u00b1@\u00d5\u0013L!\u00bd7\u0001\u001c@\u0019n\u0096\u000e\u0087\u0091G\"\u00de\u001e@\u009f\tF~\u00b7&\u0007j\u00a0'5\u008d\u00be\u00d5\u00ee\bf\t\u00b3d\u009cNE\u0094\fbz#\u0011\u0093\u0082J\n\u0006VA\u007fF\u00a5\u00bb\u00db)\u008c\u0085\u00a9\u00eazF\u00c4\u00b9\u001caQ\u009c\u00df\u00ac\u00d0Zi\u00945\u008e\u00cd\f\u0094\u0093\u00ce@\u0015w\u00aaK!\u00b2\u009e\u0081\u001eA\u0093h\u00a9A\u00fb\u009bq\u0095\u0095Ka\u009c\u00bc\u00ecp(\u00d1\u001b\u008d\u00b6\u009a\u00db6\u000b\u001c\u00b4\u000f\u0081\u0087\u00ef\u001f\u00ff\u00db\u0095+\u00e7\b#\u001e\u007f.\u00b1\u0089\u009b\u0084\u0088\u008e\u00a6\u0004\u00ff\u00ef\u00db\u00a2\u00cc\u00b7\u00b58rf\u0087p>\u000bT?\u00e5\u00b9K\u0097Q\u00a8e\u000e'\u0015Ck\u00070\u0010\u00ce\u00d6\u00fe\u00ab$6\u0003\u00d5y\\g\u00c7\u00ad\u000e\u00a3\u00d3)0\u00d6l\u008a\u00d8<\u00c4\u0098\u0083\u00fe.\u0093l\u00cd\u00e8\u00a2\u00f5\tN\u00e9\u001d\u001a\u00d2\u00b8\u0019\u00900\u000b\u00e0)Pd\u00fc\u008c\u008d\u00c7\u00152\u00e4\u009eo\u0007/r\u0085\u0004\u00c1\u00b0|\u00074\u00e8\u0082;\u00c6\u00b8\u008a(n~\u00eb\u00be\u0098\u00d0:\",~\u00f1\u00b5\u00b4\u0088\u00b1\u0089\u00d9\u00c1e\u00b3\u0019o=\u00ddt\u0080+r\u00b4f\u0001\u0094-\u00f9)\u00c4;/\u00b2\u00ce\u000f\u001b\u00c8\u000bAlC\u0001\u0093>\u00c5\u0012\u0093h\u0018\u00b4\"\fw\u00eb\u00be(\u00ba\u00daH@\u00e4V\u00d0`\u00a9\r\u00e0\u00a2h.\u0087\u00fb\u00d7\u00aeQ\u0005\u00f9~\u00f8\reO\u00ea1\u00ae\u000e^t\u00a3\u00d6y\u00b1\u00a3\u00cdj\u000e\u0098\u00ea5=\u001b\u001ae,\u00f1s\u00e0w\u00bb\u00a7G\u00ac\u00c2\u00e3\u000e[\u0002\u00c0\u009e\u00df\u00c5\u00fe\u00ab}x4\u00b1\r\n\u00d1\u00e6\u0091\u0086\u00d0\u00ea\u00d0\u00d0\u00f8H\u0018\u00b8\u00fex\u008f\u00f8\u0093'\u008b\u00b3\u0088\u00ec\u00a4R\u0091\u0091\u00d0\u00ee\u00c5\u00cd\u00d7\u00c4\u00a2a\n)\\\u00b5\u00e1\u00e6i\u00b1\u00f2)E\u00c8\u00f6Us\u001c\u0094\u00e3\u0004T\u00af\u0087\u001b\u00c7[\u000f]\u00f4%k\u0011y\u00d5\u00ffi!\u00ea\u00e6'2\u00a2\u009e\u00a7\tw\u009d\u0081\u00ee\u00c6\u0003\u00cd\u0089h";
                var4_3 = "\u00d5i\u00c5\u0019\u0000\u00c7\u00d0G\u0014V~\u008d\u001c\u00f7\u00ef\u0081XF\u008f\u00d2J\u00dd>\u00bb\u008e\u00f3\u0014\u00d4N\u0006)\u0082Zd\u0099)\u0018O\u0090\u00ce\u00f1\u001d\u0097\u00de\u0097e\u000b\u00b9\u00aa\u00d6\u00dd\u0088p<\u00a2\u0003\u0005#P\b\u008f\t\u001c4:\u00d4\u00e8\u00acx\u00b8\u008d\u0005u\u0003\u00d1T\u00f2\b\u008c|\u00ee\u00ca7\u009b0.\u0014y6\u0010\u008e)\u00b5o\u0084\u00f5\u00c9\u000f6,\u0012>\u00e6Q\u00cay\u00d7\u0005T\u0093\u00f5Fv\u001e\u00fa\u00985C\u00f3\u0005\u00a1\u00bf/\u001a\u00bb\u000f\u00daI\u00ab\u0086\u00b9\u00eda\u0018\u00c3\u00dc\u0018\u00d3Nd\u001a!\u0097i\u0010\u000br\u00ef\u00db\u00ff$\u00d6b\u00bc\u0013D\u00d3#\u0087;\u00c0\th@bK\u00b0xU\u00bd\u00c6\u0010\u000b$\u00ef\u0011\u00ff}\u00d6I\u00bcvD\u007f#\u0012;r?7i\u0084}\u00c8\u00cbC\n\u0002}[\u0018y]\u00e2=U\u00ff\u0081\u009fQ~1\u00e1{\u00ca\u00b1@\u00d5\u0013L!\u00bd7\u0001\u001c@\u0019n\u0096\u000e\u0087\u0091G\"\u00de\u001e@\u009f\tF~\u00b7&\u0007j\u00a0'5\u008d\u00be\u00d5\u00ee\bf\t\u00b3d\u009cNE\u0094\fbz#\u0011\u0093\u0082J\n\u0006VA\u007fF\u00a5\u00bb\u00db)\u008c\u0085\u00a9\u00eazF\u00c4\u00b9\u001caQ\u009c\u00df\u00ac\u00d0Zi\u00945\u008e\u00cd\f\u0094\u0093\u00ce@\u0015w\u00aaK!\u00b2\u009e\u0081\u001eA\u0093h\u00a9A\u00fb\u009bq\u0095\u0095Ka\u009c\u00bc\u00ecp(\u00d1\u001b\u008d\u00b6\u009a\u00db6\u000b\u001c\u00b4\u000f\u0081\u0087\u00ef\u001f\u00ff\u00db\u0095+\u00e7\b#\u001e\u007f.\u00b1\u0089\u009b\u0084\u0088\u008e\u00a6\u0004\u00ff\u00ef\u00db\u00a2\u00cc\u00b7\u00b58rf\u0087p>\u000bT?\u00e5\u00b9K\u0097Q\u00a8e\u000e'\u0015Ck\u00070\u0010\u00ce\u00d6\u00fe\u00ab$6\u0003\u00d5y\\g\u00c7\u00ad\u000e\u00a3\u00d3)0\u00d6l\u008a\u00d8<\u00c4\u0098\u0083\u00fe.\u0093l\u00cd\u00e8\u00a2\u00f5\tN\u00e9\u001d\u001a\u00d2\u00b8\u0019\u00900\u000b\u00e0)Pd\u00fc\u008c\u008d\u00c7\u00152\u00e4\u009eo\u0007/r\u0085\u0004\u00c1\u00b0|\u00074\u00e8\u0082;\u00c6\u00b8\u008a(n~\u00eb\u00be\u0098\u00d0:\",~\u00f1\u00b5\u00b4\u0088\u00b1\u0089\u00d9\u00c1e\u00b3\u0019o=\u00ddt\u0080+r\u00b4f\u0001\u0094-\u00f9)\u00c4;/\u00b2\u00ce\u000f\u001b\u00c8\u000bAlC\u0001\u0093>\u00c5\u0012\u0093h\u0018\u00b4\"\fw\u00eb\u00be(\u00ba\u00daH@\u00e4V\u00d0`\u00a9\r\u00e0\u00a2h.\u0087\u00fb\u00d7\u00aeQ\u0005\u00f9~\u00f8\reO\u00ea1\u00ae\u000e^t\u00a3\u00d6y\u00b1\u00a3\u00cdj\u000e\u0098\u00ea5=\u001b\u001ae,\u00f1s\u00e0w\u00bb\u00a7G\u00ac\u00c2\u00e3\u000e[\u0002\u00c0\u009e\u00df\u00c5\u00fe\u00ab}x4\u00b1\r\n\u00d1\u00e6\u0091\u0086\u00d0\u00ea\u00d0\u00d0\u00f8H\u0018\u00b8\u00fex\u008f\u00f8\u0093'\u008b\u00b3\u0088\u00ec\u00a4R\u0091\u0091\u00d0\u00ee\u00c5\u00cd\u00d7\u00c4\u00a2a\n)\\\u00b5\u00e1\u00e6i\u00b1\u00f2)E\u00c8\u00f6Us\u001c\u0094\u00e3\u0004T\u00af\u0087\u001b\u00c7[\u000f]\u00f4%k\u0011y\u00d5\u00ffi!\u00ea\u00e6'2\u00a2\u009e\u00a7\tw\u009d\u0081\u00ee\u00c6\u0003\u00cd\u0089h".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 125;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "'0e\u00bd\u00121v\u00d2>\\r,\b\u00d8\u0010\u0090\u007f\u00dd{\u00d9?\u00d8\u00c7\u00d9\u008e\u00d9%`j\u0014\b\u00c5\u00ad\u0080\u0018\u0097\u0097\u00bco\u00f8\u001cO\u00efu\u0016\f\u00ad\u00af\u00f4\u00d2";
                    var4_3 = "'0e\u00bd\u00121v\u00d2>\\r,\b\u00d8\u0010\u0090\u007f\u00dd{\u00d9?\u00d8\u00c7\u00d9\u008e\u00d9%`j\u0014\b\u00c5\u00ad\u0080\u0018\u0097\u0097\u00bco\u00f8\u001cO\u00efu\u0016\f\u00ad\u00af\u00f4\u00d2".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 83;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 6;
                            break;
                        }
                        case 1: {
                            v15 = 5;
                            break;
                        }
                        case 2: {
                            v15 = 99;
                            break;
                        }
                        case 3: {
                            v15 = 103;
                            break;
                        }
                        case 4: {
                            v15 = 40;
                            break;
                        }
                        case 5: {
                            v15 = 114;
                            break;
                        }
                        default: {
                            v15 = 41;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x56A6) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 94;
                case 1 -> 190;
                case 2 -> 199;
                case 3 -> 129;
                case 4 -> 226;
                case 5 -> 61;
                case 6 -> 64;
                case 7 -> 120;
                case 8 -> 70;
                case 9 -> 51;
                case 10 -> 177;
                case 11 -> 78;
                case 12 -> 2;
                case 13 -> 162;
                case 14 -> 80;
                case 15 -> 240;
                case 16 -> 32;
                case 17 -> 140;
                case 18 -> 114;
                case 19 -> 98;
                case 20 -> 10;
                case 21 -> 25;
                case 22 -> 127;
                case 23 -> 13;
                case 24 -> 237;
                case 25 -> 86;
                case 26 -> 206;
                case 27 -> 0;
                case 28 -> 125;
                case 29 -> 158;
                case 30 -> 161;
                case 31 -> 207;
                case 32 -> 26;
                case 33 -> 201;
                case 34 -> 145;
                case 35 -> 230;
                case 36 -> 66;
                case 37 -> 211;
                case 38 -> 241;
                case 39 -> 182;
                case 40 -> 56;
                case 41 -> 19;
                case 42 -> 153;
                case 43 -> 184;
                case 44 -> 233;
                case 45 -> 235;
                case 46 -> 110;
                case 47 -> 223;
                case 48 -> 62;
                case 49 -> 22;
                case 50 -> 217;
                case 51 -> 178;
                case 52 -> 99;
                case 53 -> 196;
                case 54 -> 59;
                case 55 -> 208;
                case 56 -> 31;
                case 57 -> 105;
                case 58 -> 133;
                case 59 -> 118;
                case 60 -> 204;
                case 61 -> 166;
                case 62 -> 122;
                case 63 -> 75;
                case 64 -> 47;
                case 65 -> 238;
                case 66 -> 21;
                case 67 -> 28;
                case 68 -> 150;
                case 69 -> 74;
                case 70 -> 227;
                case 71 -> 11;
                case 72 -> 236;
                case 73 -> 77;
                case 74 -> 246;
                case 75 -> 160;
                case 76 -> 156;
                case 77 -> 92;
                case 78 -> 44;
                case 79 -> 186;
                case 80 -> 225;
                case 81 -> 37;
                case 82 -> 221;
                case 83 -> 169;
                case 84 -> 52;
                case 85 -> 95;
                case 86 -> 111;
                case 87 -> 253;
                case 88 -> 193;
                case 89 -> 194;
                case 90 -> 3;
                case 91 -> 60;
                case 92 -> 53;
                case 93 -> 183;
                case 94 -> 189;
                case 95 -> 63;
                case 96 -> 192;
                case 97 -> 17;
                case 98 -> 116;
                case 99 -> 142;
                case 100 -> 71;
                case 101 -> 33;
                case 102 -> 9;
                case 103 -> 50;
                case 104 -> 147;
                case 105 -> 76;
                case 106 -> 171;
                case 107 -> 108;
                case 108 -> 29;
                case 109 -> 151;
                case 110 -> 135;
                case 111 -> 8;
                case 112 -> 229;
                case 113 -> 57;
                case 114 -> 42;
                case 115 -> 188;
                case 116 -> 180;
                case 117 -> 224;
                case 118 -> 167;
                case 119 -> 36;
                case 120 -> 210;
                case 121 -> 82;
                case 122 -> 91;
                case 123 -> 103;
                case 124 -> 27;
                case 125 -> 1;
                case 126 -> 187;
                case 127 -> 121;
                case 128 -> 119;
                case 129 -> 222;
                case 130 -> 139;
                case 131 -> 39;
                case 132 -> 117;
                case 133 -> 104;
                case 134 -> 132;
                case 135 -> 200;
                case 136 -> 88;
                case 137 -> 41;
                case 138 -> 205;
                case 139 -> 43;
                case 140 -> 144;
                case 141 -> 250;
                case 142 -> 130;
                case 143 -> 128;
                case 144 -> 4;
                case 145 -> 12;
                case 146 -> 164;
                case 147 -> 202;
                case 148 -> 45;
                case 149 -> 228;
                case 150 -> 163;
                case 151 -> 243;
                case 152 -> 157;
                case 153 -> 203;
                case 154 -> 141;
                case 155 -> 191;
                case 156 -> 209;
                case 157 -> 115;
                case 158 -> 97;
                case 159 -> 85;
                case 160 -> 168;
                case 161 -> 219;
                case 162 -> 68;
                case 163 -> 40;
                case 164 -> 89;
                case 165 -> 148;
                case 166 -> 181;
                case 167 -> 212;
                case 168 -> 170;
                case 169 -> 79;
                case 170 -> 46;
                case 171 -> 245;
                case 172 -> 232;
                case 173 -> 83;
                case 174 -> 109;
                case 175 -> 254;
                case 176 -> 249;
                case 177 -> 112;
                case 178 -> 146;
                case 179 -> 20;
                case 180 -> 38;
                case 181 -> 234;
                case 182 -> 165;
                case 183 -> 90;
                case 184 -> 143;
                case 185 -> 155;
                case 186 -> 24;
                case 187 -> 72;
                case 188 -> 131;
                case 189 -> 252;
                case 190 -> 96;
                case 191 -> 100;
                case 192 -> 149;
                case 193 -> 106;
                case 194 -> 123;
                case 195 -> 247;
                case 196 -> 176;
                case 197 -> 159;
                case 198 -> 58;
                case 199 -> 231;
                case 200 -> 49;
                case 201 -> 7;
                case 202 -> 138;
                case 203 -> 137;
                case 204 -> 18;
                case 205 -> 54;
                case 206 -> 136;
                case 207 -> 5;
                case 208 -> 173;
                case 209 -> 213;
                case 210 -> 172;
                case 211 -> 81;
                case 212 -> 124;
                case 213 -> 179;
                case 214 -> 244;
                case 215 -> 197;
                case 216 -> 152;
                case 217 -> 154;
                case 218 -> 174;
                case 219 -> 65;
                case 220 -> 102;
                case 221 -> 23;
                case 222 -> 134;
                case 223 -> 113;
                case 224 -> 248;
                case 225 -> 251;
                case 226 -> 34;
                case 227 -> 93;
                case 228 -> 84;
                case 229 -> 48;
                case 230 -> 242;
                case 231 -> 73;
                case 232 -> 14;
                case 233 -> 55;
                case 234 -> 15;
                case 235 -> 195;
                case 236 -> 215;
                case 237 -> 35;
                case 238 -> 67;
                case 239 -> 220;
                case 240 -> 198;
                case 241 -> 87;
                case 242 -> 30;
                case 243 -> 101;
                case 244 -> 6;
                case 245 -> 126;
                case 246 -> 175;
                case 247 -> 218;
                case 248 -> 239;
                case 249 -> 69;
                case 250 -> 214;
                case 251 -> 216;
                case 252 -> 185;
                case 253 -> 255;
                case 254 -> 107;
                default -> 16;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 18676301554770L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1783731630 - 4042, 1783731630 - 4582, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        boolean bl2;
                        block4: {
                            l2 = 16399919466799L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            bl2 = SshAgentIpcService.G();
                            try {
                                hANDLE2 = hANDLE;
                                if (bl2) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (bl2) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl3 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1734318240 + 4088, 1734318240 + 15057, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1734318240 + 4091, -1734318240 + -8463, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1734318240 + 4090, 1734318240 + 14720, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00a0\u00b2j\u00b4\u00b2\u001ed*\u0010\u0098j\u009c\u000e\u00d6\u00f2\u0011\u00ee\u0081\u00835\u0086a\u00cf%\f";
                    var4_3 = "\u00a0\u00b2j\u00b4\u00b2\u001ed*\u0010\u0098j\u009c\u000e\u00d6\u00f2\u0011\u00ee\u0081\u00835\u0086a\u00cf%\f".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 4;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00a2\u009e>%\\5\u0016L\u00bf\u0013\u00be|\u0010\u0080\u00c2\u00e1\u00db\u001e_\"\u00f3/|\u00b6`_\u0087\u00a1\u0096[,a<\u00e9\u00b6\u00c7\u00e4>\u0007\u0010\u00a4\u00fb\u00e0\u00da\u00fc\u00d6\u0094V\u0017D\u00b2\u0097\u00ad\u0083\u00ab\u00c5\u0002\u00d7\u00b8";
                        var4_3 = "\u00a2\u009e>%\\5\u0016L\u00bf\u0013\u00be|\u0010\u0080\u00c2\u00e1\u00db\u001e_\"\u00f3/|\u00b6`_\u0087\u00a1\u0096[,a<\u00e9\u00b6\u00c7\u00e4>\u0007\u0010\u00a4\u00fb\u00e0\u00da\u00fc\u00d6\u0094V\u0017D\u00b2\u0097\u00ad\u0083\u00ab\u00c5\u0002\u00d7\u00b8".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 127;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 109;
                                break;
                            }
                            case 1: {
                                v15 = 89;
                                break;
                            }
                            case 2: {
                                v15 = 89;
                                break;
                            }
                            case 3: {
                                v15 = 108;
                                break;
                            }
                            case 4: {
                                v15 = 126;
                                break;
                            }
                            case 5: {
                                v15 = 41;
                                break;
                            }
                            default: {
                                v15 = 87;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x61B6) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 104;
                    case 1 -> 81;
                    case 2 -> 5;
                    case 3 -> 19;
                    case 4 -> 209;
                    case 5 -> 7;
                    case 6 -> 126;
                    case 7 -> 67;
                    case 8 -> 125;
                    case 9 -> 193;
                    case 10 -> 254;
                    case 11 -> 136;
                    case 12 -> 160;
                    case 13 -> 92;
                    case 14 -> 82;
                    case 15 -> 217;
                    case 16 -> 33;
                    case 17 -> 198;
                    case 18 -> 187;
                    case 19 -> 223;
                    case 20 -> 115;
                    case 21 -> 3;
                    case 22 -> 25;
                    case 23 -> 72;
                    case 24 -> 249;
                    case 25 -> 64;
                    case 26 -> 11;
                    case 27 -> 128;
                    case 28 -> 4;
                    case 29 -> 236;
                    case 30 -> 34;
                    case 31 -> 176;
                    case 32 -> 253;
                    case 33 -> 154;
                    case 34 -> 10;
                    case 35 -> 250;
                    case 36 -> 177;
                    case 37 -> 14;
                    case 38 -> 226;
                    case 39 -> 175;
                    case 40 -> 192;
                    case 41 -> 30;
                    case 42 -> 54;
                    case 43 -> 120;
                    case 44 -> 1;
                    case 45 -> 86;
                    case 46 -> 48;
                    case 47 -> 238;
                    case 48 -> 155;
                    case 49 -> 169;
                    case 50 -> 161;
                    case 51 -> 17;
                    case 52 -> 55;
                    case 53 -> 102;
                    case 54 -> 149;
                    case 55 -> 186;
                    case 56 -> 242;
                    case 57 -> 137;
                    case 58 -> 76;
                    case 59 -> 159;
                    case 60 -> 46;
                    case 61 -> 132;
                    case 62 -> 13;
                    case 63 -> 51;
                    case 64 -> 215;
                    case 65 -> 232;
                    case 66 -> 140;
                    case 67 -> 57;
                    case 68 -> 24;
                    case 69 -> 0;
                    case 70 -> 227;
                    case 71 -> 185;
                    case 72 -> 8;
                    case 73 -> 218;
                    case 74 -> 106;
                    case 75 -> 204;
                    case 76 -> 147;
                    case 77 -> 197;
                    case 78 -> 224;
                    case 79 -> 163;
                    case 80 -> 172;
                    case 81 -> 118;
                    case 82 -> 97;
                    case 83 -> 130;
                    case 84 -> 49;
                    case 85 -> 70;
                    case 86 -> 99;
                    case 87 -> 40;
                    case 88 -> 108;
                    case 89 -> 195;
                    case 90 -> 105;
                    case 91 -> 78;
                    case 92 -> 56;
                    case 93 -> 189;
                    case 94 -> 37;
                    case 95 -> 231;
                    case 96 -> 157;
                    case 97 -> 235;
                    case 98 -> 228;
                    case 99 -> 146;
                    case 100 -> 87;
                    case 101 -> 103;
                    case 102 -> 194;
                    case 103 -> 211;
                    case 104 -> 63;
                    case 105 -> 143;
                    case 106 -> 246;
                    case 107 -> 142;
                    case 108 -> 80;
                    case 109 -> 151;
                    case 110 -> 121;
                    case 111 -> 240;
                    case 112 -> 45;
                    case 113 -> 23;
                    case 114 -> 79;
                    case 115 -> 109;
                    case 116 -> 9;
                    case 117 -> 58;
                    case 118 -> 20;
                    case 119 -> 38;
                    case 120 -> 245;
                    case 121 -> 135;
                    case 122 -> 74;
                    case 123 -> 83;
                    case 124 -> 212;
                    case 125 -> 237;
                    case 126 -> 210;
                    case 127 -> 60;
                    case 128 -> 39;
                    case 129 -> 61;
                    case 130 -> 207;
                    case 131 -> 241;
                    case 132 -> 29;
                    case 133 -> 98;
                    case 134 -> 112;
                    case 135 -> 95;
                    case 136 -> 107;
                    case 137 -> 170;
                    case 138 -> 52;
                    case 139 -> 182;
                    case 140 -> 36;
                    case 141 -> 93;
                    case 142 -> 69;
                    case 143 -> 248;
                    case 144 -> 90;
                    case 145 -> 101;
                    case 146 -> 145;
                    case 147 -> 88;
                    case 148 -> 138;
                    case 149 -> 65;
                    case 150 -> 124;
                    case 151 -> 26;
                    case 152 -> 133;
                    case 153 -> 162;
                    case 154 -> 252;
                    case 155 -> 196;
                    case 156 -> 68;
                    case 157 -> 156;
                    case 158 -> 129;
                    case 159 -> 234;
                    case 160 -> 84;
                    case 161 -> 28;
                    case 162 -> 179;
                    case 163 -> 216;
                    case 164 -> 134;
                    case 165 -> 153;
                    case 166 -> 12;
                    case 167 -> 205;
                    case 168 -> 53;
                    case 169 -> 139;
                    case 170 -> 208;
                    case 171 -> 221;
                    case 172 -> 35;
                    case 173 -> 31;
                    case 174 -> 22;
                    case 175 -> 32;
                    case 176 -> 190;
                    case 177 -> 203;
                    case 178 -> 183;
                    case 179 -> 158;
                    case 180 -> 191;
                    case 181 -> 2;
                    case 182 -> 75;
                    case 183 -> 114;
                    case 184 -> 164;
                    case 185 -> 167;
                    case 186 -> 180;
                    case 187 -> 188;
                    case 188 -> 131;
                    case 189 -> 41;
                    case 190 -> 89;
                    case 191 -> 148;
                    case 192 -> 16;
                    case 193 -> 233;
                    case 194 -> 113;
                    case 195 -> 239;
                    case 196 -> 255;
                    case 197 -> 206;
                    case 198 -> 247;
                    case 199 -> 174;
                    case 200 -> 220;
                    case 201 -> 225;
                    case 202 -> 202;
                    case 203 -> 73;
                    case 204 -> 244;
                    case 205 -> 219;
                    case 206 -> 27;
                    case 207 -> 243;
                    case 208 -> 62;
                    case 209 -> 44;
                    case 210 -> 15;
                    case 211 -> 199;
                    case 212 -> 201;
                    case 213 -> 116;
                    case 214 -> 122;
                    case 215 -> 144;
                    case 216 -> 184;
                    case 217 -> 173;
                    case 218 -> 123;
                    case 219 -> 150;
                    case 220 -> 111;
                    case 221 -> 6;
                    case 222 -> 94;
                    case 223 -> 213;
                    case 224 -> 119;
                    case 225 -> 127;
                    case 226 -> 166;
                    case 227 -> 71;
                    case 228 -> 178;
                    case 229 -> 165;
                    case 230 -> 152;
                    case 231 -> 18;
                    case 232 -> 47;
                    case 233 -> 85;
                    case 234 -> 251;
                    case 235 -> 100;
                    case 236 -> 21;
                    case 237 -> 214;
                    case 238 -> 141;
                    case 239 -> 50;
                    case 240 -> 229;
                    case 241 -> 200;
                    case 242 -> 222;
                    case 243 -> 91;
                    case 244 -> 77;
                    case 245 -> 171;
                    case 246 -> 117;
                    case 247 -> 42;
                    case 248 -> 168;
                    case 249 -> 110;
                    case 250 -> 43;
                    case 251 -> 96;
                    case 252 -> 181;
                    case 253 -> 59;
                    case 254 -> 230;
                    default -> 66;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 120155847440093L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "3\u0000\u0000w\u0002s{j\t4\n\u0013}O1fvL";
                    var5_4 = "3\u0000\u0000w\u0002s{j\t4\n\u0013}O1fvL".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 66;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 26;
                                    break;
                                }
                                case 1: {
                                    v11 = 39;
                                    break;
                                }
                                case 2: {
                                    v11 = 48;
                                    break;
                                }
                                case 3: {
                                    v11 = 91;
                                    break;
                                }
                                case 4: {
                                    v11 = 37;
                                    break;
                                }
                                case 5: {
                                    v11 = 93;
                                    break;
                                }
                                default: {
                                    v11 = 10;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 139747820987251L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "l#\u0007jU;u\u0004j=\u000bp\nf\"\u0000pY9mL#\t\tf\"\u0000pY9m@)\ra$\u001d}S4w@.\u001awR=";
                    var5_4 = "l#\u0007jU;u\u0004j=\u000bp\nf\"\u0000pY9mL#\t\tf\"\u0000pY9m@)\ra$\u001d}S4w@.\u001awR=".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 26;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "C\u0004$Hp\u0011[\u0006C\u0004$H|\u001b";
                        var5_4 = "C\u0004$Hp\u0011[\u0006C\u0004$H|\u001b".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 63;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 63;
                                break;
                            }
                            case 1: {
                                v15 = 87;
                                break;
                            }
                            case 2: {
                                v15 = 116;
                                break;
                            }
                            case 3: {
                                v15 = 4;
                                break;
                            }
                            case 4: {
                                v15 = 38;
                                break;
                            }
                            case 5: {
                                v15 = 64;
                                break;
                            }
                            default: {
                                v15 = 3;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 17136135858151L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(783667530 - 6811, -783667530 - -19639, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 32019709460924L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00fd\u0004B\u00c7\u00d8\u0003y\u00cdf\u0005\u0001Y\u00fb\u00a8\f\rkR\u0080\u0083\u0096X\u00ab\u00a8\u0003j\u00e7\nS\u0010\u001a\u00bfi\u00d5\u0094\u0007\u00c0~\u00a74\u0090\u008c[\u0017L\u000b\u0005~\u0096\u0014Q\u00f13\u00a5\u00da~\u00af\u00a3\f\u0016\u000b\u0000g\u00ef\u00cfr.E3+[\u0015x\u0003yhyMRcT\u00d9\u00cc\u0087wB\u0005a\b\u00aaWp\u0085\u0002\u00eb\u00ee\u00c9M!\u00d4\u00e5\u0080\u0003\u009f";
                    var4_3 = "\u00fd\u0004B\u00c7\u00d8\u0003y\u00cdf\u0005\u0001Y\u00fb\u00a8\f\rkR\u0080\u0083\u0096X\u00ab\u00a8\u0003j\u00e7\nS\u0010\u001a\u00bfi\u00d5\u0094\u0007\u00c0~\u00a74\u0090\u008c[\u0017L\u000b\u0005~\u0096\u0014Q\u00f13\u00a5\u00da~\u00af\u00a3\f\u0016\u000b\u0000g\u00ef\u00cfr.E3+[\u0015x\u0003yhyMRcT\u00d9\u00cc\u0087wB\u0005a\b\u00aaWp\u0085\u0002\u00eb\u00ee\u00c9M!\u00d4\u00e5\u0080\u0003\u009f".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 29;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00a4@\u00e4p\u007f\u00e9\u00e7\u00f9\u0019\u009e\u001d\u0083\u00b0\u00ack&L?\u00d3`\u00c8\u00c56\u00del\u00b7\u00bfd\u001e\u0091\u0091\u00dc\u00f8G\u00a9=\u008a4\u0019\u00fe\u008d\u00e6}i-8\u00f0\u000e\u00c59\u00e7%\u0012J\u0090\fA\u00e1\u00d4\u0007\t?\u00bd\u000b\u0014\u00d3SGzU\u009e\u001c\u00ae\u00e5\u00e8\u00ac\u00a0X\u00b0\u00bb1[\r\u00f06io\u0095\u00f7\u0081w\u00e8\u00c6";
                        var4_3 = "\u00a4@\u00e4p\u007f\u00e9\u00e7\u00f9\u0019\u009e\u001d\u0083\u00b0\u00ack&L?\u00d3`\u00c8\u00c56\u00del\u00b7\u00bfd\u001e\u0091\u0091\u00dc\u00f8G\u00a9=\u008a4\u0019\u00fe\u008d\u00e6}i-8\u00f0\u000e\u00c59\u00e7%\u0012J\u0090\fA\u00e1\u00d4\u0007\t?\u00bd\u000b\u0014\u00d3SGzU\u009e\u001c\u00ae\u00e5\u00e8\u00ac\u00a0X\u00b0\u00bb1[\r\u00f06io\u0095\u00f7\u0081w\u00e8\u00c6".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 77;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 51;
                                break;
                            }
                            case 1: {
                                v15 = 58;
                                break;
                            }
                            case 2: {
                                v15 = 13;
                                break;
                            }
                            case 3: {
                                v15 = 91;
                                break;
                            }
                            case 4: {
                                v15 = 50;
                                break;
                            }
                            case 5: {
                                v15 = 123;
                                break;
                            }
                            default: {
                                v15 = 125;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFD148) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 18;
                    case 1 -> 170;
                    case 2 -> 204;
                    case 3 -> 220;
                    case 4 -> 115;
                    case 5 -> 35;
                    case 6 -> 120;
                    case 7 -> 160;
                    case 8 -> 42;
                    case 9 -> 31;
                    case 10 -> 206;
                    case 11 -> 137;
                    case 12 -> 53;
                    case 13 -> 201;
                    case 14 -> 221;
                    case 15 -> 96;
                    case 16 -> 70;
                    case 17 -> 98;
                    case 18 -> 74;
                    case 19 -> 92;
                    case 20 -> 8;
                    case 21 -> 226;
                    case 22 -> 195;
                    case 23 -> 189;
                    case 24 -> 64;
                    case 25 -> 150;
                    case 26 -> 9;
                    case 27 -> 59;
                    case 28 -> 54;
                    case 29 -> 43;
                    case 30 -> 215;
                    case 31 -> 196;
                    case 32 -> 135;
                    case 33 -> 237;
                    case 34 -> 248;
                    case 35 -> 52;
                    case 36 -> 223;
                    case 37 -> 153;
                    case 38 -> 44;
                    case 39 -> 154;
                    case 40 -> 166;
                    case 41 -> 230;
                    case 42 -> 169;
                    case 43 -> 240;
                    case 44 -> 99;
                    case 45 -> 49;
                    case 46 -> 190;
                    case 47 -> 113;
                    case 48 -> 10;
                    case 49 -> 187;
                    case 50 -> 71;
                    case 51 -> 22;
                    case 52 -> 121;
                    case 53 -> 32;
                    case 54 -> 194;
                    case 55 -> 87;
                    case 56 -> 123;
                    case 57 -> 193;
                    case 58 -> 146;
                    case 59 -> 241;
                    case 60 -> 17;
                    case 61 -> 7;
                    case 62 -> 5;
                    case 63 -> 138;
                    case 64 -> 116;
                    case 65 -> 79;
                    case 66 -> 168;
                    case 67 -> 95;
                    case 68 -> 159;
                    case 69 -> 26;
                    case 70 -> 175;
                    case 71 -> 69;
                    case 72 -> 202;
                    case 73 -> 134;
                    case 74 -> 161;
                    case 75 -> 65;
                    case 76 -> 238;
                    case 77 -> 83;
                    case 78 -> 155;
                    case 79 -> 105;
                    case 80 -> 218;
                    case 81 -> 224;
                    case 82 -> 235;
                    case 83 -> 164;
                    case 84 -> 234;
                    case 85 -> 225;
                    case 86 -> 100;
                    case 87 -> 90;
                    case 88 -> 45;
                    case 89 -> 145;
                    case 90 -> 0;
                    case 91 -> 46;
                    case 92 -> 12;
                    case 93 -> 228;
                    case 94 -> 252;
                    case 95 -> 129;
                    case 96 -> 37;
                    case 97 -> 163;
                    case 98 -> 68;
                    case 99 -> 243;
                    case 100 -> 61;
                    case 101 -> 38;
                    case 102 -> 80;
                    case 103 -> 6;
                    case 104 -> 242;
                    case 105 -> 108;
                    case 106 -> 117;
                    case 107 -> 40;
                    case 108 -> 86;
                    case 109 -> 51;
                    case 110 -> 29;
                    case 111 -> 151;
                    case 112 -> 253;
                    case 113 -> 125;
                    case 114 -> 114;
                    case 115 -> 247;
                    case 116 -> 217;
                    case 117 -> 76;
                    case 118 -> 174;
                    case 119 -> 152;
                    case 120 -> 231;
                    case 121 -> 182;
                    case 122 -> 162;
                    case 123 -> 239;
                    case 124 -> 111;
                    case 125 -> 255;
                    case 126 -> 119;
                    case 127 -> 213;
                    case 128 -> 102;
                    case 129 -> 184;
                    case 130 -> 133;
                    case 131 -> 203;
                    case 132 -> 33;
                    case 133 -> 181;
                    case 134 -> 118;
                    case 135 -> 144;
                    case 136 -> 127;
                    case 137 -> 107;
                    case 138 -> 104;
                    case 139 -> 75;
                    case 140 -> 219;
                    case 141 -> 149;
                    case 142 -> 212;
                    case 143 -> 185;
                    case 144 -> 91;
                    case 145 -> 73;
                    case 146 -> 165;
                    case 147 -> 180;
                    case 148 -> 249;
                    case 149 -> 222;
                    case 150 -> 158;
                    case 151 -> 66;
                    case 152 -> 16;
                    case 153 -> 147;
                    case 154 -> 179;
                    case 155 -> 11;
                    case 156 -> 13;
                    case 157 -> 39;
                    case 158 -> 81;
                    case 159 -> 27;
                    case 160 -> 62;
                    case 161 -> 188;
                    case 162 -> 94;
                    case 163 -> 136;
                    case 164 -> 112;
                    case 165 -> 176;
                    case 166 -> 200;
                    case 167 -> 130;
                    case 168 -> 250;
                    case 169 -> 21;
                    case 170 -> 23;
                    case 171 -> 3;
                    case 172 -> 97;
                    case 173 -> 36;
                    case 174 -> 72;
                    case 175 -> 198;
                    case 176 -> 41;
                    case 177 -> 205;
                    case 178 -> 197;
                    case 179 -> 109;
                    case 180 -> 89;
                    case 181 -> 227;
                    case 182 -> 67;
                    case 183 -> 148;
                    case 184 -> 2;
                    case 185 -> 191;
                    case 186 -> 48;
                    case 187 -> 173;
                    case 188 -> 82;
                    case 189 -> 167;
                    case 190 -> 211;
                    case 191 -> 192;
                    case 192 -> 254;
                    case 193 -> 246;
                    case 194 -> 157;
                    case 195 -> 183;
                    case 196 -> 124;
                    case 197 -> 172;
                    case 198 -> 60;
                    case 199 -> 208;
                    case 200 -> 14;
                    case 201 -> 78;
                    case 202 -> 132;
                    case 203 -> 103;
                    case 204 -> 28;
                    case 205 -> 126;
                    case 206 -> 1;
                    case 207 -> 58;
                    case 208 -> 244;
                    case 209 -> 63;
                    case 210 -> 24;
                    case 211 -> 216;
                    case 212 -> 140;
                    case 213 -> 4;
                    case 214 -> 156;
                    case 215 -> 177;
                    case 216 -> 85;
                    case 217 -> 110;
                    case 218 -> 88;
                    case 219 -> 34;
                    case 220 -> 232;
                    case 221 -> 131;
                    case 222 -> 233;
                    case 223 -> 141;
                    case 224 -> 251;
                    case 225 -> 30;
                    case 226 -> 245;
                    case 227 -> 171;
                    case 228 -> 142;
                    case 229 -> 178;
                    case 230 -> 101;
                    case 231 -> 186;
                    case 232 -> 50;
                    case 233 -> 56;
                    case 234 -> 25;
                    case 235 -> 143;
                    case 236 -> 47;
                    case 237 -> 229;
                    case 238 -> 122;
                    case 239 -> 55;
                    case 240 -> 106;
                    case 241 -> 15;
                    case 242 -> 207;
                    case 243 -> 84;
                    case 244 -> 93;
                    case 245 -> 199;
                    case 246 -> 128;
                    case 247 -> 20;
                    case 248 -> 209;
                    case 249 -> 77;
                    case 250 -> 57;
                    case 251 -> 214;
                    case 252 -> 139;
                    case 253 -> 236;
                    case 254 -> 19;
                    default -> 210;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 135540431072994L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-146798400 + -((char)-6893), -146798400 + -((char)-22485), (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 114278423017026L;
                    boolean bl = SshAgentIpcService.j();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-2066842830 - -((char)-16422), -2066842830 - -((char)-8480), (int)l2));
                    boolean bl2 = bl;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (!bl2) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 88827596915326L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00ae\u008c\u00d4\u00c7t\u0003\u00fb\u009b(";
                var4_3 = "\u00ae\u008c\u00d4\u00c7t\u0003\u00fb\u009b(".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 15;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 29;
                                break;
                            }
                            case 1: {
                                v11 = 80;
                                break;
                            }
                            case 2: {
                                v11 = 100;
                                break;
                            }
                            case 3: {
                                v11 = 87;
                                break;
                            }
                            case 4: {
                                v11 = 49;
                                break;
                            }
                            case 5: {
                                v11 = 28;
                                break;
                            }
                            default: {
                                v11 = 7;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xD4F) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 41;
                    case 1 -> 136;
                    case 2 -> 217;
                    case 3 -> 189;
                    case 4 -> 244;
                    case 5 -> 53;
                    case 6 -> 66;
                    case 7 -> 59;
                    case 8 -> 103;
                    case 9 -> 213;
                    case 10 -> 248;
                    case 11 -> 191;
                    case 12 -> 108;
                    case 13 -> 32;
                    case 14 -> 186;
                    case 15 -> 112;
                    case 16 -> 11;
                    case 17 -> 183;
                    case 18 -> 48;
                    case 19 -> 104;
                    case 20 -> 179;
                    case 21 -> 40;
                    case 22 -> 14;
                    case 23 -> 128;
                    case 24 -> 201;
                    case 25 -> 163;
                    case 26 -> 200;
                    case 27 -> 212;
                    case 28 -> 57;
                    case 29 -> 233;
                    case 30 -> 226;
                    case 31 -> 215;
                    case 32 -> 222;
                    case 33 -> 138;
                    case 34 -> 47;
                    case 35 -> 39;
                    case 36 -> 253;
                    case 37 -> 75;
                    case 38 -> 81;
                    case 39 -> 58;
                    case 40 -> 185;
                    case 41 -> 109;
                    case 42 -> 130;
                    case 43 -> 164;
                    case 44 -> 91;
                    case 45 -> 209;
                    case 46 -> 147;
                    case 47 -> 155;
                    case 48 -> 145;
                    case 49 -> 106;
                    case 50 -> 105;
                    case 51 -> 73;
                    case 52 -> 173;
                    case 53 -> 1;
                    case 54 -> 68;
                    case 55 -> 221;
                    case 56 -> 118;
                    case 57 -> 86;
                    case 58 -> 188;
                    case 59 -> 172;
                    case 60 -> 219;
                    case 61 -> 76;
                    case 62 -> 4;
                    case 63 -> 52;
                    case 64 -> 239;
                    case 65 -> 140;
                    case 66 -> 89;
                    case 67 -> 43;
                    case 68 -> 159;
                    case 69 -> 35;
                    case 70 -> 243;
                    case 71 -> 26;
                    case 72 -> 84;
                    case 73 -> 8;
                    case 74 -> 204;
                    case 75 -> 142;
                    case 76 -> 236;
                    case 77 -> 19;
                    case 78 -> 122;
                    case 79 -> 121;
                    case 80 -> 249;
                    case 81 -> 64;
                    case 82 -> 65;
                    case 83 -> 246;
                    case 84 -> 232;
                    case 85 -> 97;
                    case 86 -> 80;
                    case 87 -> 254;
                    case 88 -> 20;
                    case 89 -> 21;
                    case 90 -> 10;
                    case 91 -> 251;
                    case 92 -> 25;
                    case 93 -> 87;
                    case 94 -> 124;
                    case 95 -> 23;
                    case 96 -> 27;
                    case 97 -> 190;
                    case 98 -> 231;
                    case 99 -> 180;
                    case 100 -> 169;
                    case 101 -> 224;
                    case 102 -> 167;
                    case 103 -> 165;
                    case 104 -> 95;
                    case 105 -> 216;
                    case 106 -> 156;
                    case 107 -> 177;
                    case 108 -> 107;
                    case 109 -> 17;
                    case 110 -> 49;
                    case 111 -> 223;
                    case 112 -> 36;
                    case 113 -> 29;
                    case 114 -> 227;
                    case 115 -> 192;
                    case 116 -> 38;
                    case 117 -> 158;
                    case 118 -> 230;
                    case 119 -> 166;
                    case 120 -> 202;
                    case 121 -> 24;
                    case 122 -> 151;
                    case 123 -> 102;
                    case 124 -> 79;
                    case 125 -> 131;
                    case 126 -> 113;
                    case 127 -> 198;
                    case 128 -> 129;
                    case 129 -> 220;
                    case 130 -> 146;
                    case 131 -> 175;
                    case 132 -> 250;
                    case 133 -> 181;
                    case 134 -> 196;
                    case 135 -> 62;
                    case 136 -> 242;
                    case 137 -> 161;
                    case 138 -> 90;
                    case 139 -> 78;
                    case 140 -> 46;
                    case 141 -> 88;
                    case 142 -> 194;
                    case 143 -> 98;
                    case 144 -> 85;
                    case 145 -> 238;
                    case 146 -> 162;
                    case 147 -> 5;
                    case 148 -> 6;
                    case 149 -> 111;
                    case 150 -> 229;
                    case 151 -> 143;
                    case 152 -> 235;
                    case 153 -> 149;
                    case 154 -> 237;
                    case 155 -> 61;
                    case 156 -> 197;
                    case 157 -> 33;
                    case 158 -> 174;
                    case 159 -> 135;
                    case 160 -> 123;
                    case 161 -> 211;
                    case 162 -> 132;
                    case 163 -> 228;
                    case 164 -> 203;
                    case 165 -> 0;
                    case 166 -> 114;
                    case 167 -> 153;
                    case 168 -> 96;
                    case 169 -> 160;
                    case 170 -> 144;
                    case 171 -> 55;
                    case 172 -> 252;
                    case 173 -> 115;
                    case 174 -> 13;
                    case 175 -> 206;
                    case 176 -> 74;
                    case 177 -> 37;
                    case 178 -> 116;
                    case 179 -> 187;
                    case 180 -> 195;
                    case 181 -> 82;
                    case 182 -> 241;
                    case 183 -> 63;
                    case 184 -> 245;
                    case 185 -> 2;
                    case 186 -> 133;
                    case 187 -> 214;
                    case 188 -> 154;
                    case 189 -> 234;
                    case 190 -> 15;
                    case 191 -> 168;
                    case 192 -> 137;
                    case 193 -> 134;
                    case 194 -> 139;
                    case 195 -> 22;
                    case 196 -> 127;
                    case 197 -> 45;
                    case 198 -> 205;
                    case 199 -> 92;
                    case 200 -> 225;
                    case 201 -> 93;
                    case 202 -> 50;
                    case 203 -> 152;
                    case 204 -> 255;
                    case 205 -> 119;
                    case 206 -> 184;
                    case 207 -> 171;
                    case 208 -> 9;
                    case 209 -> 30;
                    case 210 -> 208;
                    case 211 -> 176;
                    case 212 -> 16;
                    case 213 -> 60;
                    case 214 -> 207;
                    case 215 -> 69;
                    case 216 -> 44;
                    case 217 -> 77;
                    case 218 -> 71;
                    case 219 -> 150;
                    case 220 -> 42;
                    case 221 -> 31;
                    case 222 -> 3;
                    case 223 -> 94;
                    case 224 -> 67;
                    case 225 -> 18;
                    case 226 -> 125;
                    case 227 -> 117;
                    case 228 -> 72;
                    case 229 -> 7;
                    case 230 -> 34;
                    case 231 -> 100;
                    case 232 -> 54;
                    case 233 -> 182;
                    case 234 -> 99;
                    case 235 -> 141;
                    case 236 -> 178;
                    case 237 -> 210;
                    case 238 -> 51;
                    case 239 -> 240;
                    case 240 -> 70;
                    case 241 -> 170;
                    case 242 -> 199;
                    case 243 -> 193;
                    case 244 -> 56;
                    case 245 -> 83;
                    case 246 -> 110;
                    case 247 -> 126;
                    case 248 -> 120;
                    case 249 -> 148;
                    case 250 -> 157;
                    case 251 -> 12;
                    case 252 -> 247;
                    case 253 -> 28;
                    case 254 -> 101;
                    default -> 218;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

