/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.navigation.NavigationItem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrRenameableLightElement;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrVariableEnhancer;

public class ClosureSyntheticParameter
extends GrLightParameter
implements NavigationItem,
GrRenameableLightElement,
SyntheticElement {
    private static final Function<ClosureSyntheticParameter, PsiType> TYPES_CALCULATOR = parameter -> {
        PsiType typeGroovy = GrVariableEnhancer.getEnhancedType(parameter);
        if (typeGroovy instanceof PsiIntersectionType) {
            return ((PsiIntersectionType)typeGroovy).getRepresentative();
        }
        return typeGroovy;
    };
    private final SmartPsiElementPointer<GrClosableBlock> myClosure;

    public ClosureSyntheticParameter(@NotNull GrClosableBlock closure, boolean isOptional) {
        if (closure == null) {
            ClosureSyntheticParameter.$$$reportNull$$$0(0);
        }
        super("it", (PsiType)TypesUtil.getJavaLangObject(closure), closure);
        this.setOptional(isOptional);
        this.myClosure = SmartPointerManager.createPointer((PsiElement)closure);
    }

    public PsiElement getParent() {
        return this.myClosure.getElement();
    }

    @NotNull
    public PsiElement findSameElementInCopy(@NotNull PsiFile copy) {
        GrClosableBlock block;
        if (copy == null) {
            ClosureSyntheticParameter.$$$reportNull$$$0(1);
        }
        if ((block = (GrClosableBlock)this.myClosure.getElement()) == null) {
            throw new IllegalStateException("No parent closure");
        }
        return new ClosureSyntheticParameter((GrClosableBlock)PsiTreeUtil.findSameElementInCopy((PsiElement)block, (PsiFile)copy), this.isOptional());
    }

    public PsiElement setName(@NotNull String newName) throws IncorrectOperationException {
        if (newName == null) {
            ClosureSyntheticParameter.$$$reportNull$$$0(2);
        }
        if (!newName.equals(this.getName())) {
            GrParameter parameter = GroovyPsiElementFactory.getInstance(this.getProject()).createParameter(newName, null, null);
            GrClosableBlock closure = (GrClosableBlock)this.myClosure.getElement();
            if (closure == null) {
                throw new IncorrectOperationException("Invalidated element pointer");
            }
            closure.addParameter(parameter);
        }
        return this;
    }

    @Override
    @Nullable
    public PsiType getTypeGroovy() {
        assert (this.isValid());
        return TypeInferenceHelper.getCurrentContext().getExpressionType(this, TYPES_CALCULATOR);
    }

    @Override
    @Nullable
    public PsiType getDeclaredType() {
        return null;
    }

    public boolean isWritable() {
        return true;
    }

    @NotNull
    public SearchScope getUseScope() {
        GrClosableBlock closure = (GrClosableBlock)this.myClosure.getElement();
        if (closure == null) {
            throw new IncorrectOperationException("Pointer is invalidated");
        }
        return new LocalSearchScope((PsiElement)closure);
    }

    public boolean isStillValid() {
        return this.myClosure.getElement() != null;
    }

    public GrClosableBlock getClosure() {
        GrClosableBlock closure = (GrClosableBlock)this.myClosure.getElement();
        if (closure == null) {
            throw new IncorrectOperationException("Pointer is invalidated");
        }
        return closure;
    }

    @Override
    @NotNull
    public PsiElement getDeclarationScope() {
        GrClosableBlock smartClosure = (GrClosableBlock)this.myClosure.getElement();
        GrClosableBlock grClosableBlock = smartClosure != null ? smartClosure : super.getDeclarationScope();
        if (grClosableBlock == null) {
            ClosureSyntheticParameter.$$$reportNull$$$0(3);
        }
        return grClosableBlock;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClosureSyntheticParameter)) {
            return false;
        }
        ClosureSyntheticParameter parameter = (ClosureSyntheticParameter)o;
        return Objects.equals(this.myClosure, parameter.myClosure);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.myClosure);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/ClosureSyntheticParameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/ClosureSyntheticParameter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findSameElementInCopy";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

