/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.jobs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.application.PerforceNumberNameSynchronizer;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.jobs.ByNamesConstraint;
import org.jetbrains.idea.perforce.perforce.jobs.FixesOutputParser;
import org.jetbrains.idea.perforce.perforce.jobs.JobDetailsParser;
import org.jetbrains.idea.perforce.perforce.jobs.JobsOutputParser;
import org.jetbrains.idea.perforce.perforce.jobs.JobsSearchSpecificator;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJob;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJobField;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJobSpecification;
import org.jetbrains.idea.perforce.perforce.jobs.SpecificationParser;
import org.jetbrains.idea.perforce.perforce.jobs.StandardJobFields;

public class JobsWorker {
    private final Project myProject;
    private final PerforceRunner myRunner;
    private final PerforceNumberNameSynchronizer mySynchronizer;

    Project getProject() {
        return this.myProject;
    }

    public JobsWorker(Project project) {
        this.myProject = project;
        this.mySynchronizer = PerforceNumberNameSynchronizer.getInstance(this.myProject);
        this.myRunner = PerforceRunner.getInstance(this.myProject);
    }

    public PerforceJobSpecification getSpec(P4Connection connection) throws VcsException {
        List<String> lines = this.myRunner.getJobSpecification(connection);
        SpecificationParser parser = new SpecificationParser(lines);
        return parser.parse();
    }

    @NotNull
    public List<PerforceJob> getJobs(PerforceJobSpecification specification, JobsSearchSpecificator specificator, P4Connection connection, ConnectionKey key) throws VcsException {
        List<String> lines = this.myRunner.getJobs(connection, specificator);
        JobsOutputParser parser = new JobsOutputParser(specification, lines, connection, key);
        List<PerforceJob> list = parser.parse();
        if (list == null) {
            JobsWorker.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Nullable
    private Long getNativeListNumber(LocalChangeList list, ConnectionKey key) {
        return this.mySynchronizer.getNumber(key, list.getName());
    }

    @NotNull
    public List<Pair<String, String>> loadJob(PerforceJob job) throws VcsException {
        List<String> lines = this.myRunner.getJobDetails(job);
        JobDetailsParser parser = new JobDetailsParser(lines);
        List<Pair<String, String>> list = parser.parse();
        if (list == null) {
            JobsWorker.$$$reportNull$$$0(1);
        }
        return list;
    }

    public List<String> getJobNames(LocalChangeList list, P4Connection connection, ConnectionKey key) throws VcsException {
        Long number = this.getNativeListNumber(list, key);
        if (number == null) {
            return Collections.emptyList();
        }
        return new FixesOutputParser(this.myRunner.getJobsForChange(connection, number)).parseJobNames();
    }

    public static List<String> getFreeFields(PerforceJobSpecification spec) {
        ArrayList<String> result = new ArrayList<String>();
        Collection<PerforceJobField> fields = spec.getFields();
        for (PerforceJobField field : fields) {
            if (StandardJobFields.isStandardField(field)) continue;
            result.add(field.getName());
        }
        return result;
    }

    public void addJob(PerforceJob job, LocalChangeList list) throws VcsException {
        Long number = this.getNativeListNumber(list, job.getConnectionKey());
        if (number != null) {
            this.myRunner.addJobForList(job.getConnection(), number, job.getName());
        }
    }

    public void removeJob(PerforceJob job, LocalChangeList list) throws VcsException {
        Long number = this.getNativeListNumber(list, job.getConnectionKey());
        if (number != null) {
            this.myRunner.removeJobFromList(job.getConnection(), number, job.getName());
        }
    }

    public List<PerforceJob> getJobsForList(PerforceJobSpecification specification, LocalChangeList list, P4Connection connection, ConnectionKey key) throws VcsException {
        List<String> jobNames = this.getJobNames(list, connection, key);
        if (jobNames.isEmpty()) {
            return new ArrayList<PerforceJob>();
        }
        return this.getJobs(specification, new ByNamesConstraint(jobNames), connection, key);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/idea/perforce/perforce/jobs/JobsWorker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getJobs";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "loadJob";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

