/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridSelection;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.MutationType;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.datagrid.mutating.CellMutation;
import com.intellij.database.datagrid.mutating.Mutation;
import com.intellij.database.run.ui.DataGridRequestPlace;
import com.intellij.database.run.ui.GridDataSupport;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridDataSupportImpl
implements GridDataSupport {
    private final GridMutator<GridRow, GridColumn> myMutator;
    private final DataGrid myGrid;

    public GridDataSupportImpl(@NotNull DataGrid grid, @Nullable GridMutator<GridRow, GridColumn> mutator) {
        if (grid == null) {
            GridDataSupportImpl.$$$reportNull$$$0(0);
        }
        this.myMutator = mutator;
        this.myGrid = grid;
    }

    public void revert(@NotNull ModelIndexSet<GridRow> rows, @NotNull ModelIndexSet<GridColumn> columns) {
        GridMutator.DatabaseMutator<GridRow, GridColumn> mutator;
        if (rows == null) {
            GridDataSupportImpl.$$$reportNull$$$0(1);
        }
        if (columns == null) {
            GridDataSupportImpl.$$$reportNull$$$0(2);
        }
        if ((mutator = this.getDatabaseMutator()) == null) {
            return;
        }
        GridRequestSource source = new GridRequestSource((GridRequestSource.RequestPlace)new DataGridRequestPlace((CoreGrid)this.myGrid, rows, columns));
        GridSelection selection = this.myGrid.getSelectionModel().store();
        mutator.revert(source, rows, columns);
        this.myGrid.getAutoscrollLocker().runWithLock(() -> {
            SelectionModel selectionModel = this.myGrid.getSelectionModel();
            selectionModel.restore(selectionModel.fit(selection));
        });
    }

    @Nullable
    private GridMutator.DatabaseMutator<GridRow, GridColumn> getDatabaseMutator() {
        return (GridMutator.DatabaseMutator)ObjectUtils.tryCast(this.myMutator, GridMutator.DatabaseMutator.class);
    }

    @Nullable
    private GridMutator.RowsMutator<GridRow, GridColumn> getRowsMutator() {
        return (GridMutator.RowsMutator)ObjectUtils.tryCast(this.myMutator, GridMutator.RowsMutator.class);
    }

    @Nullable
    private GridMutator.ColumnsMutator<GridRow, GridColumn> getColumnsMutator() {
        return (GridMutator.ColumnsMutator)ObjectUtils.tryCast(this.myMutator, GridMutator.ColumnsMutator.class);
    }

    public boolean isDeletedRows(@NotNull ModelIndexSet<GridRow> rows) {
        GridMutator.RowsMutator<GridRow, GridColumn> mutator;
        if (rows == null) {
            GridDataSupportImpl.$$$reportNull$$$0(3);
        }
        return (mutator = this.getRowsMutator()) != null && mutator.isDeletedRows(rows);
    }

    public boolean isModified(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        GridMutator.DatabaseMutator<GridRow, GridColumn> mutator;
        if (row == null) {
            GridDataSupportImpl.$$$reportNull$$$0(4);
        }
        if (column == null) {
            GridDataSupportImpl.$$$reportNull$$$0(5);
        }
        if ((mutator = this.getDatabaseMutator()) == null) {
            return false;
        }
        return mutator.getMutationType(row, column) == MutationType.MODIFY;
    }

    public boolean isDeletedColumn(@NotNull ModelIndex<GridColumn> column) {
        GridMutator.ColumnsMutator<GridRow, GridColumn> mutator;
        if (column == null) {
            GridDataSupportImpl.$$$reportNull$$$0(6);
        }
        return (mutator = this.getColumnsMutator()) != null && mutator.isDeletedColumn(column);
    }

    public boolean isInsertedColumn(@NotNull ModelIndex<GridColumn> column) {
        GridMutator.ColumnsMutator<GridRow, GridColumn> mutator;
        if (column == null) {
            GridDataSupportImpl.$$$reportNull$$$0(7);
        }
        return (mutator = this.getColumnsMutator()) != null && mutator.isInsertedColumn(column);
    }

    public int getInsertedColumnsCount() {
        GridMutator.ColumnsMutator<GridRow, GridColumn> mutator = this.getColumnsMutator();
        return mutator == null ? 0 : mutator.getInsertedColumnsCount();
    }

    public boolean hasPendingChanges() {
        return this.hasMutator() && Objects.requireNonNull(this.myMutator).hasPendingChanges();
    }

    public boolean hasUnparsedValues() {
        return this.hasMutator() && Objects.requireNonNull(this.myMutator).hasUnparsedValues();
    }

    public boolean hasMutator() {
        return this.myMutator != null;
    }

    public boolean hasRowMutator() {
        return this.getRowsMutator() != null;
    }

    public boolean canRevert() {
        return this.getDatabaseMutator() != null;
    }

    public boolean isSubmitImmediately() {
        return this.myMutator != null && this.myMutator.isUpdateImmediately();
    }

    public void finishBuildingAndApply(@NotNull List<CellMutation.Builder> builders) {
        if (builders == null) {
            GridDataSupportImpl.$$$reportNull$$$0(8);
        }
        if (this.myMutator == null) {
            return;
        }
        List mutations = ContainerUtil.map(builders, CellMutation.Builder::build);
        ModelIndexSet rows = ModelIndexSet.forRows((CoreGrid)this.myGrid, (int[])GridDataSupportImpl.uniqueIndices(mutations, Mutation::getRow));
        ModelIndexSet columns = ModelIndexSet.forColumns((CoreGrid)this.myGrid, (int[])GridDataSupportImpl.uniqueIndices(mutations, CellMutation::getColumn));
        this.myMutator.mutate(new GridRequestSource((GridRequestSource.RequestPlace)new DataGridRequestPlace((CoreGrid)this.myGrid, rows, columns)), mutations, true);
    }

    private static int[] uniqueIndices(@NotNull List<CellMutation> mutations, @NotNull Function<CellMutation, ModelIndex<?>> function) {
        if (mutations == null) {
            GridDataSupportImpl.$$$reportNull$$$0(9);
        }
        if (function == null) {
            GridDataSupportImpl.$$$reportNull$$$0(10);
        }
        return mutations.stream().mapToInt(mutation -> ((ModelIndex)function.fun(mutation)).asInteger()).distinct().toArray();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builders";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutations";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/ui/grid/GridDataSupportImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "revert";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isDeletedRows";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isModified";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isDeletedColumn";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isInsertedColumn";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "finishBuildingAndApply";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "uniqueIndices";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

