/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.ui.DeferredIconImpl;
import com.intellij.util.ProcessingContext;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.injection.CodeFenceLanguageProvider;
import org.intellij.plugins.markdown.injection.aliases.CodeFenceLanguageAliases;
import org.intellij.plugins.markdown.injection.aliases.CodeFenceLanguageGuesser;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\f\rB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\u000e"}, d2={"Lorg/intellij/plugins/markdown/editor/CodeFenceLanguageListCompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "<init>", "()V", "addCompletions", "", "parameters", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "MyInsertHandler", "Companion", "intellij.markdown"})
public final class CodeFenceLanguageListCompletionProvider
extends CompletionProvider<CompletionParameters> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        for (CodeFenceLanguageProvider provider : CodeFenceLanguageGuesser.INSTANCE.getCustomProviders()) {
            List<LookupElement> lookups;
            Intrinsics.checkNotNullExpressionValue(provider.getCompletionVariantsForInfoString(parameters), (String)"getCompletionVariantsForInfoString(...)");
            for (LookupElement lookupElement : lookups) {
                LookupElementDecorator element2;
                Intrinsics.checkNotNullExpressionValue((Object)LookupElementDecorator.withInsertHandler((LookupElement)lookupElement, (InsertHandler)new InsertHandler(parameters, lookupElement){
                    final /* synthetic */ CompletionParameters $parameters;
                    final /* synthetic */ LookupElement $lookupElement;
                    {
                        this.$parameters = $parameters;
                        this.$lookupElement = $lookupElement;
                    }

                    public final void handleInsert(InsertionContext context, LookupElementDecorator<LookupElement> item) {
                        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                        Intrinsics.checkNotNullParameter(item, (String)"item");
                        new MyInsertHandler(this.$parameters).handleInsert(context, (LookupElement)item);
                        this.$lookupElement.handleInsert(context);
                    }
                }), (String)"withInsertHandler(...)");
                result.addElement((LookupElement)element2);
            }
        }
        for (Language language : LanguageUtil.getInjectableLanguages()) {
            String string = language.getID();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
            String alias = CodeFenceLanguageAliases.INSTANCE.findMainAlias(string);
            LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)alias);
            Intrinsics.checkNotNull((Object)language);
            LookupElementBuilder lookupElementBuilder2 = lookupElementBuilder.withIcon(Companion.createLanguageIcon(language)).withTypeText(language.getDisplayName(), true).withInsertHandler((InsertHandler)new MyInsertHandler(parameters));
            Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder2, (String)"withInsertHandler(...)");
            LookupElementBuilder lookupElement = lookupElementBuilder2;
            result.addElement((LookupElement)lookupElement);
        }
    }

    @JvmStatic
    @NotNull
    public static final Icon createLanguageIcon(@NotNull Language language) {
        return Companion.createLanguageIcon(language);
    }

    @JvmStatic
    public static final boolean isInMiddleOfUnCollapsedFence(@Nullable PsiElement element2, int offset) {
        return Companion.isInMiddleOfUnCollapsedFence(element2, offset);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001a\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007\u00a8\u0006\u000e"}, d2={"Lorg/intellij/plugins/markdown/editor/CodeFenceLanguageListCompletionProvider$Companion;", "", "<init>", "()V", "createLanguageIcon", "Ljavax/swing/Icon;", "language", "Lcom/intellij/lang/Language;", "isInMiddleOfUnCollapsedFence", "", "element", "Lcom/intellij/psi/PsiElement;", "offset", "", "intellij.markdown"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Icon createLanguageIcon(@NotNull Language language) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            return (Icon)new DeferredIconImpl(null, (Object)language, true, arg_0 -> Companion.createLanguageIcon$lambda$1(Companion::createLanguageIcon$lambda$0, arg_0));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        public final boolean isInMiddleOfUnCollapsedFence(@Nullable PsiElement element2, int offset) {
            if (element2 == null) {
                return false;
            }
            IElementType iElementType = MarkdownTokenTypes.CODE_FENCE_START;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"CODE_FENCE_START");
            if (PsiUtilsKt.hasType(element2, iElementType)) {
                TextRange range = element2.getTextRange();
                if (range.getStartOffset() + range.getEndOffset() != offset * 2) return false;
                return true;
            }
            IElementType iElementType2 = MarkdownTokenTypes.TEXT;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"TEXT");
            if (!PsiUtilsKt.hasType(element2, iElementType2)) return false;
            PsiElement psiElement = element2.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getParent(...)");
            IElementType iElementType3 = MarkdownElementTypes.CODE_SPAN;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType3, (String)"CODE_SPAN");
            if (!PsiUtilsKt.hasType(psiElement, iElementType3)) return false;
            TextRange range = element2.getTextRange();
            TextRange parentRange = element2.getParent().getTextRange();
            if (range.getStartOffset() - parentRange.getStartOffset() != parentRange.getEndOffset() - range.getEndOffset()) return false;
            return true;
        }

        private static final Icon createLanguageIcon$lambda$0(Language curLanguage) {
            Intrinsics.checkNotNullParameter((Object)curLanguage, (String)"curLanguage");
            LanguageFileType languageFileType = curLanguage.getAssociatedFileType();
            return languageFileType != null ? languageFileType.getIcon() : null;
        }

        private static final Icon createLanguageIcon$lambda$1(Function1 $tmp0, Object p0) {
            return (Icon)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/intellij/plugins/markdown/editor/CodeFenceLanguageListCompletionProvider$MyInsertHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "<init>", "(Lcom/intellij/codeInsight/completion/CompletionParameters;)V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "intellij.markdown"})
    private static final class MyInsertHandler
    implements InsertHandler<LookupElement> {
        @NotNull
        private final CompletionParameters parameters;

        public MyInsertHandler(@NotNull CompletionParameters parameters) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            this.parameters = parameters;
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            if (Companion.isInMiddleOfUnCollapsedFence(this.parameters.getOriginalPosition(), context.getStartOffset())) {
                context.getDocument().insertString(context.getTailOffset(), (CharSequence)"\n\n");
                context.getEditor().getCaretModel().moveCaretRelatively(1, 0, false, false, false);
            }
        }
    }
}

