// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 2
// REQUIRES: riscv-registered-target
// RUN: %clang_cc1 -triple riscv64 -target-feature +v -target-feature +zfh \
// RUN:   -target-feature +zvfhmin -disable-O0-optnone  \
// RUN:   -emit-llvm %s -o - | opt -S -passes=mem2reg | \
// RUN:   FileCheck --check-prefix=CHECK-RV64 %s

#include <riscv_vector.h>

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x half> @test_vset_v_f16m1_f16m2
// CHECK-RV64-SAME: (<vscale x 8 x half> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x half> [[VAL:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x half> @llvm.vector.insert.nxv8f16.nxv4f16(<vscale x 8 x half> [[DEST]], <vscale x 4 x half> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
vfloat16m2_t test_vset_v_f16m1_f16m2(vfloat16m2_t dest, size_t index, vfloat16m1_t val) {
  return __riscv_vset_v_f16m1_f16m2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x half> @test_vset_v_f16m1_f16m4
// CHECK-RV64-SAME: (<vscale x 16 x half> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x half> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x half> @llvm.vector.insert.nxv16f16.nxv4f16(<vscale x 16 x half> [[DEST]], <vscale x 4 x half> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
vfloat16m4_t test_vset_v_f16m1_f16m4(vfloat16m4_t dest, size_t index, vfloat16m1_t val) {
  return __riscv_vset_v_f16m1_f16m4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x half> @test_vset_v_f16m2_f16m4
// CHECK-RV64-SAME: (<vscale x 16 x half> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x half> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x half> @llvm.vector.insert.nxv16f16.nxv8f16(<vscale x 16 x half> [[DEST]], <vscale x 8 x half> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
vfloat16m4_t test_vset_v_f16m2_f16m4(vfloat16m4_t dest, size_t index, vfloat16m2_t val) {
  return __riscv_vset_v_f16m2_f16m4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x half> @test_vset_v_f16m1_f16m8
// CHECK-RV64-SAME: (<vscale x 32 x half> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x half> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x half> @llvm.vector.insert.nxv32f16.nxv4f16(<vscale x 32 x half> [[DEST]], <vscale x 4 x half> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
vfloat16m8_t test_vset_v_f16m1_f16m8(vfloat16m8_t dest, size_t index, vfloat16m1_t val) {
  return __riscv_vset_v_f16m1_f16m8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x half> @test_vset_v_f16m2_f16m8
// CHECK-RV64-SAME: (<vscale x 32 x half> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x half> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x half> @llvm.vector.insert.nxv32f16.nxv8f16(<vscale x 32 x half> [[DEST]], <vscale x 8 x half> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
vfloat16m8_t test_vset_v_f16m2_f16m8(vfloat16m8_t dest, size_t index, vfloat16m2_t val) {
  return __riscv_vset_v_f16m2_f16m8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x half> @test_vset_v_f16m4_f16m8
// CHECK-RV64-SAME: (<vscale x 32 x half> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 16 x half> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x half> @llvm.vector.insert.nxv32f16.nxv16f16(<vscale x 32 x half> [[DEST]], <vscale x 16 x half> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
vfloat16m8_t test_vset_v_f16m4_f16m8(vfloat16m8_t dest, size_t index, vfloat16m4_t val) {
  return __riscv_vset_v_f16m4_f16m8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x float> @test_vset_v_f32m1_f32m2
// CHECK-RV64-SAME: (<vscale x 4 x float> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x float> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x float> @llvm.vector.insert.nxv4f32.nxv2f32(<vscale x 4 x float> [[DEST]], <vscale x 2 x float> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 4 x float> [[TMP0]]
//
vfloat32m2_t test_vset_v_f32m1_f32m2(vfloat32m2_t dest, size_t index, vfloat32m1_t val) {
  return __riscv_vset_v_f32m1_f32m2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x float> @test_vset_v_f32m1_f32m4
// CHECK-RV64-SAME: (<vscale x 8 x float> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x float> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x float> @llvm.vector.insert.nxv8f32.nxv2f32(<vscale x 8 x float> [[DEST]], <vscale x 2 x float> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x float> [[TMP0]]
//
vfloat32m4_t test_vset_v_f32m1_f32m4(vfloat32m4_t dest, size_t index, vfloat32m1_t val) {
  return __riscv_vset_v_f32m1_f32m4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x float> @test_vset_v_f32m2_f32m4
// CHECK-RV64-SAME: (<vscale x 8 x float> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x float> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x float> @llvm.vector.insert.nxv8f32.nxv4f32(<vscale x 8 x float> [[DEST]], <vscale x 4 x float> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x float> [[TMP0]]
//
vfloat32m4_t test_vset_v_f32m2_f32m4(vfloat32m4_t dest, size_t index, vfloat32m2_t val) {
  return __riscv_vset_v_f32m2_f32m4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x float> @test_vset_v_f32m1_f32m8
// CHECK-RV64-SAME: (<vscale x 16 x float> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x float> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x float> @llvm.vector.insert.nxv16f32.nxv2f32(<vscale x 16 x float> [[DEST]], <vscale x 2 x float> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 16 x float> [[TMP0]]
//
vfloat32m8_t test_vset_v_f32m1_f32m8(vfloat32m8_t dest, size_t index, vfloat32m1_t val) {
  return __riscv_vset_v_f32m1_f32m8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x float> @test_vset_v_f32m2_f32m8
// CHECK-RV64-SAME: (<vscale x 16 x float> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x float> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x float> @llvm.vector.insert.nxv16f32.nxv4f32(<vscale x 16 x float> [[DEST]], <vscale x 4 x float> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 16 x float> [[TMP0]]
//
vfloat32m8_t test_vset_v_f32m2_f32m8(vfloat32m8_t dest, size_t index, vfloat32m2_t val) {
  return __riscv_vset_v_f32m2_f32m8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x float> @test_vset_v_f32m4_f32m8
// CHECK-RV64-SAME: (<vscale x 16 x float> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x float> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x float> @llvm.vector.insert.nxv16f32.nxv8f32(<vscale x 16 x float> [[DEST]], <vscale x 8 x float> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 16 x float> [[TMP0]]
//
vfloat32m8_t test_vset_v_f32m4_f32m8(vfloat32m8_t dest, size_t index, vfloat32m4_t val) {
  return __riscv_vset_v_f32m4_f32m8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x double> @test_vset_v_f64m1_f64m2
// CHECK-RV64-SAME: (<vscale x 2 x double> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x double> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x double> @llvm.vector.insert.nxv2f64.nxv1f64(<vscale x 2 x double> [[DEST]], <vscale x 1 x double> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 2 x double> [[TMP0]]
//
vfloat64m2_t test_vset_v_f64m1_f64m2(vfloat64m2_t dest, size_t index, vfloat64m1_t val) {
  return __riscv_vset_v_f64m1_f64m2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x double> @test_vset_v_f64m1_f64m4
// CHECK-RV64-SAME: (<vscale x 4 x double> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x double> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x double> @llvm.vector.insert.nxv4f64.nxv1f64(<vscale x 4 x double> [[DEST]], <vscale x 1 x double> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 4 x double> [[TMP0]]
//
vfloat64m4_t test_vset_v_f64m1_f64m4(vfloat64m4_t dest, size_t index, vfloat64m1_t val) {
  return __riscv_vset_v_f64m1_f64m4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x double> @test_vset_v_f64m2_f64m4
// CHECK-RV64-SAME: (<vscale x 4 x double> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x double> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x double> @llvm.vector.insert.nxv4f64.nxv2f64(<vscale x 4 x double> [[DEST]], <vscale x 2 x double> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 4 x double> [[TMP0]]
//
vfloat64m4_t test_vset_v_f64m2_f64m4(vfloat64m4_t dest, size_t index, vfloat64m2_t val) {
  return __riscv_vset_v_f64m2_f64m4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x double> @test_vset_v_f64m1_f64m8
// CHECK-RV64-SAME: (<vscale x 8 x double> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x double> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x double> @llvm.vector.insert.nxv8f64.nxv1f64(<vscale x 8 x double> [[DEST]], <vscale x 1 x double> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x double> [[TMP0]]
//
vfloat64m8_t test_vset_v_f64m1_f64m8(vfloat64m8_t dest, size_t index, vfloat64m1_t val) {
  return __riscv_vset_v_f64m1_f64m8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x double> @test_vset_v_f64m2_f64m8
// CHECK-RV64-SAME: (<vscale x 8 x double> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x double> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x double> @llvm.vector.insert.nxv8f64.nxv2f64(<vscale x 8 x double> [[DEST]], <vscale x 2 x double> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x double> [[TMP0]]
//
vfloat64m8_t test_vset_v_f64m2_f64m8(vfloat64m8_t dest, size_t index, vfloat64m2_t val) {
  return __riscv_vset_v_f64m2_f64m8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x double> @test_vset_v_f64m4_f64m8
// CHECK-RV64-SAME: (<vscale x 8 x double> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x double> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x double> @llvm.vector.insert.nxv8f64.nxv4f64(<vscale x 8 x double> [[DEST]], <vscale x 4 x double> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x double> [[TMP0]]
//
vfloat64m8_t test_vset_v_f64m4_f64m8(vfloat64m8_t dest, size_t index, vfloat64m4_t val) {
  return __riscv_vset_v_f64m4_f64m8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i8> @test_vset_v_i8m1_i8m2
// CHECK-RV64-SAME: (<vscale x 16 x i8> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.vector.insert.nxv16i8.nxv8i8(<vscale x 16 x i8> [[DEST]], <vscale x 8 x i8> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
vint8m2_t test_vset_v_i8m1_i8m2(vint8m2_t dest, size_t index, vint8m1_t val) {
  return __riscv_vset_v_i8m1_i8m2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x i8> @test_vset_v_i8m1_i8m4
// CHECK-RV64-SAME: (<vscale x 32 x i8> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.vector.insert.nxv32i8.nxv8i8(<vscale x 32 x i8> [[DEST]], <vscale x 8 x i8> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
vint8m4_t test_vset_v_i8m1_i8m4(vint8m4_t dest, size_t index, vint8m1_t val) {
  return __riscv_vset_v_i8m1_i8m4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x i8> @test_vset_v_i8m2_i8m4
// CHECK-RV64-SAME: (<vscale x 32 x i8> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 16 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.vector.insert.nxv32i8.nxv16i8(<vscale x 32 x i8> [[DEST]], <vscale x 16 x i8> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
vint8m4_t test_vset_v_i8m2_i8m4(vint8m4_t dest, size_t index, vint8m2_t val) {
  return __riscv_vset_v_i8m2_i8m4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 64 x i8> @test_vset_v_i8m1_i8m8
// CHECK-RV64-SAME: (<vscale x 64 x i8> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.vector.insert.nxv64i8.nxv8i8(<vscale x 64 x i8> [[DEST]], <vscale x 8 x i8> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
vint8m8_t test_vset_v_i8m1_i8m8(vint8m8_t dest, size_t index, vint8m1_t val) {
  return __riscv_vset_v_i8m1_i8m8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 64 x i8> @test_vset_v_i8m2_i8m8
// CHECK-RV64-SAME: (<vscale x 64 x i8> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 16 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.vector.insert.nxv64i8.nxv16i8(<vscale x 64 x i8> [[DEST]], <vscale x 16 x i8> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
vint8m8_t test_vset_v_i8m2_i8m8(vint8m8_t dest, size_t index, vint8m2_t val) {
  return __riscv_vset_v_i8m2_i8m8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 64 x i8> @test_vset_v_i8m4_i8m8
// CHECK-RV64-SAME: (<vscale x 64 x i8> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 32 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.vector.insert.nxv64i8.nxv32i8(<vscale x 64 x i8> [[DEST]], <vscale x 32 x i8> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
vint8m8_t test_vset_v_i8m4_i8m8(vint8m8_t dest, size_t index, vint8m4_t val) {
  return __riscv_vset_v_i8m4_i8m8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i16> @test_vset_v_i16m1_i16m2
// CHECK-RV64-SAME: (<vscale x 8 x i16> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.vector.insert.nxv8i16.nxv4i16(<vscale x 8 x i16> [[DEST]], <vscale x 4 x i16> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
vint16m2_t test_vset_v_i16m1_i16m2(vint16m2_t dest, size_t index, vint16m1_t val) {
  return __riscv_vset_v_i16m1_i16m2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i16> @test_vset_v_i16m1_i16m4
// CHECK-RV64-SAME: (<vscale x 16 x i16> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.vector.insert.nxv16i16.nxv4i16(<vscale x 16 x i16> [[DEST]], <vscale x 4 x i16> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
vint16m4_t test_vset_v_i16m1_i16m4(vint16m4_t dest, size_t index, vint16m1_t val) {
  return __riscv_vset_v_i16m1_i16m4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i16> @test_vset_v_i16m2_i16m4
// CHECK-RV64-SAME: (<vscale x 16 x i16> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.vector.insert.nxv16i16.nxv8i16(<vscale x 16 x i16> [[DEST]], <vscale x 8 x i16> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
vint16m4_t test_vset_v_i16m2_i16m4(vint16m4_t dest, size_t index, vint16m2_t val) {
  return __riscv_vset_v_i16m2_i16m4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x i16> @test_vset_v_i16m1_i16m8
// CHECK-RV64-SAME: (<vscale x 32 x i16> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.vector.insert.nxv32i16.nxv4i16(<vscale x 32 x i16> [[DEST]], <vscale x 4 x i16> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vint16m8_t test_vset_v_i16m1_i16m8(vint16m8_t dest, size_t index, vint16m1_t val) {
  return __riscv_vset_v_i16m1_i16m8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x i16> @test_vset_v_i16m2_i16m8
// CHECK-RV64-SAME: (<vscale x 32 x i16> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.vector.insert.nxv32i16.nxv8i16(<vscale x 32 x i16> [[DEST]], <vscale x 8 x i16> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vint16m8_t test_vset_v_i16m2_i16m8(vint16m8_t dest, size_t index, vint16m2_t val) {
  return __riscv_vset_v_i16m2_i16m8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x i16> @test_vset_v_i16m4_i16m8
// CHECK-RV64-SAME: (<vscale x 32 x i16> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 16 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.vector.insert.nxv32i16.nxv16i16(<vscale x 32 x i16> [[DEST]], <vscale x 16 x i16> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vint16m8_t test_vset_v_i16m4_i16m8(vint16m8_t dest, size_t index, vint16m4_t val) {
  return __riscv_vset_v_i16m4_i16m8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i32> @test_vset_v_i32m1_i32m2
// CHECK-RV64-SAME: (<vscale x 4 x i32> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.vector.insert.nxv4i32.nxv2i32(<vscale x 4 x i32> [[DEST]], <vscale x 2 x i32> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
vint32m2_t test_vset_v_i32m1_i32m2(vint32m2_t dest, size_t index, vint32m1_t val) {
  return __riscv_vset_v_i32m1_i32m2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i32> @test_vset_v_i32m1_i32m4
// CHECK-RV64-SAME: (<vscale x 8 x i32> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.vector.insert.nxv8i32.nxv2i32(<vscale x 8 x i32> [[DEST]], <vscale x 2 x i32> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
vint32m4_t test_vset_v_i32m1_i32m4(vint32m4_t dest, size_t index, vint32m1_t val) {
  return __riscv_vset_v_i32m1_i32m4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i32> @test_vset_v_i32m2_i32m4
// CHECK-RV64-SAME: (<vscale x 8 x i32> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.vector.insert.nxv8i32.nxv4i32(<vscale x 8 x i32> [[DEST]], <vscale x 4 x i32> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
vint32m4_t test_vset_v_i32m2_i32m4(vint32m4_t dest, size_t index, vint32m2_t val) {
  return __riscv_vset_v_i32m2_i32m4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i32> @test_vset_v_i32m1_i32m8
// CHECK-RV64-SAME: (<vscale x 16 x i32> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.vector.insert.nxv16i32.nxv2i32(<vscale x 16 x i32> [[DEST]], <vscale x 2 x i32> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
vint32m8_t test_vset_v_i32m1_i32m8(vint32m8_t dest, size_t index, vint32m1_t val) {
  return __riscv_vset_v_i32m1_i32m8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i32> @test_vset_v_i32m2_i32m8
// CHECK-RV64-SAME: (<vscale x 16 x i32> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.vector.insert.nxv16i32.nxv4i32(<vscale x 16 x i32> [[DEST]], <vscale x 4 x i32> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
vint32m8_t test_vset_v_i32m2_i32m8(vint32m8_t dest, size_t index, vint32m2_t val) {
  return __riscv_vset_v_i32m2_i32m8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i32> @test_vset_v_i32m4_i32m8
// CHECK-RV64-SAME: (<vscale x 16 x i32> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.vector.insert.nxv16i32.nxv8i32(<vscale x 16 x i32> [[DEST]], <vscale x 8 x i32> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
vint32m8_t test_vset_v_i32m4_i32m8(vint32m8_t dest, size_t index, vint32m4_t val) {
  return __riscv_vset_v_i32m4_i32m8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i64> @test_vset_v_i64m1_i64m2
// CHECK-RV64-SAME: (<vscale x 2 x i64> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i64> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.vector.insert.nxv2i64.nxv1i64(<vscale x 2 x i64> [[DEST]], <vscale x 1 x i64> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
vint64m2_t test_vset_v_i64m1_i64m2(vint64m2_t dest, size_t index, vint64m1_t val) {
  return __riscv_vset_v_i64m1_i64m2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i64> @test_vset_v_i64m1_i64m4
// CHECK-RV64-SAME: (<vscale x 4 x i64> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i64> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.vector.insert.nxv4i64.nxv1i64(<vscale x 4 x i64> [[DEST]], <vscale x 1 x i64> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
vint64m4_t test_vset_v_i64m1_i64m4(vint64m4_t dest, size_t index, vint64m1_t val) {
  return __riscv_vset_v_i64m1_i64m4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i64> @test_vset_v_i64m2_i64m4
// CHECK-RV64-SAME: (<vscale x 4 x i64> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i64> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.vector.insert.nxv4i64.nxv2i64(<vscale x 4 x i64> [[DEST]], <vscale x 2 x i64> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
vint64m4_t test_vset_v_i64m2_i64m4(vint64m4_t dest, size_t index, vint64m2_t val) {
  return __riscv_vset_v_i64m2_i64m4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i64> @test_vset_v_i64m1_i64m8
// CHECK-RV64-SAME: (<vscale x 8 x i64> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i64> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.vector.insert.nxv8i64.nxv1i64(<vscale x 8 x i64> [[DEST]], <vscale x 1 x i64> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
vint64m8_t test_vset_v_i64m1_i64m8(vint64m8_t dest, size_t index, vint64m1_t val) {
  return __riscv_vset_v_i64m1_i64m8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i64> @test_vset_v_i64m2_i64m8
// CHECK-RV64-SAME: (<vscale x 8 x i64> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i64> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.vector.insert.nxv8i64.nxv2i64(<vscale x 8 x i64> [[DEST]], <vscale x 2 x i64> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
vint64m8_t test_vset_v_i64m2_i64m8(vint64m8_t dest, size_t index, vint64m2_t val) {
  return __riscv_vset_v_i64m2_i64m8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i64> @test_vset_v_i64m4_i64m8
// CHECK-RV64-SAME: (<vscale x 8 x i64> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i64> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.vector.insert.nxv8i64.nxv4i64(<vscale x 8 x i64> [[DEST]], <vscale x 4 x i64> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
vint64m8_t test_vset_v_i64m4_i64m8(vint64m8_t dest, size_t index, vint64m4_t val) {
  return __riscv_vset_v_i64m4_i64m8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i8> @test_vset_v_u8m1_u8m2
// CHECK-RV64-SAME: (<vscale x 16 x i8> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.vector.insert.nxv16i8.nxv8i8(<vscale x 16 x i8> [[DEST]], <vscale x 8 x i8> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
vuint8m2_t test_vset_v_u8m1_u8m2(vuint8m2_t dest, size_t index, vuint8m1_t val) {
  return __riscv_vset_v_u8m1_u8m2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x i8> @test_vset_v_u8m1_u8m4
// CHECK-RV64-SAME: (<vscale x 32 x i8> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.vector.insert.nxv32i8.nxv8i8(<vscale x 32 x i8> [[DEST]], <vscale x 8 x i8> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
vuint8m4_t test_vset_v_u8m1_u8m4(vuint8m4_t dest, size_t index, vuint8m1_t val) {
  return __riscv_vset_v_u8m1_u8m4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x i8> @test_vset_v_u8m2_u8m4
// CHECK-RV64-SAME: (<vscale x 32 x i8> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 16 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.vector.insert.nxv32i8.nxv16i8(<vscale x 32 x i8> [[DEST]], <vscale x 16 x i8> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
vuint8m4_t test_vset_v_u8m2_u8m4(vuint8m4_t dest, size_t index, vuint8m2_t val) {
  return __riscv_vset_v_u8m2_u8m4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 64 x i8> @test_vset_v_u8m1_u8m8
// CHECK-RV64-SAME: (<vscale x 64 x i8> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.vector.insert.nxv64i8.nxv8i8(<vscale x 64 x i8> [[DEST]], <vscale x 8 x i8> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
vuint8m8_t test_vset_v_u8m1_u8m8(vuint8m8_t dest, size_t index, vuint8m1_t val) {
  return __riscv_vset_v_u8m1_u8m8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 64 x i8> @test_vset_v_u8m2_u8m8
// CHECK-RV64-SAME: (<vscale x 64 x i8> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 16 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.vector.insert.nxv64i8.nxv16i8(<vscale x 64 x i8> [[DEST]], <vscale x 16 x i8> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
vuint8m8_t test_vset_v_u8m2_u8m8(vuint8m8_t dest, size_t index, vuint8m2_t val) {
  return __riscv_vset_v_u8m2_u8m8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 64 x i8> @test_vset_v_u8m4_u8m8
// CHECK-RV64-SAME: (<vscale x 64 x i8> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 32 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.vector.insert.nxv64i8.nxv32i8(<vscale x 64 x i8> [[DEST]], <vscale x 32 x i8> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
vuint8m8_t test_vset_v_u8m4_u8m8(vuint8m8_t dest, size_t index, vuint8m4_t val) {
  return __riscv_vset_v_u8m4_u8m8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i16> @test_vset_v_u16m1_u16m2
// CHECK-RV64-SAME: (<vscale x 8 x i16> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.vector.insert.nxv8i16.nxv4i16(<vscale x 8 x i16> [[DEST]], <vscale x 4 x i16> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
vuint16m2_t test_vset_v_u16m1_u16m2(vuint16m2_t dest, size_t index, vuint16m1_t val) {
  return __riscv_vset_v_u16m1_u16m2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i16> @test_vset_v_u16m1_u16m4
// CHECK-RV64-SAME: (<vscale x 16 x i16> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.vector.insert.nxv16i16.nxv4i16(<vscale x 16 x i16> [[DEST]], <vscale x 4 x i16> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
vuint16m4_t test_vset_v_u16m1_u16m4(vuint16m4_t dest, size_t index, vuint16m1_t val) {
  return __riscv_vset_v_u16m1_u16m4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i16> @test_vset_v_u16m2_u16m4
// CHECK-RV64-SAME: (<vscale x 16 x i16> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.vector.insert.nxv16i16.nxv8i16(<vscale x 16 x i16> [[DEST]], <vscale x 8 x i16> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
vuint16m4_t test_vset_v_u16m2_u16m4(vuint16m4_t dest, size_t index, vuint16m2_t val) {
  return __riscv_vset_v_u16m2_u16m4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x i16> @test_vset_v_u16m1_u16m8
// CHECK-RV64-SAME: (<vscale x 32 x i16> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.vector.insert.nxv32i16.nxv4i16(<vscale x 32 x i16> [[DEST]], <vscale x 4 x i16> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vuint16m8_t test_vset_v_u16m1_u16m8(vuint16m8_t dest, size_t index, vuint16m1_t val) {
  return __riscv_vset_v_u16m1_u16m8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x i16> @test_vset_v_u16m2_u16m8
// CHECK-RV64-SAME: (<vscale x 32 x i16> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.vector.insert.nxv32i16.nxv8i16(<vscale x 32 x i16> [[DEST]], <vscale x 8 x i16> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vuint16m8_t test_vset_v_u16m2_u16m8(vuint16m8_t dest, size_t index, vuint16m2_t val) {
  return __riscv_vset_v_u16m2_u16m8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x i16> @test_vset_v_u16m4_u16m8
// CHECK-RV64-SAME: (<vscale x 32 x i16> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 16 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.vector.insert.nxv32i16.nxv16i16(<vscale x 32 x i16> [[DEST]], <vscale x 16 x i16> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vuint16m8_t test_vset_v_u16m4_u16m8(vuint16m8_t dest, size_t index, vuint16m4_t val) {
  return __riscv_vset_v_u16m4_u16m8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i32> @test_vset_v_u32m1_u32m2
// CHECK-RV64-SAME: (<vscale x 4 x i32> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.vector.insert.nxv4i32.nxv2i32(<vscale x 4 x i32> [[DEST]], <vscale x 2 x i32> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
vuint32m2_t test_vset_v_u32m1_u32m2(vuint32m2_t dest, size_t index, vuint32m1_t val) {
  return __riscv_vset_v_u32m1_u32m2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i32> @test_vset_v_u32m1_u32m4
// CHECK-RV64-SAME: (<vscale x 8 x i32> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.vector.insert.nxv8i32.nxv2i32(<vscale x 8 x i32> [[DEST]], <vscale x 2 x i32> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
vuint32m4_t test_vset_v_u32m1_u32m4(vuint32m4_t dest, size_t index, vuint32m1_t val) {
  return __riscv_vset_v_u32m1_u32m4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i32> @test_vset_v_u32m2_u32m4
// CHECK-RV64-SAME: (<vscale x 8 x i32> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.vector.insert.nxv8i32.nxv4i32(<vscale x 8 x i32> [[DEST]], <vscale x 4 x i32> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
vuint32m4_t test_vset_v_u32m2_u32m4(vuint32m4_t dest, size_t index, vuint32m2_t val) {
  return __riscv_vset_v_u32m2_u32m4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i32> @test_vset_v_u32m1_u32m8
// CHECK-RV64-SAME: (<vscale x 16 x i32> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.vector.insert.nxv16i32.nxv2i32(<vscale x 16 x i32> [[DEST]], <vscale x 2 x i32> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
vuint32m8_t test_vset_v_u32m1_u32m8(vuint32m8_t dest, size_t index, vuint32m1_t val) {
  return __riscv_vset_v_u32m1_u32m8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i32> @test_vset_v_u32m2_u32m8
// CHECK-RV64-SAME: (<vscale x 16 x i32> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.vector.insert.nxv16i32.nxv4i32(<vscale x 16 x i32> [[DEST]], <vscale x 4 x i32> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
vuint32m8_t test_vset_v_u32m2_u32m8(vuint32m8_t dest, size_t index, vuint32m2_t val) {
  return __riscv_vset_v_u32m2_u32m8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i32> @test_vset_v_u32m4_u32m8
// CHECK-RV64-SAME: (<vscale x 16 x i32> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.vector.insert.nxv16i32.nxv8i32(<vscale x 16 x i32> [[DEST]], <vscale x 8 x i32> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
vuint32m8_t test_vset_v_u32m4_u32m8(vuint32m8_t dest, size_t index, vuint32m4_t val) {
  return __riscv_vset_v_u32m4_u32m8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i64> @test_vset_v_u64m1_u64m2
// CHECK-RV64-SAME: (<vscale x 2 x i64> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i64> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.vector.insert.nxv2i64.nxv1i64(<vscale x 2 x i64> [[DEST]], <vscale x 1 x i64> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
vuint64m2_t test_vset_v_u64m1_u64m2(vuint64m2_t dest, size_t index, vuint64m1_t val) {
  return __riscv_vset_v_u64m1_u64m2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i64> @test_vset_v_u64m1_u64m4
// CHECK-RV64-SAME: (<vscale x 4 x i64> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i64> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.vector.insert.nxv4i64.nxv1i64(<vscale x 4 x i64> [[DEST]], <vscale x 1 x i64> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
vuint64m4_t test_vset_v_u64m1_u64m4(vuint64m4_t dest, size_t index, vuint64m1_t val) {
  return __riscv_vset_v_u64m1_u64m4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i64> @test_vset_v_u64m2_u64m4
// CHECK-RV64-SAME: (<vscale x 4 x i64> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i64> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.vector.insert.nxv4i64.nxv2i64(<vscale x 4 x i64> [[DEST]], <vscale x 2 x i64> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
vuint64m4_t test_vset_v_u64m2_u64m4(vuint64m4_t dest, size_t index, vuint64m2_t val) {
  return __riscv_vset_v_u64m2_u64m4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i64> @test_vset_v_u64m1_u64m8
// CHECK-RV64-SAME: (<vscale x 8 x i64> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i64> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.vector.insert.nxv8i64.nxv1i64(<vscale x 8 x i64> [[DEST]], <vscale x 1 x i64> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
vuint64m8_t test_vset_v_u64m1_u64m8(vuint64m8_t dest, size_t index, vuint64m1_t val) {
  return __riscv_vset_v_u64m1_u64m8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i64> @test_vset_v_u64m2_u64m8
// CHECK-RV64-SAME: (<vscale x 8 x i64> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i64> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.vector.insert.nxv8i64.nxv2i64(<vscale x 8 x i64> [[DEST]], <vscale x 2 x i64> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
vuint64m8_t test_vset_v_u64m2_u64m8(vuint64m8_t dest, size_t index, vuint64m2_t val) {
  return __riscv_vset_v_u64m2_u64m8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i64> @test_vset_v_u64m4_u64m8
// CHECK-RV64-SAME: (<vscale x 8 x i64> [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i64> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.vector.insert.nxv8i64.nxv4i64(<vscale x 8 x i64> [[DEST]], <vscale x 4 x i64> [[VAL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
vuint64m8_t test_vset_v_u64m4_u64m8(vuint64m8_t dest, size_t index, vuint64m4_t val) {
  return __riscv_vset_v_u64m4_u64m8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @test_vset_v_f16mf4_f16mf4x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 2 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x half> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv2i8_2t.nxv1f16(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) [[DEST]], <vscale x 1 x half> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 2 x i8>, 2) [[TMP0]]
//
vfloat16mf4x2_t test_vset_v_f16mf4_f16mf4x2(vfloat16mf4x2_t dest, size_t index, vfloat16mf4_t val) {
  return __riscv_vset_v_f16mf4_f16mf4x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @test_vset_v_f16mf4_f16mf4x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 2 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x half> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv2i8_3t.nxv1f16(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) [[DEST]], <vscale x 1 x half> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 2 x i8>, 3) [[TMP0]]
//
vfloat16mf4x3_t test_vset_v_f16mf4_f16mf4x3(vfloat16mf4x3_t dest, size_t index, vfloat16mf4_t val) {
  return __riscv_vset_v_f16mf4_f16mf4x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @test_vset_v_f16mf4_f16mf4x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 2 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x half> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv2i8_4t.nxv1f16(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) [[DEST]], <vscale x 1 x half> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 2 x i8>, 4) [[TMP0]]
//
vfloat16mf4x4_t test_vset_v_f16mf4_f16mf4x4(vfloat16mf4x4_t dest, size_t index, vfloat16mf4_t val) {
  return __riscv_vset_v_f16mf4_f16mf4x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @test_vset_v_f16mf4_f16mf4x5
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 2 x i8>, 5) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x half> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv2i8_5t.nxv1f16(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) [[DEST]], <vscale x 1 x half> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 2 x i8>, 5) [[TMP0]]
//
vfloat16mf4x5_t test_vset_v_f16mf4_f16mf4x5(vfloat16mf4x5_t dest, size_t index, vfloat16mf4_t val) {
  return __riscv_vset_v_f16mf4_f16mf4x5(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @test_vset_v_f16mf4_f16mf4x6
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 2 x i8>, 6) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x half> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv2i8_6t.nxv1f16(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) [[DEST]], <vscale x 1 x half> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 2 x i8>, 6) [[TMP0]]
//
vfloat16mf4x6_t test_vset_v_f16mf4_f16mf4x6(vfloat16mf4x6_t dest, size_t index, vfloat16mf4_t val) {
  return __riscv_vset_v_f16mf4_f16mf4x6(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @test_vset_v_f16mf4_f16mf4x7
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 2 x i8>, 7) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x half> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv2i8_7t.nxv1f16(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) [[DEST]], <vscale x 1 x half> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 2 x i8>, 7) [[TMP0]]
//
vfloat16mf4x7_t test_vset_v_f16mf4_f16mf4x7(vfloat16mf4x7_t dest, size_t index, vfloat16mf4_t val) {
  return __riscv_vset_v_f16mf4_f16mf4x7(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @test_vset_v_f16mf4_f16mf4x8
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 2 x i8>, 8) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x half> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv2i8_8t.nxv1f16(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) [[DEST]], <vscale x 1 x half> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 2 x i8>, 8) [[TMP0]]
//
vfloat16mf4x8_t test_vset_v_f16mf4_f16mf4x8(vfloat16mf4x8_t dest, size_t index, vfloat16mf4_t val) {
  return __riscv_vset_v_f16mf4_f16mf4x8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @test_vset_v_f16mf2_f16mf2x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x half> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_2t.nxv2f16(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) [[DEST]], <vscale x 2 x half> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 2) [[TMP0]]
//
vfloat16mf2x2_t test_vset_v_f16mf2_f16mf2x2(vfloat16mf2x2_t dest, size_t index, vfloat16mf2_t val) {
  return __riscv_vset_v_f16mf2_f16mf2x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @test_vset_v_f16mf2_f16mf2x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x half> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_3t.nxv2f16(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) [[DEST]], <vscale x 2 x half> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 3) [[TMP0]]
//
vfloat16mf2x3_t test_vset_v_f16mf2_f16mf2x3(vfloat16mf2x3_t dest, size_t index, vfloat16mf2_t val) {
  return __riscv_vset_v_f16mf2_f16mf2x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @test_vset_v_f16mf2_f16mf2x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x half> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_4t.nxv2f16(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) [[DEST]], <vscale x 2 x half> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 4) [[TMP0]]
//
vfloat16mf2x4_t test_vset_v_f16mf2_f16mf2x4(vfloat16mf2x4_t dest, size_t index, vfloat16mf2_t val) {
  return __riscv_vset_v_f16mf2_f16mf2x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @test_vset_v_f16mf2_f16mf2x5
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 5) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x half> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_5t.nxv2f16(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) [[DEST]], <vscale x 2 x half> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 5) [[TMP0]]
//
vfloat16mf2x5_t test_vset_v_f16mf2_f16mf2x5(vfloat16mf2x5_t dest, size_t index, vfloat16mf2_t val) {
  return __riscv_vset_v_f16mf2_f16mf2x5(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @test_vset_v_f16mf2_f16mf2x6
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 6) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x half> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_6t.nxv2f16(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) [[DEST]], <vscale x 2 x half> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 6) [[TMP0]]
//
vfloat16mf2x6_t test_vset_v_f16mf2_f16mf2x6(vfloat16mf2x6_t dest, size_t index, vfloat16mf2_t val) {
  return __riscv_vset_v_f16mf2_f16mf2x6(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @test_vset_v_f16mf2_f16mf2x7
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 7) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x half> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_7t.nxv2f16(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) [[DEST]], <vscale x 2 x half> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 7) [[TMP0]]
//
vfloat16mf2x7_t test_vset_v_f16mf2_f16mf2x7(vfloat16mf2x7_t dest, size_t index, vfloat16mf2_t val) {
  return __riscv_vset_v_f16mf2_f16mf2x7(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @test_vset_v_f16mf2_f16mf2x8
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 8) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x half> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_8t.nxv2f16(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) [[DEST]], <vscale x 2 x half> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 8) [[TMP0]]
//
vfloat16mf2x8_t test_vset_v_f16mf2_f16mf2x8(vfloat16mf2x8_t dest, size_t index, vfloat16mf2_t val) {
  return __riscv_vset_v_f16mf2_f16mf2x8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @test_vset_v_f16m1_f16m1x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x half> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_2t.nxv4f16(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) [[DEST]], <vscale x 4 x half> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 2) [[TMP0]]
//
vfloat16m1x2_t test_vset_v_f16m1_f16m1x2(vfloat16m1x2_t dest, size_t index, vfloat16m1_t val) {
  return __riscv_vset_v_f16m1_f16m1x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @test_vset_v_f16m1_f16m1x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x half> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_3t.nxv4f16(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) [[DEST]], <vscale x 4 x half> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 3) [[TMP0]]
//
vfloat16m1x3_t test_vset_v_f16m1_f16m1x3(vfloat16m1x3_t dest, size_t index, vfloat16m1_t val) {
  return __riscv_vset_v_f16m1_f16m1x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @test_vset_v_f16m1_f16m1x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x half> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_4t.nxv4f16(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[DEST]], <vscale x 4 x half> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[TMP0]]
//
vfloat16m1x4_t test_vset_v_f16m1_f16m1x4(vfloat16m1x4_t dest, size_t index, vfloat16m1_t val) {
  return __riscv_vset_v_f16m1_f16m1x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @test_vset_v_f16m1_f16m1x5
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 5) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x half> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_5t.nxv4f16(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) [[DEST]], <vscale x 4 x half> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 5) [[TMP0]]
//
vfloat16m1x5_t test_vset_v_f16m1_f16m1x5(vfloat16m1x5_t dest, size_t index, vfloat16m1_t val) {
  return __riscv_vset_v_f16m1_f16m1x5(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @test_vset_v_f16m1_f16m1x6
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 6) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x half> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_6t.nxv4f16(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) [[DEST]], <vscale x 4 x half> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 6) [[TMP0]]
//
vfloat16m1x6_t test_vset_v_f16m1_f16m1x6(vfloat16m1x6_t dest, size_t index, vfloat16m1_t val) {
  return __riscv_vset_v_f16m1_f16m1x6(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @test_vset_v_f16m1_f16m1x7
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 7) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x half> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_7t.nxv4f16(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) [[DEST]], <vscale x 4 x half> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 7) [[TMP0]]
//
vfloat16m1x7_t test_vset_v_f16m1_f16m1x7(vfloat16m1x7_t dest, size_t index, vfloat16m1_t val) {
  return __riscv_vset_v_f16m1_f16m1x7(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @test_vset_v_f16m1_f16m1x8
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 8) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x half> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_8t.nxv4f16(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) [[DEST]], <vscale x 4 x half> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 8) [[TMP0]]
//
vfloat16m1x8_t test_vset_v_f16m1_f16m1x8(vfloat16m1x8_t dest, size_t index, vfloat16m1_t val) {
  return __riscv_vset_v_f16m1_f16m1x8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @test_vset_v_f16m2_f16m2x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 16 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x half> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv16i8_2t.nxv8f16(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) [[DEST]], <vscale x 8 x half> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 16 x i8>, 2) [[TMP0]]
//
vfloat16m2x2_t test_vset_v_f16m2_f16m2x2(vfloat16m2x2_t dest, size_t index, vfloat16m2_t val) {
  return __riscv_vset_v_f16m2_f16m2x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @test_vset_v_f16m2_f16m2x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 16 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x half> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv16i8_3t.nxv8f16(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) [[DEST]], <vscale x 8 x half> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 16 x i8>, 3) [[TMP0]]
//
vfloat16m2x3_t test_vset_v_f16m2_f16m2x3(vfloat16m2x3_t dest, size_t index, vfloat16m2_t val) {
  return __riscv_vset_v_f16m2_f16m2x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @test_vset_v_f16m2_f16m2x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x half> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv16i8_4t.nxv8f16(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[DEST]], <vscale x 8 x half> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[TMP0]]
//
vfloat16m2x4_t test_vset_v_f16m2_f16m2x4(vfloat16m2x4_t dest, size_t index, vfloat16m2_t val) {
  return __riscv_vset_v_f16m2_f16m2x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @test_vset_v_f16m4_f16m4x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 32 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 16 x half> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv32i8_2t.nxv16f16(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) [[DEST]], <vscale x 16 x half> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 32 x i8>, 2) [[TMP0]]
//
vfloat16m4x2_t test_vset_v_f16m4_f16m4x2(vfloat16m4x2_t dest, size_t index, vfloat16m4_t val) {
  return __riscv_vset_v_f16m4_f16m4x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @test_vset_v_f32mf2_f32mf2x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x float> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_2t.nxv1f32(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) [[DEST]], <vscale x 1 x float> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 2) [[TMP0]]
//
vfloat32mf2x2_t test_vset_v_f32mf2_f32mf2x2(vfloat32mf2x2_t dest, size_t index, vfloat32mf2_t val) {
  return __riscv_vset_v_f32mf2_f32mf2x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @test_vset_v_f32mf2_f32mf2x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x float> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_3t.nxv1f32(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) [[DEST]], <vscale x 1 x float> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 3) [[TMP0]]
//
vfloat32mf2x3_t test_vset_v_f32mf2_f32mf2x3(vfloat32mf2x3_t dest, size_t index, vfloat32mf2_t val) {
  return __riscv_vset_v_f32mf2_f32mf2x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @test_vset_v_f32mf2_f32mf2x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x float> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_4t.nxv1f32(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) [[DEST]], <vscale x 1 x float> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 4) [[TMP0]]
//
vfloat32mf2x4_t test_vset_v_f32mf2_f32mf2x4(vfloat32mf2x4_t dest, size_t index, vfloat32mf2_t val) {
  return __riscv_vset_v_f32mf2_f32mf2x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @test_vset_v_f32mf2_f32mf2x5
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 5) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x float> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_5t.nxv1f32(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) [[DEST]], <vscale x 1 x float> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 5) [[TMP0]]
//
vfloat32mf2x5_t test_vset_v_f32mf2_f32mf2x5(vfloat32mf2x5_t dest, size_t index, vfloat32mf2_t val) {
  return __riscv_vset_v_f32mf2_f32mf2x5(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @test_vset_v_f32mf2_f32mf2x6
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 6) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x float> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_6t.nxv1f32(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) [[DEST]], <vscale x 1 x float> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 6) [[TMP0]]
//
vfloat32mf2x6_t test_vset_v_f32mf2_f32mf2x6(vfloat32mf2x6_t dest, size_t index, vfloat32mf2_t val) {
  return __riscv_vset_v_f32mf2_f32mf2x6(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @test_vset_v_f32mf2_f32mf2x7
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 7) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x float> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_7t.nxv1f32(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) [[DEST]], <vscale x 1 x float> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 7) [[TMP0]]
//
vfloat32mf2x7_t test_vset_v_f32mf2_f32mf2x7(vfloat32mf2x7_t dest, size_t index, vfloat32mf2_t val) {
  return __riscv_vset_v_f32mf2_f32mf2x7(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @test_vset_v_f32mf2_f32mf2x8
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 8) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x float> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_8t.nxv1f32(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) [[DEST]], <vscale x 1 x float> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 8) [[TMP0]]
//
vfloat32mf2x8_t test_vset_v_f32mf2_f32mf2x8(vfloat32mf2x8_t dest, size_t index, vfloat32mf2_t val) {
  return __riscv_vset_v_f32mf2_f32mf2x8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @test_vset_v_f32m1_f32m1x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x float> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_2t.nxv2f32(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) [[DEST]], <vscale x 2 x float> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 2) [[TMP0]]
//
vfloat32m1x2_t test_vset_v_f32m1_f32m1x2(vfloat32m1x2_t dest, size_t index, vfloat32m1_t val) {
  return __riscv_vset_v_f32m1_f32m1x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @test_vset_v_f32m1_f32m1x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x float> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_3t.nxv2f32(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) [[DEST]], <vscale x 2 x float> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 3) [[TMP0]]
//
vfloat32m1x3_t test_vset_v_f32m1_f32m1x3(vfloat32m1x3_t dest, size_t index, vfloat32m1_t val) {
  return __riscv_vset_v_f32m1_f32m1x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @test_vset_v_f32m1_f32m1x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x float> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_4t.nxv2f32(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[DEST]], <vscale x 2 x float> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[TMP0]]
//
vfloat32m1x4_t test_vset_v_f32m1_f32m1x4(vfloat32m1x4_t dest, size_t index, vfloat32m1_t val) {
  return __riscv_vset_v_f32m1_f32m1x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @test_vset_v_f32m1_f32m1x5
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 5) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x float> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_5t.nxv2f32(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) [[DEST]], <vscale x 2 x float> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 5) [[TMP0]]
//
vfloat32m1x5_t test_vset_v_f32m1_f32m1x5(vfloat32m1x5_t dest, size_t index, vfloat32m1_t val) {
  return __riscv_vset_v_f32m1_f32m1x5(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @test_vset_v_f32m1_f32m1x6
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 6) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x float> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_6t.nxv2f32(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) [[DEST]], <vscale x 2 x float> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 6) [[TMP0]]
//
vfloat32m1x6_t test_vset_v_f32m1_f32m1x6(vfloat32m1x6_t dest, size_t index, vfloat32m1_t val) {
  return __riscv_vset_v_f32m1_f32m1x6(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @test_vset_v_f32m1_f32m1x7
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 7) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x float> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_7t.nxv2f32(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) [[DEST]], <vscale x 2 x float> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 7) [[TMP0]]
//
vfloat32m1x7_t test_vset_v_f32m1_f32m1x7(vfloat32m1x7_t dest, size_t index, vfloat32m1_t val) {
  return __riscv_vset_v_f32m1_f32m1x7(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @test_vset_v_f32m1_f32m1x8
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 8) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x float> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_8t.nxv2f32(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) [[DEST]], <vscale x 2 x float> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 8) [[TMP0]]
//
vfloat32m1x8_t test_vset_v_f32m1_f32m1x8(vfloat32m1x8_t dest, size_t index, vfloat32m1_t val) {
  return __riscv_vset_v_f32m1_f32m1x8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @test_vset_v_f32m2_f32m2x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 16 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x float> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv16i8_2t.nxv4f32(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) [[DEST]], <vscale x 4 x float> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 16 x i8>, 2) [[TMP0]]
//
vfloat32m2x2_t test_vset_v_f32m2_f32m2x2(vfloat32m2x2_t dest, size_t index, vfloat32m2_t val) {
  return __riscv_vset_v_f32m2_f32m2x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @test_vset_v_f32m2_f32m2x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 16 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x float> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv16i8_3t.nxv4f32(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) [[DEST]], <vscale x 4 x float> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 16 x i8>, 3) [[TMP0]]
//
vfloat32m2x3_t test_vset_v_f32m2_f32m2x3(vfloat32m2x3_t dest, size_t index, vfloat32m2_t val) {
  return __riscv_vset_v_f32m2_f32m2x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @test_vset_v_f32m2_f32m2x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x float> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv16i8_4t.nxv4f32(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[DEST]], <vscale x 4 x float> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[TMP0]]
//
vfloat32m2x4_t test_vset_v_f32m2_f32m2x4(vfloat32m2x4_t dest, size_t index, vfloat32m2_t val) {
  return __riscv_vset_v_f32m2_f32m2x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @test_vset_v_f32m4_f32m4x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 32 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x float> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv32i8_2t.nxv8f32(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) [[DEST]], <vscale x 8 x float> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 32 x i8>, 2) [[TMP0]]
//
vfloat32m4x2_t test_vset_v_f32m4_f32m4x2(vfloat32m4x2_t dest, size_t index, vfloat32m4_t val) {
  return __riscv_vset_v_f32m4_f32m4x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @test_vset_v_f64m1_f64m1x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x double> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_2t.nxv1f64(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) [[DEST]], <vscale x 1 x double> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 2) [[TMP0]]
//
vfloat64m1x2_t test_vset_v_f64m1_f64m1x2(vfloat64m1x2_t dest, size_t index, vfloat64m1_t val) {
  return __riscv_vset_v_f64m1_f64m1x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @test_vset_v_f64m1_f64m1x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x double> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_3t.nxv1f64(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) [[DEST]], <vscale x 1 x double> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 3) [[TMP0]]
//
vfloat64m1x3_t test_vset_v_f64m1_f64m1x3(vfloat64m1x3_t dest, size_t index, vfloat64m1_t val) {
  return __riscv_vset_v_f64m1_f64m1x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @test_vset_v_f64m1_f64m1x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x double> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_4t.nxv1f64(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[DEST]], <vscale x 1 x double> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[TMP0]]
//
vfloat64m1x4_t test_vset_v_f64m1_f64m1x4(vfloat64m1x4_t dest, size_t index, vfloat64m1_t val) {
  return __riscv_vset_v_f64m1_f64m1x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @test_vset_v_f64m1_f64m1x5
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 5) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x double> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_5t.nxv1f64(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) [[DEST]], <vscale x 1 x double> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 5) [[TMP0]]
//
vfloat64m1x5_t test_vset_v_f64m1_f64m1x5(vfloat64m1x5_t dest, size_t index, vfloat64m1_t val) {
  return __riscv_vset_v_f64m1_f64m1x5(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @test_vset_v_f64m1_f64m1x6
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 6) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x double> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_6t.nxv1f64(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) [[DEST]], <vscale x 1 x double> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 6) [[TMP0]]
//
vfloat64m1x6_t test_vset_v_f64m1_f64m1x6(vfloat64m1x6_t dest, size_t index, vfloat64m1_t val) {
  return __riscv_vset_v_f64m1_f64m1x6(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @test_vset_v_f64m1_f64m1x7
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 7) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x double> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_7t.nxv1f64(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) [[DEST]], <vscale x 1 x double> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 7) [[TMP0]]
//
vfloat64m1x7_t test_vset_v_f64m1_f64m1x7(vfloat64m1x7_t dest, size_t index, vfloat64m1_t val) {
  return __riscv_vset_v_f64m1_f64m1x7(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @test_vset_v_f64m1_f64m1x8
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 8) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x double> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_8t.nxv1f64(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) [[DEST]], <vscale x 1 x double> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 8) [[TMP0]]
//
vfloat64m1x8_t test_vset_v_f64m1_f64m1x8(vfloat64m1x8_t dest, size_t index, vfloat64m1_t val) {
  return __riscv_vset_v_f64m1_f64m1x8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @test_vset_v_f64m2_f64m2x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 16 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x double> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv16i8_2t.nxv2f64(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) [[DEST]], <vscale x 2 x double> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 16 x i8>, 2) [[TMP0]]
//
vfloat64m2x2_t test_vset_v_f64m2_f64m2x2(vfloat64m2x2_t dest, size_t index, vfloat64m2_t val) {
  return __riscv_vset_v_f64m2_f64m2x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @test_vset_v_f64m2_f64m2x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 16 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x double> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv16i8_3t.nxv2f64(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) [[DEST]], <vscale x 2 x double> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 16 x i8>, 3) [[TMP0]]
//
vfloat64m2x3_t test_vset_v_f64m2_f64m2x3(vfloat64m2x3_t dest, size_t index, vfloat64m2_t val) {
  return __riscv_vset_v_f64m2_f64m2x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @test_vset_v_f64m2_f64m2x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x double> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv16i8_4t.nxv2f64(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[DEST]], <vscale x 2 x double> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[TMP0]]
//
vfloat64m2x4_t test_vset_v_f64m2_f64m2x4(vfloat64m2x4_t dest, size_t index, vfloat64m2_t val) {
  return __riscv_vset_v_f64m2_f64m2x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @test_vset_v_f64m4_f64m4x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 32 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x double> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv32i8_2t.nxv4f64(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) [[DEST]], <vscale x 4 x double> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 32 x i8>, 2) [[TMP0]]
//
vfloat64m4x2_t test_vset_v_f64m4_f64m4x2(vfloat64m4x2_t dest, size_t index, vfloat64m4_t val) {
  return __riscv_vset_v_f64m4_f64m4x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 1 x i8>, 2) @test_vset_v_i8mf8_i8mf8x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 1 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 1 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv1i8_2t.nxv1i8(target("riscv.vector.tuple", <vscale x 1 x i8>, 2) [[DEST]], <vscale x 1 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 1 x i8>, 2) [[TMP0]]
//
vint8mf8x2_t test_vset_v_i8mf8_i8mf8x2(vint8mf8x2_t dest, size_t index, vint8mf8_t val) {
  return __riscv_vset_v_i8mf8_i8mf8x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 1 x i8>, 3) @test_vset_v_i8mf8_i8mf8x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 1 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 1 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv1i8_3t.nxv1i8(target("riscv.vector.tuple", <vscale x 1 x i8>, 3) [[DEST]], <vscale x 1 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 1 x i8>, 3) [[TMP0]]
//
vint8mf8x3_t test_vset_v_i8mf8_i8mf8x3(vint8mf8x3_t dest, size_t index, vint8mf8_t val) {
  return __riscv_vset_v_i8mf8_i8mf8x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 1 x i8>, 4) @test_vset_v_i8mf8_i8mf8x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 1 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 1 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv1i8_4t.nxv1i8(target("riscv.vector.tuple", <vscale x 1 x i8>, 4) [[DEST]], <vscale x 1 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 1 x i8>, 4) [[TMP0]]
//
vint8mf8x4_t test_vset_v_i8mf8_i8mf8x4(vint8mf8x4_t dest, size_t index, vint8mf8_t val) {
  return __riscv_vset_v_i8mf8_i8mf8x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 1 x i8>, 5) @test_vset_v_i8mf8_i8mf8x5
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 1 x i8>, 5) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 1 x i8>, 5) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv1i8_5t.nxv1i8(target("riscv.vector.tuple", <vscale x 1 x i8>, 5) [[DEST]], <vscale x 1 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 1 x i8>, 5) [[TMP0]]
//
vint8mf8x5_t test_vset_v_i8mf8_i8mf8x5(vint8mf8x5_t dest, size_t index, vint8mf8_t val) {
  return __riscv_vset_v_i8mf8_i8mf8x5(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 1 x i8>, 6) @test_vset_v_i8mf8_i8mf8x6
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 1 x i8>, 6) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 1 x i8>, 6) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv1i8_6t.nxv1i8(target("riscv.vector.tuple", <vscale x 1 x i8>, 6) [[DEST]], <vscale x 1 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 1 x i8>, 6) [[TMP0]]
//
vint8mf8x6_t test_vset_v_i8mf8_i8mf8x6(vint8mf8x6_t dest, size_t index, vint8mf8_t val) {
  return __riscv_vset_v_i8mf8_i8mf8x6(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 1 x i8>, 7) @test_vset_v_i8mf8_i8mf8x7
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 1 x i8>, 7) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 1 x i8>, 7) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv1i8_7t.nxv1i8(target("riscv.vector.tuple", <vscale x 1 x i8>, 7) [[DEST]], <vscale x 1 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 1 x i8>, 7) [[TMP0]]
//
vint8mf8x7_t test_vset_v_i8mf8_i8mf8x7(vint8mf8x7_t dest, size_t index, vint8mf8_t val) {
  return __riscv_vset_v_i8mf8_i8mf8x7(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 1 x i8>, 8) @test_vset_v_i8mf8_i8mf8x8
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 1 x i8>, 8) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 1 x i8>, 8) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv1i8_8t.nxv1i8(target("riscv.vector.tuple", <vscale x 1 x i8>, 8) [[DEST]], <vscale x 1 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 1 x i8>, 8) [[TMP0]]
//
vint8mf8x8_t test_vset_v_i8mf8_i8mf8x8(vint8mf8x8_t dest, size_t index, vint8mf8_t val) {
  return __riscv_vset_v_i8mf8_i8mf8x8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @test_vset_v_i8mf4_i8mf4x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 2 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv2i8_2t.nxv2i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) [[DEST]], <vscale x 2 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 2 x i8>, 2) [[TMP0]]
//
vint8mf4x2_t test_vset_v_i8mf4_i8mf4x2(vint8mf4x2_t dest, size_t index, vint8mf4_t val) {
  return __riscv_vset_v_i8mf4_i8mf4x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @test_vset_v_i8mf4_i8mf4x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 2 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv2i8_3t.nxv2i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) [[DEST]], <vscale x 2 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 2 x i8>, 3) [[TMP0]]
//
vint8mf4x3_t test_vset_v_i8mf4_i8mf4x3(vint8mf4x3_t dest, size_t index, vint8mf4_t val) {
  return __riscv_vset_v_i8mf4_i8mf4x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @test_vset_v_i8mf4_i8mf4x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 2 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv2i8_4t.nxv2i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) [[DEST]], <vscale x 2 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 2 x i8>, 4) [[TMP0]]
//
vint8mf4x4_t test_vset_v_i8mf4_i8mf4x4(vint8mf4x4_t dest, size_t index, vint8mf4_t val) {
  return __riscv_vset_v_i8mf4_i8mf4x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @test_vset_v_i8mf4_i8mf4x5
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 2 x i8>, 5) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv2i8_5t.nxv2i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) [[DEST]], <vscale x 2 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 2 x i8>, 5) [[TMP0]]
//
vint8mf4x5_t test_vset_v_i8mf4_i8mf4x5(vint8mf4x5_t dest, size_t index, vint8mf4_t val) {
  return __riscv_vset_v_i8mf4_i8mf4x5(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @test_vset_v_i8mf4_i8mf4x6
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 2 x i8>, 6) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv2i8_6t.nxv2i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) [[DEST]], <vscale x 2 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 2 x i8>, 6) [[TMP0]]
//
vint8mf4x6_t test_vset_v_i8mf4_i8mf4x6(vint8mf4x6_t dest, size_t index, vint8mf4_t val) {
  return __riscv_vset_v_i8mf4_i8mf4x6(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @test_vset_v_i8mf4_i8mf4x7
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 2 x i8>, 7) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv2i8_7t.nxv2i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) [[DEST]], <vscale x 2 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 2 x i8>, 7) [[TMP0]]
//
vint8mf4x7_t test_vset_v_i8mf4_i8mf4x7(vint8mf4x7_t dest, size_t index, vint8mf4_t val) {
  return __riscv_vset_v_i8mf4_i8mf4x7(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @test_vset_v_i8mf4_i8mf4x8
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 2 x i8>, 8) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv2i8_8t.nxv2i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) [[DEST]], <vscale x 2 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 2 x i8>, 8) [[TMP0]]
//
vint8mf4x8_t test_vset_v_i8mf4_i8mf4x8(vint8mf4x8_t dest, size_t index, vint8mf4_t val) {
  return __riscv_vset_v_i8mf4_i8mf4x8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @test_vset_v_i8mf2_i8mf2x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_2t.nxv4i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) [[DEST]], <vscale x 4 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 2) [[TMP0]]
//
vint8mf2x2_t test_vset_v_i8mf2_i8mf2x2(vint8mf2x2_t dest, size_t index, vint8mf2_t val) {
  return __riscv_vset_v_i8mf2_i8mf2x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @test_vset_v_i8mf2_i8mf2x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_3t.nxv4i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) [[DEST]], <vscale x 4 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 3) [[TMP0]]
//
vint8mf2x3_t test_vset_v_i8mf2_i8mf2x3(vint8mf2x3_t dest, size_t index, vint8mf2_t val) {
  return __riscv_vset_v_i8mf2_i8mf2x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @test_vset_v_i8mf2_i8mf2x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_4t.nxv4i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) [[DEST]], <vscale x 4 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 4) [[TMP0]]
//
vint8mf2x4_t test_vset_v_i8mf2_i8mf2x4(vint8mf2x4_t dest, size_t index, vint8mf2_t val) {
  return __riscv_vset_v_i8mf2_i8mf2x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @test_vset_v_i8mf2_i8mf2x5
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 5) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_5t.nxv4i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) [[DEST]], <vscale x 4 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 5) [[TMP0]]
//
vint8mf2x5_t test_vset_v_i8mf2_i8mf2x5(vint8mf2x5_t dest, size_t index, vint8mf2_t val) {
  return __riscv_vset_v_i8mf2_i8mf2x5(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @test_vset_v_i8mf2_i8mf2x6
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 6) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_6t.nxv4i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) [[DEST]], <vscale x 4 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 6) [[TMP0]]
//
vint8mf2x6_t test_vset_v_i8mf2_i8mf2x6(vint8mf2x6_t dest, size_t index, vint8mf2_t val) {
  return __riscv_vset_v_i8mf2_i8mf2x6(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @test_vset_v_i8mf2_i8mf2x7
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 7) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_7t.nxv4i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) [[DEST]], <vscale x 4 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 7) [[TMP0]]
//
vint8mf2x7_t test_vset_v_i8mf2_i8mf2x7(vint8mf2x7_t dest, size_t index, vint8mf2_t val) {
  return __riscv_vset_v_i8mf2_i8mf2x7(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @test_vset_v_i8mf2_i8mf2x8
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 8) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_8t.nxv4i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) [[DEST]], <vscale x 4 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 8) [[TMP0]]
//
vint8mf2x8_t test_vset_v_i8mf2_i8mf2x8(vint8mf2x8_t dest, size_t index, vint8mf2_t val) {
  return __riscv_vset_v_i8mf2_i8mf2x8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @test_vset_v_i8m1_i8m1x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_2t.nxv8i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) [[DEST]], <vscale x 8 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 2) [[TMP0]]
//
vint8m1x2_t test_vset_v_i8m1_i8m1x2(vint8m1x2_t dest, size_t index, vint8m1_t val) {
  return __riscv_vset_v_i8m1_i8m1x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @test_vset_v_i8m1_i8m1x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_3t.nxv8i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) [[DEST]], <vscale x 8 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 3) [[TMP0]]
//
vint8m1x3_t test_vset_v_i8m1_i8m1x3(vint8m1x3_t dest, size_t index, vint8m1_t val) {
  return __riscv_vset_v_i8m1_i8m1x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @test_vset_v_i8m1_i8m1x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_4t.nxv8i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[DEST]], <vscale x 8 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[TMP0]]
//
vint8m1x4_t test_vset_v_i8m1_i8m1x4(vint8m1x4_t dest, size_t index, vint8m1_t val) {
  return __riscv_vset_v_i8m1_i8m1x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @test_vset_v_i8m1_i8m1x5
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 5) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_5t.nxv8i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) [[DEST]], <vscale x 8 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 5) [[TMP0]]
//
vint8m1x5_t test_vset_v_i8m1_i8m1x5(vint8m1x5_t dest, size_t index, vint8m1_t val) {
  return __riscv_vset_v_i8m1_i8m1x5(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @test_vset_v_i8m1_i8m1x6
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 6) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_6t.nxv8i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) [[DEST]], <vscale x 8 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 6) [[TMP0]]
//
vint8m1x6_t test_vset_v_i8m1_i8m1x6(vint8m1x6_t dest, size_t index, vint8m1_t val) {
  return __riscv_vset_v_i8m1_i8m1x6(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @test_vset_v_i8m1_i8m1x7
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 7) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_7t.nxv8i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) [[DEST]], <vscale x 8 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 7) [[TMP0]]
//
vint8m1x7_t test_vset_v_i8m1_i8m1x7(vint8m1x7_t dest, size_t index, vint8m1_t val) {
  return __riscv_vset_v_i8m1_i8m1x7(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @test_vset_v_i8m1_i8m1x8
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 8) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_8t.nxv8i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) [[DEST]], <vscale x 8 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 8) [[TMP0]]
//
vint8m1x8_t test_vset_v_i8m1_i8m1x8(vint8m1x8_t dest, size_t index, vint8m1_t val) {
  return __riscv_vset_v_i8m1_i8m1x8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @test_vset_v_i8m2_i8m2x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 16 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 16 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv16i8_2t.nxv16i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) [[DEST]], <vscale x 16 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 16 x i8>, 2) [[TMP0]]
//
vint8m2x2_t test_vset_v_i8m2_i8m2x2(vint8m2x2_t dest, size_t index, vint8m2_t val) {
  return __riscv_vset_v_i8m2_i8m2x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @test_vset_v_i8m2_i8m2x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 16 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 16 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv16i8_3t.nxv16i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) [[DEST]], <vscale x 16 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 16 x i8>, 3) [[TMP0]]
//
vint8m2x3_t test_vset_v_i8m2_i8m2x3(vint8m2x3_t dest, size_t index, vint8m2_t val) {
  return __riscv_vset_v_i8m2_i8m2x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @test_vset_v_i8m2_i8m2x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 16 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv16i8_4t.nxv16i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[DEST]], <vscale x 16 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[TMP0]]
//
vint8m2x4_t test_vset_v_i8m2_i8m2x4(vint8m2x4_t dest, size_t index, vint8m2_t val) {
  return __riscv_vset_v_i8m2_i8m2x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @test_vset_v_i8m4_i8m4x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 32 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 32 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv32i8_2t.nxv32i8(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) [[DEST]], <vscale x 32 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 32 x i8>, 2) [[TMP0]]
//
vint8m4x2_t test_vset_v_i8m4_i8m4x2(vint8m4x2_t dest, size_t index, vint8m4_t val) {
  return __riscv_vset_v_i8m4_i8m4x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @test_vset_v_i16mf4_i16mf4x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 2 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv2i8_2t.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) [[DEST]], <vscale x 1 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 2 x i8>, 2) [[TMP0]]
//
vint16mf4x2_t test_vset_v_i16mf4_i16mf4x2(vint16mf4x2_t dest, size_t index, vint16mf4_t val) {
  return __riscv_vset_v_i16mf4_i16mf4x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @test_vset_v_i16mf4_i16mf4x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 2 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv2i8_3t.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) [[DEST]], <vscale x 1 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 2 x i8>, 3) [[TMP0]]
//
vint16mf4x3_t test_vset_v_i16mf4_i16mf4x3(vint16mf4x3_t dest, size_t index, vint16mf4_t val) {
  return __riscv_vset_v_i16mf4_i16mf4x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @test_vset_v_i16mf4_i16mf4x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 2 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv2i8_4t.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) [[DEST]], <vscale x 1 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 2 x i8>, 4) [[TMP0]]
//
vint16mf4x4_t test_vset_v_i16mf4_i16mf4x4(vint16mf4x4_t dest, size_t index, vint16mf4_t val) {
  return __riscv_vset_v_i16mf4_i16mf4x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @test_vset_v_i16mf4_i16mf4x5
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 2 x i8>, 5) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv2i8_5t.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) [[DEST]], <vscale x 1 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 2 x i8>, 5) [[TMP0]]
//
vint16mf4x5_t test_vset_v_i16mf4_i16mf4x5(vint16mf4x5_t dest, size_t index, vint16mf4_t val) {
  return __riscv_vset_v_i16mf4_i16mf4x5(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @test_vset_v_i16mf4_i16mf4x6
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 2 x i8>, 6) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv2i8_6t.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) [[DEST]], <vscale x 1 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 2 x i8>, 6) [[TMP0]]
//
vint16mf4x6_t test_vset_v_i16mf4_i16mf4x6(vint16mf4x6_t dest, size_t index, vint16mf4_t val) {
  return __riscv_vset_v_i16mf4_i16mf4x6(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @test_vset_v_i16mf4_i16mf4x7
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 2 x i8>, 7) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv2i8_7t.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) [[DEST]], <vscale x 1 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 2 x i8>, 7) [[TMP0]]
//
vint16mf4x7_t test_vset_v_i16mf4_i16mf4x7(vint16mf4x7_t dest, size_t index, vint16mf4_t val) {
  return __riscv_vset_v_i16mf4_i16mf4x7(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @test_vset_v_i16mf4_i16mf4x8
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 2 x i8>, 8) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv2i8_8t.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) [[DEST]], <vscale x 1 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 2 x i8>, 8) [[TMP0]]
//
vint16mf4x8_t test_vset_v_i16mf4_i16mf4x8(vint16mf4x8_t dest, size_t index, vint16mf4_t val) {
  return __riscv_vset_v_i16mf4_i16mf4x8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @test_vset_v_i16mf2_i16mf2x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_2t.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) [[DEST]], <vscale x 2 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 2) [[TMP0]]
//
vint16mf2x2_t test_vset_v_i16mf2_i16mf2x2(vint16mf2x2_t dest, size_t index, vint16mf2_t val) {
  return __riscv_vset_v_i16mf2_i16mf2x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @test_vset_v_i16mf2_i16mf2x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_3t.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) [[DEST]], <vscale x 2 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 3) [[TMP0]]
//
vint16mf2x3_t test_vset_v_i16mf2_i16mf2x3(vint16mf2x3_t dest, size_t index, vint16mf2_t val) {
  return __riscv_vset_v_i16mf2_i16mf2x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @test_vset_v_i16mf2_i16mf2x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_4t.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) [[DEST]], <vscale x 2 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 4) [[TMP0]]
//
vint16mf2x4_t test_vset_v_i16mf2_i16mf2x4(vint16mf2x4_t dest, size_t index, vint16mf2_t val) {
  return __riscv_vset_v_i16mf2_i16mf2x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @test_vset_v_i16mf2_i16mf2x5
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 5) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_5t.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) [[DEST]], <vscale x 2 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 5) [[TMP0]]
//
vint16mf2x5_t test_vset_v_i16mf2_i16mf2x5(vint16mf2x5_t dest, size_t index, vint16mf2_t val) {
  return __riscv_vset_v_i16mf2_i16mf2x5(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @test_vset_v_i16mf2_i16mf2x6
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 6) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_6t.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) [[DEST]], <vscale x 2 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 6) [[TMP0]]
//
vint16mf2x6_t test_vset_v_i16mf2_i16mf2x6(vint16mf2x6_t dest, size_t index, vint16mf2_t val) {
  return __riscv_vset_v_i16mf2_i16mf2x6(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @test_vset_v_i16mf2_i16mf2x7
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 7) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_7t.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) [[DEST]], <vscale x 2 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 7) [[TMP0]]
//
vint16mf2x7_t test_vset_v_i16mf2_i16mf2x7(vint16mf2x7_t dest, size_t index, vint16mf2_t val) {
  return __riscv_vset_v_i16mf2_i16mf2x7(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @test_vset_v_i16mf2_i16mf2x8
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 8) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_8t.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) [[DEST]], <vscale x 2 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 8) [[TMP0]]
//
vint16mf2x8_t test_vset_v_i16mf2_i16mf2x8(vint16mf2x8_t dest, size_t index, vint16mf2_t val) {
  return __riscv_vset_v_i16mf2_i16mf2x8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @test_vset_v_i16m1_i16m1x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_2t.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) [[DEST]], <vscale x 4 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 2) [[TMP0]]
//
vint16m1x2_t test_vset_v_i16m1_i16m1x2(vint16m1x2_t dest, size_t index, vint16m1_t val) {
  return __riscv_vset_v_i16m1_i16m1x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @test_vset_v_i16m1_i16m1x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_3t.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) [[DEST]], <vscale x 4 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 3) [[TMP0]]
//
vint16m1x3_t test_vset_v_i16m1_i16m1x3(vint16m1x3_t dest, size_t index, vint16m1_t val) {
  return __riscv_vset_v_i16m1_i16m1x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @test_vset_v_i16m1_i16m1x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_4t.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[DEST]], <vscale x 4 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[TMP0]]
//
vint16m1x4_t test_vset_v_i16m1_i16m1x4(vint16m1x4_t dest, size_t index, vint16m1_t val) {
  return __riscv_vset_v_i16m1_i16m1x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @test_vset_v_i16m1_i16m1x5
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 5) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_5t.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) [[DEST]], <vscale x 4 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 5) [[TMP0]]
//
vint16m1x5_t test_vset_v_i16m1_i16m1x5(vint16m1x5_t dest, size_t index, vint16m1_t val) {
  return __riscv_vset_v_i16m1_i16m1x5(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @test_vset_v_i16m1_i16m1x6
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 6) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_6t.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) [[DEST]], <vscale x 4 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 6) [[TMP0]]
//
vint16m1x6_t test_vset_v_i16m1_i16m1x6(vint16m1x6_t dest, size_t index, vint16m1_t val) {
  return __riscv_vset_v_i16m1_i16m1x6(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @test_vset_v_i16m1_i16m1x7
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 7) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_7t.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) [[DEST]], <vscale x 4 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 7) [[TMP0]]
//
vint16m1x7_t test_vset_v_i16m1_i16m1x7(vint16m1x7_t dest, size_t index, vint16m1_t val) {
  return __riscv_vset_v_i16m1_i16m1x7(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @test_vset_v_i16m1_i16m1x8
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 8) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_8t.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) [[DEST]], <vscale x 4 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 8) [[TMP0]]
//
vint16m1x8_t test_vset_v_i16m1_i16m1x8(vint16m1x8_t dest, size_t index, vint16m1_t val) {
  return __riscv_vset_v_i16m1_i16m1x8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @test_vset_v_i16m2_i16m2x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 16 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv16i8_2t.nxv8i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) [[DEST]], <vscale x 8 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 16 x i8>, 2) [[TMP0]]
//
vint16m2x2_t test_vset_v_i16m2_i16m2x2(vint16m2x2_t dest, size_t index, vint16m2_t val) {
  return __riscv_vset_v_i16m2_i16m2x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @test_vset_v_i16m2_i16m2x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 16 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv16i8_3t.nxv8i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) [[DEST]], <vscale x 8 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 16 x i8>, 3) [[TMP0]]
//
vint16m2x3_t test_vset_v_i16m2_i16m2x3(vint16m2x3_t dest, size_t index, vint16m2_t val) {
  return __riscv_vset_v_i16m2_i16m2x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @test_vset_v_i16m2_i16m2x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv16i8_4t.nxv8i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[DEST]], <vscale x 8 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[TMP0]]
//
vint16m2x4_t test_vset_v_i16m2_i16m2x4(vint16m2x4_t dest, size_t index, vint16m2_t val) {
  return __riscv_vset_v_i16m2_i16m2x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @test_vset_v_i16m4_i16m4x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 32 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 16 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv32i8_2t.nxv16i16(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) [[DEST]], <vscale x 16 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 32 x i8>, 2) [[TMP0]]
//
vint16m4x2_t test_vset_v_i16m4_i16m4x2(vint16m4x2_t dest, size_t index, vint16m4_t val) {
  return __riscv_vset_v_i16m4_i16m4x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @test_vset_v_i32mf2_i32mf2x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_2t.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) [[DEST]], <vscale x 1 x i32> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 2) [[TMP0]]
//
vint32mf2x2_t test_vset_v_i32mf2_i32mf2x2(vint32mf2x2_t dest, size_t index, vint32mf2_t val) {
  return __riscv_vset_v_i32mf2_i32mf2x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @test_vset_v_i32mf2_i32mf2x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_3t.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) [[DEST]], <vscale x 1 x i32> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 3) [[TMP0]]
//
vint32mf2x3_t test_vset_v_i32mf2_i32mf2x3(vint32mf2x3_t dest, size_t index, vint32mf2_t val) {
  return __riscv_vset_v_i32mf2_i32mf2x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @test_vset_v_i32mf2_i32mf2x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_4t.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) [[DEST]], <vscale x 1 x i32> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 4) [[TMP0]]
//
vint32mf2x4_t test_vset_v_i32mf2_i32mf2x4(vint32mf2x4_t dest, size_t index, vint32mf2_t val) {
  return __riscv_vset_v_i32mf2_i32mf2x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @test_vset_v_i32mf2_i32mf2x5
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 5) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_5t.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) [[DEST]], <vscale x 1 x i32> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 5) [[TMP0]]
//
vint32mf2x5_t test_vset_v_i32mf2_i32mf2x5(vint32mf2x5_t dest, size_t index, vint32mf2_t val) {
  return __riscv_vset_v_i32mf2_i32mf2x5(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @test_vset_v_i32mf2_i32mf2x6
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 6) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_6t.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) [[DEST]], <vscale x 1 x i32> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 6) [[TMP0]]
//
vint32mf2x6_t test_vset_v_i32mf2_i32mf2x6(vint32mf2x6_t dest, size_t index, vint32mf2_t val) {
  return __riscv_vset_v_i32mf2_i32mf2x6(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @test_vset_v_i32mf2_i32mf2x7
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 7) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_7t.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) [[DEST]], <vscale x 1 x i32> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 7) [[TMP0]]
//
vint32mf2x7_t test_vset_v_i32mf2_i32mf2x7(vint32mf2x7_t dest, size_t index, vint32mf2_t val) {
  return __riscv_vset_v_i32mf2_i32mf2x7(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @test_vset_v_i32mf2_i32mf2x8
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 8) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_8t.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) [[DEST]], <vscale x 1 x i32> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 8) [[TMP0]]
//
vint32mf2x8_t test_vset_v_i32mf2_i32mf2x8(vint32mf2x8_t dest, size_t index, vint32mf2_t val) {
  return __riscv_vset_v_i32mf2_i32mf2x8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @test_vset_v_i32m1_i32m1x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_2t.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) [[DEST]], <vscale x 2 x i32> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 2) [[TMP0]]
//
vint32m1x2_t test_vset_v_i32m1_i32m1x2(vint32m1x2_t dest, size_t index, vint32m1_t val) {
  return __riscv_vset_v_i32m1_i32m1x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @test_vset_v_i32m1_i32m1x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_3t.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) [[DEST]], <vscale x 2 x i32> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 3) [[TMP0]]
//
vint32m1x3_t test_vset_v_i32m1_i32m1x3(vint32m1x3_t dest, size_t index, vint32m1_t val) {
  return __riscv_vset_v_i32m1_i32m1x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @test_vset_v_i32m1_i32m1x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_4t.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[DEST]], <vscale x 2 x i32> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[TMP0]]
//
vint32m1x4_t test_vset_v_i32m1_i32m1x4(vint32m1x4_t dest, size_t index, vint32m1_t val) {
  return __riscv_vset_v_i32m1_i32m1x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @test_vset_v_i32m1_i32m1x5
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 5) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_5t.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) [[DEST]], <vscale x 2 x i32> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 5) [[TMP0]]
//
vint32m1x5_t test_vset_v_i32m1_i32m1x5(vint32m1x5_t dest, size_t index, vint32m1_t val) {
  return __riscv_vset_v_i32m1_i32m1x5(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @test_vset_v_i32m1_i32m1x6
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 6) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_6t.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) [[DEST]], <vscale x 2 x i32> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 6) [[TMP0]]
//
vint32m1x6_t test_vset_v_i32m1_i32m1x6(vint32m1x6_t dest, size_t index, vint32m1_t val) {
  return __riscv_vset_v_i32m1_i32m1x6(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @test_vset_v_i32m1_i32m1x7
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 7) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_7t.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) [[DEST]], <vscale x 2 x i32> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 7) [[TMP0]]
//
vint32m1x7_t test_vset_v_i32m1_i32m1x7(vint32m1x7_t dest, size_t index, vint32m1_t val) {
  return __riscv_vset_v_i32m1_i32m1x7(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @test_vset_v_i32m1_i32m1x8
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 8) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_8t.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) [[DEST]], <vscale x 2 x i32> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 8) [[TMP0]]
//
vint32m1x8_t test_vset_v_i32m1_i32m1x8(vint32m1x8_t dest, size_t index, vint32m1_t val) {
  return __riscv_vset_v_i32m1_i32m1x8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @test_vset_v_i32m2_i32m2x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 16 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv16i8_2t.nxv4i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) [[DEST]], <vscale x 4 x i32> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 16 x i8>, 2) [[TMP0]]
//
vint32m2x2_t test_vset_v_i32m2_i32m2x2(vint32m2x2_t dest, size_t index, vint32m2_t val) {
  return __riscv_vset_v_i32m2_i32m2x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @test_vset_v_i32m2_i32m2x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 16 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv16i8_3t.nxv4i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) [[DEST]], <vscale x 4 x i32> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 16 x i8>, 3) [[TMP0]]
//
vint32m2x3_t test_vset_v_i32m2_i32m2x3(vint32m2x3_t dest, size_t index, vint32m2_t val) {
  return __riscv_vset_v_i32m2_i32m2x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @test_vset_v_i32m2_i32m2x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv16i8_4t.nxv4i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[DEST]], <vscale x 4 x i32> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[TMP0]]
//
vint32m2x4_t test_vset_v_i32m2_i32m2x4(vint32m2x4_t dest, size_t index, vint32m2_t val) {
  return __riscv_vset_v_i32m2_i32m2x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @test_vset_v_i32m4_i32m4x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 32 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv32i8_2t.nxv8i32(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) [[DEST]], <vscale x 8 x i32> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 32 x i8>, 2) [[TMP0]]
//
vint32m4x2_t test_vset_v_i32m4_i32m4x2(vint32m4x2_t dest, size_t index, vint32m4_t val) {
  return __riscv_vset_v_i32m4_i32m4x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @test_vset_v_i64m1_i64m1x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i64> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_2t.nxv1i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) [[DEST]], <vscale x 1 x i64> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 2) [[TMP0]]
//
vint64m1x2_t test_vset_v_i64m1_i64m1x2(vint64m1x2_t dest, size_t index, vint64m1_t val) {
  return __riscv_vset_v_i64m1_i64m1x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @test_vset_v_i64m1_i64m1x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i64> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_3t.nxv1i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) [[DEST]], <vscale x 1 x i64> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 3) [[TMP0]]
//
vint64m1x3_t test_vset_v_i64m1_i64m1x3(vint64m1x3_t dest, size_t index, vint64m1_t val) {
  return __riscv_vset_v_i64m1_i64m1x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @test_vset_v_i64m1_i64m1x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i64> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_4t.nxv1i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[DEST]], <vscale x 1 x i64> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[TMP0]]
//
vint64m1x4_t test_vset_v_i64m1_i64m1x4(vint64m1x4_t dest, size_t index, vint64m1_t val) {
  return __riscv_vset_v_i64m1_i64m1x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @test_vset_v_i64m1_i64m1x5
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 5) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i64> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_5t.nxv1i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) [[DEST]], <vscale x 1 x i64> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 5) [[TMP0]]
//
vint64m1x5_t test_vset_v_i64m1_i64m1x5(vint64m1x5_t dest, size_t index, vint64m1_t val) {
  return __riscv_vset_v_i64m1_i64m1x5(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @test_vset_v_i64m1_i64m1x6
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 6) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i64> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_6t.nxv1i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) [[DEST]], <vscale x 1 x i64> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 6) [[TMP0]]
//
vint64m1x6_t test_vset_v_i64m1_i64m1x6(vint64m1x6_t dest, size_t index, vint64m1_t val) {
  return __riscv_vset_v_i64m1_i64m1x6(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @test_vset_v_i64m1_i64m1x7
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 7) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i64> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_7t.nxv1i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) [[DEST]], <vscale x 1 x i64> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 7) [[TMP0]]
//
vint64m1x7_t test_vset_v_i64m1_i64m1x7(vint64m1x7_t dest, size_t index, vint64m1_t val) {
  return __riscv_vset_v_i64m1_i64m1x7(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @test_vset_v_i64m1_i64m1x8
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 8) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i64> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_8t.nxv1i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) [[DEST]], <vscale x 1 x i64> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 8) [[TMP0]]
//
vint64m1x8_t test_vset_v_i64m1_i64m1x8(vint64m1x8_t dest, size_t index, vint64m1_t val) {
  return __riscv_vset_v_i64m1_i64m1x8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @test_vset_v_i64m2_i64m2x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 16 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i64> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv16i8_2t.nxv2i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) [[DEST]], <vscale x 2 x i64> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 16 x i8>, 2) [[TMP0]]
//
vint64m2x2_t test_vset_v_i64m2_i64m2x2(vint64m2x2_t dest, size_t index, vint64m2_t val) {
  return __riscv_vset_v_i64m2_i64m2x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @test_vset_v_i64m2_i64m2x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 16 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i64> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv16i8_3t.nxv2i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) [[DEST]], <vscale x 2 x i64> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 16 x i8>, 3) [[TMP0]]
//
vint64m2x3_t test_vset_v_i64m2_i64m2x3(vint64m2x3_t dest, size_t index, vint64m2_t val) {
  return __riscv_vset_v_i64m2_i64m2x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @test_vset_v_i64m2_i64m2x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i64> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv16i8_4t.nxv2i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[DEST]], <vscale x 2 x i64> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[TMP0]]
//
vint64m2x4_t test_vset_v_i64m2_i64m2x4(vint64m2x4_t dest, size_t index, vint64m2_t val) {
  return __riscv_vset_v_i64m2_i64m2x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @test_vset_v_i64m4_i64m4x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 32 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i64> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv32i8_2t.nxv4i64(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) [[DEST]], <vscale x 4 x i64> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 32 x i8>, 2) [[TMP0]]
//
vint64m4x2_t test_vset_v_i64m4_i64m4x2(vint64m4x2_t dest, size_t index, vint64m4_t val) {
  return __riscv_vset_v_i64m4_i64m4x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 1 x i8>, 2) @test_vset_v_u8mf8_u8mf8x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 1 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 1 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv1i8_2t.nxv1i8(target("riscv.vector.tuple", <vscale x 1 x i8>, 2) [[DEST]], <vscale x 1 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 1 x i8>, 2) [[TMP0]]
//
vuint8mf8x2_t test_vset_v_u8mf8_u8mf8x2(vuint8mf8x2_t dest, size_t index, vuint8mf8_t val) {
  return __riscv_vset_v_u8mf8_u8mf8x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 1 x i8>, 3) @test_vset_v_u8mf8_u8mf8x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 1 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 1 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv1i8_3t.nxv1i8(target("riscv.vector.tuple", <vscale x 1 x i8>, 3) [[DEST]], <vscale x 1 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 1 x i8>, 3) [[TMP0]]
//
vuint8mf8x3_t test_vset_v_u8mf8_u8mf8x3(vuint8mf8x3_t dest, size_t index, vuint8mf8_t val) {
  return __riscv_vset_v_u8mf8_u8mf8x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 1 x i8>, 4) @test_vset_v_u8mf8_u8mf8x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 1 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 1 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv1i8_4t.nxv1i8(target("riscv.vector.tuple", <vscale x 1 x i8>, 4) [[DEST]], <vscale x 1 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 1 x i8>, 4) [[TMP0]]
//
vuint8mf8x4_t test_vset_v_u8mf8_u8mf8x4(vuint8mf8x4_t dest, size_t index, vuint8mf8_t val) {
  return __riscv_vset_v_u8mf8_u8mf8x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 1 x i8>, 5) @test_vset_v_u8mf8_u8mf8x5
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 1 x i8>, 5) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 1 x i8>, 5) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv1i8_5t.nxv1i8(target("riscv.vector.tuple", <vscale x 1 x i8>, 5) [[DEST]], <vscale x 1 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 1 x i8>, 5) [[TMP0]]
//
vuint8mf8x5_t test_vset_v_u8mf8_u8mf8x5(vuint8mf8x5_t dest, size_t index, vuint8mf8_t val) {
  return __riscv_vset_v_u8mf8_u8mf8x5(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 1 x i8>, 6) @test_vset_v_u8mf8_u8mf8x6
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 1 x i8>, 6) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 1 x i8>, 6) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv1i8_6t.nxv1i8(target("riscv.vector.tuple", <vscale x 1 x i8>, 6) [[DEST]], <vscale x 1 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 1 x i8>, 6) [[TMP0]]
//
vuint8mf8x6_t test_vset_v_u8mf8_u8mf8x6(vuint8mf8x6_t dest, size_t index, vuint8mf8_t val) {
  return __riscv_vset_v_u8mf8_u8mf8x6(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 1 x i8>, 7) @test_vset_v_u8mf8_u8mf8x7
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 1 x i8>, 7) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 1 x i8>, 7) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv1i8_7t.nxv1i8(target("riscv.vector.tuple", <vscale x 1 x i8>, 7) [[DEST]], <vscale x 1 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 1 x i8>, 7) [[TMP0]]
//
vuint8mf8x7_t test_vset_v_u8mf8_u8mf8x7(vuint8mf8x7_t dest, size_t index, vuint8mf8_t val) {
  return __riscv_vset_v_u8mf8_u8mf8x7(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 1 x i8>, 8) @test_vset_v_u8mf8_u8mf8x8
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 1 x i8>, 8) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 1 x i8>, 8) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv1i8_8t.nxv1i8(target("riscv.vector.tuple", <vscale x 1 x i8>, 8) [[DEST]], <vscale x 1 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 1 x i8>, 8) [[TMP0]]
//
vuint8mf8x8_t test_vset_v_u8mf8_u8mf8x8(vuint8mf8x8_t dest, size_t index, vuint8mf8_t val) {
  return __riscv_vset_v_u8mf8_u8mf8x8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @test_vset_v_u8mf4_u8mf4x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 2 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv2i8_2t.nxv2i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) [[DEST]], <vscale x 2 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 2 x i8>, 2) [[TMP0]]
//
vuint8mf4x2_t test_vset_v_u8mf4_u8mf4x2(vuint8mf4x2_t dest, size_t index, vuint8mf4_t val) {
  return __riscv_vset_v_u8mf4_u8mf4x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @test_vset_v_u8mf4_u8mf4x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 2 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv2i8_3t.nxv2i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) [[DEST]], <vscale x 2 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 2 x i8>, 3) [[TMP0]]
//
vuint8mf4x3_t test_vset_v_u8mf4_u8mf4x3(vuint8mf4x3_t dest, size_t index, vuint8mf4_t val) {
  return __riscv_vset_v_u8mf4_u8mf4x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @test_vset_v_u8mf4_u8mf4x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 2 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv2i8_4t.nxv2i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) [[DEST]], <vscale x 2 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 2 x i8>, 4) [[TMP0]]
//
vuint8mf4x4_t test_vset_v_u8mf4_u8mf4x4(vuint8mf4x4_t dest, size_t index, vuint8mf4_t val) {
  return __riscv_vset_v_u8mf4_u8mf4x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @test_vset_v_u8mf4_u8mf4x5
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 2 x i8>, 5) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv2i8_5t.nxv2i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) [[DEST]], <vscale x 2 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 2 x i8>, 5) [[TMP0]]
//
vuint8mf4x5_t test_vset_v_u8mf4_u8mf4x5(vuint8mf4x5_t dest, size_t index, vuint8mf4_t val) {
  return __riscv_vset_v_u8mf4_u8mf4x5(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @test_vset_v_u8mf4_u8mf4x6
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 2 x i8>, 6) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv2i8_6t.nxv2i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) [[DEST]], <vscale x 2 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 2 x i8>, 6) [[TMP0]]
//
vuint8mf4x6_t test_vset_v_u8mf4_u8mf4x6(vuint8mf4x6_t dest, size_t index, vuint8mf4_t val) {
  return __riscv_vset_v_u8mf4_u8mf4x6(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @test_vset_v_u8mf4_u8mf4x7
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 2 x i8>, 7) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv2i8_7t.nxv2i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) [[DEST]], <vscale x 2 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 2 x i8>, 7) [[TMP0]]
//
vuint8mf4x7_t test_vset_v_u8mf4_u8mf4x7(vuint8mf4x7_t dest, size_t index, vuint8mf4_t val) {
  return __riscv_vset_v_u8mf4_u8mf4x7(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @test_vset_v_u8mf4_u8mf4x8
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 2 x i8>, 8) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv2i8_8t.nxv2i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) [[DEST]], <vscale x 2 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 2 x i8>, 8) [[TMP0]]
//
vuint8mf4x8_t test_vset_v_u8mf4_u8mf4x8(vuint8mf4x8_t dest, size_t index, vuint8mf4_t val) {
  return __riscv_vset_v_u8mf4_u8mf4x8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @test_vset_v_u8mf2_u8mf2x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_2t.nxv4i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) [[DEST]], <vscale x 4 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 2) [[TMP0]]
//
vuint8mf2x2_t test_vset_v_u8mf2_u8mf2x2(vuint8mf2x2_t dest, size_t index, vuint8mf2_t val) {
  return __riscv_vset_v_u8mf2_u8mf2x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @test_vset_v_u8mf2_u8mf2x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_3t.nxv4i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) [[DEST]], <vscale x 4 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 3) [[TMP0]]
//
vuint8mf2x3_t test_vset_v_u8mf2_u8mf2x3(vuint8mf2x3_t dest, size_t index, vuint8mf2_t val) {
  return __riscv_vset_v_u8mf2_u8mf2x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @test_vset_v_u8mf2_u8mf2x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_4t.nxv4i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) [[DEST]], <vscale x 4 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 4) [[TMP0]]
//
vuint8mf2x4_t test_vset_v_u8mf2_u8mf2x4(vuint8mf2x4_t dest, size_t index, vuint8mf2_t val) {
  return __riscv_vset_v_u8mf2_u8mf2x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @test_vset_v_u8mf2_u8mf2x5
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 5) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_5t.nxv4i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) [[DEST]], <vscale x 4 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 5) [[TMP0]]
//
vuint8mf2x5_t test_vset_v_u8mf2_u8mf2x5(vuint8mf2x5_t dest, size_t index, vuint8mf2_t val) {
  return __riscv_vset_v_u8mf2_u8mf2x5(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @test_vset_v_u8mf2_u8mf2x6
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 6) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_6t.nxv4i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) [[DEST]], <vscale x 4 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 6) [[TMP0]]
//
vuint8mf2x6_t test_vset_v_u8mf2_u8mf2x6(vuint8mf2x6_t dest, size_t index, vuint8mf2_t val) {
  return __riscv_vset_v_u8mf2_u8mf2x6(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @test_vset_v_u8mf2_u8mf2x7
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 7) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_7t.nxv4i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) [[DEST]], <vscale x 4 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 7) [[TMP0]]
//
vuint8mf2x7_t test_vset_v_u8mf2_u8mf2x7(vuint8mf2x7_t dest, size_t index, vuint8mf2_t val) {
  return __riscv_vset_v_u8mf2_u8mf2x7(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @test_vset_v_u8mf2_u8mf2x8
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 8) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_8t.nxv4i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) [[DEST]], <vscale x 4 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 8) [[TMP0]]
//
vuint8mf2x8_t test_vset_v_u8mf2_u8mf2x8(vuint8mf2x8_t dest, size_t index, vuint8mf2_t val) {
  return __riscv_vset_v_u8mf2_u8mf2x8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @test_vset_v_u8m1_u8m1x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_2t.nxv8i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) [[DEST]], <vscale x 8 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 2) [[TMP0]]
//
vuint8m1x2_t test_vset_v_u8m1_u8m1x2(vuint8m1x2_t dest, size_t index, vuint8m1_t val) {
  return __riscv_vset_v_u8m1_u8m1x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @test_vset_v_u8m1_u8m1x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_3t.nxv8i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) [[DEST]], <vscale x 8 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 3) [[TMP0]]
//
vuint8m1x3_t test_vset_v_u8m1_u8m1x3(vuint8m1x3_t dest, size_t index, vuint8m1_t val) {
  return __riscv_vset_v_u8m1_u8m1x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @test_vset_v_u8m1_u8m1x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_4t.nxv8i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[DEST]], <vscale x 8 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[TMP0]]
//
vuint8m1x4_t test_vset_v_u8m1_u8m1x4(vuint8m1x4_t dest, size_t index, vuint8m1_t val) {
  return __riscv_vset_v_u8m1_u8m1x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @test_vset_v_u8m1_u8m1x5
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 5) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_5t.nxv8i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) [[DEST]], <vscale x 8 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 5) [[TMP0]]
//
vuint8m1x5_t test_vset_v_u8m1_u8m1x5(vuint8m1x5_t dest, size_t index, vuint8m1_t val) {
  return __riscv_vset_v_u8m1_u8m1x5(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @test_vset_v_u8m1_u8m1x6
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 6) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_6t.nxv8i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) [[DEST]], <vscale x 8 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 6) [[TMP0]]
//
vuint8m1x6_t test_vset_v_u8m1_u8m1x6(vuint8m1x6_t dest, size_t index, vuint8m1_t val) {
  return __riscv_vset_v_u8m1_u8m1x6(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @test_vset_v_u8m1_u8m1x7
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 7) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_7t.nxv8i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) [[DEST]], <vscale x 8 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 7) [[TMP0]]
//
vuint8m1x7_t test_vset_v_u8m1_u8m1x7(vuint8m1x7_t dest, size_t index, vuint8m1_t val) {
  return __riscv_vset_v_u8m1_u8m1x7(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @test_vset_v_u8m1_u8m1x8
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 8) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_8t.nxv8i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) [[DEST]], <vscale x 8 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 8) [[TMP0]]
//
vuint8m1x8_t test_vset_v_u8m1_u8m1x8(vuint8m1x8_t dest, size_t index, vuint8m1_t val) {
  return __riscv_vset_v_u8m1_u8m1x8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @test_vset_v_u8m2_u8m2x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 16 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 16 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv16i8_2t.nxv16i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) [[DEST]], <vscale x 16 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 16 x i8>, 2) [[TMP0]]
//
vuint8m2x2_t test_vset_v_u8m2_u8m2x2(vuint8m2x2_t dest, size_t index, vuint8m2_t val) {
  return __riscv_vset_v_u8m2_u8m2x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @test_vset_v_u8m2_u8m2x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 16 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 16 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv16i8_3t.nxv16i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) [[DEST]], <vscale x 16 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 16 x i8>, 3) [[TMP0]]
//
vuint8m2x3_t test_vset_v_u8m2_u8m2x3(vuint8m2x3_t dest, size_t index, vuint8m2_t val) {
  return __riscv_vset_v_u8m2_u8m2x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @test_vset_v_u8m2_u8m2x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 16 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv16i8_4t.nxv16i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[DEST]], <vscale x 16 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[TMP0]]
//
vuint8m2x4_t test_vset_v_u8m2_u8m2x4(vuint8m2x4_t dest, size_t index, vuint8m2_t val) {
  return __riscv_vset_v_u8m2_u8m2x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @test_vset_v_u8m4_u8m4x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 32 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 32 x i8> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv32i8_2t.nxv32i8(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) [[DEST]], <vscale x 32 x i8> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 32 x i8>, 2) [[TMP0]]
//
vuint8m4x2_t test_vset_v_u8m4_u8m4x2(vuint8m4x2_t dest, size_t index, vuint8m4_t val) {
  return __riscv_vset_v_u8m4_u8m4x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @test_vset_v_u16mf4_u16mf4x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 2 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv2i8_2t.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) [[DEST]], <vscale x 1 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 2 x i8>, 2) [[TMP0]]
//
vuint16mf4x2_t test_vset_v_u16mf4_u16mf4x2(vuint16mf4x2_t dest, size_t index, vuint16mf4_t val) {
  return __riscv_vset_v_u16mf4_u16mf4x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @test_vset_v_u16mf4_u16mf4x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 2 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv2i8_3t.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) [[DEST]], <vscale x 1 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 2 x i8>, 3) [[TMP0]]
//
vuint16mf4x3_t test_vset_v_u16mf4_u16mf4x3(vuint16mf4x3_t dest, size_t index, vuint16mf4_t val) {
  return __riscv_vset_v_u16mf4_u16mf4x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @test_vset_v_u16mf4_u16mf4x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 2 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv2i8_4t.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) [[DEST]], <vscale x 1 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 2 x i8>, 4) [[TMP0]]
//
vuint16mf4x4_t test_vset_v_u16mf4_u16mf4x4(vuint16mf4x4_t dest, size_t index, vuint16mf4_t val) {
  return __riscv_vset_v_u16mf4_u16mf4x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @test_vset_v_u16mf4_u16mf4x5
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 2 x i8>, 5) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv2i8_5t.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) [[DEST]], <vscale x 1 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 2 x i8>, 5) [[TMP0]]
//
vuint16mf4x5_t test_vset_v_u16mf4_u16mf4x5(vuint16mf4x5_t dest, size_t index, vuint16mf4_t val) {
  return __riscv_vset_v_u16mf4_u16mf4x5(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @test_vset_v_u16mf4_u16mf4x6
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 2 x i8>, 6) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv2i8_6t.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) [[DEST]], <vscale x 1 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 2 x i8>, 6) [[TMP0]]
//
vuint16mf4x6_t test_vset_v_u16mf4_u16mf4x6(vuint16mf4x6_t dest, size_t index, vuint16mf4_t val) {
  return __riscv_vset_v_u16mf4_u16mf4x6(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @test_vset_v_u16mf4_u16mf4x7
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 2 x i8>, 7) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv2i8_7t.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) [[DEST]], <vscale x 1 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 2 x i8>, 7) [[TMP0]]
//
vuint16mf4x7_t test_vset_v_u16mf4_u16mf4x7(vuint16mf4x7_t dest, size_t index, vuint16mf4_t val) {
  return __riscv_vset_v_u16mf4_u16mf4x7(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @test_vset_v_u16mf4_u16mf4x8
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 2 x i8>, 8) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv2i8_8t.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) [[DEST]], <vscale x 1 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 2 x i8>, 8) [[TMP0]]
//
vuint16mf4x8_t test_vset_v_u16mf4_u16mf4x8(vuint16mf4x8_t dest, size_t index, vuint16mf4_t val) {
  return __riscv_vset_v_u16mf4_u16mf4x8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @test_vset_v_u16mf2_u16mf2x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_2t.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) [[DEST]], <vscale x 2 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 2) [[TMP0]]
//
vuint16mf2x2_t test_vset_v_u16mf2_u16mf2x2(vuint16mf2x2_t dest, size_t index, vuint16mf2_t val) {
  return __riscv_vset_v_u16mf2_u16mf2x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @test_vset_v_u16mf2_u16mf2x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_3t.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) [[DEST]], <vscale x 2 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 3) [[TMP0]]
//
vuint16mf2x3_t test_vset_v_u16mf2_u16mf2x3(vuint16mf2x3_t dest, size_t index, vuint16mf2_t val) {
  return __riscv_vset_v_u16mf2_u16mf2x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @test_vset_v_u16mf2_u16mf2x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_4t.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) [[DEST]], <vscale x 2 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 4) [[TMP0]]
//
vuint16mf2x4_t test_vset_v_u16mf2_u16mf2x4(vuint16mf2x4_t dest, size_t index, vuint16mf2_t val) {
  return __riscv_vset_v_u16mf2_u16mf2x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @test_vset_v_u16mf2_u16mf2x5
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 5) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_5t.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) [[DEST]], <vscale x 2 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 5) [[TMP0]]
//
vuint16mf2x5_t test_vset_v_u16mf2_u16mf2x5(vuint16mf2x5_t dest, size_t index, vuint16mf2_t val) {
  return __riscv_vset_v_u16mf2_u16mf2x5(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @test_vset_v_u16mf2_u16mf2x6
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 6) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_6t.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) [[DEST]], <vscale x 2 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 6) [[TMP0]]
//
vuint16mf2x6_t test_vset_v_u16mf2_u16mf2x6(vuint16mf2x6_t dest, size_t index, vuint16mf2_t val) {
  return __riscv_vset_v_u16mf2_u16mf2x6(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @test_vset_v_u16mf2_u16mf2x7
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 7) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_7t.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) [[DEST]], <vscale x 2 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 7) [[TMP0]]
//
vuint16mf2x7_t test_vset_v_u16mf2_u16mf2x7(vuint16mf2x7_t dest, size_t index, vuint16mf2_t val) {
  return __riscv_vset_v_u16mf2_u16mf2x7(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @test_vset_v_u16mf2_u16mf2x8
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 8) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_8t.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) [[DEST]], <vscale x 2 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 8) [[TMP0]]
//
vuint16mf2x8_t test_vset_v_u16mf2_u16mf2x8(vuint16mf2x8_t dest, size_t index, vuint16mf2_t val) {
  return __riscv_vset_v_u16mf2_u16mf2x8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @test_vset_v_u16m1_u16m1x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_2t.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) [[DEST]], <vscale x 4 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 2) [[TMP0]]
//
vuint16m1x2_t test_vset_v_u16m1_u16m1x2(vuint16m1x2_t dest, size_t index, vuint16m1_t val) {
  return __riscv_vset_v_u16m1_u16m1x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @test_vset_v_u16m1_u16m1x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_3t.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) [[DEST]], <vscale x 4 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 3) [[TMP0]]
//
vuint16m1x3_t test_vset_v_u16m1_u16m1x3(vuint16m1x3_t dest, size_t index, vuint16m1_t val) {
  return __riscv_vset_v_u16m1_u16m1x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @test_vset_v_u16m1_u16m1x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_4t.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[DEST]], <vscale x 4 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[TMP0]]
//
vuint16m1x4_t test_vset_v_u16m1_u16m1x4(vuint16m1x4_t dest, size_t index, vuint16m1_t val) {
  return __riscv_vset_v_u16m1_u16m1x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @test_vset_v_u16m1_u16m1x5
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 5) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_5t.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) [[DEST]], <vscale x 4 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 5) [[TMP0]]
//
vuint16m1x5_t test_vset_v_u16m1_u16m1x5(vuint16m1x5_t dest, size_t index, vuint16m1_t val) {
  return __riscv_vset_v_u16m1_u16m1x5(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @test_vset_v_u16m1_u16m1x6
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 6) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_6t.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) [[DEST]], <vscale x 4 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 6) [[TMP0]]
//
vuint16m1x6_t test_vset_v_u16m1_u16m1x6(vuint16m1x6_t dest, size_t index, vuint16m1_t val) {
  return __riscv_vset_v_u16m1_u16m1x6(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @test_vset_v_u16m1_u16m1x7
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 7) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_7t.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) [[DEST]], <vscale x 4 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 7) [[TMP0]]
//
vuint16m1x7_t test_vset_v_u16m1_u16m1x7(vuint16m1x7_t dest, size_t index, vuint16m1_t val) {
  return __riscv_vset_v_u16m1_u16m1x7(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @test_vset_v_u16m1_u16m1x8
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 8) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_8t.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) [[DEST]], <vscale x 4 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 8) [[TMP0]]
//
vuint16m1x8_t test_vset_v_u16m1_u16m1x8(vuint16m1x8_t dest, size_t index, vuint16m1_t val) {
  return __riscv_vset_v_u16m1_u16m1x8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @test_vset_v_u16m2_u16m2x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 16 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv16i8_2t.nxv8i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) [[DEST]], <vscale x 8 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 16 x i8>, 2) [[TMP0]]
//
vuint16m2x2_t test_vset_v_u16m2_u16m2x2(vuint16m2x2_t dest, size_t index, vuint16m2_t val) {
  return __riscv_vset_v_u16m2_u16m2x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @test_vset_v_u16m2_u16m2x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 16 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv16i8_3t.nxv8i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) [[DEST]], <vscale x 8 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 16 x i8>, 3) [[TMP0]]
//
vuint16m2x3_t test_vset_v_u16m2_u16m2x3(vuint16m2x3_t dest, size_t index, vuint16m2_t val) {
  return __riscv_vset_v_u16m2_u16m2x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @test_vset_v_u16m2_u16m2x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv16i8_4t.nxv8i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[DEST]], <vscale x 8 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[TMP0]]
//
vuint16m2x4_t test_vset_v_u16m2_u16m2x4(vuint16m2x4_t dest, size_t index, vuint16m2_t val) {
  return __riscv_vset_v_u16m2_u16m2x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @test_vset_v_u16m4_u16m4x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 32 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 16 x i16> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv32i8_2t.nxv16i16(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) [[DEST]], <vscale x 16 x i16> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 32 x i8>, 2) [[TMP0]]
//
vuint16m4x2_t test_vset_v_u16m4_u16m4x2(vuint16m4x2_t dest, size_t index, vuint16m4_t val) {
  return __riscv_vset_v_u16m4_u16m4x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @test_vset_v_u32mf2_u32mf2x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_2t.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) [[DEST]], <vscale x 1 x i32> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 2) [[TMP0]]
//
vuint32mf2x2_t test_vset_v_u32mf2_u32mf2x2(vuint32mf2x2_t dest, size_t index, vuint32mf2_t val) {
  return __riscv_vset_v_u32mf2_u32mf2x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @test_vset_v_u32mf2_u32mf2x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_3t.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) [[DEST]], <vscale x 1 x i32> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 3) [[TMP0]]
//
vuint32mf2x3_t test_vset_v_u32mf2_u32mf2x3(vuint32mf2x3_t dest, size_t index, vuint32mf2_t val) {
  return __riscv_vset_v_u32mf2_u32mf2x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @test_vset_v_u32mf2_u32mf2x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_4t.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) [[DEST]], <vscale x 1 x i32> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 4) [[TMP0]]
//
vuint32mf2x4_t test_vset_v_u32mf2_u32mf2x4(vuint32mf2x4_t dest, size_t index, vuint32mf2_t val) {
  return __riscv_vset_v_u32mf2_u32mf2x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @test_vset_v_u32mf2_u32mf2x5
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 5) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_5t.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) [[DEST]], <vscale x 1 x i32> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 5) [[TMP0]]
//
vuint32mf2x5_t test_vset_v_u32mf2_u32mf2x5(vuint32mf2x5_t dest, size_t index, vuint32mf2_t val) {
  return __riscv_vset_v_u32mf2_u32mf2x5(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @test_vset_v_u32mf2_u32mf2x6
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 6) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_6t.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) [[DEST]], <vscale x 1 x i32> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 6) [[TMP0]]
//
vuint32mf2x6_t test_vset_v_u32mf2_u32mf2x6(vuint32mf2x6_t dest, size_t index, vuint32mf2_t val) {
  return __riscv_vset_v_u32mf2_u32mf2x6(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @test_vset_v_u32mf2_u32mf2x7
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 7) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_7t.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) [[DEST]], <vscale x 1 x i32> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 7) [[TMP0]]
//
vuint32mf2x7_t test_vset_v_u32mf2_u32mf2x7(vuint32mf2x7_t dest, size_t index, vuint32mf2_t val) {
  return __riscv_vset_v_u32mf2_u32mf2x7(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @test_vset_v_u32mf2_u32mf2x8
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 4 x i8>, 8) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv4i8_8t.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) [[DEST]], <vscale x 1 x i32> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 4 x i8>, 8) [[TMP0]]
//
vuint32mf2x8_t test_vset_v_u32mf2_u32mf2x8(vuint32mf2x8_t dest, size_t index, vuint32mf2_t val) {
  return __riscv_vset_v_u32mf2_u32mf2x8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @test_vset_v_u32m1_u32m1x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_2t.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) [[DEST]], <vscale x 2 x i32> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 2) [[TMP0]]
//
vuint32m1x2_t test_vset_v_u32m1_u32m1x2(vuint32m1x2_t dest, size_t index, vuint32m1_t val) {
  return __riscv_vset_v_u32m1_u32m1x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @test_vset_v_u32m1_u32m1x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_3t.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) [[DEST]], <vscale x 2 x i32> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 3) [[TMP0]]
//
vuint32m1x3_t test_vset_v_u32m1_u32m1x3(vuint32m1x3_t dest, size_t index, vuint32m1_t val) {
  return __riscv_vset_v_u32m1_u32m1x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @test_vset_v_u32m1_u32m1x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_4t.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[DEST]], <vscale x 2 x i32> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[TMP0]]
//
vuint32m1x4_t test_vset_v_u32m1_u32m1x4(vuint32m1x4_t dest, size_t index, vuint32m1_t val) {
  return __riscv_vset_v_u32m1_u32m1x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @test_vset_v_u32m1_u32m1x5
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 5) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_5t.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) [[DEST]], <vscale x 2 x i32> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 5) [[TMP0]]
//
vuint32m1x5_t test_vset_v_u32m1_u32m1x5(vuint32m1x5_t dest, size_t index, vuint32m1_t val) {
  return __riscv_vset_v_u32m1_u32m1x5(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @test_vset_v_u32m1_u32m1x6
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 6) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_6t.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) [[DEST]], <vscale x 2 x i32> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 6) [[TMP0]]
//
vuint32m1x6_t test_vset_v_u32m1_u32m1x6(vuint32m1x6_t dest, size_t index, vuint32m1_t val) {
  return __riscv_vset_v_u32m1_u32m1x6(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @test_vset_v_u32m1_u32m1x7
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 7) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_7t.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) [[DEST]], <vscale x 2 x i32> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 7) [[TMP0]]
//
vuint32m1x7_t test_vset_v_u32m1_u32m1x7(vuint32m1x7_t dest, size_t index, vuint32m1_t val) {
  return __riscv_vset_v_u32m1_u32m1x7(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @test_vset_v_u32m1_u32m1x8
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 8) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_8t.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) [[DEST]], <vscale x 2 x i32> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 8) [[TMP0]]
//
vuint32m1x8_t test_vset_v_u32m1_u32m1x8(vuint32m1x8_t dest, size_t index, vuint32m1_t val) {
  return __riscv_vset_v_u32m1_u32m1x8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @test_vset_v_u32m2_u32m2x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 16 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv16i8_2t.nxv4i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) [[DEST]], <vscale x 4 x i32> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 16 x i8>, 2) [[TMP0]]
//
vuint32m2x2_t test_vset_v_u32m2_u32m2x2(vuint32m2x2_t dest, size_t index, vuint32m2_t val) {
  return __riscv_vset_v_u32m2_u32m2x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @test_vset_v_u32m2_u32m2x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 16 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv16i8_3t.nxv4i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) [[DEST]], <vscale x 4 x i32> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 16 x i8>, 3) [[TMP0]]
//
vuint32m2x3_t test_vset_v_u32m2_u32m2x3(vuint32m2x3_t dest, size_t index, vuint32m2_t val) {
  return __riscv_vset_v_u32m2_u32m2x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @test_vset_v_u32m2_u32m2x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv16i8_4t.nxv4i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[DEST]], <vscale x 4 x i32> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[TMP0]]
//
vuint32m2x4_t test_vset_v_u32m2_u32m2x4(vuint32m2x4_t dest, size_t index, vuint32m2_t val) {
  return __riscv_vset_v_u32m2_u32m2x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @test_vset_v_u32m4_u32m4x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 32 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 8 x i32> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv32i8_2t.nxv8i32(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) [[DEST]], <vscale x 8 x i32> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 32 x i8>, 2) [[TMP0]]
//
vuint32m4x2_t test_vset_v_u32m4_u32m4x2(vuint32m4x2_t dest, size_t index, vuint32m4_t val) {
  return __riscv_vset_v_u32m4_u32m4x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @test_vset_v_u64m1_u64m1x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i64> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_2t.nxv1i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) [[DEST]], <vscale x 1 x i64> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 2) [[TMP0]]
//
vuint64m1x2_t test_vset_v_u64m1_u64m1x2(vuint64m1x2_t dest, size_t index, vuint64m1_t val) {
  return __riscv_vset_v_u64m1_u64m1x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @test_vset_v_u64m1_u64m1x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i64> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_3t.nxv1i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) [[DEST]], <vscale x 1 x i64> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 3) [[TMP0]]
//
vuint64m1x3_t test_vset_v_u64m1_u64m1x3(vuint64m1x3_t dest, size_t index, vuint64m1_t val) {
  return __riscv_vset_v_u64m1_u64m1x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @test_vset_v_u64m1_u64m1x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i64> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_4t.nxv1i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[DEST]], <vscale x 1 x i64> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[TMP0]]
//
vuint64m1x4_t test_vset_v_u64m1_u64m1x4(vuint64m1x4_t dest, size_t index, vuint64m1_t val) {
  return __riscv_vset_v_u64m1_u64m1x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @test_vset_v_u64m1_u64m1x5
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 5) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i64> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_5t.nxv1i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) [[DEST]], <vscale x 1 x i64> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 5) [[TMP0]]
//
vuint64m1x5_t test_vset_v_u64m1_u64m1x5(vuint64m1x5_t dest, size_t index, vuint64m1_t val) {
  return __riscv_vset_v_u64m1_u64m1x5(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @test_vset_v_u64m1_u64m1x6
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 6) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i64> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_6t.nxv1i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) [[DEST]], <vscale x 1 x i64> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 6) [[TMP0]]
//
vuint64m1x6_t test_vset_v_u64m1_u64m1x6(vuint64m1x6_t dest, size_t index, vuint64m1_t val) {
  return __riscv_vset_v_u64m1_u64m1x6(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @test_vset_v_u64m1_u64m1x7
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 7) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i64> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_7t.nxv1i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) [[DEST]], <vscale x 1 x i64> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 7) [[TMP0]]
//
vuint64m1x7_t test_vset_v_u64m1_u64m1x7(vuint64m1x7_t dest, size_t index, vuint64m1_t val) {
  return __riscv_vset_v_u64m1_u64m1x7(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @test_vset_v_u64m1_u64m1x8
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 8 x i8>, 8) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 1 x i64> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv8i8_8t.nxv1i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) [[DEST]], <vscale x 1 x i64> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 8 x i8>, 8) [[TMP0]]
//
vuint64m1x8_t test_vset_v_u64m1_u64m1x8(vuint64m1x8_t dest, size_t index, vuint64m1_t val) {
  return __riscv_vset_v_u64m1_u64m1x8(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @test_vset_v_u64m2_u64m2x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 16 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i64> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv16i8_2t.nxv2i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) [[DEST]], <vscale x 2 x i64> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 16 x i8>, 2) [[TMP0]]
//
vuint64m2x2_t test_vset_v_u64m2_u64m2x2(vuint64m2x2_t dest, size_t index, vuint64m2_t val) {
  return __riscv_vset_v_u64m2_u64m2x2(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @test_vset_v_u64m2_u64m2x3
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 16 x i8>, 3) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i64> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv16i8_3t.nxv2i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) [[DEST]], <vscale x 2 x i64> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 16 x i8>, 3) [[TMP0]]
//
vuint64m2x3_t test_vset_v_u64m2_u64m2x3(vuint64m2x3_t dest, size_t index, vuint64m2_t val) {
  return __riscv_vset_v_u64m2_u64m2x3(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @test_vset_v_u64m2_u64m2x4
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 2 x i64> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv16i8_4t.nxv2i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[DEST]], <vscale x 2 x i64> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[TMP0]]
//
vuint64m2x4_t test_vset_v_u64m2_u64m2x4(vuint64m2x4_t dest, size_t index, vuint64m2_t val) {
  return __riscv_vset_v_u64m2_u64m2x4(dest, 0, val);
}

// CHECK-RV64-LABEL: define dso_local target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @test_vset_v_u64m4_u64m4x2
// CHECK-RV64-SAME: (target("riscv.vector.tuple", <vscale x 32 x i8>, 2) [[DEST:%.*]], i64 noundef [[INDEX:%.*]], <vscale x 4 x i64> [[VAL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.tuple.insert.triscv.vector.tuple_nxv32i8_2t.nxv4i64(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) [[DEST]], <vscale x 4 x i64> [[VAL]], i32 0)
// CHECK-RV64-NEXT:    ret target("riscv.vector.tuple", <vscale x 32 x i8>, 2) [[TMP0]]
//
vuint64m4x2_t test_vset_v_u64m4_u64m4x2(vuint64m4x2_t dest, size_t index, vuint64m4_t val) {
  return __riscv_vset_v_u64m4_u64m4x2(dest, 0, val);
}

