/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.data;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import jrm.profile.Profile;
import jrm.profile.data.Anyware;
import jrm.profile.data.Entity;
import jrm.profile.data.EntityStatus;
import jrm.profile.data.NameBase;
import jrm.profile.data.Software;
import jrm.xml.EnhancedXMLStreamWriter;
import jrm.xml.SimpleAttribute;

public class Disk
extends Entity
implements Serializable {
    public boolean writeable = false;
    public Integer index = null;
    public boolean optional = false;
    public String region = null;

    public Disk(Anyware parent) {
        super(parent);
    }

    @Override
    public String getName() {
        if (Anyware.merge_mode.isMerge()) {
            if (this.merge == null) {
                if (this.isCollisionMode(true) && this.getParent().isClone()) {
                    return this.parent.name + "/" + this.name + ".chd";
                }
            } else if (!Profile.curr_profile.getProperty("ignore_merge_name_disks", false)) {
                return this.merge + ".chd";
            }
        }
        return this.name + ".chd";
    }

    public boolean equals(Object obj) {
        if (obj instanceof Disk) {
            if (((Disk)obj).sha1 != null && this.sha1 != null) {
                return ((Disk)obj).sha1.equals(this.sha1);
            }
            if (((Disk)obj).md5 != null && this.md5 != null) {
                return ((Disk)obj).md5.equals(this.md5);
            }
        }
        return super.equals(obj);
    }

    public int hashCode() {
        if (this.sha1 != null) {
            return this.sha1.hashCode();
        }
        if (this.md5 != null) {
            return this.md5.hashCode();
        }
        return super.hashCode();
    }

    public String hashString() {
        if (this.sha1 != null) {
            return this.sha1;
        }
        if (this.md5 != null) {
            return this.md5;
        }
        return this.getName();
    }

    public static Map<String, Disk> getDisksByName(List<Disk> disks) {
        return disks.stream().collect(Collectors.toMap(NameBase::getNormalizedName, Function.identity(), (n, r) -> n));
    }

    private static EntityStatus findDiskStatus(Anyware parent, Disk disk) {
        if (parent.parent != null) {
            if (Anyware.merge_mode.isMerge()) {
                for (Anyware clone : parent.getParent().clones.values()) {
                    if (clone == parent) continue;
                    for (Disk d : clone.disks) {
                        if (!disk.equals(d) || d.own_status == EntityStatus.UNKNOWN) continue;
                        return d.own_status;
                    }
                }
            }
            for (Disk d : parent.getParent().disks) {
                if (!disk.equals(d)) continue;
                return d.getStatus();
            }
            if (parent.parent.parent != null) {
                return Disk.findDiskStatus(parent.getParent(), disk);
            }
        } else if (parent.isRomOf() && disk.merge != null) {
            return EntityStatus.OK;
        }
        return null;
    }

    @Override
    public EntityStatus getStatus() {
        EntityStatus status;
        if (this.status == Entity.Status.nodump) {
            return EntityStatus.OK;
        }
        if (this.own_status == EntityStatus.UNKNOWN && (status = Disk.findDiskStatus(this.getParent(), this)) != null) {
            return status;
        }
        return this.own_status;
    }

    public void export(EnhancedXMLStreamWriter writer, boolean is_mame) throws XMLStreamException, IOException {
        if (this.parent instanceof Software) {
            writer.writeElement("disk", new SimpleAttribute("name", this.name), new SimpleAttribute("sha1", this.sha1), new SimpleAttribute("status", this.status.getXML(is_mame)), new SimpleAttribute("writeable", this.writeable ? "yes" : null));
        } else if (is_mame) {
            writer.writeElement("disk", new SimpleAttribute("name", this.name), new SimpleAttribute("sha1", this.sha1), new SimpleAttribute("merge", this.merge), new SimpleAttribute("status", this.status.getXML(is_mame)), new SimpleAttribute("optional", this.optional), new SimpleAttribute("region", this.region), new SimpleAttribute("writable", this.writeable ? "yes" : null), new SimpleAttribute("index", this.index));
        } else {
            writer.writeElement("disk", new SimpleAttribute("name", this.name), new SimpleAttribute("sha1", this.sha1), new SimpleAttribute("md5", this.md5), new SimpleAttribute("merge", this.merge), new SimpleAttribute("status", this.status.getXML(is_mame)));
        }
    }
}

