/*
 * Decompiled with CFR 0.152.
 */
package jrm.io.torrent.bencoding.types;

import java.util.ArrayList;
import jrm.io.torrent.bencoding.Utils;
import jrm.io.torrent.bencoding.types.IBencodable;

public class BInt
implements IBencodable {
    public byte[] blob;
    private final Long value;

    public BInt(Long value) {
        this.value = value;
    }

    @Override
    public String bencodedString() {
        return "i" + this.value + "e";
    }

    @Override
    public byte[] bencode() {
        byte[] sizeInAsciiBytes = Utils.stringToAsciiBytes(this.value.toString());
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        bytes.add((byte)105);
        for (byte sizeByte : sizeInAsciiBytes) {
            bytes.add(sizeByte);
        }
        bytes.add((byte)101);
        byte[] bencoded = new byte[bytes.size()];
        for (int i = 0; i < bytes.size(); ++i) {
            bencoded[i] = (Byte)bytes.get(i);
        }
        return bencoded;
    }

    public Long getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BInt bInt = (BInt)o;
        return this.value.equals(bInt.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

