--
-- Generated by RecordFlux 0.10.1.dev8+g53cf133e on 2023-07-26
--
-- Copyright (C) 2018-2023 AdaCore GmbH
--
-- This file is distributed under the terms of the GNU Affero General Public License version 3.
--

pragma Style_Checks ("N3aAbCdefhiIklnOprStux");

with Ada.Unchecked_Deallocation;

package RFLX.RFLX_Types with
  SPARK_Mode
is

   type Length is new Natural;

   type Index is new Length range 1 .. Length'Last;

   type Byte is mod 2**8;

   type Bytes is array (Index range <>) of Byte;

   type Bytes_Ptr is access Bytes;

   type Bit_Length is range 0 .. Length'Last * 8;

   pragma Compile_Time_Error (Index'First /= 1, "Index'First must be 1");

   pragma Compile_Time_Error (Byte'Size /= 8, "Byte must be of size 8");

   pragma Compile_Time_Error (Byte'Pos (Byte'Last) - Byte'Pos (Byte'First) + 1 /= 2**Byte'Size,
                              "Byte must cover entire value range");

   pragma Compile_Time_Error (Length'First /= 0, "Length'First must be 0");

   pragma Compile_Time_Error (Length'Pos (Length'Last) /= Index'Pos (Index'Last),
                              "Length'Last must be equal to Index'Last");

   pragma Compile_Time_Error (Bit_Length'First /= 0, "Bit_Length'First must be 0");

   pragma Compile_Time_Error (Bit_Length'Pos (Bit_Length'Last) /= Length'Pos (Length'Last) * 8,
                              "Bit_Length'Last must be equal to Length'Last * 8");

   type U64 is mod 2**64 with
     Annotate => (GNATprove, No_Wrap_Around);

   type Base_Integer is range 0 .. 2 ** 63 - 1;

   subtype Bit_Index is Bit_Length range 1 .. Bit_Length'Last;

   function To_Index (Bit_Idx : Bit_Length) return Index is
     (Index (Length ((Bit_Idx - 1) / 8) + 1));

   function To_Length (Bit_Len : Bit_Length) return Length is
     (Length ((Bit_Len + 7) / 8));

   function To_Bit_Length (Len : Length) return Bit_Length is
     (Bit_Length (Len) * 8);

   function To_First_Bit_Index (Idx : Index) return Bit_Index is
     ((Bit_Length (Idx) - 1) * 8 + 1);

   function To_Last_Bit_Index (Idx : Index) return Bit_Index is
     ((Bit_Length (Idx) - 1) * 8 + 8);

   function To_Last_Bit_Index (Idx : Length) return Bit_Length is
     ((Bit_Length (Idx) - 1) * 8 + 8);

   type Offset is mod 8;

   type Byte_Order is (High_Order_First, Low_Order_First);

   pragma Warnings (Off, "precondition is always False");

   function Unreachable return Boolean is (False) with Pre => False;

   function Unreachable return Bit_Length is (0) with Pre => False;

   function Unreachable return Length is (0) with Pre => False;

   pragma Warnings (On, "precondition is always False");

   procedure Free is new Ada.Unchecked_Deallocation (Object => Bytes, Name => Bytes_Ptr);

end RFLX.RFLX_Types;
