function(append value)
  foreach(variable ${ARGN})
    set(${variable} "${${variable}} ${value}" PARENT_SCOPE)
  endforeach(variable)
endfunction()

include(CheckCXXCompilerFlag)

if (NOT DEFINED SDCV_COMPILER_IS_GCC_COMPATIBLE)
  if (CMAKE_COMPILER_IS_GNUCXX)
    set(SDCV_COMPILER_IS_GCC_COMPATIBLE ON)
  elseif (MSVC)
    set(SDCV_COMPILER_IS_GCC_COMPATIBLE OFF)
  elseif ("${CMAKE_CXX_COMPILER_ID}" MATCHES "Clang")
    set (SDCV_COMPILER_IS_GCC_COMPATIBLE ON)
  endif()
endif()

if (SDCV_COMPILER_IS_GCC_COMPATIBLE)
  append("-Wall" "-Wextra" "-Wformat-security" "-Wcast-align" "-Werror=format" "-Wcast-qual" CMAKE_C_FLAGS)
  append("-Wall" "-pedantic" "-Wextra" "-Wformat-security" "-Wcast-align" "-Werror=format" "-Wcast-qual" CMAKE_CXX_FLAGS)
endif ()
