// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#ifndef Sprite_manager_h
#define Sprite_manager_h




#include "enums.h"
#include "SDL.h"
#include "Log.h"
#include "Crystal.h"
#include "constants.h"
#include "Albert.h"
#include "Player_data.h"
#include "Fish.h"
#include "Sound_engine.h"
#include "Bonus.h"
#include <vector>
#include "Collectable_sprite.h"
#include "Collisions.h"
#include <fstream>
#include <cstdio>
#include <iostream>
#include <cstdlib>
#include "User_input.h"
#include "Scroller.h"
#include "Pause_menu.h"
#include "FS_gfx.h"
#include <tr1/memory>
#include <algorithm>
#include <boost/bind.hpp>




extern std::tr1::shared_ptr<FS::FS_gfx> gfx_ptr;




namespace FS
{
    
class Sprite_manager
{    
    public:
            
        enum State 
        { 
            PLAYING_GAME,
            REQUEST_LEVEL_RESTART, 
            RUNNING_LEVEL_COMPLETED_ROUTINE,
            LEVEL_COMPLETED,
            RUNNING_GAME_OVER_ROUTINE,
            GAME_OVER
        }; // enum SpriteMngrState
        
        enum CatLogCollisionType { ALLOWED, DISALLOWED, MISSED }; 
        
        Sprite_manager();
        ~Sprite_manager();
        
        void set_player_data( Player_data* pd ) { player_data_ptr = pd; }
        void set_sound_engine( Sound_engine* se ) { sound_engine_ptr = se; }
        void set_scroller( Scroller* s ) { scroller_ptr = s; }
        void set_pause_menu( Pause_menu* pm ) { pause_menu_ptr = pm; }
        void create_scrolling_sprites();
        
        void reset();
        void restart_level();
        
        State update( int t, const ScrollingData& sd, PauseType pause_t );
       
        void activate_pause_menu();
        void deactivate_pause_menu();
        
        int get_cats_row() const { return the_cat.get_host_log_row(); }
        const Log* get_cats_host_log() const { return the_cat.get_host_log(); }
        
        void redraw_screen();
        
        RowDescription get_alberts_row() const { return alberts_row; }
        const LogColor get_host_log_color() const;

    private:
    
        Player_data* player_data_ptr;    // from PlayModel
        Sound_engine* sound_engine_ptr;    // from GameManager
        Scroller* scroller_ptr;
        Pause_menu* pause_menu_ptr;
        
        bool pause_menu_needs_erasing;
        bool pause_menu_needs_drawing; 
        
        Albert the_cat;
        Fish the_fish;
        std::vector<Log*> my_logs;
        std::vector<Log*>::iterator logs_iter;
        std::vector<Collectable_sprite*> my_collectables;
        std::vector<Collectable_sprite*>::iterator collectables_iter;
        
        State current_state;
        
        int time_passed;
        bool is_first_pass;
        
        bool redraw_crystals;
        bool redraw_fish;
        bool redraw_score;
        bool redraw_level;
        bool redraw_lives;
        
        // Use these to help with collision detection.
        int rows_min_ys[NUM_ROWS];
        int rows_max_ys[NUM_ROWS];
        
        void create_logs();
        void create_collectables();
        void delete_logs_and_collectables();
        
        void check_collisions();
        
        RowDescription calc_alberts_row();
        
        CatLogCollisionType check_cat_log_collision(int row);
        void check_cat_collectable_collision(int row);
        void handle_crystal_collision(Crystal* c);
        void handle_bonus_collision(Bonus* b);
        void set_logs_to_brown(int row);
        
        // These two variables work together to prevent Albert
        // from picking up a swapped crystal over and over...
        bool cat_crystal_collisions_disabled;
        Crystal* disabled_crystal;
        
        RowDescription alberts_row;
        
}; // class Sprite_manager

} // namespace FS




#endif

        
    
