// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#ifndef Fish_h
#define Fish_h




#include "Sprite.h"
#include "constants.h"
#include "SDL.h"
#include "enums.h"
#include "FS_gfx.h"
#include <tr1/memory>




extern std::tr1::shared_ptr<FS::FS_gfx> gfx_ptr;




namespace FS
{
    
class Fish : public Sprite
{
    public:
        Fish();
        ~Fish();
        
        void reset();
        
        void draw();
        void remove_fish();
        
    private:
            
        static const int COLL_BOX_X_OFFSET = 5;
        static const int COLL_BOX_Y_OFFSET = 9;
        static const int COLL_BOX_WIDTH = 38;
        static const int COLL_BOX_HEIGHT = 19;

        static const int fish_x_c = 375;
        static const int fish_y_c = 25;
        static const int fish_w_c = 60;
        static const int fish_h_c = 28;
        
        bool fish_taken;
        
}; // class Fish

} // namespace FS




#endif

    
