// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#ifndef FS_gfx_h
#define FS_gfx_h

#include "Gfx_engine.h"




namespace FS
{
    
class FS_gfx : public Mafferyew::Gfx_engine
{
    
    public:
            
        FS_gfx();
        ~FS_gfx();
        
        static const int NUM_SPRITES = 99;
        enum Image_name
        {
            NONE = -1,
            LOWER_LIMIT,
            MIDDLE,
            UPPER_LIMIT,
            LOG_RED_1,
            LOG_RED_2,
            LOG_RED_3,
            LOG_RED_4,
            LOG_RED_5,
            LOG_YELLOW_1,
            LOG_YELLOW_2,
            LOG_YELLOW_3,
            LOG_YELLOW_4,
            LOG_YELLOW_5,
            LOG_BLUE_1,
            LOG_BLUE_2,
            LOG_BLUE_3,
            LOG_BLUE_4,
            LOG_BLUE_5,
            LOG_ORANGE_1,
            LOG_ORANGE_2,
            LOG_ORANGE_3,
            LOG_ORANGE_4,
            LOG_ORANGE_5,
            LOG_GREEN_1,
            LOG_GREEN_2,
            LOG_GREEN_3,
            LOG_GREEN_4,
            LOG_GREEN_5,
            LOG_PURPLE_1,
            LOG_PURPLE_2,
            LOG_PURPLE_3,
            LOG_PURPLE_4,
            LOG_PURPLE_5,
            LOG_BROWN_1,
            LOG_BROWN_2,
            LOG_BROWN_3,
            LOG_BROWN_4,
            LOG_BROWN_5,
            CRYSTAL_RED,
            CRYSTAL_YELLOW,
            CRYSTAL_BLUE,
            CRYSTAL_WHITE,
            FISH,
            SPRING,
            LEAF,
            ARROWS,
            SNAIL,
            LIGHTNING,
            STAR,
            PLATE,
            PAUSE_MENU_CONTINUE,
            PAUSE_MENU_QUIT,
            JOYSTICK,
            KEYBOARD, 
            SOUND_ON,
            SOUND_OFF,
            TICK,
            MESSAGE_BOARD,
            WALKING_0,
            WALKING_1,
            WALKING_2,
            WALKING_3,
            WALKING_4,
            WALKING_5,
            WALKING_6,
            WALKING_7,
            JUMPING_0,
            JUMPING_1,
            JUMPING_2,
            JUMPING_3,
            JUMPING_4,
            JUMPING_5,
            JUMPING_6,
            JUMPING_7,
            JUMPING_8,
            JUMPING_9,
            JUMPING_10,
            JUMPING_11,
            SPLASHING_0,
            SPLASHING_1,
            SPLASHING_2,
            SPLASHING_3,
            SPLASHING_4,
            SPLASHING_5,
            SPLASHING_6,
            SPLASHING_7,
            ZAPPING_0,
            ZAPPING_1,
            ZAPPING_2,
            ZAPPING_3,
            ZAPPING_4,
            WALKING_E_WITH_FISH_0,
            WALKING_E_WITH_FISH_1,
            WALKING_E_WITH_FISH_2,
            WALKING_E_WITH_FISH_3,
            WALKING_E_WITH_FISH_4,
            WALKING_E_WITH_FISH_5,
            WALKING_E_WITH_FISH_6,
            WALKING_E_WITH_FISH_7,
        }; // enum Image_name

        static const int NUM_BACKGROUNDS = 5;
        enum { GET_READY, CATS_WHISKERS, BACKGROUND, SETTINGS_BG, INTRO_SCREEN, };
        
        static const int NUM_FONTS = 6;
        enum Font_name
        {
            SMALL_FONT, 
            SMALL_FONT_FAINT, 
            LARGE_FONT, 
            LARGE_FONT_FAINT, 
            WHITE_FONT,
            TUTORIAL_FONT,  // DejaVu Sans Mono black 20pt
        }; // enum Font_name

        // extra functionality
        void clear_screen();
        
    protected:
            
        // Definition of pure virtual function inherited from
        // Gfx_engine.
        void init();

}; // class FS_gfx

} // namespace FS




#endif

