/*
	MultiMouse - bind MULTIple mice into a MOUSE -
	Copyright (C) 1995 Takashi MANABE (manabe@papilio.tutics.tut.ac.jp)

	MultiMouse is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published
	by the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	MultiMouse is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
	See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <signal.h>

#include "mumse.h"

static pid_t childPid;

static
void QuitDaemon()
{
#ifdef DEBUG
    printf("QuitDaemon\n");fflush(stdout);
#endif
    usleep(100000);
    close(msFifo);
    unlink(PATH_PID);
    exit(0);
}

/*
   create PID file and quit
*/

static
void QuitParent()
{
    FILE *fp;

    if ((fp = fopen(PATH_PID, "w")) == NULL) {
	perror(PATH_PID);
	exit(EOF);
    }
    fprintf(fp, "%d\n", childPid);
    fclose(fp);
    exit(0);
}

/*
   parent never return
*/

int MakeMeDaemon()
{
    pid_t parent;

    parent = getpid();
    signal(SIGTERM, QuitParent);
    close(fileno(stdin));
    close(fileno(stdout));
    if ((childPid = fork()) == -1) {	/* DW: this used to be vfork */
	perror("");
	return(EOF);
    }
    if (childPid) pause();
    setsid();
    close(fileno(stderr));
    kill(parent, SIGTERM);
}

void SetSignals()
{
    signal(SIGTERM, QuitDaemon);
    signal(SIGINT, QuitDaemon);
}

