/*
 * STAN -- Stream Analyser -- http://www.roqe.org/stan
 * Copyright (c) 2001-2004 Konrad Rieck <kr@roqe.org> 
 * All rights reserved.
 * ---
 * $Id: pattern.c,v 1.4 2003/12/10 20:29:29 kr Exp $
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    ``This product includes software developed by Konrad Rieck.''
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * ---
 *
 * This file contains everything dealing with the analysed pattern. 
 */

#include <stdio.h>
#include <ctype.h>

#include <stan.h>
#include <treap.h>
#include <pattern.h>
#include <config.h>

void print_pattern(tnode_t * n, size_t patlen)
{
   if (!n || !n->pattern || !n->count)
      return;
   print_byte(n->pattern, patlen);
   printf(": 0x%.8x", n->count);
}

void print_byte(byte_t * b, size_t patlen)
{
   size_t i;

   if (!b)
      return;

   printf("0x");

   for (i = 0; i < patlen; i++)
      printf("%.2x", b[i]);

   printf("(");

   for (i = 0; i < patlen; i++)
      printf("%c", isprint(b[i]) ? b[i] : ' ');

   printf(")");
}
