package main

import (
	"bytes"
	"compress/gzip"
	"encoding/ascii85"
	"fmt"
	"io"
	"log"
	"os"
)

func main() {
	if err := run(); err != nil {
		log.Fatal(err)
	}
}

const tmpl = `// Code generated by lichen/gen; DO NOT EDIT.

package db

var archive = []byte(%q)
`

func run() error {
	f, err := os.Open(os.Args[1])
	if err != nil {
		return err
	}
	defer f.Close()

	w, err := os.Create(os.Args[2])
	if err != nil {
		return err
	}
	defer w.Close()

	buf := &bytes.Buffer{}
	encoder := ascii85.NewEncoder(buf)
	gz := gzip.NewWriter(encoder)
	if _, err := io.Copy(gz, f); err != nil {
		return err
	}
	if err := gz.Flush(); err != nil {
		return err
	}
	if err := gz.Close(); err != nil {
		return err
	}
	if err := encoder.Close(); err != nil {
		return err
	}

	fmt.Fprintf(w, tmpl, buf.String())

	return nil
}
