/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.FileSet;

public class SignJar
extends Task {
    protected String jar;
    protected String alias;
    protected String keystore;
    protected String storepass;
    protected String storetype;
    protected String keypass;
    protected String sigfile;
    protected String signedjar;
    protected boolean verbose;
    protected boolean internalsf;
    protected boolean sectionsonly;
    protected Vector filesets = new Vector();
    protected boolean lazy;

    public void setJar(String string) {
        this.jar = string;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public void setKeystore(String string) {
        this.keystore = string;
    }

    public void setStorepass(String string) {
        this.storepass = string;
    }

    public void setStoretype(String string) {
        this.storetype = string;
    }

    public void setKeypass(String string) {
        this.keypass = string;
    }

    public void setSigfile(String string) {
        this.sigfile = string;
    }

    public void setSignedjar(String string) {
        this.signedjar = string;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setInternalsf(boolean bl) {
        this.internalsf = bl;
    }

    public void setSectionsonly(boolean bl) {
        this.sectionsonly = bl;
    }

    public void setLazy(boolean bl) {
        this.lazy = bl;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public void execute() throws BuildException {
        if (null == this.jar && null == this.filesets) {
            throw new BuildException("jar must be set through jar attribute or nested filesets");
        }
        if (null != this.jar) {
            this.doOneJar(this.jar, this.signedjar);
            return;
        }
        int n = 0;
        while (n < this.filesets.size()) {
            FileSet fileSet = (FileSet)this.filesets.elementAt(n);
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.project);
            String[] stringArray = directoryScanner.getIncludedFiles();
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.doOneJar(stringArray[n2], null);
                ++n2;
            }
            ++n;
        }
    }

    private void doOneJar(String string, String string2) throws BuildException {
        if (Project.getJavaVersion().equals("1.1")) {
            throw new BuildException("The signjar task is only available on JDK versions 1.2 or greater");
        }
        if (null == this.alias) {
            throw new BuildException("alias attribute must be set");
        }
        if (null == this.storepass) {
            throw new BuildException("storepass attribute must be set");
        }
        if (this.isUpToDate(string, string2)) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        ExecTask execTask = (ExecTask)this.project.createTask("exec");
        execTask.setExecutable("jarsigner");
        if (null != this.keystore) {
            execTask.createArg().setValue("-keystore");
            execTask.createArg().setValue(this.keystore);
        }
        if (null != this.storepass) {
            execTask.createArg().setValue("-storepass");
            execTask.createArg().setValue(this.storepass);
        }
        if (null != this.storetype) {
            execTask.createArg().setValue("-storetype");
            execTask.createArg().setValue(this.storetype);
        }
        if (null != this.keypass) {
            execTask.createArg().setValue("-keypass");
            execTask.createArg().setValue(this.keypass);
        }
        if (null != this.sigfile) {
            execTask.createArg().setValue("-sigfile");
            execTask.createArg().setValue(this.sigfile);
        }
        if (null != string2) {
            execTask.createArg().setValue("-signedjar");
            execTask.createArg().setValue(string2);
        }
        if (this.verbose) {
            execTask.createArg().setValue("-verbose");
        }
        if (this.internalsf) {
            execTask.createArg().setValue("-internalsf");
        }
        if (this.sectionsonly) {
            execTask.createArg().setValue("-sectionsonly");
        }
        execTask.createArg().setValue(string);
        execTask.createArg().setValue(this.alias);
        this.log("Signing Jar : " + new File(string).getAbsolutePath());
        execTask.setFailonerror(true);
        execTask.setTaskName(this.getTaskName());
        execTask.execute();
    }

    protected boolean isUpToDate(String string, String string2) {
        if (null == string) {
            return false;
        }
        if (null != string2) {
            File file = new File(string);
            File file2 = new File(string2);
            if (!file.exists()) {
                return false;
            }
            if (!file2.exists()) {
                return false;
            }
            if (file.equals(file2)) {
                return false;
            }
            if (file2.lastModified() > file.lastModified()) {
                return true;
            }
        } else if (this.lazy) {
            return this.isSigned(string);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isSigned(String var1_1) {
        var4_2 = new File(var1_1);
        if (!var4_2.exists()) {
            return false;
        }
        var5_3 = null;
        try {
            try {
                var5_3 = new ZipFile(var4_2);
                if (null == this.alias) {
                    block13: {
                        var6_4 = var5_3.entries();
                        do {
                            if (!var6_4.hasMoreElements()) break block13;
                        } while (!(var7_7 = var6_4.nextElement().getName()).startsWith("META-INF/") || !var7_7.endsWith(".SF"));
                        var8_10 = true;
                        var10_11 = null;
                        if (var5_3 == null) return var8_10;
                        try {
                            var5_3.close();
                            return var8_10;
                        }
                        catch (IOException var11_16) {
                            // empty catch block
                        }
                        return var8_10;
                    }
                    var7_8 = false;
                    var10_12 = null;
                    if (var5_3 == null) return var7_8;
                    ** try [egrp 2[TRYBLOCK] [2 : 192->200)] { 
lbl29:
                    // 1 sources

                    var5_3.close();
                    return var7_8;
lbl31:
                    // 1 sources

                    catch (IOException var11_17) {
                        // empty catch block
                    }
                    return var7_8;
                }
                var6_5 = var5_3.getEntry("META-INF/" + this.alias.toUpperCase() + ".SF") != null;
            }
            catch (IOException var6_6) {
                var7_9 = false;
                var10_14 = null;
                if (var5_3 == null) return var7_9;
                ** try [egrp 2[TRYBLOCK] [2 : 192->200)] { 
lbl43:
                // 1 sources

                var5_3.close();
                return var7_9;
lbl45:
                // 1 sources

                catch (IOException var11_19) {
                    // empty catch block
                }
                return var7_9;
            }
        }
        catch (Throwable var9_21) {
            var10_15 = null;
            if (var5_3 == null) throw var9_21;
            try {}
            catch (IOException var11_20) {
                throw var9_21;
            }
            var5_3.close();
            throw var9_21;
        }
        var10_13 = null;
        if (var5_3 == null) return var6_5;
        ** try [egrp 2[TRYBLOCK] [2 : 192->200)] { 
lbl61:
        // 1 sources

        var5_3.close();
        return var6_5;
lbl63:
        // 1 sources

        catch (IOException var11_18) {
            // empty catch block
        }
        return var6_5;
    }
}

