// C++ encapsulation for sonix v4l2 device
// by Bram Stolk

struct buffer
{
  void * start;
  size_t length;
};

class SonixCam
{
  public:

    SonixCam(const char *devname="/dev/video0", int width=352, int height=288);
    ~SonixCam();
    bool StartCapture(void);
    bool StopCapture(void);
    bool Sustain(void);
    unsigned char *GetImage(void) { return rgb; }
    bool ShowHistograms(bool v) { show_hists=v; return true; }
    bool SetGain(float v);
    float GetGain(void) { return gain; }
    bool SetCompression(bool v);
    bool SetJPEG(int v);
    bool DoNormalize(bool v) { do_normalize = v; return true; }
    bool DoAutoGain(bool v) { do_auto_gain = v; return true; }
    char *GetName(void) { return name; }

    // Analysis interface
    void Analyze(unsigned char *vals, int histo[256], bool ispost);
    void AnalyzeSuperimpose(unsigned char *vals, int histo[256], unsigned char rgb[3], int chartheight=64);
    void AnalyzeNormalize(unsigned char *vals, int histo[256]);
    float AnalyzeGainChange(float speed=0.04);

  protected:

    bool ProcessImage(unsigned char *p);
    bool ReadImage(void);

    int w,h;
    int fd;
    struct buffer *buffers;
    unsigned int n_buffers;
    unsigned char *rgb;
    unsigned char *uncompressed_src;
    bool capturing;
    bool show_hists;
    bool do_compression;
    bool do_normalize;
    bool do_auto_gain;
    float gain;
    char name[128];
};

