/*-
 * Copyright (c) 2003 by Thomas Moestl <tmm@FreeBSD.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $FreeBSD: stable/11/sys/sparc64/pci/ofw_pcib_subr.h 178279 2008-04-17 12:38:00Z marius $
 */

#ifndef _SPARC64_PCI_OFW_PCI_SUBR_H
#define	_SPARC64_PCI_OFW_PCI_SUBR_H

struct ofw_pcib_gen_softc {
	/*
	 * This is here so that we can use pci bridge methods, too - the
	 * generic routines only need the dev, secbus and subbus members
	 * filled.
	 */
	struct pcib_softc	ops_pcib_sc;
	phandle_t		ops_node;
	struct ofw_bus_iinfo	ops_iinfo;
};

void ofw_pcib_gen_setup(device_t);
pcib_route_interrupt_t ofw_pcib_gen_route_interrupt;
ofw_bus_get_node_t ofw_pcib_gen_get_node;

#endif /* !_SPARC64_PCI_OFW_PCI_SUBR_H */
