/*-
 * Copyright (c) 2009-2011 Nathan Whitehorn
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: stable/11/sys/powerpc/powermac/powermac_thermal.h 331722 2018-03-29 02:50:57Z eadler $
 */

#ifndef _POWERPC_POWERMAC_POWERMAC_THERMAL_H
#define _POWERPC_POWERMAC_POWERMAC_THERMAL_H

#define ZERO_C_TO_K 2731

struct pmac_fan {
	int min_rpm, max_rpm, default_rpm;
	
	char name[32];
	int zone;

	int (*read)(struct pmac_fan *);
	int (*set)(struct pmac_fan *, int value);
};

struct pmac_therm {
	int target_temp, max_temp;	/* Tenths of a degree K */
	
	char name[32];
	int zone;

	int (*read)(struct pmac_therm *);
};

void pmac_thermal_fan_register(struct pmac_fan *);
void pmac_thermal_sensor_register(struct pmac_therm *);

#endif
