/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.gef;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.Request;
import org.eclipse.gef.Tool;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.requests.AbstractCreateRequest;
import org.eclipse.wb.gef.core.tools.AbstractCreationTool;
import org.eclipse.wb.tests.gef.RequestTestCase;
import org.eclipse.wb.tests.gef.RequestTestCaseEditPart;
import org.eclipse.wb.tests.gef.RequestsLogger;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractCreationToolTest
extends RequestTestCase {
    protected AbstractCreateRequest m_request;
    protected AbstractCreationTool m_tool;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.configureTestCase();
    }

    protected abstract void configureTestCase();

    @Test
    public void test_Move_DND() throws Exception {
        RequestsLogger actualLogger = new RequestsLogger();
        RequestTestCaseEditPart editPart = AbstractCreationToolTest.addEditPart((EditPart)this.m_viewer.getRootEditPart(), "parentEditPart", actualLogger, 50, 50, 400, 300);
        RequestTestCaseEditPart childEditPart1 = AbstractCreationToolTest.addEditPart((EditPart)editPart, "childEditPart1", actualLogger, 50, 50, 70, 50);
        RequestTestCaseEditPart childEditPart2 = AbstractCreationToolTest.addEditPart((EditPart)editPart, "childEditPart2", actualLogger, 250, 25, 100, 155);
        RequestsLogger expectedLogger = new RequestsLogger();
        this.m_sender.moveTo(10, 10);
        actualLogger.assertEmpty();
        this.m_sender.moveTo(60, 60);
        this.m_request.setLocation(new Point(60, 60));
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, new String[]{"getTargetEditPart", "getTargetEditPart", "showTargetFeedback", "showTargetFeedback", "getCommand"}, (Request)this.m_request);
        AbstractCreationToolTest.assertLoggers(expectedLogger, actualLogger);
        this.m_sender.moveTo(120, 120);
        this.m_request.setLocation(new Point(120, 120));
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart1, new String[]{"getTargetEditPart", "getTargetEditPart"}, (Request)this.m_request);
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, "eraseTargetFeedback", (Request)this.m_request);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart1, new String[]{"showTargetFeedback", "showTargetFeedback", "getCommand"}, (Request)this.m_request);
        AbstractCreationToolTest.assertLoggers(expectedLogger, actualLogger);
        this.m_sender.moveTo(130, 130);
        this.m_request.setLocation(new Point(130, 130));
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart1, new String[]{"getTargetEditPart", "getTargetEditPart", "showTargetFeedback", "getCommand"}, (Request)this.m_request);
        AbstractCreationToolTest.assertLoggers(expectedLogger, actualLogger);
        this.m_sender.startDrag(130, 130, 1);
        actualLogger.assertEmpty();
        this.m_sender.dragTo(200, 200);
        this.m_request.setLocation(new Point(130, 130));
        this.m_request.setSize(new Dimension(70, 70));
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart1, new String[]{"showTargetFeedback", "getCommand"}, (Request)this.m_request);
        AbstractCreationToolTest.assertLoggers(expectedLogger, actualLogger);
        this.m_sender.dragTo(330, 140);
        this.m_request.setLocation(new Point(130, 130));
        this.m_request.setSize(new Dimension(200, 10));
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart1, new String[]{"showTargetFeedback", "getCommand"}, (Request)this.m_request);
        AbstractCreationToolTest.assertLoggers(expectedLogger, actualLogger);
        this.m_sender.endDrag();
        this.m_request.setLocation(new Point(130, 130));
        this.m_request.setSize(new Dimension(200, 10));
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart1, "eraseTargetFeedback", (Request)this.m_request);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart2, new String[]{"getTargetEditPart", "getTargetEditPart", "showTargetFeedback", "eraseTargetFeedback"}, (Request)this.m_request);
        AbstractCreationToolTest.assertLoggers(expectedLogger, actualLogger);
        this.m_sender.moveTo(300, 150);
        actualLogger.assertEmpty();
        this.m_sender.click(330, 170, 1);
        actualLogger.assertEmpty();
    }

    @Test
    public void test_Move_DND_InvalidInput() throws Exception {
        RequestsLogger actualLogger = new RequestsLogger();
        RequestTestCaseEditPart editPart = AbstractCreationToolTest.addEditPart((EditPart)this.m_viewer.getRootEditPart(), "editPart", actualLogger, 50, 50, 400, 300);
        RequestsLogger expectedLogger = new RequestsLogger();
        this.m_sender.moveTo(70, 70);
        this.m_request.setLocation(new Point(70, 70));
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, new String[]{"getTargetEditPart", "getTargetEditPart", "showTargetFeedback", "showTargetFeedback", "getCommand"}, (Request)this.m_request);
        AbstractCreationToolTest.assertLoggers(expectedLogger, actualLogger);
        this.m_sender.click(70, 70, 2);
        this.m_request.setLocation(new Point(70, 70));
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, "eraseTargetFeedback", (Request)this.m_request);
        AbstractCreationToolTest.assertLoggers(expectedLogger, actualLogger);
        this.m_sender.moveTo(80, 80);
        actualLogger.assertEmpty();
        this.m_domain.setActiveTool((Tool)this.m_tool);
        this.m_sender.moveTo(90, 90);
        this.m_request.setLocation(new Point(90, 90));
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, new String[]{"getTargetEditPart", "getTargetEditPart", "showTargetFeedback", "showTargetFeedback", "getCommand"}, (Request)this.m_request);
        AbstractCreationToolTest.assertLoggers(expectedLogger, actualLogger);
        this.m_sender.startDrag(90, 90, 1);
        actualLogger.assertEmpty();
        this.m_sender.dragTo(100, 100);
        this.m_request.setLocation(new Point(90, 90));
        this.m_request.setSize(new Dimension(10, 10));
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, new String[]{"showTargetFeedback", "getCommand"}, (Request)this.m_request);
        AbstractCreationToolTest.assertLoggers(expectedLogger, actualLogger);
        this.m_sender.click(100, 100, 3);
        this.m_request.setLocation(new Point(90, 90));
        this.m_request.setSize(new Dimension(10, 10));
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, "eraseTargetFeedback", (Request)this.m_request);
        AbstractCreationToolTest.assertLoggers(expectedLogger, actualLogger);
        this.m_sender.moveTo(100, 100);
        actualLogger.assertEmpty();
    }
}

