/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.FormLayout;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wb.internal.swing.FormLayout.model.FormColumnInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormDimensionInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormLayoutInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormRowInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.FormLayout.AbstractFormLayoutTest;
import org.junit.jupiter.api.Test;

public class FormLayoutGroupsTest
extends AbstractFormLayoutTest {
    @Test
    public void test_parsing() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    FormLayout formLayout = new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,});", "    setLayout(formLayout);", "    formLayout.setColumnGroups(new int[][]{new int[]{1, 3}});", "  }", "}");
        FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
        panel.refresh();
        try {
            List columns = layout.getColumns();
            FormColumnInfo column_0 = (FormColumnInfo)columns.get(0);
            FormColumnInfo column_1 = (FormColumnInfo)columns.get(1);
            FormColumnInfo column_2 = (FormColumnInfo)columns.get(2);
            List group_0 = layout.getColumnGroup(column_0);
            FormLayoutGroupsTest.assertNotNull((Object)group_0);
            FormLayoutGroupsTest.assertTrue((boolean)group_0.contains(column_0));
            FormLayoutGroupsTest.assertTrue((boolean)group_0.contains(column_2));
            FormLayoutGroupsTest.assertSame((Object)group_0, (Object)layout.getColumnGroup(column_2));
            FormLayoutGroupsTest.assertEquals((int)0, (int)layout.getDimensionGroupIndex((FormDimensionInfo)column_0));
            FormLayoutGroupsTest.assertEquals((int)0, (int)layout.getDimensionGroupIndex((FormDimensionInfo)column_2));
            FormLayoutGroupsTest.assertNull((Object)layout.getColumnGroup(column_1));
            FormLayoutGroupsTest.assertEquals((int)-1, (int)layout.getDimensionGroupIndex((FormDimensionInfo)column_1));
        }
        finally {
            panel.refresh_dispose();
        }
    }

    @Test
    public void test_removeFromGroup() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    FormLayout formLayout = new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,});", "    setLayout(formLayout);", "    formLayout.setColumnGroups(new int[][]{new int[]{1, 4}, new int[]{2, 3}});", "  }", "}");
        FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
        panel.refresh();
        try {
            List columns = layout.getColumns();
            FormColumnInfo column_1 = (FormColumnInfo)columns.get(1);
            FormLayoutGroupsTest.assertNotNull((Object)layout.getColumnGroup(column_1));
            layout.deleteColumn(1);
            FormLayoutGroupsTest.assertNull((Object)layout.getColumnGroup(column_1));
        }
        finally {
            panel.refresh_dispose();
        }
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    FormLayout formLayout = new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,});", "    setLayout(formLayout);", "    formLayout.setColumnGroups(new int[][]{new int[]{1, 3}});", "  }", "}");
    }

    @Test
    public void test_unGroupColumns() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    FormLayout formLayout = new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,});", "    setLayout(formLayout);", "    formLayout.setColumnGroups(new int[][]{new int[]{1, 2}});", "  }", "}");
        FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
        panel.refresh();
        try {
            List columns = layout.getColumns();
            FormColumnInfo column_0 = (FormColumnInfo)columns.get(0);
            FormColumnInfo column_1 = (FormColumnInfo)columns.get(1);
            FormLayoutGroupsTest.assertNotNull((Object)layout.getColumnGroup(column_0));
            FormLayoutGroupsTest.assertNotNull((Object)layout.getColumnGroup(column_1));
            ArrayList<FormColumnInfo> columnsToUnGroup = new ArrayList<FormColumnInfo>();
            columnsToUnGroup.add(column_1);
            layout.unGroupColumns(columnsToUnGroup);
            FormLayoutGroupsTest.assertNull((Object)layout.getColumnGroup(column_0));
        }
        finally {
            panel.refresh_dispose();
        }
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    FormLayout formLayout = new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,});", "    setLayout(formLayout);", "  }", "}");
    }

    @Test
    public void test_groupNew() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.RELATED_GAP_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,}));", "  }", "}");
        FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
        panel.refresh();
        try {
            List columns = layout.getColumns();
            FormColumnInfo column_0 = (FormColumnInfo)columns.get(0);
            FormColumnInfo column_1 = (FormColumnInfo)columns.get(1);
            FormColumnInfo column_2 = (FormColumnInfo)columns.get(2);
            FormColumnInfo column_3 = (FormColumnInfo)columns.get(3);
            FormColumnInfo column_4 = (FormColumnInfo)columns.get(4);
            ArrayList<FormColumnInfo> columnsToGroup = new ArrayList<FormColumnInfo>();
            columnsToGroup.add(column_0);
            columnsToGroup.add(column_3);
            layout.groupColumns(columnsToGroup);
            columnsToGroup = new ArrayList();
            columnsToGroup.add(column_2);
            columnsToGroup.add(column_4);
            columnsToGroup.add(column_1);
            layout.groupColumns(columnsToGroup);
        }
        finally {
            panel.refresh_dispose();
        }
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    FormLayout formLayout = new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.RELATED_GAP_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,});", "    formLayout.setColumnGroups(new int[][]{new int[]{1, 4}, new int[]{3, 5}});", "    setLayout(formLayout);", "  }", "}");
    }

    @Test
    public void test_ignoreOne() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,}));", "  }", "}");
        FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
        String expectedSource = this.m_lastEditor.getSource();
        panel.refresh();
        try {
            List columns = layout.getColumns();
            FormColumnInfo column_0 = (FormColumnInfo)columns.get(0);
            ArrayList<FormColumnInfo> columnsToGroup = new ArrayList<FormColumnInfo>();
            columnsToGroup.add(column_0);
            layout.groupColumns(columnsToGroup);
        }
        finally {
            panel.refresh_dispose();
        }
        FormLayoutGroupsTest.assertEditor(expectedSource, this.m_lastEditor);
    }

    @Test
    public void test_groupWithExisting() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    FormLayout formLayout = new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,});", "    setLayout(formLayout);", "    formLayout.setColumnGroups(new int[][]{new int[]{1, 2}});", "  }", "}");
        FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
        panel.refresh();
        try {
            List columns = layout.getColumns();
            FormColumnInfo column_0 = (FormColumnInfo)columns.get(0);
            FormColumnInfo column_1 = (FormColumnInfo)columns.get(1);
            FormColumnInfo column_2 = (FormColumnInfo)columns.get(2);
            FormLayoutGroupsTest.assertNotNull((Object)layout.getColumnGroup(column_0));
            FormLayoutGroupsTest.assertSame((Object)layout.getColumnGroup(column_0), (Object)layout.getColumnGroup(column_1));
            ArrayList<FormColumnInfo> columnsToGroup = new ArrayList<FormColumnInfo>();
            columnsToGroup.add(column_0);
            columnsToGroup.add(column_2);
            layout.groupColumns(columnsToGroup);
            FormLayoutGroupsTest.assertSame((Object)layout.getColumnGroup(column_0), (Object)layout.getColumnGroup(column_1));
        }
        finally {
            panel.refresh_dispose();
        }
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    FormLayout formLayout = new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,});", "    setLayout(formLayout);", "    formLayout.setColumnGroups(new int[][]{new int[]{1, 2, 3}});", "  }", "}");
    }

    @Test
    public void test_groupIgnoreTwoGroups() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    FormLayout formLayout = new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,});", "    setLayout(formLayout);", "    formLayout.setColumnGroups(new int[][]{new int[]{1, 2}, new int[]{3, 4}});", "  }", "}");
        FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
        String expectedSource = this.m_lastEditor.getSource();
        panel.refresh();
        try {
            List columns = layout.getColumns();
            FormColumnInfo column_2 = (FormColumnInfo)columns.get(0);
            FormColumnInfo column_3 = (FormColumnInfo)columns.get(3);
            FormLayoutGroupsTest.assertNotNull((Object)layout.getColumnGroup(column_2));
            FormLayoutGroupsTest.assertNotNull((Object)layout.getColumnGroup(column_3));
            FormLayoutGroupsTest.assertNotSame((Object)layout.getColumnGroup(column_2), (Object)layout.getColumnGroup(column_3));
            ArrayList<FormColumnInfo> columnsToGroup = new ArrayList<FormColumnInfo>();
            columnsToGroup.add(column_2);
            columnsToGroup.add(column_3);
            layout.groupColumns(columnsToGroup);
            FormLayoutGroupsTest.assertNotSame((Object)layout.getColumnGroup(column_2), (Object)layout.getColumnGroup(column_3));
        }
        finally {
            panel.refresh_dispose();
        }
        FormLayoutGroupsTest.assertEditor(expectedSource, this.m_lastEditor);
    }

    @Test
    public void test_groupRows() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    FormLayout formLayout = new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,});", "    setLayout(formLayout);", "    formLayout.setRowGroups(new int[][]{new int[]{1, 2}});", "  }", "}");
        FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
        panel.refresh();
        try {
            List rows = layout.getRows();
            FormRowInfo row_0 = (FormRowInfo)rows.get(0);
            FormRowInfo row_1 = (FormRowInfo)rows.get(1);
            FormRowInfo row_2 = (FormRowInfo)rows.get(2);
            FormLayoutGroupsTest.assertNotNull((Object)layout.getRowGroup(row_0));
            FormLayoutGroupsTest.assertSame((Object)layout.getRowGroup(row_0), (Object)layout.getRowGroup(row_1));
            ArrayList<FormRowInfo> rowsToGroup = new ArrayList<FormRowInfo>();
            rowsToGroup.add(row_0);
            rowsToGroup.add(row_2);
            layout.groupRows(rowsToGroup);
            FormLayoutGroupsTest.assertSame((Object)layout.getRowGroup(row_0), (Object)layout.getRowGroup(row_1));
        }
        finally {
            panel.refresh_dispose();
        }
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    FormLayout formLayout = new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,});", "    setLayout(formLayout);", "    formLayout.setRowGroups(new int[][]{new int[]{1, 2, 3}});", "  }", "}");
    }

    @Test
    public void test_unGroupRows() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    FormLayout formLayout = new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,});", "    setLayout(formLayout);", "    formLayout.setRowGroups(new int[][]{new int[]{1, 2}});", "  }", "}");
        FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
        panel.refresh();
        try {
            List rows = layout.getRows();
            FormRowInfo row_0 = (FormRowInfo)rows.get(0);
            FormRowInfo row_1 = (FormRowInfo)rows.get(1);
            FormLayoutGroupsTest.assertNotNull((Object)layout.getRowGroup(row_0));
            FormLayoutGroupsTest.assertNotNull((Object)layout.getRowGroup(row_1));
            FormLayoutGroupsTest.assertEquals((int)0, (int)layout.getDimensionGroupIndex((FormDimensionInfo)row_0));
            FormLayoutGroupsTest.assertEquals((int)0, (int)layout.getDimensionGroupIndex((FormDimensionInfo)row_1));
            ArrayList<FormRowInfo> rowsToUnGroup = new ArrayList<FormRowInfo>();
            rowsToUnGroup.add(row_1);
            layout.unGroupRows(rowsToUnGroup);
            FormLayoutGroupsTest.assertNull((Object)layout.getRowGroup(row_0));
            FormLayoutGroupsTest.assertEquals((int)-1, (int)layout.getDimensionGroupIndex((FormDimensionInfo)row_0));
        }
        finally {
            panel.refresh_dispose();
        }
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    FormLayout formLayout = new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,});", "    setLayout(formLayout);", "  }", "}");
    }
}

