/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.description;

import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.GenericPropertyDescription;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.GenericPropertyImpl;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.BooleanPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.string.StringPropertyEditor;
import org.eclipse.wb.internal.core.model.util.PropertyUtils;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class MethodPropertyRuleTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_subPropertiesAndAccessors() throws Exception {
        MethodPropertyRuleTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void setText(String someText, boolean html) {", "  }", "}"));
        MethodPropertyRuleTest.setFileContentSrc("test/MyPanel.wbp-component.xml", MethodPropertyRuleTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <method-property title='text' method='setText(java.lang.String,boolean)'/>", "</component>"));
        MethodPropertyRuleTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    setText('some text', true);", "  }", "}");
        MethodPropertyRuleTest.assertNotNull((Object)panel.getDescription().getMethod("setText(java.lang.String,boolean)"));
        GenericProperty methodProperty = (GenericProperty)panel.getPropertyByTitle("text");
        MethodPropertyRuleTest.assertNotNull((Object)methodProperty);
        MethodPropertyRuleTest.assertEquals((Object)"(properties)", (Object)MethodPropertyRuleTest.getPropertyText((Property)methodProperty));
        Property[] subProperties = MethodPropertyRuleTest.getSubProperties((Property)methodProperty);
        MethodPropertyRuleTest.assertEquals((int)2, (int)subProperties.length);
        GenericPropertyImpl subProperty = (GenericPropertyImpl)subProperties[0];
        MethodPropertyRuleTest.assertEquals((Object)"someText", (Object)subProperty.getTitle());
        MethodPropertyRuleTest.assertEquals((Object)"some text", (Object)subProperty.getValue());
        subProperty = (GenericPropertyImpl)subProperties[1];
        MethodPropertyRuleTest.assertEquals((Object)"html", (Object)subProperty.getTitle());
        MethodPropertyRuleTest.assertEquals((Object)Boolean.TRUE, (Object)subProperty.getValue());
    }

    @Test
    public void test_useNamesFromParameterDescription() throws Exception {
        MethodPropertyRuleTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void setText(String text, boolean html) {", "  }", "}"));
        MethodPropertyRuleTest.setFileContentSrc("test/MyPanel.wbp-component.xml", MethodPropertyRuleTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='setText'>", "      <parameter type='java.lang.String' name='myArg_0'/>", "      <parameter type='boolean' name='myArg_1'/>", "    </method>", "  </methods>", "  <method-property title='text' method='setText(java.lang.String,boolean)'/>", "</component>"));
        MethodPropertyRuleTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        GenericProperty methodProperty = (GenericProperty)panel.getPropertyByTitle("text");
        Property[] subProperties = MethodPropertyRuleTest.getSubProperties((Property)methodProperty);
        MethodPropertyRuleTest.assertEquals((Object)"myArg_0", (Object)subProperties[0].getTitle());
        MethodPropertyRuleTest.assertEquals((Object)"myArg_1", (Object)subProperties[1].getTitle());
    }

    @Test
    public void test_noExtraTopLevelProperties() throws Exception {
        MethodPropertyRuleTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void setText(String someText, boolean html) {", "  }", "}"));
        MethodPropertyRuleTest.setFileContentSrc("test/MyPanel.wbp-component.xml", MethodPropertyRuleTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <method-property title='text' method='setText(java.lang.String,boolean)'/>", "</component>"));
        MethodPropertyRuleTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    setText('some text', true);", "  }", "}");
        MethodPropertyRuleTest.assertNotNull((Object)PropertyUtils.getByPath((ObjectInfo)panel, (String)"text/someText"));
        MethodPropertyRuleTest.assertNotNull((Object)PropertyUtils.getByPath((ObjectInfo)panel, (String)"text/html"));
        MethodPropertyRuleTest.assertNull((Object)panel.getPropertyByTitle("someText"));
        MethodPropertyRuleTest.assertNull((Object)panel.getPropertyByTitle("html"));
    }

    @Test
    public void test_registeredSubProperties() throws Exception {
        MethodPropertyRuleTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void setText(String someText, boolean html) {", "  }", "}"));
        MethodPropertyRuleTest.setFileContentSrc("test/MyPanel.wbp-component.xml", MethodPropertyRuleTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <method-property title='text' method='setText(java.lang.String,boolean)'/>", "</component>"));
        MethodPropertyRuleTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        ComponentDescription description = panel.getDescription();
        String id = "setText(java.lang.String,boolean) 0";
        GenericPropertyDescription property = description.getProperty(id);
        MethodPropertyRuleTest.assertNotNull((Object)property);
        MethodPropertyRuleTest.assertSame((Object)property.getEditor(), (Object)StringPropertyEditor.INSTANCE);
        id = "setText(java.lang.String,boolean) 1";
        property = description.getProperty(id);
        MethodPropertyRuleTest.assertNotNull((Object)property);
        MethodPropertyRuleTest.assertSame((Object)property.getEditor(), (Object)BooleanPropertyEditor.INSTANCE);
    }
}

