/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.eval.primities;

import org.eclipse.wb.tests.designer.core.eval.AbstractEngineTest;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class FloatTest
extends AbstractEngineTest {
    @BeforeAll
    public static void setUpClass() throws Exception {
        FloatTest.do_projectCreate();
    }

    @Test
    public void test_float_value1() throws Exception {
        this.check_float("1F", 1.0f);
    }

    @Test
    public void test_float_value2() throws Exception {
        this.check_float("2f", 2.0f);
    }

    @Test
    public void test_float_positive_value() throws Exception {
        this.check_float("+3f", 3.0f);
    }

    @Test
    public void test_float_negative_value() throws Exception {
        this.check_float("-3f", -3.0f);
    }

    @Test
    public void test_float_plus() throws Exception {
        this.check_float("1F + 2F", 3.0f);
    }

    @Test
    public void test_float_plus3() throws Exception {
        this.check_float("1F + 2F + 3F", 6.0f);
    }

    @Test
    public void test_float_minus() throws Exception {
        this.check_float("5F - 1F", 4.0f);
    }

    @Test
    public void test_float_mul() throws Exception {
        this.check_float("2F * 3F", 6.0f);
    }

    @Test
    public void test_float_div() throws Exception {
        this.check_float("6F / 2F", 3.0f);
    }

    @Test
    public void test_float_div2() throws Exception {
        this.check_float("5F / 2F", 2.5f);
    }

    @Test
    public void test_float_mod() throws Exception {
        this.check_float("5F % 2F", 1.0f);
    }

    @Test
    public void test_float_mod2() throws Exception {
        this.check_float("-5F % 3F", -2.0f);
    }

    @Test
    public void test_float_mix_int() throws Exception {
        this.check_float("1F + 2", 3.0f);
    }

    @Test
    public void test_float_mix_char() throws Exception {
        this.check_float("1F + '0'", 49.0f);
    }

    @Test
    public void test_float_cast_to() throws Exception {
        this.check_float("((float)1) + 2", 3.0f);
    }

    private void check_float(String expression, float expected) throws Exception {
        FloatTest.assertEquals((Object)Float.valueOf(expected), (Object)this.evaluateExpression(expression, "float"));
    }
}

