/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.check;

import java.text.MessageFormat;
import org.eclipse.wb.internal.core.utils.check.AssertionFailedException;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;

public final class Assert {
    private Assert() {
    }

    public static boolean isLegal(boolean expression) {
        return Assert.isLegal(expression, "");
    }

    public static boolean isLegal(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
        return expression;
    }

    public static void isNull(Object object) {
        Assert.isNull(object, "null argument expected");
    }

    public static void isNull(Object object, String message) {
        if (object != null) {
            throw new AssertionFailedException(message);
        }
    }

    public static void isNull(Object object, String errorFormat, Object ... args) {
        if (object != null) {
            String message = String.format(errorFormat, args);
            Assert.fail(message);
        }
    }

    public static void isNull2(Object object, String errorFormat, Object ... args) {
        if (object != null) {
            String message = MessageFormat.format(errorFormat, args);
            Assert.fail(message);
        }
    }

    public static void isNotNull(Object object) {
        Assert.isNotNull(object, "null argument");
    }

    public static void isNotNull(Object object, String message) {
        if (object == null) {
            Assert.fail(message);
        }
    }

    public static void isNotNull(Object object, String errorFormat, Object ... args) {
        if (object == null) {
            Assert.fail(String.format(errorFormat, args));
        }
    }

    public static void isNotNull2(Object object, String errorFormat, Object ... args) {
        if (object == null) {
            String message = MessageFormat.format(errorFormat, args);
            Assert.fail(message);
        }
    }

    public static void fail(String message) {
        throw new AssertionFailedException(message);
    }

    public static void fail(String errorFormat, Object ... args) {
        String message = MessageFormat.format(errorFormat, args);
        throw new AssertionFailedException(message);
    }

    public static boolean isTrue(boolean expression) {
        return Assert.isTrue(expression, "assertion failed");
    }

    public static boolean isTrue(boolean expression, String message) {
        if (!expression) {
            Assert.fail(message);
        }
        return expression;
    }

    public static boolean isTrue(boolean expression, String errorFormat, Object ... args) {
        if (!expression) {
            String message = String.format(errorFormat, args);
            Assert.fail(message);
        }
        return expression;
    }

    public static boolean isTrue2(boolean expression, String errorFormat, Object ... args) {
        if (!expression) {
            Assert.fail(errorFormat, args);
        }
        return expression;
    }

    public static void equals(int expected, int actual) {
        Assert.equals(expected, actual, expected + " expected, but " + actual + " found");
    }

    public static void equals(int expected, int actual, String message) {
        if (expected != actual) {
            Assert.fail(message);
        }
    }

    public static void instanceOf(Class<?> expectedClass, Object o) {
        if (o == null) {
            Assert.fail(expectedClass.getName() + " expected, but 'null' found.");
        }
        if (!expectedClass.isAssignableFrom(o.getClass())) {
            Assert.fail(expectedClass.getName() + " expected, but " + o.getClass().getName() + " found.");
        }
    }

    public static void isTrueException(boolean expression, int exceptionCode, Object ... parameters) {
        if (!expression) {
            Object[] paramStrings = new String[parameters.length];
            int i = 0;
            while (i < parameters.length) {
                Object parameter = parameters[i];
                paramStrings[i] = parameter != null ? parameter.toString() : "null";
                ++i;
            }
            throw new DesignerException(exceptionCode, paramStrings);
        }
    }
}

