/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.gef.core.tools;

import org.eclipse.gef.Request;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.core.requests.CreateRequest;
import org.eclipse.wb.gef.core.requests.ICreationFactory;
import org.eclipse.wb.gef.core.tools.AbstractCreationTool;

public class CreationTool
extends AbstractCreationTool {
    private final ICreationFactory m_factory;

    public CreationTool(ICreationFactory factory) {
        this.m_factory = factory;
    }

    @Override
    public void activate() {
        super.activate();
        try {
            this.m_factory.activate();
        }
        catch (Throwable e) {
            this.getDomain().loadDefaultTool();
        }
    }

    public final ICreationFactory getFactory() {
        return this.m_factory;
    }

    @Override
    protected Request createTargetRequest() {
        return new CreateRequest(this.m_factory);
    }

    @Override
    protected void selectAddedObjects() {
        EditPart editPart;
        IEditPartViewer viewer;
        CreateRequest request = (CreateRequest)this.getTargetRequest();
        Object model = request.getSelectObject();
        if (model != null && (viewer = this.getCurrentViewer()) != null && (editPart = (EditPart)((Object)viewer.getEditPartRegistry().get(model))) != null) {
            viewer.select((org.eclipse.gef.EditPart)editPart);
        }
    }
}

