/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.palette.model.entry;

import java.io.File;
import java.io.IOException;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.palette.model.entry.LibraryInfo;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public final class BundleLibraryInfo
implements LibraryInfo {
    public static final QualifiedName VERSION = new QualifiedName("org.eclipse.wb.core", "version");
    private final String typeName;
    private final String symbolicName;

    public BundleLibraryInfo(IConfigurationElement element) {
        this.typeName = ExternalFactoriesHelper.getRequiredAttribute((IConfigurationElement)element, (String)"type");
        this.symbolicName = ExternalFactoriesHelper.getRequiredAttribute((IConfigurationElement)element, (String)"symbolicName");
    }

    public BundleLibraryInfo(String symbolicName, String typeName) {
        this.typeName = typeName;
        this.symbolicName = symbolicName;
    }

    @Override
    public void ensure(IJavaProject javaProject) throws Exception {
        Object bundleFile;
        IType type = javaProject.findType(this.typeName);
        Bundle bundle = ExternalFactoriesHelper.getRequiredBundle((String)this.symbolicName);
        if (type != null) {
            bundleFile = type.getResource();
            if (bundleFile == null) {
                return;
            }
            Version bundleVersion = this.getBundleVersion((IResource)bundleFile);
            if (bundleVersion == null || bundleVersion.compareTo(bundle.getVersion()) < 0) {
                type = null;
                IPath bundlePath = bundleFile.getFullPath();
                Predicate<IClasspathEntry> versionComparator = classpath -> bundlePath.equals((Object)classpath.getPath());
                ProjectUtils.removeClasspathEntries(javaProject, versionComparator);
                bundleFile.delete(true, null);
                ProjectUtils.waitForAutoBuild();
            }
        }
        if (type == null) {
            bundleFile = FileLocator.getBundleFileLocation((Bundle)bundle).orElse(null);
            if (bundleFile != null) {
                ProjectUtils.addJar(javaProject, ((File)bundleFile).getAbsolutePath(), null);
                ProjectUtils.waitForAutoBuild();
            } else {
                DesignerPlugin.log((IStatus)Status.warning((String)("Unable to find bundle file " + String.valueOf(bundleFile))));
            }
        }
    }

    private Version getBundleVersion(IResource bundleResource) {
        if (bundleResource instanceof IFile) {
            IFile bundleFile = (IFile)bundleResource;
            try {
                String versionString = bundleResource.getPersistentProperty(VERSION);
                if (versionString != null) {
                    return Version.parseVersion((String)versionString);
                }
            }
            catch (CoreException e) {
                DesignerPlugin.log((Throwable)e);
            }
            File javaFile = bundleFile.getLocation().toFile();
            try {
                Throwable throwable = null;
                Object var5_8 = null;
                try (JarFile jarFile = new JarFile(javaFile);){
                    Manifest manifest = jarFile.getManifest();
                    Attributes attributes = manifest.getMainAttributes();
                    String versionString = attributes.getValue("Bundle-Version");
                    bundleResource.setPersistentProperty(VERSION, versionString);
                    return Version.parseVersion((String)versionString);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | CoreException e) {
                DesignerPlugin.log((Throwable)e);
            }
        }
        return null;
    }
}

