/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.burningwave.core.Component;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.function.ThrowingBiFunction;
import org.burningwave.core.function.ThrowingFunction;

public abstract class FieldAccessor
implements Component {
    public static final String REG_EXP_FOR_SIMPLE_FIELDS = "([a-zA-Z\\$\\_\\-0-9]*)(\\[*.*)";
    public static final String REG_EXP_FOR_INDEXES_OF_INDEXED_FIELDS = "\\[(.*?)\\]";
    private List<ThrowingBiFunction<Object, String, Object, Throwable>> fieldRetrievers = this.getFieldRetrievers();
    private List<ThrowingFunction<Object[], Boolean, Throwable>> fieldSetters = this.getFieldSetters();
    private Pattern simpleFieldSearcher = Pattern.compile("([a-zA-Z\\$\\_\\-0-9]*)(\\[*.*)");
    private Pattern indexesSearcherForIndexedField = Pattern.compile("\\[(.*?)\\]");

    FieldAccessor() {
    }

    abstract List<ThrowingFunction<Object[], Boolean, Throwable>> getFieldSetters();

    abstract List<ThrowingBiFunction<Object, String, Object, Throwable>> getFieldRetrievers();

    public <T> T get(Object obj, String path) {
        if (path == null) {
            throw new IllegalArgumentException("Field path cannot be null");
        }
        String[] pathSegments = path.split("\\.");
        Object objToReturn = obj;
        for (int j = 0; j < pathSegments.length; ++j) {
            objToReturn = this.getField(j != 0 ? objToReturn : obj, pathSegments[j]);
        }
        return (T)objToReturn;
    }

    private Object getField(Object obj, String pathSegment) {
        Object objToReturn = null;
        Matcher matcher = this.simpleFieldSearcher.matcher(pathSegment);
        matcher.find();
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        for (ThrowingBiFunction<Object, String, Object, Throwable> retriever : this.fieldRetrievers) {
            try {
                objToReturn = retriever.apply(obj, matcher.group(1));
                if (objToReturn == null) continue;
                break;
            }
            catch (Throwable exc) {
                exceptions.add(exc);
            }
        }
        this.manageGetFieldExceptions(exceptions);
        if (!matcher.group(2).isEmpty()) {
            try {
                objToReturn = this.retrieveFromIndexedField(objToReturn, matcher.group(2));
            }
            catch (Throwable exc) {
                exceptions.add(exc);
            }
        }
        return objToReturn;
    }

    private void manageGetFieldExceptions(List<Throwable> exceptions) {
        if (exceptions.size() > 0) {
            String message = "";
            for (Throwable exception : exceptions) {
                message = message + exception.getMessage() + "\n";
            }
            message = message.substring(0, message.length() - 1);
            if (exceptions.size() == this.fieldRetrievers.size()) {
                StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, message.toString());
                StaticComponentContainer.Driver.throwException(exceptions.iterator().next());
            }
        }
    }

    public void set(Object obj, String path, Object value) {
        if (path == null) {
            throw new IllegalArgumentException("Field path cannot be null");
        }
        if (path.trim().isEmpty()) {
            return;
        }
        Object target = path.contains(".") ? this.get(obj, path.substring(0, path.lastIndexOf("."))) : obj;
        String targetPathSegment = path.contains(".") ? path.substring(path.lastIndexOf(".") + 1, path.length()) : path;
        this.setField(target, targetPathSegment, value);
    }

    private void setField(Object target, String pathSegment, Object value) {
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        for (ThrowingFunction<Object[], Boolean, Throwable> setter : this.fieldSetters) {
            try {
                setter.apply(new Object[]{target, pathSegment, value});
                break;
            }
            catch (Throwable exc) {
                exceptions.add(exc);
            }
        }
        this.manageGetFieldExceptions(exceptions);
    }

    private <T> Object retrieveFromIndexedField(Object fieldValue, String indexes) {
        Matcher matcher = this.indexesSearcherForIndexedField.matcher(indexes);
        if (matcher.find()) {
            String index = matcher.group(1);
            Supplier<Object> propertyRetriever = null;
            if (fieldValue.getClass().isArray()) {
                propertyRetriever = () -> Array.get(fieldValue, Integer.valueOf(index));
            } else if (fieldValue instanceof List) {
                propertyRetriever = () -> ((List)fieldValue).get(Integer.valueOf(index));
            } else if (fieldValue instanceof Map) {
                propertyRetriever = () -> ((Map)fieldValue).get(index);
            } else if (fieldValue instanceof Collection) {
                propertyRetriever = () -> {
                    Collection collection = (Collection)fieldValue;
                    int indexAsInt = this.convertAndCheckIndex(collection, index);
                    Iterator itr = collection.iterator();
                    int currentIterationIndex = 0;
                    while (itr.hasNext()) {
                        Object currentIteartedObject = itr.next();
                        if (currentIterationIndex++ != indexAsInt) continue;
                        return currentIteartedObject;
                    }
                    return null;
                };
            } else {
                return StaticComponentContainer.Driver.throwException("indexed property {} of type {} is not supporterd", new Object[]{fieldValue, fieldValue.getClass()});
            }
            return this.retrieveFromIndexedField(propertyRetriever.get(), indexes.substring(matcher.end(), indexes.length()));
        }
        return fieldValue;
    }

    Object retrieveFieldByDirectAccess(Object target, String pathSegment) throws IllegalAccessException {
        if (pathSegment.trim().isEmpty()) {
            return target;
        }
        return StaticComponentContainer.Fields.getDirect(target, pathSegment);
    }

    Object retrieveFieldByGetterMethod(Object target, String pathSegment) {
        if (pathSegment.trim().isEmpty()) {
            return target;
        }
        Object objToReturn = StaticComponentContainer.Methods.invokeDirect(target, StaticComponentContainer.Methods.createGetterMethodNameByFieldPath(pathSegment), new Object[0]);
        return objToReturn;
    }

    private <T> void setInIndexedField(Object fieldValue, String indexes, Object value) {
        Matcher matcher = this.indexesSearcherForIndexedField.matcher(indexes);
        int lastIndexOf = 0;
        String index = null;
        while (matcher.find()) {
            index = matcher.group(1);
            lastIndexOf = matcher.start();
        }
        Object targetObject = this.retrieveFromIndexedField(fieldValue, indexes.substring(0, lastIndexOf));
        if (targetObject.getClass().isArray()) {
            Array.set(targetObject, Integer.valueOf(index), value);
        } else if (targetObject instanceof List) {
            ((List)targetObject).set(Integer.valueOf(index), value);
        } else if (targetObject instanceof Map) {
            ((Map)targetObject).put(index, value);
        } else if (targetObject instanceof Collection) {
            this.setIndexedValue((Collection)targetObject, index, value);
        } else {
            StaticComponentContainer.Driver.throwException("indexed property {} of type {} is not supporterd", new Object[]{fieldValue, fieldValue.getClass()});
        }
    }

    private <T> void setIndexedValue(Collection<T> collection, String index, Object value) {
        int indexAsInt = this.convertAndCheckIndex(collection, index);
        ArrayList<T> tempList = new ArrayList<T>();
        Iterator<Object> itr = collection.iterator();
        while (itr.hasNext()) {
            tempList.add(itr.next());
        }
        int iterationIndex = 0;
        collection.clear();
        for (Object origVal : tempList) {
            if (iterationIndex++ != indexAsInt) {
                collection.add(origVal);
                continue;
            }
            collection.add(value);
        }
    }

    private <T> int convertAndCheckIndex(Collection<T> collection, String indexAsString) {
        int index = Integer.valueOf(indexAsString);
        if (collection.size() < index) {
            throw new IndexOutOfBoundsException("Illegal index " + indexAsString + ", collection size " + collection.size());
        }
        return index;
    }

    Boolean setFieldByDirectAccess(Object target, String pathSegment, Object value) throws IllegalAccessException {
        Matcher matcher = this.simpleFieldSearcher.matcher(pathSegment);
        matcher.find();
        if (matcher.group(2).isEmpty()) {
            Field field = StaticComponentContainer.Fields.findOneAndMakeItAccessible(target.getClass(), matcher.group(1));
            StaticComponentContainer.Fields.setDirect(target, field, value);
        } else if (target.getClass().isArray() || target instanceof Map || target instanceof Collection) {
            this.setInIndexedField(target, matcher.group(2), value);
        } else {
            Field field = StaticComponentContainer.Fields.findOneAndMakeItAccessible(target.getClass(), matcher.group(1));
            this.setInIndexedField(field.get(target), matcher.group(2), value);
        }
        return Boolean.TRUE;
    }

    Boolean setFieldBySetterMethod(Object target, String pathSegment, Object value) {
        Matcher matcher = this.simpleFieldSearcher.matcher(pathSegment);
        matcher.find();
        if (matcher.group(2).isEmpty()) {
            StaticComponentContainer.Methods.invokeDirect(target, StaticComponentContainer.Methods.createSetterMethodNameByFieldPath(matcher.group(1)), value);
        } else if (target.getClass().isArray() || target instanceof Map || target instanceof Collection) {
            this.setInIndexedField(target, matcher.group(2), value);
        } else {
            this.setInIndexedField(StaticComponentContainer.Methods.invokeDirect(target, StaticComponentContainer.Methods.createGetterMethodNameByFieldPath(matcher.group(1)), new Object[0]), matcher.group(2), value);
        }
        return Boolean.TRUE;
    }

    public static class ByMethodOrByField
    extends FieldAccessor {
        private ByMethodOrByField() {
        }

        public static ByMethodOrByField create() {
            return new ByMethodOrByField();
        }

        @Override
        List<ThrowingBiFunction<Object, String, Object, Throwable>> getFieldRetrievers() {
            ArrayList<ThrowingBiFunction<Object, String, Object, Throwable>> retrievers = new ArrayList<ThrowingBiFunction<Object, String, Object, Throwable>>();
            retrievers.add((object, pathSegment) -> this.retrieveFieldByGetterMethod(object, (String)pathSegment));
            retrievers.add((object, pathSegment) -> this.retrieveFieldByDirectAccess(object, (String)pathSegment));
            return retrievers;
        }

        @Override
        List<ThrowingFunction<Object[], Boolean, Throwable>> getFieldSetters() {
            ArrayList<ThrowingFunction<Object[], Boolean, Throwable>> retrievers = new ArrayList<ThrowingFunction<Object[], Boolean, Throwable>>();
            retrievers.add(objects -> this.setFieldBySetterMethod(objects[0], (String)objects[1], objects[2]));
            retrievers.add(objects -> this.setFieldByDirectAccess(objects[0], (String)objects[1], objects[2]));
            return retrievers;
        }
    }

    public static class ByFieldOrByMethod
    extends FieldAccessor {
        private ByFieldOrByMethod() {
        }

        public static ByFieldOrByMethod create() {
            return new ByFieldOrByMethod();
        }

        @Override
        List<ThrowingBiFunction<Object, String, Object, Throwable>> getFieldRetrievers() {
            ArrayList<ThrowingBiFunction<Object, String, Object, Throwable>> retrievers = new ArrayList<ThrowingBiFunction<Object, String, Object, Throwable>>();
            retrievers.add((object, pathSegment) -> this.retrieveFieldByDirectAccess(object, (String)pathSegment));
            retrievers.add((object, pathSegment) -> this.retrieveFieldByGetterMethod(object, (String)pathSegment));
            return retrievers;
        }

        @Override
        List<ThrowingFunction<Object[], Boolean, Throwable>> getFieldSetters() {
            ArrayList<ThrowingFunction<Object[], Boolean, Throwable>> setters = new ArrayList<ThrowingFunction<Object[], Boolean, Throwable>>();
            setters.add(objects -> this.setFieldByDirectAccess(objects[0], (String)objects[1], objects[2]));
            setters.add(objects -> this.setFieldBySetterMethod(objects[0], (String)objects[1], objects[2]));
            return setters;
        }
    }
}

