/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.component;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipProvider;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class JTreeTest
extends SwingModelTest {
    @Test
    public void test_JTree_parsing() throws Exception {
        ContainerInfo panel = this.parseContainer("import javax.swing.tree.*;", "public class Test extends JPanel {", "  public Test() {", "    JTree tree = new JTree();", "    add(tree);", "    tree.setModel(new DefaultTreeModel(", "      new DefaultMutableTreeNode('(root)') {", "        {", "          DefaultMutableTreeNode node1 = new DefaultMutableTreeNode('1');", "            DefaultMutableTreeNode node2 = new DefaultMutableTreeNode('11');", "            node1.add(node2);", "          add(node1);", "          node1 = new DefaultMutableTreeNode('2');", "            node1.add(new DefaultMutableTreeNode('21'));", "          add(node1);", "        }", "      }", "    ));", "  }", "}");
        panel.refresh();
        ComponentInfo treeInfo = (ComponentInfo)panel.getChildrenComponents().get(0);
        JTree treeObject = (JTree)treeInfo.getObject();
        TreeModel model = treeObject.getModel();
        JTreeTest.assertNotNull((Object)model);
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)model.getRoot();
        JTreeTest.assertEquals((Object)"(root)", (Object)rootNode.getUserObject());
        JTreeTest.assertEquals((int)2, (int)rootNode.getChildCount());
        DefaultMutableTreeNode node_1 = (DefaultMutableTreeNode)rootNode.getChildAt(0);
        JTreeTest.assertEquals((Object)"1", (Object)node_1.getUserObject());
        JTreeTest.assertEquals((int)1, (int)node_1.getChildCount());
        DefaultMutableTreeNode node_2 = (DefaultMutableTreeNode)node_1.getChildAt(0);
        JTreeTest.assertEquals((Object)"11", (Object)node_2.getUserObject());
        JTreeTest.assertEquals((int)0, (int)node_2.getChildCount());
        node_1 = (DefaultMutableTreeNode)rootNode.getChildAt(1);
        JTreeTest.assertEquals((Object)"2", (Object)node_1.getUserObject());
        JTreeTest.assertEquals((int)1, (int)node_1.getChildCount());
        node_2 = (DefaultMutableTreeNode)node_1.getChildAt(0);
        JTreeTest.assertEquals((Object)"21", (Object)node_2.getUserObject());
        JTreeTest.assertEquals((int)0, (int)node_2.getChildCount());
        Property modelProperty = treeInfo.getPropertyByTitle("model");
        PropertyEditor modelEditor = modelProperty.getEditor();
        String text = (String)ReflectionUtils.invokeMethod2((Object)modelEditor, (String)"getText", Property.class, (Object)modelProperty);
        JTreeTest.assertEquals((Object)"(root), +1, ++11, +2, ++21", (Object)text);
        String tooltip = JTreeTest.getPropertyTooltipText((IAdaptable)modelEditor, modelProperty);
        JTreeTest.assertEquals((Object)StringUtils.join((Object[])new String[]{"(root)", "    1", "        11", "    2", "        21"}, (String)"\n"), (Object)tooltip);
        PropertyTooltipProvider provider = (PropertyTooltipProvider)modelEditor.getAdapter(PropertyTooltipProvider.class);
        JTreeTest.assertSame((Object)1, (Object)provider.getTooltipPosition());
    }

    @Test
    public void test_emptyModel() throws Exception {
        ContainerInfo panel = this.parseContainer("import javax.swing.tree.*;", "public class Test extends JPanel {", "  public Test() {", "    JTree tree = new JTree();", "    add(tree);", "    tree.setModel(null);", "  }", "}");
        panel.refresh();
        ComponentInfo treeInfo = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property modelProperty = treeInfo.getPropertyByTitle("model");
        PropertyEditor modelEditor = modelProperty.getEditor();
        String text = (String)ReflectionUtils.invokeMethod2((Object)modelEditor, (String)"getText", Property.class, (Object)modelProperty);
        JTreeTest.assertNull((Object)text);
        String tooltip = JTreeTest.getPropertyTooltipText((IAdaptable)modelEditor, modelProperty);
        JTreeTest.assertNull((Object)tooltip);
    }

    @Test
    public void test_setItems() throws Exception {
        ContainerInfo panel = this.parseContainer("import javax.swing.tree.*;", "public class Test extends JPanel {", "  public Test() {", "    JTree tree = new JTree();", "    add(tree);", "  }", "}");
        panel.refresh();
        ComponentInfo treeInfo = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property modelProperty = treeInfo.getPropertyByTitle("model");
        PropertyEditor modelEditor = modelProperty.getEditor();
        Object rootItem = JTreeTest.createItemInformation(0, "(root)");
        Object item_1 = JTreeTest.addItemInformation(rootItem, "aaa");
        JTreeTest.addItemInformation(item_1, "1");
        JTreeTest.addItemInformation(item_1, "2");
        Object item_2 = JTreeTest.addItemInformation(rootItem, "bbb");
        JTreeTest.addItemInformation(item_2, "3");
        ReflectionUtils.invokeMethod((Object)modelEditor, (String)"setItems(org.eclipse.wb.internal.core.model.property.Property,int,org.eclipse.wb.internal.swing.model.property.editor.models.tree.TreeModelDialog.ItemInformation)", (Object[])new Object[]{modelProperty, 3, rootItem});
        this.assertEditor("import javax.swing.tree.*;", "public class Test extends JPanel {", "  public Test() {", "    JTree tree = new JTree();", "    tree.setModel(new DefaultTreeModel(", "      new DefaultMutableTreeNode('(root)') {", "        {", "          DefaultMutableTreeNode node_1;", "          node_1 = new DefaultMutableTreeNode('aaa');", "            node_1.add(new DefaultMutableTreeNode('1'));", "            node_1.add(new DefaultMutableTreeNode('2'));", "          add(node_1);", "          node_1 = new DefaultMutableTreeNode('bbb');", "            node_1.add(new DefaultMutableTreeNode('3'));", "          add(node_1);", "        }", "      }", "    ));", "    add(tree);", "  }", "}");
    }

    private static Object createItemInformation(int level, String text) throws Exception {
        Class<?> itemClass = Class.forName("org.eclipse.wb.internal.swing.model.property.editor.models.tree.TreeModelDialog$ItemInformation");
        return ReflectionUtils.newInstance(itemClass, (String)"<init>(int,java.lang.String)", (Object[])new Object[]{level, text});
    }

    public static Object addItemInformation(Object parentItem, String text) throws Exception {
        int parentLevel = (Integer)ReflectionUtils.invokeMethod2((Object)parentItem, (String)"getLevel");
        Object childItem = JTreeTest.createItemInformation(parentLevel + 1, text);
        Object parentChildren = ReflectionUtils.invokeMethod2((Object)parentItem, (String)"getChildren");
        ReflectionUtils.invokeMethod2((Object)parentChildren, (String)"add", Object.class, (Object)childItem);
        return childItem;
    }
}

