/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.component;

import java.util.List;
import javax.swing.JLayeredPane;
import org.eclipse.wb.internal.core.model.presentation.IObjectPresentation;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.component.JLayeredPaneInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class JLayeredPaneTest
extends SwingModelTest {
    @Test
    public void test_layer_Constraints() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JLayeredPane pane = new JLayeredPane();", "    add(pane);", "    {", "      JButton button = new JButton();", "      pane.add(button, new Integer(10));", "    }", "  }", "}");
        panel.refresh();
        JLayeredPaneInfo pane = (JLayeredPaneInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)pane.getChildrenComponents().get(0);
        JLayeredPaneTest.assertEquals((int)10, (int)((JLayeredPane)pane.getObject()).getLayer(button.getComponent()));
        Property layerProperty = button.getPropertyByTitle("Layer");
        JLayeredPaneTest.assertNotNull((Object)layerProperty);
        JLayeredPaneTest.assertTrue((boolean)layerProperty.isModified());
        JLayeredPaneTest.assertEquals((Object)10, (Object)layerProperty.getValue());
        layerProperty.setValue((Object)20);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JLayeredPane pane = new JLayeredPane();", "    add(pane);", "    {", "      JButton button = new JButton();", "      pane.setLayer(button, 20);", "      pane.add(button);", "    }", "  }", "}");
        JLayeredPaneTest.assertEquals((Object)20, (Object)layerProperty.getValue());
    }

    @Test
    public void test_layer_noConstraints() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JLayeredPane pane = new JLayeredPane();", "    add(pane);", "    {", "      JButton button = new JButton();", "      pane.add(button, BorderLayout.NORTH);", "    }", "  }", "}");
        panel.refresh();
        JLayeredPaneInfo pane = (JLayeredPaneInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)pane.getChildrenComponents().get(0);
        JLayeredPaneTest.assertEquals((int)0, (int)((JLayeredPane)pane.getObject()).getLayer(button.getComponent()));
        Property layerProperty = button.getPropertyByTitle("Layer");
        JLayeredPaneTest.assertNotNull((Object)layerProperty);
        JLayeredPaneTest.assertTrue((boolean)layerProperty.isModified());
        JLayeredPaneTest.assertEquals((Object)0, (Object)layerProperty.getValue());
        layerProperty.setValue((Object)20);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JLayeredPane pane = new JLayeredPane();", "    add(pane);", "    {", "      JButton button = new JButton();", "      pane.setLayer(button, 20);", "      pane.add(button, BorderLayout.NORTH);", "    }", "  }", "}");
        JLayeredPaneTest.assertEquals((Object)20, (Object)layerProperty.getValue());
    }

    @Test
    public void test_layer_setLayer_1() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JLayeredPane pane = new JLayeredPane();", "    add(pane);", "    {", "      JButton button = new JButton();", "      pane.add(button);", "      pane.setLayer(button, 10);", "    }", "  }", "}");
        panel.refresh();
        JLayeredPaneInfo pane = (JLayeredPaneInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)pane.getChildrenComponents().get(0);
        JLayeredPaneTest.assertEquals((int)10, (int)((JLayeredPane)pane.getObject()).getLayer(button.getComponent()));
        Property layerProperty = button.getPropertyByTitle("Layer");
        JLayeredPaneTest.assertNotNull((Object)layerProperty);
        JLayeredPaneTest.assertTrue((boolean)layerProperty.isModified());
        JLayeredPaneTest.assertEquals((Object)10, (Object)layerProperty.getValue());
        layerProperty.setValue((Object)20);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JLayeredPane pane = new JLayeredPane();", "    add(pane);", "    {", "      JButton button = new JButton();", "      pane.add(button);", "      pane.setLayer(button, 20);", "    }", "  }", "}");
        JLayeredPaneTest.assertEquals((Object)20, (Object)layerProperty.getValue());
    }

    @Test
    public void test_layer_setLayer_2() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JLayeredPane pane = new JLayeredPane();", "    add(pane);", "    {", "      JButton button = new JButton();", "      pane.add(button);", "      pane.setLayer(button, 10, 5);", "    }", "  }", "}");
        panel.refresh();
        JLayeredPaneInfo pane = (JLayeredPaneInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)pane.getChildrenComponents().get(0);
        JLayeredPaneTest.assertEquals((int)10, (int)((JLayeredPane)pane.getObject()).getLayer(button.getComponent()));
        Property layerProperty = button.getPropertyByTitle("Layer");
        JLayeredPaneTest.assertNotNull((Object)layerProperty);
        JLayeredPaneTest.assertTrue((boolean)layerProperty.isModified());
        JLayeredPaneTest.assertEquals((Object)10, (Object)layerProperty.getValue());
        layerProperty.setValue((Object)20);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JLayeredPane pane = new JLayeredPane();", "    add(pane);", "    {", "      JButton button = new JButton();", "      pane.add(button);", "      pane.setLayer(button, 20, 5);", "    }", "  }", "}");
        JLayeredPaneTest.assertEquals((Object)20, (Object)layerProperty.getValue());
    }

    @Test
    public void test_layer_setLayer_remove() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JLayeredPane pane = new JLayeredPane();", "    add(pane);", "    {", "      JButton button = new JButton();", "      pane.add(button);", "      pane.setLayer(button, 10);", "    }", "  }", "}");
        panel.refresh();
        JLayeredPaneInfo pane = (JLayeredPaneInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)pane.getChildrenComponents().get(0);
        JLayeredPaneTest.assertEquals((int)10, (int)((JLayeredPane)pane.getObject()).getLayer(button.getComponent()));
        Property layerProperty = button.getPropertyByTitle("Layer");
        JLayeredPaneTest.assertNotNull((Object)layerProperty);
        JLayeredPaneTest.assertTrue((boolean)layerProperty.isModified());
        JLayeredPaneTest.assertEquals((Object)10, (Object)layerProperty.getValue());
        layerProperty.setValue(Property.UNKNOWN_VALUE);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JLayeredPane pane = new JLayeredPane();", "    add(pane);", "    {", "      JButton button = new JButton();", "      pane.add(button);", "    }", "  }", "}");
        JLayeredPaneTest.assertEquals((Object)0, (Object)layerProperty.getValue());
    }

    @Test
    public void test_getGraphicalChildren() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JLayeredPane pane = new JLayeredPane();", "    add(pane);", "    {", "      JButton button_1 = new JButton();", "      pane.add(button_1);", "      pane.setLayer(button_1, 5);", "    }", "    {", "      JButton button_2 = new JButton();", "      pane.add(button_2);", "      pane.setLayer(button_2, 10);", "    }", "    {", "      JButton button_3 = new JButton();", "      pane.add(button_3);", "      pane.setLayer(button_3, 10);", "    }", "  }", "}");
        panel.refresh();
        JLayeredPaneInfo pane = (JLayeredPaneInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_1 = (ComponentInfo)pane.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)pane.getChildrenComponents().get(1);
        ComponentInfo button_3 = (ComponentInfo)pane.getChildrenComponents().get(2);
        IObjectPresentation presentation = pane.getPresentation();
        List graphical = presentation.getChildrenGraphical();
        JLayeredPaneTest.assertEquals((Object)graphical, List.of(button_2, button_3, button_1));
    }
}

