/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.rcp;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wb.core.editor.palette.PaletteEventListener;
import org.eclipse.wb.core.editor.palette.model.CategoryInfo;
import org.eclipse.wb.core.editor.palette.model.entry.SelectionToolEntryInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.ObjectInfoUtils;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.model.generation.GenerationSettings;
import org.eclipse.wb.internal.core.model.presentation.IObjectPresentation;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.variable.EmptyPureVariableSupport;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.check.AssertionFailedException;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.rcp.ToolkitProvider;
import org.eclipse.wb.internal.rcp.model.rcp.perspective.AbstractPartInfo;
import org.eclipse.wb.internal.rcp.model.rcp.perspective.EditorAreaInfo;
import org.eclipse.wb.internal.rcp.model.rcp.perspective.FolderViewInfo;
import org.eclipse.wb.internal.rcp.model.rcp.perspective.IPageLayoutTopLevelInfo;
import org.eclipse.wb.internal.rcp.model.rcp.perspective.PageLayoutAddCreationSupport;
import org.eclipse.wb.internal.rcp.model.rcp.perspective.PageLayoutAddViewInfo;
import org.eclipse.wb.internal.rcp.model.rcp.perspective.PageLayoutCreateFolderInfo;
import org.eclipse.wb.internal.rcp.model.rcp.perspective.PageLayoutCreationSupport;
import org.eclipse.wb.internal.rcp.model.rcp.perspective.PageLayoutInfo;
import org.eclipse.wb.internal.rcp.model.rcp.perspective.PageLayoutTopBoundsSupport;
import org.eclipse.wb.internal.rcp.model.rcp.perspective.SashLineInfo;
import org.eclipse.wb.internal.rcp.model.rcp.perspective.shortcuts.FastViewContainerInfo;
import org.eclipse.wb.internal.rcp.model.rcp.perspective.shortcuts.FastViewInfo;
import org.eclipse.wb.internal.rcp.model.rcp.perspective.shortcuts.PerspectiveShortcutContainerInfo;
import org.eclipse.wb.internal.rcp.model.rcp.perspective.shortcuts.PerspectiveShortcutInfo;
import org.eclipse.wb.internal.rcp.model.rcp.perspective.shortcuts.ViewShortcutContainerInfo;
import org.eclipse.wb.internal.rcp.model.rcp.perspective.shortcuts.ViewShortcutInfo;
import org.eclipse.wb.tests.designer.core.PdeProjectConversionUtils;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.eclipse.wb.tests.designer.rcp.model.rcp.AbstractPdeTest;
import org.junit.jupiter.api.Test;

public class PageLayoutTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_canNotEditPalette() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "  }", "}");
        boolean[] canEdit = new boolean[]{true};
        ((PaletteEventListener)page.getBroadcast(PaletteEventListener.class)).canEdit(canEdit);
        PageLayoutTest.assertFalse((boolean)canEdit[0]);
    }

    @Test
    public void test_0() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    String editorArea = layout.getEditorArea();", "    addFastViews(layout);", "    addViewShortcuts(layout);", "    addPerspectiveShortcuts(layout);", "    layout.addView('org.eclipse.jdt.ui.PackageExplorer', IPageLayout.LEFT, 0.3f, editorArea);", "    layout.addView('org.eclipse.jdt.ui.TypeHierarchy', IPageLayout.BOTTOM, 0.7f, editorArea);", "  }", "  private void addFastViews(IPageLayout layout) {", "  }", "  private void addViewShortcuts(IPageLayout layout) {", "  }", "  private void addPerspectiveShortcuts(IPageLayout layout) {", "  }", "}");
        PageLayoutTest.assertHierarchy("{parameter: layout} {layout} {/layout.getEditorArea()/ /addFastViews(layout)/ /addViewShortcuts(layout)/ /addPerspectiveShortcuts(layout)/ /layout.addView('org.eclipse.jdt.ui.PackageExplorer', IPageLayout.LEFT, 0.3f, editorArea)/ /layout.addView('org.eclipse.jdt.ui.TypeHierarchy', IPageLayout.BOTTOM, 0.7f, editorArea)/}", "  (editor area)", "  {void} {void} {/layout.addView('org.eclipse.jdt.ui.PackageExplorer', IPageLayout.LEFT, 0.3f, editorArea)/}", "  {void} {void} {/layout.addView('org.eclipse.jdt.ui.TypeHierarchy', IPageLayout.BOTTOM, 0.7f, editorArea)/}", "  (fast views)", "  (view shortcuts)", "  (perspective shortcuts)");
        PageLayoutTest.assertEquals((Object)"(editor area)", (Object)page.getEditorArea().toString());
        PageLayoutTest.assertEquals((Object)"(fast views)", (Object)page.getFastViewContainer().toString());
        PageLayoutTest.assertEquals((Object)"(view shortcuts)", (Object)page.getViewShortcutContainer().toString());
        PageLayoutTest.assertEquals((Object)"(perspective shortcuts)", (Object)page.getPerspectiveShortcutContainer().toString());
        List parts = page.getParts();
        Assertions.assertThat((List)parts).hasSize(2);
    }

    @Test
    public void test_PageLayout_CreationSupport() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "  }", "}");
        PageLayoutCreationSupport creationSupport = (PageLayoutCreationSupport)page.getCreationSupport();
        SingleVariableDeclaration parameter = (SingleVariableDeclaration)creationSupport.getNode();
        PageLayoutTest.assertEquals((Object)"layout", (Object)parameter.getName().getIdentifier());
        PageLayoutTest.assertEquals((Object)"parameter: layout", (Object)creationSupport.toString());
        PageLayoutTest.assertFalse((boolean)creationSupport.canBeEvaluated());
        PageLayoutTest.assertFalse((boolean)creationSupport.canDelete());
        PageLayoutTest.assertFalse((boolean)creationSupport.canReorder());
        PageLayoutTest.assertFalse((boolean)creationSupport.canReparent());
    }

    @Test
    public void test_PageLayout_TopBoundsSupport() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "  }", "}");
        PageLayoutTopBoundsSupport topBoundsSupport = (PageLayoutTopBoundsSupport)page.getTopBoundsSupport();
        page.refresh();
        PageLayoutTest.assertEquals((int)600, (int)page.getBounds().width);
        PageLayoutTest.assertEquals((int)500, (int)page.getBounds().height);
        topBoundsSupport.setSize(800, 600);
        page.refresh();
        PageLayoutTest.assertEquals((int)800, (int)page.getBounds().width);
        PageLayoutTest.assertEquals((int)600, (int)page.getBounds().height);
    }

    @Test
    public void test_EditorArea() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "  }", "}");
        this.refresh();
        EditorAreaInfo editorArea = page.getEditorArea();
        PageLayoutTest.assertSame((Object)page, (Object)editorArea.getPage());
        PageLayoutTest.assertEquals((Object)"org.eclipse.ui.editorss", (Object)editorArea.getId());
        PageLayoutTest.assertEquals((Object)"org.eclipse.ui.IPageLayout.ID_EDITOR_AREA", (Object)editorArea.getIdSource());
        PageLayoutTest.assertEquals((Object)"(editor area)", (Object)editorArea.toString());
        IObjectPresentation presentation = editorArea.getPresentation();
        PageLayoutTest.assertNotNull((Object)presentation.getIcon());
        PageLayoutTest.assertEquals((Object)"(editor area)", (Object)presentation.getText());
        Rectangle bounds = editorArea.getBounds();
        PageLayoutTest.assertEquals((int)bounds.x, (int)0);
        PageLayoutTest.assertEquals((int)bounds.y, (int)0);
        Assertions.assertThat((int)bounds.width).isGreaterThan(550);
        Assertions.assertThat((int)bounds.height).isGreaterThan(450);
    }

    @Test
    public void test_editorAreaVisible_false() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.setEditorAreaVisible(false);", "    String editorArea = layout.getEditorArea();", "    layout.addView('org.eclipse.ui.console.ConsoleView', IPageLayout.LEFT, 0.5f, IPageLayout.ID_EDITOR_AREA);", "  }", "}");
        EditorAreaInfo editorArea = page.getEditorArea();
        PageLayoutAddViewInfo view = (PageLayoutAddViewInfo)page.getParts().get(0);
        page.refresh();
        PageLayoutTest.assertNoErrors((JavaInfo)page);
        Rectangle editorBounds = editorArea.getBounds();
        Rectangle viewBounds = view.getBounds();
        Assertions.assertThat((int)editorBounds.x).isGreaterThan(550);
        PageLayoutTest.assertEquals((int)editorBounds.y, (int)0);
        PageLayoutTest.assertEquals((int)editorBounds.width, (int)0);
        Assertions.assertThat((int)editorBounds.height).isGreaterThan(450);
        PageLayoutTest.assertEquals((int)viewBounds.x, (int)0);
        PageLayoutTest.assertEquals((int)viewBounds.y, (int)0);
        Assertions.assertThat((int)viewBounds.width).isGreaterThan(450);
        PageLayoutTest.assertEquals((int)viewBounds.height, (int)editorBounds.height);
    }

    @Test
    public void test_properties() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "  }", "}");
        Property property = page.getPropertyByTitle("editorAreaVisible");
        PageLayoutTest.assertNotNull((Object)property);
        PageLayoutTest.assertTrue((boolean)((Boolean)property.getValue()));
        property = page.getPropertyByTitle("editorReuseThreshold");
        PageLayoutTest.assertNotNull((Object)property);
        property = page.getPropertyByTitle("fixed");
        PageLayoutTest.assertNotNull((Object)property);
        PageLayoutTest.assertFalse((boolean)((Boolean)property.getValue()));
    }

    @Test
    public void test_PageLayout_add_CreationSupport() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    String editorArea = layout.getEditorArea();", "    layout.addView('org.eclipse.jdt.ui.PackageExplorer', IPageLayout.LEFT, 0.3f, editorArea);", "  }", "}");
        PageLayoutAddViewInfo view = (PageLayoutAddViewInfo)page.getParts().get(0);
        PageLayoutTest.assertSame((Object)page, (Object)view.getPage());
        PageLayoutTest.assertEquals((Object)"\"org.eclipse.jdt.ui.PackageExplorer\"", (Object)view.getIdSource());
        PageLayoutTest.assertEquals((Object)"org.eclipse.jdt.ui.PackageExplorer", (Object)view.getId());
        PageLayoutTest.assertEquals((int)1, (int)view.getRelationship());
        PageLayoutTest.assertEquals((float)0.3f, (float)view.getRatio(), (float)0.001f);
        PageLayoutTest.assertEquals((Object)"org.eclipse.ui.editorss", (Object)view.getRefId());
        PageLayoutTest.assertEquals((Object)"editorArea", (Object)view.getRefIdSource());
        IObjectPresentation presentation = view.getPresentation();
        PageLayoutTest.assertNotNull((Object)presentation.getIcon());
        PageLayoutTest.assertEquals((Object)"\"Package Explorer\" - org.eclipse.jdt.ui.PackageExplorer", (Object)presentation.getText());
        PageLayoutAddCreationSupport creationSupport = (PageLayoutAddCreationSupport)view.getCreationSupport();
        PageLayoutTest.assertTrue((boolean)creationSupport.canReorder());
        PageLayoutTest.assertTrue((boolean)creationSupport.canReparent());
        try {
            NodeTarget nodeTarget = PageLayoutTest.getNodeStatementTarget((JavaInfo)page, "createInitialLayout(org.eclipse.ui.IPageLayout)", false, 1);
            creationSupport.add_getSource(nodeTarget);
            PageLayoutTest.fail();
        }
        catch (AssertionFailedException assertionFailedException) {
            // empty catch block
        }
    }

    @Test
    public void test_sashLines() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.addView('view_0', IPageLayout.LEFT, 0.3f, IPageLayout.ID_EDITOR_AREA);", "    layout.addView('view_1', IPageLayout.TOP, 0.3f, IPageLayout.ID_EDITOR_AREA);", "    layout.addView('view_2', IPageLayout.BOTTOM, 0.3f, IPageLayout.ID_EDITOR_AREA);", "    layout.addView('view_3', IPageLayout.RIGHT, 0.3f, IPageLayout.ID_EDITOR_AREA);", "  }", "}");
        page.refresh();
        PageLayoutAddViewInfo view_0 = (PageLayoutAddViewInfo)page.getParts().get(0);
        PageLayoutAddViewInfo view_1 = (PageLayoutAddViewInfo)page.getParts().get(1);
        PageLayoutAddViewInfo view_2 = (PageLayoutAddViewInfo)page.getParts().get(2);
        PageLayoutAddViewInfo view_3 = (PageLayoutAddViewInfo)page.getParts().get(3);
        PageLayoutTest.assertEquals((Object)new Dimension(600, 500), (Object)page.getBounds().getSize());
        SashLineInfo line_0 = view_0.getSashLine();
        SashLineInfo line_1 = view_1.getSashLine();
        SashLineInfo line_2 = view_2.getSashLine();
        SashLineInfo line_3 = view_3.getSashLine();
        PageLayoutTest.assertSame((Object)view_0, (Object)line_0.getPart());
        PageLayoutTest.assertSame((Object)view_1, (Object)line_1.getPart());
        PageLayoutTest.assertSame((Object)view_2, (Object)line_2.getPart());
        PageLayoutTest.assertSame((Object)view_3, (Object)line_3.getPart());
        Rectangle bounds_0 = line_0.getBounds();
        Rectangle bounds_1 = line_1.getBounds();
        Rectangle bounds_2 = line_2.getBounds();
        Rectangle bounds_3 = line_3.getBounds();
        SashLineInfo line = line_0;
        ((AbstractStringAssert)Assertions.assertThat((String)line.toString()).contains(new CharSequence[]{"view_0"})).contains(new CharSequence[]{"true"});
        PageLayoutTest.assertSame((Object)view_0, (Object)line.getPart());
        PageLayoutTest.assertEquals((int)16, (int)line.getPosition());
        PageLayoutTest.assertTrue((boolean)line.isHorizontal());
        Assertions.assertThat((int)bounds_0.x).isGreaterThan(150);
        Assertions.assertThat((int)bounds_0.y).isZero();
        PageLayoutTest.assertEquals((int)bounds_0.width, (int)3);
        Assertions.assertThat((int)bounds_0.height).isGreaterThanOrEqualTo(450);
        Assertions.assertThat((int)line_0.getPartBounds().x).isZero();
        Assertions.assertThat((int)line_0.getPartBounds().y).isZero();
        PageLayoutTest.assertEquals((int)line_0.getPartBounds().right(), (int)bounds_0.x);
        PageLayoutTest.assertEquals((int)line_0.getPartBounds().height, (int)bounds_0.height);
        Assertions.assertThat((int)line_0.getRefBounds().x).isZero();
        Assertions.assertThat((int)line_0.getRefBounds().y).isZero();
        Assertions.assertThat((int)line_0.getRefBounds().width).isGreaterThan(550);
        Assertions.assertThat((int)line_0.getRefBounds().height).isGreaterThan(450);
        line = line_1;
        ((AbstractStringAssert)Assertions.assertThat((String)line.toString()).contains(new CharSequence[]{"view_1"})).contains(new CharSequence[]{"false"});
        PageLayoutTest.assertSame((Object)view_1, (Object)line.getPart());
        PageLayoutTest.assertEquals((int)4, (int)line.getPosition());
        PageLayoutTest.assertFalse((boolean)line.isHorizontal());
        PageLayoutTest.assertEquals((int)bounds_1.x, (int)(bounds_0.x + bounds_0.width));
        Assertions.assertThat((int)bounds_1.y).isGreaterThan(130);
        Assertions.assertThat((int)bounds_1.width).isGreaterThan(350);
        PageLayoutTest.assertEquals((int)bounds_1.height, (int)3);
        line = line_2;
        ((AbstractStringAssert)Assertions.assertThat((String)line.toString()).contains(new CharSequence[]{"view_2"})).contains(new CharSequence[]{"false"});
        PageLayoutTest.assertSame((Object)view_2, (Object)line.getPart());
        PageLayoutTest.assertEquals((int)1, (int)line.getPosition());
        PageLayoutTest.assertFalse((boolean)line.isHorizontal());
        PageLayoutTest.assertEquals((int)bounds_2.x, (int)bounds_1.x);
        PageLayoutTest.assertEquals((int)bounds_2.height, (int)3);
        PageLayoutTest.assertEquals((int)bounds_2.width, (int)bounds_1.width);
        line = line_3;
        ((AbstractStringAssert)Assertions.assertThat((String)line.toString()).contains(new CharSequence[]{"view_3"})).contains(new CharSequence[]{"true"});
        PageLayoutTest.assertSame((Object)view_3, (Object)line.getPart());
        PageLayoutTest.assertEquals((int)8, (int)line.getPosition());
        PageLayoutTest.assertTrue((boolean)line.isHorizontal());
        PageLayoutTest.assertEquals((int)bounds_3.y, (int)(bounds_1.y + bounds_1.height));
        PageLayoutTest.assertEquals((int)bounds_3.width, (int)3);
        PageLayoutTest.assertEquals((int)bounds_3.height, (int)(bounds_2.y - (bounds_1.y + bounds_1.height)));
    }

    @Test
    public void test_deduceSettings() throws Exception {
        GenerationSettings generationSettings = ToolkitProvider.DESCRIPTION.getGenerationSettings();
        generationSettings.setDeduceSettings(true);
        this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    String editorArea = layout.getEditorArea();", "    layout.addView('0', IPageLayout.LEFT, 0.3f, editorArea);", "    layout.addView('1', IPageLayout.LEFT, 0.3f, editorArea);", "    layout.addView('2', IPageLayout.LEFT, 0.3f, editorArea);", "    layout.addView('3', IPageLayout.LEFT, 0.3f, editorArea);", "  }", "}");
    }

    @Test
    public void test_addView_LEFT() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    String editorArea = layout.getEditorArea();", "    layout.addView('org.eclipse.jdt.ui.PackageExplorer', IPageLayout.LEFT, 0.3f, editorArea);", "  }", "}");
        EditorAreaInfo editorArea = page.getEditorArea();
        PageLayoutAddViewInfo view = (PageLayoutAddViewInfo)page.getParts().get(0);
        page.refresh();
        PageLayoutTest.assertNoErrors((JavaInfo)page);
        Rectangle editorBounds = editorArea.getBounds();
        Rectangle viewBounds = view.getBounds();
        PageLayoutTest.assertEquals((int)viewBounds.x, (int)0);
        PageLayoutTest.assertEquals((int)viewBounds.y, (int)0);
        Assertions.assertThat((int)viewBounds.width).isGreaterThan(150);
        Assertions.assertThat((int)viewBounds.height).isGreaterThan(450);
        PageLayoutTest.assertEquals((int)editorBounds.x, (int)(viewBounds.right() + 3));
        PageLayoutTest.assertEquals((int)editorBounds.y, (int)0);
        PageLayoutTest.assertEquals((int)editorBounds.height, (int)viewBounds.height);
        PageLayoutTest.assertPartsSizes(viewBounds.width, editorBounds.width, 0.3, 0.7);
    }

    @Test
    public void test_addView_RIGHT() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    String editorArea = layout.getEditorArea();", "    layout.addView('org.eclipse.jdt.ui.PackageExplorer', IPageLayout.RIGHT, 0.7f, editorArea);", "  }", "}");
        EditorAreaInfo editorArea = page.getEditorArea();
        PageLayoutAddViewInfo view = (PageLayoutAddViewInfo)page.getParts().get(0);
        page.refresh();
        PageLayoutTest.assertNoErrors((JavaInfo)page);
        Rectangle editorBounds = editorArea.getBounds();
        Rectangle viewBounds = view.getBounds();
        PageLayoutTest.assertEquals((int)editorBounds.x, (int)0);
        PageLayoutTest.assertEquals((int)editorBounds.y, (int)0);
        Assertions.assertThat((int)editorBounds.width).isGreaterThan(150);
        Assertions.assertThat((int)editorBounds.height).isGreaterThan(450);
        PageLayoutTest.assertEquals((int)viewBounds.x, (int)(editorBounds.right() + 3));
        PageLayoutTest.assertEquals((int)viewBounds.y, (int)0);
        PageLayoutTest.assertEquals((int)viewBounds.height, (int)editorBounds.height);
        PageLayoutTest.assertPartsSizes(viewBounds.width, editorBounds.width, 0.3, 0.7);
    }

    @Test
    public void test_addView_TOP() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    String editorArea = layout.getEditorArea();", "    layout.addView('org.eclipse.jdt.ui.PackageExplorer', IPageLayout.TOP, 0.3f, editorArea);", "  }", "}");
        EditorAreaInfo editorArea = page.getEditorArea();
        PageLayoutAddViewInfo view = (PageLayoutAddViewInfo)page.getParts().get(0);
        page.refresh();
        PageLayoutTest.assertNoErrors((JavaInfo)page);
        Rectangle editorBounds = editorArea.getBounds();
        Rectangle viewBounds = view.getBounds();
        PageLayoutTest.assertEquals((int)viewBounds.x, (int)0);
        PageLayoutTest.assertEquals((int)viewBounds.y, (int)0);
        Assertions.assertThat((int)viewBounds.width).isGreaterThan(500);
        Assertions.assertThat((int)viewBounds.height).isGreaterThan(100);
        PageLayoutTest.assertEquals((int)editorBounds.x, (int)0);
        PageLayoutTest.assertEquals((int)editorBounds.y, (int)(viewBounds.bottom() + 3));
        PageLayoutTest.assertEquals((int)editorBounds.width, (int)viewBounds.width);
        PageLayoutTest.assertPartsSizes(viewBounds.height, editorBounds.height, 0.3, 0.7);
    }

    @Test
    public void test_addView_BOTTOM() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    String editorArea = layout.getEditorArea();", "    layout.addView('org.eclipse.jdt.ui.PackageExplorer', IPageLayout.BOTTOM, 0.7f, editorArea);", "  }", "}");
        EditorAreaInfo editorArea = page.getEditorArea();
        PageLayoutAddViewInfo view = (PageLayoutAddViewInfo)page.getParts().get(0);
        page.refresh();
        PageLayoutTest.assertNoErrors((JavaInfo)page);
        Rectangle editorBounds = editorArea.getBounds();
        Rectangle viewBounds = view.getBounds();
        PageLayoutTest.assertEquals((int)editorBounds.x, (int)0);
        PageLayoutTest.assertEquals((int)editorBounds.y, (int)0);
        Assertions.assertThat((int)editorBounds.width).isGreaterThan(550);
        Assertions.assertThat((int)editorBounds.height).isGreaterThan(300);
        PageLayoutTest.assertEquals((int)viewBounds.x, (int)0);
        PageLayoutTest.assertEquals((int)viewBounds.y, (int)(editorBounds.bottom() + 3));
        PageLayoutTest.assertEquals((int)viewBounds.width, (int)editorBounds.width);
        PageLayoutTest.assertPartsSizes(viewBounds.height, editorBounds.height, 0.3, 0.7);
    }

    @Test
    public void test_addView_viewInFolderAsReference() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    String editorArea = layout.getEditorArea();", "    IFolderLayout folder = layout.createFolder('folder.1', IPageLayout.TOP, 0.4f, editorArea);", "    folder.addView('view.1');", "    layout.addView('view.2', IPageLayout.LEFT, 0.3f, 'view.1');", "  }", "}");
        PageLayoutTest.assertHierarchy("{parameter: layout} {layout} {/layout.getEditorArea()/ /layout.createFolder('folder.1', IPageLayout.TOP, 0.4f, editorArea)/ /layout.addView('view.2', IPageLayout.LEFT, 0.3f, 'view.1')/}", "  (editor area)", "  {void} {local-unique: folder} {/layout.createFolder('folder.1', IPageLayout.TOP, 0.4f, editorArea)/ /folder.addView('view.1')/}", "    {void} {void} {/folder.addView('view.1')/}", "  {void} {void} {/layout.addView('view.2', IPageLayout.LEFT, 0.3f, 'view.1')/}", "  (fast views)", "  (view shortcuts)", "  (perspective shortcuts)");
        page.refresh();
        AbstractPartInfo folder = (AbstractPartInfo)page.getParts().get(0);
        PageLayoutTest.assertNotNull((Object)folder.getSashLine());
        AbstractPartInfo view2 = (AbstractPartInfo)page.getParts().get(1);
        PageLayoutTest.assertNotNull((Object)view2.getSashLine());
        Rectangle bounds = view2.getBounds();
        PageLayoutTest.assertEquals((int)bounds.x, (int)0);
        PageLayoutTest.assertEquals((int)bounds.y, (int)0);
        Assertions.assertThat((int)bounds.width).isGreaterThan(150);
        Assertions.assertThat((int)bounds.height).isGreaterThan(150);
    }

    @Test
    public void test_addView_invalidRelatioship() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    String editorArea = layout.getEditorArea();", "    layout.addView('org.eclipse.jdt.ui.PackageExplorer', -555, 0.7f, editorArea);", "  }", "}");
        try {
            page.refresh();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"relationship"});
        }
    }

    private static void assertPartsSizes(int value_1, int value_2, double k_1, double k_2) {
        PageLayoutTest.assertEquals((double)(Math.abs((double)value_1 / k_1 - (double)value_2 / k_2) - 3.0), (double)0.0, (double)2.0);
    }

    @Test
    public void test_shortcuts_0() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    addFastViews(layout);", "  }", "  private void addFastViews(IPageLayout layout) {", "    layout.addFastView(IPageLayout.ID_PROJECT_EXPLORER);", "  }", "}");
        PageLayoutTest.assertHierarchy("{parameter: layout} {layout} {/layout.addFastView(IPageLayout.ID_PROJECT_EXPLORER)/ /addFastViews(layout)/}", "  (editor area)", "  (fast views)", "    {void} {empty} {/layout.addFastView(IPageLayout.ID_PROJECT_EXPLORER)/}", "  (view shortcuts)", "  (perspective shortcuts)");
        FastViewContainerInfo container = page.getFastViewContainer();
        page.refresh();
        PageLayoutTest.assertEquals((Object)"(fast views)", (Object)container.toString());
        PageLayoutTest.assertSame((Object)page, (Object)container.getPage());
        IObjectPresentation presentation = container.getPresentation();
        PageLayoutTest.assertNotNull((Object)presentation.getIcon());
        PageLayoutTest.assertEquals((Object)"(fast views)", (Object)presentation.getText());
        Rectangle bounds = container.getBounds();
        PageLayoutTest.assertEquals((int)bounds.x, (int)0);
        Assertions.assertThat((int)bounds.y).isGreaterThan(450);
        Assertions.assertThat((int)bounds.width).isGreaterThan(550);
        Assertions.assertThat((int)bounds.height).isGreaterThan(20);
        List shortcuts = container.getShortcuts();
        Assertions.assertThat((List)shortcuts).hasSize(1);
        FastViewInfo view = (FastViewInfo)shortcuts.get(0);
        PageLayoutTest.assertEquals((Object)"org.eclipse.ui.navigator.ProjectExplorer", (Object)view.getId());
        IObjectPresentation presentation2 = view.getPresentation();
        PageLayoutTest.assertNotNull((Object)presentation2.getIcon());
        PageLayoutTest.assertEquals((Object)"\"Project Explorer\" - org.eclipse.ui.navigator.ProjectExplorer", (Object)presentation2.getText());
        Rectangle bounds2 = view.getBounds();
        Assertions.assertThat((int)bounds2.x).isGreaterThan(0);
        Assertions.assertThat((int)bounds2.y).isGreaterThan(0);
        Assertions.assertThat((int)bounds2.width).isGreaterThan(20);
        Assertions.assertThat((int)bounds2.height).isGreaterThan(20);
    }

    @Test
    public void test_fastView_CREATE_1() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    addFastViews(layout);", "  }", "  private void addFastViews(IPageLayout layout) {", "    layout.addFastView(IPageLayout.ID_PROJECT_EXPLORER);", "  }", "}");
        page.refresh();
        FastViewContainerInfo container = page.getFastViewContainer();
        FastViewInfo nextItem = (FastViewInfo)container.getShortcuts().get(0);
        PageLayoutTest.assertNotNull((Object)ObjectInfoUtils.getId((ObjectInfo)nextItem));
        FastViewInfo item = container.command_CREATE("org.eclipse.jdt.ui.PackageExplorer", nextItem);
        PageLayoutTest.assertNotNull((Object)ObjectInfoUtils.getId((ObjectInfo)item));
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    addFastViews(layout);", "  }", "  private void addFastViews(IPageLayout layout) {", "    layout.addFastView('org.eclipse.jdt.ui.PackageExplorer');", "    layout.addFastView(IPageLayout.ID_PROJECT_EXPLORER);", "  }", "}");
        PageLayoutTest.assertSame((Object)container, (Object)item.getParent());
        Assertions.assertThat((List)container.getChildren()).contains((Object[])new ObjectInfo[]{item});
        PageLayoutTest.assertInstanceOf(PageLayoutAddCreationSupport.class, (Object)item.getCreationSupport());
        PageLayoutTest.assertInstanceOf(EmptyPureVariableSupport.class, (Object)item.getVariableSupport());
        PageLayoutTest.assertHierarchy("{parameter: layout} {layout} {/layout.addFastView(IPageLayout.ID_PROJECT_EXPLORER)/ /addFastViews(layout)/ /layout.addFastView('org.eclipse.jdt.ui.PackageExplorer')/}", "  (editor area)", "  (fast views)", "    {void} {empty} {/layout.addFastView('org.eclipse.jdt.ui.PackageExplorer')/}", "    {void} {empty} {/layout.addFastView(IPageLayout.ID_PROJECT_EXPLORER)/}", "  (view shortcuts)", "  (perspective shortcuts)");
    }

    @Test
    public void test_fastView_CREATE_2() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "  }", "}");
        page.refresh();
        FastViewContainerInfo container = page.getFastViewContainer();
        FastViewInfo item = container.command_CREATE("org.eclipse.jdt.ui.PackageExplorer", null);
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    addFastViews(layout);", "  }", "  private void addFastViews(IPageLayout layout) {", "    layout.addFastView('org.eclipse.jdt.ui.PackageExplorer');", "  }", "}");
        PageLayoutTest.assertSame((Object)container, (Object)item.getParent());
        Assertions.assertThat((List)container.getChildren()).contains((Object[])new ObjectInfo[]{item});
        PageLayoutTest.assertInstanceOf(PageLayoutAddCreationSupport.class, (Object)item.getCreationSupport());
        PageLayoutTest.assertInstanceOf(EmptyPureVariableSupport.class, (Object)item.getVariableSupport());
        PageLayoutTest.assertHierarchy("{parameter: layout} {layout} {/layout.addFastView('org.eclipse.jdt.ui.PackageExplorer')/}", "  (editor area)", "  (fast views)", "    {void} {empty} {/layout.addFastView('org.eclipse.jdt.ui.PackageExplorer')/}", "  (view shortcuts)", "  (perspective shortcuts)");
    }

    @Test
    public void test_fastView_MOVE_1() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    addFastViews(layout);", "  }", "  private void addFastViews(IPageLayout layout) {", "    layout.addFastView(IPageLayout.ID_PROJECT_EXPLORER);", "    layout.addFastView(IPageLayout.ID_PROBLEM_VIEW);", "  }", "}");
        page.refresh();
        FastViewContainerInfo container = page.getFastViewContainer();
        FastViewInfo item_1 = (FastViewInfo)container.getShortcuts().get(0);
        FastViewInfo item_2 = (FastViewInfo)container.getShortcuts().get(1);
        container.command_MOVE(item_2, item_1);
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    addFastViews(layout);", "  }", "  private void addFastViews(IPageLayout layout) {", "    layout.addFastView(IPageLayout.ID_PROBLEM_VIEW);", "    layout.addFastView(IPageLayout.ID_PROJECT_EXPLORER);", "  }", "}");
        List shortcuts = container.getShortcuts();
        PageLayoutTest.assertSame((Object)item_2, shortcuts.get(0));
        PageLayoutTest.assertSame((Object)item_1, shortcuts.get(1));
    }

    @Test
    public void test_fastView_MOVE_2() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    addFastViews(layout);", "  }", "  private void addFastViews(IPageLayout layout) {", "    layout.addFastView(IPageLayout.ID_PROJECT_EXPLORER);", "    layout.addFastView(IPageLayout.ID_PROBLEM_VIEW);", "  }", "}");
        page.refresh();
        FastViewContainerInfo container = page.getFastViewContainer();
        FastViewInfo item_1 = (FastViewInfo)container.getShortcuts().get(0);
        FastViewInfo item_2 = (FastViewInfo)container.getShortcuts().get(1);
        container.command_MOVE(item_1, null);
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    addFastViews(layout);", "  }", "  private void addFastViews(IPageLayout layout) {", "    layout.addFastView(IPageLayout.ID_PROBLEM_VIEW);", "    layout.addFastView(IPageLayout.ID_PROJECT_EXPLORER);", "  }", "}");
        List shortcuts = container.getShortcuts();
        PageLayoutTest.assertSame((Object)item_2, shortcuts.get(0));
        PageLayoutTest.assertSame((Object)item_1, shortcuts.get(1));
    }

    @Test
    public void test_viewShortcuts_CREATE() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    addViewShortcuts(layout);", "  }", "  private void addViewShortcuts(IPageLayout layout) {", "    layout.addShowViewShortcut(IPageLayout.ID_PROJECT_EXPLORER);", "  }", "}");
        page.refresh();
        ViewShortcutContainerInfo container = page.getViewShortcutContainer();
        ViewShortcutInfo nextItem = (ViewShortcutInfo)container.getShortcuts().get(0);
        PageLayoutTest.assertNotNull((Object)ObjectInfoUtils.getId((ObjectInfo)nextItem));
        ViewShortcutInfo item = container.command_CREATE("org.eclipse.jdt.ui.PackageExplorer", nextItem);
        PageLayoutTest.assertNotNull((Object)ObjectInfoUtils.getId((ObjectInfo)item));
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    addViewShortcuts(layout);", "  }", "  private void addViewShortcuts(IPageLayout layout) {", "    layout.addShowViewShortcut('org.eclipse.jdt.ui.PackageExplorer');", "    layout.addShowViewShortcut(IPageLayout.ID_PROJECT_EXPLORER);", "  }", "}");
    }

    @Test
    public void test_viewShortcuts_MOVE() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    addViewShortcuts(layout);", "  }", "  private void addViewShortcuts(IPageLayout layout) {", "    layout.addShowViewShortcut(IPageLayout.ID_PROJECT_EXPLORER);", "    layout.addShowViewShortcut(IPageLayout.ID_PROBLEM_VIEW);", "  }", "}");
        page.refresh();
        ViewShortcutContainerInfo container = page.getViewShortcutContainer();
        ViewShortcutInfo item_1 = (ViewShortcutInfo)container.getShortcuts().get(0);
        ViewShortcutInfo item_2 = (ViewShortcutInfo)container.getShortcuts().get(1);
        container.command_MOVE(item_2, item_1);
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    addViewShortcuts(layout);", "  }", "  private void addViewShortcuts(IPageLayout layout) {", "    layout.addShowViewShortcut(IPageLayout.ID_PROBLEM_VIEW);", "    layout.addShowViewShortcut(IPageLayout.ID_PROJECT_EXPLORER);", "  }", "}");
    }

    @Test
    public void test_perspectiveShortcuts_CREATE() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    addPerspectiveShortcuts(layout);", "  }", "  private void addPerspectiveShortcuts(IPageLayout layout) {", "    layout.addPerspectiveShortcut('org.eclipse.jdt.ui.JavaPerspective');", "  }", "}");
        page.refresh();
        PerspectiveShortcutContainerInfo container = page.getPerspectiveShortcutContainer();
        PerspectiveShortcutInfo nextItem = (PerspectiveShortcutInfo)container.getShortcuts().get(0);
        PageLayoutTest.assertNotNull((Object)ObjectInfoUtils.getId((ObjectInfo)nextItem));
        PerspectiveShortcutInfo item = container.command_CREATE("org.eclipse.ui.resourcePerspective", nextItem);
        PageLayoutTest.assertNotNull((Object)ObjectInfoUtils.getId((ObjectInfo)item));
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    addPerspectiveShortcuts(layout);", "  }", "  private void addPerspectiveShortcuts(IPageLayout layout) {", "    layout.addPerspectiveShortcut('org.eclipse.ui.resourcePerspective');", "    layout.addPerspectiveShortcut('org.eclipse.jdt.ui.JavaPerspective');", "  }", "}");
    }

    @Test
    public void test_perspectiveShortcuts_MOVE() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    addPerspectiveShortcuts(layout);", "  }", "  private void addPerspectiveShortcuts(IPageLayout layout) {", "    layout.addPerspectiveShortcut('org.eclipse.ui.resourcePerspective');", "    layout.addPerspectiveShortcut('org.eclipse.jdt.ui.JavaPerspective');", "  }", "}");
        page.refresh();
        PerspectiveShortcutContainerInfo container = page.getPerspectiveShortcutContainer();
        PerspectiveShortcutInfo item_1 = (PerspectiveShortcutInfo)container.getShortcuts().get(0);
        PerspectiveShortcutInfo item_2 = (PerspectiveShortcutInfo)container.getShortcuts().get(1);
        container.command_MOVE(item_2, item_1);
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    addPerspectiveShortcuts(layout);", "  }", "  private void addPerspectiveShortcuts(IPageLayout layout) {", "    layout.addPerspectiveShortcut('org.eclipse.jdt.ui.JavaPerspective');", "    layout.addPerspectiveShortcut('org.eclipse.ui.resourcePerspective');", "  }", "}");
    }

    @Test
    public void test_abstractPart_resizeActive() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.addView('view', IPageLayout.LEFT, 0.3f, IPageLayout.ID_EDITOR_AREA);", "  }", "}");
        page.refresh();
        PageLayoutAddViewInfo view = (PageLayoutAddViewInfo)page.getParts().get(0);
        PageLayoutTest.assertEquals((Object)new Dimension(600, 500), (Object)page.getBounds().getSize());
        view.resize(100);
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.addView('view', IPageLayout.LEFT, 0.47f, IPageLayout.ID_EDITOR_AREA);", "  }", "}");
    }

    @Test
    public void test_abstractPart_resizeActiveVertical() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.addView('view', IPageLayout.TOP, 0.3f, IPageLayout.ID_EDITOR_AREA);", "  }", "}");
        page.refresh();
        PageLayoutAddViewInfo view = (PageLayoutAddViewInfo)page.getParts().get(0);
        PageLayoutTest.assertEquals((Object)new Dimension(600, 500), (Object)page.getBounds().getSize());
        view.resize(100);
        Object ratio = ((MethodInvocation)view.getRelatedNodes().get(0)).arguments().get(2);
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.addView('view', IPageLayout.TOP, " + String.valueOf(ratio) + ", IPageLayout.ID_EDITOR_AREA);", "  }", "}");
    }

    @Test
    public void test_abstractPart_resizeActive_plusOver() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.addView('view', IPageLayout.LEFT, 0.4f, IPageLayout.ID_EDITOR_AREA);", "  }", "}");
        page.refresh();
        PageLayoutAddViewInfo view = (PageLayoutAddViewInfo)page.getParts().get(0);
        PageLayoutTest.assertEquals((Object)new Dimension(600, 500), (Object)page.getBounds().getSize());
        view.resize(10000);
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.addView('view', IPageLayout.LEFT, 0.95f, IPageLayout.ID_EDITOR_AREA);", "  }", "}");
    }

    @Test
    public void test_abstractPart_resizePassive() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.addView('view', IPageLayout.RIGHT, 0.7f, IPageLayout.ID_EDITOR_AREA);", "  }", "}");
        page.refresh();
        PageLayoutAddViewInfo view = (PageLayoutAddViewInfo)page.getParts().get(0);
        PageLayoutTest.assertEquals((Object)new Dimension(600, 500), (Object)page.getBounds().getSize());
        view.resize(100);
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.addView('view', IPageLayout.RIGHT, 0.52f, IPageLayout.ID_EDITOR_AREA);", "  }", "}");
    }

    @Test
    public void test_abstractPart_resizePassive_minus() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.addView('view', IPageLayout.RIGHT, 0.4f, IPageLayout.ID_EDITOR_AREA);", "  }", "}");
        page.refresh();
        PageLayoutAddViewInfo view = (PageLayoutAddViewInfo)page.getParts().get(0);
        PageLayoutTest.assertEquals((Object)new Dimension(600, 500), (Object)page.getBounds().getSize());
        view.resize(-150);
        Object ratio = ((MethodInvocation)view.getRelatedNodes().get(0)).arguments().get(2);
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.addView('view', IPageLayout.RIGHT, " + String.valueOf(ratio) + ", IPageLayout.ID_EDITOR_AREA);", "  }", "}");
    }

    @Test
    public void test_abstractPart_resizePassive_minusOver() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.addView('view', IPageLayout.RIGHT, 0.4f, IPageLayout.ID_EDITOR_AREA);", "  }", "}");
        page.refresh();
        PageLayoutAddViewInfo view = (PageLayoutAddViewInfo)page.getParts().get(0);
        PageLayoutTest.assertEquals((Object)new Dimension(600, 500), (Object)page.getBounds().getSize());
        view.resize(-10000);
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.addView('view', IPageLayout.RIGHT, 0.95f, IPageLayout.ID_EDITOR_AREA);", "  }", "}");
    }

    @Test
    public void test_addView_morphing() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    String editorArea = layout.getEditorArea();", "    layout.addView(IPageLayout.ID_PROJECT_EXPLORER, IPageLayout.LEFT, 0.3f, editorArea);", "  }", "}");
        PageLayoutAddViewInfo view = (PageLayoutAddViewInfo)page.getParts().get(0);
        Property standaloneProperty = view.getPropertyByTitle("standalone");
        Property placeholderProperty = view.getPropertyByTitle("placeholder");
        PageLayoutTest.assertMorphView(view, false, false);
        PageLayoutTest.setStandalone(view, true);
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    String editorArea = layout.getEditorArea();", "    layout.addStandaloneView(IPageLayout.ID_PROJECT_EXPLORER, true, IPageLayout.LEFT, 0.3f, editorArea);", "  }", "}");
        PageLayoutTest.assertMorphView(view, true, false);
        PageLayoutTest.setPlaceholder(view, true);
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    String editorArea = layout.getEditorArea();", "    layout.addStandaloneViewPlaceholder(IPageLayout.ID_PROJECT_EXPLORER, IPageLayout.LEFT, 0.3f, editorArea, true);", "  }", "}");
        PageLayoutTest.assertMorphView(view, true, true);
        PageLayoutTest.setPlaceholder(view, false);
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    String editorArea = layout.getEditorArea();", "    layout.addStandaloneView(IPageLayout.ID_PROJECT_EXPLORER, true, IPageLayout.LEFT, 0.3f, editorArea);", "  }", "}");
        PageLayoutTest.assertMorphView(view, true, false);
        PageLayoutTest.setStandalone(view, false);
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    String editorArea = layout.getEditorArea();", "    layout.addView(IPageLayout.ID_PROJECT_EXPLORER, IPageLayout.LEFT, 0.3f, editorArea);", "  }", "}");
        PageLayoutTest.assertMorphView(view, false, false);
        PageLayoutTest.setPlaceholder(view, true);
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    String editorArea = layout.getEditorArea();", "    layout.addPlaceholder(IPageLayout.ID_PROJECT_EXPLORER, IPageLayout.LEFT, 0.3f, editorArea);", "  }", "}");
        PageLayoutTest.assertMorphView(view, false, true);
        PageLayoutTest.setStandalone(view, true);
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    String editorArea = layout.getEditorArea();", "    layout.addStandaloneViewPlaceholder(IPageLayout.ID_PROJECT_EXPLORER, IPageLayout.LEFT, 0.3f, editorArea, true);", "  }", "}");
        PageLayoutTest.assertMorphView(view, true, true);
        PageLayoutTest.setStandalone(view, false);
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    String editorArea = layout.getEditorArea();", "    layout.addPlaceholder(IPageLayout.ID_PROJECT_EXPLORER, IPageLayout.LEFT, 0.3f, editorArea);", "  }", "}");
        PageLayoutTest.assertMorphView(view, false, true);
        PageLayoutTest.setPlaceholder(view, false);
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    String editorArea = layout.getEditorArea();", "    layout.addView(IPageLayout.ID_PROJECT_EXPLORER, IPageLayout.LEFT, 0.3f, editorArea);", "  }", "}");
        PageLayoutTest.assertMorphView(view, false, false);
        standaloneProperty.setValue((Object)Boolean.TRUE);
        placeholderProperty.setValue((Object)Boolean.TRUE);
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    String editorArea = layout.getEditorArea();", "    layout.addStandaloneViewPlaceholder(IPageLayout.ID_PROJECT_EXPLORER, IPageLayout.LEFT, 0.3f, editorArea, true);", "  }", "}");
        PageLayoutTest.assertMorphView(view, true, true);
    }

    private static void setStandalone(PageLayoutAddViewInfo view, boolean makeStandalone) throws Exception {
        view.setStandalone(makeStandalone);
        view.getRoot().refresh();
    }

    private static void setPlaceholder(PageLayoutAddViewInfo view, boolean makePlaceholder) throws Exception {
        view.setPlaceholder(makePlaceholder);
        view.getRoot().refresh();
    }

    private static void assertMorphView(PageLayoutAddViewInfo view, boolean standalone, boolean placeholder) throws Exception {
        PageLayoutTest.assertEquals((Object)standalone, (Object)view.isStandalone());
        PageLayoutTest.assertEquals((Object)placeholder, (Object)view.isPlaceholder2());
        Property property = view.getPropertyByTitle("standalone");
        PageLayoutTest.assertTrue((boolean)property.isModified());
        PageLayoutTest.assertEquals((Object)standalone, (Object)((Boolean)property.getValue()));
        property = view.getPropertyByTitle("placeholder");
        PageLayoutTest.assertTrue((boolean)property.isModified());
        PageLayoutTest.assertEquals((Object)placeholder, (Object)((Boolean)property.getValue()));
        PageLayoutTest.assertEquals((Object)"org.eclipse.ui.navigator.ProjectExplorer", (Object)view.getId());
        PageLayoutTest.assertEquals((int)1, (int)view.getRelationship());
        PageLayoutTest.assertEquals((double)0.3f, (double)view.getRatio(), (double)0.001);
        PageLayoutTest.assertEquals((Object)"org.eclipse.ui.editorss", (Object)view.getRefId());
    }

    @Test
    public void test_CREATE_view_0() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.addView(IPageLayout.ID_PROJECT_EXPLORER, IPageLayout.TOP, 0.3f, layout.getEditorArea());", "  }", "}");
        page.refresh();
        PageLayoutAddViewInfo newView = page.command_CREATE("org.eclipse.jdt.ui.PackagesView", 1, 0.5f, (IPageLayoutTopLevelInfo)page.getEditorArea());
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.addView(IPageLayout.ID_PROJECT_EXPLORER, IPageLayout.TOP, 0.3f, layout.getEditorArea());", "    layout.addView('org.eclipse.jdt.ui.PackagesView', IPageLayout.LEFT, 0.5f, IPageLayout.ID_EDITOR_AREA);", "  }", "}");
        PageLayoutTest.assertHierarchy("{parameter: layout} {layout} {/layout.getEditorArea()/ /layout.addView(IPageLayout.ID_PROJECT_EXPLORER, IPageLayout.TOP, 0.3f, layout.getEditorArea())/ /layout.addView('org.eclipse.jdt.ui.PackagesView', IPageLayout.LEFT, 0.5f, IPageLayout.ID_EDITOR_AREA)/}", "  (editor area)", "  {void} {void} {/layout.addView(IPageLayout.ID_PROJECT_EXPLORER, IPageLayout.TOP, 0.3f, layout.getEditorArea())/}", "  {void} {void} {/layout.addView('org.eclipse.jdt.ui.PackagesView', IPageLayout.LEFT, 0.5f, IPageLayout.ID_EDITOR_AREA)/}", "  (fast views)", "  (view shortcuts)", "  (perspective shortcuts)");
        PageLayoutTest.assertSame((Object)newView, page.getParts().get(1));
    }

    @Test
    public void test_CREATE_view_1() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "  }", "}");
        page.refresh();
        PageLayoutAddViewInfo newView = page.command_CREATE("org.eclipse.jdt.ui.PackagesView", 1, 0.5f, (IPageLayoutTopLevelInfo)page.getEditorArea());
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.addView('org.eclipse.jdt.ui.PackagesView', IPageLayout.LEFT, 0.5f, IPageLayout.ID_EDITOR_AREA);", "  }", "}");
        PageLayoutTest.assertSame((Object)newView, page.getParts().get(0));
    }

    @Test
    public void test_CREATE_view_2() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.addView('view_1', IPageLayout.LEFT, 0.3f, layout.getEditorArea());", "    layout.addView('view_2', IPageLayout.TOP, 0.3f, layout.getEditorArea());", "  }", "}");
        page.refresh();
        PageLayoutAddViewInfo view_1 = (PageLayoutAddViewInfo)page.getParts().get(0);
        PageLayoutAddViewInfo newView = page.command_CREATE("view_3", 4, 0.4f, (IPageLayoutTopLevelInfo)view_1);
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.addView('view_1', IPageLayout.LEFT, 0.3f, layout.getEditorArea());", "    layout.addView('view_3', IPageLayout.BOTTOM, 0.4f, 'view_1');", "    layout.addView('view_2', IPageLayout.TOP, 0.3f, layout.getEditorArea());", "  }", "}");
        PageLayoutTest.assertHierarchy("{parameter: layout} {layout} {/layout.getEditorArea()/ /layout.addView('view_1', IPageLayout.LEFT, 0.3f, layout.getEditorArea())/ /layout.getEditorArea()/ /layout.addView('view_2', IPageLayout.TOP, 0.3f, layout.getEditorArea())/ /layout.addView('view_3', IPageLayout.BOTTOM, 0.4f, 'view_1')/}", "  (editor area)", "  {void} {void} {/layout.addView('view_1', IPageLayout.LEFT, 0.3f, layout.getEditorArea())/}", "  {void} {void} {/layout.addView('view_3', IPageLayout.BOTTOM, 0.4f, 'view_1')/}", "  {void} {void} {/layout.addView('view_2', IPageLayout.TOP, 0.3f, layout.getEditorArea())/}", "  (fast views)", "  (view shortcuts)", "  (perspective shortcuts)");
        PageLayoutTest.assertSame((Object)newView, page.getParts().get(1));
    }

    @Test
    public void test_CREATE_view_3() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    {", "      IFolderLayout folder = layout.createFolder('folder.1', IPageLayout.TOP, 0.3f, IPageLayout.ID_EDITOR_AREA);", "      folder.addView('view.1');", "      folder.addView('view.2');", "    }", "  }", "}");
        page.refresh();
        page.command_CREATE("view_3", 2, 0.5f, (IPageLayoutTopLevelInfo)page.getEditorArea());
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    {", "      IFolderLayout folder = layout.createFolder('folder.1', IPageLayout.TOP, 0.3f, IPageLayout.ID_EDITOR_AREA);", "      folder.addView('view.1');", "      folder.addView('view.2');", "    }", "    layout.addView('view_3', IPageLayout.RIGHT, 0.5f, IPageLayout.ID_EDITOR_AREA);", "  }", "}");
    }

    @Test
    public void test_CREATE_view_4() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.addView('view_1', IPageLayout.LEFT, 0.3f, IPageLayout.ID_EDITOR_AREA);", "    {", "      IFolderLayout folder = layout.createFolder('folder.1', IPageLayout.TOP, 0.3f, IPageLayout.ID_EDITOR_AREA);", "      folder.addView('view.2');", "      folder.addView('view.3');", "    }", "    layout.addView('view_4', IPageLayout.BOTTOM, 0.5f, 'view_1');", "  }", "}");
        page.refresh();
        page.command_CREATE("view_5", 2, 0.5f, (IPageLayoutTopLevelInfo)page.getEditorArea());
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.addView('view_1', IPageLayout.LEFT, 0.3f, IPageLayout.ID_EDITOR_AREA);", "    {", "      IFolderLayout folder = layout.createFolder('folder.1', IPageLayout.TOP, 0.3f, IPageLayout.ID_EDITOR_AREA);", "      folder.addView('view.2');", "      folder.addView('view.3');", "    }", "    layout.addView('view_5', IPageLayout.RIGHT, 0.5f, IPageLayout.ID_EDITOR_AREA);", "    layout.addView('view_4', IPageLayout.BOTTOM, 0.5f, 'view_1');", "  }", "}");
    }

    @Test
    public void test_CREATE_view_TOP() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "  }", "}");
        page.refresh();
        page.command_CREATE("org.eclipse.jdt.ui.PackagesView", 3, 0.3f, (IPageLayoutTopLevelInfo)page.getEditorArea());
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.addView('org.eclipse.jdt.ui.PackagesView', IPageLayout.TOP, 0.3f, IPageLayout.ID_EDITOR_AREA);", "  }", "}");
    }

    @Test
    public void test_CREATE_view_BOTTOM() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "  }", "}");
        page.refresh();
        page.command_CREATE("org.eclipse.jdt.ui.PackagesView", 4, 0.3f, (IPageLayoutTopLevelInfo)page.getEditorArea());
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.addView('org.eclipse.jdt.ui.PackagesView', IPageLayout.BOTTOM, 0.3f, IPageLayout.ID_EDITOR_AREA);", "  }", "}");
    }

    @Test
    public void test_CREATE_view_LEFT() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "  }", "}");
        page.refresh();
        page.command_CREATE("org.eclipse.jdt.ui.PackagesView", 1, 0.3f, (IPageLayoutTopLevelInfo)page.getEditorArea());
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.addView('org.eclipse.jdt.ui.PackagesView', IPageLayout.LEFT, 0.3f, IPageLayout.ID_EDITOR_AREA);", "  }", "}");
    }

    @Test
    public void test_CREATE_view_RIGHT() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "  }", "}");
        page.refresh();
        page.command_CREATE("org.eclipse.jdt.ui.PackagesView", 2, 0.3f, (IPageLayoutTopLevelInfo)page.getEditorArea());
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.addView('org.eclipse.jdt.ui.PackagesView', IPageLayout.RIGHT, 0.3f, IPageLayout.ID_EDITOR_AREA);", "  }", "}");
    }

    @Test
    public void test_CREATE_view_invalidRelationship() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "  }", "}");
        page.refresh();
        try {
            int invalidRelationship = 555;
            page.command_CREATE("org.eclipse.jdt.ui.PackagesView", invalidRelationship, 0.3f, (IPageLayoutTopLevelInfo)page.getEditorArea());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void test_MOVE_view_1() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.addView('view_1', IPageLayout.LEFT, 0.3f, layout.getEditorArea());", "    layout.addView('view_2', IPageLayout.BOTTOM, 0.4f, 'view_1');", "    layout.addView('view_3', IPageLayout.TOP, 0.3f, layout.getEditorArea());", "  }", "}");
        page.refresh();
        PageLayoutAddViewInfo view_2 = (PageLayoutAddViewInfo)page.getParts().get(1);
        PageLayoutAddViewInfo view_3 = (PageLayoutAddViewInfo)page.getParts().get(2);
        page.command_MOVE((AbstractPartInfo)view_2, 2, 0.2f, (IPageLayoutTopLevelInfo)view_3);
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.addView('view_1', IPageLayout.LEFT, 0.3f, layout.getEditorArea());", "    layout.addView('view_3', IPageLayout.TOP, 0.3f, layout.getEditorArea());", "    layout.addView('view_2', IPageLayout.RIGHT, 0.2f, 'view_3');", "  }", "}");
        PageLayoutTest.assertHierarchy("{parameter: layout} {layout} {/layout.getEditorArea()/ /layout.addView('view_1', IPageLayout.LEFT, 0.3f, layout.getEditorArea())/ /layout.addView('view_2', IPageLayout.RIGHT, 0.2f, 'view_3')/ /layout.getEditorArea()/ /layout.addView('view_3', IPageLayout.TOP, 0.3f, layout.getEditorArea())/}", "  (editor area)", "  {void} {void} {/layout.addView('view_1', IPageLayout.LEFT, 0.3f, layout.getEditorArea())/}", "  {void} {void} {/layout.addView('view_3', IPageLayout.TOP, 0.3f, layout.getEditorArea())/}", "  {void} {void} {/layout.addView('view_2', IPageLayout.RIGHT, 0.2f, 'view_3')/}", "  (fast views)", "  (view shortcuts)", "  (perspective shortcuts)");
        PageLayoutTest.assertSame((Object)view_3, page.getParts().get(1));
        PageLayoutTest.assertSame((Object)view_2, page.getParts().get(2));
    }

    @Test
    public void test_MOVE_view_2() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.addView('view_1', IPageLayout.LEFT, 0.3f, layout.getEditorArea());", "    layout.addView('view_2', IPageLayout.BOTTOM, 0.4f, 'view_1');", "    layout.addView('view_3', IPageLayout.TOP, 0.3f, layout.getEditorArea());", "  }", "}");
        page.refresh();
        PageLayoutAddViewInfo view_1 = (PageLayoutAddViewInfo)page.getParts().get(0);
        PageLayoutAddViewInfo view_2 = (PageLayoutAddViewInfo)page.getParts().get(1);
        page.command_MOVE((AbstractPartInfo)view_2, 3, 0.2f, (IPageLayoutTopLevelInfo)view_1);
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.addView('view_1', IPageLayout.LEFT, 0.3f, layout.getEditorArea());", "    layout.addView('view_2', IPageLayout.TOP, 0.2f, 'view_1');", "    layout.addView('view_3', IPageLayout.TOP, 0.3f, layout.getEditorArea());", "  }", "}");
        PageLayoutTest.assertHierarchy("{parameter: layout} {layout} {/layout.getEditorArea()/ /layout.addView('view_1', IPageLayout.LEFT, 0.3f, layout.getEditorArea())/ /layout.addView('view_2', IPageLayout.TOP, 0.2f, 'view_1')/ /layout.getEditorArea()/ /layout.addView('view_3', IPageLayout.TOP, 0.3f, layout.getEditorArea())/}", "  (editor area)", "  {void} {void} {/layout.addView('view_1', IPageLayout.LEFT, 0.3f, layout.getEditorArea())/}", "  {void} {void} {/layout.addView('view_2', IPageLayout.TOP, 0.2f, 'view_1')/}", "  {void} {void} {/layout.addView('view_3', IPageLayout.TOP, 0.3f, layout.getEditorArea())/}", "  (fast views)", "  (view shortcuts)", "  (perspective shortcuts)");
        PageLayoutTest.assertSame((Object)view_1, page.getParts().get(0));
        PageLayoutTest.assertSame((Object)view_2, page.getParts().get(1));
    }

    @Test
    public void test_MOVE_view_3() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.addView('view_1', IPageLayout.LEFT, 0.3f, layout.getEditorArea());", "    layout.addView('view_2', IPageLayout.TOP, 0.3f, layout.getEditorArea());", "  }", "}");
        page.refresh();
        PageLayoutAddViewInfo view_1 = (PageLayoutAddViewInfo)page.getParts().get(0);
        PageLayoutAddViewInfo view_2 = (PageLayoutAddViewInfo)page.getParts().get(1);
        page.command_MOVE((AbstractPartInfo)view_2, 4, 0.2f, (IPageLayoutTopLevelInfo)view_1);
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.addView('view_1', IPageLayout.LEFT, 0.3f, layout.getEditorArea());", "    layout.addView('view_2', IPageLayout.BOTTOM, 0.2f, 'view_1');", "  }", "}");
        PageLayoutTest.assertSame((Object)view_1, page.getParts().get(0));
        PageLayoutTest.assertSame((Object)view_2, page.getParts().get(1));
    }

    @Test
    public void test_MOVE_folder_1() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.addView('view.1', IPageLayout.LEFT, 0.3f, IPageLayout.ID_EDITOR_AREA);", "    {", "      IFolderLayout folder = layout.createFolder('folder.1', IPageLayout.TOP, 0.3f, IPageLayout.ID_EDITOR_AREA);", "      folder.addView('view.2');", "      folder.addView('view.3');", "    }", "    layout.addView('view.4', IPageLayout.BOTTOM, 0.5f, 'view.1');", "  }", "}");
        page.refresh();
        PageLayoutTest.assertHierarchy("{parameter: layout} {layout} {/layout.addView('view.1', IPageLayout.LEFT, 0.3f, IPageLayout.ID_EDITOR_AREA)/ /layout.createFolder('folder.1', IPageLayout.TOP, 0.3f, IPageLayout.ID_EDITOR_AREA)/ /layout.addView('view.4', IPageLayout.BOTTOM, 0.5f, 'view.1')/}", "  (editor area)", "  {void} {void} {/layout.addView('view.1', IPageLayout.LEFT, 0.3f, IPageLayout.ID_EDITOR_AREA)/}", "  {void} {local-unique: folder} {/layout.createFolder('folder.1', IPageLayout.TOP, 0.3f, IPageLayout.ID_EDITOR_AREA)/ /folder.addView('view.2')/ /folder.addView('view.3')/}", "    {void} {void} {/folder.addView('view.2')/}", "    {void} {void} {/folder.addView('view.3')/}", "  {void} {void} {/layout.addView('view.4', IPageLayout.BOTTOM, 0.5f, 'view.1')/}", "  (fast views)", "  (view shortcuts)", "  (perspective shortcuts)");
        PageLayoutAddViewInfo view_4 = (PageLayoutAddViewInfo)page.getParts().get(2);
        PageLayoutTest.assertEquals((Object)"view.4", (Object)view_4.getId());
        PageLayoutCreateFolderInfo folder = (PageLayoutCreateFolderInfo)page.getParts().get(1);
        page.command_MOVE((AbstractPartInfo)folder, 3, 0.2f, (IPageLayoutTopLevelInfo)view_4);
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.addView('view.1', IPageLayout.LEFT, 0.3f, IPageLayout.ID_EDITOR_AREA);", "    layout.addView('view.4', IPageLayout.BOTTOM, 0.5f, 'view.1');", "    {", "      IFolderLayout folder = layout.createFolder('folder.1', IPageLayout.TOP, 0.2f, 'view.4');", "      folder.addView('view.2');", "      folder.addView('view.3');", "    }", "  }", "}");
        PageLayoutTest.assertHierarchy("{parameter: layout} {layout} {/layout.addView('view.1', IPageLayout.LEFT, 0.3f, IPageLayout.ID_EDITOR_AREA)/ /layout.createFolder('folder.1', IPageLayout.TOP, 0.2f, 'view.4')/ /layout.addView('view.4', IPageLayout.BOTTOM, 0.5f, 'view.1')/}", "  (editor area)", "  {void} {void} {/layout.addView('view.1', IPageLayout.LEFT, 0.3f, IPageLayout.ID_EDITOR_AREA)/}", "  {void} {void} {/layout.addView('view.4', IPageLayout.BOTTOM, 0.5f, 'view.1')/}", "  {void} {local-unique: folder} {/layout.createFolder('folder.1', IPageLayout.TOP, 0.2f, 'view.4')/ /folder.addView('view.2')/ /folder.addView('view.3')/}", "    {void} {void} {/folder.addView('view.2')/}", "    {void} {void} {/folder.addView('view.3')/}", "  (fast views)", "  (view shortcuts)", "  (perspective shortcuts)");
    }

    @Test
    public void test_MOVE_FolderView_into_topView() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    {", "      IFolderLayout folder = layout.createFolder('folder.1', IPageLayout.TOP, 0.3f, IPageLayout.ID_EDITOR_AREA);", "      folder.addView('view');", "    }", "  }", "}");
        page.refresh();
        PageLayoutTest.assertHierarchy("{parameter: layout} {layout} {/layout.createFolder('folder.1', IPageLayout.TOP, 0.3f, IPageLayout.ID_EDITOR_AREA)/}", "  (editor area)", "  {void} {local-unique: folder} {/layout.createFolder('folder.1', IPageLayout.TOP, 0.3f, IPageLayout.ID_EDITOR_AREA)/ /folder.addView('view')/}", "    {void} {void} {/folder.addView('view')/}", "  (fast views)", "  (view shortcuts)", "  (perspective shortcuts)");
        PageLayoutCreateFolderInfo folder = (PageLayoutCreateFolderInfo)page.getParts().get(0);
        FolderViewInfo folderView = (FolderViewInfo)folder.getViews().get(0);
        PageLayoutTest.assertEquals((Object)"view", (Object)folderView.getId());
        PageLayoutAddViewInfo topView = page.command_MOVE(folderView, 3, 0.2f, (IPageLayoutTopLevelInfo)folder);
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    {", "      IFolderLayout folder = layout.createFolder('folder.1', IPageLayout.TOP, 0.3f, IPageLayout.ID_EDITOR_AREA);", "    }", "    layout.addView('view', IPageLayout.TOP, 0.2f, 'folder.1');", "  }", "}");
        PageLayoutTest.assertHierarchy("{parameter: layout} {layout} {/layout.createFolder('folder.1', IPageLayout.TOP, 0.3f, IPageLayout.ID_EDITOR_AREA)/ /layout.addView('view', IPageLayout.TOP, 0.2f, 'folder.1')/}", "  (editor area)", "  {void} {local-unique: folder} {/layout.createFolder('folder.1', IPageLayout.TOP, 0.3f, IPageLayout.ID_EDITOR_AREA)/}", "  {void} {void} {/layout.addView('view', IPageLayout.TOP, 0.2f, 'folder.1')/}", "  (fast views)", "  (view shortcuts)", "  (perspective shortcuts)");
        PageLayoutTest.assertSame((Object)topView, page.getParts().get(1));
    }

    @Test
    public void test_CREATE_folder() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.createFolder('folder', IPageLayout.LEFT, 0.3f, IPageLayout.ID_EDITOR_AREA);", "    layout.createFolder('folder_1', IPageLayout.RIGHT, 0.3f, IPageLayout.ID_EDITOR_AREA);", "  }", "}");
        page.refresh();
        page.command_CREATE_folder(4, 0.5f, (IPageLayoutTopLevelInfo)page.getEditorArea());
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.createFolder('folder', IPageLayout.LEFT, 0.3f, IPageLayout.ID_EDITOR_AREA);", "    layout.createFolder('folder_1', IPageLayout.RIGHT, 0.3f, IPageLayout.ID_EDITOR_AREA);", "    {", "      IFolderLayout folderLayout = layout.createFolder('folder_2', IPageLayout.BOTTOM, 0.5f, IPageLayout.ID_EDITOR_AREA);", "    }", "  }", "}");
        PageLayoutTest.assertHierarchy("{parameter: layout} {layout} {/layout.createFolder('folder', IPageLayout.LEFT, 0.3f, IPageLayout.ID_EDITOR_AREA)/ /layout.createFolder('folder_1', IPageLayout.RIGHT, 0.3f, IPageLayout.ID_EDITOR_AREA)/ /layout.createFolder('folder_2', IPageLayout.BOTTOM, 0.5f, IPageLayout.ID_EDITOR_AREA)/}", "  (editor area)", "  {void} {empty} {/layout.createFolder('folder', IPageLayout.LEFT, 0.3f, IPageLayout.ID_EDITOR_AREA)/}", "  {void} {empty} {/layout.createFolder('folder_1', IPageLayout.RIGHT, 0.3f, IPageLayout.ID_EDITOR_AREA)/}", "  {void} {local-unique: folderLayout} {/layout.createFolder('folder_2', IPageLayout.BOTTOM, 0.5f, IPageLayout.ID_EDITOR_AREA)/}", "  (fast views)", "  (view shortcuts)", "  (perspective shortcuts)");
    }

    @Test
    public void test_convertViewIntoFolder_1() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.addView('view_1', IPageLayout.LEFT, 0.3f, IPageLayout.ID_EDITOR_AREA);", "    layout.addView('view_2', IPageLayout.TOP, 0.3f, IPageLayout.ID_EDITOR_AREA);", "    layout.addView('view_3', IPageLayout.BOTTOM, 0.3f, IPageLayout.ID_EDITOR_AREA);", "  }", "}");
        page.refresh();
        PageLayoutAddViewInfo view_1 = (PageLayoutAddViewInfo)page.getParts().get(0);
        PageLayoutAddViewInfo view_2 = (PageLayoutAddViewInfo)page.getParts().get(1);
        PageLayoutAddViewInfo view_3 = (PageLayoutAddViewInfo)page.getParts().get(2);
        PageLayoutCreateFolderInfo newFolder = page.convertIntoFolder(view_2);
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.addView('view_1', IPageLayout.LEFT, 0.3f, IPageLayout.ID_EDITOR_AREA);", "    {", "      IFolderLayout folderLayout = layout.createFolder('folder', IPageLayout.TOP, 0.3f, IPageLayout.ID_EDITOR_AREA);", "      folderLayout.addView('view_2');", "    }", "    layout.addView('view_3', IPageLayout.BOTTOM, 0.3f, IPageLayout.ID_EDITOR_AREA);", "  }", "}");
        PageLayoutTest.assertHierarchy("{parameter: layout} {layout} {/layout.addView('view_1', IPageLayout.LEFT, 0.3f, IPageLayout.ID_EDITOR_AREA)/ /layout.addView('view_3', IPageLayout.BOTTOM, 0.3f, IPageLayout.ID_EDITOR_AREA)/ /layout.createFolder('folder', IPageLayout.TOP, 0.3f, IPageLayout.ID_EDITOR_AREA)/}", "  (editor area)", "  {void} {void} {/layout.addView('view_1', IPageLayout.LEFT, 0.3f, IPageLayout.ID_EDITOR_AREA)/}", "  {void} {local-unique: folderLayout} {/layout.createFolder('folder', IPageLayout.TOP, 0.3f, IPageLayout.ID_EDITOR_AREA)/ /folderLayout.addView('view_2')/}", "    {void} {void} {/folderLayout.addView('view_2')/}", "  {void} {void} {/layout.addView('view_3', IPageLayout.BOTTOM, 0.3f, IPageLayout.ID_EDITOR_AREA)/}", "  (fast views)", "  (view shortcuts)", "  (perspective shortcuts)");
        PageLayoutTest.assertSame((Object)view_1, page.getParts().get(0));
        PageLayoutTest.assertSame((Object)newFolder, page.getParts().get(1));
        PageLayoutTest.assertSame((Object)view_3, page.getParts().get(2));
    }

    @Test
    public void test_convertViewIntoFolder_2() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.addView('view_1', IPageLayout.LEFT, 0.3f, IPageLayout.ID_EDITOR_AREA);", "    layout.addView('view_2', IPageLayout.TOP, 0.3f, 'view_1');", "    layout.addView('view_3', IPageLayout.BOTTOM, 0.3f, 'view_1');", "  }", "}");
        page.refresh();
        PageLayoutAddViewInfo view_1 = (PageLayoutAddViewInfo)page.getParts().get(0);
        PageLayoutAddViewInfo view_2 = (PageLayoutAddViewInfo)page.getParts().get(1);
        PageLayoutCreateFolderInfo newFolder = page.convertIntoFolder(view_2);
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    layout.addView('view_1', IPageLayout.LEFT, 0.3f, IPageLayout.ID_EDITOR_AREA);", "    {", "      IFolderLayout folderLayout = layout.createFolder('folder', IPageLayout.TOP, 0.3f, 'view_1');", "      folderLayout.addView('view_2');", "    }", "    layout.addView('view_3', IPageLayout.BOTTOM, 0.3f, 'view_1');", "  }", "}");
        PageLayoutTest.assertHierarchy("{parameter: layout} {layout} {/layout.addView('view_1', IPageLayout.LEFT, 0.3f, IPageLayout.ID_EDITOR_AREA)/ /layout.addView('view_3', IPageLayout.BOTTOM, 0.3f, 'view_1')/ /layout.createFolder('folder', IPageLayout.TOP, 0.3f, 'view_1')/}", "  (editor area)", "  {void} {void} {/layout.addView('view_1', IPageLayout.LEFT, 0.3f, IPageLayout.ID_EDITOR_AREA)/}", "  {void} {local-unique: folderLayout} {/layout.createFolder('folder', IPageLayout.TOP, 0.3f, 'view_1')/ /folderLayout.addView('view_2')/}", "    {void} {void} {/folderLayout.addView('view_2')/}", "  {void} {void} {/layout.addView('view_3', IPageLayout.BOTTOM, 0.3f, 'view_1')/}", "  (fast views)", "  (view shortcuts)", "  (perspective shortcuts)");
        PageLayoutTest.assertSame((Object)view_1, page.getParts().get(0));
        PageLayoutTest.assertSame((Object)newFolder, page.getParts().get(1));
    }

    @Test
    public void test_IFolderLayout_parse() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    String editorArea = layout.getEditorArea();", "    IFolderLayout folder = layout.createFolder('folder.1', IPageLayout.TOP, 0.4f, editorArea);", "    folder.addView('view.1');", "    folder.addView('view.2');", "  }", "}");
        PageLayoutTest.assertHierarchy("{parameter: layout} {layout} {/layout.getEditorArea()/ /layout.createFolder('folder.1', IPageLayout.TOP, 0.4f, editorArea)/}", "  (editor area)", "  {void} {local-unique: folder} {/layout.createFolder('folder.1', IPageLayout.TOP, 0.4f, editorArea)/ /folder.addView('view.1')/ /folder.addView('view.2')/}", "    {void} {void} {/folder.addView('view.1')/}", "    {void} {void} {/folder.addView('view.2')/}", "  (fast views)", "  (view shortcuts)", "  (perspective shortcuts)");
        List parts = page.getParts();
        Assertions.assertThat((List)parts).hasSize(1);
        PageLayoutCreateFolderInfo folder = (PageLayoutCreateFolderInfo)parts.get(0);
        PageLayoutTest.assertNotNull((Object)ObjectInfoUtils.getId((ObjectInfo)folder));
        List views = folder.getViews();
        Assertions.assertThat((List)views).hasSize(2);
        FolderViewInfo view_1 = (FolderViewInfo)views.get(0);
        FolderViewInfo view_2 = (FolderViewInfo)views.get(1);
        PageLayoutTest.assertNotNull((Object)ObjectInfoUtils.getId((ObjectInfo)view_1));
        PageLayoutTest.assertNotNull((Object)ObjectInfoUtils.getId((ObjectInfo)view_2));
        page.refresh();
        Rectangle bounds = folder.getBounds();
        PageLayoutTest.assertEquals((int)bounds.x, (int)0);
        PageLayoutTest.assertEquals((int)bounds.y, (int)0);
        Assertions.assertThat((int)bounds.width).isGreaterThan(550);
        Assertions.assertThat((int)bounds.height).isGreaterThan(150);
        bounds = view_1.getBounds();
        Assertions.assertThat((int)bounds.width).isGreaterThan(50);
        Assertions.assertThat((int)bounds.height).isGreaterThan(20);
        bounds = view_2.getBounds();
        Assertions.assertThat((int)bounds.width).isGreaterThan(50);
        Assertions.assertThat((int)bounds.height).isGreaterThan(20);
        Assertions.assertThat((int)view_2.getBounds().x).isGreaterThan(view_1.getBounds().right());
        PageLayoutTest.assertEquals((int)view_2.getBounds().y, (int)view_1.getBounds().y);
        IObjectPresentation presentation = folder.getPresentation();
        PageLayoutTest.assertNotNull((Object)presentation.getIcon());
        PageLayoutTest.assertEquals((Object)"folder.1", (Object)presentation.getText());
        presentation = view_1.getPresentation();
        PageLayoutTest.assertNotNull((Object)presentation.getIcon());
        PageLayoutTest.assertEquals((Object)"\"view.1\" - view.1", (Object)presentation.getText());
    }

    @Test
    public void test_IFolderLayout_delete() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    String editorArea = layout.getEditorArea();", "    IFolderLayout folder = layout.createFolder('folder.1', IPageLayout.TOP, 0.4f, editorArea);", "    folder.addView('view.1');", "    folder.addView('view.2');", "  }", "}");
        page.refresh();
        PageLayoutCreateFolderInfo folder = (PageLayoutCreateFolderInfo)page.getParts().get(0);
        folder.delete();
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    String editorArea = layout.getEditorArea();", "  }", "}");
    }

    @Test
    public void test_IFolderLayout_morphing() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    String editorArea = layout.getEditorArea();", "    IFolderLayout folder = layout.createFolder('folder.1', IPageLayout.TOP, 0.4f, editorArea);", "    folder.addView('view.1');", "    folder.addView('view.2');", "  }", "}");
        PageLayoutCreateFolderInfo folder = (PageLayoutCreateFolderInfo)page.getParts().get(0);
        Property placeholderProperty = folder.getPropertyByTitle("placeholder");
        PageLayoutTest.assertNotNull((Object)placeholderProperty);
        PageLayoutTest.assertEquals((Object)"placeholder", (Object)placeholderProperty.getTitle());
        PageLayoutTest.assertTrue((boolean)placeholderProperty.isModified());
        PageLayoutTest.assertFalse((boolean)folder.isPlaceholder2());
        PageLayoutTest.assertEquals((Object)false, (Object)((Boolean)placeholderProperty.getValue()));
        folder.setPlaceholder(true);
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    String editorArea = layout.getEditorArea();", "    IPlaceholderFolderLayout folder = layout.createPlaceholderFolder('folder.1', IPageLayout.TOP, 0.4f, editorArea);", "    folder.addPlaceholder('view.1');", "    folder.addPlaceholder('view.2');", "  }", "}");
        PageLayoutTest.assertTrue((boolean)folder.isPlaceholder2());
        PageLayoutTest.assertEquals((Object)true, (Object)((Boolean)placeholderProperty.getValue()));
        placeholderProperty.setValue((Object)false);
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    String editorArea = layout.getEditorArea();", "    IFolderLayout folder = layout.createFolder('folder.1', IPageLayout.TOP, 0.4f, editorArea);", "    folder.addView('view.1');", "    folder.addView('view.2');", "  }", "}");
        PageLayoutTest.assertFalse((boolean)folder.isPlaceholder2());
        PageLayoutTest.assertEquals((Object)false, (Object)((Boolean)placeholderProperty.getValue()));
    }

    @Test
    public void test_IFolderLayout_CREATE_1() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    String editorArea = layout.getEditorArea();", "    IFolderLayout folder = layout.createFolder('folder.1', IPageLayout.TOP, 0.4f, editorArea);", "    folder.addView('view.1');", "  }", "}");
        PageLayoutCreateFolderInfo folder = (PageLayoutCreateFolderInfo)page.getParts().get(0);
        FolderViewInfo nextView = (FolderViewInfo)folder.getViews().get(0);
        FolderViewInfo newView = folder.command_CREATE("view.2", nextView);
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    String editorArea = layout.getEditorArea();", "    IFolderLayout folder = layout.createFolder('folder.1', IPageLayout.TOP, 0.4f, editorArea);", "    folder.addView('view.2');", "    folder.addView('view.1');", "  }", "}");
        PageLayoutTest.assertSame((Object)newView, folder.getViews().get(0));
        PageLayoutTest.assertSame((Object)nextView, folder.getViews().get(1));
    }

    @Test
    public void test_IFolderLayout_MOVE_1() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    String editorArea = layout.getEditorArea();", "    IFolderLayout folder = layout.createFolder('folder.1', IPageLayout.TOP, 0.4f, editorArea);", "    folder.addView('view.1');", "    folder.addView('view.2');", "    folder.addView('view.3');", "  }", "}");
        PageLayoutCreateFolderInfo folder = (PageLayoutCreateFolderInfo)page.getParts().get(0);
        FolderViewInfo view_1 = (FolderViewInfo)folder.getViews().get(0);
        FolderViewInfo view_2 = (FolderViewInfo)folder.getViews().get(1);
        FolderViewInfo view_3 = (FolderViewInfo)folder.getViews().get(2);
        folder.command_MOVE(view_3, view_1);
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    String editorArea = layout.getEditorArea();", "    IFolderLayout folder = layout.createFolder('folder.1', IPageLayout.TOP, 0.4f, editorArea);", "    folder.addView('view.3');", "    folder.addView('view.1');", "    folder.addView('view.2');", "  }", "}");
        PageLayoutTest.assertSame((Object)view_3, folder.getViews().get(0));
        PageLayoutTest.assertSame((Object)view_1, folder.getViews().get(1));
        PageLayoutTest.assertSame((Object)view_2, folder.getViews().get(2));
    }

    @Test
    public void test_IFolderLayout_MOVE_2() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    String editorArea = layout.getEditorArea();", "    IFolderLayout folder = layout.createFolder('folder.1', IPageLayout.TOP, 0.4f, editorArea);", "    folder.addView('view.1');", "    layout.addView('view.2', IPageLayout.LEFT, 0.3f, IPageLayout.ID_EDITOR_AREA);", "  }", "}");
        PageLayoutCreateFolderInfo folder = (PageLayoutCreateFolderInfo)page.getParts().get(0);
        FolderViewInfo view_1 = (FolderViewInfo)folder.getViews().get(0);
        PageLayoutAddViewInfo view_2 = (PageLayoutAddViewInfo)page.getParts().get(1);
        FolderViewInfo newView_2 = folder.command_MOVE(view_2, null);
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    String editorArea = layout.getEditorArea();", "    IFolderLayout folder = layout.createFolder('folder.1', IPageLayout.TOP, 0.4f, editorArea);", "    folder.addView('view.1');", "    folder.addView('view.2');", "  }", "}");
        PageLayoutTest.assertSame((Object)view_1, folder.getViews().get(0));
        PageLayoutTest.assertFalse((boolean)page.getParts().contains(view_2));
        PageLayoutTest.assertSame((Object)newView_2, folder.getViews().get(1));
    }

    @Test
    public void test_IFolderLayout_MOVE_fromOtherFolder() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    String editorArea = layout.getEditorArea();", "    {", "      IFolderLayout folder_1 = layout.createFolder('folder.1', IPageLayout.TOP, 0.4f, editorArea);", "      folder_1.addView('view');", "    }", "    {", "      IFolderLayout folder_2 = layout.createFolder('folder.2', IPageLayout.RIGHT, 0.3f, editorArea);", "    }", "  }", "}");
        PageLayoutCreateFolderInfo folder_1 = (PageLayoutCreateFolderInfo)page.getParts().get(0);
        PageLayoutCreateFolderInfo folder_2 = (PageLayoutCreateFolderInfo)page.getParts().get(1);
        FolderViewInfo view = (FolderViewInfo)folder_1.getViews().get(0);
        FolderViewInfo newView = folder_2.command_MOVE(view, null);
        this.assertEditor("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "    String editorArea = layout.getEditorArea();", "    {", "      IFolderLayout folder_1 = layout.createFolder('folder.1', IPageLayout.TOP, 0.4f, editorArea);", "    }", "    {", "      IFolderLayout folder_2 = layout.createFolder('folder.2', IPageLayout.RIGHT, 0.3f, editorArea);", "      folder_2.addView('view');", "    }", "  }", "}");
        Assertions.assertThat((List)folder_1.getViews()).isEmpty();
        Assertions.assertThat((List)folder_2.getViews()).containsOnly((Object[])new FolderViewInfo[]{newView});
    }

    @Test
    public void test_palette() throws Exception {
        PageLayoutInfo page = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "  }", "}");
        page.refresh();
        ArrayList<CategoryInfo> categories = new ArrayList<CategoryInfo>();
        CategoryInfo oldCategory = new CategoryInfo("old.ID");
        categories.add(oldCategory);
        PageLayoutTest.assertTrue((boolean)categories.contains(oldCategory));
        ((PaletteEventListener)page.getBroadcast(PaletteEventListener.class)).categories(categories);
        PageLayoutTest.assertFalse((boolean)categories.contains(oldCategory));
        Assertions.assertThat((int)categories.size()).isGreaterThan(5);
        CategoryInfo category = (CategoryInfo)categories.get(0);
        PageLayoutTest.assertEquals((Object)"System", (Object)category.getName());
        PageLayoutTest.assertEquals((int)1, (int)category.getEntries().size());
        PageLayoutTest.assertInstanceOf(SelectionToolEntryInfo.class, category.getEntries().get(0));
        boolean hasOther = false;
        for (CategoryInfo category2 : categories) {
            if (!"other".equals(category2.getId())) continue;
            hasOther = true;
            PageLayoutTest.assertEquals((Object)"Other", (Object)category2.getName());
        }
        PageLayoutTest.assertTrue((boolean)hasOther, (String)"No 'Other' category");
        boolean hasGeneral = false;
        boolean hasJava = false;
        for (CategoryInfo category3 : categories) {
            if ("org.eclipse.ui".equals(category3.getId())) {
                hasGeneral = true;
                PageLayoutTest.assertEquals((Object)"General", (Object)category3.getName());
                Assertions.assertThat((int)category3.getEntries().size()).isGreaterThan(10);
            }
            if (!"org.eclipse.jdt.ui.java".equals(category3.getId())) continue;
            hasJava = true;
            PageLayoutTest.assertEquals((Object)"Java", (Object)category3.getName());
            Assertions.assertThat((int)category3.getEntries().size()).isGreaterThan(5);
        }
        PageLayoutTest.assertTrue((boolean)hasGeneral, (String)"No 'General' category");
        PageLayoutTest.assertTrue((boolean)hasJava, (String)"No 'Java' category");
    }

    @Test
    public void test_extensionProperties_notPlugin() throws Exception {
        PageLayoutInfo part = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "  }", "}");
        PageLayoutTest.assertNull((Object)part.getPropertyByTitle("Extension"));
    }

    @Test
    public void test_extensionProperties_noExtension() throws Exception {
        PdeProjectConversionUtils.convertToPDE(m_testProject.getProject(), null, "testplugin.Activator");
        AbstractPdeTest.createPluginXML("<plugin>", "  <!-- ===== filler filler filler filler filler ===== -->", "  <!-- ===== filler filler filler filler filler ===== -->", "</plugin>");
        PageLayoutInfo part = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "  }", "}");
        PageLayoutTest.assertNull((Object)part.getPropertyByTitle("Extension"));
    }

    @Test
    public void test_extensionProperties_hasExtension() throws Exception {
        PageLayoutTest.do_projectDispose();
        PageLayoutTest.do_projectCreate();
        PdeProjectConversionUtils.convertToPDE(m_testProject.getProject(), null, "testplugin.Activator");
        AbstractPdeTest.createPluginXML("<plugin>", "  <extension point='org.eclipse.ui.perspectives'>", "    <perspective id='id_1' name='name 1' icon='icons/false.gif' class='test.Test' fixed='true'/>", "  </extension>", "</plugin>");
        PageLayoutInfo part = this.parsePerspective("public class Test implements IPerspectiveFactory {", "  public Test() {", "  }", "  public void createInitialLayout(IPageLayout layout) {", "  }", "}");
        Property extensionProperty = part.getPropertyByTitle("Extension");
        PageLayoutTest.assertNotNull((Object)extensionProperty);
        PageLayoutTest.assertTrue((boolean)extensionProperty.getCategory().isSystem());
        Object[] subProperties = PageLayoutTest.getSubProperties(extensionProperty);
        Assertions.assertThat((Object[])subProperties).hasSize(3);
        Object nameProperty = subProperties[0];
        PageLayoutTest.assertEquals((Object)"name", (Object)nameProperty.getTitle());
        PageLayoutTest.assertTrue((boolean)nameProperty.isModified());
        PageLayoutTest.assertEquals((Object)"name 1", (Object)nameProperty.getValue());
        Object iconProperty = subProperties[1];
        PageLayoutTest.assertEquals((Object)"icon", (Object)iconProperty.getTitle());
        PageLayoutTest.assertTrue((boolean)iconProperty.isModified());
        PageLayoutTest.assertEquals((Object)"icons/false.gif", (Object)iconProperty.getValue());
        Object fixedProperty = subProperties[2];
        PageLayoutTest.assertEquals((Object)"fixed", (Object)fixedProperty.getTitle());
        PageLayoutTest.assertTrue((boolean)fixedProperty.isModified());
        PageLayoutTest.assertEquals((Object)true, (Object)fixedProperty.getValue());
        final boolean[] refreshed = new boolean[1];
        part.addBroadcastListener((Object)new ObjectEventListener(){

            public void refreshed() throws Exception {
                refreshed[0] = true;
            }
        });
        Object nameProperty2 = subProperties[0];
        nameProperty2.setValue((Object)"New name");
        PageLayoutTest.assertTrue((boolean)refreshed[0]);
    }

    private PageLayoutInfo parsePerspective(String ... lines) throws Exception {
        return (PageLayoutInfo)this.parseJavaInfo(lines);
    }

    @Override
    protected String[] getTestSource_decorate(String ... lines) {
        lines = CodeUtils.join((String[])new String[]{"package test;", "import org.eclipse.ui.*;"}, (String[])lines);
        return lines;
    }
}

