/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.databinding.swing;

import java.util.Collection;
import java.util.List;
import org.eclipse.wb.internal.core.databinding.ui.ObserveType;
import org.eclipse.wb.internal.core.utils.GenericsUtils;
import org.eclipse.wb.internal.swing.databinding.DatabindingsProvider;
import org.eclipse.wb.internal.swing.databinding.model.beans.FieldBeanObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.generic.GenericTypeContainer;
import org.eclipse.wb.internal.swing.databinding.model.generic.IGenericType;
import org.eclipse.wb.internal.swing.model.component.JPanelInfo;
import org.eclipse.wb.tests.designer.databinding.swing.AbstractBindingTest;
import org.eclipse.wb.tests.designer.databinding.swing.DatabindingTestUtils;
import org.junit.jupiter.api.Test;

public class GenericUtilsTest
extends AbstractBindingTest {
    @Test
    public void test_getObjectType() throws Exception {
        JPanelInfo shell = DatabindingTestUtils.parseTestSource(this, "import java.util.List;\nimport java.util.Map;\npublic class Test extends JPanel {\n\tprivate List<Map<String,Number>> datas;\n\tpublic Test() {\n\t}\n}");
        GenericUtilsTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List beanObserves = provider.getObserves(ObserveType.BEANS);
        List fieldObserves = GenericsUtils.select((Collection)beanObserves, FieldBeanObserveInfo.class);
        FieldBeanObserveInfo datas = (FieldBeanObserveInfo)fieldObserves.get(0);
        IGenericType datasObjectType = datas.getObjectType();
        GenericUtilsTest.assertInstanceOf(GenericTypeContainer.class, (Object)datasObjectType);
        GenericTypeContainer datasType = (GenericTypeContainer)datasObjectType;
        GenericUtilsTest.assertEquals((Object)datasType.getFullTypeName(), (Object)"java.util.List<java.util.Map<java.lang.String, java.lang.Number>>");
        IGenericType datasItemObjectType = datasType.getSubType(0);
        GenericUtilsTest.assertInstanceOf(GenericTypeContainer.class, (Object)datasItemObjectType);
        GenericTypeContainer datasItemType = (GenericTypeContainer)datasItemObjectType;
        GenericUtilsTest.assertEquals((Object)datasItemType.getFullTypeName(), (Object)"java.util.Map<java.lang.String, java.lang.Number>");
        List subTypes = datasItemType.getSubTypes();
        GenericUtilsTest.assertEquals((int)subTypes.size(), (int)2);
    }
}

