/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.util;

import java.io.DataOutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.wb.internal.core.utils.XmlWriter;
import org.eclipse.wb.tests.designer.tests.DesignerTestCase;
import org.junit.jupiter.api.Test;

public class XmlWriterTest
extends DesignerTestCase {
    private static final String lineSeparator = System.getProperty("line.separator");

    @Test
    public void test_constructor() throws Exception {
        StringWriter stringWriter = new StringWriter();
        XmlWriter writer = new XmlWriter((Writer)stringWriter);
        writer.close();
        XmlWriterTest.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>", (Object)stringWriter.toString());
    }

    @Test
    public void test_open_tag() throws Exception {
        StringWriter stringWriter = new StringWriter();
        XmlWriter writer = new XmlWriter((Writer)stringWriter);
        writer.openTag("root");
        writer.openTag("tag1");
        writer.closeTag();
        writer.closeTag();
        writer.close();
        XmlWriterTest.assertEquals((Object)("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + lineSeparator + "<root>" + lineSeparator + "\t<tag1></tag1>" + lineSeparator + "</root>" + lineSeparator), (Object)stringWriter.toString());
    }

    @Test
    public void test_open_tag_for_attribute() throws Exception {
        StringWriter stringWriter = new StringWriter();
        XmlWriter writer = new XmlWriter((Writer)stringWriter);
        writer.beginTag("tag1");
        writer.closeTag();
        writer.close();
        XmlWriterTest.assertEquals((Object)("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + lineSeparator + "<tag1/>" + lineSeparator), (Object)stringWriter.toString());
    }

    @Test
    public void test_write_several_tags_with_attributes() throws Exception {
        StringWriter stringWriter = new StringWriter();
        XmlWriter writer = new XmlWriter((Writer)stringWriter);
        writer.openTag("root");
        writer.beginTag("tag1");
        writer.writeAttribute("attr1", "attrValue1");
        writer.closeTag();
        writer.beginTag("tag2");
        writer.writeAttribute("attr2", "attrValue2");
        writer.closeTag();
        writer.closeTag();
        writer.close();
        XmlWriterTest.assertEquals((Object)("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + lineSeparator + "<root>" + lineSeparator + "\t<tag1 attr1=\"attrValue1\"/>" + lineSeparator + "\t<tag2 attr2=\"attrValue2\"/>" + lineSeparator + "</root>" + lineSeparator), (Object)stringWriter.toString());
    }

    @Test
    public void test_open_tag_write_attribute() throws Exception {
        StringWriter stringWriter = new StringWriter();
        XmlWriter writer = new XmlWriter((Writer)stringWriter);
        writer.beginTag("tag1");
        writer.writeAttribute("attr1", "attrValue1");
        writer.closeTag();
        writer.close();
        XmlWriterTest.assertEquals((Object)("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + lineSeparator + "<tag1 attr1=\"attrValue1\"/>" + lineSeparator), (Object)stringWriter.toString());
    }

    @Test
    public void test_writeAttribute_withSpecialCharacters() throws Exception {
        StringWriter stringWriter = new StringWriter();
        XmlWriter writer = new XmlWriter((Writer)stringWriter);
        writer.beginTag("tag");
        writer.writeAttribute("attr", "abc\n\u0410<>'&");
        writer.closeTag();
        writer.close();
        XmlWriterTest.assertEquals((Object)("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + lineSeparator + "<tag attr=\"abc&#10;\u0410&lt;&gt;&apos;&amp;\"/>" + lineSeparator), (Object)stringWriter.toString());
    }

    @Test
    public void test_open_tag_write_attribute_endTag() throws Exception {
        StringWriter stringWriter = new StringWriter();
        XmlWriter writer = new XmlWriter((Writer)stringWriter);
        writer.beginTag("tag1");
        writer.writeAttribute("attr1", "attrValue1");
        writer.endTag();
        writer.closeTag();
        writer.close();
        XmlWriterTest.assertEquals((Object)("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + lineSeparator + "<tag1 attr1=\"attrValue1\"></tag1>" + lineSeparator), (Object)stringWriter.toString());
    }

    @Test
    public void test_open_close_tag_with_value() throws Exception {
        StringWriter stringWriter = new StringWriter();
        XmlWriter writer = new XmlWriter((Writer)stringWriter);
        writer.write("tag1", "value1");
        writer.close();
        XmlWriterTest.assertEquals((Object)("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + lineSeparator + "<tag1>value1</tag1>" + lineSeparator), (Object)stringWriter.toString());
    }

    @Test
    public void test_write_nested_tags() throws Exception {
        StringWriter stringWriter = new StringWriter();
        XmlWriter writer = new XmlWriter((Writer)stringWriter);
        writer.openTag("tag1");
        writer.openTag("tag2");
        writer.openTag("tag3");
        writer.closeTag();
        writer.closeTag();
        writer.closeTag();
        writer.close();
        XmlWriterTest.assertEquals((Object)("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + lineSeparator + "<tag1>" + lineSeparator + "\t<tag2>" + lineSeparator + "\t\t<tag3></tag3>" + lineSeparator + "\t</tag2>" + lineSeparator + "</tag1>" + lineSeparator), (Object)stringWriter.toString());
    }

    @Test
    public void test_write_cdata() throws Exception {
        StringWriter stringWriter = new StringWriter();
        XmlWriter writer = new XmlWriter((Writer)stringWriter);
        writer.openTag("tag1");
        writer.openTag("tag2");
        DataOutputStream dataOutputStream = new DataOutputStream(writer.streamCDATA());
        dataOutputStream.writeBytes("cdata contents");
        dataOutputStream.close();
        writer.closeTag();
        writer.closeTag();
        writer.close();
        XmlWriterTest.assertEquals((Object)("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + lineSeparator + "<tag1>" + lineSeparator + "\t<tag2><![CDATA[" + lineSeparator + "cdata contents]]></tag2>" + lineSeparator + "</tag1>" + lineSeparator), (Object)stringWriter.toString());
    }
}

