/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.description;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.MorphingTargetDescription;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MorphingTargetDescriptionTest
extends SwingModelTest {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_loadFromDescriptions() throws Exception {
        MorphingTargetDescriptionTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton extends JComponent {", "  public MyButton() {", "  }", "}"));
        MorphingTargetDescriptionTest.setFileContentSrc("test/MyButton.wbp-component.xml", MorphingTargetDescriptionTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <morphTargets>", "    <morphTarget class='javax.swing.JButton'/>", "    <morphTarget class='javax.swing.JTextField' creationId='someId'/>", "  </morphTargets>", "</component>"));
        MorphingTargetDescriptionTest.waitForAutoBuild();
        ComponentDescription description = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, this.m_lastLoader.loadClass("test.MyButton"));
        List morphingTargets = description.getMorphingTargets();
        MorphingTargetDescriptionTest.assertEquals((int)2, (int)morphingTargets.size());
        MorphingTargetDescription morphingTarget = (MorphingTargetDescription)morphingTargets.get(0);
        MorphingTargetDescriptionTest.assertEquals((Object)"javax.swing.JButton", (Object)morphingTarget.getComponentClass().getName());
        MorphingTargetDescriptionTest.assertNull((Object)morphingTarget.getCreationId());
        morphingTarget = (MorphingTargetDescription)morphingTargets.get(1);
        MorphingTargetDescriptionTest.assertEquals((Object)"javax.swing.JTextField", (Object)morphingTarget.getComponentClass().getName());
        MorphingTargetDescriptionTest.assertEquals((Object)"someId", (Object)morphingTarget.getCreationId());
    }

    @Test
    public void test_noTargetClass() throws Exception {
        MorphingTargetDescriptionTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton extends JComponent {", "  public MyButton() {", "  }", "}"));
        MorphingTargetDescriptionTest.setFileContentSrc("test/MyButton.wbp-component.xml", MorphingTargetDescriptionTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <morphTargets>", "    <morphTarget class='no.such.Class'/>", "    <morphTarget class='javax.swing.JButton'/>", "  </morphTargets>", "</component>"));
        MorphingTargetDescriptionTest.waitForAutoBuild();
        ComponentDescription description = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, this.m_lastLoader.loadClass("test.MyButton"));
        List morphingTargets = description.getMorphingTargets();
        Assertions.assertThat((List)morphingTargets).hasSize(1);
        MorphingTargetDescription morphingTarget = (MorphingTargetDescription)morphingTargets.get(0);
        MorphingTargetDescriptionTest.assertEquals((Object)"javax.swing.JButton", (Object)morphingTarget.getComponentClass().getName());
        MorphingTargetDescriptionTest.assertNull((Object)morphingTarget.getCreationId());
    }

    @Test
    public void test_noInherit() throws Exception {
        MorphingTargetDescriptionTest.setFileContentSrc("test/MyBaseButton.java", this.getTestSource("public class MyBaseButton extends JComponent {", "  public MyBaseButton() {", "  }", "}"));
        MorphingTargetDescriptionTest.setFileContentSrc("test/MyBaseButton.wbp-component.xml", MorphingTargetDescriptionTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <morphTargets>", "    <morphTarget class='javax.swing.JButton'/>", "  </morphTargets>", "</component>"));
        MorphingTargetDescriptionTest.setFileContentSrc("test/MyButton1.java", this.getTestSource("public class MyButton1 extends MyBaseButton {", "  public MyButton1() {", "  }", "}"));
        MorphingTargetDescriptionTest.setFileContentSrc("test/MyButton1.wbp-component.xml", MorphingTargetDescriptionTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <morphTargets>", "    <morphTarget class='javax.swing.JPanel'/>", "  </morphTargets>", "</component>"));
        MorphingTargetDescriptionTest.setFileContentSrc("test/MyButton2.java", this.getTestSource("public class MyButton2 extends MyBaseButton {", "  public MyButton2() {", "  }", "}"));
        MorphingTargetDescriptionTest.setFileContentSrc("test/MyButton2.wbp-component.xml", MorphingTargetDescriptionTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <morphTargets>", "    <noInherit/>", "    <morphTarget class='javax.swing.JLabel'/>", "  </morphTargets>", "</component>"));
        MorphingTargetDescriptionTest.waitForAutoBuild();
        ComponentDescription description = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, this.m_lastLoader.loadClass("test.MyButton1"));
        List morphingTargets = description.getMorphingTargets();
        Assertions.assertThat((List)morphingTargets).hasSize(2);
        MorphingTargetDescription morphingTarget = (MorphingTargetDescription)morphingTargets.get(0);
        MorphingTargetDescriptionTest.assertEquals((Object)"javax.swing.JButton", (Object)morphingTarget.getComponentClass().getName());
        MorphingTargetDescriptionTest.assertNull((Object)morphingTarget.getCreationId());
        morphingTarget = (MorphingTargetDescription)morphingTargets.get(1);
        MorphingTargetDescriptionTest.assertEquals((Object)"javax.swing.JPanel", (Object)morphingTarget.getComponentClass().getName());
        MorphingTargetDescriptionTest.assertNull((Object)morphingTarget.getCreationId());
        description = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, this.m_lastLoader.loadClass("test.MyButton2"));
        morphingTargets = description.getMorphingTargets();
        Assertions.assertThat((List)morphingTargets).hasSize(1);
        morphingTarget = (MorphingTargetDescription)morphingTargets.get(0);
        MorphingTargetDescriptionTest.assertEquals((Object)"javax.swing.JLabel", (Object)morphingTarget.getComponentClass().getName());
        MorphingTargetDescriptionTest.assertNull((Object)morphingTarget.getCreationId());
    }
}

