/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.binding.editors.controls;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wb.internal.core.utils.binding.IDataEditor;
import org.eclipse.wb.internal.core.utils.binding.ValueUtils;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;

public final class CheckButtonEditor
implements IDataEditor {
    private final Button m_button;
    private final List<Control> m_enableControls = new ArrayList<Control>();

    public CheckButtonEditor(Button button) {
        this.m_button = button;
        this.m_button.addListener(13, event -> this.changeEnablement(this.m_button.getSelection()));
    }

    @Override
    public void setValue(Object value) {
        boolean selection = ValueUtils.objectToBoolean(value);
        this.m_button.setSelection(selection);
        this.changeEnablement(selection);
    }

    @Override
    public Object getValue() {
        return ValueUtils.booleanToObject(this.m_button.getSelection());
    }

    public void addEnableControl(Control control) {
        this.m_enableControls.add(control);
        UiUtils.changeControlEnable(control, this.m_button.getSelection());
    }

    private void changeEnablement(boolean enable) {
        for (Control control : this.m_enableControls) {
            UiUtils.changeControlEnable(control, enable);
        }
    }
}

